/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Objects;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;

public class Replacement<PS, SEG, S> {
    private final int start;
    private final int end;
    private final ReadOnlyStyledDocument<PS, SEG, S> document;

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final ReadOnlyStyledDocument<PS, SEG, S> getDocument() {
        return this.document;
    }

    public Replacement(int n2, int n3, ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument) {
        this.start = n2;
        this.end = n3;
        this.document = readOnlyStyledDocument;
    }

    public int getNetLength() {
        return this.document.length() - (this.end - this.start);
    }

    public boolean equals(Object object) {
        if (object instanceof Replacement) {
            Replacement replacement = (Replacement)object;
            return Objects.equals(this.start, replacement.start) && Objects.equals(this.end, replacement.end) && Objects.equals(this.document, replacement.document);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.document);
    }

    public String toString() {
        return String.format("Replacement(start=%s end=%s document=%s)", this.start, this.end, this.document);
    }
}

