/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;

public final class ReadOnlyStyledDocumentBuilder<PS, SEG, S> {
    private final SegmentOps<SEG, S> segmentOps;
    private final PS defaultParagraphStyle;
    private final List<Paragraph<PS, SEG, S>> paragraphList;
    private boolean alreadyCreated = false;

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> constructDocument(SegmentOps<SEG, S> segmentOps, PS PS, Consumer<ReadOnlyStyledDocumentBuilder<PS, SEG, S>> consumer) {
        ReadOnlyStyledDocumentBuilder<PS, SEG, S> readOnlyStyledDocumentBuilder = new ReadOnlyStyledDocumentBuilder<PS, SEG, S>(segmentOps, PS);
        consumer.accept(readOnlyStyledDocumentBuilder);
        return readOnlyStyledDocumentBuilder.build();
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> constructDocument(SegmentOps<SEG, S> segmentOps, PS PS, int n2, Consumer<ReadOnlyStyledDocumentBuilder<PS, SEG, S>> consumer) {
        ReadOnlyStyledDocumentBuilder<PS, SEG, S> readOnlyStyledDocumentBuilder = new ReadOnlyStyledDocumentBuilder<PS, SEG, S>(segmentOps, PS, n2);
        consumer.accept(readOnlyStyledDocumentBuilder);
        return readOnlyStyledDocumentBuilder.build();
    }

    public ReadOnlyStyledDocumentBuilder(SegmentOps<SEG, S> segmentOps, PS PS) {
        this(segmentOps, PS, new ArrayList<Paragraph<PS, SEG, S>>());
    }

    public ReadOnlyStyledDocumentBuilder(SegmentOps<SEG, S> segmentOps, PS PS, int n2) {
        this(segmentOps, PS, new ArrayList<Paragraph<PS, SEG, S>>(n2));
    }

    private ReadOnlyStyledDocumentBuilder(SegmentOps<SEG, S> segmentOps, PS PS, List<Paragraph<PS, SEG, S>> list) {
        this.segmentOps = segmentOps;
        this.defaultParagraphStyle = PS;
        this.paragraphList = list;
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<StyledSegment<SEG, S>> list) {
        return this.addParagraph((SEG)list, (S)null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<StyledSegment<SEG, S>> list, PS PS) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(PS), this.segmentOps, list));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG SEG, S s2) {
        return this.addParagraph(SEG, s2, null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG SEG, S s2, PS PS) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(PS), this.segmentOps, SEG, s2));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG SEG, StyleSpans<S> styleSpans) {
        return this.addParagraph(SEG, styleSpans, (PS)null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(SEG SEG, StyleSpans<S> styleSpans, PS PS) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(PS), this.segmentOps, SEG, styleSpans));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<SEG> list, StyleSpans<S> styleSpans) {
        return this.addParagraph(list, styleSpans, (PS)null);
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraph(List<SEG> list, StyleSpans<S> styleSpans, PS PS) {
        return this.addPar(new Paragraph<PS, SEG, S>(this.argumentOrDefault(PS), this.segmentOps, list, styleSpans));
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraphs(List<List<SEG>> list2, StyleSpans<S> styleSpans) {
        return this.addParagraphList(list2, styleSpans, list -> null, Function.identity());
    }

    public ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraphs0(List<Tuple2<PS, List<SEG>>> list, StyleSpans<S> styleSpans) {
        return this.addParagraphList(list, styleSpans, Tuple2::get1, Tuple2::get2);
    }

    public ReadOnlyStyledDocument<PS, SEG, S> build() {
        this.ensureNotYetCreated();
        if (this.paragraphList.isEmpty()) {
            throw new IllegalStateException("Cannot build a ReadOnlyStyledDocument with an empty list of paragraphs!");
        }
        this.alreadyCreated = true;
        return new ReadOnlyStyledDocument<PS, SEG, S>(this.paragraphList);
    }

    private <T> ReadOnlyStyledDocumentBuilder<PS, SEG, S> addParagraphList(List<T> list2, StyleSpans<S> styleSpans, Function<T, PS> function, Function<T, List<SEG>> function2) {
        int n4 = list2.stream().map(function2).flatMap(list -> list.stream().map(this.segmentOps::length)).reduce(0, (n2, n3) -> n2 + n3);
        if (n4 != styleSpans.length()) {
            throw new IllegalArgumentException(String.format("Document length does not equal style spans length! docLength=%s styleSpans' length=%s", n4, styleSpans.length()));
        }
        int n5 = 0;
        for (T t2 : list2) {
            PS PS = this.argumentOrDefault(function.apply(t2));
            List<SEG> list3 = function2.apply(t2);
            int n6 = list3.stream().mapToInt(this.segmentOps::length).sum();
            int n7 = n5 + n6;
            StyleSpans<S> styleSpans2 = styleSpans.subView(n5, n7);
            this.addPar(new Paragraph<PS, SEG, S>(PS, this.segmentOps, list3, styleSpans2));
            n5 = n7;
        }
        return this;
    }

    private PS argumentOrDefault(PS PS) {
        return PS != null ? PS : this.defaultParagraphStyle;
    }

    private void ensureNotYetCreated() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("This builder has already been used to create a list of Paragraphs. One builder can only be used to build a single list. To create a new one, create a new builder");
        }
    }

    private ReadOnlyStyledDocumentBuilder<PS, SEG, S> addPar(Paragraph<PS, SEG, S> paragraph) {
        this.ensureNotYetCreated();
        this.paragraphList.add(paragraph);
        return this;
    }
}

