/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.collection.MaterializedListModification;
import org.reactfx.util.BiIndex;
import org.reactfx.util.Either;
import org.reactfx.util.FingerTree;
import org.reactfx.util.Lists;
import org.reactfx.util.ToSemigroup;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuples;

public final class ReadOnlyStyledDocument<PS, SEG, S>
implements StyledDocument<PS, SEG, S> {
    private static final Pattern LINE_TERMINATOR = Pattern.compile("\r\n|\r|\n");
    private static final BiFunction<Summary, Integer, Either<Integer, Integer>> NAVIGATE = (summary, n2) -> n2 <= summary.length() ? Either.left(n2) : Either.right(n2 - (summary.length() + 1));
    private final FingerTree.NonEmptyFingerTree<Paragraph<PS, SEG, S>, Summary> tree;
    private String text = null;
    private List<Paragraph<PS, SEG, S>> paragraphs = null;

    private static <PS, SEG, S> ToSemigroup<Paragraph<PS, SEG, S>, Summary> summaryProvider() {
        return new ToSemigroup<Paragraph<PS, SEG, S>, Summary>(){

            @Override
            public Summary apply(Paragraph<PS, SEG, S> paragraph) {
                return new Summary(1, paragraph.length());
            }

            @Override
            public Summary reduce(Summary summary, Summary summary2) {
                return new Summary(summary.paragraphCount + summary2.paragraphCount, summary.charCount + summary2.charCount);
            }
        };
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> fromString(String string, PS PS, S s2, TextOps<SEG, S> textOps) {
        String string2;
        Matcher matcher = LINE_TERMINATOR.matcher(string);
        int n2 = 1;
        while (matcher.find()) {
            ++n2;
        }
        ArrayList<Paragraph<PS, SEG, S>> arrayList = new ArrayList<Paragraph<PS, SEG, S>>(n2);
        int n3 = 0;
        matcher.reset();
        while (matcher.find()) {
            string2 = string.substring(n3, matcher.start());
            arrayList.add(new Paragraph<PS, SEG, S>(PS, textOps, textOps.create(string2), s2));
            n3 = matcher.end();
        }
        string2 = string.substring(n3);
        arrayList.add(new Paragraph<PS, SEG, S>(PS, textOps, textOps.create(string2), s2));
        return new ReadOnlyStyledDocument<PS, SEG, S>(arrayList);
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> fromSegment(SEG SEG, PS PS, S s2, SegmentOps<SEG, S> segmentOps) {
        Paragraph<PS, SEG, S> paragraph = new Paragraph<PS, SEG, S>(PS, segmentOps, SEG, s2);
        List<Paragraph<PS, SEG, S>> list = Collections.singletonList(paragraph);
        return new ReadOnlyStyledDocument<PS, SEG, S>(list);
    }

    public static <PS, SEG, S> ReadOnlyStyledDocument<PS, SEG, S> from(StyledDocument<PS, SEG, S> styledDocument) {
        if (styledDocument instanceof ReadOnlyStyledDocument) {
            return (ReadOnlyStyledDocument)styledDocument;
        }
        return new ReadOnlyStyledDocument<PS, SEG, S>(styledDocument.getParagraphs());
    }

    public static <PS, SEG, S> Codec<StyledDocument<PS, SEG, S>> codec(final Codec<PS> codec, final Codec<StyledSegment<SEG, S>> codec2, final SegmentOps<SEG, S> segmentOps) {
        return new Codec<StyledDocument<PS, SEG, S>>(){
            private final Codec<List<Paragraph<PS, SEG, S>>> codec;
            {
                this.codec = Codec.listCodec(ReadOnlyStyledDocument.paragraphCodec(codec, codec2, segmentOps));
            }

            @Override
            public String getName() {
                return "application/richtextfx-styled-document<" + codec.getName() + ";" + codec2.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, StyledDocument<PS, SEG, S> styledDocument) throws IOException {
                this.codec.encode(dataOutputStream, styledDocument.getParagraphs());
            }

            @Override
            public StyledDocument<PS, SEG, S> decode(DataInputStream dataInputStream) throws IOException {
                return new ReadOnlyStyledDocument(this.codec.decode(dataInputStream));
            }
        };
    }

    private static <PS, SEG, S> Codec<Paragraph<PS, SEG, S>> paragraphCodec(final Codec<PS> codec, final Codec<StyledSegment<SEG, S>> codec2, final SegmentOps<SEG, S> segmentOps) {
        return new Codec<Paragraph<PS, SEG, S>>(){
            private final Codec<List<StyledSegment<SEG, S>>> segmentsCodec;
            {
                this.segmentsCodec = Codec.listCodec(codec2);
            }

            @Override
            public String getName() {
                return "paragraph<" + codec.getName() + ";" + codec2.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, Paragraph<PS, SEG, S> paragraph) throws IOException {
                codec.encode(dataOutputStream, paragraph.getParagraphStyle());
                this.segmentsCodec.encode(dataOutputStream, paragraph.getStyledSegments());
            }

            @Override
            public Paragraph<PS, SEG, S> decode(DataInputStream dataInputStream) throws IOException {
                Object t2 = codec.decode(dataInputStream);
                List list = this.segmentsCodec.decode(dataInputStream);
                return new Paragraph(t2, segmentOps, list);
            }
        };
    }

    private ReadOnlyStyledDocument(FingerTree.NonEmptyFingerTree<Paragraph<PS, SEG, S>, Summary> nonEmptyFingerTree) {
        this.tree = nonEmptyFingerTree;
    }

    ReadOnlyStyledDocument(List<Paragraph<PS, SEG, S>> list) {
        this.tree = FingerTree.mkTree(list, ReadOnlyStyledDocument.summaryProvider()).caseEmpty().unify(fingerTree -> {
            throw new AssertionError((Object)"Unreachable code");
        }, nonEmptyFingerTree -> nonEmptyFingerTree);
    }

    @Override
    public int length() {
        return this.tree.getSummary().length();
    }

    @Override
    public String getText() {
        if (this.text == null) {
            CharSequence[] charSequenceArray = (String[])this.getParagraphs().stream().map(Paragraph::getText).toArray(String[]::new);
            this.text = String.join((CharSequence)"\n", charSequenceArray);
        }
        return this.text;
    }

    public int getParagraphCount() {
        return this.tree.getLeafCount();
    }

    @Override
    public Paragraph<PS, SEG, S> getParagraph(int n2) {
        return (Paragraph)this.tree.getLeaf(n2);
    }

    @Override
    public List<Paragraph<PS, SEG, S>> getParagraphs() {
        if (this.paragraphs == null) {
            this.paragraphs = this.tree.asList();
        }
        return this.paragraphs;
    }

    @Override
    public TwoDimensional.Position position(int n2, int n3) {
        return new Pos(n2, n3);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int n2, TwoDimensional.Bias bias) {
        return this.position(0, 0).offsetBy(n2, bias);
    }

    public Tuple2<ReadOnlyStyledDocument<PS, SEG, S>, ReadOnlyStyledDocument<PS, SEG, S>> split(int n2) {
        return this.tree.locate(NAVIGATE, n2).map(this::split);
    }

    public Tuple2<ReadOnlyStyledDocument<PS, SEG, S>, ReadOnlyStyledDocument<PS, SEG, S>> split(int n2, int n3) {
        return this.tree.splitAt(n2).map((fingerTree, paragraph, fingerTree2) -> {
            Paragraph paragraph2 = paragraph.trim(n3);
            Paragraph paragraph3 = paragraph.subSequence(n3);
            ReadOnlyStyledDocument readOnlyStyledDocument = new ReadOnlyStyledDocument(fingerTree.append(paragraph2));
            ReadOnlyStyledDocument readOnlyStyledDocument2 = new ReadOnlyStyledDocument(fingerTree2.prepend(paragraph3));
            return Tuples.t(readOnlyStyledDocument, readOnlyStyledDocument2);
        });
    }

    @Override
    public ReadOnlyStyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> styledDocument) {
        return this.concat0(styledDocument, Paragraph::concat);
    }

    private ReadOnlyStyledDocument<PS, SEG, S> concatR(StyledDocument<PS, SEG, S> styledDocument) {
        return this.concat0(styledDocument, Paragraph::concatR);
    }

    private ReadOnlyStyledDocument<PS, SEG, S> concat0(StyledDocument<PS, SEG, S> styledDocument, BinaryOperator<Paragraph<PS, SEG, S>> binaryOperator) {
        int n2 = this.tree.getLeafCount() - 1;
        Paragraph paragraph = (Paragraph)this.tree.getLeaf(n2);
        Paragraph<PS, SEG, S> paragraph2 = styledDocument.getParagraphs().get(0);
        Paragraph paragraph3 = (Paragraph)binaryOperator.apply(paragraph, paragraph2);
        FingerTree.NonEmptyFingerTree nonEmptyFingerTree = this.tree.updateLeaf(n2, paragraph3);
        FingerTree<Paragraph<PS, SEG, S>, Summary> fingerTree = styledDocument instanceof ReadOnlyStyledDocument ? (FingerTree<Paragraph<PS, SEG, S>, Summary>)((ReadOnlyStyledDocument)styledDocument).tree.split((int)1)._2 : FingerTree.mkTree(styledDocument.getParagraphs().subList(1, styledDocument.getParagraphs().size()), ReadOnlyStyledDocument.summaryProvider());
        return new ReadOnlyStyledDocument<PS, SEG, S>(nonEmptyFingerTree.join((FingerTree)fingerTree));
    }

    @Override
    public StyledDocument<PS, SEG, S> subSequence(int n2, int n3) {
        return (StyledDocument)((ReadOnlyStyledDocument)this.split((int)n3)._1).split((int)n2)._2;
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, List<RichTextChange<PS, SEG, S>>, List<MaterializedListModification<Paragraph<PS, SEG, S>>>> replaceMulti(List<Replacement<PS, SEG, S>> list) {
        ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument = this;
        ArrayList<RichTextChange<PS, SEG, S>> arrayList = new ArrayList<RichTextChange<PS, SEG, S>>(list.size());
        ArrayList<MaterializedListModification<Paragraph<PS, SEG, S>>> arrayList2 = new ArrayList<MaterializedListModification<Paragraph<PS, SEG, S>>>(list.size());
        for (Replacement<PS, SEG, S> replacement : list) {
            Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> tuple3 = readOnlyStyledDocument.replace(replacement);
            readOnlyStyledDocument = tuple3.get1();
            arrayList.add(tuple3.get2());
            arrayList2.add(tuple3.get3());
        }
        return Tuples.t(readOnlyStyledDocument, arrayList, arrayList2);
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(Replacement<PS, SEG, S> replacement) {
        return this.replace(replacement.getStart(), replacement.getEnd(), replacement.getDocument());
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(int n2, int n3, ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument) {
        return this.replace(n2, n3, readOnlyStyledDocument2 -> readOnlyStyledDocument);
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(int n2, int n3, UnaryOperator<ReadOnlyStyledDocument<PS, SEG, S>> unaryOperator) {
        this.ensureValidRange(n2, n3);
        BiIndex biIndex = this.tree.locate(NAVIGATE, n2);
        BiIndex biIndex2 = this.tree.locate(NAVIGATE, n3);
        return this.replace(biIndex, biIndex2, unaryOperator);
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(int n2, int n3, int n4, UnaryOperator<ReadOnlyStyledDocument<PS, SEG, S>> unaryOperator) {
        this.ensureValidParagraphRange(n2, n3, n4);
        return this.replace(new BiIndex(n2, n3), new BiIndex(n2, n4), unaryOperator);
    }

    private Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replace(BiIndex biIndex, BiIndex biIndex2, UnaryOperator<ReadOnlyStyledDocument<PS, SEG, S>> unaryOperator) {
        int n2 = this.tree.getSummaryBetween(0, biIndex.major).map(summary -> summary.length() + 1).orElse(0) + biIndex.minor;
        List list = this.getParagraphs().subList(biIndex.major, biIndex2.major + 1);
        return biIndex2.map(this::split).map((readOnlyStyledDocument, readOnlyStyledDocument4) -> biIndex.map(readOnlyStyledDocument::split).map((readOnlyStyledDocument2, readOnlyStyledDocument3) -> {
            ReadOnlyStyledDocument readOnlyStyledDocument4 = (ReadOnlyStyledDocument)unaryOperator.apply((ReadOnlyStyledDocument)readOnlyStyledDocument3);
            StyledDocument styledDocument = readOnlyStyledDocument2.concatR(readOnlyStyledDocument4).concat((StyledDocument)readOnlyStyledDocument4);
            RichTextChange richTextChange = new RichTextChange(n2, readOnlyStyledDocument3, readOnlyStyledDocument4);
            List list2 = ((ReadOnlyStyledDocument)styledDocument).getParagraphs().subList(biIndex.major, biIndex.major + readOnlyStyledDocument4.getParagraphCount());
            MaterializedListModification materializedListModification = MaterializedListModification.create(biIndex.major, list, list2);
            return Tuples.t(styledDocument, richTextChange, materializedListModification);
        }));
    }

    public Tuple3<ReadOnlyStyledDocument<PS, SEG, S>, RichTextChange<PS, SEG, S>, MaterializedListModification<Paragraph<PS, SEG, S>>> replaceParagraph(int n2, UnaryOperator<Paragraph<PS, SEG, S>> unaryOperator) {
        this.ensureValidParagraphIndex(n2);
        return this.replace(new BiIndex(n2, 0), new BiIndex(n2, ((Paragraph)this.tree.getLeaf(n2)).length()), readOnlyStyledDocument -> readOnlyStyledDocument.mapParagraphs(unaryOperator));
    }

    public ReadOnlyStyledDocument<PS, SEG, S> mapParagraphs(UnaryOperator<Paragraph<PS, SEG, S>> unaryOperator) {
        int n2 = this.tree.getLeafCount();
        ArrayList<Paragraph<PS, SEG, S>> arrayList = new ArrayList<Paragraph<PS, SEG, S>>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add((Paragraph<PS, SEG, S>)unaryOperator.apply((Paragraph<PS, SEG, S>)this.tree.getLeaf(i2)));
        }
        return new ReadOnlyStyledDocument<PS, SEG, S>(arrayList);
    }

    public String toString() {
        return this.getParagraphs().stream().map(Paragraph::toString).reduce((string, string2) -> string + "\n" + string2).orElse("");
    }

    public final boolean equals(Object object) {
        if (object instanceof StyledDocument) {
            StyledDocument styledDocument = (StyledDocument)object;
            return Objects.equals(this.getParagraphs(), styledDocument.getParagraphs());
        }
        return false;
    }

    public final int hashCode() {
        return this.getParagraphs().hashCode();
    }

    private void ensureValidParagraphIndex(int n2) {
        Lists.checkIndex(n2, this.getParagraphCount());
    }

    private void ensureValidRange(int n2, int n3) {
        Lists.checkRange(n2, n3, this.length());
    }

    private void ensureValidParagraphRange(int n2, int n3, int n4) {
        this.ensureValidParagraphIndex(n2);
        Lists.checkRange(n3, n4, this.fullLength(n2));
    }

    private int fullLength(int n2) {
        int n3 = this.getParagraphCount();
        return this.getParagraph(n2).length() + (n2 == n3 - 1 ? 0 : 1);
    }

    private class Pos
    implements TwoDimensional.Position {
        private final int major;
        private final int minor;

        private Pos(int n2, int n3) {
            this.major = n2;
            this.minor = n3;
        }

        public String toString() {
            return "(" + this.major + ", " + this.minor + ")";
        }

        @Override
        public boolean sameAs(TwoDimensional.Position position) {
            return this.getTargetObject() == position.getTargetObject() && this.major == position.getMajor() && this.minor == position.getMinor();
        }

        @Override
        public TwoDimensional getTargetObject() {
            return ReadOnlyStyledDocument.this;
        }

        @Override
        public int getMajor() {
            return this.major;
        }

        @Override
        public int getMinor() {
            return this.minor;
        }

        @Override
        public TwoDimensional.Position clamp() {
            if (this.major == ReadOnlyStyledDocument.this.tree.getLeafCount() - 1) {
                int n2 = ((Paragraph)ReadOnlyStyledDocument.this.tree.getLeaf(this.major)).length();
                if (this.minor < n2) {
                    return this;
                }
                return new Pos(this.major, n2 - 1);
            }
            return this;
        }

        @Override
        public TwoDimensional.Position offsetBy(int n4, TwoDimensional.Bias bias) {
            return ReadOnlyStyledDocument.this.tree.locateProgressively(summary -> ((Summary)summary).charCount + ((Summary)summary).paragraphCount, this.toOffset() + n4).map((n2, n3) -> new Pos((int)n2, (int)n3));
        }

        @Override
        public int toOffset() {
            if (this.major == 0) {
                return this.minor;
            }
            return ((Summary)ReadOnlyStyledDocument.this.tree.getSummaryBetween(0, this.major).get()).length() + 1 + this.minor;
        }
    }

    private static class Summary {
        private final int paragraphCount;
        private final int charCount;

        public Summary(int n2, int n3) {
            assert (n2 > 0);
            assert (n3 >= 0);
            this.paragraphCount = n2;
            this.charCount = n3;
        }

        public int length() {
            return this.charCount + this.paragraphCount - 1;
        }
    }
}

