/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBase;

class PrependedSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final StyleSpan<S> prepended;
    private int length = -1;
    private int spanCount = -1;

    public PrependedSpans(StyleSpans<S> styleSpans, StyleSpan<S> styleSpan) {
        this.original = styleSpans;
        this.prepended = styleSpan;
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.prepended.getLength() + this.original.length();
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        if (this.spanCount == -1) {
            this.spanCount = 1 + this.original.getSpanCount();
        }
        return this.spanCount;
    }

    @Override
    public StyleSpan<S> getStyleSpan(int n2) {
        if (n2 == 0) {
            return this.prepended;
        }
        return this.original.getStyleSpan(n2 - 1);
    }
}

