/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

public final class Paragraph<PS, SEG, S> {
    private final List<SEG> segments;
    private final StyleSpans<S> styles;
    private final TwoLevelNavigator navigator;
    private final PS paragraphStyle;
    private final SegmentOps<SEG, S> segmentOps;
    private List<StyledSegment<SEG, S>> styledSegments = null;
    private int length = -1;
    private String text = null;

    private static <SEG, S> Tuple2<List<SEG>, StyleSpans<S>> decompose(List<StyledSegment<SEG, S>> list, SegmentOps<SEG, S> segmentOps) {
        ArrayList<SEG> arrayList = new ArrayList<SEG>();
        StyleSpansBuilder<S> styleSpansBuilder = new StyleSpansBuilder<S>();
        for (StyledSegment<SEG, S> styledSegment : list) {
            if (arrayList.isEmpty()) {
                arrayList.add(styledSegment.getSegment());
            } else {
                int n2 = arrayList.size() - 1;
                Object e2 = arrayList.get(n2);
                Optional<SEG> optional = segmentOps.joinSeg(e2, styledSegment.getSegment());
                if (optional.isPresent()) {
                    arrayList.set(n2, optional.get());
                } else {
                    arrayList.add(styledSegment.getSegment());
                }
            }
            styleSpansBuilder.add(styledSegment.getStyle(), segmentOps.length(styledSegment.getSegment()));
        }
        return Tuples.t(arrayList, styleSpansBuilder.create());
    }

    @SafeVarargs
    private static <T> List<T> list(T t2, T ... TArray) {
        if (TArray.length == 0) {
            return Collections.singletonList(t2);
        }
        ArrayList<T> arrayList = new ArrayList<T>(1 + TArray.length);
        arrayList.add(t2);
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public Paragraph(PS PS, SegmentOps<SEG, S> segmentOps, List<StyledSegment<SEG, S>> list) {
        this(PS, segmentOps, Paragraph.decompose(list, segmentOps));
    }

    private Paragraph(PS PS, SegmentOps<SEG, S> segmentOps, Tuple2<List<SEG>, StyleSpans<S>> tuple2) {
        this(PS, segmentOps, (List)tuple2._1, (StyleSpans)tuple2._2);
    }

    public Paragraph(PS PS, SegmentOps<SEG, S> segmentOps, SEG SEG, S s2) {
        this(PS, segmentOps, SEG, StyleSpans.singleton(s2, segmentOps.length(SEG)));
    }

    public Paragraph(PS PS, SegmentOps<SEG, S> segmentOps, SEG SEG, StyleSpans<S> styleSpans) {
        this(PS, segmentOps, Collections.singletonList(SEG), styleSpans);
    }

    public Paragraph(PS PS, SegmentOps<SEG, S> segmentOps, List<SEG> list, StyleSpans<S> styleSpans) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct a Paragraph with an empty list of segments");
        }
        if (styleSpans.getSpanCount() == 0) {
            throw new IllegalArgumentException("Cannot construct a Paragraph with StyleSpans object that contains no StyleSpan objects");
        }
        this.segmentOps = segmentOps;
        this.segments = list;
        this.styles = styleSpans;
        this.paragraphStyle = PS;
        this.navigator = new TwoLevelNavigator(list::size, n2 -> segmentOps.length(list.get(n2)));
    }

    public List<StyledSegment<SEG, S>> getStyledSegments() {
        if (this.styledSegments == null) {
            this.styledSegments = this.segments.size() == 1 && this.styles.getSpanCount() == 1 ? Collections.singletonList(new StyledSegment<SEG, S>(this.segments.get(0), this.styles.getStyleSpan(0).getStyle())) : this.createStyledSegments();
        }
        return this.styledSegments;
    }

    public List<SEG> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public PS getParagraphStyle() {
        return this.paragraphStyle;
    }

    public int length() {
        if (this.length == -1) {
            this.length = this.segments.stream().mapToInt(this.segmentOps::length).sum();
        }
        return this.length;
    }

    public char charAt(int n2) {
        TwoDimensional.Position position = this.navigator.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        return this.segmentOps.charAt(this.segments.get(position.getMajor()), position.getMinor());
    }

    public String substring(int n2, int n3) {
        return this.getText().substring(n2, Math.min(n3, this.length()));
    }

    public String substring(int n2) {
        return this.getText().substring(n2);
    }

    public Paragraph<PS, SEG, S> concat(Paragraph<PS, SEG, S> paragraph) {
        ArrayList<SEG> arrayList;
        Object object;
        SEG SEG;
        if (paragraph.length() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return paragraph;
        }
        SEG SEG2 = this.segments.get(this.segments.size() - 1);
        Optional<SEG> optional = this.segmentOps.joinSeg(SEG2, SEG = paragraph.segments.get(0));
        if (optional.isPresent()) {
            object = optional.get();
            arrayList = new ArrayList(this.segments.size() + paragraph.segments.size() - 1);
            arrayList.addAll(this.segments.subList(0, this.segments.size() - 1));
            arrayList.add(object);
            arrayList.addAll(paragraph.segments.subList(1, paragraph.segments.size()));
        } else {
            arrayList = new ArrayList<SEG>(this.segments.size() + paragraph.segments.size());
            arrayList.addAll(this.segments);
            arrayList.addAll(paragraph.segments);
        }
        StyleSpan<S> styleSpan = this.styles.getStyleSpan(this.styles.getSpanCount() - 1);
        StyleSpan<S> styleSpan2 = paragraph.styles.getStyleSpan(0);
        Optional<S> optional2 = this.segmentOps.joinStyle(styleSpan.getStyle(), styleSpan2.getStyle());
        if (optional2.isPresent()) {
            int n2 = this.styles.position(this.styles.getSpanCount() - 1, 0).toOffset();
            StyleSpans<S> styleSpans = this.styles.subView(0, n2);
            int n3 = paragraph.styles.position(1, 0).toOffset();
            StyleSpans<S> styleSpans2 = paragraph.styles.subView(n3, paragraph.styles.length());
            object = styleSpans.append(optional2.get(), styleSpan.getLength() + styleSpan2.getLength()).concat(styleSpans2);
        } else {
            object = this.styles.concat(paragraph.styles);
        }
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, arrayList, object);
    }

    Paragraph<PS, SEG, S> concatR(Paragraph<PS, SEG, S> paragraph) {
        return this.length() == 0 && paragraph.length() == 0 ? paragraph : this.concat(paragraph);
    }

    public Paragraph<PS, SEG, S> subSequence(int n2, int n3) {
        return this.trim(n3).subSequence(n2);
    }

    public Paragraph<PS, SEG, S> trim(int n2) {
        if (n2 >= this.length()) {
            return this;
        }
        TwoDimensional.Position position = this.navigator.offsetToPosition(n2, TwoDimensional.Bias.Backward);
        int n3 = position.getMajor();
        ArrayList<SEG> arrayList = new ArrayList<SEG>(n3 + 1);
        arrayList.addAll(this.segments.subList(0, n3));
        arrayList.add(this.segmentOps.subSequence(this.segments.get(n3), 0, position.getMinor()));
        if (arrayList.isEmpty()) {
            arrayList.add(this.segmentOps.createEmptySeg());
        }
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, arrayList, this.styles.subView(0, n2));
    }

    public Paragraph<PS, SEG, S> subSequence(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("start must not be negative (was: " + n2 + ")");
        }
        if (n2 == 0) {
            return this;
        }
        if (n2 == this.length()) {
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segmentOps.createEmptySeg(), this.styles.subView(n2, n2));
        }
        if (n2 < this.length()) {
            TwoDimensional.Position position = this.navigator.offsetToPosition(n2, TwoDimensional.Bias.Forward);
            int n3 = position.getMajor();
            ArrayList<SEG> arrayList = new ArrayList<SEG>(this.segments.size() - n3);
            arrayList.add(this.segmentOps.subSequence(this.segments.get(n3), position.getMinor()));
            arrayList.addAll(this.segments.subList(n3 + 1, this.segments.size()));
            if (arrayList.isEmpty()) {
                arrayList.add(this.segmentOps.createEmptySeg());
            }
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, arrayList, this.styles.subView(n2, this.styles.length()));
        }
        throw new IndexOutOfBoundsException(n2 + " not in [0, " + this.length() + "]");
    }

    public Paragraph<PS, SEG, S> delete(int n2, int n3) {
        return this.trim(n2).concat(this.subSequence(n3));
    }

    public Paragraph<PS, SEG, S> restyle(S s2) {
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, StyleSpans.singleton(s2, this.length()));
    }

    public Paragraph<PS, SEG, S> restyle(int n2, int n3, S s2) {
        if (n2 >= this.length()) {
            return this;
        }
        StyleSpans<S> styleSpans = this.styles.subView(0, n2);
        StyleSpans<S> styleSpans2 = this.styles.subView(n3, this.length());
        StyleSpans<S> styleSpans3 = styleSpans.append(s2, n3 - n2).concat(styleSpans2);
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, styleSpans3);
    }

    public Paragraph<PS, SEG, S> restyle(int n2, StyleSpans<? extends S> styleSpans) {
        int n3 = styleSpans.length();
        if (styleSpans.equals(this.getStyleSpans(n2, n2 + n3)) || styleSpans.getSpanCount() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, styleSpans);
        }
        StyleSpans<S> styleSpans2 = this.styles.subView(0, n2);
        StyleSpans<S> styleSpans3 = this.styles.subView(n2 + n3, this.length());
        StyleSpans<S> styleSpans4 = styleSpans;
        StyleSpans<? extends S> styleSpans5 = styleSpans2.concat(styleSpans4).concat(styleSpans3);
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, styleSpans5);
    }

    public Paragraph<PS, SEG, S> setParagraphStyle(PS PS) {
        return new Paragraph<PS, SEG, S>(PS, this.segmentOps, this.segments, this.styles);
    }

    public S getStyleOfChar(int n2) {
        if (n2 < 0) {
            return this.styles.getStyleSpan(0).getStyle();
        }
        TwoDimensional.Position position = this.styles.offsetToPosition(n2, TwoDimensional.Bias.Forward);
        return this.styles.getStyleSpan(position.getMajor()).getStyle();
    }

    public S getStyleAtPosition(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Paragraph position cannot be negative (" + n2 + ")");
        }
        TwoDimensional.Position position = this.styles.offsetToPosition(n2, TwoDimensional.Bias.Backward);
        return this.styles.getStyleSpan(position.getMajor()).getStyle();
    }

    public IndexRange getStyleRangeAtPosition(int n2) {
        TwoDimensional.Position position = this.styles.offsetToPosition(n2, TwoDimensional.Bias.Backward);
        int n3 = n2 - position.getMinor();
        int n4 = n3 + this.styles.getStyleSpan(position.getMajor()).getLength();
        return new IndexRange(n3, n4);
    }

    public StyleSpans<S> getStyleSpans() {
        return this.styles;
    }

    public StyleSpans<S> getStyleSpans(int n2, int n3) {
        return this.styles.subView(n2, n3);
    }

    public String getText() {
        if (this.text == null) {
            StringBuilder stringBuilder = new StringBuilder(this.length());
            for (SEG SEG : this.segments) {
                stringBuilder.append(this.segmentOps.getText(SEG));
            }
            this.text = stringBuilder.toString();
        }
        return this.text;
    }

    public String toString() {
        return "Par[" + this.paragraphStyle + "; " + this.getStyledSegments().stream().map(Object::toString).reduce((string, string2) -> string + ", " + string2).orElse("") + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Paragraph) {
            Paragraph paragraph = (Paragraph)object;
            return Objects.equals(this.paragraphStyle, paragraph.paragraphStyle) && Objects.equals(this.segments, paragraph.segments) && Objects.equals(this.styles, paragraph.styles);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.paragraphStyle, this.segments, this.styles);
    }

    private List<StyledSegment<SEG, S>> createStyledSegments() {
        LinkedList<StyledSegment<SEG, S>> linkedList = new LinkedList<StyledSegment<SEG, S>>();
        Iterator<SEG> iterator = this.segments.iterator();
        Iterator<StyleSpan<S>> iterator2 = this.styles.iterator();
        SEG SEG = iterator.next();
        StyleSpan<S> styleSpan = iterator2.next();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (!bl) {
            SEG SEG2;
            int n4;
            int n5 = this.segmentOps.length(SEG) - n2;
            if (n5 < (n4 = styleSpan.getLength() - n3)) {
                SEG2 = this.segmentOps.subSequence(SEG, n2);
                linkedList.add(new StyledSegment<SEG, S>(SEG2, styleSpan.getStyle()));
                SEG = iterator.next();
                n2 = 0;
                n3 += n5;
                continue;
            }
            if (n4 < n5) {
                SEG2 = this.segmentOps.subSequence(SEG, n2, n2 + n4);
                linkedList.add(new StyledSegment<SEG, S>(SEG2, styleSpan.getStyle()));
                styleSpan = iterator2.next();
                n3 = 0;
                n2 += n4;
                continue;
            }
            SEG2 = this.segmentOps.subSequence(SEG, n2, n2 + n4);
            linkedList.add(new StyledSegment<SEG, S>(SEG2, styleSpan.getStyle()));
            if (iterator.hasNext() && iterator2.hasNext()) {
                SEG = iterator.next();
                n2 = 0;
                styleSpan = iterator2.next();
                n3 = 0;
                continue;
            }
            bl = true;
        }
        return linkedList;
    }
}

