/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventSource;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.ListChangeAccumulator;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.MaterializedListModification;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.SuspendableList;
import org.reactfx.collection.UnmodifiableByDefaultLiveList;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;

class GenericEditableStyledDocumentBase<PS, SEG, S>
implements EditableStyledDocument<PS, SEG, S> {
    private ReadOnlyStyledDocument<PS, SEG, S> doc;
    private final EventSource<List<RichTextChange<PS, SEG, S>>> internalRichChangeList = new EventSource();
    private final SuspendableEventStream<List<RichTextChange<PS, SEG, S>>> richChangeList = this.internalRichChangeList.pausable();
    private final Val<String> internalText = Val.create(() -> this.doc.getText(), this.internalRichChangeList);
    private final SuspendableVal<String> text = this.internalText.suspendable();
    private final Val<Integer> internalLength = Val.create(() -> this.doc.length(), this.internalRichChangeList);
    private final SuspendableVal<Integer> length = this.internalLength.suspendable();
    private final EventSource<List<MaterializedListModification<Paragraph<PS, SEG, S>>>> parChangesList = new EventSource();
    private final SuspendableList<Paragraph<PS, SEG, S>> paragraphs = new ParagraphList().suspendable();
    private final SuspendableNo beingUpdated = new SuspendableNo();

    @Override
    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges() {
        return this.richChangeList;
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    public Val<String> textProperty() {
        return this.text;
    }

    @Override
    public int getLength() {
        return (Integer)this.length.getValue();
    }

    @Override
    public Val<Integer> lengthProperty() {
        return this.length;
    }

    @Override
    public int length() {
        return (Integer)this.length.getValue();
    }

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs() {
        return this.paragraphs;
    }

    @Override
    public ReadOnlyStyledDocument<PS, SEG, S> snapshot() {
        return this.doc;
    }

    @Override
    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    GenericEditableStyledDocumentBase(ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument) {
        this.doc = readOnlyStyledDocument;
        Suspendable suspendable = Suspendable.combine(this.text, this.length, this.richChangeList, this.paragraphs);
        suspendable.suspendWhen(this.beingUpdated);
    }

    GenericEditableStyledDocumentBase(Paragraph<PS, SEG, S> paragraph) {
        this(new ReadOnlyStyledDocument<PS, SEG, S>(Collections.singletonList(paragraph)));
    }

    GenericEditableStyledDocumentBase(PS PS, S s2, SegmentOps<SEG, S> segmentOps) {
        this(new Paragraph<PS, SEG, S>(PS, segmentOps, segmentOps.createEmptySeg(), s2));
    }

    @Override
    public TwoDimensional.Position position(int n2, int n3) {
        return this.doc.position(n2, n3);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int n2, TwoDimensional.Bias bias) {
        return this.doc.offsetToPosition(n2, bias);
    }

    @Override
    public void replaceMulti(List<Replacement<PS, SEG, S>> list) {
        this.doc.replaceMulti(list).exec(this::updateMulti);
    }

    @Override
    public void replace(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        this.doc.replace(n2, n3, ReadOnlyStyledDocument.from(styledDocument)).exec(this::updateSingle);
    }

    @Override
    public void setStyle(int n2, int n3, S s2) {
        this.doc.replace(n2, n3, readOnlyStyledDocument -> readOnlyStyledDocument.mapParagraphs(paragraph -> paragraph.restyle(s2))).exec(this::updateSingle);
    }

    @Override
    public void setStyle(int n2, S s2) {
        this.doc.replaceParagraph(n2, paragraph -> paragraph.restyle(s2)).exec(this::updateSingle);
    }

    @Override
    public void setStyle(int n2, int n3, int n4, S s2) {
        this.doc.replace(n2, n3, n4, readOnlyStyledDocument -> readOnlyStyledDocument.mapParagraphs(paragraph -> paragraph.restyle(s2))).exec(this::updateSingle);
    }

    @Override
    public void setStyleSpans(int n2, StyleSpans<? extends S> styleSpans) {
        int n3 = styleSpans.length();
        this.doc.replace(n2, n2 + n3, readOnlyStyledDocument -> {
            TwoDimensional.Position position = styleSpans.position(0, 0);
            ArrayList arrayList = new ArrayList(readOnlyStyledDocument.getParagraphs().size());
            for (Paragraph paragraph : readOnlyStyledDocument.getParagraphs()) {
                TwoDimensional.Position position2 = position.offsetBy(paragraph.length(), TwoDimensional.Bias.Backward);
                StyleSpans styleSpans2 = styleSpans.subView(position, position2);
                arrayList.add(paragraph.restyle(0, styleSpans2));
                position = position2.offsetBy(1, TwoDimensional.Bias.Forward);
            }
            return new ReadOnlyStyledDocument(arrayList);
        }).exec(this::updateSingle);
    }

    @Override
    public void setStyleSpans(int n2, int n3, StyleSpans<? extends S> styleSpans) {
        this.setStyleSpans(this.doc.position(n2, n3).toOffset(), styleSpans);
    }

    @Override
    public void setParagraphStyle(int n2, PS PS) {
        this.doc.replaceParagraph(n2, paragraph -> paragraph.setParagraphStyle(PS)).exec(this::updateSingle);
    }

    @Override
    public StyledDocument<PS, SEG, S> concat(StyledDocument<PS, SEG, S> styledDocument) {
        return this.doc.concat((StyledDocument)styledDocument);
    }

    @Override
    public StyledDocument<PS, SEG, S> subSequence(int n2, int n3) {
        return this.doc.subSequence(n2, n3);
    }

    private void updateSingle(ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument, RichTextChange<PS, SEG, S> richTextChange, MaterializedListModification<Paragraph<PS, SEG, S>> materializedListModification) {
        this.updateMulti(readOnlyStyledDocument, Collections.singletonList(richTextChange), Collections.singletonList(materializedListModification));
    }

    private void updateMulti(ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument, List<RichTextChange<PS, SEG, S>> list, List<MaterializedListModification<Paragraph<PS, SEG, S>>> list2) {
        this.doc = readOnlyStyledDocument;
        this.beingUpdated.suspendWhile(() -> {
            this.internalRichChangeList.push(list);
            this.parChangesList.push(list2);
        });
    }

    private MaterializedListModification<Paragraph<PS, SEG, S>> trim(MaterializedListModification<Paragraph<PS, SEG, S>> materializedListModification) {
        return GenericEditableStyledDocumentBase.commonPrefixSuffixLengths(materializedListModification.getRemoved(), materializedListModification.getAdded()).map((n2, n3) -> {
            if (n2 == 0 && n3 == 0) {
                return materializedListModification;
            }
            return MaterializedListModification.create(materializedListModification.getFrom() + n2, materializedListModification.getRemoved().subList((int)n2, materializedListModification.getRemovedSize() - n3), materializedListModification.getAdded().subList((int)n2, materializedListModification.getAddedSize() - n3));
        });
    }

    private static Tuple2<Integer, Integer> commonPrefixSuffixLengths(List<?> list, List<?> list2) {
        int n2 = list.size();
        int n3 = list2.size();
        if (n2 == 0 || n3 == 0) {
            return Tuples.t(0, 0);
        }
        int n4 = GenericEditableStyledDocumentBase.commonPrefixLength(list, list2);
        if (n4 == n2 || n4 == n3) {
            return Tuples.t(n4, 0);
        }
        int n5 = GenericEditableStyledDocumentBase.commonSuffixLength(list, list2);
        return Tuples.t(n4, n5);
    }

    private static int commonPrefixLength(List<?> list, List<?> list2) {
        ListIterator<?> listIterator = list.listIterator();
        ListIterator<?> listIterator2 = list2.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            if (listIterator.next() == listIterator2.next()) continue;
            return listIterator.nextIndex() - 1;
        }
        return listIterator.nextIndex();
    }

    private static int commonSuffixLength(List<?> list, List<?> list2) {
        ListIterator<?> listIterator = list.listIterator(list.size());
        ListIterator<?> listIterator2 = list2.listIterator(list2.size());
        while (listIterator.hasPrevious() && listIterator2.hasPrevious()) {
            if (listIterator.previous() == listIterator2.previous()) continue;
            return list.size() - listIterator.nextIndex() - 1;
        }
        return list.size() - listIterator.nextIndex();
    }

    private class ParagraphList
    extends LiveListBase<Paragraph<PS, SEG, S>>
    implements UnmodifiableByDefaultLiveList<Paragraph<PS, SEG, S>> {
        private ParagraphList() {
        }

        @Override
        public Paragraph<PS, SEG, S> get(int n2) {
            return GenericEditableStyledDocumentBase.this.doc.getParagraph(n2);
        }

        @Override
        public int size() {
            return GenericEditableStyledDocumentBase.this.doc.getParagraphCount();
        }

        @Override
        protected Subscription observeInputs() {
            return GenericEditableStyledDocumentBase.this.parChangesList.subscribe(list -> {
                ListChangeAccumulator listChangeAccumulator = new ListChangeAccumulator();
                for (MaterializedListModification materializedListModification : list) {
                    materializedListModification = GenericEditableStyledDocumentBase.this.trim(materializedListModification);
                    listChangeAccumulator.add(QuasiListModification.create(materializedListModification.getFrom(), materializedListModification.getRemoved(), materializedListModification.getAddedSize()));
                }
                this.notifyObservers(listChangeAccumulator.asListChange());
            });
        }
    }
}

