/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.scene.paint.Color;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.SuperCodec;
import org.reactfx.util.Either;

public interface Codec<T> {
    public static final Codec<String> STRING_CODEC = new Codec<String>(){

        @Override
        public String getName() {
            return "string";
        }

        @Override
        public void encode(DataOutputStream dataOutputStream, String string) throws IOException {
            dataOutputStream.writeUTF(string);
        }

        @Override
        public String decode(DataInputStream dataInputStream) throws IOException {
            return dataInputStream.readUTF();
        }
    };
    public static final Codec<Color> COLOR_CODEC = new Codec<Color>(){

        @Override
        public String getName() {
            return "color";
        }

        @Override
        public void encode(DataOutputStream dataOutputStream, Color color) throws IOException {
            dataOutputStream.writeDouble(color.getRed());
            dataOutputStream.writeDouble(color.getGreen());
            dataOutputStream.writeDouble(color.getBlue());
            dataOutputStream.writeDouble(color.getOpacity());
        }

        @Override
        public Color decode(DataInputStream dataInputStream) throws IOException {
            return Color.color((double)dataInputStream.readDouble(), (double)dataInputStream.readDouble(), (double)dataInputStream.readDouble(), (double)dataInputStream.readDouble());
        }
    };

    public String getName();

    public void encode(DataOutputStream var1, T var2) throws IOException;

    public T decode(DataInputStream var1) throws IOException;

    public static <SEG, S> Codec<StyledSegment<SEG, S>> styledSegmentCodec(final Codec<SEG> codec, final Codec<S> codec2) {
        return new Codec<StyledSegment<SEG, S>>(){

            @Override
            public String getName() {
                return "styled-segment<" + codec.getName() + ", " + codec2.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, StyledSegment<SEG, S> styledSegment) throws IOException {
                codec.encode(dataOutputStream, styledSegment.getSegment());
                codec2.encode(dataOutputStream, styledSegment.getStyle());
            }

            @Override
            public StyledSegment<SEG, S> decode(DataInputStream dataInputStream) throws IOException {
                Object t2 = codec.decode(dataInputStream);
                Object t3 = codec2.decode(dataInputStream);
                return new StyledSegment(t2, t3);
            }
        };
    }

    public static <S> Codec<StyledSegment<String, S>> styledTextCodec(final Codec<S> codec) {
        return new Codec<StyledSegment<String, S>>(){

            @Override
            public String getName() {
                return "styled-text";
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, StyledSegment<String, S> styledSegment) throws IOException {
                STRING_CODEC.encode(dataOutputStream, styledSegment.getSegment());
                codec.encode(dataOutputStream, styledSegment.getStyle());
            }

            @Override
            public StyledSegment<String, S> decode(DataInputStream dataInputStream) throws IOException {
                String string = STRING_CODEC.decode(dataInputStream);
                Object t2 = codec.decode(dataInputStream);
                return new StyledSegment(string, t2);
            }
        };
    }

    public static <T> Codec<List<T>> listCodec(Codec<T> codec) {
        return SuperCodec.collectionListCodec(codec);
    }

    public static <T> Codec<Collection<T>> collectionCodec(Codec<T> codec) {
        return SuperCodec.upCast(SuperCodec.collectionListCodec(codec));
    }

    public static <T> Codec<Optional<T>> optionalCodec(final Codec<T> codec) {
        return new Codec<Optional<T>>(){

            @Override
            public String getName() {
                return "optional<" + codec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, Optional<T> optional) throws IOException {
                if (optional.isPresent()) {
                    dataOutputStream.writeBoolean(true);
                    codec.encode(dataOutputStream, optional.get());
                } else {
                    dataOutputStream.writeBoolean(false);
                }
            }

            @Override
            public Optional<T> decode(DataInputStream dataInputStream) throws IOException {
                return dataInputStream.readBoolean() ? Optional.of(codec.decode(dataInputStream)) : Optional.empty();
            }
        };
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(final Class<E> clazz) {
        return new Codec<E>(){

            @Override
            public String getName() {
                return clazz.getSimpleName();
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, E e2) throws IOException {
                dataOutputStream.writeInt(((Enum)e2).ordinal());
            }

            @Override
            public E decode(DataInputStream dataInputStream) throws IOException {
                int n2 = dataInputStream.readInt();
                return ((Enum[])clazz.getEnumConstants())[n2];
            }
        };
    }

    public static <L, R> Codec<Either<L, R>> eitherCodec(final Codec<L> codec, final Codec<R> codec2) {
        return new Codec<Either<L, R>>(){

            @Override
            public String getName() {
                return "either<" + codec.getName() + ", " + codec2.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream dataOutputStream, Either<L, R> either) throws IOException {
                if (either.isLeft()) {
                    dataOutputStream.writeBoolean(false);
                    codec.encode(dataOutputStream, either.getLeft());
                } else {
                    dataOutputStream.writeBoolean(true);
                    codec2.encode(dataOutputStream, either.getRight());
                }
            }

            @Override
            public Either<L, R> decode(DataInputStream dataInputStream) throws IOException {
                boolean bl = dataInputStream.readBoolean();
                return bl ? Either.right(codec2.decode(dataInputStream)) : Either.left(codec.decode(dataInputStream));
            }
        };
    }
}

