/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBase;

class AppendedSpans<S>
extends StyleSpansBase<S> {
    private final StyleSpans<S> original;
    private final StyleSpan<S> appended;
    private int length = -1;
    private int spanCount = -1;

    public AppendedSpans(StyleSpans<S> styleSpans, StyleSpan<S> styleSpan) {
        this.original = styleSpans;
        this.appended = styleSpan;
    }

    @Override
    public int length() {
        if (this.length == -1) {
            this.length = this.original.length() + this.appended.getLength();
        }
        return this.length;
    }

    @Override
    public int getSpanCount() {
        if (this.spanCount == -1) {
            this.spanCount = this.original.getSpanCount() + 1;
        }
        return this.spanCount;
    }

    @Override
    public StyleSpan<S> getStyleSpan(int n2) {
        if (n2 == this.getSpanCount() - 1) {
            return this.appended;
        }
        return this.original.getStyleSpan(n2);
    }
}

