/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.event;

import java.time.Duration;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.fxmisc.richtext.event.MouseStationaryEvent;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.util.Either;

public class MouseStationaryHelper {
    private final Node node;
    private Subscription installed = null;

    public MouseStationaryHelper(Node node) {
        this.node = node;
    }

    public EventStream<Either<Point2D, Void>> events(Duration duration) {
        EventStream eventStream = EventStreams.eventsOf(this.node, MouseEvent.ANY);
        EventStream<Point2D> eventStream2 = eventStream.successionEnds(duration).filter(mouseEvent -> mouseEvent.getEventType() == MouseEvent.MOUSE_MOVED).map(mouseEvent -> new Point2D(mouseEvent.getX(), mouseEvent.getY()));
        EventStream<Void> eventStream3 = eventStream.supply((Void)null);
        return eventStream2.or(eventStream3).distinct();
    }

    public void install(Duration duration) {
        if (this.installed != null) {
            this.installed.unsubscribe();
        }
        this.installed = this.events(duration).map(either -> either.unify(point2D -> MouseStationaryEvent.beginAt(this.node.localToScreen(point2D)), void_ -> MouseStationaryEvent.end())).subscribe(event -> Event.fireEvent((EventTarget)this.node, (Event)event));
    }

    public void uninstall() {
        if (this.installed != null) {
            this.installed.unsubscribe();
            this.installed = null;
        }
    }
}

