/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.event;

import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.InputEvent;

public abstract class MouseStationaryEvent
extends InputEvent {
    private static final long serialVersionUID = 1L;
    private static final End DEFAULT_END = new End(null, null);
    public static final EventType<MouseStationaryEvent> ANY = new EventType(InputEvent.ANY, "MOUSE_STATIONARY_ANY");
    public static final EventType<MouseStationaryEvent> MOUSE_STATIONARY_BEGIN = new EventType(ANY, "MOUSE_STATIONARY_BEGIN");
    public static final EventType<MouseStationaryEvent> MOUSE_STATIONARY_END = new EventType(ANY, "MOUSE_STATIONARY_END");

    static final MouseStationaryEvent beginAt(Point2D point2D) {
        return new Begin(null, null, point2D);
    }

    static final MouseStationaryEvent end() {
        return DEFAULT_END;
    }

    private MouseStationaryEvent(Object object, EventTarget eventTarget, EventType<? extends MouseStationaryEvent> eventType) {
        super(object, eventTarget, eventType);
    }

    public abstract Point2D getPosition();

    public abstract Point2D getScenePosition();

    public abstract Point2D getScreenPosition();

    private static class End
    extends MouseStationaryEvent {
        private static final long serialVersionUID = 1L;

        public End(Object object, EventTarget eventTarget) {
            super(object, eventTarget, MOUSE_STATIONARY_END);
        }

        @Override
        public Point2D getPosition() {
            return null;
        }

        @Override
        public Point2D getScenePosition() {
            return null;
        }

        @Override
        public Point2D getScreenPosition() {
            return null;
        }

        public End copyFor(Object object, EventTarget eventTarget) {
            return new End(object, eventTarget);
        }
    }

    private static class Begin
    extends MouseStationaryEvent {
        private static final long serialVersionUID = 1L;
        private final Point2D screenPos;

        public Begin(Object object, EventTarget eventTarget, Point2D point2D) {
            super(object, eventTarget, MOUSE_STATIONARY_BEGIN);
            this.screenPos = point2D;
        }

        @Override
        public Point2D getPosition() {
            if (this.source instanceof Node) {
                return ((Node)this.source).screenToLocal(this.screenPos);
            }
            if (this.source instanceof Scene) {
                return this.getScenePosition();
            }
            return null;
        }

        @Override
        public Point2D getScenePosition() {
            Scene scene;
            if (this.source instanceof Node) {
                scene = ((Node)this.source).getScene();
            } else if (this.source instanceof Scene) {
                scene = (Scene)this.source;
            } else {
                return null;
            }
            return this.screenPos.subtract(scene.getX() + scene.getWindow().getX(), scene.getY() + scene.getWindow().getY());
        }

        @Override
        public Point2D getScreenPosition() {
            return this.screenPos;
        }

        public Begin copyFor(Object object, EventTarget eventTarget) {
            return new Begin(object, eventTarget, this.screenPos);
        }
    }
}

