/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.event;

import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;

public abstract class MouseOverTextEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private static final End DEFAULT_END = new End(null, null);
    public static final EventType<MouseOverTextEvent> ANY = new EventType(Event.ANY, "MOUSE_OVER_TEXT_ANY");
    public static final EventType<MouseOverTextEvent> MOUSE_OVER_TEXT_BEGIN = new EventType(ANY, "MOUSE_OVER_TEXT_BEGIN");
    public static final EventType<MouseOverTextEvent> MOUSE_OVER_TEXT_END = new EventType(ANY, "MOUSE_OVER_TEXT_END");

    public static final MouseOverTextEvent beginAt(Point2D point2D, int n2) {
        return new Begin(null, null, point2D, n2);
    }

    public static final MouseOverTextEvent end() {
        return DEFAULT_END;
    }

    private MouseOverTextEvent(Object object, EventTarget eventTarget, EventType<? extends MouseOverTextEvent> eventType) {
        super(object, eventTarget, eventType);
    }

    public abstract Point2D getPosition();

    public abstract Point2D getScenePosition();

    public abstract Point2D getScreenPosition();

    public abstract int getCharacterIndex();

    private static class End
    extends MouseOverTextEvent {
        private static final long serialVersionUID = 1L;

        public End(Object object, EventTarget eventTarget) {
            super(object, eventTarget, MOUSE_OVER_TEXT_END);
        }

        @Override
        public int getCharacterIndex() {
            return -1;
        }

        @Override
        public Point2D getPosition() {
            return null;
        }

        @Override
        public Point2D getScenePosition() {
            return null;
        }

        @Override
        public Point2D getScreenPosition() {
            return null;
        }

        public End copyFor(Object object, EventTarget eventTarget) {
            return new End(object, eventTarget);
        }
    }

    private static class Begin
    extends MouseOverTextEvent {
        private static final long serialVersionUID = 1L;
        private final Point2D screenPos;
        private final int charIdx;

        public Begin(Object object, EventTarget eventTarget, Point2D point2D, int n2) {
            super(object, eventTarget, MOUSE_OVER_TEXT_BEGIN);
            this.screenPos = point2D;
            this.charIdx = n2;
        }

        @Override
        public int getCharacterIndex() {
            return this.charIdx;
        }

        @Override
        public Point2D getPosition() {
            if (this.source instanceof Node) {
                return ((Node)this.source).screenToLocal(this.screenPos);
            }
            if (this.source instanceof Scene) {
                return this.getScenePosition();
            }
            return null;
        }

        @Override
        public Point2D getScenePosition() {
            Scene scene;
            if (this.source instanceof Node) {
                scene = ((Node)this.source).getScene();
            } else if (this.source instanceof Scene) {
                scene = (Scene)this.source;
            } else {
                return null;
            }
            return this.screenPos.subtract(scene.getX() + scene.getWindow().getX(), scene.getY() + scene.getWindow().getY());
        }

        @Override
        public Point2D getScreenPosition() {
            return this.screenPos;
        }

        public Begin copyFor(Object object, EventTarget eventTarget) {
            return new Begin(object, eventTarget, this.screenPos, this.charIdx);
        }
    }
}

