/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javafx.scene.control.IndexRange;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowExt
extends TextFlow {
    private static Method mGetTextLayout;

    TextFlowExt() {
    }

    private static Object invoke(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    int getLineCount() {
        return this.getLines().length;
    }

    int getLineStartPosition(int n3) {
        TextLine[] textLineArray = this.getLines();
        TwoLevelNavigator twoLevelNavigator = new TwoLevelNavigator(() -> textLineArray.length, n2 -> textLineArray[n2].getLength());
        int n4 = twoLevelNavigator.offsetToPosition(n3, TwoDimensional.Bias.Forward).getMajor();
        return twoLevelNavigator.position(n4, 0).toOffset();
    }

    int getLineEndPosition(int n3) {
        TextLine[] textLineArray = this.getLines();
        TwoLevelNavigator twoLevelNavigator = new TwoLevelNavigator(() -> textLineArray.length, n2 -> textLineArray[n2].getLength());
        int n4 = twoLevelNavigator.offsetToPosition(n3, TwoDimensional.Bias.Forward).getMajor();
        int n5 = n4 == textLineArray.length - 1 ? 0 : -1;
        return twoLevelNavigator.position(n4 + 1, n5).toOffset();
    }

    int getLineOfCharacter(int n3) {
        TextLine[] textLineArray = this.getLines();
        TwoLevelNavigator twoLevelNavigator = new TwoLevelNavigator(() -> textLineArray.length, n2 -> textLineArray[n2].getLength());
        return twoLevelNavigator.offsetToPosition(n3, TwoDimensional.Bias.Forward).getMajor();
    }

    PathElement[] getCaretShape(int n2, boolean bl) {
        return this.textLayout().getCaretShape(n2, bl, 0.0f, 0.0f);
    }

    PathElement[] getRangeShape(IndexRange indexRange) {
        return this.getRangeShape(indexRange.getStart(), indexRange.getEnd());
    }

    PathElement[] getRangeShape(int n2, int n3) {
        return this.textLayout().getRange(n2, n3, 1, 0.0f, 0.0f);
    }

    PathElement[] getUnderlineShape(IndexRange indexRange) {
        return this.getUnderlineShape(indexRange.getStart(), indexRange.getEnd());
    }

    PathElement[] getUnderlineShape(int n2, int n3) {
        PathElement[] pathElementArray = this.textLayout().getRange(n2, n3, 2, 0.0f, 0.0f);
        ArrayList<PathElement> arrayList = new ArrayList<PathElement>();
        boolean bl = false;
        for (PathElement pathElement : pathElementArray) {
            if (pathElement instanceof MoveTo) {
                arrayList.add(pathElement);
                bl = true;
                continue;
            }
            if (!(pathElement instanceof LineTo) || !bl) continue;
            arrayList.add(pathElement);
            bl = false;
        }
        return arrayList.toArray(new PathElement[0]);
    }

    CharacterHit hitLine(double d2, int n2) {
        return this.hit(d2, this.getLineCenter(n2));
    }

    CharacterHit hit(double d2, double d3) {
        HitInfo hitInfo = this.textLayout().getHitInfo((float)d2, (float)d3);
        int n2 = hitInfo.getCharIndex();
        boolean bl = hitInfo.isLeading();
        int n3 = this.getLineIndex((float)d3);
        if (n3 >= this.getLineCount()) {
            return CharacterHit.insertionAt(this.getCharCount());
        }
        TextLine[] textLineArray = this.getLines();
        TextLine textLine = textLineArray[n3];
        RectBounds rectBounds = textLine.getBounds();
        if (textLineArray.length > 1 && n3 < textLineArray.length - 1 && n2 + 1 >= textLine.getStart() + textLine.getLength() && !bl) {
            bl = true;
        }
        if (d2 < (double)rectBounds.getMinX() || d2 > (double)rectBounds.getMaxX()) {
            if (bl) {
                return CharacterHit.insertionAt(n2);
            }
            return CharacterHit.insertionAt(n2 + 1);
        }
        if (bl) {
            return CharacterHit.leadingHalfOf(n2);
        }
        return CharacterHit.trailingHalfOf(n2);
    }

    private float getLineY(int n2) {
        TextLine[] textLineArray = this.getLines();
        float f2 = (float)this.getLineSpacing();
        float f3 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f3 += textLineArray[i2].getBounds().getHeight() + f2;
        }
        return f3;
    }

    private float getLineCenter(int n2) {
        return this.getLineY(n2) + this.getLines()[n2].getBounds().getHeight() / 2.0f;
    }

    private TextLine[] getLines() {
        return this.textLayout().getLines();
    }

    private int getLineIndex(float f2) {
        return this.textLayout().getLineIndex(f2);
    }

    private int getCharCount() {
        return this.textLayout().getCharCount();
    }

    private TextLayout textLayout() {
        return GenericIceBreaker.proxy(TextLayout.class, TextFlowExt.invoke(mGetTextLayout, (Object)this, new Object[0]));
    }

    static {
        try {
            mGetTextLayout = TextFlow.class.getDeclaredMethod("getTextLayout", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
        mGetTextLayout.setAccessible(true);
    }

    private static interface HitInfo {
        public int getCharIndex();

        public boolean isLeading();
    }

    private static interface RectBounds {
        public float getMinX();

        public float getMaxX();

        public float getHeight();
    }

    private static interface TextLine {
        public int getLength();

        public RectBounds getBounds();

        public int getStart();
    }

    private static interface TextLayout {
        public static final int TYPE_TEXT = 1;
        public static final int TYPE_UNDERLINE = 2;

        public TextLine[] getLines();

        public int getLineIndex(float var1);

        public int getCharCount();

        public HitInfo getHitInfo(float var1, float var2);

        public PathElement[] getCaretShape(int var1, boolean var2, float var3, float var4);

        public PathElement[] getRange(int var1, int var2, int var3, float var4, float var5);
    }

    private static class MethodCacheKey {
        final Class<?> cls;
        final String name;
        final Class<?>[] paramTypes;

        MethodCacheKey(Class<?> clazz, String string, Class<?> ... classArray) {
            this.cls = clazz;
            this.name = string;
            this.paramTypes = classArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodCacheKey)) {
                return false;
            }
            MethodCacheKey methodCacheKey = (MethodCacheKey)object;
            return this.cls == methodCacheKey.cls && this.name.equals(methodCacheKey.name) && Arrays.equals(this.paramTypes, methodCacheKey.paramTypes);
        }

        public int hashCode() {
            return this.cls.hashCode() + this.name.hashCode() + Arrays.hashCode(this.paramTypes);
        }
    }

    private static class GenericIceBreaker
    implements InvocationHandler {
        private final Object delegate;
        private static final HashMap<MethodCacheKey, Method> declaredMethodCache = new HashMap();

        private GenericIceBreaker(Object object) {
            this.delegate = object;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Method method2 = GenericIceBreaker.getDeclaredMethod(this.delegate.getClass(), method.getName(), method.getParameterTypes());
            Object object2 = null;
            try {
                object2 = method2.invoke(this.delegate, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new RuntimeException("problems invoking " + method.getName());
            }
            if (object2 == null) {
                return null;
            }
            if (method.getReturnType().isArray() && method.getReturnType().getComponentType().isInterface() && !method.getReturnType().getComponentType().equals(method2.getReturnType().getComponentType())) {
                int n2 = Array.getLength(object2);
                Object object3 = Array.newInstance(method.getReturnType().getComponentType(), n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Array.set(object3, i2, GenericIceBreaker.proxy(method.getReturnType().getComponentType(), Array.get(object2, i2)));
                }
                return object3;
            }
            if (method.getReturnType().isInterface() && !method.getReturnType().equals(method2.getReturnType())) {
                return GenericIceBreaker.proxy(method.getReturnType(), object2);
            }
            return object2;
        }

        static <T> T proxy(Class<T> clazz, Object object) {
            return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new GenericIceBreaker(object));
        }

        private static synchronized Method getDeclaredMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException, SecurityException {
            MethodCacheKey methodCacheKey = new MethodCacheKey(clazz, string, classArray);
            Method method = declaredMethodCache.get(methodCacheKey);
            if (method == null) {
                method = clazz.getDeclaredMethod(string, classArray);
                method.setAccessible(true);
                declaredMethodCache.put(methodCacheKey, method);
            }
            return method;
        }
    }
}

