/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.List;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.EventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.value.Var;

public interface TextEditingArea<PS, SEG, S> {
    default public int getLength() {
        return (Integer)this.lengthProperty().getValue();
    }

    public ObservableValue<Integer> lengthProperty();

    default public String getText() {
        return (String)this.textProperty().getValue();
    }

    public ObservableValue<String> textProperty();

    public StyledDocument<PS, SEG, S> getDocument();

    public EditableStyledDocument<PS, SEG, S> getContent();

    public SegmentOps<SEG, S> getSegOps();

    default public int getCaretPosition() {
        return this.getCaretSelectionBind().getPosition();
    }

    default public ObservableValue<Integer> caretPositionProperty() {
        return this.getCaretSelectionBind().positionProperty();
    }

    default public int getCurrentParagraph() {
        return this.getCaretSelectionBind().getParagraphIndex();
    }

    default public ObservableValue<Integer> currentParagraphProperty() {
        return this.getCaretSelectionBind().paragraphIndexProperty();
    }

    default public int getCaretColumn() {
        return this.getCaretSelectionBind().getColumnPosition();
    }

    default public ObservableValue<Integer> caretColumnProperty() {
        return this.getCaretSelectionBind().columnPositionProperty();
    }

    default public Optional<Bounds> getCaretBounds() {
        return this.getCaretSelectionBind().getCaretBounds();
    }

    default public ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.getCaretSelectionBind().caretBoundsProperty();
    }

    default public Caret.CaretVisibility getShowCaret() {
        return this.getCaretSelectionBind().getShowCaret();
    }

    default public void setShowCaret(Caret.CaretVisibility caretVisibility) {
        this.getCaretSelectionBind().setShowCaret(caretVisibility);
    }

    default public Var<Caret.CaretVisibility> showCaretProperty() {
        return this.getCaretSelectionBind().showCaretProperty();
    }

    public CaretSelectionBind<PS, SEG, S> getCaretSelectionBind();

    default public int getAnchor() {
        return this.getCaretSelectionBind().getAnchorPosition();
    }

    default public ObservableValue<Integer> anchorProperty() {
        return this.getCaretSelectionBind().anchorPositionProperty();
    }

    default public IndexRange getSelection() {
        return this.getCaretSelectionBind().getRange();
    }

    default public ObservableValue<IndexRange> selectionProperty() {
        return this.getCaretSelectionBind().rangeProperty();
    }

    default public String getSelectedText() {
        return this.getCaretSelectionBind().getSelectedText();
    }

    default public ObservableValue<String> selectedTextProperty() {
        return this.getCaretSelectionBind().selectedTextProperty();
    }

    default public Optional<Bounds> getSelectionBounds() {
        return this.getCaretSelectionBind().getSelectionBounds();
    }

    default public ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.getCaretSelectionBind().selectionBoundsProperty();
    }

    public ObservableList<Paragraph<PS, SEG, S>> getParagraphs();

    default public Paragraph<PS, SEG, S> getParagraph(int n2) {
        return (Paragraph)this.getParagraphs().get(n2);
    }

    default public int getParagraphLength(int n2) {
        return this.getParagraph(n2).length();
    }

    public SuspendableNo beingUpdatedProperty();

    default public boolean isBeingUpdated() {
        return this.beingUpdatedProperty().get();
    }

    public EventStream<List<PlainTextChange>> multiPlainChanges();

    public EventStream<PlainTextChange> plainTextChanges();

    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges();

    public EventStream<RichTextChange<PS, SEG, S>> richChanges();

    public String getText(int var1);

    public String getText(int var1, int var2);

    public String getText(IndexRange var1);

    default public String getText(int n2, int n3, int n4, int n5) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        return this.getText(n6, n7);
    }

    public StyledDocument<PS, SEG, S> subDocument(int var1);

    default public StyledDocument<PS, SEG, S> subDocument(IndexRange indexRange) {
        return this.subDocument(indexRange.getStart(), indexRange.getEnd());
    }

    public StyledDocument<PS, SEG, S> subDocument(int var1, int var2);

    default public StyledDocument<PS, SEG, S> subDocument(int n2, int n3, int n4, int n5) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        return this.subDocument(n6, n7);
    }

    default public IndexRange getParagraphSelection(int n2) {
        return this.getParagraphSelection(this.getCaretSelectionBind(), n2);
    }

    public IndexRange getParagraphSelection(Selection var1, int var2);

    default public void selectRange(int n2, int n3) {
        this.getCaretSelectionBind().selectRangeExpl(n2, n3);
    }

    default public void selectRange(int n2, int n3, int n4, int n5) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        this.selectRange(n6, n7);
    }

    public void displaceCaret(int var1);

    public void replaceText(int var1, int var2, String var3);

    default public void replaceText(int n2, int n3, int n4, int n5, String string) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        this.replaceText(n6, n7, string);
    }

    public void replace(int var1, int var2, StyledDocument<PS, SEG, S> var3);

    public MultiChangeBuilder<PS, SEG, S> createMultiChange();

    public MultiChangeBuilder<PS, SEG, S> createMultiChange(int var1);

    public void replace(int var1, int var2, SEG var3, S var4);

    default public void replace(int n2, int n3, int n4, int n5, SEG SEG, S s2) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        this.replace(n6, n7, SEG, s2);
    }

    default public void replace(int n2, int n3, int n4, int n5, StyledDocument<PS, SEG, S> styledDocument) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        this.replace(n6, n7, styledDocument);
    }

    default public void replaceText(IndexRange indexRange, String string) {
        this.replaceText(indexRange.getStart(), indexRange.getEnd(), string);
    }

    default public void replace(IndexRange indexRange, SEG SEG, S s2) {
        this.replace(indexRange.getStart(), indexRange.getEnd(), SEG, s2);
    }

    default public void replace(IndexRange indexRange, StyledDocument<PS, SEG, S> styledDocument) {
        this.replace(indexRange.getStart(), indexRange.getEnd(), styledDocument);
    }

    public int getAbsolutePosition(int var1, int var2);

    public void dispose();
}

