/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.BiConsumer;
import javafx.beans.NamedArg;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.SimpleEditableStyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;

public class StyledTextArea<PS, S>
extends GenericStyledArea<PS, String, S> {
    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> biConsumer2, @NamedArg(value="document") EditableStyledDocument<PS, String, S> editableStyledDocument, @NamedArg(value="segmentOps") TextOps<String, S> textOps, @NamedArg(value="preserveStyle") boolean bl) {
        super(PS, biConsumer, s2, editableStyledDocument, textOps, bl, styledSegment -> StyledTextArea.createStyledTextNode(styledSegment, biConsumer2));
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> biConsumer2, @NamedArg(value="document") EditableStyledDocument<PS, String, S> editableStyledDocument, @NamedArg(value="preserveStyle") boolean bl) {
        this(PS, biConsumer, s2, biConsumer2, editableStyledDocument, SegmentOps.styledTextOps(), bl);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> biConsumer2, @NamedArg(value="document") EditableStyledDocument<PS, String, S> editableStyledDocument) {
        this(PS, biConsumer, s2, biConsumer2, editableStyledDocument, true);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> biConsumer2, @NamedArg(value="preserveStyle") boolean bl) {
        this(PS, biConsumer, s2, biConsumer2, new SimpleEditableStyledDocument<PS, S>(PS, s2), bl);
    }

    public StyledTextArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="applyStyle") BiConsumer<? super TextExt, S> biConsumer2) {
        this(PS, biConsumer, s2, biConsumer2, true);
    }

    public static <S> Node createStyledTextNode(StyledSegment<String, S> styledSegment, BiConsumer<? super TextExt, S> biConsumer) {
        return StyledTextArea.createStyledTextNode(styledSegment.getSegment(), styledSegment.getStyle(), biConsumer);
    }

    public static <S> Node createStyledTextNode(String string, S s2, BiConsumer<? super TextExt, S> biConsumer) {
        TextExt textExt = new TextExt(string);
        textExt.setTextOrigin(VPos.TOP);
        textExt.getStyleClass().add((Object)"text");
        biConsumer.accept(textExt, s2);
        return textExt;
    }
}

