/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class SelectionImpl<PS, SEG, S>
implements Comparable<SelectionImpl<PS, SEG, S>>,
Selection<PS, SEG, S> {
    private final SuspendableVal<IndexRange> range;
    private final SuspendableVal<Integer> length;
    private final Val<Integer> paragraphSpan;
    private final SuspendableVal<StyledDocument<PS, SEG, S>> selectedDocument;
    private final SuspendableVal<String> selectedText;
    private final SuspendableVal<Integer> startPosition;
    private final Val<Integer> startParagraphIndex;
    private final Val<Integer> startColumnPosition;
    private final SuspendableVal<Integer> endPosition;
    private final Val<Integer> endParagraphIndex;
    private final Val<Integer> endColumnPosition;
    private final SuspendableVal<Optional<Bounds>> bounds;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final GenericStyledArea<PS, SEG, S> area;
    private final String name;
    private final SuspendableNo dependentBeingUpdated;
    private final Var<IndexRange> internalRange;
    private final EventStream<?> dirty;
    private final Var<TwoDimensional.Position> start2DPosition;
    private final Val<TwoDimensional.Position> end2DPosition;
    private final Consumer<SelectionPath> configurePath;
    private Subscription subscription = () -> {};

    @Override
    public final IndexRange getRange() {
        return (IndexRange)this.range.getValue();
    }

    @Override
    public final ObservableValue<IndexRange> rangeProperty() {
        return this.range;
    }

    @Override
    public final int getLength() {
        return (Integer)this.length.getValue();
    }

    @Override
    public final ObservableValue<Integer> lengthProperty() {
        return this.length;
    }

    @Override
    public final int getParagraphSpan() {
        return (Integer)this.paragraphSpan.getValue();
    }

    @Override
    public final ObservableValue<Integer> paragraphSpanProperty() {
        return this.paragraphSpan;
    }

    @Override
    public final ObservableValue<StyledDocument<PS, SEG, S>> selectedDocumentProperty() {
        return this.selectedDocument;
    }

    @Override
    public final StyledDocument<PS, SEG, S> getSelectedDocument() {
        return (StyledDocument)this.selectedDocument.getValue();
    }

    @Override
    public final String getSelectedText() {
        return (String)this.selectedText.getValue();
    }

    @Override
    public final ObservableValue<String> selectedTextProperty() {
        return this.selectedText;
    }

    @Override
    public final int getStartPosition() {
        return (Integer)this.startPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> startPositionProperty() {
        return this.startPosition;
    }

    @Override
    public final int getStartParagraphIndex() {
        return (Integer)this.startParagraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> startParagraphIndexProperty() {
        return this.startParagraphIndex;
    }

    @Override
    public final int getStartColumnPosition() {
        return (Integer)this.startColumnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> startColumnPositionProperty() {
        return this.startColumnPosition;
    }

    @Override
    public final int getEndPosition() {
        return (Integer)this.endPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> endPositionProperty() {
        return this.endPosition;
    }

    @Override
    public final int getEndParagraphIndex() {
        return (Integer)this.endParagraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> endParagraphIndexProperty() {
        return this.endParagraphIndex;
    }

    @Override
    public final int getEndColumnPosition() {
        return (Integer)this.endColumnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> endColumnPositionProperty() {
        return this.endColumnPosition;
    }

    @Override
    public final Optional<Bounds> getSelectionBounds() {
        return (Optional)this.bounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.bounds;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public final ObservableValue<Boolean> beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public GenericStyledArea<PS, SEG, S> getArea() {
        return this.area;
    }

    @Override
    public String getSelectionName() {
        return this.name;
    }

    public SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea) {
        this(string, genericStyledArea, 0, 0);
    }

    public SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea, Consumer<SelectionPath> consumer) {
        this(string, genericStyledArea, 0, 0, genericStyledArea.beingUpdatedProperty(), consumer);
    }

    public SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea, int n2, int n3) {
        this(string, genericStyledArea, new IndexRange(n2, n3), genericStyledArea.beingUpdatedProperty());
    }

    SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea, int n2, int n3, SuspendableNo suspendableNo) {
        this(string, genericStyledArea, new IndexRange(n2, n3), suspendableNo);
    }

    SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea, int n2, int n3, SuspendableNo suspendableNo, Consumer<SelectionPath> consumer) {
        this(string, genericStyledArea, new IndexRange(n2, n3), suspendableNo, consumer);
    }

    SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea, IndexRange indexRange, SuspendableNo suspendableNo) {
        this(string, genericStyledArea, indexRange, suspendableNo, (SelectionPath selectionPath) -> selectionPath.getStyleClass().add((Object)"selection"));
    }

    SelectionImpl(String string, GenericStyledArea<PS, SEG, S> genericStyledArea, IndexRange indexRange, SuspendableNo suspendableNo, Consumer<SelectionPath> consumer) {
        this.name = string;
        this.area = genericStyledArea;
        this.dependentBeingUpdated = suspendableNo;
        this.configurePath = consumer;
        this.internalRange = Var.newSimpleVar(indexRange);
        this.range = this.internalRange.suspendable();
        this.length = this.internalRange.map(IndexRange::getLength).suspendable();
        Val<StyledDocument> val = Val.create(() -> genericStyledArea.subDocument((IndexRange)this.internalRange.getValue()), new Observable[]{this.internalRange, genericStyledArea.getParagraphs()});
        this.selectedDocument = val.suspendable();
        this.selectedText = val.map(StyledDocument::getText).suspendable();
        this.start2DPosition = Var.newSimpleVar(this.position(0, 0));
        this.end2DPosition = this.start2DPosition.map(position -> this.getLength() == 0 ? position : position.offsetBy(this.getLength(), TwoDimensional.Bias.Backward));
        this.internalRange.addListener(observable -> {
            IndexRange indexRange = (IndexRange)this.internalRange.getValue();
            this.start2DPosition.setValue(genericStyledArea.offsetToPosition(indexRange.getStart(), TwoDimensional.Bias.Forward));
        });
        this.startPosition = this.internalRange.map(IndexRange::getStart).suspendable();
        this.startParagraphIndex = this.start2DPosition.map(TwoDimensional.Position::getMajor);
        this.startColumnPosition = this.start2DPosition.map(TwoDimensional.Position::getMinor);
        this.endPosition = this.internalRange.map(IndexRange::getEnd).suspendable();
        this.endParagraphIndex = this.end2DPosition.map(TwoDimensional.Position::getMajor);
        this.endColumnPosition = this.end2DPosition.map(TwoDimensional.Position::getMinor);
        this.paragraphSpan = Val.combine(this.startParagraphIndex, this.endParagraphIndex, (n2, n3) -> n3 - n2 + 1);
        this.dirty = EventStreams.merge(EventStreams.invalidationsOf(this.rangeProperty()), EventStreams.invalidationsOf((Observable)genericStyledArea.getParagraphs()));
        this.bounds = Val.create(() -> genericStyledArea.getSelectionBoundsOnScreen(this), EventStreams.merge(genericStyledArea.viewportDirtyEvents(), this.dirty)).suspendable();
        this.manageSubscription(genericStyledArea.multiPlainChanges(), list -> {
            int n2 = this.getStartPosition();
            int n3 = this.getEndPosition();
            for (PlainTextChange plainTextChange : list) {
                int n4 = plainTextChange.getNetLength();
                int n5 = plainTextChange.getPosition();
                int n6 = n5 + Math.abs(n4);
                if (this.getLength() != 0) {
                    if (n5 == n2 && n4 > 0) {
                        n2 += n4;
                    } else if (n5 < n2) {
                        int n7 = n2 = n2 < n6 ? n5 : n2 + n4;
                    }
                    if (n5 < n3) {
                        int n8 = n3 = n3 < n6 ? n5 : n3 + n4;
                    }
                    if (n2 <= n3) continue;
                    n2 = n3;
                    continue;
                }
                if (this.getEndPosition() <= 0) continue;
                n3 = n2 = genericStyledArea.getLength();
            }
            this.selectRange(n2, n3);
        });
        Suspendable suspendable = Suspendable.combine(this.beingUpdated, this.bounds, this.endPosition, this.startPosition, this.selectedText, this.selectedDocument, this.length, this.range);
        this.manageSubscription(suspendable.suspendWhen(suspendableNo));
    }

    @Override
    public void selectRange(int n2, int n3, int n4, int n5) {
        this.selectRange(this.textPosition(n2, n3), this.textPosition(n4, n5));
    }

    @Override
    public void selectRange(int n2, int n3) {
        this.selectRange(new IndexRange(n2, n3));
    }

    private void selectRange(IndexRange indexRange) {
        Runnable runnable = () -> this.internalRange.setValue(indexRange);
        if (this.dependentBeingUpdated.get()) {
            runnable.run();
        } else {
            this.dependentBeingUpdated.suspendWhile(runnable);
        }
    }

    @Override
    public void updateStartBy(int n3, Selection.Direction direction) {
        this.moveBoundary(direction, n3, this.getStartPosition(), n2 -> IndexRange.normalize((int)n2, (int)this.getEndPosition()));
    }

    @Override
    public void updateEndBy(int n3, Selection.Direction direction) {
        this.moveBoundary(direction, n3, this.getEndPosition(), n2 -> IndexRange.normalize((int)this.getStartPosition(), (int)n2));
    }

    @Override
    public void updateStartTo(int n2) {
        this.selectRange(n2, this.getEndPosition());
    }

    @Override
    public void updateStartTo(int n2, int n3) {
        this.selectRange(this.textPosition(n2, n3), this.getEndPosition());
    }

    @Override
    public void updateStartByBreaksForward(int n2, BreakIterator breakIterator) {
        this.updateStartByBreaks(n2, breakIterator, true);
    }

    @Override
    public void updateStartByBreaksBackward(int n2, BreakIterator breakIterator) {
        this.updateStartByBreaks(n2, breakIterator, false);
    }

    @Override
    public void updateEndTo(int n2) {
        this.selectRange(this.getStartPosition(), n2);
    }

    @Override
    public void updateEndTo(int n2, int n3) {
        this.selectRange(this.getStartPosition(), this.textPosition(n2, n3));
    }

    @Override
    public void updateEndByBreaksForward(int n2, BreakIterator breakIterator) {
        this.updateEndByBreaks(n2, breakIterator, true);
    }

    @Override
    public void updateEndByBreaksBackward(int n2, BreakIterator breakIterator) {
        this.updateEndByBreaks(n2, breakIterator, false);
    }

    @Override
    public void selectAll() {
        this.selectRange(0, this.area.getLength());
    }

    @Override
    public void selectParagraph(int n2) {
        int n3 = this.textPosition(n2, 0);
        int n4 = n3 + this.area.getParagraphLength(n2);
        this.selectRange(n3, n4);
    }

    @Override
    public void selectWord(int n2) {
        if (this.area.getLength() == 0) {
            return;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(this.area.getText());
        breakIterator.preceding(n2);
        breakIterator.next();
        int n3 = breakIterator.current();
        breakIterator.following(n2);
        breakIterator.next();
        int n4 = breakIterator.current();
        this.selectRange(n3, n4);
    }

    @Override
    public void configureSelectionPath(SelectionPath selectionPath) {
        this.configurePath.accept(selectionPath);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(SelectionImpl<PS, SEG, S> selectionImpl) {
        return Integer.compare(this.hashCode(), selectionImpl.hashCode());
    }

    public String toString() {
        return String.format("SelectionImpl(name=%s startPar=%s startCol=%s endPar=%s endCol=%s paragraphSpan=%s selectedDocument=%s", this.name, this.getStartParagraphIndex(), this.getStartColumnPosition(), this.getEndParagraphIndex(), this.getEndColumnPosition(), this.getParagraphSpan(), this.getSelectedDocument());
    }

    @Override
    public void dispose() {
        this.subscription.unsubscribe();
    }

    private <T> void manageSubscription(EventStream<T> eventStream, Consumer<T> consumer) {
        this.manageSubscription(eventStream.subscribe(consumer));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscription = this.subscription.and(subscription);
    }

    private IndexRange getParagraphSelection(int n2) {
        int n3 = this.getStartParagraphIndex();
        int n4 = this.getEndParagraphIndex();
        if (n2 < n3 || n2 > n4) {
            return GenericStyledArea.EMPTY_RANGE;
        }
        int n5 = n2 == n3 ? this.getStartColumnPosition() : 0;
        int n6 = n2 == n4 ? this.getEndColumnPosition() : this.area.getParagraphLength(n2) + 1;
        return new IndexRange(n5, n6);
    }

    private TwoDimensional.Position position(int n2, int n3) {
        return this.area.position(n2, n3);
    }

    private int textPosition(int n2, int n3) {
        return this.position(n2, n3).toOffset();
    }

    private void moveBoundary(Selection.Direction direction, int n3, int n4, Function<Integer, IndexRange> function) {
        switch (direction) {
            case LEFT: {
                this.moveBoundary(() -> n4 - n3, n2 -> 0 <= n2, function);
                break;
            }
            default: {
                this.moveBoundary(() -> n4 + n3, n2 -> n2 <= this.area.getLength(), function);
            }
        }
    }

    private void moveBoundary(IntSupplier intSupplier, Function<Integer, Boolean> function, Function<Integer, IndexRange> function2) {
        int n2 = intSupplier.getAsInt();
        if (function.apply(n2).booleanValue()) {
            this.selectRange(function2.apply(n2));
        }
    }

    private void updateStartByBreaks(int n2, BreakIterator breakIterator, boolean bl) {
        this.updateSelectionByBreaks(n2, breakIterator, bl, true);
    }

    private void updateEndByBreaks(int n2, BreakIterator breakIterator, boolean bl) {
        this.updateSelectionByBreaks(n2, breakIterator, bl, false);
    }

    private void updateSelectionByBreaks(int n2, BreakIterator breakIterator, boolean bl, boolean bl2) {
        Runnable runnable;
        int n3;
        if (this.area.getLength() == 0) {
            return;
        }
        breakIterator.setText(this.area.getText());
        if (bl2) {
            n3 = this.getStartPosition();
            runnable = () -> this.selectRange(breakIterator.current(), this.getEndPosition());
        } else {
            n3 = this.getEndPosition();
            runnable = () -> this.selectRange(this.getStartPosition(), breakIterator.current());
        }
        if (bl) {
            breakIterator.following(n3);
        } else {
            breakIterator.preceding(n3);
        }
        breakIterator.next(n2);
        runnable.run();
    }
}

