/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import org.fxmisc.richtext.BackgroundPath;
import org.fxmisc.richtext.BorderPath;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.JavaFXCompatibility;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.TextFlowExt;
import org.fxmisc.richtext.UnderlinePath;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;

class ParagraphText<PS, SEG, S>
extends TextFlowExt {
    private final ObservableSet<CaretNode> carets = FXCollections.observableSet(new HashSet(1));
    private final ObservableMap<Selection<PS, SEG, S>, SelectionPath> selections = FXCollections.observableMap(new HashMap(1));
    private final MapChangeListener<? super Selection<PS, SEG, S>, ? super SelectionPath> selectionPathListener;
    private final SetChangeListener<? super CaretNode> caretNodeListener;
    private final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty((Object)Color.WHITE);
    private final Paragraph<PS, SEG, S> paragraph;
    private final CustomCssShapeHelper<Paint> backgroundShapeHelper;
    private final CustomCssShapeHelper<BorderAttributes> borderShapeHelper;
    private final CustomCssShapeHelper<UnderlineAttributes> underlineShapeHelper;
    private int selectionShapeStartIndex = 0;

    public final ObservableSet<CaretNode> caretsProperty() {
        return this.carets;
    }

    public final ObservableMap<Selection<PS, SEG, S>, SelectionPath> selectionsProperty() {
        return this.selections;
    }

    public ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    ParagraphText(Paragraph<PS, SEG, S> paragraph, Function<StyledSegment<SEG, S>, Node> function) {
        this.paragraph = paragraph;
        this.getStyleClass().add((Object)"paragraph-text");
        Val<Double> val = Val.map(this.insetsProperty(), Insets::getLeft);
        Val<Double> val2 = Val.map(this.insetsProperty(), Insets::getTop);
        ChangeListener changeListener = (observableValue, indexRange, indexRange2) -> this.requestLayout();
        this.selectionPathListener = change -> {
            SelectionPath selectionPath;
            if (change.wasRemoved()) {
                selectionPath = (SelectionPath)((Object)((Object)change.getValueRemoved()));
                selectionPath.rangeProperty().removeListener((ChangeListener<IndexRange>)changeListener);
                selectionPath.layoutXProperty().unbind();
                selectionPath.layoutYProperty().unbind();
                this.getChildren().remove((Object)selectionPath);
            }
            if (change.wasAdded()) {
                selectionPath = (SelectionPath)((Object)((Object)change.getValueAdded()));
                selectionPath.rangeProperty().addListener((ChangeListener<IndexRange>)changeListener);
                selectionPath.layoutXProperty().bind((ObservableValue)val);
                selectionPath.layoutYProperty().bind((ObservableValue)val2);
                this.getChildren().add(this.selectionShapeStartIndex, (Object)selectionPath);
                this.updateSingleSelection(selectionPath);
            }
        };
        this.selections.addListener(this.selectionPathListener);
        ChangeListener changeListener2 = (observableValue, n2, n3) -> this.requestLayout();
        this.caretNodeListener = change -> {
            CaretNode caretNode;
            if (change.wasRemoved()) {
                caretNode = (CaretNode)change.getElementRemoved();
                caretNode.columnPositionProperty().removeListener(changeListener2);
                caretNode.layoutXProperty().unbind();
                caretNode.layoutYProperty().unbind();
                this.getChildren().remove((Object)caretNode);
            }
            if (change.wasAdded()) {
                caretNode = (CaretNode)change.getElementAdded();
                caretNode.columnPositionProperty().addListener(changeListener2);
                caretNode.layoutXProperty().bind((ObservableValue)val);
                caretNode.layoutYProperty().bind((ObservableValue)val2);
                this.getChildren().add((Object)caretNode);
                this.updateSingleCaret(caretNode);
            }
        };
        this.carets.addListener(this.caretNodeListener);
        paragraph.getStyledSegments().stream().map(function).forEach(node -> {
            if (node instanceof TextExt) {
                TextExt textExt = (TextExt)((Object)node);
                JavaFXCompatibility.Text_selectionFillProperty(textExt).bind((ObservableValue)textExt.fillProperty());
            }
            this.getChildren().add(node);
        });
        UnaryOperator unaryOperator = path -> {
            path.setManaged(false);
            path.layoutXProperty().bind((ObservableValue)val);
            path.layoutYProperty().bind((ObservableValue)val2);
            return path;
        };
        Supplier<Path> supplier = () -> (Path)unaryOperator.apply(new BackgroundPath());
        Supplier<Path> supplier2 = () -> (Path)unaryOperator.apply(new BorderPath());
        Supplier<Path> supplier3 = () -> (Path)unaryOperator.apply(new UnderlinePath());
        Consumer<Collection<Path>> consumer = collection -> this.getChildren().removeAll(collection);
        Consumer<Path> consumer2 = path -> this.getChildren().add(0, path);
        Consumer<Path> consumer3 = consumer2.andThen(path -> ++this.selectionShapeStartIndex);
        Consumer<Path> consumer4 = path -> this.getChildren().add(path);
        this.backgroundShapeHelper = new CustomCssShapeHelper(supplier, (path, tuple2) -> {
            path.setStrokeWidth(0.0);
            path.setFill((Paint)tuple2._1);
            path.getElements().setAll((Object[])this.getRangeShape((IndexRange)tuple2._2));
        }, consumer3, consumer);
        this.borderShapeHelper = new CustomCssShapeHelper(supplier2, (path, tuple2) -> {
            BorderAttributes borderAttributes = (BorderAttributes)tuple2._1;
            path.setStrokeWidth(borderAttributes.width);
            path.setStroke(borderAttributes.color);
            if (borderAttributes.type != null) {
                path.setStrokeType(borderAttributes.type);
            }
            if (borderAttributes.dashArray != null) {
                path.getStrokeDashArray().setAll((Object[])borderAttributes.dashArray);
            }
            path.getElements().setAll((Object[])this.getRangeShape((IndexRange)tuple2._2));
        }, consumer2, consumer);
        this.underlineShapeHelper = new CustomCssShapeHelper(supplier3, (path, tuple2) -> {
            UnderlineAttributes underlineAttributes = (UnderlineAttributes)tuple2._1;
            path.setStroke(underlineAttributes.color);
            path.setStrokeWidth(underlineAttributes.width);
            path.setStrokeLineCap(underlineAttributes.cap);
            if (underlineAttributes.dashArray != null) {
                path.getStrokeDashArray().setAll((Object[])underlineAttributes.dashArray);
            }
            path.getElements().setAll((Object[])this.getUnderlineShape((IndexRange)tuple2._2));
        }, consumer4, consumer);
    }

    void dispose() {
        this.selections.removeListener(this.selectionPathListener);
        this.carets.removeListener(this.caretNodeListener);
        this.selections.clear();
        this.carets.clear();
    }

    public Paragraph<PS, SEG, S> getParagraph() {
        return this.paragraph;
    }

    public <T extends Node> double getCaretOffsetX(T t2) {
        this.layout();
        this.checkWithinParagraph(t2);
        Bounds bounds = t2.getLayoutBounds();
        return (bounds.getMinX() + bounds.getMaxX()) / 2.0;
    }

    public <T extends Node> Bounds getCaretBounds(T t2) {
        this.layout();
        this.checkWithinParagraph(t2);
        return t2.getBoundsInParent();
    }

    public <T extends Node> Bounds getCaretBoundsOnScreen(T t2) {
        this.layout();
        this.checkWithinParagraph(t2);
        Bounds bounds = t2.getBoundsInLocal();
        return t2.localToScreen(bounds);
    }

    public Bounds getRangeBoundsOnScreen(int n2, int n3) {
        this.layout();
        Object[] objectArray = this.getRangeShapeSafely(n2, n3);
        Path path = new Path();
        path.setManaged(false);
        path.setLayoutX(this.getInsets().getLeft());
        path.setLayoutY(this.getInsets().getTop());
        this.getChildren().add((Object)path);
        path.getElements().setAll(objectArray);
        Bounds bounds = path.getBoundsInLocal();
        Bounds bounds2 = path.localToScreen(bounds);
        this.getChildren().remove((Object)path);
        return bounds2;
    }

    public Optional<Bounds> getSelectionBoundsOnScreen(Selection<PS, SEG, S> selection) {
        if (selection.getLength() == 0) {
            return Optional.empty();
        }
        this.layout();
        SelectionPath selectionPath = (SelectionPath)((Object)this.selections.get(selection));
        this.checkWithinParagraph(selectionPath);
        Bounds bounds = selectionPath.getBoundsInLocal();
        return Optional.ofNullable(selectionPath.localToScreen(bounds));
    }

    public int getCurrentLineStartPosition(Caret caret) {
        return this.getLineStartPosition(this.getClampedCaretPosition(caret));
    }

    public int getCurrentLineEndPosition(Caret caret) {
        return this.getLineEndPosition(this.getClampedCaretPosition(caret));
    }

    public int currentLineIndex(Caret caret) {
        return this.getLineOfCharacter(this.getClampedCaretPosition(caret));
    }

    public int currentLineIndex(int n2) {
        return this.getLineOfCharacter(n2);
    }

    private <T extends Node> void checkWithinParagraph(T t2) {
        if (t2.getParent() != this) {
            throw new IllegalArgumentException(String.format("This ParagraphText is not the parent of the given shape (%s):\nExpected: %s\nActual:   %s", new Object[]{t2, this, t2.getParent()}));
        }
    }

    private int getClampedCaretPosition(Caret caret) {
        return Math.min(caret.getColumnPosition(), this.paragraph.length());
    }

    private void updateAllCaretShapes() {
        this.carets.forEach(this::updateSingleCaret);
    }

    private void updateSingleCaret(CaretNode caretNode) {
        Object[] objectArray = this.getCaretShape(this.getClampedCaretPosition(caretNode), true);
        caretNode.getElements().setAll(objectArray);
    }

    private void updateAllSelectionShapes() {
        this.selections.values().forEach(this::updateSingleSelection);
    }

    private void updateSingleSelection(SelectionPath selectionPath) {
        selectionPath.getElements().setAll((Object[])this.getRangeShapeSafely((IndexRange)selectionPath.rangeProperty().getValue()));
    }

    private PathElement[] getRangeShapeSafely(IndexRange indexRange) {
        return this.getRangeShapeSafely(indexRange.getStart(), indexRange.getEnd());
    }

    private PathElement[] getRangeShapeSafely(int n2, int n3) {
        int n4;
        int n5;
        PathElement[] pathElementArray;
        if (n3 <= this.paragraph.length()) {
            pathElementArray = this.getRangeShape(n2, n3);
        } else if (this.paragraph.length() == 0) {
            pathElementArray = this.createRectangle(0.0, 0.0, this.getWidth(), this.getHeight());
        } else if (n2 == this.paragraph.length()) {
            pathElementArray = this.getRangeShape(n2 - 1, n2);
            LineTo lineTo = (LineTo)pathElementArray[pathElementArray.length - 4];
            pathElementArray = this.createRectangle(lineTo.getX(), lineTo.getY(), this.getWidth(), this.getHeight());
        } else {
            pathElementArray = this.getRangeShape(n2, this.paragraph.length());
            int n6 = pathElementArray.length;
            if (n6 > 3) {
                n5 = n6 - 3;
                n4 = n5 - 1;
                LineTo lineTo = (LineTo)pathElementArray[n4];
                pathElementArray[n4] = new LineTo(this.getWidth(), lineTo.getY());
                pathElementArray[n5] = new LineTo(this.getWidth(), this.getHeight());
            }
        }
        if (this.getLineCount() > 1) {
            boolean bl = n3 > 0 && this.getLineOfCharacter(n3) > this.getLineOfCharacter(n3 - 1);
            n5 = pathElementArray.length - (bl ? 0 : 5);
            for (n4 = 0; n4 < n5; ++n4) {
                if (!(pathElementArray[n4] instanceof MoveTo)) continue;
                ((LineTo)pathElementArray[n4 + 1]).setX(this.getWidth());
                ((LineTo)pathElementArray[n4 + 2]).setX(this.getWidth());
            }
        }
        return pathElementArray;
    }

    private PathElement[] createRectangle(double d2, double d3, double d4, double d5) {
        return new PathElement[]{new MoveTo(d2, d3), new LineTo(d4, d3), new LineTo(d4, d5), new LineTo(d2, d5), new LineTo(d2, d3)};
    }

    private void updateBackgroundShapes() {
        int n2 = 0;
        for (Node node : this.getManagedChildren()) {
            UnderlineAttributes underlineAttributes;
            BorderAttributes borderAttributes;
            if (!(node instanceof TextExt)) {
                ++n2;
                continue;
            }
            TextExt textExt = (TextExt)node;
            int n3 = n2 + textExt.getText().length();
            Paint paint = textExt.getBackgroundColor();
            if (paint != null) {
                ((CustomCssShapeHelper)this.backgroundShapeHelper).updateSharedShapeRange(paint, n2, n3, Object::equals);
            }
            if (!(borderAttributes = new BorderAttributes(textExt)).isNullValue()) {
                ((CustomCssShapeHelper)this.borderShapeHelper).updateSharedShapeRange(borderAttributes, n2, n3, BorderAttributes::equalsFaster);
            }
            if (!(underlineAttributes = new UnderlineAttributes(textExt)).isNullValue()) {
                ((CustomCssShapeHelper)this.underlineShapeHelper).updateSharedShapeRange(underlineAttributes, n2, n3, UnderlineAttributes::equalsFaster);
            }
            n2 = n3;
        }
        ((CustomCssShapeHelper)this.borderShapeHelper).updateSharedShapes();
        ((CustomCssShapeHelper)this.backgroundShapeHelper).updateSharedShapes();
        ((CustomCssShapeHelper)this.underlineShapeHelper).updateSharedShapes();
    }

    public String toString() {
        return String.format("ParagraphText@%s(paragraph=%s)", ((Object)((Object)this)).hashCode(), this.paragraph);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.updateAllCaretShapes();
        this.updateAllSelectionShapes();
        this.updateBackgroundShapes();
    }

    private static class LineAttributesBase {
        final double width;
        final Paint color;
        final Double[] dashArray;

        public final boolean isNullValue() {
            return this.color == null || this.width == -1.0;
        }

        LineAttributesBase(Paint paint, Number number, ObjectProperty<Number[]> objectProperty) {
            this.color = paint;
            if (paint == null || number == null || number.doubleValue() <= 0.0) {
                this.width = -1.0;
                this.dashArray = null;
            } else {
                this.width = number.doubleValue();
                Object object = objectProperty.get();
                if (object != null) {
                    if (object.getClass().isArray()) {
                        Number[] numberArray = (Number[])object;
                        this.dashArray = new Double[numberArray.length];
                        int n2 = 0;
                        for (Number number2 : numberArray) {
                            this.dashArray[n2++] = (Double)number2;
                        }
                    } else {
                        this.dashArray = new Double[1];
                        this.dashArray[0] = (double)((Double)object);
                    }
                } else {
                    this.dashArray = null;
                }
            }
        }

        public boolean equalsFaster(LineAttributesBase lineAttributesBase) {
            return Objects.equals(this.width, lineAttributesBase.width) && Objects.equals(this.color, lineAttributesBase.color) && Arrays.equals((Object[])this.dashArray, (Object[])lineAttributesBase.dashArray);
        }

        public boolean equals(Object object) {
            if (object instanceof LineAttributesBase) {
                LineAttributesBase lineAttributesBase = (LineAttributesBase)object;
                return this.equalsFaster(lineAttributesBase);
            }
            return false;
        }

        protected final String getSubString() {
            return String.format("width=%s color=%s dashArray=%s", this.width, this.color, Arrays.toString((Object[])this.dashArray));
        }
    }

    private static class UnderlineAttributes
    extends LineAttributesBase {
        final StrokeLineCap cap;

        UnderlineAttributes(TextExt textExt) {
            super(textExt.getUnderlineColor(), textExt.getUnderlineWidth(), textExt.underlineDashArrayProperty());
            this.cap = textExt.getUnderlineCap();
        }

        public boolean equalsFaster(UnderlineAttributes underlineAttributes) {
            return super.equalsFaster(underlineAttributes) && Objects.equals(this.cap, underlineAttributes.cap);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof UnderlineAttributes) {
                UnderlineAttributes underlineAttributes = (UnderlineAttributes)object;
                return this.equalsFaster(underlineAttributes);
            }
            return false;
        }

        public String toString() {
            return String.format("UnderlineAttributes[cap=%s %s]", this.cap, this.getSubString());
        }
    }

    private static class BorderAttributes
    extends LineAttributesBase {
        final StrokeType type;

        BorderAttributes(TextExt textExt) {
            super(textExt.getBorderStrokeColor(), textExt.getBorderStrokeWidth(), textExt.borderStrokeDashArrayProperty());
            this.type = textExt.getBorderStrokeType();
        }

        public boolean equalsFaster(BorderAttributes borderAttributes) {
            return super.equalsFaster(borderAttributes) && Objects.equals(this.type, borderAttributes.type);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof BorderAttributes) {
                BorderAttributes borderAttributes = (BorderAttributes)object;
                return this.equalsFaster(borderAttributes);
            }
            return false;
        }

        public String toString() {
            return String.format("BorderAttributes[type=%s %s]", this.type, this.getSubString());
        }
    }

    private static class CustomCssShapeHelper<T> {
        private final List<Tuple2<T, IndexRange>> ranges = new LinkedList<Tuple2<T, IndexRange>>();
        private final List<Path> shapes = new LinkedList<Path>();
        private final Supplier<Path> createShape;
        private final BiConsumer<Path, Tuple2<T, IndexRange>> configureShape;
        private final Consumer<Path> addToChildren;
        private final Consumer<Collection<Path>> clearUnusedShapes;

        CustomCssShapeHelper(Supplier<Path> supplier, BiConsumer<Path, Tuple2<T, IndexRange>> biConsumer, Consumer<Path> consumer, Consumer<Collection<Path>> consumer2) {
            this.createShape = supplier;
            this.configureShape = biConsumer;
            this.addToChildren = consumer;
            this.clearUnusedShapes = consumer2;
        }

        private void updateSharedShapeRange(T t2, int n2, int n3, BiFunction<T, T, Boolean> biFunction) {
            Runnable runnable = () -> this.ranges.add(Tuples.t(t2, new IndexRange(n2, n3)));
            if (this.ranges.isEmpty()) {
                runnable.run();
            } else {
                int n4 = this.ranges.size() - 1;
                Tuple2<T, IndexRange> tuple2 = this.ranges.get(n4);
                Object a2 = tuple2._1;
                int n5 = tuple2.get2().getEnd();
                if (n2 == n5 && biFunction.apply(a2, t2).booleanValue()) {
                    IndexRange indexRange = (IndexRange)tuple2._2;
                    IndexRange indexRange2 = new IndexRange(indexRange.getStart(), n3);
                    this.ranges.set(n4, Tuples.t(a2, indexRange2));
                } else {
                    runnable.run();
                }
            }
        }

        private void updateSharedShapes() {
            int n2;
            int n3 = this.ranges.size();
            if (n3 < (n2 = this.shapes.size())) {
                List<Path> list = this.shapes.subList(n3, n2);
                this.clearUnusedShapes.accept(list);
                list.clear();
            } else if (n2 < n3) {
                for (int i2 = 0; i2 < n3 - n2; ++i2) {
                    Path path = this.createShape.get();
                    this.shapes.add(path);
                    this.addToChildren.accept(path);
                }
            }
            for (int i3 = 0; i3 < this.ranges.size(); ++i3) {
                this.configureShape.accept(this.shapes.get(i3), this.ranges.get(i3));
            }
            this.ranges.clear();
        }
    }
}

