/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.ParagraphText;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.event.MouseStationaryHelper;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.EventStream;
import org.reactfx.util.Either;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class ParagraphBox<PS, SEG, S>
extends Region {
    private final ParagraphText<PS, SEG, S> text;
    private final ObjectProperty<IntFunction<? extends Node>> graphicFactory = new SimpleObjectProperty(null);
    private final Val<Node> graphic;
    final DoubleProperty graphicOffset = new SimpleDoubleProperty(0.0);
    private final BooleanProperty wrapText = new SimpleBooleanProperty(false);
    private final Var<Integer> index;

    public ObjectProperty<IntFunction<? extends Node>> graphicFactoryProperty() {
        return this.graphicFactory;
    }

    public BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public Val<Integer> indexProperty() {
        return this.index;
    }

    public void setIndex(int n2) {
        this.index.setValue(n2);
    }

    public int getIndex() {
        return (Integer)this.index.getValue();
    }

    public final ObservableSet<CaretNode> caretsProperty() {
        return this.text.caretsProperty();
    }

    public final ObservableMap<Selection<PS, SEG, S>, SelectionPath> selectionsProperty() {
        return this.text.selectionsProperty();
    }

    ParagraphBox(Paragraph<PS, SEG, S> paragraph, BiConsumer<TextFlow, PS> biConsumer, Function<StyledSegment<SEG, S>, Node> function) {
        this.wrapText.addListener((observableValue, bl, bl2) -> this.requestLayout());
        this.getStyleClass().add((Object)"paragraph-box");
        this.text = new ParagraphText<PS, SEG, S>(paragraph, function);
        biConsumer.accept(this.text, paragraph.getParagraphStyle());
        this.index = Var.newSimpleVar(-1);
        this.getChildren().add(this.text);
        this.graphic = Val.combine(this.graphicFactory, this.index, (intFunction, n2) -> intFunction != null ? (Node)intFunction.apply((int)n2) : null);
        this.graphic.addListener((ChangeListener<Node>)((ChangeListener)(observableValue, node, node2) -> {
            if (node != null) {
                this.getChildren().remove(node);
            }
            if (node2 != null) {
                this.getChildren().add(node2);
            }
        }));
        this.graphicOffset.addListener(observable -> this.requestLayout());
    }

    void dispose() {
        this.text.dispose();
    }

    public String toString() {
        return String.format("ParagraphBox@%s[%s|%s]", ((Object)((Object)this)).hashCode(), this.graphic.isPresent() ? "#" : "", this.text.getParagraph());
    }

    public Property<Paint> highlightTextFillProperty() {
        return this.text.highlightTextFillProperty();
    }

    Paragraph<PS, SEG, S> getParagraph() {
        return this.text.getParagraph();
    }

    public EventStream<Either<Tuple2<Point2D, Integer>, Object>> stationaryIndices(Duration duration) {
        EventStream<Either<Point2D, Void>> eventStream = new MouseStationaryHelper((Node)this).events(duration);
        EventStream<Void> eventStream2 = eventStream.filterMap(Either::asLeft).filterMap(point2D -> {
            OptionalInt optionalInt = this.hit((Point2D)point2D).getCharacterIndex();
            if (optionalInt.isPresent()) {
                return Optional.of(Tuples.t(point2D, optionalInt.getAsInt()));
            }
            return Optional.empty();
        });
        EventStream<Void> eventStream3 = eventStream.filter(Either::isRight).map(Either::getRight);
        return eventStream2.or(eventStream3);
    }

    public CharacterHit hit(Point2D point2D) {
        return this.hit(point2D.getX(), point2D.getY());
    }

    public CharacterHit hit(double d2, double d3) {
        Point2D point2D = this.localToScreen(d2, d3);
        Point2D point2D2 = this.text.screenToLocal(point2D);
        Insets insets = this.text.getInsets();
        return this.text.hit(point2D2.getX() - insets.getLeft(), point2D2.getY() - insets.getTop());
    }

    public <T extends Node> CaretOffsetX getCaretOffsetX(T t2) {
        this.layout();
        return new CaretOffsetX(this.text.getCaretOffsetX(t2));
    }

    public int getCurrentLineStartPosition(Caret caret) {
        this.layout();
        return this.text.getCurrentLineStartPosition(caret);
    }

    public int getCurrentLineEndPosition(Caret caret) {
        this.layout();
        return this.text.getCurrentLineEndPosition(caret);
    }

    public int getLineCount() {
        this.layout();
        return this.text.getLineCount();
    }

    public int getCurrentLineIndex(Caret caret) {
        this.layout();
        return this.text.currentLineIndex(caret);
    }

    public int getCurrentLineIndex(int n2) {
        this.layout();
        return this.text.currentLineIndex(n2);
    }

    public <T extends Node> Bounds getCaretBounds(T t2) {
        this.layout();
        Bounds bounds = this.text.getCaretBounds(t2);
        return this.text.localToParent(bounds);
    }

    public <T extends Node> Bounds getCaretBoundsOnScreen(T t2) {
        this.layout();
        return this.text.getCaretBoundsOnScreen(t2);
    }

    public Optional<Bounds> getSelectionBoundsOnScreen(Selection<PS, SEG, S> selection) {
        this.layout();
        return this.text.getSelectionBoundsOnScreen(selection);
    }

    public Bounds getRangeBoundsOnScreen(int n2, int n3) {
        this.layout();
        return this.text.getRangeBoundsOnScreen(n2, n3);
    }

    protected double computeMinWidth(double d2) {
        return this.computePrefWidth(-1.0);
    }

    protected double computePrefWidth(double d2) {
        Insets insets = this.getInsets();
        return this.wrapText.get() ? 0.0 : this.getGraphicPrefWidth() + this.text.prefWidth(-1.0) + insets.getLeft() + insets.getRight();
    }

    protected double computePrefHeight(double d2) {
        Insets insets = this.getInsets();
        double d3 = this.getGraphicPrefWidth() + insets.getLeft() + insets.getRight();
        return this.text.prefHeight(d2 - d3) + insets.getTop() + insets.getBottom();
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double d2 = this.getWidth() - insets.getLeft() - insets.getRight();
        double d3 = this.getHeight() - insets.getTop() - insets.getBottom();
        double d4 = this.getGraphicPrefWidth();
        this.text.resizeRelocate(d4 + insets.getLeft(), insets.getTop(), d2 - d4, d3);
        this.graphic.ifPresent(node -> node.resizeRelocate(this.graphicOffset.get() + insets.getLeft(), insets.getTop(), d4, d3));
    }

    double getGraphicPrefWidth() {
        if (this.graphic.isPresent()) {
            return ((Node)this.graphic.getValue()).prefWidth(-1.0);
        }
        return 0.0;
    }

    CharacterHit hitTextLine(CaretOffsetX caretOffsetX, int n2) {
        return this.text.hitLine(caretOffsetX.value, n2);
    }

    CharacterHit hitText(CaretOffsetX caretOffsetX, double d2) {
        return this.text.hit(caretOffsetX.value, d2);
    }

    public static class CaretOffsetX {
        private final double value;

        private CaretOffsetX(double d2) {
            this.value = d2;
        }
    }
}

