/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import org.fxmisc.richtext.TextEditingArea;

public interface NavigationActions<PS, SEG, S>
extends TextEditingArea<PS, SEG, S> {
    default public void moveTo(int n2) {
        this.getCaretSelectionBind().moveTo(n2);
    }

    default public void moveTo(int n2, int n3) {
        this.getCaretSelectionBind().moveTo(n2, n3);
    }

    default public void moveTo(int n2, SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveTo(n2, selectionPolicy);
    }

    default public void moveTo(int n2, int n3, SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveTo(n2, n3, selectionPolicy);
    }

    default public void previousChar(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToPrevChar(selectionPolicy);
    }

    default public void nextChar(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToNextChar(selectionPolicy);
    }

    default public void wordBreaksBackwards(int n2, SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(this.getText());
        breakIterator.preceding(this.getCaretPosition());
        for (int i2 = 1; i2 < n2; ++i2) {
            breakIterator.previous();
        }
        this.moveTo(breakIterator.current(), selectionPolicy);
    }

    default public void wordBreaksForwards(int n2, SelectionPolicy selectionPolicy) {
        if (this.getLength() == 0) {
            return;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(this.getText());
        breakIterator.following(this.getCaretPosition());
        for (int i2 = 1; i2 < n2; ++i2) {
            breakIterator.next();
        }
        this.moveTo(breakIterator.current(), selectionPolicy);
    }

    default public void selectWord() {
        this.getCaretSelectionBind().selectWord();
    }

    default public void paragraphStart(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToParStart(selectionPolicy);
    }

    default public void paragraphEnd(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToParEnd(selectionPolicy);
    }

    default public void start(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToAreaStart(selectionPolicy);
    }

    default public void end(SelectionPolicy selectionPolicy) {
        this.getCaretSelectionBind().moveToAreaEnd(selectionPolicy);
    }

    default public void selectParagraph() {
        this.getCaretSelectionBind().selectParagraph();
    }

    default public void selectAll() {
        this.getCaretSelectionBind().selectAll();
    }

    default public void deselect() {
        this.getCaretSelectionBind().deselect();
    }

    public static enum SelectionPolicy {
        CLEAR,
        ADJUST,
        EXTEND;

    }
}

