/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.StyledDocument;

public class MultiChangeBuilder<PS, SEG, S> {
    private final GenericStyledArea<PS, SEG, S> area;
    private final List<Replacement<PS, SEG, S>> list;
    private boolean alreadyCreated = false;

    MultiChangeBuilder(GenericStyledArea<PS, SEG, S> genericStyledArea) {
        this(genericStyledArea, new ArrayList<Replacement<PS, SEG, S>>());
    }

    MultiChangeBuilder(GenericStyledArea<PS, SEG, S> genericStyledArea, int n2) {
        this(genericStyledArea, new ArrayList<Replacement<PS, SEG, S>>(n2));
    }

    private MultiChangeBuilder(GenericStyledArea<PS, SEG, S> genericStyledArea, List<Replacement<PS, SEG, S>> list) {
        this.area = genericStyledArea;
        this.list = list;
    }

    public MultiChangeBuilder<PS, SEG, S> insertText(int n2, String string) {
        return this.replaceText(n2, n2, string);
    }

    public MultiChangeBuilder<PS, SEG, S> insertTextAbsolutely(int n2, String string) {
        return this.replaceTextAbsolutely(n2, n2, string);
    }

    public MultiChangeBuilder<PS, SEG, S> insertText(int n2, int n3, String string) {
        int n4 = this.area.getAbsolutePosition(n2, n3);
        return this.replaceText(n4, n4, string);
    }

    public MultiChangeBuilder<PS, SEG, S> insertTextAbsolutely(int n2, int n3, String string) {
        int n4 = this.area.getAbsolutePosition(n2, n3);
        return this.replaceTextAbsolutely(n4, n4, string);
    }

    public MultiChangeBuilder<PS, SEG, S> insert(int n2, StyledDocument<PS, SEG, S> styledDocument) {
        return this.replace(n2, n2, styledDocument);
    }

    public MultiChangeBuilder<PS, SEG, S> insertAbsolutely(int n2, StyledDocument<PS, SEG, S> styledDocument) {
        return this.replaceAbsolutely(n2, n2, styledDocument);
    }

    public MultiChangeBuilder<PS, SEG, S> insert(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        int n4 = this.area.getAbsolutePosition(n2, n3);
        return this.replace(n4, n4, styledDocument);
    }

    public MultiChangeBuilder<PS, SEG, S> insertAbsolutely(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        int n4 = this.area.getAbsolutePosition(n2, n3);
        return this.replaceAbsolutely(n4, n4, styledDocument);
    }

    public MultiChangeBuilder<PS, SEG, S> deleteText(IndexRange indexRange) {
        return this.deleteText(indexRange.getStart(), indexRange.getEnd());
    }

    public MultiChangeBuilder<PS, SEG, S> deleteTextAbsolutely(IndexRange indexRange) {
        return this.deleteTextAbsolutely(indexRange.getStart(), indexRange.getEnd());
    }

    public MultiChangeBuilder<PS, SEG, S> deleteText(int n2, int n3) {
        return this.replaceText(n2, n3, "");
    }

    public MultiChangeBuilder<PS, SEG, S> deleteTextAbsolutely(int n2, int n3) {
        return this.replaceTextAbsolutely(n2, n3, "");
    }

    public MultiChangeBuilder<PS, SEG, S> deleteText(int n2, int n3, int n4, int n5) {
        int n6 = this.area.getAbsolutePosition(n2, n3);
        int n7 = this.area.getAbsolutePosition(n4, n5);
        return this.replaceText(n6, n7, "");
    }

    public MultiChangeBuilder<PS, SEG, S> deleteTextAbsolutely(int n2, int n3, int n4, int n5) {
        int n6 = this.area.getAbsolutePosition(n2, n3);
        int n7 = this.area.getAbsolutePosition(n4, n5);
        return this.replaceTextAbsolutely(n6, n7, "");
    }

    public MultiChangeBuilder<PS, SEG, S> replaceText(int n2, int n3, String string) {
        return this.relativeReplace(n2, n3, ReadOnlyStyledDocument.fromString(string, this.area.getInitialParagraphStyle(), this.area.getInitialTextStyle(), this.area.getSegOps()));
    }

    public MultiChangeBuilder<PS, SEG, S> replaceTextAbsolutely(int n2, int n3, String string) {
        return this.absoluteReplace(n2, n3, ReadOnlyStyledDocument.fromString(string, this.area.getInitialParagraphStyle(), this.area.getInitialTextStyle(), this.area.getSegOps()));
    }

    public MultiChangeBuilder<PS, SEG, S> replace(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        return this.relativeReplace(n2, n3, ReadOnlyStyledDocument.from(styledDocument));
    }

    public MultiChangeBuilder<PS, SEG, S> replaceAbsolutely(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        return this.absoluteReplace(n2, n3, ReadOnlyStyledDocument.from(styledDocument));
    }

    public final void commit() {
        this.ensureNotYetCreated();
        this.ensureHasChanges();
        this.alreadyCreated = true;
        this.area.replaceMulti(Collections.unmodifiableList(this.list));
    }

    private MultiChangeBuilder<PS, SEG, S> relativeReplace(int n2, int n3, ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument) {
        if (this.list.isEmpty()) {
            return this.absoluteReplace(n2, n3, readOnlyStyledDocument);
        }
        int n4 = n2;
        int n5 = n3;
        for (Replacement<PS, SEG, S> replacement : this.list) {
            if (replacement.getStart() <= n4) {
                n4 += replacement.getNetLength();
                if (replacement.getEnd() > n5) continue;
                n5 += replacement.getNetLength();
                continue;
            }
            if (replacement.getEnd() > n5) continue;
            n5 += replacement.getNetLength();
        }
        return this.absoluteReplace(n4, n5, readOnlyStyledDocument);
    }

    private MultiChangeBuilder<PS, SEG, S> absoluteReplace(int n2, int n3, ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument) {
        this.list.add(new Replacement<PS, SEG, S>(n2, n3, readOnlyStyledDocument));
        return this;
    }

    private void ensureNotYetCreated() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("Cannot reuse a builder multiple times");
        }
    }

    private void ensureHasChanges() {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("Cannot commit multiple changes since none have been added");
        }
    }
}

