/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.IntFunction;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fxmisc.richtext.GenericStyledArea;
import org.reactfx.collection.LiveList;
import org.reactfx.value.Val;

public class LineNumberFactory
implements IntFunction<Node> {
    private static final Insets DEFAULT_INSETS = new Insets(0.0, 5.0, 0.0, 5.0);
    private static final Paint DEFAULT_TEXT_FILL = Color.web((String)"#666");
    private static final Background DEFAULT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#ddd"), null, null)});
    private final Val<Integer> nParagraphs;
    private final IntFunction<String> format;

    public static IntFunction<Node> get(GenericStyledArea<?, ?, ?> genericStyledArea) {
        return LineNumberFactory.get(genericStyledArea, n2 -> "%1$" + n2 + "s");
    }

    public static IntFunction<Node> get(GenericStyledArea<?, ?, ?> genericStyledArea, IntFunction<String> intFunction) {
        return new LineNumberFactory(genericStyledArea, intFunction);
    }

    private LineNumberFactory(GenericStyledArea<?, ?, ?> genericStyledArea, IntFunction<String> intFunction) {
        this.nParagraphs = LiveList.sizeOf(genericStyledArea.getParagraphs());
        this.format = intFunction;
    }

    @Override
    public Node apply(int n2) {
        Val<String> val = this.nParagraphs.map(n3 -> this.format(n2 + 1, (int)n3));
        Label label = new Label();
        label.setBackground(DEFAULT_BACKGROUND);
        label.setTextFill(DEFAULT_TEXT_FILL);
        label.setPadding(DEFAULT_INSETS);
        label.setAlignment(Pos.TOP_RIGHT);
        label.getStyleClass().add((Object)"lineno");
        label.textProperty().bind(val.conditionOnShowing((Node)label));
        return label;
    }

    private String format(int n2, int n3) {
        int n4 = (int)Math.floor(Math.log10(n3)) + 1;
        return String.format(this.format.apply(n4), n2);
    }
}

