/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.function.Predicate;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputHandler;
import org.fxmisc.wellbehaved.event.template.InputMapTemplate;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class GenericStyledAreaBehavior {
    private static final boolean isMac;
    private static final boolean isWindows;
    private static final InputMapTemplate<GenericStyledAreaBehavior, ? super Event> EVENT_TEMPLATE;
    private final GenericStyledArea<?, ?, ?> view;
    private DragState dragSelection = DragState.NO_DRAG;
    private DragState dragNewSelection = DragState.NO_DRAG;
    private final Var<Point2D> autoscrollTo = Var.newSimpleVar(null);

    GenericStyledAreaBehavior(GenericStyledArea<?, ?, ?> genericStyledArea) {
        this.view = genericStyledArea;
        InputMapTemplate.installFallback(EVENT_TEMPLATE, this, genericStyledAreaBehavior -> genericStyledAreaBehavior.view);
        Val<Point2D> val = Val.combine(this.autoscrollTo, genericStyledArea.layoutBoundsProperty(), GenericStyledAreaBehavior::project);
        Val<Point2D> val2 = Val.combine(this.autoscrollTo, val, Point2D::subtract);
        EventStream<Point2D> eventStream = EventStreams.nonNullValuesOf(val2).emitBothOnEach(EventStreams.animationFrames()).map(tuple2 -> tuple2.map((point2D, l2) -> point2D.multiply((double)l2.longValue() / 1.0E8)));
        EventStreams.valuesOf(this.autoscrollTo).flatMap(point2D -> point2D == null ? EventStreams.never() : eventStream).subscribe(point2D -> {
            genericStyledArea.scrollBy((Point2D)point2D);
            val.ifPresent(this::dragTo);
        });
    }

    private void keyTyped(KeyEvent keyEvent) {
        String string = keyEvent.getCharacter();
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        this.view.replaceSelection(string);
    }

    private static boolean isLegal(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isISOControl(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private void deleteBackward(KeyEvent keyEvent) {
        IndexRange indexRange = this.view.getSelection();
        if (indexRange.getLength() == 0) {
            this.view.deletePreviousChar();
        } else {
            this.view.replaceSelection("");
        }
    }

    private void deleteForward(KeyEvent keyEvent) {
        IndexRange indexRange = this.view.getSelection();
        if (indexRange.getLength() == 0) {
            this.view.deleteNextChar();
        } else {
            this.view.replaceSelection("");
        }
    }

    private void left(KeyEvent keyEvent) {
        IndexRange indexRange = this.view.getSelection();
        if (indexRange.getLength() == 0) {
            this.view.previousChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.view.moveTo(indexRange.getStart(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void right(KeyEvent keyEvent) {
        IndexRange indexRange = this.view.getSelection();
        if (indexRange.getLength() == 0) {
            this.view.nextChar(NavigationActions.SelectionPolicy.CLEAR);
        } else {
            this.view.moveTo(indexRange.getEnd(), NavigationActions.SelectionPolicy.CLEAR);
        }
    }

    private void selectLeft(KeyEvent keyEvent) {
        this.view.previousChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void selectRight(KeyEvent keyEvent) {
        this.view.nextChar(NavigationActions.SelectionPolicy.ADJUST);
    }

    private void deletePrevWord(KeyEvent keyEvent) {
        int n2 = this.view.getCaretPosition();
        if (n2 > 0) {
            this.view.wordBreaksBackwards(2, NavigationActions.SelectionPolicy.CLEAR);
            int n3 = this.view.getCaretPosition();
            this.view.replaceText(n3, n2, "");
        }
    }

    private void deleteNextWord(KeyEvent keyEvent) {
        int n2 = this.view.getCaretPosition();
        if (n2 < this.view.getLength()) {
            this.view.wordBreaksForwards(2, NavigationActions.SelectionPolicy.CLEAR);
            int n3 = this.view.getCaretPosition();
            this.view.replaceText(n2, n3, "");
        }
    }

    private void downLines(NavigationActions.SelectionPolicy selectionPolicy, int n2) {
        TwoDimensional.Position position;
        TwoDimensional.Position position2 = this.view.currentLine();
        if (!position2.sameAs(position = position2.offsetBy(n2, TwoDimensional.Bias.Forward).clamp())) {
            CharacterHit characterHit = this.view.hit(this.view.getTargetCaretOffset(), position);
            this.view.moveTo(characterHit.getInsertionIndex(), selectionPolicy);
        }
    }

    private void prevLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(selectionPolicy, -1);
    }

    private void nextLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.downLines(selectionPolicy, 1);
    }

    private void skipToPrevWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int n2 = this.view.getCaretPosition();
        if (1 <= n2) {
            boolean bl = Character.isWhitespace(this.view.getText(n2 - 1, n2).charAt(0));
            this.view.wordBreaksBackwards(bl ? 2 : 1, selectionPolicy);
        }
    }

    private void skipToNextWord(NavigationActions.SelectionPolicy selectionPolicy) {
        int n2;
        int n3 = this.view.getCaretPosition();
        if (n3 <= (n2 = this.view.getLength()) - 1) {
            boolean bl = Character.isWhitespace(this.view.getText(n3, n3 + 1).charAt(0));
            this.view.wordBreaksForwards(bl ? 2 : 1, selectionPolicy);
        }
    }

    private void showContextMenu(ContextMenuEvent contextMenuEvent) {
        ContextMenu contextMenu = this.view.getContextMenu();
        double d2 = this.view.getContextMenuXOffset();
        double d3 = this.view.getContextMenuYOffset();
        contextMenu.show(this.view, contextMenuEvent.getScreenX() + d2, contextMenuEvent.getScreenY() + d3);
    }

    private void handleShiftPress(MouseEvent mouseEvent) {
        this.view.requestFocus();
        CharacterHit characterHit = this.view.hit(mouseEvent.getX(), mouseEvent.getY());
        this.view.moveTo(characterHit.getInsertionIndex(), isMac ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST);
    }

    private void handleFirstPrimaryPress(MouseEvent mouseEvent) {
        this.view.requestFocus();
        CharacterHit characterHit = this.view.hit(mouseEvent.getX(), mouseEvent.getY());
        this.view.clearTargetCaretOffset();
        IndexRange indexRange = this.view.getSelection();
        if (this.view.isEditable() && indexRange.getLength() != 0 && characterHit.getCharacterIndex().isPresent() && characterHit.getCharacterIndex().getAsInt() >= indexRange.getStart() && characterHit.getCharacterIndex().getAsInt() < indexRange.getEnd()) {
            this.dragSelection = DragState.POTENTIAL_DRAG;
            this.dragNewSelection = DragState.NO_DRAG;
        } else {
            this.dragSelection = DragState.NO_DRAG;
            this.dragNewSelection = DragState.NO_DRAG;
            this.view.getOnOutsideSelectionMousePressed().handle((Event)mouseEvent);
        }
    }

    private void handleSecondPress(MouseEvent mouseEvent) {
        this.view.selectWord();
    }

    private void handleThirdPress(MouseEvent mouseEvent) {
        this.view.selectParagraph();
    }

    private void handlePrimaryOnlyDragDetected() {
        if (this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.dragSelection = DragState.DRAG;
        } else {
            this.dragNewSelection = DragState.DRAG;
        }
    }

    private InputHandler.Result processPrimaryOnlyMouseDragged(MouseEvent mouseEvent) {
        Point2D point2D = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        if (this.view.getLayoutBounds().contains(point2D)) {
            this.dragTo(point2D);
        }
        this.view.setAutoScrollOnDragDesired(true);
        return InputHandler.Result.PROCEED;
    }

    private void continueOrStopAutoScroll(MouseEvent mouseEvent) {
        if (!this.view.isAutoScrollOnDragDesired()) {
            this.autoscrollTo.setValue(null);
        }
        Point2D point2D = new Point2D(mouseEvent.getX(), mouseEvent.getY());
        if (this.view.getLayoutBounds().contains(point2D)) {
            this.autoscrollTo.setValue(null);
        } else {
            this.autoscrollTo.setValue(point2D);
        }
    }

    private void dragTo(Point2D point2D) {
        if (this.dragSelection == DragState.DRAG || this.dragSelection == DragState.POTENTIAL_DRAG) {
            this.view.getOnSelectionDrag().accept(point2D);
        } else {
            this.view.getOnNewSelectionDrag().accept(point2D);
        }
    }

    private InputHandler.Result processMouseReleased(MouseEvent mouseEvent) {
        if (this.view.isDisabled()) {
            return InputHandler.Result.IGNORE;
        }
        switch (this.dragSelection) {
            case POTENTIAL_DRAG: {
                this.view.getOnInsideSelectionMousePressReleased().handle((Event)mouseEvent);
            }
            case DRAG: {
                this.view.getOnSelectionDropped().handle((Event)mouseEvent);
                break;
            }
            case NO_DRAG: {
                if (this.dragNewSelection != DragState.DRAG) break;
                this.view.getOnNewSelectionDragFinished().handle((Event)mouseEvent);
            }
        }
        this.dragNewSelection = DragState.NO_DRAG;
        this.dragSelection = DragState.NO_DRAG;
        return InputHandler.Result.PROCEED;
    }

    private static Point2D project(Point2D point2D, Bounds bounds) {
        double d2 = GenericStyledAreaBehavior.clamp(point2D.getX(), bounds.getMinX(), bounds.getMaxX());
        double d3 = GenericStyledAreaBehavior.clamp(point2D.getY(), bounds.getMinY(), bounds.getMaxY());
        return new Point2D(d2, d3);
    }

    private static double clamp(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), d4);
    }

    private static /* synthetic */ void lambda$static$26(NavigationActions.SelectionPolicy selectionPolicy, GenericStyledAreaBehavior genericStyledAreaBehavior, KeyEvent keyEvent) {
        genericStyledAreaBehavior.skipToPrevWord(selectionPolicy);
    }

    private static /* synthetic */ void lambda$static$25(NavigationActions.SelectionPolicy selectionPolicy, GenericStyledAreaBehavior genericStyledAreaBehavior, KeyEvent keyEvent) {
        genericStyledAreaBehavior.skipToNextWord(selectionPolicy);
    }

    private static /* synthetic */ void lambda$static$24(NavigationActions.SelectionPolicy selectionPolicy, GenericStyledAreaBehavior genericStyledAreaBehavior, KeyEvent keyEvent) {
        genericStyledAreaBehavior.view.end(selectionPolicy);
    }

    private static /* synthetic */ void lambda$static$23(NavigationActions.SelectionPolicy selectionPolicy, GenericStyledAreaBehavior genericStyledAreaBehavior, KeyEvent keyEvent) {
        genericStyledAreaBehavior.view.start(selectionPolicy);
    }

    private static /* synthetic */ void lambda$static$22(NavigationActions.SelectionPolicy selectionPolicy, GenericStyledAreaBehavior genericStyledAreaBehavior, KeyEvent keyEvent) {
        genericStyledAreaBehavior.view.lineEnd(selectionPolicy);
    }

    private static /* synthetic */ void lambda$static$21(NavigationActions.SelectionPolicy selectionPolicy, GenericStyledAreaBehavior genericStyledAreaBehavior, KeyEvent keyEvent) {
        genericStyledAreaBehavior.view.lineStart(selectionPolicy);
    }

    static {
        Object object = System.getProperty("os.name");
        isMac = object.startsWith("Mac");
        isWindows = object.startsWith("Windows");
        object = isMac ? NavigationActions.SelectionPolicy.EXTEND : NavigationActions.SelectionPolicy.ADJUST;
        KeyCharacterCombination keyCharacterCombination = new KeyCharacterCombination("a", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination keyCharacterCombination2 = new KeyCharacterCombination("c", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination keyCharacterCombination3 = new KeyCharacterCombination("v", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination keyCharacterCombination4 = new KeyCharacterCombination("x", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination keyCharacterCombination5 = new KeyCharacterCombination("y", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination keyCharacterCombination6 = new KeyCharacterCombination("z", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        KeyCharacterCombination keyCharacterCombination7 = new KeyCharacterCombination("z", new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN});
        InputMapTemplate inputMapTemplate = InputMapTemplate.sequence(InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.DELETE, new KeyCombination.Modifier[0]), GenericStyledAreaBehavior::deleteForward), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.BACK_SPACE, new KeyCombination.Modifier[0]), GenericStyledAreaBehavior::deleteBackward), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.DELETE, KeyCombination.SHORTCUT_DOWN), GenericStyledAreaBehavior::deleteNextWord), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.BACK_SPACE, KeyCombination.SHORTCUT_DOWN), GenericStyledAreaBehavior::deletePrevWord), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.CUT, new KeyCombination.Modifier[0]), EventPattern.keyPressed((KeyCombination)keyCharacterCombination4), EventPattern.keyPressed(KeyCode.DELETE, KeyCombination.SHIFT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.cut()), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.PASTE, new KeyCombination.Modifier[0]), EventPattern.keyPressed((KeyCombination)keyCharacterCombination3), EventPattern.keyPressed(KeyCode.INSERT, KeyCombination.SHIFT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.paste()), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.ENTER, new KeyCombination.Modifier[0]), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.replaceSelection("\n")), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.TAB, new KeyCombination.Modifier[0]), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.replaceSelection("\t")), InputMapTemplate.consume(EventPattern.keyPressed((KeyCombination)keyCharacterCombination6), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.undo()), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed((KeyCombination)keyCharacterCombination5), EventPattern.keyPressed((KeyCombination)keyCharacterCombination7)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.redo()));
        InputMapTemplate inputMapTemplate2 = InputMapTemplate.when(genericStyledAreaBehavior -> genericStyledAreaBehavior.view.isEditable(), inputMapTemplate);
        InputMapTemplate inputMapTemplate3 = InputMapTemplate.sequence(InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.UP, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_UP, new KeyCombination.Modifier[0])), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.prevLine(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.DOWN, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_DOWN, new KeyCombination.Modifier[0])), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.nextLine(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_UP, new KeyCombination.Modifier[0]), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.prevPage(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_DOWN, new KeyCombination.Modifier[0]), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.nextPage(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.UP, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_UP, KeyCombination.SHIFT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.prevLine(NavigationActions.SelectionPolicy.ADJUST)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.DOWN, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_DOWN, KeyCombination.SHIFT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.nextLine(NavigationActions.SelectionPolicy.ADJUST)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_UP, KeyCombination.SHIFT_DOWN), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.prevPage(NavigationActions.SelectionPolicy.ADJUST)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.PAGE_DOWN, KeyCombination.SHIFT_DOWN), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.nextPage(NavigationActions.SelectionPolicy.ADJUST)));
        InputMapTemplate inputMapTemplate4 = InputMapTemplate.sequence(InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_RIGHT, new KeyCombination.Modifier[0])), GenericStyledAreaBehavior::right), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, new KeyCombination.Modifier[0]), EventPattern.keyPressed(KeyCode.KP_LEFT, new KeyCombination.Modifier[0])), GenericStyledAreaBehavior::left), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, new KeyCombination.Modifier[0]), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.lineStart(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, new KeyCombination.Modifier[0]), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.lineEnd(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHORTCUT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.skipToNextWord(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHORTCUT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.skipToPrevWord(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHORTCUT_DOWN), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.start(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHORTCUT_DOWN), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.end(NavigationActions.SelectionPolicy.CLEAR)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHIFT_DOWN)), GenericStyledAreaBehavior::selectRight), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHIFT_DOWN), EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHIFT_DOWN)), GenericStyledAreaBehavior::selectLeft), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHIFT_DOWN), (arg_0, arg_1) -> GenericStyledAreaBehavior.lambda$static$21((NavigationActions.SelectionPolicy)((Object)object), arg_0, arg_1)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHIFT_DOWN), (arg_0, arg_1) -> GenericStyledAreaBehavior.lambda$static$22((NavigationActions.SelectionPolicy)((Object)object), arg_0, arg_1)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.HOME, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), (arg_0, arg_1) -> GenericStyledAreaBehavior.lambda$static$23((NavigationActions.SelectionPolicy)((Object)object), arg_0, arg_1)), InputMapTemplate.consume(EventPattern.keyPressed(KeyCode.END, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), (arg_0, arg_1) -> GenericStyledAreaBehavior.lambda$static$24((NavigationActions.SelectionPolicy)((Object)object), arg_0, arg_1)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.RIGHT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_RIGHT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)), (arg_0, arg_1) -> GenericStyledAreaBehavior.lambda$static$25((NavigationActions.SelectionPolicy)((Object)object), arg_0, arg_1)), InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.LEFT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN), EventPattern.keyPressed(KeyCode.KP_LEFT, KeyCombination.SHIFT_DOWN, KeyCombination.SHORTCUT_DOWN)), (arg_0, arg_1) -> GenericStyledAreaBehavior.lambda$static$26((NavigationActions.SelectionPolicy)((Object)object), arg_0, arg_1)), InputMapTemplate.consume(EventPattern.keyPressed((KeyCombination)keyCharacterCombination), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.selectAll()));
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> inputMapTemplate5 = InputMapTemplate.consume(EventPattern.anyOf(EventPattern.keyPressed(KeyCode.COPY, new KeyCombination.Modifier[0]), EventPattern.keyPressed((KeyCombination)keyCharacterCombination2), EventPattern.keyPressed(KeyCode.INSERT, KeyCombination.SHORTCUT_DOWN)), (genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.copy());
        Predicate<KeyEvent> predicate = keyEvent -> !keyEvent.isControlDown() && !keyEvent.isMetaDown() || isWindows && !keyEvent.isMetaDown() && (!keyEvent.isControlDown() || keyEvent.isAltDown());
        Predicate<KeyEvent> predicate2 = keyEvent -> keyEvent.getCode().isLetterKey() || keyEvent.getCode().isDigitKey() || keyEvent.getCode().isWhitespaceKey();
        InputMapTemplate inputMapTemplate6 = InputMapTemplate.consume(EventPattern.keyPressed().onlyIf(predicate2.and(predicate)));
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> inputMapTemplate7 = inputMapTemplate2.orElse(inputMapTemplate4).ifConsumed((genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.clearTargetCaretOffset()).orElse(inputMapTemplate3).orElse(inputMapTemplate5).ifConsumed((genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.requestFollowCaret()).orElse(inputMapTemplate6);
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> inputMapTemplate8 = InputMapTemplate.consume(EventPattern.keyTyped().onlyIf(predicate.and(keyEvent -> GenericStyledAreaBehavior.isLegal(keyEvent.getCharacter()))), GenericStyledAreaBehavior::keyTyped).ifConsumed((genericStyledAreaBehavior, keyEvent) -> genericStyledAreaBehavior.view.requestFollowCaret());
        InputMapTemplate<GenericStyledAreaBehavior, KeyEvent> inputMapTemplate9 = InputMapTemplate.when(genericStyledAreaBehavior -> genericStyledAreaBehavior.view.isEditable(), inputMapTemplate8);
        InputMapTemplate inputMapTemplate10 = InputMapTemplate.sequence(InputMapTemplate.process(EventPattern.mousePressed(MouseButton.PRIMARY), (genericStyledAreaBehavior, mouseEvent) -> genericStyledAreaBehavior.view.isDisabled() ? InputHandler.Result.IGNORE : InputHandler.Result.PROCEED), InputMapTemplate.process(EventPattern.mousePressed(), (genericStyledAreaBehavior, mouseEvent) -> {
            genericStyledAreaBehavior.view.hideContextMenu();
            return InputHandler.Result.PROCEED;
        }), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(MouseEvent::isShiftDown), GenericStyledAreaBehavior::handleShiftPress), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(mouseEvent -> mouseEvent.getClickCount() == 1), GenericStyledAreaBehavior::handleFirstPrimaryPress), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(mouseEvent -> mouseEvent.getClickCount() == 2), GenericStyledAreaBehavior::handleSecondPress), InputMapTemplate.consume(EventPattern.mousePressed(MouseButton.PRIMARY).onlyIf(mouseEvent -> mouseEvent.getClickCount() == 3), GenericStyledAreaBehavior::handleThirdPress));
        Predicate<MouseEvent> predicate3 = mouseEvent -> mouseEvent.getButton() == MouseButton.PRIMARY && !mouseEvent.isMiddleButtonDown() && !mouseEvent.isSecondaryButtonDown();
        InputMapTemplate<GenericStyledAreaBehavior, MouseEvent> inputMapTemplate11 = InputMapTemplate.consume(EventPattern.eventType(MouseEvent.DRAG_DETECTED).onlyIf(predicate3), (genericStyledAreaBehavior, mouseEvent) -> genericStyledAreaBehavior.handlePrimaryOnlyDragDetected());
        InputMapTemplate inputMapTemplate12 = InputMapTemplate.sequence(InputMapTemplate.process(EventPattern.mouseDragged().onlyIf(predicate3), GenericStyledAreaBehavior::processPrimaryOnlyMouseDragged), InputMapTemplate.consume(EventPattern.mouseDragged(), GenericStyledAreaBehavior::continueOrStopAutoScroll));
        InputMapTemplate inputMapTemplate13 = InputMapTemplate.sequence(InputMapTemplate.process(EventPattern.mouseReleased().onlyIf(predicate3), GenericStyledAreaBehavior::processMouseReleased), InputMapTemplate.consume(EventPattern.mouseReleased(), (genericStyledAreaBehavior, mouseEvent) -> genericStyledAreaBehavior.autoscrollTo.setValue(null)));
        InputMapTemplate inputMapTemplate14 = InputMapTemplate.sequence(inputMapTemplate10, inputMapTemplate11, inputMapTemplate12, inputMapTemplate13);
        InputMapTemplate<GenericStyledAreaBehavior, ContextMenuEvent> inputMapTemplate15 = InputMapTemplate.consumeWhen(EventPattern.eventType(ContextMenuEvent.CONTEXT_MENU_REQUESTED), genericStyledAreaBehavior -> !genericStyledAreaBehavior.view.isDisabled() && genericStyledAreaBehavior.view.isContextMenuPresent(), GenericStyledAreaBehavior::showContextMenu);
        EVENT_TEMPLATE = InputMapTemplate.sequence(inputMapTemplate14, inputMapTemplate7, inputMapTemplate9, inputMapTemplate15);
    }

    private static enum DragState {
        NO_DRAG,
        POTENTIAL_DRAG,
        DRAG;

    }
}

