/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.text.TextFlow;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.fxmisc.flowless.Virtualized;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.CaretSelectionBindImpl;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.ClipboardActions;
import org.fxmisc.richtext.CustomCssMetaData;
import org.fxmisc.richtext.CustomStyleableProperty;
import org.fxmisc.richtext.EditActions;
import org.fxmisc.richtext.GenericStyledAreaBehavior;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionImpl;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.StyleActions;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextEditingArea;
import org.fxmisc.richtext.UndoActions;
import org.fxmisc.richtext.ViewActions;
import org.fxmisc.richtext.event.MouseOverTextEvent;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.GenericEditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;
import org.fxmisc.richtext.util.SubscribeableContentsObsSet;
import org.fxmisc.richtext.util.UndoUtils;
import org.fxmisc.undo.UndoManager;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.SuspendableList;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class GenericStyledArea<PS, SEG, S>
extends Region
implements Virtualized,
ClipboardActions<PS, SEG, S>,
EditActions<PS, SEG, S>,
NavigationActions<PS, SEG, S>,
StyleActions<PS, S>,
TextEditingArea<PS, SEG, S>,
UndoActions,
ViewActions<PS, SEG, S>,
TwoDimensional {
    public static final IndexRange EMPTY_RANGE = new IndexRange(0, 0);
    private static final PseudoClass READ_ONLY = PseudoClass.getPseudoClass((String)"readonly");
    private static final PseudoClass HAS_CARET = PseudoClass.getPseudoClass((String)"has-caret");
    private static final PseudoClass FIRST_PAR = PseudoClass.getPseudoClass((String)"first-paragraph");
    private static final PseudoClass LAST_PAR = PseudoClass.getPseudoClass((String)"last-paragraph");
    private final StyleableObjectProperty<Paint> highlightTextFill = new CustomStyleableProperty<Paint>((Paint)Color.WHITE, "highlightTextFill", this, (CssMetaData<Styleable, Paint>)HIGHLIGHT_TEXT_FILL);
    private final BooleanProperty editable = new SimpleBooleanProperty(this, "editable", true){

        protected void invalidated() {
            ((Region)this.getBean()).pseudoClassStateChanged(READ_ONLY, !this.get());
        }
    };
    private final BooleanProperty wrapText = new SimpleBooleanProperty((Object)this, "wrapText");
    private UndoManager undoManager;
    private final ObjectProperty<Duration> mouseOverTextDelay = new SimpleObjectProperty(null);
    private final ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactory = new SimpleObjectProperty(null);
    private ObjectProperty<ContextMenu> contextMenu = new SimpleObjectProperty(null);
    private DoubleProperty contextMenuXOffset = new SimpleDoubleProperty(2.0);
    private DoubleProperty contextMenuYOffset = new SimpleDoubleProperty(2.0);
    private final BooleanProperty useInitialStyleForInsertion = new SimpleBooleanProperty();
    private Optional<Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>>> styleCodecs = Optional.empty();
    private final SubscribeableContentsObsSet<CaretNode> caretSet;
    private final SubscribeableContentsObsSet<Selection<PS, SEG, S>> selectionSet;
    private final ObjectProperty<EventHandler<MouseEvent>> onOutsideSelectionMousePressed = new SimpleObjectProperty(mouseEvent -> this.moveTo(this.hit(mouseEvent.getX(), mouseEvent.getY()).getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR));
    private final ObjectProperty<EventHandler<MouseEvent>> onInsideSelectionMousePressReleased = new SimpleObjectProperty(mouseEvent -> this.moveTo(this.hit(mouseEvent.getX(), mouseEvent.getY()).getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR));
    private final ObjectProperty<Consumer<Point2D>> onNewSelectionDrag = new SimpleObjectProperty(point2D -> {
        CharacterHit characterHit = this.hit(point2D.getX(), point2D.getY());
        this.moveTo(characterHit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
    });
    private final ObjectProperty<EventHandler<MouseEvent>> onNewSelectionDragFinished = new SimpleObjectProperty(mouseEvent -> {
        CharacterHit characterHit = this.hit(mouseEvent.getX(), mouseEvent.getY());
        this.moveTo(characterHit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
    });
    private final ObjectProperty<Consumer<Point2D>> onSelectionDrag = new SimpleObjectProperty(point2D -> {
        CharacterHit characterHit = this.hit(point2D.getX(), point2D.getY());
        this.displaceCaret(characterHit.getInsertionIndex());
    });
    private final ObjectProperty<EventHandler<MouseEvent>> onSelectionDropped = new SimpleObjectProperty(mouseEvent -> this.moveSelectedText(this.hit(mouseEvent.getX(), mouseEvent.getY()).getInsertionIndex()));
    private final BooleanProperty autoScrollOnDragDesired = new SimpleBooleanProperty(true);
    private CaretSelectionBind<PS, SEG, S> caretSelectionBind;
    private final SuspendableList<Paragraph<PS, SEG, S>> visibleParagraphs;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final SuspendableEventStream<?> viewportDirty;
    private Subscription subscriptions = () -> {};
    private final VirtualFlow<Paragraph<PS, SEG, S>, Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> virtualFlow;
    private final TwoLevelNavigator paragraphLineNavigator;
    private boolean paging;
    private boolean followCaretRequested = false;
    private final EditableStyledDocument<PS, SEG, S> content;
    private final S initialTextStyle;
    private final PS initialParagraphStyle;
    private final BiConsumer<TextFlow, PS> applyParagraphStyle;
    private final boolean preserveStyle;
    private final TextOps<SEG, S> segmentOps;
    private final EventStream<Boolean> autoCaretBlinksSteam;
    private double caretPrevY = -1.0;
    private Selection<PS, SEG, S> lineHighlighter;
    private ObjectProperty<Paint> lineHighlighterFill;
    private static final CssMetaData<GenericStyledArea<?, ?, ?>, Paint> HIGHLIGHT_TEXT_FILL = new CustomCssMetaData<GenericStyledArea, Color>("-fx-highlight-text-fill", StyleConverter.getPaintConverter(), Color.WHITE, genericStyledArea -> genericStyledArea.highlightTextFill);
    private static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA_LIST;

    @Override
    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this.editable.set(bl);
    }

    @Override
    public boolean isEditable() {
        return this.editable.get();
    }

    @Override
    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    @Override
    public void setWrapText(boolean bl) {
        this.wrapText.set(bl);
    }

    @Override
    public boolean isWrapText() {
        return this.wrapText.get();
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManager undoManager) {
        this.undoManager.close();
        this.undoManager = undoManager;
    }

    @Override
    public ObjectProperty<Duration> mouseOverTextDelayProperty() {
        return this.mouseOverTextDelay;
    }

    @Override
    public ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactoryProperty() {
        return this.paragraphGraphicFactory;
    }

    @Override
    public final ObjectProperty<ContextMenu> contextMenuObjectProperty() {
        return this.contextMenu;
    }

    @Override
    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenu.set((Object)contextMenu);
    }

    @Override
    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenu.get();
    }

    protected final boolean isContextMenuPresent() {
        return this.contextMenu.get() != null;
    }

    @Override
    public final DoubleProperty contextMenuXOffsetProperty() {
        return this.contextMenuXOffset;
    }

    @Override
    public void setContextMenuXOffset(double d2) {
        this.contextMenuXOffset.set(d2);
    }

    @Override
    public double getContextMenuXOffset() {
        return this.contextMenuXOffset.get();
    }

    @Override
    public final DoubleProperty contextMenuYOffsetProperty() {
        return this.contextMenuYOffset;
    }

    @Override
    public void setContextMenuYOffset(double d2) {
        this.contextMenuYOffset.set(d2);
    }

    @Override
    public double getContextMenuYOffset() {
        return this.contextMenuYOffset.get();
    }

    @Override
    public BooleanProperty useInitialStyleForInsertionProperty() {
        return this.useInitialStyleForInsertion;
    }

    @Override
    public void setStyleCodecs(Codec<PS> codec, Codec<StyledSegment<SEG, S>> codec2) {
        this.styleCodecs = Optional.of(Tuples.t(codec, codec2));
    }

    @Override
    public Optional<Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>>> getStyleCodecs() {
        return this.styleCodecs;
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return this.virtualFlow.estimatedScrollXProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return this.virtualFlow.estimatedScrollYProperty();
    }

    public final boolean addCaret(CaretNode caretNode) {
        if (caretNode.getArea() != this) {
            throw new IllegalArgumentException(String.format("The caret (%s) is associated with a different area (%s), not this area (%s)", caretNode, caretNode.getArea(), this));
        }
        return this.caretSet.add(caretNode);
    }

    public final boolean removeCaret(CaretNode caretNode) {
        if (caretNode != this.caretSelectionBind.getUnderlyingCaret()) {
            return this.caretSet.remove(caretNode);
        }
        return false;
    }

    public final boolean addSelection(Selection<PS, SEG, S> selection) {
        if (selection.getArea() != this) {
            throw new IllegalArgumentException(String.format("The selection (%s) is associated with a different area (%s), not this area (%s)", selection, selection.getArea(), this));
        }
        return this.selectionSet.add(selection);
    }

    public final boolean removeSelection(Selection<PS, SEG, S> selection) {
        if (selection != this.caretSelectionBind.getUnderlyingSelection()) {
            return this.selectionSet.remove(selection);
        }
        return false;
    }

    @Override
    public final EventHandler<MouseEvent> getOnOutsideSelectionMousePressed() {
        return (EventHandler)this.onOutsideSelectionMousePressed.get();
    }

    @Override
    public final void setOnOutsideSelectionMousePressed(EventHandler<MouseEvent> eventHandler) {
        this.onOutsideSelectionMousePressed.set(eventHandler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onOutsideSelectionMousePressedProperty() {
        return this.onOutsideSelectionMousePressed;
    }

    @Override
    public final EventHandler<MouseEvent> getOnInsideSelectionMousePressReleased() {
        return (EventHandler)this.onInsideSelectionMousePressReleased.get();
    }

    @Override
    public final void setOnInsideSelectionMousePressReleased(EventHandler<MouseEvent> eventHandler) {
        this.onInsideSelectionMousePressReleased.set(eventHandler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onInsideSelectionMousePressReleasedProperty() {
        return this.onInsideSelectionMousePressReleased;
    }

    @Override
    public final ObjectProperty<Consumer<Point2D>> onNewSelectionDragProperty() {
        return this.onNewSelectionDrag;
    }

    @Override
    public final EventHandler<MouseEvent> getOnNewSelectionDragFinished() {
        return (EventHandler)this.onNewSelectionDragFinished.get();
    }

    @Override
    public final void setOnNewSelectionDragFinished(EventHandler<MouseEvent> eventHandler) {
        this.onNewSelectionDragFinished.set(eventHandler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onNewSelectionDragFinishedProperty() {
        return this.onNewSelectionDragFinished;
    }

    @Override
    public final ObjectProperty<Consumer<Point2D>> onSelectionDragProperty() {
        return this.onSelectionDrag;
    }

    @Override
    public final EventHandler<MouseEvent> getOnSelectionDropped() {
        return (EventHandler)this.onSelectionDropped.get();
    }

    @Override
    public final void setOnSelectionDropped(EventHandler<MouseEvent> eventHandler) {
        this.onSelectionDropped.set(eventHandler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onSelectionDroppedProperty() {
        return this.onSelectionDropped;
    }

    @Override
    public final BooleanProperty autoScrollOnDragDesiredProperty() {
        return this.autoScrollOnDragDesired;
    }

    @Override
    public void setAutoScrollOnDragDesired(boolean bl) {
        this.autoScrollOnDragDesired.set(bl);
    }

    @Override
    public boolean isAutoScrollOnDragDesired() {
        return this.autoScrollOnDragDesired.get();
    }

    @Override
    public final ObservableValue<String> textProperty() {
        return this.content.textProperty();
    }

    @Override
    public final StyledDocument<PS, SEG, S> getDocument() {
        return this.content;
    }

    @Override
    public final CaretSelectionBind<PS, SEG, S> getCaretSelectionBind() {
        return this.caretSelectionBind;
    }

    @Override
    public final ObservableValue<Integer> lengthProperty() {
        return this.content.lengthProperty();
    }

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs() {
        return this.content.getParagraphs();
    }

    @Override
    public final LiveList<Paragraph<PS, SEG, S>> getVisibleParagraphs() {
        return this.visibleParagraphs;
    }

    @Override
    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return this.virtualFlow.totalWidthEstimateProperty();
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return this.virtualFlow.totalHeightEstimateProperty();
    }

    @Override
    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges() {
        return this.content.multiRichChanges();
    }

    @Override
    public EventStream<List<PlainTextChange>> multiPlainChanges() {
        return this.content.multiPlainChanges();
    }

    @Override
    public final EventStream<PlainTextChange> plainTextChanges() {
        return this.content.plainChanges();
    }

    @Override
    public final EventStream<RichTextChange<PS, SEG, S>> richChanges() {
        return this.content.richChanges();
    }

    @Override
    public final EventStream<?> viewportDirtyEvents() {
        return this.viewportDirty;
    }

    @Override
    public final EditableStyledDocument<PS, SEG, S> getContent() {
        return this.content;
    }

    @Override
    public final S getInitialTextStyle() {
        return this.initialTextStyle;
    }

    @Override
    public final PS getInitialParagraphStyle() {
        return this.initialParagraphStyle;
    }

    @Override
    public final BiConsumer<TextFlow, PS> getApplyParagraphStyle() {
        return this.applyParagraphStyle;
    }

    @Override
    public final boolean isPreserveStyle() {
        return this.preserveStyle;
    }

    @Override
    public final TextOps<SEG, S> getSegOps() {
        return this.segmentOps;
    }

    final EventStream<Boolean> autoCaretBlink() {
        return this.autoCaretBlinksSteam;
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="segmentOps") TextOps<SEG, S> textOps, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> function) {
        this(PS, biConsumer, s2, textOps, true, function);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="segmentOps") TextOps<SEG, S> textOps, @NamedArg(value="preserveStyle") boolean bl, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> function) {
        this(PS, biConsumer, s2, new GenericEditableStyledDocument<PS, SEG, S>(PS, s2, textOps), textOps, bl, function);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="document") EditableStyledDocument<PS, SEG, S> editableStyledDocument, @NamedArg(value="segmentOps") TextOps<SEG, S> textOps, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> function) {
        this(PS, biConsumer, s2, editableStyledDocument, textOps, true, function);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS PS, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> biConsumer, @NamedArg(value="initialTextStyle") S s2, @NamedArg(value="document") EditableStyledDocument<PS, SEG, S> editableStyledDocument, @NamedArg(value="segmentOps") TextOps<SEG, S> textOps, @NamedArg(value="preserveStyle") boolean bl, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> function) {
        this.initialTextStyle = s2;
        this.initialParagraphStyle = PS;
        this.preserveStyle = bl;
        this.content = editableStyledDocument;
        this.applyParagraphStyle = biConsumer;
        this.segmentOps = textOps;
        this.undoManager = UndoUtils.defaultUndoManager(this);
        this.setFocusTraversable(true);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getStyleClass().add((Object)"styled-text-area");
        this.getStylesheets().add((Object)StyledTextArea.class.getResource("styled-text-area.css").toExternalForm());
        ObservableSet observableSet = FXCollections.observableSet((Object[])new ParagraphBox[0]);
        this.caretSet = new SubscribeableContentsObsSet();
        this.manageSubscription(() -> {
            ArrayList<CaretNode> arrayList = new ArrayList<CaretNode>(this.caretSet);
            this.caretSet.clear();
            arrayList.forEach(CaretNode::dispose);
        });
        this.selectionSet = new SubscribeableContentsObsSet();
        this.manageSubscription(() -> {
            ArrayList<Selection<PS, SEG, S>> arrayList = new ArrayList<Selection<PS, SEG, S>>(this.selectionSet);
            this.selectionSet.clear();
            arrayList.forEach(Selection::dispose);
        });
        this.virtualFlow = VirtualFlow.createVertical(this.getParagraphs(), paragraph2 -> {
            Cell cell = this.createCell((Paragraph<PS, SEG, S>)paragraph2, biConsumer, function);
            observableSet.add(cell.getNode());
            return cell.beforeReset(() -> observableSet.remove(cell.getNode())).afterUpdateItem(paragraph -> observableSet.add(cell.getNode()));
        });
        this.getChildren().add(this.virtualFlow);
        IntSupplier intSupplier = () -> this.getParagraphs().size();
        IntUnaryOperator intUnaryOperator = n2 -> this.virtualFlow.getCell(n2).getNode().getLineCount();
        this.paragraphLineNavigator = new TwoLevelNavigator(intSupplier, intUnaryOperator);
        this.viewportDirty = EventStreams.merge(EventStreams.invalidationsOf((Observable)this.scaleXProperty()), EventStreams.invalidationsOf((Observable)this.scaleYProperty()), EventStreams.invalidationsOf(this.estimatedScrollXProperty()), EventStreams.invalidationsOf(this.estimatedScrollYProperty())).suppressible();
        this.autoCaretBlinksSteam = EventStreams.valuesOf(this.focusedProperty().and((ObservableBooleanValue)this.editableProperty()).and((ObservableBooleanValue)this.disabledProperty().not()));
        this.caretSelectionBind = new CaretSelectionBindImpl("main-caret", "main-selection", this);
        this.caretSet.add(this.caretSelectionBind.getUnderlyingCaret());
        this.selectionSet.add(this.caretSelectionBind.getUnderlyingSelection());
        this.visibleParagraphs = LiveList.map(this.virtualFlow.visibleCells(), cell -> ((ParagraphBox)((Object)((Object)cell.getNode()))).getParagraph()).suspendable();
        Suspendable suspendable = Suspendable.combine(this.beingUpdated, this.visibleParagraphs);
        this.manageSubscription(suspendable.suspendWhen(this.content.beingUpdatedProperty()));
        EventStreams.valuesOf(this.mouseOverTextDelayProperty()).flatMap(duration -> duration != null ? this.mouseOverTextEvents((ObservableSet<ParagraphBox<PS, SEG, S>>)observableSet, (Duration)duration) : EventStreams.never()).subscribe(mouseOverTextEvent -> Event.fireEvent((EventTarget)this, (Event)mouseOverTextEvent));
        new GenericStyledAreaBehavior(this);
    }

    @Override
    public final double getViewportHeight() {
        return this.virtualFlow.getHeight();
    }

    @Override
    public final Optional<Integer> allParToVisibleParIndex(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The given paragraph index (allParIndex) cannot be negative but was " + n2);
        }
        if (n2 >= this.getParagraphs().size()) {
            throw new IllegalArgumentException(String.format("Paragraphs' last index is [%s] but allParIndex was [%s]", this.getParagraphs().size() - 1, n2));
        }
        Paragraph paragraph = this.getParagraph(n2);
        for (int i2 = 0; i2 < this.getVisibleParagraphs().size(); ++i2) {
            if (this.getVisibleParagraphs().get(i2) != paragraph) continue;
            return Optional.of(i2);
        }
        return Optional.empty();
    }

    @Override
    public final int visibleParToAllParIndex(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Visible paragraph index cannot be negative but was " + n2);
        }
        if (n2 >= this.getVisibleParagraphs().size()) {
            throw new IllegalArgumentException(String.format("Visible paragraphs' last index is [%s] but visibleParIndex was [%s]", this.getVisibleParagraphs().size() - 1, n2));
        }
        Paragraph paragraph = (Paragraph)this.getVisibleParagraphs().get(n2);
        for (int i2 = 0; i2 < this.getParagraphs().size(); ++i2) {
            if (this.getParagraph(i2) != paragraph) continue;
            return i2;
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    @Override
    public CharacterHit hit(double d2, double d3) {
        double d4;
        double d5 = d2 - this.getInsets().getLeft();
        VirtualFlowHit<Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> virtualFlowHit = this.virtualFlow.hit(d5, d4 = d3 - this.getInsets().getTop());
        if (virtualFlowHit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (virtualFlowHit.isAfterCells()) {
            return CharacterHit.insertionAt(this.getLength());
        }
        int n2 = virtualFlowHit.getCellIndex();
        int n3 = this.getParagraphOffset(n2);
        ParagraphBox<PS, SEG, S> paragraphBox = virtualFlowHit.getCell().getNode();
        Point2D point2D = virtualFlowHit.getCellOffset();
        CharacterHit characterHit = paragraphBox.hit(point2D);
        return characterHit.offset(n3);
    }

    @Override
    public final int lineIndex(int n2, int n3) {
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(n2);
        return cell.getNode().getCurrentLineIndex(n3);
    }

    @Override
    public int getParagraphLinesCount(int n2) {
        return this.virtualFlow.getCell(n2).getNode().getLineCount();
    }

    @Override
    public Optional<Bounds> getCharacterBoundsOnScreen(int n2, int n3) {
        TwoDimensional.Position position;
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("From is negative: " + n2);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("From is greater than to. from=%s to=%s", n2, n3));
        }
        if (n3 > this.getLength()) {
            throw new IllegalArgumentException(String.format("To is greater than area's length. length=%s, to=%s", this.getLength(), n3));
        }
        if (this.getText(n2, n3).equals("\n")) {
            return Optional.empty();
        }
        int n5 = this.getText(n2, n2 + 1).equals("\n") ? n2 + 1 : n2;
        TwoDimensional.Position position2 = this.offsetToPosition(n5, TwoDimensional.Bias.Forward);
        int n6 = position2.getMajor();
        if (n6 == (n4 = (position = position2.offsetBy(n3 - n5, TwoDimensional.Bias.Forward)).getMajor())) {
            return this.getRangeBoundsOnScreen(n6, position2.getMinor(), position.getMinor());
        }
        Optional<Bounds> optional = this.getRangeBoundsOnScreen(n6, position2.getMinor(), this.getParagraph(n6).length());
        for (int i2 = n6 + 1; i2 <= n4; ++i2) {
            Optional<Bounds> optional2 = this.getRangeBoundsOnScreen(i2, 0, i2 == n4 ? position.getMinor() : this.getParagraph(i2).length());
            if (!optional2.isPresent()) continue;
            if (optional.isPresent()) {
                Bounds bounds = optional2.get();
                optional = optional.map(bounds2 -> {
                    double d2 = Math.min(bounds2.getMinX(), bounds.getMinX());
                    double d3 = Math.min(bounds2.getMinY(), bounds.getMinY());
                    double d4 = Math.max(bounds2.getMaxX(), bounds.getMaxX());
                    double d5 = Math.max(bounds2.getMaxY(), bounds.getMaxY());
                    return new BoundingBox(d2, d3, d4 - d2, d5 - d3);
                });
                continue;
            }
            optional = optional2;
        }
        return optional;
    }

    @Override
    public final String getText(int n2, int n3) {
        return this.content.getText(n2, n3);
    }

    @Override
    public String getText(int n2) {
        return this.content.getText(n2);
    }

    @Override
    public String getText(IndexRange indexRange) {
        return this.content.getText(indexRange);
    }

    @Override
    public StyledDocument<PS, SEG, S> subDocument(int n2, int n3) {
        return this.content.subSequence(n2, n3);
    }

    @Override
    public StyledDocument<PS, SEG, S> subDocument(int n2) {
        return this.content.subDocument(n2);
    }

    @Override
    public IndexRange getParagraphSelection(Selection selection, int n2) {
        int n3 = selection.getStartParagraphIndex();
        int n4 = selection.getEndParagraphIndex();
        if (n2 < n3 || n2 > n4) {
            return EMPTY_RANGE;
        }
        int n5 = n2 == n3 ? selection.getStartColumnPosition() : 0;
        int n6 = n2 == n4 ? selection.getEndColumnPosition() : this.getParagraphLength(n2) + 1;
        selection.getRange();
        return new IndexRange(n5, n6);
    }

    @Override
    public S getStyleOfChar(int n2) {
        return this.content.getStyleOfChar(n2);
    }

    @Override
    public S getStyleAtPosition(int n2) {
        return this.content.getStyleAtPosition(n2);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int n2) {
        return this.content.getStyleRangeAtPosition(n2);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int n2, int n3) {
        return this.content.getStyleSpans(n2, n3);
    }

    @Override
    public S getStyleOfChar(int n2, int n3) {
        return this.content.getStyleOfChar(n2, n3);
    }

    @Override
    public S getStyleAtPosition(int n2, int n3) {
        return this.content.getStyleAtPosition(n2, n3);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int n2, int n3) {
        return this.content.getStyleRangeAtPosition(n2, n3);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int n2) {
        return this.content.getStyleSpans(n2);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int n2, int n3, int n4) {
        return this.content.getStyleSpans(n2, n3, n4);
    }

    @Override
    public int getAbsolutePosition(int n2, int n3) {
        return this.content.getAbsolutePosition(n2, n3);
    }

    @Override
    public TwoDimensional.Position position(int n2, int n3) {
        return this.content.position(n2, n3);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int n2, TwoDimensional.Bias bias) {
        return this.content.offsetToPosition(n2, bias);
    }

    @Override
    public Bounds getVisibleParagraphBoundsOnScreen(int n2) {
        return this.getParagraphBoundsOnScreen((Cell)this.virtualFlow.visibleCells().get(n2));
    }

    @Override
    public Optional<Bounds> getParagraphBoundsOnScreen(int n2) {
        return this.virtualFlow.getCellIfVisible(n2).map(this::getParagraphBoundsOnScreen);
    }

    @Override
    public final <T extends Node> Optional<Bounds> getCaretBoundsOnScreen(T t2) {
        return this.virtualFlow.getCellIfVisible(((Caret)t2).getParagraphIndex()).map(cell -> ((ParagraphBox)((Object)((Object)cell.getNode()))).getCaretBoundsOnScreen(t2));
    }

    @Override
    public void scrollXToPixel(double d2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollXToPixel(d2));
    }

    @Override
    public void scrollYToPixel(double d2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollYToPixel(d2));
    }

    @Override
    public void scrollXBy(double d2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollXBy(d2));
    }

    @Override
    public void scrollYBy(double d2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollYBy(d2));
    }

    @Override
    public void scrollBy(Point2D point2D) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollBy(point2D));
    }

    @Override
    public void showParagraphInViewport(int n2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.show(n2));
    }

    @Override
    public void showParagraphAtTop(int n2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAsFirst(n2));
    }

    @Override
    public void showParagraphAtBottom(int n2) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAsLast(n2));
    }

    @Override
    public void showParagraphRegion(int n2, Bounds bounds) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.show(n2, bounds));
    }

    @Override
    public void requestFollowCaret() {
        this.followCaretRequested = true;
        this.requestLayout();
    }

    @Override
    public void lineStart(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getCurrentParagraph(), this.getCurrentLineStartInParargraph(), selectionPolicy);
    }

    @Override
    public void lineEnd(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getCurrentParagraph(), this.getCurrentLineEndInParargraph(), selectionPolicy);
    }

    public int getCurrentLineStartInParargraph() {
        return this.virtualFlow.getCell(this.getCurrentParagraph()).getNode().getCurrentLineStartPosition(this.caretSelectionBind.getUnderlyingCaret());
    }

    public int getCurrentLineEndInParargraph() {
        return this.virtualFlow.getCell(this.getCurrentParagraph()).getNode().getCurrentLineEndPosition(this.caretSelectionBind.getUnderlyingCaret());
    }

    public void setLineHighlighterFill(Paint paint) {
        if (this.lineHighlighterFill != null && paint != null) {
            this.lineHighlighterFill.set((Object)paint);
        } else {
            boolean bl = this.isLineHighlighterOn();
            if (bl) {
                this.setLineHighlighterOn(false);
            }
            this.lineHighlighterFill = paint == null ? null : new SimpleObjectProperty((Object)paint);
            if (bl) {
                this.setLineHighlighterOn(true);
            }
        }
    }

    public boolean isLineHighlighterOn() {
        return this.lineHighlighter != null && this.selectionSet.contains(this.lineHighlighter);
    }

    public void setLineHighlighterOn(boolean bl) {
        if (bl) {
            if (this.lineHighlighter != null) {
                return;
            }
            this.lineHighlighter = new SelectionImpl("line-highlighter", this, selectionPath -> {
                if (this.lineHighlighterFill == null) {
                    selectionPath.setHighlightFill((Paint)Color.YELLOW);
                } else {
                    selectionPath.highlightFillProperty().bind(this.lineHighlighterFill);
                }
                selectionPath.getElements().addListener(change -> {
                    if (change.next() && change.wasAdded() || change.wasReplaced()) {
                        double d2 = this.getLayoutBounds().getWidth();
                        change.getAddedSubList().stream().skip(1L).limit(2L).forEach(pathElement -> ((LineTo)pathElement).setX(d2));
                        if (change.getAddedSize() > 5) {
                            selectionPath.getElements().remove(5, 10);
                        }
                        selectionPath.toBack();
                    }
                });
            });
            Consumer<Bounds> consumer = bounds -> {
                if (bounds.getMinY() != this.caretPrevY && this.lineHighlighter != null) {
                    int n2 = this.getCurrentParagraph();
                    int n3 = this.getCurrentLineStartInParargraph();
                    int n4 = this.getCurrentLineEndInParargraph() + 1;
                    this.lineHighlighter.selectRange(n2, n3, n2, n4);
                    this.caretPrevY = bounds.getMinY();
                }
            };
            this.caretBoundsProperty().addListener((observableValue, optional, optional2) -> optional2.ifPresent(consumer));
            this.getCaretBounds().ifPresent(consumer);
            this.selectionSet.add(this.lineHighlighter);
        } else if (this.lineHighlighter != null) {
            this.selectionSet.remove(this.lineHighlighter);
            this.lineHighlighter.deselect();
            this.lineHighlighter = null;
            this.caretPrevY = -1.0;
        }
    }

    @Override
    public void prevPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.page(-1, selectionPolicy);
    }

    @Override
    public void nextPage(NavigationActions.SelectionPolicy selectionPolicy) {
        this.page(1, selectionPolicy);
    }

    private void page(int n3, NavigationActions.SelectionPolicy selectionPolicy) {
        Optional<Bounds> optional = this.caretSelectionBind.getUnderlyingCaret().getCaretBounds();
        this.paging = true;
        this.scrollYBy((double)n3 * this.getViewportHeight());
        optional.map(arg_0 -> ((GenericStyledArea)this).screenToLocal(arg_0)).map(bounds -> this.hit(bounds.getMinX(), bounds.getMinY() + bounds.getHeight() / 2.0).getInsertionIndex()).ifPresent(n2 -> this.caretSelectionBind.moveTo((int)n2, selectionPolicy));
        optional.ifPresent(bounds -> this.getCaretBounds().map(bounds2 -> bounds2.getMinY() - bounds.getMinY()).filter(d2 -> d2 != 0.0).ifPresent(d2 -> this.scrollYBy((double)d2)));
    }

    @Override
    public void displaceCaret(int n2) {
        this.caretSelectionBind.displaceCaret(n2);
    }

    @Override
    public void setStyle(int n2, int n3, S s2) {
        this.content.setStyle(n2, n3, s2);
    }

    @Override
    public void setStyle(int n2, S s2) {
        this.content.setStyle(n2, s2);
    }

    @Override
    public void setStyle(int n2, int n3, int n4, S s2) {
        this.content.setStyle(n2, n3, n4, s2);
    }

    @Override
    public void setStyleSpans(int n2, StyleSpans<? extends S> styleSpans) {
        this.content.setStyleSpans(n2, styleSpans);
    }

    @Override
    public void setStyleSpans(int n2, int n3, StyleSpans<? extends S> styleSpans) {
        this.content.setStyleSpans(n2, n3, styleSpans);
    }

    @Override
    public void setParagraphStyle(int n2, PS PS) {
        this.content.setParagraphStyle(n2, PS);
    }

    @Override
    public final S getTextStyleForInsertionAt(int n2) {
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialTextStyle;
        }
        return this.content.getStyleAtPosition(n2);
    }

    @Override
    public final PS getParagraphStyleForInsertionAt(int n2) {
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialParagraphStyle;
        }
        return this.content.getParagraphStyleAtPosition(n2);
    }

    @Override
    public void replaceText(int n2, int n3, String string) {
        ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument = ReadOnlyStyledDocument.fromString(string, this.getParagraphStyleForInsertionAt(n2), this.getTextStyleForInsertionAt(n2), this.segmentOps);
        this.replace(n2, n3, readOnlyStyledDocument);
    }

    @Override
    public void replace(int n2, int n3, SEG SEG, S s2) {
        ReadOnlyStyledDocument<PS, SEG, S> readOnlyStyledDocument = ReadOnlyStyledDocument.fromSegment(SEG, this.getParagraphStyleForInsertionAt(n2), s2, this.segmentOps);
        this.replace(n2, n3, readOnlyStyledDocument);
    }

    @Override
    public void replace(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        this.content.replace(n2, n3, styledDocument);
        int n4 = n2 + styledDocument.length();
        this.selectRange(n4, n4);
    }

    void replaceMulti(List<Replacement<PS, SEG, S>> list) {
        this.content.replaceMulti(list);
    }

    @Override
    public MultiChangeBuilder<PS, SEG, S> createMultiChange() {
        return new MultiChangeBuilder(this);
    }

    @Override
    public MultiChangeBuilder<PS, SEG, S> createMultiChange(int n2) {
        return new MultiChangeBuilder(this, n2);
    }

    @Override
    public void dispose() {
        if (this.undoManager != null) {
            this.undoManager.close();
        }
        this.subscriptions.unsubscribe();
        this.virtualFlow.dispose();
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        this.visibleParagraphs.suspendWhile(() -> {
            this.virtualFlow.resizeRelocate(insets.getLeft(), insets.getTop(), this.getWidth() - insets.getLeft() - insets.getRight(), this.getHeight() - insets.getTop() - insets.getBottom());
            if (this.followCaretRequested && !this.paging) {
                try (Guard guard = this.viewportDirty.suspend();){
                    this.followCaret();
                }
            }
            this.followCaretRequested = false;
            this.paging = false;
        });
    }

    TwoDimensional.Position currentLine() {
        int n2 = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(n2);
        int n3 = cell.getNode().getCurrentLineIndex(this.caretSelectionBind.getUnderlyingCaret());
        return this.paragraphLineNavigator.position(n2, n3);
    }

    void showCaretAtBottom() {
        int n2 = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(n2);
        Bounds bounds = cell.getNode().getCaretBounds(this.caretSelectionBind.getUnderlyingCaret());
        double d2 = bounds.getMaxY();
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAtOffset(n2, this.getViewportHeight() - d2));
    }

    void showCaretAtTop() {
        int n2 = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(n2);
        Bounds bounds = cell.getNode().getCaretBounds(this.caretSelectionBind.getUnderlyingCaret());
        double d2 = bounds.getMinY();
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAtOffset(n2, -d2));
    }

    final ParagraphBox.CaretOffsetX getCaretOffsetX(CaretNode caretNode) {
        return this.getCell(caretNode.getParagraphIndex()).getCaretOffsetX(caretNode);
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX caretOffsetX, TwoDimensional.Position position) {
        int n2 = position.getMajor();
        ParagraphBox<PS, SEG, S> paragraphBox = this.virtualFlow.getCell(n2).getNode();
        CharacterHit characterHit = paragraphBox.hitTextLine(caretOffsetX, position.getMinor());
        return characterHit.offset(this.getParagraphOffset(n2));
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX caretOffsetX, double d2) {
        VirtualFlowHit<Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> virtualFlowHit = this.virtualFlow.hit(0.0, d2);
        if (virtualFlowHit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (virtualFlowHit.isAfterCells()) {
            return CharacterHit.insertionAt(this.getLength());
        }
        int n2 = virtualFlowHit.getCellIndex();
        int n3 = this.getParagraphOffset(n2);
        ParagraphBox<PS, SEG, S> paragraphBox = virtualFlowHit.getCell().getNode();
        Point2D point2D = virtualFlowHit.getCellOffset();
        CharacterHit characterHit = paragraphBox.hitText(caretOffsetX, point2D.getY());
        return characterHit.offset(n3);
    }

    final Optional<Bounds> getSelectionBoundsOnScreen(Selection<PS, SEG, S> selection) {
        if (selection.getLength() == 0) {
            return Optional.empty();
        }
        ArrayList arrayList = new ArrayList(selection.getParagraphSpan());
        for (int i2 = selection.getStartParagraphIndex(); i2 <= selection.getEndParagraphIndex(); ++i2) {
            this.virtualFlow.getCellIfVisible(i2).ifPresent(cell -> ((ParagraphBox)((Object)((Object)cell.getNode()))).getSelectionBoundsOnScreen(selection).ifPresent(arrayList::add));
        }
        if (arrayList.size() == 0) {
            return Optional.empty();
        }
        double d2 = arrayList.stream().mapToDouble(Bounds::getMinX).min().getAsDouble();
        double d3 = arrayList.stream().mapToDouble(Bounds::getMaxX).max().getAsDouble();
        double d4 = arrayList.stream().mapToDouble(Bounds::getMinY).min().getAsDouble();
        double d5 = arrayList.stream().mapToDouble(Bounds::getMaxY).max().getAsDouble();
        return Optional.of(new BoundingBox(d2, d4, d3 - d2, d5 - d4));
    }

    void clearTargetCaretOffset() {
        this.caretSelectionBind.clearTargetOffset();
    }

    ParagraphBox.CaretOffsetX getTargetCaretOffset() {
        return this.caretSelectionBind.getTargetOffset();
    }

    private Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> createCell(Paragraph<PS, SEG, S> paragraph, BiConsumer<TextFlow, PS> biConsumer, Function<StyledSegment<SEG, S>, Node> function) {
        final ParagraphBox paragraphBox = new ParagraphBox(paragraph, biConsumer, function);
        paragraphBox.highlightTextFillProperty().bind(this.highlightTextFill);
        paragraphBox.wrapTextProperty().bind((ObservableValue)this.wrapTextProperty());
        paragraphBox.graphicFactoryProperty().bind(this.paragraphGraphicFactoryProperty());
        paragraphBox.graphicOffset.bind(this.virtualFlow.breadthOffsetProperty());
        EventStream<Integer> eventStream = paragraphBox.indexProperty().values().filter(n2 -> n2 != -1);
        final Subscription subscription = eventStream.subscribe(n2 -> paragraphBox.pseudoClassStateChanged(FIRST_PAR, n2 == 0));
        final Subscription subscription2 = EventStreams.combine(eventStream, this.getParagraphs().sizeProperty().values()).subscribe(tuple2 -> tuple2.exec((n2, n3) -> paragraphBox.pseudoClassStateChanged(LAST_PAR, n2 == n3 - 1)));
        Function<CaretNode, Subscription> function2 = caretNode -> {
            EventStream<Integer> eventStream = EventStreams.nonNullValuesOf(caretNode.paragraphIndexProperty());
            EventStream<Integer> eventStream2 = paragraphBox.indexProperty().values().filter(n2 -> n2 != -1);
            return EventStreams.combine(eventStream, eventStream2).subscribe(tuple2 -> {
                int n2;
                int n3 = (Integer)tuple2.get1();
                if (n3 == (n2 = ((Integer)tuple2.get2()).intValue())) {
                    paragraphBox.caretsProperty().add(caretNode);
                } else {
                    paragraphBox.caretsProperty().remove(caretNode);
                }
            });
        };
        final Subscription subscription3 = this.caretSet.addSubscriber(function2);
        final Subscription subscription4 = EventStreams.combine(eventStream, Val.wrap(this.currentParagraphProperty()).values()).map(tuple2 -> ((Integer)tuple2.get1()).equals(tuple2.get2())).subscribe(bl -> paragraphBox.pseudoClassStateChanged(HAS_CARET, (boolean)bl));
        Function<Selection, Subscription> function3 = selection -> {
            EventStream<Integer> eventStream = EventStreams.nonNullValuesOf(selection.startParagraphIndexProperty());
            EventStream<Integer> eventStream2 = EventStreams.nonNullValuesOf(selection.endParagraphIndexProperty());
            EventStream<Integer> eventStream3 = paragraphBox.indexProperty().values().filter(n2 -> n2 != -1);
            return EventStreams.combine(eventStream, eventStream2, eventStream3).subscribe(tuple3 -> {
                int n2 = (Integer)tuple3.get1();
                int n3 = (Integer)tuple3.get2();
                int n4 = (Integer)tuple3.get3();
                if (n2 <= n4 && n4 <= n3) {
                    SelectionPath selectionPath = (SelectionPath)((Object)((Object)((Object)paragraphBox.selectionsProperty().get(selection))));
                    if (selectionPath == null) {
                        Val<IndexRange> val = Val.create(() -> n4 != -1 ? this.getParagraphSelection((Selection)selection, n4) : EMPTY_RANGE, new Observable[]{selection.rangeProperty()});
                        SelectionPath selectionPath2 = new SelectionPath(val);
                        selectionPath2.getStyleClass().add((Object)selection.getSelectionName());
                        selection.configureSelectionPath(selectionPath2);
                        paragraphBox.selectionsProperty().put(selection, (Object)selectionPath2);
                    }
                } else {
                    paragraphBox.selectionsProperty().remove(selection);
                }
            });
        };
        final Subscription subscription5 = this.selectionSet.addSubscriber(function3);
        return new Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>(){

            @Override
            public ParagraphBox<PS, SEG, S> getNode() {
                return paragraphBox;
            }

            @Override
            public void updateIndex(int n2) {
                paragraphBox.setIndex(n2);
            }

            @Override
            public void dispose() {
                paragraphBox.highlightTextFillProperty().unbind();
                paragraphBox.wrapTextProperty().unbind();
                paragraphBox.graphicFactoryProperty().unbind();
                paragraphBox.graphicOffset.unbind();
                paragraphBox.dispose();
                subscription.unsubscribe();
                subscription2.unsubscribe();
                subscription3.unsubscribe();
                subscription4.unsubscribe();
                subscription5.unsubscribe();
            }
        };
    }

    private void followCaret() {
        int n2 = this.getCurrentParagraph();
        Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell = this.virtualFlow.getCell(n2);
        Bounds bounds = cell.getNode().getCaretBounds(this.caretSelectionBind.getUnderlyingCaret());
        double d2 = cell.getNode().getGraphicPrefWidth();
        Bounds bounds2 = GenericStyledArea.extendLeft(bounds, d2);
        this.virtualFlow.show(n2, bounds2);
    }

    private ParagraphBox<PS, SEG, S> getCell(int n2) {
        return this.virtualFlow.getCell(n2).getNode();
    }

    private EventStream<MouseOverTextEvent> mouseOverTextEvents(ObservableSet<ParagraphBox<PS, SEG, S>> observableSet, Duration duration) {
        return EventStreams.merge(observableSet, paragraphBox -> paragraphBox.stationaryIndices(duration).map(either -> either.unify(tuple2 -> tuple2.map((point2D, n2) -> MouseOverTextEvent.beginAt(paragraphBox.localToScreen((Point2D)point2D), this.getParagraphOffset(paragraphBox.getIndex()) + n2)), object -> MouseOverTextEvent.end())));
    }

    private int getParagraphOffset(int n2) {
        return this.position(n2, 0).toOffset();
    }

    private Bounds getParagraphBoundsOnScreen(Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell) {
        Bounds bounds = cell.getNode().getBoundsInLocal();
        Bounds bounds2 = cell.getNode().localToScreen(bounds);
        Bounds bounds3 = this.getBoundsInLocal();
        Bounds bounds4 = this.localToScreen(bounds3);
        double d2 = bounds2.getMinX() < bounds4.getMinX() ? bounds4.getMinX() : bounds2.getMinX();
        double d3 = bounds2.getMinY() < bounds4.getMinY() ? bounds4.getMinY() : bounds2.getMinY();
        double d4 = bounds4.getWidth();
        double d5 = bounds2.getMaxY() < bounds4.getMaxY() ? bounds2.getMaxY() : bounds4.getMaxY();
        return new BoundingBox(d2, d3, d4, d5 - d3);
    }

    private Optional<Bounds> getRangeBoundsOnScreen(int n2, int n3, int n4) {
        return this.virtualFlow.getCellIfVisible(n2).map(cell -> ((ParagraphBox)((Object)((Object)cell.getNode()))).getRangeBoundsOnScreen(n3, n4));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscriptions = this.subscriptions.and(subscription);
    }

    private static Bounds extendLeft(Bounds bounds, double d2) {
        if (d2 == 0.0) {
            return bounds;
        }
        return new BoundingBox(bounds.getMinX() - d2, bounds.getMinY(), bounds.getWidth() + d2, bounds.getHeight());
    }

    private void suspendVisibleParsWhile(Runnable runnable) {
        Suspendable.combine(this.beingUpdated, this.visibleParagraphs).suspendWhile(runnable);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    static {
        ArrayList arrayList = new ArrayList(Region.getClassCssMetaData());
        arrayList.add(HIGHLIGHT_TEXT_FILL);
        CSS_META_DATA_LIST = Collections.unmodifiableList(arrayList);
    }
}

