/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.TextEditingArea;
import org.fxmisc.richtext.model.StyledDocument;

public interface EditActions<PS, SEG, S>
extends TextEditingArea<PS, SEG, S> {
    default public void appendText(String string) {
        this.insertText(this.getLength(), string);
    }

    default public void append(StyledDocument<PS, SEG, S> styledDocument) {
        this.insert(this.getLength(), styledDocument);
    }

    default public void insertText(int n2, String string) {
        this.replaceText(n2, n2, string);
    }

    default public void insertText(int n2, int n3, String string) {
        int n4 = this.getAbsolutePosition(n2, n3);
        this.replaceText(n4, n4, string);
    }

    default public void insert(int n2, StyledDocument<PS, SEG, S> styledDocument) {
        this.replace(n2, n2, styledDocument);
    }

    default public void insert(int n2, int n3, StyledDocument<PS, SEG, S> styledDocument) {
        int n4 = this.getAbsolutePosition(n2, n3);
        this.replace(n4, n4, styledDocument);
    }

    default public void deleteText(IndexRange indexRange) {
        this.deleteText(indexRange.getStart(), indexRange.getEnd());
    }

    default public void deleteText(int n2, int n3) {
        this.replaceText(n2, n3, "");
    }

    default public void deleteText(int n2, int n3, int n4, int n5) {
        int n6 = this.getAbsolutePosition(n2, n3);
        int n7 = this.getAbsolutePosition(n4, n5);
        this.replaceText(n6, n7, "");
    }

    default public void deletePreviousChar() {
        int n2 = this.getCaretPosition();
        if (n2 > 0) {
            int n3 = Character.offsetByCodePoints(this.getText(), n2, -1);
            this.deleteText(n3, n2);
        }
    }

    default public void deleteNextChar() {
        int n2 = this.getCaretPosition();
        if (n2 < this.getLength()) {
            int n3 = Character.offsetByCodePoints(this.getText(), n2, 1);
            this.deleteText(n2, n3);
        }
    }

    default public void clear() {
        this.replaceText(0, this.getLength(), "");
    }

    default public void replaceText(String string) {
        this.replaceText(0, this.getLength(), string);
    }

    default public void replace(StyledDocument<PS, SEG, S> styledDocument) {
        this.replace(0, this.getLength(), styledDocument);
    }

    default public void replaceSelection(String string) {
        this.replaceText(this.getSelection(), string);
    }

    default public void replaceSelection(StyledDocument<PS, SEG, S> styledDocument) {
        this.replace(this.getSelection(), styledDocument);
    }

    default public void moveSelectedText(int n2) {
        IndexRange indexRange = this.getSelection();
        if (n2 >= indexRange.getStart() && n2 <= indexRange.getEnd() || indexRange.equals((Object)GenericStyledArea.EMPTY_RANGE)) {
            this.selectRange(n2, n2);
        } else {
            StyledDocument styledDocument = this.subDocument(indexRange.getStart(), indexRange.getEnd());
            if (n2 > indexRange.getEnd()) {
                n2 -= indexRange.getLength();
            }
            this.createMultiChange(2).deleteText(indexRange).insertAbsolutely(n2, styledDocument).commit();
            this.selectRange(n2, n2 + styledDocument.length());
        }
    }
}

