/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Collection;
import javafx.beans.NamedArg;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.fxmisc.richtext.model.EditableStyledDocument;

public class CodeArea
extends StyleClassedTextArea {
    public CodeArea(@NamedArg(value="document") EditableStyledDocument<Collection<String>, String, Collection<String>> editableStyledDocument) {
        super(editableStyledDocument, false);
        this.getStyleClass().add((Object)"code-area");
        this.getStylesheets().add((Object)CodeArea.class.getResource("code-area.css").toExternalForm());
        this.setUseInitialStyleForInsertion(true);
    }

    public CodeArea() {
        super(false);
        this.getStyleClass().add((Object)"code-area");
        this.getStylesheets().add((Object)CodeArea.class.getResource("code-area.css").toExternalForm());
        this.setUseInitialStyleForInsertion(true);
    }

    public CodeArea(@NamedArg(value="text") String string) {
        this();
        this.appendText(string);
        this.getUndoManager().forgetHistory();
        this.getUndoManager().mark();
        this.selectRange(0, 0);
    }

    @Override
    public void selectWord() {
        if (this.getLength() == 0) {
            return;
        }
        CaretSelectionBind caretSelectionBind = this.getCaretSelectionBind();
        int n2 = caretSelectionBind.getParagraphIndex();
        int n3 = caretSelectionBind.getColumnPosition();
        String string = this.getText(n2);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        breakIterator.preceding(n3);
        int n4 = breakIterator.current();
        while (n4 > 0 && string.charAt(n4 - 1) == '_') {
            if (--n4 <= 0 || breakIterator.isBoundary(n4 - 1)) continue;
            breakIterator.preceding(n4);
            n4 = breakIterator.current();
        }
        breakIterator.following(n3);
        int n5 = breakIterator.current();
        int n6 = string.length();
        while (n5 < n6 && string.charAt(n5) == '_') {
            if (++n5 < n6 && !breakIterator.isBoundary(n5 + 1)) {
                breakIterator.following(n5);
                n5 = breakIterator.current();
                continue;
            }
            if (!Character.isDigit(string.charAt(n5))) continue;
            ++n5;
        }
        caretSelectionBind.selectRange(n2, n4, n2, n5);
    }
}

