/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javafx.scene.control.IndexRange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import org.fxmisc.richtext.ClipboardHelper;
import org.fxmisc.richtext.EditActions;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;

public interface ClipboardActions<PS, SEG, S>
extends EditActions<PS, SEG, S> {
    public Optional<Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>>> getStyleCodecs();

    public void setStyleCodecs(Codec<PS> var1, Codec<StyledSegment<SEG, S>> var2);

    @Override
    public SegmentOps<SEG, S> getSegOps();

    default public void cut() {
        this.copy();
        IndexRange indexRange = this.getSelection();
        this.deleteText(indexRange.getStart(), indexRange.getEnd());
    }

    default public void copy() {
        IndexRange indexRange = this.getSelection();
        if (indexRange.getLength() > 0) {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(this.getSelectedText());
            this.getStyleCodecs().ifPresent(tuple2 -> {
                Codec codec = ReadOnlyStyledDocument.codec((Codec)tuple2._1, (Codec)tuple2._2, this.getSegOps());
                DataFormat dataFormat = ClipboardHelper.dataFormat(codec.getName());
                StyledDocument styledDocument = this.subDocument(indexRange.getStart(), indexRange.getEnd());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    codec.encode(dataOutputStream, styledDocument);
                    clipboardContent.put((Object)dataFormat, (Object)byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    System.err.println("Codec error: Exception in encoding '" + codec.getName() + "':");
                    iOException.printStackTrace();
                }
            });
            Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
        }
    }

    default public void paste() {
        Object object;
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (this.getStyleCodecs().isPresent()) {
            object = this.getStyleCodecs().get();
            Codec codec = ReadOnlyStyledDocument.codec((Codec)((Tuple2)object)._1, (Codec)((Tuple2)object)._2, this.getSegOps());
            DataFormat dataFormat = ClipboardHelper.dataFormat(codec.getName());
            if (clipboard.hasContent(dataFormat)) {
                byte[] byArray = (byte[])clipboard.getContent(dataFormat);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                StyledDocument styledDocument = null;
                try {
                    styledDocument = codec.decode(dataInputStream);
                }
                catch (IOException iOException) {
                    System.err.println("Codec error: Failed to decode '" + codec.getName() + "':");
                    iOException.printStackTrace();
                }
                if (styledDocument != null) {
                    this.replaceSelection(styledDocument);
                    return;
                }
            }
        }
        if (clipboard.hasString() && (object = clipboard.getString()) != null) {
            this.replaceSelection((String)object);
        }
    }
}

