/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import javafx.util.Duration;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionImpl;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.util.Tuple3;
import org.reactfx.util.Tuples;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

final class CaretSelectionBindImpl<PS, SEG, S>
implements CaretSelectionBind<PS, SEG, S> {
    private final CaretNode delegateCaret;
    private final Selection<PS, SEG, S> delegateSelection;
    private final Val<Integer> anchorPosition;
    private final Val<Integer> anchorParIndex;
    private final Val<Integer> anchorColPosition;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final Var<Boolean> internalStartedByAnchor = Var.newSimpleVar(true);
    private final SuspendableVal<Boolean> startedByAnchor = this.internalStartedByAnchor.suspendable();
    private Subscription subscription = () -> {};

    @Override
    public Var<Caret.CaretVisibility> showCaretProperty() {
        return this.delegateCaret.showCaretProperty();
    }

    @Override
    public Caret.CaretVisibility getShowCaret() {
        return this.delegateCaret.getShowCaret();
    }

    @Override
    public void setShowCaret(Caret.CaretVisibility caretVisibility) {
        this.delegateCaret.setShowCaret(caretVisibility);
    }

    @Override
    public ObservableValue<Integer> positionProperty() {
        return this.delegateCaret.positionProperty();
    }

    @Override
    public int getPosition() {
        return this.delegateCaret.getPosition();
    }

    @Override
    public ObservableValue<Integer> paragraphIndexProperty() {
        return this.delegateCaret.paragraphIndexProperty();
    }

    @Override
    public int getParagraphIndex() {
        return this.delegateCaret.getParagraphIndex();
    }

    @Override
    public ObservableValue<OptionalInt> lineIndexProperty() {
        return this.delegateCaret.lineIndexProperty();
    }

    @Override
    public OptionalInt getLineIndex() {
        return this.delegateCaret.getLineIndex();
    }

    @Override
    public ObservableValue<Integer> columnPositionProperty() {
        return this.delegateCaret.columnPositionProperty();
    }

    @Override
    public int getColumnPosition() {
        return this.delegateCaret.getColumnPosition();
    }

    @Override
    public ObservableValue<Boolean> visibleProperty() {
        return this.delegateCaret.visibleProperty();
    }

    @Override
    public boolean isVisible() {
        return this.delegateCaret.isVisible();
    }

    @Override
    public ObservableValue<Duration> blinkRateProperty() {
        return this.delegateCaret.blinkRateProperty();
    }

    @Override
    public Duration getBlinkRate() {
        return this.delegateCaret.getBlinkRate();
    }

    @Override
    public void setBlinkRate(Duration duration) {
        this.delegateCaret.setBlinkRate(duration);
    }

    @Override
    public ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.delegateCaret.caretBoundsProperty();
    }

    @Override
    public Optional<Bounds> getCaretBounds() {
        return this.delegateCaret.getCaretBounds();
    }

    @Override
    public void clearTargetOffset() {
        this.delegateCaret.clearTargetOffset();
    }

    @Override
    public ParagraphBox.CaretOffsetX getTargetOffset() {
        return this.delegateCaret.getTargetOffset();
    }

    @Override
    public ObservableValue<IndexRange> rangeProperty() {
        return this.delegateSelection.rangeProperty();
    }

    @Override
    public IndexRange getRange() {
        return this.delegateSelection.getRange();
    }

    @Override
    public ObservableValue<Integer> lengthProperty() {
        return this.delegateSelection.lengthProperty();
    }

    @Override
    public int getLength() {
        return this.delegateSelection.getLength();
    }

    @Override
    public ObservableValue<Integer> paragraphSpanProperty() {
        return this.delegateSelection.paragraphSpanProperty();
    }

    @Override
    public int getParagraphSpan() {
        return this.delegateSelection.getParagraphSpan();
    }

    @Override
    public final ObservableValue<StyledDocument<PS, SEG, S>> selectedDocumentProperty() {
        return this.delegateSelection.selectedDocumentProperty();
    }

    @Override
    public final StyledDocument<PS, SEG, S> getSelectedDocument() {
        return this.delegateSelection.getSelectedDocument();
    }

    @Override
    public ObservableValue<String> selectedTextProperty() {
        return this.delegateSelection.selectedTextProperty();
    }

    @Override
    public String getSelectedText() {
        return this.delegateSelection.getSelectedText();
    }

    @Override
    public ObservableValue<Integer> startPositionProperty() {
        return this.delegateSelection.startPositionProperty();
    }

    @Override
    public int getStartPosition() {
        return this.delegateSelection.getStartPosition();
    }

    @Override
    public ObservableValue<Integer> startParagraphIndexProperty() {
        return this.delegateSelection.startParagraphIndexProperty();
    }

    @Override
    public int getStartParagraphIndex() {
        return this.delegateSelection.getStartParagraphIndex();
    }

    @Override
    public ObservableValue<Integer> startColumnPositionProperty() {
        return this.delegateSelection.startColumnPositionProperty();
    }

    @Override
    public int getStartColumnPosition() {
        return this.delegateSelection.getStartColumnPosition();
    }

    @Override
    public ObservableValue<Integer> endPositionProperty() {
        return this.delegateSelection.endPositionProperty();
    }

    @Override
    public int getEndPosition() {
        return this.delegateSelection.getEndPosition();
    }

    @Override
    public ObservableValue<Integer> endParagraphIndexProperty() {
        return this.delegateSelection.endParagraphIndexProperty();
    }

    @Override
    public int getEndParagraphIndex() {
        return this.delegateSelection.getEndParagraphIndex();
    }

    @Override
    public ObservableValue<Integer> endColumnPositionProperty() {
        return this.delegateSelection.endColumnPositionProperty();
    }

    @Override
    public int getEndColumnPosition() {
        return this.delegateSelection.getEndColumnPosition();
    }

    @Override
    public ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.delegateSelection.selectionBoundsProperty();
    }

    @Override
    public Optional<Bounds> getSelectionBounds() {
        return this.delegateSelection.getSelectionBounds();
    }

    @Override
    public CaretNode getUnderlyingCaret() {
        return this.delegateCaret;
    }

    @Override
    public String getCaretName() {
        return this.delegateCaret.getCaretName();
    }

    @Override
    public Selection<PS, SEG, S> getUnderlyingSelection() {
        return this.delegateSelection;
    }

    @Override
    public String getSelectionName() {
        return this.delegateSelection.getSelectionName();
    }

    @Override
    public void configureSelectionPath(SelectionPath selectionPath) {
        this.delegateSelection.configureSelectionPath(selectionPath);
    }

    @Override
    public GenericStyledArea<PS, SEG, S> getArea() {
        return this.delegateSelection.getArea();
    }

    @Override
    public int getAnchorPosition() {
        return (Integer)this.anchorPosition.getValue();
    }

    @Override
    public ObservableValue<Integer> anchorPositionProperty() {
        return this.anchorPosition;
    }

    @Override
    public int getAnchorParIndex() {
        return (Integer)this.anchorParIndex.getValue();
    }

    @Override
    public ObservableValue<Integer> anchorParIndexProperty() {
        return this.anchorParIndex;
    }

    @Override
    public int getAnchorColPosition() {
        return (Integer)this.anchorColPosition.getValue();
    }

    @Override
    public ObservableValue<Integer> anchorColPositionProperty() {
        return this.anchorColPosition;
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public final ObservableValue<Boolean> beingUpdatedProperty() {
        return this.beingUpdated;
    }

    private boolean anchorIsStart() {
        return (Boolean)this.startedByAnchor.getValue();
    }

    CaretSelectionBindImpl(String string, String string2, GenericStyledArea<PS, SEG, S> genericStyledArea) {
        this(string, string2, genericStyledArea, new IndexRange(0, 0));
    }

    CaretSelectionBindImpl(String string, String string2, GenericStyledArea<PS, SEG, S> genericStyledArea, IndexRange indexRange) {
        this(suspendableNo -> new CaretNode(string, genericStyledArea, (SuspendableNo)suspendableNo, indexRange.getStart()), suspendableNo -> new SelectionImpl(string2, genericStyledArea, indexRange, (SuspendableNo)suspendableNo));
    }

    CaretSelectionBindImpl(Function<SuspendableNo, ? extends CaretNode> function, Function<SuspendableNo, Selection<PS, SEG, S>> function2) {
        SuspendableNo suspendableNo = new SuspendableNo();
        this.delegateCaret = function.apply(suspendableNo);
        this.delegateSelection = function2.apply(suspendableNo);
        if (this.delegateCaret.getArea() != this.delegateSelection.getArea()) {
            throw new IllegalArgumentException(String.format("Caret and Selection must be asociated with the same area. Caret area = %s | Selection area = %s", this.delegateCaret.getArea(), this.delegateSelection.getArea()));
        }
        Val<Integer> val = this.startedByAnchor.flatMap(bl -> bl != false ? Val.constant(Tuples.t(this.getStartPosition(), this.getStartParagraphIndex(), this.getStartColumnPosition())) : Val.constant(Tuples.t(this.getEndPosition(), this.getEndParagraphIndex(), this.getEndColumnPosition())));
        this.anchorPosition = val.map(Tuple3::get1);
        this.anchorParIndex = val.map(Tuple3::get2);
        this.anchorColPosition = val.map(Tuple3::get3);
        Suspendable suspendable = Suspendable.combine(this.beingUpdated, this.startedByAnchor, suspendableNo);
        this.subscription = suspendable.suspendWhen(this.getArea().beingUpdatedProperty());
    }

    @Override
    public void moveBreaksForwards(int n2, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingForwards(n2, breakIterator, this.getPosition());
        this.moveTo(n3, NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    public void moveBreaksBackwards(int n2, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingBackwards(n2, breakIterator, this.getPosition());
        this.moveTo(n3, NavigationActions.SelectionPolicy.CLEAR);
    }

    @Override
    public void selectRange(int n2, int n3) {
        this.doSelect(n2, n3, this.anchorIsStart());
    }

    @Override
    public void selectRange(int n2, int n3, int n4, int n5) {
        this.selectRange(this.textPosition(n2, n3), this.textPosition(n4, n5));
    }

    @Override
    public void updateStartBy(int n2, Selection.Direction direction) {
        int n3 = direction == Selection.Direction.LEFT ? this.getStartPosition() - n2 : this.getStartPosition() + n2;
        this.selectRange(n3, this.getEndPosition());
    }

    @Override
    public void updateEndBy(int n2, Selection.Direction direction) {
        int n3 = direction == Selection.Direction.LEFT ? this.getEndPosition() - n2 : this.getEndPosition() + n2;
        this.selectRange(this.getStartPosition(), n3);
    }

    @Override
    public void updateStartTo(int n2) {
        this.selectRange(n2, this.getEndPosition());
    }

    @Override
    public void updateStartTo(int n2, int n3) {
        this.updateStartTo(this.textPosition(n2, n3));
    }

    @Override
    public void updateStartByBreaksForward(int n2, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingForwards(n2, breakIterator, this.getStartPosition());
        this.updateStartTo(n3);
    }

    @Override
    public void updateStartByBreaksBackward(int n2, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingBackwards(n2, breakIterator, this.getStartPosition());
        this.updateStartTo(n3);
    }

    @Override
    public void updateEndTo(int n2) {
        this.selectRange(this.getStartPosition(), n2);
    }

    @Override
    public void updateEndTo(int n2, int n3) {
        this.updateEndTo(this.textPosition(n2, n3));
    }

    @Override
    public void updateEndByBreaksForward(int n2, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingForwards(n2, breakIterator, this.getStartPosition());
        this.updateEndTo(n3);
    }

    @Override
    public void updateEndByBreaksBackward(int n2, BreakIterator breakIterator) {
        if (this.getAreaLength() == 0) {
            return;
        }
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingBackwards(n2, breakIterator, this.getStartPosition());
        this.updateEndTo(n3);
    }

    @Override
    public void selectAll() {
        this.selectRange(0, this.getAreaLength());
    }

    @Override
    public void selectParagraph(int n2) {
        int n3 = this.textPosition(n2, 0);
        int n4 = this.getArea().getParagraphLength(n2);
        this.selectRange(n3, n4);
    }

    @Override
    public void selectWord(int n2) {
        if (this.getAreaLength() == 0) {
            return;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(this.getArea().getText());
        int n3 = this.calculatePositionViaBreakingBackwards(1, breakIterator, n2);
        int n4 = this.calculatePositionViaBreakingForwards(1, breakIterator, n2);
        this.selectRange(n3, n4);
    }

    @Override
    public void deselect() {
        this.selectRangeExpl(this.getPosition(), this.getPosition());
    }

    @Override
    public void selectRangeExpl(int n2, int n3, int n4, int n5) {
        this.selectRangeExpl(this.textPosition(n2, n3), this.textPosition(n4, n5));
    }

    @Override
    public void selectRangeExpl(int n2, int n3) {
        if (n2 <= n3) {
            this.doSelect(n2, n3, true);
        } else {
            this.doSelect(n3, n2, false);
        }
    }

    @Override
    public void moveTo(int n2, NavigationActions.SelectionPolicy selectionPolicy) {
        switch (selectionPolicy) {
            case CLEAR: {
                this.selectRangeExpl(n2, n2);
                break;
            }
            case ADJUST: {
                this.selectRangeExpl(this.getAnchorPosition(), n2);
                break;
            }
            case EXTEND: {
                IndexRange indexRange = this.getRange();
                int n3 = n2 <= indexRange.getStart() ? indexRange.getEnd() : (n2 >= indexRange.getEnd() ? indexRange.getStart() : this.getAnchorPosition());
                this.selectRangeExpl(n3, n2);
            }
        }
    }

    @Override
    public void moveTo(int n2, int n3, NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.textPosition(n2, n3), selectionPolicy);
    }

    @Override
    public void moveToPrevChar(NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.getPosition() > 0) {
            int n2 = Character.offsetByCodePoints(this.getArea().getText(), this.getPosition(), -1);
            this.moveTo(n2, selectionPolicy);
        }
    }

    @Override
    public void moveToNextChar(NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.getPosition() < this.getAreaLength()) {
            int n2 = Character.offsetByCodePoints(this.getArea().getText(), this.getPosition(), 1);
            this.moveTo(n2, selectionPolicy);
        }
    }

    @Override
    public void moveToParStart(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getPosition() - this.getColumnPosition(), selectionPolicy);
    }

    @Override
    public void moveToParEnd(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getPosition() - this.getColumnPosition() + this.getArea().getParagraphLength(this.getParagraphIndex()), selectionPolicy);
    }

    @Override
    public void moveToAreaStart(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(0, selectionPolicy);
    }

    @Override
    public void moveToAreaEnd(NavigationActions.SelectionPolicy selectionPolicy) {
        this.moveTo(this.getArea().getLength(), selectionPolicy);
    }

    @Override
    public void displaceCaret(int n2) {
        this.doUpdate(() -> this.delegateCaret.moveTo(n2));
    }

    @Override
    public void displaceSelection(int n2, int n3) {
        this.doUpdate(() -> {
            this.delegateSelection.selectRange(n2, n3);
            this.internalStartedByAnchor.setValue(n2 < n3);
        });
    }

    @Override
    public void dispose() {
        this.subscription.unsubscribe();
    }

    private void doSelect(int n2, int n3, boolean bl) {
        this.doUpdate(() -> {
            this.delegateSelection.selectRange(n2, n3);
            this.internalStartedByAnchor.setValue(bl);
            this.delegateCaret.moveTo(bl ? n3 : n2);
        });
    }

    private void doUpdate(Runnable runnable) {
        if (this.isBeingUpdated()) {
            runnable.run();
        } else {
            this.getArea().beingUpdatedProperty().suspendWhile(runnable);
        }
    }

    private int textPosition(int n2, int n3) {
        return this.getArea().position(n2, n3).toOffset();
    }

    private int getAreaLength() {
        return this.getArea().getLength();
    }

    private int calculatePositionViaBreakingForwards(int n2, BreakIterator breakIterator, int n3) {
        breakIterator.following(n3);
        for (int i2 = 1; i2 < n2; ++i2) {
            breakIterator.next(n2);
        }
        return breakIterator.current();
    }

    private int calculatePositionViaBreakingBackwards(int n2, BreakIterator breakIterator, int n3) {
        breakIterator.preceding(n3);
        for (int i2 = 1; i2 < n2; ++i2) {
            breakIterator.previous();
        }
        return breakIterator.current();
    }
}

