/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Bounds;
import javafx.scene.shape.Path;
import javafx.util.Duration;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CustomCssMetaData;
import org.fxmisc.richtext.CustomStyleableProperty;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.StateMachine;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class CaretNode
extends Path
implements Comparable<CaretNode>,
Caret {
    private static final Duration HALF_A_SECOND = Duration.millis((double)500.0);
    private static final EventStream<Boolean> ALWAYS_FALSE = Val.constant(false).values();
    private static final EventStream<Boolean> ALWAYS_TRUE = Val.constant(true).values();
    private final StyleableObjectProperty<Duration> blinkRate = new CustomStyleableProperty<Duration>(HALF_A_SECOND, "blinkRate", this, BLINK_RATE);
    private final SuspendableVal<Integer> position;
    private final SuspendableVal<Integer> paragraphIndex;
    private final SuspendableVal<OptionalInt> lineIndex;
    private final SuspendableVal<Integer> columnPosition;
    private final Var<Caret.CaretVisibility> showCaret = Var.newSimpleVar(Caret.CaretVisibility.AUTO);
    private final SuspendableVal<Optional<Bounds>> bounds;
    private Optional<ParagraphBox.CaretOffsetX> targetOffset = Optional.empty();
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final GenericStyledArea<?, ?, ?> area;
    private final String name;
    private final SuspendableNo dependentBeingUpdated;
    private final EventStream<?> dirty;
    private final Var<Integer> internalTextPosition;
    private Subscription subscriptions = () -> {};
    private static final CssMetaData<CaretNode, Duration> BLINK_RATE = new CustomCssMetaData<CaretNode, Duration>("-rtfx-blink-rate", StyleConverter.getDurationConverter(), Duration.millis((double)500.0), caretNode -> caretNode.blinkRate);
    private static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA_LIST;

    public ObjectProperty<Duration> blinkRateProperty() {
        return this.blinkRate;
    }

    @Override
    public Duration getBlinkRate() {
        return (Duration)this.blinkRate.getValue();
    }

    @Override
    public void setBlinkRate(Duration duration) {
        this.blinkRate.set((Object)duration);
    }

    @Override
    public final int getPosition() {
        return (Integer)this.position.getValue();
    }

    @Override
    public final ObservableValue<Integer> positionProperty() {
        return this.position;
    }

    @Override
    public final int getParagraphIndex() {
        return (Integer)this.paragraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> paragraphIndexProperty() {
        return this.paragraphIndex;
    }

    @Override
    public final OptionalInt getLineIndex() {
        return (OptionalInt)this.lineIndex.getValue();
    }

    @Override
    public final ObservableValue<OptionalInt> lineIndexProperty() {
        return this.lineIndex;
    }

    @Override
    public final int getColumnPosition() {
        return (Integer)this.columnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> columnPositionProperty() {
        return this.columnPosition;
    }

    @Override
    public final Caret.CaretVisibility getShowCaret() {
        return (Caret.CaretVisibility)((Object)this.showCaret.getValue());
    }

    @Override
    public final void setShowCaret(Caret.CaretVisibility caretVisibility) {
        this.showCaret.setValue((Object)caretVisibility);
    }

    @Override
    public final Var<Caret.CaretVisibility> showCaretProperty() {
        return this.showCaret;
    }

    @Override
    public final Optional<Bounds> getCaretBounds() {
        return (Optional)this.bounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.bounds;
    }

    @Override
    public final void clearTargetOffset() {
        this.targetOffset = Optional.empty();
    }

    @Override
    public final ParagraphBox.CaretOffsetX getTargetOffset() {
        if (!this.targetOffset.isPresent()) {
            this.targetOffset = Optional.of(this.area.getCaretOffsetX(this));
        }
        return this.targetOffset.get();
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public GenericStyledArea<?, ?, ?> getArea() {
        return this.area;
    }

    @Override
    public final String getCaretName() {
        return this.name;
    }

    public CaretNode(String string, GenericStyledArea<?, ?, ?> genericStyledArea) {
        this(string, genericStyledArea, 0);
    }

    public CaretNode(String string, GenericStyledArea<?, ?, ?> genericStyledArea, int n2) {
        this(string, genericStyledArea, genericStyledArea.beingUpdatedProperty(), n2);
    }

    public CaretNode(String string, GenericStyledArea<?, ?, ?> genericStyledArea, SuspendableNo suspendableNo, int n2) {
        this.name = string;
        this.area = genericStyledArea;
        this.dependentBeingUpdated = suspendableNo;
        this.getStyleClass().add((Object)"caret");
        this.setManaged(false);
        this.internalTextPosition = Var.newSimpleVar(n2);
        this.position = this.internalTextPosition.suspendable();
        Val<TwoDimensional.Position> val = Val.create(() -> genericStyledArea.offsetToPosition((Integer)this.internalTextPosition.getValue(), TwoDimensional.Bias.Forward), new Observable[]{this.internalTextPosition, genericStyledArea.getParagraphs()});
        this.paragraphIndex = val.map(TwoDimensional.Position::getMajor).suspendable();
        this.columnPosition = val.map(TwoDimensional.Position::getMinor).suspendable();
        this.manageSubscription(genericStyledArea.multiPlainChanges(), list -> {
            int n2 = this.getPosition();
            for (PlainTextChange plainTextChange : list) {
                int n3 = plainTextChange.getNetLength();
                if (n3 == 0) continue;
                int n4 = plainTextChange.getPosition();
                int n5 = n4 + Math.abs(n3);
                if (n4 == n2 && n3 > 0) {
                    n2 += n3;
                    continue;
                }
                if (n4 >= n2) continue;
                n2 = n2 < n5 ? n4 : n2 + n3;
            }
            if (n2 != this.getPosition()) {
                this.moveTo(n2);
            }
        });
        EventStream eventStream = this.showCaret.values().flatMap(caretVisibility -> {
            switch (caretVisibility) {
                case ON: {
                    return ALWAYS_TRUE;
                }
                case OFF: {
                    return ALWAYS_FALSE;
                }
            }
            return genericStyledArea.autoCaretBlink();
        });
        this.dirty = EventStreams.merge(EventStreams.invalidationsOf(this.positionProperty()), EventStreams.invalidationsOf((Observable)genericStyledArea.getParagraphs()));
        EventStream<Duration> eventStream2 = EventStreams.valuesOf(this.blinkRate).filter(duration -> duration != null);
        this.manageSubscription(EventStreams.combine(eventStream, eventStream2).flatMap(tuple2 -> {
            Boolean bl = (Boolean)tuple2.get1();
            Duration duration = (Duration)tuple2.get2();
            if (bl.booleanValue()) {
                return duration.lessThanOrEqualTo(Duration.ZERO) ? Val.constant(true).values() : CaretNode.booleanPulse(duration, this.dirty);
            }
            return Val.constant(false).values();
        }).feedTo(this.visibleProperty()));
        this.bounds = Val.create(() -> genericStyledArea.getCaretBoundsOnScreen(this), EventStreams.merge(genericStyledArea.viewportDirtyEvents(), this.dirty)).suspendable();
        this.lineIndex = Val.create(() -> OptionalInt.of(genericStyledArea.lineIndex(this.getParagraphIndex(), this.getColumnPosition())), this.dirty).suspendable();
        Suspendable suspendable = Suspendable.combine(this.beingUpdated, this.lineIndex, this.bounds, this.paragraphIndex, this.columnPosition, this.position);
        this.manageSubscription(suspendable.suspendWhen(suspendableNo));
    }

    @Override
    public void moveTo(int n2, int n3) {
        this.moveTo(this.textPosition(n2, n3));
    }

    @Override
    public void moveTo(int n2) {
        Runnable runnable = () -> this.internalTextPosition.setValue(n2);
        if (this.isBeingUpdated()) {
            runnable.run();
        } else {
            this.dependentBeingUpdated.suspendWhile(runnable);
        }
    }

    @Override
    public void moveToParStart() {
        this.moveTo(this.getPosition() - this.getColumnPosition());
    }

    @Override
    public void moveToParEnd() {
        this.moveTo(this.getPosition() - this.getColumnPosition() + this.area.getParagraphLength(this.getParagraphIndex()));
    }

    @Override
    public void moveToAreaEnd() {
        this.moveTo(this.area.getLength());
    }

    @Override
    public void moveToNextChar() {
        this.moveTo(this.getPosition() + 1);
    }

    @Override
    public void moveToPrevChar() {
        this.moveTo(this.getPosition() - 1);
    }

    @Override
    public void moveBreaksBackwards(int n2, BreakIterator breakIterator) {
        this.moveContentBreaks(n2, breakIterator, false);
    }

    @Override
    public void moveBreaksForwards(int n2, BreakIterator breakIterator) {
        this.moveContentBreaks(n2, breakIterator, true);
    }

    @Override
    public int compareTo(CaretNode caretNode) {
        return Integer.compare(this.hashCode(), caretNode.hashCode());
    }

    @Override
    public void dispose() {
        this.subscriptions.unsubscribe();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return String.format("CaretNode(name=%s position=%s paragraphIndex=%s columnPosition=%s %s)", this.getCaretName(), this.getPosition(), this.getParagraphIndex(), this.getColumnPosition(), super.toString());
    }

    private int textPosition(int n2, int n3) {
        return this.area.position(n2, n3).toOffset();
    }

    private <T> void manageSubscription(EventStream<T> eventStream, Consumer<T> consumer) {
        this.manageSubscription(eventStream.subscribe(consumer));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscriptions = this.subscriptions.and(subscription);
    }

    private static EventStream<Boolean> booleanPulse(Duration duration, EventStream<?> eventStream) {
        java.time.Duration duration2 = java.time.Duration.ofMillis(Math.round(duration.toMillis()));
        EventStream<?> eventStream2 = EventStreams.restartableTicks(duration2, eventStream);
        return StateMachine.init(false).on(eventStream.withDefaultEvent(null)).transition((bl, object) -> true).on(eventStream2).transition((bl, object) -> bl == false).toStateStream();
    }

    private void moveContentBreaks(int n2, BreakIterator breakIterator, boolean bl) {
        if (this.area.getLength() == 0) {
            return;
        }
        breakIterator.setText(this.area.getText());
        if (bl) {
            breakIterator.following(this.getPosition());
        } else {
            breakIterator.preceding(this.getPosition());
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            breakIterator.next();
        }
        this.moveTo(breakIterator.current());
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    static {
        ArrayList<CssMetaData<CaretNode, Duration>> arrayList = new ArrayList<CssMetaData<CaretNode, Duration>>(Path.getClassCssMetaData());
        arrayList.add(BLINK_RATE);
        CSS_META_DATA_LIST = Collections.unmodifiableList(arrayList);
    }
}

