/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.value.ObservableObjectValue;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.HorizontalHelper;
import org.fxmisc.flowless.OrientationHelper;
import org.reactfx.EventStreams;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.MemoizationList;
import org.reactfx.value.Val;
import org.reactfx.value.ValBase;

final class SizeTracker {
    private final OrientationHelper orientation;
    private final ObservableObjectValue<Bounds> viewportBounds;
    private final MemoizationList<? extends Cell<?, ?>> cells;
    private final MemoizationList<Double> breadths;
    private final Val<Double> maxKnownMinBreadth;
    private final Val<Double> breadthForCells;
    private final MemoizationList<Double> lengths;
    private final Val<Double> averageLengthEstimate;
    private final Val<Double> totalLengthEstimate;
    private final Val<Double> lengthOffsetEstimate;
    private final Subscription subscription;

    public SizeTracker(OrientationHelper orientation, ObservableObjectValue<Bounds> viewportBounds, MemoizationList<? extends Cell<?, ?>> lazyCells) {
        this.orientation = orientation;
        this.viewportBounds = viewportBounds;
        this.cells = lazyCells;
        this.breadths = lazyCells.map(orientation::minBreadth).memoize();
        this.maxKnownMinBreadth = this.breadths.memoizedItems().reduce(Math::max).orElseConst(0.0);
        this.breadthForCells = Val.combine(this.maxKnownMinBreadth, viewportBounds, (a2, b2) -> Math.max(a2, orientation.breadth((Bounds)b2)));
        Val<Function> lengthFn = (orientation instanceof HorizontalHelper ? this.breadthForCells : SizeTracker.avoidFalseInvalidations(this.breadthForCells)).map(breadth -> cell -> orientation.prefLength((Cell<?, ?>)cell, (double)breadth));
        this.lengths = this.cells.mapDynamic(lengthFn).memoize();
        LiveList<Double> knownLengths = this.lengths.memoizedItems();
        Val<Double> sumOfKnownLengths = knownLengths.reduce((a2, b2) -> a2 + b2).orElseConst(0.0);
        Val<Integer> knownLengthCount = knownLengths.sizeProperty();
        this.averageLengthEstimate = Val.create(() -> {
            for (int i2 = 0; i2 < this.cells.getMemoizedCount(); ++i2) {
                int j2 = this.cells.indexOfMemoizedItem(i2);
                this.lengths.force(j2, j2 + 1);
            }
            int count = (Integer)knownLengthCount.getValue();
            return count == 0 ? null : Double.valueOf((Double)sumOfKnownLengths.getValue() / (double)count);
        }, new Observable[]{sumOfKnownLengths, knownLengthCount});
        this.totalLengthEstimate = Val.combine(this.averageLengthEstimate, this.cells.sizeProperty(), (avg, n2) -> (double)n2.intValue() * avg);
        Val<Integer> firstVisibleIndex = Val.create(() -> this.cells.getMemoizedCount() == 0 ? null : Integer.valueOf(this.cells.indexOfMemoizedItem(0)), new Observable[]{this.cells, this.cells.memoizedItems()});
        Val<Cell> firstVisibleCell = this.cells.memoizedItems().collapse(visCells -> visCells.isEmpty() ? null : (Cell)visCells.get(0));
        Val<Integer> knownLengthCountBeforeFirstVisibleCell = Val.create(() -> firstVisibleIndex.getOpt().map(i2 -> this.lengths.getMemoizedCountBefore(Math.min(i2, this.lengths.size()))).orElse(0), new Observable[]{this.lengths, firstVisibleIndex});
        Val<Double> totalKnownLengthBeforeFirstVisibleCell = knownLengths.reduceRange(knownLengthCountBeforeFirstVisibleCell.map(n2 -> new IndexRange(0, n2.intValue())), (a2, b2) -> a2 + b2).orElseConst(0.0);
        Val<Double> unknownLengthEstimateBeforeFirstVisibleCell = Val.combine(firstVisibleIndex, knownLengthCountBeforeFirstVisibleCell, this.averageLengthEstimate, (firstIdx, knownCnt, avgLen) -> (double)(firstIdx - knownCnt) * avgLen);
        Val firstCellMinY = firstVisibleCell.flatMap(orientation::minYProperty);
        this.lengthOffsetEstimate = Val.wrap(EventStreams.combine(totalKnownLengthBeforeFirstVisibleCell.values(), unknownLengthEstimateBeforeFirstVisibleCell.values(), firstCellMinY.values()).filter(t3 -> t3.test((a2, b2, minY) -> a2 != null && b2 != null && minY != null)).thenRetainLatestFor(Duration.ofMillis(1L)).map(t3 -> t3.map((a2, b2, minY) -> a2 + b2 - minY)).toBinding(0.0));
        this.subscription = Subscription.multi(this.totalLengthEstimate.pin(), this.lengthOffsetEstimate.pin());
    }

    private static <T> Val<T> avoidFalseInvalidations(final Val<T> src) {
        return new ValBase<T>(){

            @Override
            protected Subscription connect() {
                return src.observeChanges((obs, oldVal, newVal) -> this.invalidate());
            }

            @Override
            protected T computeValue() {
                return src.getValue();
            }
        };
    }

    public void dispose() {
        this.subscription.unsubscribe();
    }

    public Val<Double> maxCellBreadthProperty() {
        return this.maxKnownMinBreadth;
    }

    public double getViewportBreadth() {
        return this.orientation.breadth((Bounds)this.viewportBounds.get());
    }

    public double getViewportLength() {
        return this.orientation.length((Bounds)this.viewportBounds.get());
    }

    public Val<Double> averageLengthEstimateProperty() {
        return this.averageLengthEstimate;
    }

    public Optional<Double> getAverageLengthEstimate() {
        return this.averageLengthEstimate.getOpt();
    }

    public Val<Double> totalLengthEstimateProperty() {
        return this.totalLengthEstimate;
    }

    public Val<Double> lengthOffsetEstimateProperty() {
        return this.lengthOffsetEstimate;
    }

    public double breadthFor(int itemIndex) {
        assert (this.cells.isMemoized(itemIndex));
        this.breadths.force(itemIndex, itemIndex + 1);
        return (Double)this.breadthForCells.getValue();
    }

    public void forgetSizeOf(int itemIndex) {
        this.breadths.forget(itemIndex, itemIndex + 1);
        this.lengths.forget(itemIndex, itemIndex + 1);
    }

    public double lengthFor(int itemIndex) {
        return (Double)this.lengths.get(itemIndex);
    }

    public double getCellLayoutBreadth() {
        return (Double)this.breadthForCells.getValue();
    }
}

