/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Parent;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.CellListManager;
import org.fxmisc.flowless.CellPositioner;
import org.fxmisc.flowless.EndOffEnd;
import org.fxmisc.flowless.MinDistanceTo;
import org.fxmisc.flowless.Offset;
import org.fxmisc.flowless.OrientationHelper;
import org.fxmisc.flowless.SizeTracker;
import org.fxmisc.flowless.StartOffStart;
import org.fxmisc.flowless.TargetPosition;
import org.fxmisc.flowless.TargetPositionVisitor;
import org.fxmisc.flowless.VirtualFlow;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.MemoizationList;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModification;

final class Navigator<T, C extends Cell<T, ?>>
extends Region
implements TargetPositionVisitor {
    private final CellListManager<T, C> cellListManager;
    private final MemoizationList<C> cells;
    private final CellPositioner<T, C> positioner;
    private final OrientationHelper orientation;
    private final ObjectProperty<VirtualFlow.Gravity> gravity;
    private final SizeTracker sizeTracker;
    private final Subscription itemsSubscription;
    private TargetPosition currentPosition = TargetPosition.BEGINNING;
    private TargetPosition targetPosition = TargetPosition.BEGINNING;
    private int firstVisibleIndex = -1;
    private int lastVisibleIndex = -1;

    public Navigator(CellListManager<T, C> cellListManager, CellPositioner<T, C> positioner, OrientationHelper orientation, ObjectProperty<VirtualFlow.Gravity> gravity, SizeTracker sizeTracker) {
        this.cellListManager = cellListManager;
        this.cells = cellListManager.getLazyCellList();
        this.positioner = positioner;
        this.orientation = orientation;
        this.gravity = gravity;
        this.sizeTracker = sizeTracker;
        this.itemsSubscription = LiveList.observeQuasiChanges(cellListManager.getLazyCellList(), this::itemsChanged);
        Bindings.bindContent((List)this.getChildren(), cellListManager.getNodes());
        gravity.addListener((prop, oldVal, newVal) -> this.requestLayout());
    }

    public void dispose() {
        this.itemsSubscription.unsubscribe();
        Bindings.unbindContent((Object)this.getChildren(), this.cellListManager.getNodes());
    }

    protected void layoutChildren() {
        int n2 = this.cells.getMemoizedCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int j2 = this.cells.indexOfMemoizedItem(i2);
            Object node = ((Cell)this.cells.get(j2)).getNode();
            if (!(node instanceof Parent) || !((Parent)node).isNeedsLayout()) continue;
            this.sizeTracker.forgetSizeOf(j2);
        }
        if (!this.cells.isEmpty()) {
            this.targetPosition.clamp(this.cells.size()).accept(this);
        }
        this.targetPosition = this.currentPosition = this.getCurrentPosition();
    }

    public void setTargetPosition(TargetPosition targetPosition) {
        this.targetPosition = targetPosition;
        this.requestLayout();
    }

    public void scrollCurrentPositionBy(double delta) {
        this.targetPosition = this.currentPosition.scrollBy(delta);
        this.requestLayout();
    }

    private TargetPosition getCurrentPosition() {
        if (this.cellListManager.getLazyCellList().getMemoizedCount() == 0) {
            return TargetPosition.BEGINNING;
        }
        C cell = this.positioner.getVisibleCell(this.firstVisibleIndex);
        return new StartOffStart(this.firstVisibleIndex, this.orientation.minY((Cell<?, ?>)cell));
    }

    private void itemsChanged(QuasiListChange<?> ch) {
        for (QuasiListModification quasiListModification : ch) {
            this.targetPosition = this.targetPosition.transformByChange(quasiListModification.getFrom(), quasiListModification.getRemovedSize(), quasiListModification.getAddedSize());
        }
        this.requestLayout();
    }

    void showLengthRegion(int itemIndex, double fromY, double toY) {
        this.setTargetPosition(new MinDistanceTo(itemIndex, Offset.fromStart(fromY), Offset.fromStart(toY)));
    }

    @Override
    public void visit(StartOffStart targetPosition) {
        this.cropToNeighborhoodOf(targetPosition.itemIndex);
        this.positioner.placeStartAt(targetPosition.itemIndex, targetPosition.offsetFromStart);
        this.fillViewportFrom(targetPosition.itemIndex);
    }

    @Override
    public void visit(EndOffEnd targetPosition) {
        this.cropToNeighborhoodOf(targetPosition.itemIndex);
        this.positioner.placeEndFromEnd(targetPosition.itemIndex, targetPosition.offsetFromEnd);
        this.fillViewportFrom(targetPosition.itemIndex);
    }

    private void cropToNeighborhoodOf(int itemIndex) {
        int begin = Math.max(0, this.getFirstVisibleIndex());
        int end = Math.max(itemIndex, this.getLastVisibleIndex());
        this.positioner.cropTo(Math.min(begin, itemIndex), end + 1);
    }

    @Override
    public void visit(MinDistanceTo targetPosition) {
        Optional<C> cell = this.positioner.getCellIfVisible(targetPosition.itemIndex);
        if (cell.isPresent()) {
            this.placeToViewport(targetPosition.itemIndex, targetPosition.minY, targetPosition.maxY);
        } else {
            OptionalInt prevVisible = this.positioner.lastVisibleBefore(targetPosition.itemIndex);
            if (prevVisible.isPresent()) {
                this.fillForwardFrom(prevVisible.getAsInt());
                cell = this.positioner.getCellIfVisible(targetPosition.itemIndex);
                if (cell.isPresent()) {
                    this.placeToViewport(targetPosition.itemIndex, targetPosition.minY, targetPosition.maxY);
                } else if (targetPosition.maxY.isFromStart()) {
                    this.placeStartOffEndMayCrop(targetPosition.itemIndex, -targetPosition.maxY.getValue());
                } else {
                    this.placeEndOffEndMayCrop(targetPosition.itemIndex, -targetPosition.maxY.getValue());
                }
            } else {
                OptionalInt nextVisible = this.positioner.firstVisibleAfter(targetPosition.itemIndex + 1);
                if (nextVisible.isPresent()) {
                    this.fillBackwardFrom(nextVisible.getAsInt());
                    cell = this.positioner.getCellIfVisible(targetPosition.itemIndex);
                    if (cell.isPresent()) {
                        this.placeToViewport(targetPosition.itemIndex, targetPosition.minY, targetPosition.maxY);
                    } else if (targetPosition.minY.isFromStart()) {
                        this.placeStartAtMayCrop(targetPosition.itemIndex, -targetPosition.minY.getValue());
                    } else {
                        this.placeEndOffStartMayCrop(targetPosition.itemIndex, -targetPosition.minY.getValue());
                    }
                } else if (targetPosition.minY.isFromStart()) {
                    this.placeStartAtMayCrop(targetPosition.itemIndex, -targetPosition.minY.getValue());
                } else {
                    this.placeEndOffStartMayCrop(targetPosition.itemIndex, -targetPosition.minY.getValue());
                }
            }
        }
        this.fillViewportFrom(targetPosition.itemIndex);
    }

    public int getFirstVisibleIndex() {
        return this.firstVisibleIndex;
    }

    public int getLastVisibleIndex() {
        return this.lastVisibleIndex;
    }

    private void placeToViewport(int itemIndex, Offset from, Offset to) {
        C cell = this.positioner.getVisibleCell(itemIndex);
        double fromY = from.isFromStart() ? from.getValue() : this.orientation.length((Cell<?, ?>)cell) + to.getValue();
        double toY = to.isFromStart() ? to.getValue() : this.orientation.length((Cell<?, ?>)cell) + to.getValue();
        this.placeToViewport(itemIndex, fromY, toY);
    }

    private void placeToViewport(int itemIndex, double fromY, double toY) {
        C cell = this.positioner.getVisibleCell(itemIndex);
        double d2 = this.positioner.shortestDeltaToViewport(cell, fromY, toY);
        this.positioner.placeStartAt(itemIndex, this.orientation.minY((Cell<?, ?>)cell) + d2);
    }

    private void placeStartAtMayCrop(int itemIndex, double startOffStart) {
        this.cropToNeighborhoodOf(itemIndex, startOffStart);
        this.positioner.placeStartAt(itemIndex, startOffStart);
    }

    private void placeStartOffEndMayCrop(int itemIndex, double startOffEnd) {
        this.cropToNeighborhoodOf(itemIndex, startOffEnd);
        this.positioner.placeStartFromEnd(itemIndex, startOffEnd);
    }

    private void placeEndOffStartMayCrop(int itemIndex, double endOffStart) {
        this.cropToNeighborhoodOf(itemIndex, endOffStart);
        this.positioner.placeEndFromStart(itemIndex, endOffStart);
    }

    private void placeEndOffEndMayCrop(int itemIndex, double endOffEnd) {
        this.cropToNeighborhoodOf(itemIndex, endOffEnd);
        this.positioner.placeEndFromEnd(itemIndex, endOffEnd);
    }

    private void cropToNeighborhoodOf(int itemIndex, double additionalOffset) {
        double spaceBefore = Math.max(0.0, this.sizeTracker.getViewportLength() + additionalOffset);
        double spaceAfter = Math.max(0.0, this.sizeTracker.getViewportLength() - additionalOffset);
        Optional<Double> avgLen = this.sizeTracker.getAverageLengthEstimate();
        int itemsBefore = avgLen.map(l2 -> spaceBefore / l2).orElse(5.0).intValue();
        int itemsAfter = avgLen.map(l2 -> spaceAfter / l2).orElse(5.0).intValue();
        this.positioner.cropTo(itemIndex - itemsBefore, itemIndex + 1 + itemsAfter);
    }

    private int fillForwardFrom(int itemIndex) {
        return this.fillForwardFrom(itemIndex, this.sizeTracker.getViewportLength());
    }

    private int fillForwardFrom0(int itemIndex) {
        return this.fillForwardFrom0(itemIndex, this.sizeTracker.getViewportLength());
    }

    private int fillForwardFrom(int itemIndex, double upTo) {
        C cell = this.positioner.getVisibleCell(itemIndex);
        double length0 = this.orientation.minY((Cell<?, ?>)cell);
        this.positioner.placeStartAt(itemIndex, length0);
        return this.fillForwardFrom0(itemIndex, upTo);
    }

    int fillForwardFrom0(int itemIndex, double upTo) {
        double max = this.orientation.maxY((Cell<?, ?>)this.positioner.getVisibleCell(itemIndex));
        int i2 = itemIndex;
        while (max < upTo && i2 < this.cellListManager.getLazyCellList().size() - 1) {
            C c2 = this.positioner.placeStartAt(++i2, max);
            max = this.orientation.maxY((Cell<?, ?>)c2);
        }
        return i2;
    }

    private int fillBackwardFrom(int itemIndex) {
        return this.fillBackwardFrom(itemIndex, 0.0);
    }

    private int fillBackwardFrom0(int itemIndex) {
        return this.fillBackwardFrom0(itemIndex, 0.0);
    }

    private int fillBackwardFrom(int itemIndex, double upTo) {
        C cell = this.positioner.getVisibleCell(itemIndex);
        double length0 = this.orientation.minY((Cell<?, ?>)cell);
        this.positioner.placeStartAt(itemIndex, length0);
        return this.fillBackwardFrom0(itemIndex, upTo);
    }

    int fillBackwardFrom0(int itemIndex, double upTo) {
        double min = this.orientation.minY((Cell<?, ?>)this.positioner.getVisibleCell(itemIndex));
        int i2 = itemIndex;
        while (min > upTo && i2 > 0) {
            C c2 = this.positioner.placeEndFromStart(--i2, min);
            min = this.orientation.minY((Cell<?, ?>)c2);
        }
        return i2;
    }

    private void fillViewportFrom(int itemIndex) {
        int first;
        int sky;
        double gapAfter;
        int ground = this.fillTowardsGroundFrom0(itemIndex);
        double gapBefore = this.distanceFromGround(ground);
        if (gapBefore > 0.0) {
            this.shiftCellsTowardsGround(ground, itemIndex, gapBefore);
        }
        if ((gapAfter = this.distanceFromSky(sky = this.fillTowardsSkyFrom0(itemIndex))) > 0.0) {
            ground = this.fillTowardsGroundFrom0(ground, -gapAfter);
            double extraBefore = -this.distanceFromGround(ground);
            double shift = Math.min(gapAfter, extraBefore);
            this.shiftCellsTowardsGround(ground, sky, -shift);
        }
        int last = Math.max(ground, sky);
        for (first = Math.min(ground, sky); first < last && this.orientation.maxY((Cell<?, ?>)this.positioner.getVisibleCell(first)) <= 0.0; ++first) {
        }
        while (last > first && this.orientation.minY((Cell<?, ?>)this.positioner.getVisibleCell(last)) >= this.sizeTracker.getViewportLength()) {
            --last;
        }
        this.firstVisibleIndex = first;
        this.lastVisibleIndex = last;
        this.positioner.cropTo(first, last + 1);
    }

    private int fillTowardsGroundFrom0(int itemIndex) {
        return this.gravity.get() == VirtualFlow.Gravity.FRONT ? this.fillBackwardFrom0(itemIndex) : this.fillForwardFrom0(itemIndex);
    }

    private int fillTowardsGroundFrom0(int itemIndex, double upTo) {
        return this.gravity.get() == VirtualFlow.Gravity.FRONT ? this.fillBackwardFrom0(itemIndex, upTo) : this.fillForwardFrom0(itemIndex, this.sizeTracker.getViewportLength() - upTo);
    }

    private int fillTowardsSkyFrom0(int itemIndex) {
        return this.gravity.get() == VirtualFlow.Gravity.FRONT ? this.fillForwardFrom0(itemIndex) : this.fillBackwardFrom0(itemIndex);
    }

    private double distanceFromGround(int itemIndex) {
        C cell = this.positioner.getVisibleCell(itemIndex);
        return this.gravity.get() == VirtualFlow.Gravity.FRONT ? this.orientation.minY((Cell<?, ?>)cell) : this.sizeTracker.getViewportLength() - this.orientation.maxY((Cell<?, ?>)cell);
    }

    private double distanceFromSky(int itemIndex) {
        C cell = this.positioner.getVisibleCell(itemIndex);
        return this.gravity.get() == VirtualFlow.Gravity.FRONT ? this.sizeTracker.getViewportLength() - this.orientation.maxY((Cell<?, ?>)cell) : this.orientation.minY((Cell<?, ?>)cell);
    }

    private void shiftCellsTowardsGround(int groundCellIndex, int lastCellIndex, double amount) {
        if (this.gravity.get() == VirtualFlow.Gravity.FRONT) {
            assert (groundCellIndex <= lastCellIndex);
            for (int i2 = groundCellIndex; i2 <= lastCellIndex; ++i2) {
                this.positioner.shiftCellBy(this.positioner.getVisibleCell(i2), -amount);
            }
        } else {
            assert (groundCellIndex >= lastCellIndex);
            for (int i3 = groundCellIndex; i3 >= lastCellIndex; --i3) {
                this.positioner.shiftCellBy(this.positioner.getVisibleCell(i3), amount);
            }
        }
    }
}

