/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
implements Serializable {
    private static final long serialVersionUID = -8832409930574867162L;
    private final Pattern[] patterns;

    public RegexValidator(String regex) {
        this(regex, true);
    }

    public RegexValidator(String regex, boolean caseSensitive) {
        this(new String[]{regex}, caseSensitive);
    }

    public RegexValidator(String[] regexs) {
        this(regexs, true);
    }

    public RegexValidator(String[] regexs, boolean caseSensitive) {
        if (regexs == null || regexs.length == 0) {
            throw new IllegalArgumentException("Regular expressions are missing");
        }
        this.patterns = new Pattern[regexs.length];
        int flags = caseSensitive ? 0 : 2;
        for (int i2 = 0; i2 < regexs.length; ++i2) {
            if (regexs[i2] == null || regexs[i2].length() == 0) {
                throw new IllegalArgumentException("Regular expression[" + i2 + "] is missing");
            }
            this.patterns[i2] = Pattern.compile(regexs[i2], flags);
        }
    }

    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            if (!this.patterns[i2].matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] match(String value) {
        if (value == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            Matcher matcher = this.patterns[i2].matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            String[] groups = new String[count];
            for (int j2 = 0; j2 < count; ++j2) {
                groups[j2] = matcher.group(j2 + 1);
            }
            return groups;
        }
        return null;
    }

    public String validate(String value) {
        if (value == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            Matcher matcher = this.patterns[i2].matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            if (count == 1) {
                return matcher.group(1);
            }
            StringBuilder buffer = new StringBuilder();
            for (int j2 = 0; j2 < count; ++j2) {
                String component = matcher.group(j2 + 1);
                if (component == null) continue;
                buffer.append(component);
            }
            return buffer.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RegexValidator{");
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            if (i2 > 0) {
                buffer.append(",");
            }
            buffer.append(this.patterns[i2].pattern());
        }
        buffer.append("}");
        return buffer.toString();
    }
}

