/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.SignatureECDSA;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;

public abstract class SignatureECDSAN
implements SignatureECDSA {
    Signature signature;
    KeyFactory keyFactory;

    abstract String getName();

    public void init() throws Exception {
        String name = this.getName();
        String foo = "SHA256withECDSA";
        if (name.equals("ecdsa-sha2-nistp384")) {
            foo = "SHA384withECDSA";
        } else if (name.equals("ecdsa-sha2-nistp521")) {
            foo = "SHA512withECDSA";
        }
        this.signature = Signature.getInstance(foo);
        this.keyFactory = KeyFactory.getInstance("EC");
    }

    public void setPubKey(byte[] r2, byte[] s2) throws Exception {
        r2 = this.insert0(r2);
        s2 = this.insert0(s2);
        String name = "secp256r1";
        if (r2.length >= 64) {
            name = "secp521r1";
        } else if (r2.length >= 48) {
            name = "secp384r1";
        }
        AlgorithmParameters param = AlgorithmParameters.getInstance("EC");
        param.init(new ECGenParameterSpec(name));
        ECParameterSpec ecparam = param.getParameterSpec(ECParameterSpec.class);
        ECPoint w2 = new ECPoint(new BigInteger(1, r2), new BigInteger(1, s2));
        PublicKey pubKey = this.keyFactory.generatePublic(new ECPublicKeySpec(w2, ecparam));
        this.signature.initVerify(pubKey);
    }

    public void setPrvKey(byte[] d2) throws Exception {
        d2 = this.insert0(d2);
        String name = "secp256r1";
        if (d2.length >= 64) {
            name = "secp521r1";
        } else if (d2.length >= 48) {
            name = "secp384r1";
        }
        AlgorithmParameters param = AlgorithmParameters.getInstance("EC");
        param.init(new ECGenParameterSpec(name));
        ECParameterSpec ecparam = param.getParameterSpec(ECParameterSpec.class);
        BigInteger _d = new BigInteger(1, d2);
        PrivateKey prvKey = this.keyFactory.generatePrivate(new ECPrivateKeySpec(_d, ecparam));
        this.signature.initSign(prvKey);
    }

    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        if (sig[0] == 48 && (sig[1] + 2 == sig.length || (sig[1] & 0x80) != 0 && (sig[2] & 0xFF) + 3 == sig.length)) {
            int index = 3;
            if ((sig[1] & 0x80) != 0 && (sig[2] & 0xFF) + 3 == sig.length) {
                index = 4;
            }
            byte[] r2 = new byte[sig[index]];
            byte[] s2 = new byte[sig[index + 2 + sig[index]]];
            System.arraycopy(sig, index + 1, r2, 0, r2.length);
            System.arraycopy(sig, index + 3 + sig[index], s2, 0, s2.length);
            r2 = this.chop0(r2);
            s2 = this.chop0(s2);
            Buffer buf = new Buffer();
            buf.putMPInt(r2);
            buf.putMPInt(s2);
            sig = new byte[buf.getLength()];
            buf.setOffSet(0);
            buf.getByte(sig);
        }
        return sig;
    }

    public void update(byte[] foo) throws Exception {
        this.signature.update(foo);
    }

    public boolean verify(byte[] sig) throws Exception {
        if (sig[0] != 48 || sig[1] + 2 != sig.length && ((sig[1] & 0x80) == 0 || (sig[2] & 0xFF) + 3 != sig.length)) {
            Buffer b2 = new Buffer(sig);
            b2.getString();
            b2.getInt();
            byte[] r2 = b2.getMPInt();
            byte[] s2 = b2.getMPInt();
            r2 = this.insert0(r2);
            s2 = this.insert0(s2);
            byte[] asn1 = null;
            if (r2.length < 64) {
                asn1 = new byte[6 + r2.length + s2.length];
                asn1[0] = 48;
                asn1[1] = (byte)(4 + r2.length + s2.length);
                asn1[2] = 2;
                asn1[3] = (byte)r2.length;
                System.arraycopy(r2, 0, asn1, 4, r2.length);
                asn1[r2.length + 4] = 2;
                asn1[r2.length + 5] = (byte)s2.length;
                System.arraycopy(s2, 0, asn1, 6 + r2.length, s2.length);
            } else {
                asn1 = new byte[6 + r2.length + s2.length + 1];
                asn1[0] = 48;
                asn1[1] = -127;
                asn1[2] = (byte)(4 + r2.length + s2.length);
                asn1[3] = 2;
                asn1[4] = (byte)r2.length;
                System.arraycopy(r2, 0, asn1, 5, r2.length);
                asn1[r2.length + 5] = 2;
                asn1[r2.length + 6] = (byte)s2.length;
                System.arraycopy(s2, 0, asn1, 7 + r2.length, s2.length);
            }
            sig = asn1;
        }
        return this.signature.verify(sig);
    }

    private byte[] insert0(byte[] buf) {
        if ((buf[0] & 0x80) == 0) {
            return buf;
        }
        byte[] tmp = new byte[buf.length + 1];
        System.arraycopy(buf, 0, tmp, 1, buf.length);
        this.bzero(buf);
        return tmp;
    }

    private byte[] chop0(byte[] buf) {
        if (buf[0] != 0) {
            return buf;
        }
        byte[] tmp = new byte[buf.length - 1];
        System.arraycopy(buf, 1, tmp, 0, tmp.length);
        this.bzero(buf);
        return tmp;
    }

    private void bzero(byte[] buf) {
        for (int i2 = 0; i2 < buf.length; ++i2) {
            buf[i2] = 0;
        }
    }
}

