/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HASH;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Vector;

class Util {
    private static final byte[] b64 = Util.str2byte("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
    private static String[] chars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    static final byte[] empty = Util.str2byte("");

    Util() {
    }

    private static byte val(byte foo) {
        if (foo == 61) {
            return 0;
        }
        for (int j2 = 0; j2 < b64.length; ++j2) {
            if (foo != b64[j2]) continue;
            return (byte)j2;
        }
        return 0;
    }

    static byte[] fromBase64(byte[] buf, int start, int length) throws JSchException {
        try {
            byte[] foo = new byte[length];
            int j2 = 0;
            for (int i2 = start; i2 < start + length; i2 += 4) {
                foo[j2] = (byte)(Util.val(buf[i2]) << 2 | (Util.val(buf[i2 + 1]) & 0x30) >>> 4);
                if (buf[i2 + 2] == 61) {
                    ++j2;
                    break;
                }
                foo[j2 + 1] = (byte)((Util.val(buf[i2 + 1]) & 0xF) << 4 | (Util.val(buf[i2 + 2]) & 0x3C) >>> 2);
                if (buf[i2 + 3] == 61) {
                    j2 += 2;
                    break;
                }
                foo[j2 + 2] = (byte)((Util.val(buf[i2 + 2]) & 3) << 6 | Util.val(buf[i2 + 3]) & 0x3F);
                j2 += 3;
            }
            byte[] bar = new byte[j2];
            System.arraycopy(foo, 0, bar, 0, j2);
            return bar;
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new JSchException("fromBase64: invalid base64 data", e2);
        }
    }

    static byte[] toBase64(byte[] buf, int start, int length) {
        int k2;
        int j2;
        byte[] tmp = new byte[length * 2];
        int foo = length / 3 * 3 + start;
        int i2 = 0;
        for (j2 = start; j2 < foo; j2 += 3) {
            k2 = buf[j2] >>> 2 & 0x3F;
            tmp[i2++] = b64[k2];
            k2 = (buf[j2] & 3) << 4 | buf[j2 + 1] >>> 4 & 0xF;
            tmp[i2++] = b64[k2];
            k2 = (buf[j2 + 1] & 0xF) << 2 | buf[j2 + 2] >>> 6 & 3;
            tmp[i2++] = b64[k2];
            k2 = buf[j2 + 2] & 0x3F;
            tmp[i2++] = b64[k2];
        }
        if ((foo = start + length - foo) == 1) {
            k2 = buf[j2] >>> 2 & 0x3F;
            tmp[i2++] = b64[k2];
            k2 = (buf[j2] & 3) << 4 & 0x3F;
            tmp[i2++] = b64[k2];
            tmp[i2++] = 61;
            tmp[i2++] = 61;
        } else if (foo == 2) {
            k2 = buf[j2] >>> 2 & 0x3F;
            tmp[i2++] = b64[k2];
            k2 = (buf[j2] & 3) << 4 | buf[j2 + 1] >>> 4 & 0xF;
            tmp[i2++] = b64[k2];
            k2 = (buf[j2 + 1] & 0xF) << 2 & 0x3F;
            tmp[i2++] = b64[k2];
            tmp[i2++] = 61;
        }
        byte[] bar = new byte[i2];
        System.arraycopy(tmp, 0, bar, 0, i2);
        return bar;
    }

    static String[] split(String foo, String split) {
        int index;
        if (foo == null) {
            return null;
        }
        byte[] buf = Util.str2byte(foo);
        Vector<String> bar = new Vector<String>();
        int start = 0;
        while ((index = foo.indexOf(split, start)) >= 0) {
            bar.addElement(Util.byte2str(buf, start, index - start));
            start = index + 1;
        }
        bar.addElement(Util.byte2str(buf, start, buf.length - start));
        String[] result = new String[bar.size()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (String)bar.elementAt(i2);
        }
        return result;
    }

    static boolean glob(byte[] pattern, byte[] name) {
        return Util.glob0(pattern, 0, name, 0);
    }

    private static boolean glob0(byte[] pattern, int pattern_index, byte[] name, int name_index) {
        if (name.length > 0 && name[0] == 46) {
            if (pattern.length > 0 && pattern[0] == 46) {
                if (pattern.length == 2 && pattern[1] == 42) {
                    return true;
                }
                return Util.glob(pattern, pattern_index + 1, name, name_index + 1);
            }
            return false;
        }
        return Util.glob(pattern, pattern_index, name, name_index);
    }

    private static boolean glob(byte[] pattern, int pattern_index, byte[] name, int name_index) {
        int patternlen = pattern.length;
        if (patternlen == 0) {
            return false;
        }
        int namelen = name.length;
        int i2 = pattern_index;
        int j2 = name_index;
        while (i2 < patternlen && j2 < namelen) {
            if (pattern[i2] == 92) {
                if (i2 + 1 == patternlen) {
                    return false;
                }
                if (pattern[++i2] != name[j2]) {
                    return false;
                }
                i2 += Util.skipUTF8Char(pattern[i2]);
                j2 += Util.skipUTF8Char(name[j2]);
                continue;
            }
            if (pattern[i2] == 42) {
                while (i2 < patternlen && pattern[i2] == 42) {
                    ++i2;
                }
                if (patternlen == i2) {
                    return true;
                }
                byte foo = pattern[i2];
                if (foo == 63) {
                    while (j2 < namelen) {
                        if (Util.glob(pattern, i2, name, j2)) {
                            return true;
                        }
                        j2 += Util.skipUTF8Char(name[j2]);
                    }
                    return false;
                }
                if (foo == 92) {
                    if (i2 + 1 == patternlen) {
                        return false;
                    }
                    foo = pattern[++i2];
                    while (j2 < namelen) {
                        if (foo == name[j2] && Util.glob(pattern, i2 + Util.skipUTF8Char(foo), name, j2 + Util.skipUTF8Char(name[j2]))) {
                            return true;
                        }
                        j2 += Util.skipUTF8Char(name[j2]);
                    }
                    return false;
                }
                while (j2 < namelen) {
                    if (foo == name[j2] && Util.glob(pattern, i2, name, j2)) {
                        return true;
                    }
                    j2 += Util.skipUTF8Char(name[j2]);
                }
                return false;
            }
            if (pattern[i2] == 63) {
                ++i2;
                j2 += Util.skipUTF8Char(name[j2]);
                continue;
            }
            if (pattern[i2] != name[j2]) {
                return false;
            }
            i2 += Util.skipUTF8Char(pattern[i2]);
            if ((j2 += Util.skipUTF8Char(name[j2])) < namelen) continue;
            if (i2 >= patternlen) {
                return true;
            }
            if (pattern[i2] != 42) continue;
        }
        if (i2 == patternlen && j2 == namelen) {
            return true;
        }
        if (j2 >= namelen && pattern[i2] == 42) {
            boolean ok = true;
            while (i2 < patternlen) {
                if (pattern[i2++] == 42) continue;
                ok = false;
                break;
            }
            return ok;
        }
        return false;
    }

    static String quote(String path) {
        byte[] _path = Util.str2byte(path);
        int count = 0;
        for (int i2 = 0; i2 < _path.length; ++i2) {
            byte b2 = _path[i2];
            if (b2 != 92 && b2 != 63 && b2 != 42) continue;
            ++count;
        }
        if (count == 0) {
            return path;
        }
        byte[] _path2 = new byte[_path.length + count];
        int j2 = 0;
        for (int i3 = 0; i3 < _path.length; ++i3) {
            byte b3 = _path[i3];
            if (b3 == 92 || b3 == 63 || b3 == 42) {
                _path2[j2++] = 92;
            }
            _path2[j2++] = b3;
        }
        return Util.byte2str(_path2);
    }

    static String unquote(String path) {
        byte[] bar;
        byte[] foo = Util.str2byte(path);
        if (foo.length == (bar = Util.unquote(foo)).length) {
            return path;
        }
        return Util.byte2str(bar);
    }

    static byte[] unquote(byte[] path) {
        int pathlen = path.length;
        int i2 = 0;
        while (i2 < pathlen) {
            if (path[i2] == 92) {
                if (i2 + 1 == pathlen) break;
                System.arraycopy(path, i2 + 1, path, i2, path.length - (i2 + 1));
                --pathlen;
                ++i2;
                continue;
            }
            ++i2;
        }
        if (pathlen == path.length) {
            return path;
        }
        byte[] foo = new byte[pathlen];
        System.arraycopy(path, 0, foo, 0, pathlen);
        return foo;
    }

    static String getFingerPrint(HASH hash, byte[] data) {
        try {
            hash.init();
            hash.update(data, 0, data.length);
            byte[] foo = hash.digest();
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < foo.length; ++i2) {
                int bar = foo[i2] & 0xFF;
                sb.append(chars[bar >>> 4 & 0xF]);
                sb.append(chars[bar & 0xF]);
                if (i2 + 1 >= foo.length) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return "???";
        }
    }

    static boolean array_equals(byte[] foo, byte[] bar) {
        int i2 = foo.length;
        if (i2 != bar.length) {
            return false;
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            if (foo[j2] == bar[j2]) continue;
            return false;
        }
        return true;
    }

    static Socket createSocket(String host, int port, int timeout) throws JSchException {
        Socket socket = null;
        if (timeout == 0) {
            try {
                socket = new Socket(host, port);
                return socket;
            }
            catch (Exception e2) {
                String message = e2.toString();
                if (e2 instanceof Throwable) {
                    throw new JSchException(message, e2);
                }
                throw new JSchException(message);
            }
        }
        final String _host = host;
        final int _port = port;
        final Socket[] sockp = new Socket[1];
        final Exception[] ee = new Exception[1];
        String message = "";
        Thread tmp = new Thread(new Runnable(){

            public void run() {
                sockp[0] = null;
                try {
                    sockp[0] = new Socket(_host, _port);
                }
                catch (Exception e2) {
                    ee[0] = e2;
                    if (sockp[0] != null && sockp[0].isConnected()) {
                        try {
                            sockp[0].close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    sockp[0] = null;
                }
            }
        });
        tmp.setName("Opening Socket " + host);
        tmp.start();
        try {
            tmp.join(timeout);
            message = "timeout: ";
        }
        catch (InterruptedException eee) {
            // empty catch block
        }
        if (sockp[0] == null || !sockp[0].isConnected()) {
            message = message + "socket is not established";
            if (ee[0] != null) {
                message = ee[0].toString();
            }
            tmp.interrupt();
            tmp = null;
            throw new JSchException(message, ee[0]);
        }
        socket = sockp[0];
        return socket;
    }

    static byte[] str2byte(String str, String encoding) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e2) {
            return str.getBytes();
        }
    }

    static byte[] str2byte(String str) {
        return Util.str2byte(str, "UTF-8");
    }

    static String byte2str(byte[] str, String encoding) {
        return Util.byte2str(str, 0, str.length, encoding);
    }

    static String byte2str(byte[] str, int s2, int l2, String encoding) {
        try {
            return new String(str, s2, l2, encoding);
        }
        catch (UnsupportedEncodingException e2) {
            return new String(str, s2, l2);
        }
    }

    static String byte2str(byte[] str) {
        return Util.byte2str(str, 0, str.length, "UTF-8");
    }

    static String byte2str(byte[] str, int s2, int l2) {
        return Util.byte2str(str, s2, l2, "UTF-8");
    }

    static String toHex(byte[] str) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < str.length; ++i2) {
            String foo = Integer.toHexString(str[i2] & 0xFF);
            sb.append("0x" + (foo.length() == 1 ? "0" : "") + foo);
            if (i2 + 1 >= str.length) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    static void bzero(byte[] foo) {
        if (foo == null) {
            return;
        }
        for (int i2 = 0; i2 < foo.length; ++i2) {
            foo[i2] = 0;
        }
    }

    static String diffString(String str, String[] not_available) {
        String[] stra = Util.split(str, ",");
        String result = null;
        block0: for (int i2 = 0; i2 < stra.length; ++i2) {
            for (int j2 = 0; j2 < not_available.length; ++j2) {
                if (stra[i2].equals(not_available[j2])) continue block0;
            }
            result = result == null ? stra[i2] : result + "," + stra[i2];
        }
        return result;
    }

    static String checkTilde(String str) {
        try {
            if (str.startsWith("~")) {
                str = str.replace("~", System.getProperty("user.home"));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return str;
    }

    private static int skipUTF8Char(byte b2) {
        if ((byte)(b2 & 0x80) == 0) {
            return 1;
        }
        if ((byte)(b2 & 0xE0) == -64) {
            return 2;
        }
        if ((byte)(b2 & 0xF0) == -32) {
            return 3;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] fromFile(String _file) throws IOException {
        _file = Util.checkTilde(_file);
        File file = new File(_file);
        FileInputStream fis = new FileInputStream(_file);
        try {
            int i2;
            byte[] result = new byte[(int)file.length()];
            int len = 0;
            while ((i2 = fis.read(result, len, result.length - len)) > 0) {
                len += i2;
            }
            fis.close();
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

