{$mode objfpc}

unit avxopcodes;

interface

uses Classes;

type

  TTestFileTyp = (tfNasm, tfFPC, tfFasm, tfFPCInc, tfFPCMRef, tfFPCCDisp8);

  { TAVXTestGenerator }

  TAVXTestGenerator = class(TObject)
  private
    FOpCodeList: TStringList;
  protected
    procedure Init;

    function SaveFile(aAsmList: TStringList; aOpcode, aDestPath, aFileExt: String; aHeaderList, aFooterList: TStringList): boolean;

    function InternalMakeTestFiles(aMRef, aX64, aAVX512, aSAE: boolean; aDestPath, aFilemask, aFileExt: String; aOpCodeList, aHeaderList, aFooterList: TStringList): boolean;
    function InternalMakeTestFilesCDisp8(aX64, aAVX512, aSAE: boolean; aDestPath, aFilemask, aFileExt: String; aOpCodeList, aHeaderList, aFooterList: TStringList): boolean;

  public
    constructor Create;
    destructor Destroy; override;

    function MakeTestFiles(aTyp: TTestFileTyp; aX64, aAVX512, aSAE: boolean; aDestPath, aFilemask: String): boolean;
    procedure ListMemRefState;
//    function MakeTestFilesMREF(aTyp: TTestFileTyp; aX64, aAVX512, aSAE: boolean; aDestPath: String): boolean;

    property OpCodeList: TStringList read FOpCodeList write FOpCodeList;
  end;

implementation

uses SysUtils, AsmTestGenerator, Dialogs;

{ TAVXTestGenerator }

constructor TAVXTestGenerator.Create;
var
  i: integer;
begin
  inherited;

  FOpCodeList := TStringList.Create;
  FOpCodeList.Duplicates := dupIgnore;
  FOpCodeList.Sorted := true;

  Init;


  FOpCodeList.Sorted := false;
  for i := 0 to FOpCodeList.Count - 1 do
   FOpCodeList[i] := AnsiLowerCase(FOpCodeList[i]);
end;

destructor TAVXTestGenerator.Destroy;
begin
  FreeAndNil(FOpCodeList);

  inherited;
end;

{$define TEST_SHA}
{$define TEST_XSAVE}
{$define TEST_ALL}

procedure TAVXTestGenerator.Init;
begin
  // Opcode, i386, x8664, AVX512, Parameter
{$if defined(TEST_SHA) or defined(TEST_ALL)}
  { SHA opcodes }
  FOpCodeList.Add('SHA1RNDS4,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('SHA1NEXTE,1,1,0,XMMREG,XMMRM,,');  
  FOpCodeList.Add('SHA1MSG1,1,1,0,XMMREG,XMMRM,,');  
  FOpCodeList.Add('SHA1MSG2,1,1,0,XMMREG,XMMRM,,');  
  FOpCodeList.Add('SHA256RNDS2,1,1,0,XMMREG,XMMRM,,');  
  FOpCodeList.Add('SHA256MSG1,1,1,0,XMMREG,XMMRM,,');  
  FOpCodeList.Add('SHA256MSG2,1,1,0,XMMREG,XMMRM,,');  
{$endif defined(TEST_SHA) or defined(TEST_ALL)}

{$if defined(TEST_XSAVE) or defined(TEST_ALL)}
  { XSAVE opcodes }
  FOpCodeList.Add('XGETBV,1,1,0,,,,,');
  FOpCodeList.Add('XSETBV,1,1,0,,,,,');
  FOpCodeList.Add('XSAVE,1,1,0,MEM64,,,,');
  FOpCodeList.Add('XSAVE64,1,1,0,MEM64,,,,');
  FOpCodeList.Add('XRSTOR,1,1,0,MEM64,,,,');
  FOpCodeList.Add('XRSTOR64,1,1,0,MEM64,,,,');
  FOpCodeList.Add('XSAVEOPT,1,1,0,MEM64,,,,');
  FOpCodeList.Add('XSAVEOPT64,1,1,0,MEM64,,,,');
{$endif defined(TEST_XSAVE) or defined(TEST_ALL)}

{$ifdef TEST_ALL}
  FOpCodeList.Add('ADDSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('ADDSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('ADDSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('ADDSD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('CMPEQSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPEQSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('CMPLTSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPLTSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('CMPNEQSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPNEQSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('CMPNLESS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPNLESS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('CMPNLTSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPNLTSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('CMPORDSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPORDSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('CMPUNORDSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPUNORDSS,1,1,0,XMMREG,MEM32,,,');
//  FOpCodeList.Add('CMPSS,1,1,0,XMMREG,XMMREG,IMM8,,');
//  FOpCodeList.Add('CMPSS,1,1,0,XMMREG,MEM32,IMM8,,');
  FOpCodeList.Add('COMISS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('COMISS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('cvtsd2si,1,1,0,REG32,MEM64,,');
  FOpCodeList.Add('cvtsd2si,1,1,0,REG32,XMMREG_ER,,');
  FOpCodeList.Add('cvtsd2si,1,1,0,REG64,MEM64,,');
  FOpCodeList.Add('cvtsd2si,1,1,0,REG64,XMMREG_ER,,');
  FOpCodeList.Add('cvtss2si,1,1,0,REG32,MEM32,,');
  FOpCodeList.Add('cvtss2si,1,1,0,REG32,XMMREG_ER,,');
  FOpCodeList.Add('cvtss2si,1,1,0,REG64,MEM32,,');
  FOpCodeList.Add('cvtss2si,1,1,0,REG64,XMMREG_ER,,');
  FOpCodeList.Add('cvttsd2si,1,1,0,REG32,MEM64,,');
  FOpCodeList.Add('cvttsd2si,1,1,0,REG32,XMMREG_SAE,,');
  FOpCodeList.Add('cvttsd2si,1,1,0,REG64,MEM64,,');
  FOpCodeList.Add('cvttsd2si,1,1,0,REG64,XMMREG_SAE,,');
  FOpCodeList.Add('cvttss2si,1,1,0,REG32,MEM32,,');
  FOpCodeList.Add('cvttss2si,1,1,0,REG32,XMMREG_SAE,,');
  FOpCodeList.Add('cvttss2si,1,1,0,REG64,MEM32,,');
  FOpCodeList.Add('cvttss2si,1,1,0,REG64,XMMREG_SAE,,');

  FOpCodeList.Add('DIVSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('DIVSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('MAXSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MAXSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('MINSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MINSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('MOVSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MOVSS,1,1,0,XMMREG,MEM32,,,');
  FOpCodeList.Add('MOVSS,1,1,0,MEM32,XMMREG,,,');

  FOpCodeList.Add('MULSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MULSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('RCPSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('RCPSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('RSQRTSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('RSQRTSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('SQRTSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('SQRTSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('SUBSS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('SUBSS,1,1,0,XMMREG,MEM32,,,');

  FOpCodeList.Add('UCOMISS,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('UCOMISS,1,1,0,XMMREG,MEM32,,,');



  FOpCodeList.Add('CMPEQSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPEQSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('CMPLTSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPLTSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('CMPNEQSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPNEQSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('CMPNLESD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPNLESD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('CMPNLTSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPNLTSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('CMPORDSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPORDSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('CMPUNORDSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('CMPUNORDSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('COMISD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('COMISD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('DIVSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('DIVSD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('MAXSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MAXSD,1,1,0,XMMREG,MEM64,,,');
  FOpCodeList.Add('MINSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MINSD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('MULSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('MULSD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('SQRTSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('SQRTSD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('SUBSD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('SUBSD,1,1,0,XMMREG,MEM64,,,');

  FOpCodeList.Add('UCOMISD,1,1,0,XMMREG,XMMREG,,,');
  FOpCodeList.Add('UCOMISD,1,1,0,XMMREG,MEM64,,,');



  FOpCodeList.Add('ADCX,1,1,0,REG32,RM32,,,');
  FOpCodeList.Add('ADCX,1,1,0,REG64,RM64,,,');
  FOpCodeList.Add('ADOX,1,1,0,REG32,RM32,,,');
  FOpCodeList.Add('ADOX,1,1,0,REG64,RM64,,,');

  FOpCodeList.Add('BLSI,1,1,0,REG32,RM32,,,');
  FOpCodeList.Add('BLSI,1,1,0,REG64,RM64,,,');
  FOpCodeList.Add('BLSR,1,1,0,REG32,RM32,,,');
  FOpCodeList.Add('BLSR,1,1,0,REG64,RM64,,,');
  FOpCodeList.Add('BLSMSK,1,1,0,REG32,RM32,,,');
  FOpCodeList.Add('BLSMSK,1,1,0,REG64,RM64,,,');
  FOpCodeList.Add('BZHI,1,1,0,REG32,RM32,REG32,,');
  FOpCodeList.Add('BZHI,1,1,0,REG64,RM64,REG64,,');
  FOpCodeList.Add('MULX,1,1,0,REG32,REG32,RM32,,');
  FOpCodeList.Add('MULX,1,1,0,REG64,REG64,RM64,,');
  FOpCodeList.Add('PDEP,1,1,0,REG32,REG32,RM32,,');
  FOpCodeList.Add('PDEP,1,1,0,REG64,REG64,RM64,,');
  FOpCodeList.Add('PEXT,1,1,0,REG32,REG32,RM32,,');
  FOpCodeList.Add('PEXT,1,1,0,REG64,REG64,RM64,,');

  FOpCodeList.Add('MOVBE,1,1,0,REG16,MEM16,,,');
  FOpCodeList.Add('MOVBE,1,1,0,MEM16,REG16,,,');
  FOpCodeList.Add('MOVBE,1,1,0,REG32,MEM32,,,');
  FOpCodeList.Add('MOVBE,1,1,0,MEM32,REG32,,,');
  FOpCodeList.Add('MOVBE,1,1,0,REG64,MEM64,,,');
  FOpCodeList.Add('MOVBE,1,1,0,MEM64,REG64,,,');

  FOpCodeList.Add('PCLMULQDQ,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('VPCLMULQDQ,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');



  FOpCodeList.Add('vaddpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vaddpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vaddpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vaddpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vaddpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vaddpd,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vaddpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vaddps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vaddps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vaddps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vaddps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vaddps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vaddps,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vaddps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vaddsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vaddsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vaddss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vaddss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vaddsubpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vaddsubpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vaddsubps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vaddsubps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vaesdec,1,1,1,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vaesdeclast,1,1,1,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vaesenc,1,1,1,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vaesenclast,1,1,1,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vaesimc,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vaeskeygenassist,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vandnpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vandnpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vandnpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vandnpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vandnpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vandnpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vandnps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vandnps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vandnps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vandnps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vandnps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vandnps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vandpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vandpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vandpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vandpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vandpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vandpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vandps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vandps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vandps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vandps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vandps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vandps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vblendpd,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vblendpd,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vblendps,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vblendps,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vblendvpd,1,1,0,XMMREG,XMMREG,XMMRM,XMMREG');
  FOpCodeList.Add('vblendvpd,1,1,0,YMMREG,YMMREG,YMMRM,YMMREG');
  FOpCodeList.Add('vblendvps,1,1,0,XMMREG,XMMREG,XMMRM,XMMREG');
  FOpCodeList.Add('vblendvps,1,1,0,YMMREG,YMMREG,YMMRM,YMMREG');
  FOpCodeList.Add('vbroadcastf128,1,1,0,YMMREG,MEM128,,');
  FOpCodeList.Add('vbroadcastsd,1,1,1,YMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vbroadcastsd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vbroadcastsd,1,1,1,ZMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vbroadcastsd,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vbroadcastss,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vbroadcastss,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vbroadcastss,1,1,1,YMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vbroadcastss,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vbroadcastss,1,1,1,ZMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vbroadcastss,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcmpeqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpltps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpltps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpleps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpleps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpunordps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpunordps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnltps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnltps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnleps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnleps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpordps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpordps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeq_uqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeq_uqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpngeps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpngeps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpngtps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpngtps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpfalseps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpfalseps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneq_oqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneq_oqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpgeps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpgeps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpgtps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpgtps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmptrueps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmptrueps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeq_osps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeq_osps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmplt_oqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmplt_oqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmple_oqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmple_oqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpunord_sps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpunord_sps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneq_usps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneq_usps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnlt_uqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnlt_uqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnle_uqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnle_uqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpord_sps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpord_sps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeq_usps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeq_usps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnge_uqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnge_uqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpngt_uqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpngt_uqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpfalse_osps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpfalse_osps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneq_osps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneq_osps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpge_oqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpge_oqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpgt_oqps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpgt_oqps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmptrue_usps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmptrue_usps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpltpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpltpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmplepd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmplepd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpunordpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpunordpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnltpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnltpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnlepd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnlepd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpordpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpordpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeq_uqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeq_uqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpngepd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpngepd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpngtpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpngtpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpfalsepd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpfalsepd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneq_oqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneq_oqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpgepd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpgepd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpgtpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpgtpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmptruepd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmptruepd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeq_ospd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeq_ospd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmplt_oqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmplt_oqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmple_oqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmple_oqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpunord_spd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpunord_spd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneq_uspd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneq_uspd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnlt_uqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnlt_uqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnle_uqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnle_uqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpord_spd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpord_spd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpeq_uspd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpeq_uspd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpnge_uqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpnge_uqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpngt_uqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpngt_uqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpfalse_ospd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpfalse_ospd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpneq_ospd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpneq_ospd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpge_oqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpge_oqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmpgt_oqpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmpgt_oqpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmptrue_uspd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vcmptrue_uspd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,XMMREG,2B64,IMM8');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,YMMREG,4B64,IMM8');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,ZMMREG,MEM512,IMM8');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,ZMMREG,8B64,IMM8');
  FOpCodeList.Add('vcmppd,1,1,1,KREG_M,ZMMREG,ZMMREG_SAE,IMM8');
  FOpCodeList.Add('vcmppd,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vcmppd,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,XMMREG,4B32,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,YMMREG,8B32,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,ZMMREG,MEM512,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,ZMMREG,16B32,IMM8');
  FOpCodeList.Add('vcmpps,1,1,1,KREG_M,ZMMREG,ZMMREG_SAE,IMM8');
  FOpCodeList.Add('vcmpps,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vcmpps,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vcmpsd,1,1,1,KREG_M,XMMREG,MEM64,IMM8');
  FOpCodeList.Add('vcmpsd,1,1,1,KREG_M,XMMREG,XMMREG_SAE,IMM8');
  FOpCodeList.Add('vcmpsd,1,1,0,XMMREG,XMMREG,XMMREG,IMM8');
  FOpCodeList.Add('vcmpsd,1,1,0,XMMREG,XMMREG,MEM64,IMM8');
  FOpCodeList.Add('vcmpss,1,1,1,KREG_M,XMMREG,MEM32,IMM8');
  FOpCodeList.Add('vcmpss,1,1,1,KREG_M,XMMREG,XMMREG_SAE,IMM8');
  FOpCodeList.Add('vcmpss,1,1,0,XMMREG,XMMREG,XMMREG,IMM8');
  FOpCodeList.Add('vcmpss,1,1,0,XMMREG,XMMREG,MEM32,IMM8');
  FOpCodeList.Add('vcomisd,1,1,1,XMMREG,MEM64,,');
  FOpCodeList.Add('vcomisd,1,1,1,XMMREG,XMMREG_SAE,,');
  FOpCodeList.Add('vcomiss,1,1,1,XMMREG,MEM32,,');
  FOpCodeList.Add('vcomiss,1,1,1,XMMREG,XMMREG_SAE,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,XMMREG_MZ,2B32,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,YMMREG_MZ,4B32,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vcvtdq2pd,1,1,1,ZMMREG_MZ,8B32,,');

  FOpCodeList.Add('vcvtdq2ps,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vcvtdq2ps,1,1,1,XMMREG_MZ,4B32,,');
  FOpCodeList.Add('vcvtdq2ps,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vcvtdq2ps,1,1,1,YMMREG_MZ,8B32,,');
  FOpCodeList.Add('vcvtdq2ps,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vcvtdq2ps,1,1,1,ZMMREG_MZ,16B32,,');
  FOpCodeList.Add('vcvtdq2ps,1,1,1,ZMMREG_MZ,ZMMREG_ER,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,XMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,XMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,XMMREG_MZ,2B64,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,XMMREG_MZ,4B64,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,XMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,YMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,YMMREG_MZ,8B64,,');
  FOpCodeList.Add('vcvtpd2dq,1,1,1,YMMREG_MZ,ZMMREG,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,XMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,XMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,XMMREG_MZ,2B64,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,XMMREG_MZ,4B64,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,XMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,YMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,YMMREG_MZ,8B64,,');
  FOpCodeList.Add('vcvtpd2ps,1,1,1,YMMREG_MZ,ZMMREG_ER,,');
  FOpCodeList.Add('vcvtph2ps,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vcvtph2ps,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtph2ps,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvtph2ps,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtph2ps,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvtph2ps,1,1,1,ZMMREG_MZ,YMMREG_SAE,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,XMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,XMMREG_MZ,4B32,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,YMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,YMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,YMMREG_MZ,8B32,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,ZMMREG_MZ,16B32,,');
  FOpCodeList.Add('vcvtps2dq,1,1,1,ZMMREG_MZ,ZMMREG_ER,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,XMMREG_MZ,2B32,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,YMMREG_MZ,4B32,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,ZMMREG_MZ,YMMREG_SAE,,');
  FOpCodeList.Add('vcvtps2pd,1,1,1,ZMMREG_MZ,8B32,,');
  FOpCodeList.Add('vcvtps2ph,1,1,1,MEM128_M,YMMREG,IMM8,');
  FOpCodeList.Add('vcvtps2ph,1,1,1,MEM256_M,ZMMREG_SAE,IMM8,');
  FOpCodeList.Add('vcvtps2ph,1,1,1,MEM64_M,XMMREG,IMM8,');
  FOpCodeList.Add('vcvtps2ph,1,1,1,XMMREG_MZ,XMMREG,IMM8,');
  FOpCodeList.Add('vcvtps2ph,1,1,1,XMMREG_MZ,YMMREG,IMM8,');
  FOpCodeList.Add('vcvtps2ph,1,1,1,YMMREG_MZ,ZMMREG_SAE,IMM8,');
  FOpCodeList.Add('vcvtsd2si,1,1,1,REG32,MEM64,,');
  FOpCodeList.Add('vcvtsd2si,1,1,1,REG32,XMMREG_ER,,');
  FOpCodeList.Add('vcvtsd2si,1,1,1,REG64,MEM64,,');
  FOpCodeList.Add('vcvtsd2si,1,1,1,REG64,XMMREG_ER,,');
  FOpCodeList.Add('vcvtsd2ss,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vcvtsd2ss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vcvtsi2sd,1,1,1,XMMREG,XMMREG,REG32,');
  FOpCodeList.Add('vcvtsi2sd,1,1,1,XMMREG,XMMREG,MEM32,');
  FOpCodeList.Add('vcvtsi2sd,0,1,1,XMMREG,XMMREG_ER,REG64,');
  FOpCodeList.Add('vcvtsi2sd,0,1,1,XMMREG,XMMREG,MEM64,');
  FOpCodeList.Add('vcvtsi2ss,1,1,1,XMMREG,XMMREG,REG32,');
  FOpCodeList.Add('vcvtsi2ss,0,1,1,XMMREG,XMMREG_ER,REG64,');
  FOpCodeList.Add('vcvtss2sd,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vcvtss2sd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_SAE,');
  FOpCodeList.Add('vcvtss2si,1,1,1,REG32,MEM32,,');
  FOpCodeList.Add('vcvtss2si,1,1,1,REG32,XMMREG_ER,,');
  FOpCodeList.Add('vcvtss2si,1,1,1,REG64,MEM32,,');
  FOpCodeList.Add('vcvtss2si,1,1,1,REG64,XMMREG_ER,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,XMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,XMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,XMMREG_MZ,2B64,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,XMMREG_MZ,4B64,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,XMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,YMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,YMMREG_MZ,8B64,,');
  FOpCodeList.Add('vcvttpd2dq,1,1,1,YMMREG_MZ,ZMMREG_SAE,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,XMMREG_MZ,4B32,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,YMMREG_MZ,8B32,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,ZMMREG_MZ,16B32,,');
  FOpCodeList.Add('vcvttps2dq,1,1,1,ZMMREG_MZ,ZMMREG_SAE,,');
  FOpCodeList.Add('vcvttsd2si,1,1,1,REG32,MEM64,,');
  FOpCodeList.Add('vcvttsd2si,1,1,1,REG32,XMMREG_SAE,,');
  FOpCodeList.Add('vcvttsd2si,1,1,1,REG64,MEM64,,');
  FOpCodeList.Add('vcvttsd2si,1,1,1,REG64,XMMREG_SAE,,');
  FOpCodeList.Add('vcvttss2si,1,1,1,REG32,MEM32,,');
  FOpCodeList.Add('vcvttss2si,1,1,1,REG32,XMMREG_SAE,,');
  FOpCodeList.Add('vcvttss2si,1,1,1,REG64,MEM32,,');
  FOpCodeList.Add('vcvttss2si,1,1,1,REG64,XMMREG_SAE,,');
  FOpCodeList.Add('vdivpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vdivpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vdivpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vdivpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vdivpd,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vdivpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vdivpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vdivps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vdivps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vdivps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vdivps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vdivps,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vdivps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vdivps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vdivsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vdivsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vdivss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vdivss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vdppd,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vdpps,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vdpps,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vextractf128,1,1,0,XMMRM,YMMREG,IMM8,');
  FOpCodeList.Add('vextractps,1,1,1,MEM32,XMMREG,IMM8,');
  FOpCodeList.Add('vextractps,1,1,1,REG32,XMMREG,IMM8,');
  FOpCodeList.Add('vextractps,1,1,1,REG64,XMMREG,IMM8,');
  FOpCodeList.Add('vhaddpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vhaddpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vhaddps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vhaddps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vhsubpd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vhsubpd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vhsubps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vhsubps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vinsertf128,1,1,0,YMMREG,YMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vinsertps,1,1,1,XMMREG,XMMREG,MEM32,IMM8');
  FOpCodeList.Add('vinsertps,1,1,1,XMMREG,XMMREG,XMMREG,IMM8');
  FOpCodeList.Add('vlddqu,1,1,0,XMMREG,MEM128,,');
  FOpCodeList.Add('vlddqu,1,1,0,YMMREG,MEM256,,');
  FOpCodeList.Add('vldmxcsr,1,1,0,MEM32,,,');
  FOpCodeList.Add('vmaskmovdqu,1,1,0,XMMREG,XMMREG,,');
  FOpCodeList.Add('vmaskmovpd,1,1,0,MEM256,YMMREG,YMMREG,');
  FOpCodeList.Add('vmaskmovpd,1,1,0,MEM128,XMMREG,XMMREG,');
  FOpCodeList.Add('vmaskmovpd,1,1,0,YMMREG,YMMREG,MEM256,');
  FOpCodeList.Add('vmaskmovpd,1,1,0,XMMREG,XMMREG,MEM128,');
  FOpCodeList.Add('vmaskmovps,1,1,0,MEM256,YMMREG,YMMREG,');
  FOpCodeList.Add('vmaskmovps,1,1,0,MEM128,XMMREG,XMMREG,');
  FOpCodeList.Add('vmaskmovps,1,1,0,YMMREG,YMMREG,MEM256,');
  FOpCodeList.Add('vmaskmovps,1,1,0,XMMREG,XMMREG,MEM128,');
  FOpCodeList.Add('vmaxpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vmaxpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vmaxpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vmaxpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vmaxpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_SAE,');
  FOpCodeList.Add('vmaxpd,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vmaxpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vmaxps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vmaxps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vmaxps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vmaxps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vmaxps,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vmaxps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vmaxps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_SAE,');
  FOpCodeList.Add('vmaxsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vmaxsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_SAE,');
  FOpCodeList.Add('vmaxss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vmaxss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_SAE,');
  FOpCodeList.Add('vminpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vminpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vminpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vminpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vminpd,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vminpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vminpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_SAE,');
  FOpCodeList.Add('vminps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vminps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vminps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vminps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vminps,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vminps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vminps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_SAE,');
  FOpCodeList.Add('vminsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vminsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_SAE,');
  FOpCodeList.Add('vminss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vminss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_SAE,');
  FOpCodeList.Add('vmovapd,1,1,1,MEM128_M,XMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,MEM256_M,YMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,MEM512_M,ZMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,XMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vmovapd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,YMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vmovapd,1,1,1,YMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,YMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vmovapd,1,1,1,ZMMREG_MZ,ZMMREG,,');
  FOpCodeList.Add('vmovapd,1,1,1,ZMMREG_MZ,ZMMREG,,');
  FOpCodeList.Add('vmovaps,1,1,1,MEM128_M,XMMREG,,');
  FOpCodeList.Add('vmovaps,1,1,1,MEM256_M,YMMREG,,');
  FOpCodeList.Add('vmovaps,1,1,1,MEM512_M,ZMMREG,,');
  FOpCodeList.Add('vmovaps,1,1,1,XMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vmovaps,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vmovaps,1,1,1,YMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vmovaps,1,1,1,YMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vmovaps,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vmovaps,1,1,1,ZMMREG_MZ,ZMMREG,,');
  FOpCodeList.Add('vmovd,1,1,1,RM32,XMMREG,,');
  FOpCodeList.Add('vmovd,1,1,1,XMMREG,RM32,,');
  FOpCodeList.Add('vmovddup,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vmovddup,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vmovddup,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vmovddup,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vmovdqa,1,1,0,YMMRM,YMMREG,,');
  FOpCodeList.Add('vmovdqa,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vmovdqa,1,1,0,XMMRM,XMMREG,,');
  FOpCodeList.Add('vmovdqa,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vmovdqu,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vmovdqu,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vmovdqu,1,1,0,XMMRM,XMMREG,,');
  FOpCodeList.Add('vmovdqu,1,1,0,YMMRM,YMMREG,,');
  FOpCodeList.Add('vmovhlps,1,1,1,XMMREG,XMMREG,XMMREG,');
  FOpCodeList.Add('vmovhpd,1,1,1,MEM64,XMMREG,,');
  FOpCodeList.Add('vmovhpd,1,1,1,XMMREG,XMMREG,MEM64,');
  FOpCodeList.Add('vmovhps,1,1,1,MEM64,XMMREG,,');
  FOpCodeList.Add('vmovhps,1,1,1,XMMREG,XMMREG,MEM64,');
  FOpCodeList.Add('vmovlhps,1,1,1,XMMREG,XMMREG,XMMREG,');
  FOpCodeList.Add('vmovlpd,1,1,1,MEM64,XMMREG,,');
  FOpCodeList.Add('vmovlpd,1,1,1,XMMREG,XMMREG,MEM64,');
  FOpCodeList.Add('vmovlps,1,1,1,MEM64,XMMREG,,');
  FOpCodeList.Add('vmovlps,1,1,1,XMMREG,XMMREG,MEM64,');
  FOpCodeList.Add('vmovmskpd,1,1,0,REG32,YMMREG,,');
  FOpCodeList.Add('vmovmskpd,1,1,0,REG64,XMMREG,,');
  FOpCodeList.Add('vmovmskpd,1,1,0,REG32,XMMREG,,');
  FOpCodeList.Add('vmovmskpd,1,1,0,REG64,YMMREG,,');
  FOpCodeList.Add('vmovmskps,1,1,0,REG32,YMMREG,,');
  FOpCodeList.Add('vmovmskps,1,1,0,REG64,XMMREG,,');
  FOpCodeList.Add('vmovmskps,1,1,0,REG32,XMMREG,,');
  FOpCodeList.Add('vmovmskps,1,1,0,REG64,YMMREG,,');
  FOpCodeList.Add('vmovntdq,1,1,1,MEM128,XMMREG,,');
  FOpCodeList.Add('vmovntdq,1,1,1,MEM256,YMMREG,,');
  FOpCodeList.Add('vmovntdq,1,1,1,MEM512,ZMMREG,,');
  FOpCodeList.Add('vmovntdqa,1,1,1,XMMREG,MEM128,,');
  FOpCodeList.Add('vmovntdqa,1,1,1,YMMREG,MEM256,,');
  FOpCodeList.Add('vmovntdqa,1,1,1,ZMMREG,MEM512,,');
  FOpCodeList.Add('vmovntpd,1,1,1,MEM128,XMMREG,,');
  FOpCodeList.Add('vmovntpd,1,1,1,MEM256,YMMREG,,');
  FOpCodeList.Add('vmovntpd,1,1,1,MEM512,ZMMREG,,');
  FOpCodeList.Add('vmovntps,1,1,1,MEM128,XMMREG,,');
  FOpCodeList.Add('vmovntps,1,1,1,MEM256,YMMREG,,');
  FOpCodeList.Add('vmovntps,1,1,1,MEM512,ZMMREG,,');
  FOpCodeList.Add('vmovq,1,1,1,MEM64,XMMREG,,');
  FOpCodeList.Add('vmovq,0,1,1,RM64,XMMREG,,');
  FOpCodeList.Add('vmovq,1,1,1,XMMREG,MEM64,,');
  FOpCodeList.Add('vmovq,0,1,1,XMMREG,RM64,,');
  FOpCodeList.Add('vmovq,1,1,1,XMMREG,XMMREG,,');
  FOpCodeList.Add('vmovq,1,1,1,XMMREG,XMMREG,,');
  FOpCodeList.Add('vmovsd,1,1,1,MEM64_M,XMMREG,,');
  FOpCodeList.Add('vmovsd,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vmovsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG,');
  FOpCodeList.Add('vmovsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG,');
  FOpCodeList.Add('vmovshdup,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vmovshdup,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vmovshdup,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vmovsldup,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vmovsldup,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vmovsldup,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vmovss,1,1,1,MEM32_M,XMMREG,,');
  FOpCodeList.Add('vmovss,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vmovss,1,1,1,XMMREG_MZ,XMMREG,XMMREG,');
  FOpCodeList.Add('vmovss,1,1,1,XMMREG_MZ,XMMREG,XMMREG,');
  FOpCodeList.Add('vmovupd,1,1,1,MEM128_M,XMMREG,,');
  FOpCodeList.Add('vmovupd,1,1,1,MEM256_M,YMMREG,,');
  FOpCodeList.Add('vmovupd,1,1,1,MEM512_M,ZMMREG,,');
  FOpCodeList.Add('vmovupd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vmovupd,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vmovupd,1,1,1,YMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vmovupd,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vmovupd,1,1,1,ZMMREG_MZ,ZMMREG,,');
  FOpCodeList.Add('vmovupd,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vmovups,1,1,1,MEM128_M,XMMREG,,');
  FOpCodeList.Add('vmovups,1,1,1,MEM256_M,YMMREG,,');
  FOpCodeList.Add('vmovups,1,1,1,MEM512_M,ZMMREG,,');
  FOpCodeList.Add('vmovups,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vmovups,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vmovups,1,1,1,YMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vmovups,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vmovups,1,1,1,ZMMREG_MZ,ZMMREG,,');
  FOpCodeList.Add('vmovups,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vmpsadbw,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vmpsadbw,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vmulpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vmulpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vmulpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vmulpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vmulpd,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vmulpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vmulpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vmulps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vmulps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vmulps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vmulps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vmulps,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vmulps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vmulps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vmulsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vmulsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vmulss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vmulss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vorpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vorpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vorpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vorpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vorpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vorpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vorps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vorps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vorps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vorps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vorps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vorps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpabsb,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vpabsb,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vpabsb,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vpabsd,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vpabsd,1,1,1,XMMREG_MZ,4B32,,');
  FOpCodeList.Add('vpabsd,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vpabsd,1,1,1,YMMREG_MZ,8B32,,');
  FOpCodeList.Add('vpabsd,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vpabsd,1,1,1,ZMMREG_MZ,16B32,,');
  FOpCodeList.Add('vpabsw,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vpabsw,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vpabsw,1,1,1,ZMMREG_MZ,ZMMRM,,');
  FOpCodeList.Add('vpackssdw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpackssdw,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpackssdw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpackssdw,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpackssdw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpackssdw,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpacksswb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpacksswb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpacksswb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpackusdw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpackusdw,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpackusdw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpackusdw,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpackusdw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpackusdw,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpackuswb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpackuswb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpackuswb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpaddd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpaddd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpaddq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpaddq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpaddq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpaddsb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddsb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddsb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddsw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddsw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddsw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddusb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddusb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddusb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddusw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddusw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddusw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpaddw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpaddw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpaddw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpalignr,1,1,1,XMMREG_MZ,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vpalignr,1,1,1,YMMREG_MZ,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vpalignr,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,IMM8');
  FOpCodeList.Add('vpand,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpand,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpandn,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpandn,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpavgb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpavgb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpavgb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpavgw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpavgw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpavgw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpblendvb,1,1,0,XMMREG,XMMREG,XMMRM,XMMREG');
  FOpCodeList.Add('vpblendvb,1,1,0,YMMREG,YMMREG,YMMRM,YMMREG');
  FOpCodeList.Add('vpblendw,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vpblendw,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vpclmulqdq,1,1,1,XMMREG,XMMREG,XMMRM,IMM8');
//  FOpCodeList.Add('vpclmulqdq,1,1,1,YMMREG,YMMREG,YMMRM,IMM8');
//  FOpCodeList.Add('vpclmulqdq,1,1,1,ZMMREG,ZMMREG,ZMMRM,IMM8');
  FOpCodeList.Add('vpcmpeqb,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqb,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqb,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpeqb,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqb,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqd,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqd,1,1,1,KREG_M,XMMREG,4B32,');
  FOpCodeList.Add('vpcmpeqd,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqd,1,1,1,KREG_M,YMMREG,8B32,');
  FOpCodeList.Add('vpcmpeqd,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpeqd,1,1,1,KREG_M,ZMMREG,16B32,');
  FOpCodeList.Add('vpcmpeqd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqq,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqq,1,1,1,KREG_M,XMMREG,2B64,');
  FOpCodeList.Add('vpcmpeqq,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqq,1,1,1,KREG_M,YMMREG,4B64,');
  FOpCodeList.Add('vpcmpeqq,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpeqq,1,1,1,KREG_M,ZMMREG,8B64,');
  FOpCodeList.Add('vpcmpeqq,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqq,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqw,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqw,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpeqw,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpeqw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpeqw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpestri,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vpcmpestrm,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vpcmpgtb,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtb,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtb,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpgtb,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtb,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtd,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtd,1,1,1,KREG_M,XMMREG,4B32,');
  FOpCodeList.Add('vpcmpgtd,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtd,1,1,1,KREG_M,YMMREG,8B32,');
  FOpCodeList.Add('vpcmpgtd,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpgtd,1,1,1,KREG_M,ZMMREG,16B32,');
  FOpCodeList.Add('vpcmpgtd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtq,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtq,1,1,1,KREG_M,XMMREG,2B64,');
  FOpCodeList.Add('vpcmpgtq,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtq,1,1,1,KREG_M,YMMREG,4B64,');
  FOpCodeList.Add('vpcmpgtq,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpgtq,1,1,1,KREG_M,ZMMREG,8B64,');
  FOpCodeList.Add('vpcmpgtq,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtq,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtw,1,1,1,KREG_M,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtw,1,1,1,KREG_M,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpgtw,1,1,1,KREG_M,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpcmpgtw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpcmpgtw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpcmpistri,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vpcmpistrm,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vperm2f128,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vpermilpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpermilpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpermilpd,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpermilpd,1,1,1,XMMREG_MZ,2B64,IMM8,');
  FOpCodeList.Add('vpermilpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpermilpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpermilpd,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpermilpd,1,1,1,YMMREG_MZ,4B64,IMM8,');
  FOpCodeList.Add('vpermilpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpermilpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpermilpd,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpermilpd,1,1,1,ZMMREG_MZ,8B64,IMM8,');
  FOpCodeList.Add('vpermilps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpermilps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpermilps,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpermilps,1,1,1,XMMREG_MZ,4B32,IMM8,');
  FOpCodeList.Add('vpermilps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpermilps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpermilps,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpermilps,1,1,1,YMMREG_MZ,8B32,IMM8,');
  FOpCodeList.Add('vpermilps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpermilps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpermilps,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpermilps,1,1,1,ZMMREG_MZ,16B32,IMM8,');
  FOpCodeList.Add('vpextrb,1,1,1,MEM8,XMMREG,IMM8,');
  //FOpCodeList.Add('vpextrb,1,1,1,REG8,XMMREG,IMM8,');
  //FOpCodeList.Add('vpextrb,1,1,1,REG16,XMMREG,IMM8,');
  FOpCodeList.Add('vpextrb,1,1,1,REG32,XMMREG,IMM8,');
  FOpCodeList.Add('vpextrb,1,1,1,REG64,XMMREG,IMM8,');
  FOpCodeList.Add('vpextrd,1,1,1,RM32,XMMREG,IMM8,');
  FOpCodeList.Add('vpextrq,1,1,1,RM64,XMMREG,IMM8,');
  FOpCodeList.Add('vpextrw,1,1,1,MEM16,XMMREG,IMM8,');
  //FOpCodeList.Add('vpextrw,1,1,1,REG16,XMMREG,IMM8,');
  FOpCodeList.Add('vpextrw,1,1,1,REG32,XMMREG,IMM8,');
  //FOpCodeList.Add('vpextrw,1,1,1,REG64,XMMREG,IMM8,');
  FOpCodeList.Add('vphaddd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vphaddd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vphaddsw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vphaddsw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vphaddw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vphaddw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vphminposuw,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vphsubd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vphsubd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vphsubsw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vphsubsw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vphsubw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vphsubw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpinsrb,1,1,1,XMMREG,XMMREG,REG32,IMM8');
  FOpCodeList.Add('vpinsrb,1,1,1,XMMREG,XMMREG,MEM8,IMM8');
  FOpCodeList.Add('vpinsrd,1,1,1,XMMREG,XMMREG,RM32,IMM8');
  FOpCodeList.Add('vpinsrw,1,1,1,XMMREG,XMMREG,MEM16,IMM8');
  FOpCodeList.Add('vpinsrw,1,1,1,XMMREG,XMMREG,REG32,IMM8');
  FOpCodeList.Add('vpmaddubsw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaddubsw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaddubsw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaddwd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaddwd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaddwd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaxsb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaxsb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaxsb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaxsd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaxsd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpmaxsd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaxsd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpmaxsd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaxsd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpmaxsw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaxsw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaxsw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaxub,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaxub,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaxub,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaxud,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaxud,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpmaxud,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaxud,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpmaxud,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmaxud,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpmaxuw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmaxuw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmaxuw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpminsb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpminsb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpminsb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpminsd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpminsd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpminsd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpminsd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpminsd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpminsd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpminsw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpminsw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpminsw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpminub,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpminub,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpminub,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpminud,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpminud,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpminud,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpminud,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpminud,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpminud,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpminuw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpminuw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpminuw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmovmskb,1,1,0,REG64,XMMREG,,');
  FOpCodeList.Add('vpmovmskb,1,1,0,REG32,XMMREG,,');
  FOpCodeList.Add('vpmovmskb,1,1,0,REG32,YMMREG,,');
  FOpCodeList.Add('vpmovmskb,1,1,0,REG64,YMMREG,,');
  FOpCodeList.Add('vpmovsxbd,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpmovsxbd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbd,1,1,1,YMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovsxbd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbd,1,1,1,ZMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovsxbd,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbq,1,1,1,XMMREG_MZ,MEM16,,');
  FOpCodeList.Add('vpmovsxbq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbq,1,1,1,YMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpmovsxbq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbq,1,1,1,ZMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovsxbq,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbw,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovsxbw,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbw,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovsxbw,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxbw,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vpmovsxbw,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vpmovsxdq,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovsxdq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxdq,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovsxdq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxdq,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vpmovsxdq,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vpmovsxwd,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovsxwd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxwd,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovsxwd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxwd,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vpmovsxwd,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vpmovsxwq,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpmovsxwq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxwq,1,1,1,YMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovsxwq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovsxwq,1,1,1,ZMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovsxwq,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbd,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpmovzxbd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbd,1,1,1,YMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovzxbd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbd,1,1,1,ZMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovzxbd,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbq,1,1,1,XMMREG_MZ,MEM16,,');
  FOpCodeList.Add('vpmovzxbq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbq,1,1,1,YMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpmovzxbq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbq,1,1,1,ZMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovzxbq,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbw,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovzxbw,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbw,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovzxbw,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxbw,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vpmovzxbw,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vpmovzxdq,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovzxdq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxdq,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovzxdq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxdq,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vpmovzxdq,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vpmovzxwd,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovzxwd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxwd,1,1,1,YMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovzxwd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxwd,1,1,1,ZMMREG_MZ,MEM256,,');
  FOpCodeList.Add('vpmovzxwd,1,1,1,ZMMREG_MZ,YMMREG,,');
  FOpCodeList.Add('vpmovzxwq,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpmovzxwq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxwq,1,1,1,YMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpmovzxwq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmovzxwq,1,1,1,ZMMREG_MZ,MEM128,,');
  FOpCodeList.Add('vpmovzxwq,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpmuldq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmuldq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpmuldq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmuldq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpmuldq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmuldq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpmulhrsw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmulhrsw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmulhrsw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmulhuw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmulhuw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmulhuw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmulhw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmulhw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmulhw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmulld,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmulld,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpmulld,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmulld,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpmulld,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmulld,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpmullw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmullw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmullw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmuludq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpmuludq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpmuludq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpmuludq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpmuludq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpmuludq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpor,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpor,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsadbw,1,1,1,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsadbw,1,1,1,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsadbw,1,1,1,ZMMREG,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpshufb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpshufb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpshufb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpshufd,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpshufd,1,1,1,XMMREG_MZ,4B32,IMM8,');
  FOpCodeList.Add('vpshufd,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpshufd,1,1,1,YMMREG_MZ,8B32,IMM8,');
  FOpCodeList.Add('vpshufd,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpshufd,1,1,1,ZMMREG_MZ,16B32,IMM8,');
  FOpCodeList.Add('vpshufhw,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpshufhw,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpshufhw,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpshuflw,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpshuflw,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpshuflw,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsignb,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsignb,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsignd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsignd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsignw,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsignw,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vpslld,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpslld,1,1,1,XMMREG_MZ,4B32,IMM8,');
  FOpCodeList.Add('vpslld,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpslld,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpslld,1,1,1,YMMREG_MZ,8B32,IMM8,');
  FOpCodeList.Add('vpslld,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpslld,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpslld,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpslld,1,1,1,ZMMREG_MZ,16B32,IMM8,');
  FOpCodeList.Add('vpslldq,1,1,1,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vpslldq,1,1,1,YMMREG,YMMRM,IMM8,');
  FOpCodeList.Add('vpslldq,1,1,1,ZMMREG,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsllq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsllq,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsllq,1,1,1,XMMREG_MZ,2B64,IMM8,');
  FOpCodeList.Add('vpsllq,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsllq,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsllq,1,1,1,YMMREG_MZ,4B64,IMM8,');
  FOpCodeList.Add('vpsllq,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsllq,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsllq,1,1,1,ZMMREG_MZ,8B64,IMM8,');
  FOpCodeList.Add('vpsllw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsllw,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsllw,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsllw,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsllw,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsllw,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsrad,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsrad,1,1,1,XMMREG_MZ,4B32,IMM8,');
  FOpCodeList.Add('vpsrad,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsrad,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsrad,1,1,1,YMMREG_MZ,8B32,IMM8,');
  FOpCodeList.Add('vpsrad,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsrad,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsrad,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsrad,1,1,1,ZMMREG_MZ,16B32,IMM8,');
  FOpCodeList.Add('vpsraw,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsraw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsraw,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsraw,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsraw,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsraw,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsrld,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsrld,1,1,1,XMMREG_MZ,4B32,IMM8,');
  FOpCodeList.Add('vpsrld,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsrld,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsrld,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsrld,1,1,1,YMMREG_MZ,8B32,IMM8,');
  FOpCodeList.Add('vpsrld,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsrld,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsrld,1,1,1,ZMMREG_MZ,16B32,IMM8,');
  FOpCodeList.Add('vpsrldq,1,1,1,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vpsrldq,1,1,1,YMMREG,YMMRM,IMM8,');
  FOpCodeList.Add('vpsrldq,1,1,1,ZMMREG,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsrlq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlq,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsrlq,1,1,1,XMMREG_MZ,2B64,IMM8,');
  FOpCodeList.Add('vpsrlq,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsrlq,1,1,1,YMMREG_MZ,4B64,IMM8,');
  FOpCodeList.Add('vpsrlq,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlq,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlq,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsrlq,1,1,1,ZMMREG_MZ,8B64,IMM8,');
  FOpCodeList.Add('vpsrlw,1,1,1,XMMREG_MZ,XMMRM,IMM8,');
  FOpCodeList.Add('vpsrlw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlw,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpsrlw,1,1,1,YMMREG_MZ,YMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlw,1,1,1,ZMMREG_MZ,ZMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlw,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpsubb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpsubd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpsubd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpsubq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpsubq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpsubq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpsubsb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubsb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubsb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubsw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubsw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubsw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubusb,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubusb,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubusb,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubusw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubusw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubusw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsubw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsubw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsubw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vptest,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vptest,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vpunpckhbw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpckhbw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpckhbw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpckhdq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpckhdq,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpunpckhdq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpckhdq,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpunpckhdq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpckhdq,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpunpckhqdq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpckhqdq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpunpckhqdq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpckhqdq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpunpckhqdq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpckhqdq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpunpckhwd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpckhwd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpckhwd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpcklbw,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpcklbw,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpcklbw,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpckldq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpckldq,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpunpckldq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpckldq,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpunpckldq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpckldq,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpunpcklqdq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpcklqdq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpunpcklqdq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpcklqdq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpunpcklqdq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpunpcklqdq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpunpcklwd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpunpcklwd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpunpcklwd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpxor,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vpxor,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vrcpps,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vrcpps,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vrcpss,1,1,0,XMMREG,XMMREG,MEM32,');
  FOpCodeList.Add('vrcpss,1,1,0,XMMREG,XMMREG,XMMREG,');
  FOpCodeList.Add('vroundpd,1,1,0,YMMREG,YMMRM,IMM8,');
  FOpCodeList.Add('vroundpd,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vroundps,1,1,0,YMMREG,YMMRM,IMM8,');
  FOpCodeList.Add('vroundps,1,1,0,XMMREG,XMMRM,IMM8,');
  FOpCodeList.Add('vroundsd,1,1,0,XMMREG,XMMREG,MEM64,IMM8');
  FOpCodeList.Add('vroundsd,1,1,0,XMMREG,XMMREG,XMMREG,IMM8');
  FOpCodeList.Add('vroundss,1,1,0,XMMREG,XMMREG,MEM32,IMM8');
  FOpCodeList.Add('vroundss,1,1,0,XMMREG,XMMREG,XMMREG,IMM8');
  FOpCodeList.Add('vrsqrtps,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vrsqrtps,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vrsqrtss,1,1,0,XMMREG,XMMREG,MEM32,');
  FOpCodeList.Add('vrsqrtss,1,1,0,XMMREG,XMMREG,XMMREG,');
  FOpCodeList.Add('vshufpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vshufpd,1,1,1,XMMREG_MZ,XMMREG,2B64,IMM8');
  FOpCodeList.Add('vshufpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vshufpd,1,1,1,YMMREG_MZ,YMMREG,4B64,IMM8');
  FOpCodeList.Add('vshufpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,IMM8');
  FOpCodeList.Add('vshufpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,IMM8');
  FOpCodeList.Add('vshufps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vshufps,1,1,1,XMMREG_MZ,XMMREG,4B32,IMM8');
  FOpCodeList.Add('vshufps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vshufps,1,1,1,YMMREG_MZ,YMMREG,8B32,IMM8');
  FOpCodeList.Add('vshufps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,IMM8');
  FOpCodeList.Add('vshufps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,IMM8');
  FOpCodeList.Add('vsqrtpd,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vsqrtpd,1,1,1,XMMREG_MZ,2B64,,');
  FOpCodeList.Add('vsqrtpd,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vsqrtpd,1,1,1,YMMREG_MZ,4B64,,');
  FOpCodeList.Add('vsqrtpd,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vsqrtpd,1,1,1,ZMMREG_MZ,8B64,,');
  FOpCodeList.Add('vsqrtpd,1,1,1,ZMMREG_MZ,ZMMREG_ER,,');
  FOpCodeList.Add('vsqrtps,1,1,1,XMMREG_MZ,XMMRM,,');
  FOpCodeList.Add('vsqrtps,1,1,1,XMMREG_MZ,4B32,,');
  FOpCodeList.Add('vsqrtps,1,1,1,YMMREG_MZ,YMMRM,,');
  FOpCodeList.Add('vsqrtps,1,1,1,YMMREG_MZ,8B32,,');
  FOpCodeList.Add('vsqrtps,1,1,1,ZMMREG_MZ,MEM512,,');
  FOpCodeList.Add('vsqrtps,1,1,1,ZMMREG_MZ,16B32,,');
  FOpCodeList.Add('vsqrtps,1,1,1,ZMMREG_MZ,ZMMREG_ER,,');
  FOpCodeList.Add('vsqrtsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vsqrtsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vsqrtss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vsqrtss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vstmxcsr,1,1,0,MEM32,,,');
  FOpCodeList.Add('vsubpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vsubpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vsubpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vsubpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vsubpd,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vsubpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vsubpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vsubps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vsubps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vsubps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vsubps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vsubps,1,1,1,ZMMREG_MZ,ZMMREG,MEM512,');
  FOpCodeList.Add('vsubps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vsubps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMREG_ER,');
  FOpCodeList.Add('vsubsd,1,1,1,XMMREG_MZ,XMMREG,MEM64,');
  FOpCodeList.Add('vsubsd,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vsubss,1,1,1,XMMREG_MZ,XMMREG,XMMREG_ER,');
  FOpCodeList.Add('vsubss,1,1,1,XMMREG_MZ,XMMREG,MEM32,');
  FOpCodeList.Add('vtestpd,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vtestpd,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vtestps,1,1,0,YMMREG,YMMRM,,');
  FOpCodeList.Add('vtestps,1,1,0,XMMREG,XMMRM,,');
  FOpCodeList.Add('vucomisd,1,1,1,XMMREG,MEM64,,');
  FOpCodeList.Add('vucomisd,1,1,1,XMMREG,XMMREG_SAE,,');
  FOpCodeList.Add('vucomiss,1,1,1,XMMREG,MEM32,,');
  FOpCodeList.Add('vucomiss,1,1,1,XMMREG,XMMREG_SAE,,');
  FOpCodeList.Add('vunpckhpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vunpckhpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vunpckhpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vunpckhpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vunpckhpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vunpckhpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vunpckhps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vunpckhps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vunpckhps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vunpckhps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vunpckhps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vunpckhps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vunpcklpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vunpcklpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vunpcklpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vunpcklpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vunpcklpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vunpcklpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vunpcklps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vunpcklps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vunpcklps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vunpcklps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vunpcklps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vunpcklps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vxorpd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vxorpd,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vxorpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vxorpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vxorpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vxorpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vxorps,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vxorps,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vxorps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vxorps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vxorps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vxorps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vzeroall,1,1,0,,,,');
  FOpCodeList.Add('vzeroupper,1,1,0,,,,');
  FOpCodeList.Add('andn,1,1,0,REG32,REG32,RM32,');
  FOpCodeList.Add('andn,0,1,0,REG64,REG64,RM64,');
  FOpCodeList.Add('bextr,1,1,0,REG32,RM32,REG32,');
  FOpCodeList.Add('bextr,0,1,0,REG64,RM64,REG64,');
  FOpCodeList.Add('rorx,1,1,0,REG32,RM32,IMM8,');
  FOpCodeList.Add('rorx,0,1,0,REG64,RM64,IMM8,');
  FOpCodeList.Add('sarx,1,1,0,REG32,RM32,REG32,');
  FOpCodeList.Add('sarx,0,1,0,REG64,RM64,REG64,');
  FOpCodeList.Add('shlx,1,1,0,REG32,RM32,REG32,');
  FOpCodeList.Add('shlx,0,1,0,REG64,RM64,REG64,');
  FOpCodeList.Add('shrx,1,1,0,REG32,RM32,REG32,');
  FOpCodeList.Add('shrx,0,1,0,REG64,RM64,REG64,');
  FOpCodeList.Add('vbroadcasti128,1,1,0,YMMREG,MEM128,,');
  FOpCodeList.Add('vextracti128,1,1,0,XMMRM,YMMREG,IMM8,');
  FOpCodeList.Add('vinserti128,1,1,0,YMMREG,YMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vpblendd,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vpblendd,1,1,0,XMMREG,XMMREG,XMMRM,IMM8');
  FOpCodeList.Add('vpbroadcastb,1,1,1,XMMREG_MZ,MEM8,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,XMMREG_MZ,XMMREG,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,XMMREG_MZ,REG8,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,XMMREG_MZ,REG32,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,XMMREG_MZ,REG64,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,XMMREG_MZ,REG16,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,YMMREG_MZ,MEM8,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,YMMREG_MZ,XMMREG,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,YMMREG_MZ,REG8,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,YMMREG_MZ,REG32,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,YMMREG_MZ,REG64,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,YMMREG_MZ,REG16,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,ZMMREG_MZ,MEM8,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,ZMMREG_MZ,REG8,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,ZMMREG_MZ,REG32,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,ZMMREG_MZ,REG64,,');
  //FOpCodeList.Add('vpbroadcastb,1,1,1,ZMMREG_MZ,REG16,,');
  FOpCodeList.Add('vpbroadcastb,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,XMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,XMMREG_MZ,REG32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,YMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,YMMREG_MZ,REG32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,ZMMREG_MZ,MEM32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,ZMMREG_MZ,REG32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,XMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,XMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,XMMREG_MZ,REG64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,YMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,YMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,YMMREG_MZ,REG64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,ZMMREG_MZ,MEM64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,ZMMREG_MZ,REG64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,XMMREG_MZ,MEM16,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,XMMREG_MZ,XMMREG,,');
  //FOpCodeList.Add('vpbroadcastw,1,1,1,XMMREG_MZ,REG16,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,XMMREG_MZ,REG32,,');
  //FOpCodeList.Add('vpbroadcastw,1,1,1,XMMREG_MZ,REG64,,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,YMMREG_MZ,MEM16,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,YMMREG_MZ,XMMREG,,');
  //FOpCodeList.Add('vpbroadcastw,1,1,1,YMMREG_MZ,REG16,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,YMMREG_MZ,REG32,,');
  //FOpCodeList.Add('vpbroadcastw,1,1,1,YMMREG_MZ,REG64,,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,ZMMREG_MZ,MEM16,');
  //FOpCodeList.Add('vpbroadcastw,1,1,1,ZMMREG_MZ,REG16,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,ZMMREG_MZ,REG32,,');
  //FOpCodeList.Add('vpbroadcastw,1,1,1,ZMMREG_MZ,REG64,,');
  FOpCodeList.Add('vpbroadcastw,1,1,1,ZMMREG_MZ,XMMREG,,');
  FOpCodeList.Add('vperm2i128,1,1,0,YMMREG,YMMREG,YMMRM,IMM8');
  FOpCodeList.Add('vpermd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpermd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpermd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpermd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpermpd,1,1,1,YMMREG_MZ,MEM256,IMM8,');
  FOpCodeList.Add('vpermpd,1,1,1,YMMREG_MZ,YMMREG,IMM8,');
  FOpCodeList.Add('vpermpd,1,1,1,YMMREG_MZ,4B64,IMM8,');
  FOpCodeList.Add('vpermpd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpermpd,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpermpd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpermpd,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpermpd,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpermpd,1,1,1,ZMMREG_MZ,8B64,IMM8,');
  FOpCodeList.Add('vpermps,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpermps,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpermps,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpermps,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpermq,1,1,1,YMMREG_MZ,YMMRM,IMM8,');
  FOpCodeList.Add('vpermq,1,1,1,YMMREG_MZ,4B64,IMM8,');
  FOpCodeList.Add('vpermq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpermq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpermq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpermq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpermq,1,1,1,ZMMREG_MZ,ZMMRM,IMM8,');
  FOpCodeList.Add('vpermq,1,1,1,ZMMREG_MZ,8B64,IMM8,');
  FOpCodeList.Add('vpmaskmovd,1,1,0,XMMREG,XMMREG,MEM128,');
  FOpCodeList.Add('vpmaskmovd,1,1,0,MEM128,XMMREG,XMMREG,');
  FOpCodeList.Add('vpmaskmovd,1,1,0,YMMREG,YMMREG,MEM256,');
  FOpCodeList.Add('vpmaskmovd,1,1,0,MEM256,YMMREG,YMMREG,');
  FOpCodeList.Add('vpmaskmovq,1,1,0,XMMREG,XMMREG,MEM128,');
  FOpCodeList.Add('vpmaskmovq,1,1,0,MEM128,XMMREG,XMMREG,');
  FOpCodeList.Add('vpmaskmovq,1,1,0,MEM256,YMMREG,YMMREG,');
  FOpCodeList.Add('vpmaskmovq,1,1,0,YMMREG,YMMREG,MEM256,');
  FOpCodeList.Add('vpsllvd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsllvd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpsllvd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsllvd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpsllvd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsllvd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpsllvq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsllvq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpsllvq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsllvq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpsllvq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsllvq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');
  FOpCodeList.Add('vpsravd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsravd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpsravd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsravd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpsravd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsravd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpsrlvd,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlvd,1,1,1,XMMREG_MZ,XMMREG,4B32,');
  FOpCodeList.Add('vpsrlvd,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsrlvd,1,1,1,YMMREG_MZ,YMMREG,8B32,');
  FOpCodeList.Add('vpsrlvd,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsrlvd,1,1,1,ZMMREG_MZ,ZMMREG,16B32,');
  FOpCodeList.Add('vpsrlvq,1,1,1,XMMREG_MZ,XMMREG,XMMRM,');
  FOpCodeList.Add('vpsrlvq,1,1,1,XMMREG_MZ,XMMREG,2B64,');
  FOpCodeList.Add('vpsrlvq,1,1,1,YMMREG_MZ,YMMREG,YMMRM,');
  FOpCodeList.Add('vpsrlvq,1,1,1,YMMREG_MZ,YMMREG,4B64,');
  FOpCodeList.Add('vpsrlvq,1,1,1,ZMMREG_MZ,ZMMREG,ZMMRM,');
  FOpCodeList.Add('vpsrlvq,1,1,1,ZMMREG_MZ,ZMMREG,8B64,');

  FOpCodeList.Add('vgatherdpd,1,1,0,XMMREG,XMEM32,XMMREG,');
  FOpCodeList.Add('vgatherdpd,1,1,1,XMMREG_M,XMEM32,,');
  FOpCodeList.Add('vgatherdpd,1,1,0,YMMREG,XMEM32,YMMREG,');
  FOpCodeList.Add('vgatherdpd,1,1,1,YMMREG_M,XMEM32,,');
  FOpCodeList.Add('vgatherdpd,1,1,1,ZMMREG_M,YMEM32,,');

  FOpCodeList.Add('vgatherdps,1,1,0,XMMREG,XMEM32,XMMREG,');
  FOpCodeList.Add('vgatherdps,1,1,1,XMMREG_M,XMEM32,,');
  FOpCodeList.Add('vgatherdps,1,1,0,YMMREG,YMEM32,YMMREG,');
  FOpCodeList.Add('vgatherdps,1,1,1,YMMREG_M,YMEM32,,');
  FOpCodeList.Add('vgatherdps,1,1,1,ZMMREG_M,ZMEM32,,');
  FOpCodeList.Add('vgatherqpd,1,1,0,XMMREG,XMEM64,XMMREG,');
  FOpCodeList.Add('vgatherqpd,1,1,1,XMMREG_M,XMEM64,,');
  FOpCodeList.Add('vgatherqpd,1,1,0,YMMREG,YMEM64,YMMREG,');
  FOpCodeList.Add('vgatherqpd,1,1,1,YMMREG_M,YMEM64,,');
  FOpCodeList.Add('vgatherqpd,1,1,1,ZMMREG_M,ZMEM64,,');
  FOpCodeList.Add('vgatherqps,1,1,0,XMMREG,XMEM32,XMMREG,');
  FOpCodeList.Add('vgatherqps,1,1,0,XMMREG,YMEM32,XMMREG,');
  FOpCodeList.Add('vgatherqps,1,1,1,XMMREG_M,XMEM32,,');
  FOpCodeList.Add('vgatherqps,1,1,1,XMMREG_M,YMEM32,,');
  FOpCodeList.Add('vgatherqps,1,1,1,YMMREG_M,ZMEM32,,');
  FOpCodeList.Add('vpgatherdd,1,1,0,XMMREG,XMEM32,XMMREG,');
  FOpCodeList.Add('vpgatherdd,1,1,1,XMMREG_M,XMEM32,,');
  FOpCodeList.Add('vpgatherdd,1,1,0,YMMREG,YMEM32,YMMREG,');
  FOpCodeList.Add('vpgatherdd,1,1,1,YMMREG_M,YMEM32,,');
  FOpCodeList.Add('vpgatherdd,1,1,1,ZMMREG_M,ZMEM32,,');
  FOpCodeList.Add('vpgatherdq,1,1,0,XMMREG,XMEM64,XMMREG,');
  FOpCodeList.Add('vpgatherdq,1,1,1,XMMREG_M,XMEM64,,');
  FOpCodeList.Add('vpgatherdq,1,1,0,YMMREG,XMEM64,YMMREG,');
  FOpCodeList.Add('vpgatherdq,1,1,1,YMMREG_M,XMEM64,,');
  FOpCodeList.Add('vpgatherdq,1,1,1,ZMMREG_M,YMEM64,,');
  FOpCodeList.Add('vpgatherqd,1,1,0,XMMREG,XMEM32,XMMREG,');
  FOpCodeList.Add('vpgatherqd,1,1,0,XMMREG,YMEM32,XMMREG,');
  FOpCodeList.Add('vpgatherqd,1,1,1,XMMREG_M,XMEM32,,');
  FOpCodeList.Add('vpgatherqd,1,1,1,XMMREG_M,YMEM32,,');
  FOpCodeList.Add('vpgatherqd,1,1,1,YMMREG_M,ZMEM32,,');
  FOpCodeList.Add('vpgatherqq,1,1,0,XMMREG,XMEM64,XMMREG,');
  FOpCodeList.Add('vpgatherqq,1,1,1,XMMREG_M,XMEM64,,');
  FOpCodeList.Add('vpgatherqq,1,1,0,YMMREG,YMEM64,YMMREG,');
  FOpCodeList.Add('vpgatherqq,1,1,1,YMMREG_M,YMEM64,,');
  FOpCodeList.Add('vpgatherqq,1,1,1,ZMMREG_M,ZMEM64,,');
  FOpCodeList.Add('vfmadd132pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd132pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmadd213pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd213pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmadd231pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd231pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  //FOpCodeList.Add('vfmaddpd,1,1,0,XMMREG,XMMREG,XMMRM,XMMREG');
  //FOpCodeList.Add('vfmaddpd,1,1,0,XMMREG,XMMREG,XMMREG,XMMRM');
  FOpCodeList.Add('vfmadd132ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd132ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmadd213ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd213ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmadd231ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd231ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmadd132sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd213sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd231sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd132ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd213ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmadd231ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub132pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub132pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub213pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub213pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub231pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub231pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub132ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub132ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub213ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub213ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub231ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub231ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfmsub132sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub213sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub231sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub132ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub213ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfmsub231ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd132pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd132pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmadd213pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd213pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmadd231pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd231pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmadd132ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd132ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmadd213ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd213ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmadd231ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd231ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmadd132sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd213sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd231sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd132ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd213ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmadd231ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub132pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub132pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmsub213pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub213pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmsub231pd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub231pd,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmsub132ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub132ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmsub213ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub213ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmsub231ps,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub231ps,1,1,0,YMMREG,YMMREG,YMMRM,');
  FOpCodeList.Add('vfnmsub132sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub213sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub231sd,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub132ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub213ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('vfnmsub231ss,1,1,0,XMMREG,XMMREG,XMMRM,');
  FOpCodeList.Add('kaddb,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kaddd,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kaddq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kaddw,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandb,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandd,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandnb,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandnd,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandnq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandnw,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kandw,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kmovb,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kmovb,1,1,0,KREG,REG32,,');
  FOpCodeList.Add('kmovb,1,1,0,REG32,KREG,,');
  FOpCodeList.Add('kmovd,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kmovd,1,1,0,KREG,MEM32,,');
  FOpCodeList.Add('kmovd,1,1,0,KREG,REG32,,');
  FOpCodeList.Add('kmovd,1,1,0,MEM32,KREG,,');
  FOpCodeList.Add('kmovd,1,1,0,REG32,KREG,,');
  FOpCodeList.Add('kmovq,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kmovq,1,1,0,KREG,MEM64,,');
  FOpCodeList.Add('kmovq,1,1,0,KREG,REG64,,');
  FOpCodeList.Add('kmovq,1,1,0,MEM64,KREG,,');
  FOpCodeList.Add('kmovq,1,1,0,REG64,KREG,,');
  FOpCodeList.Add('kmovw,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kmovw,1,1,0,KREG,REG32,,');
  FOpCodeList.Add('kmovw,1,1,0,REG32,KREG,,');
  FOpCodeList.Add('knotb,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('knotd,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('knotq,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('knotw,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('korb,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kord,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('korq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kortestb,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kortestd,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kortestq,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kortestw,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('korw,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kshiftlb,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftld,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftlq,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftlw,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftrb,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftrd,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftrq,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('kshiftrw,1,1,0,KREG,KREG,IMM8,');
  FOpCodeList.Add('ktestb,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('ktestd,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('ktestq,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('ktestw,1,1,0,KREG,KREG,,');
  FOpCodeList.Add('kunpckbw,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kunpckdq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kunpckwd,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxnorb,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxnord,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxnorq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxnorw,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxorb,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxord,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxorq,1,1,0,KREG,KREG,KREG,');
  FOpCodeList.Add('kxorw,1,1,0,KREG,KREG,KREG,');

  FOpCodeList.Add('valignd,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('valignd,1,1,1,xmmreg_mz,xmmreg,4B32,imm8');
  FOpCodeList.Add('valignd,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('valignd,1,1,1,ymmreg_mz,ymmreg,8B32,imm8');
  FOpCodeList.Add('valignd,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('valignd,1,1,1,zmmreg_mz,zmmreg,16B32,imm8');
  FOpCodeList.Add('valignq,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('valignq,1,1,1,xmmreg_mz,xmmreg,2B64,imm8');
  FOpCodeList.Add('valignq,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('valignq,1,1,1,ymmreg_mz,ymmreg,4B64,imm8');
  FOpCodeList.Add('valignq,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('valignq,1,1,1,zmmreg_mz,zmmreg,8B64,imm8');
  FOpCodeList.Add('vblendmpd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vblendmpd,1,1,1,xmmreg_mz,xmmreg,2B64,');
  FOpCodeList.Add('vblendmpd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vblendmpd,1,1,1,ymmreg_mz,ymmreg,4B64,');
  FOpCodeList.Add('vblendmpd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vblendmpd,1,1,1,zmmreg_mz,zmmreg,8B64,');
  FOpCodeList.Add('vblendmps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vblendmps,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('vblendmps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vblendmps,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('vblendmps,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vblendmps,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('vbroadcastf32x2,1,1,1,ymmreg_mz,mem64,,');
  FOpCodeList.Add('vbroadcastf32x2,1,1,1,ymmreg_mz,xmmreg,,');
  FOpCodeList.Add('vbroadcastf32x2,1,1,1,zmmreg_mz,mem64,,');
  FOpCodeList.Add('vbroadcastf32x2,1,1,1,zmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vbroadcastf32x4,1,1,1,ymmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcastf32x4,1,1,1,zmmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcastf32x8,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vbroadcastf64x2,1,1,1,ymmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcastf64x2,1,1,1,zmmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcastf64x4,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vbroadcasti32x2,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vbroadcasti32x2,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vbroadcasti32x2,1,1,1,ymmreg_mz,mem64,,');
  FOpCodeList.Add('vbroadcasti32x2,1,1,1,ymmreg_mz,xmmreg,,');
  FOpCodeList.Add('vbroadcasti32x2,1,1,1,zmmreg_mz,mem64,,');
  FOpCodeList.Add('vbroadcasti32x2,1,1,1,zmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vbroadcasti32x4,1,1,1,ymmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcasti32x4,1,1,1,zmmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcasti32x8,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vbroadcasti64x2,1,1,1,ymmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcasti64x2,1,1,1,zmmreg_mz,mem128,,');
  FOpCodeList.Add('vbroadcasti64x4,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vcompresspd,1,1,1,mem128_m,xmmreg,,');
  FOpCodeList.Add('vcompresspd,1,1,1,mem256_m,ymmreg,,');
  FOpCodeList.Add('vcompresspd,1,1,1,mem512_m,zmmreg,,');
  FOpCodeList.Add('vcompressps,1,1,1,mem128_m,xmmreg,,');
  FOpCodeList.Add('vcompressps,1,1,1,mem256_m,ymmreg,,');
  FOpCodeList.Add('vcompressps,1,1,1,mem512_m,zmmreg,,');
  FOpCodeList.Add('vcompressps,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcompressps,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vcompressps,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtpd2qq,1,1,1,zmmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,xmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,xmmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,ymmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,ymmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtpd2udq,1,1,1,ymmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtpd2uqq,1,1,1,zmmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,xmmreg_mz,2b32,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,ymmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,ymmreg_mz,4b32,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,zmmreg_mz,8b32,,');
  FOpCodeList.Add('vcvtps2qq,1,1,1,zmmreg_mz,ymmreg_er,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vcvtps2udq,1,1,1,zmmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,xmmreg_mz,2b32,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,ymmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,ymmreg_mz,4b32,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,zmmreg_mz,8b32,,');
  FOpCodeList.Add('vcvtps2uqq,1,1,1,zmmreg_mz,ymmreg_er,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtqq2pd,1,1,1,zmmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,xmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,xmmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,ymmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,ymmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtqq2ps,1,1,1,ymmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtsd2usi,1,1,1,reg32,mem64,,');
  FOpCodeList.Add('vcvtsd2usi,1,1,1,reg32,xmmreg_er,,');
  FOpCodeList.Add('vcvtsd2usi,1,1,1,reg64,mem64,,');
  FOpCodeList.Add('vcvtsd2usi,1,1,1,reg64,xmmreg_er,,');
  FOpCodeList.Add('vcvtss2usi,1,1,1,reg32,mem32,,');
  FOpCodeList.Add('vcvtss2usi,1,1,1,reg32,xmmreg_er,,');
  FOpCodeList.Add('vcvtss2usi,1,1,1,reg64,mem32,,');
  FOpCodeList.Add('vcvtss2usi,1,1,1,reg64,xmmreg_er,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vcvttpd2qq,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,xmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,xmmreg_mz,4b64,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,ymmreg_mz,mem512,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,ymmreg_mz,8b64,,');
  FOpCodeList.Add('vcvttpd2udq,1,1,1,ymmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vcvttpd2uqq,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,xmmreg_mz,2b32,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,ymmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,ymmreg_mz,4b32,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,zmmreg_mz,8b32,,');
  FOpCodeList.Add('vcvttps2qq,1,1,1,zmmreg_mz,ymmreg_sae,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vcvttps2udq,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,xmmreg_mz,2b32,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,ymmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,ymmreg_mz,4b32,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,zmmreg_mz,8b32,,');
  FOpCodeList.Add('vcvttps2uqq,1,1,1,zmmreg_mz,ymmreg_sae,,');
  FOpCodeList.Add('vcvttsd2usi,1,1,1,reg32,mem64,,');
  FOpCodeList.Add('vcvttsd2usi,1,1,1,reg32,xmmreg_sae,,');
  FOpCodeList.Add('vcvttsd2usi,1,1,1,reg64,mem64,,');
  FOpCodeList.Add('vcvttsd2usi,1,1,1,reg64,xmmreg_sae,,');
  FOpCodeList.Add('vcvttss2usi,1,1,1,reg32,mem32,,');
  FOpCodeList.Add('vcvttss2usi,1,1,1,reg32,xmmreg_sae,,');
  FOpCodeList.Add('vcvttss2usi,1,1,1,reg64,mem32,,');
  FOpCodeList.Add('vcvttss2usi,1,1,1,reg64,xmmreg_sae,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,xmmreg_mz,2b32,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,ymmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,ymmreg_mz,4b32,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,zmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,zmmreg_mz,8b32,,');
  FOpCodeList.Add('vcvtudq2pd,1,1,1,zmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vcvtudq2ps,1,1,1,zmmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtuqq2pd,1,1,1,zmmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,xmmreg_mz,mem256,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,xmmreg_mz,4b64,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,ymmreg_mz,mem512,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,ymmreg_mz,8b64,,');
  FOpCodeList.Add('vcvtuqq2ps,1,1,1,ymmreg_mz,zmmreg_er,,');
  FOpCodeList.Add('vcvtusi2sd,1,1,1,xmmreg,xmmreg_er,reg32,');
  FOpCodeList.Add('vcvtusi2sd,1,1,1,xmmreg,xmmreg_er,mem32,');
  FOpCodeList.Add('vcvtusi2sd,0,1,1,xmmreg,xmmreg_er,reg64,');
  FOpCodeList.Add('vcvtusi2sd,0,1,1,xmmreg,xmmreg_er,mem64,');
  FOpCodeList.Add('vcvtusi2ss,1,1,1,xmmreg,xmmreg_er,reg32,');
  FOpCodeList.Add('vcvtusi2ss,1,1,1,xmmreg,xmmreg_er,mem32,');
  FOpCodeList.Add('vcvtusi2ss,0,1,1,xmmreg,xmmreg_er,reg64,');
  FOpCodeList.Add('vcvtusi2ss,0,1,1,xmmreg,xmmreg_er,mem64,');
  FOpCodeList.Add('vdbpsadbw,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vdbpsadbw,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vdbpsadbw,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vexp2pd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vexp2pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vexp2pd,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vexp2ps,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vexp2ps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vexp2ps,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vexpandpd,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vexpandpd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vexpandpd,1,1,1,ymmreg_mz,mem256,,');
  FOpCodeList.Add('vexpandpd,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vexpandpd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vexpandpd,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vexpandps,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vexpandps,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vexpandps,1,1,1,ymmreg_mz,mem256,,');
  FOpCodeList.Add('vexpandps,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vexpandps,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vexpandps,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vextractf32x4,1,1,1,mem128_m,ymmreg,imm8,');
  FOpCodeList.Add('vextractf32x4,1,1,1,mem128_m,zmmreg,imm8,');
  FOpCodeList.Add('vextractf32x4,1,1,1,xmmreg_mz,ymmreg,imm8,');
  FOpCodeList.Add('vextractf32x4,1,1,1,xmmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextractf32x8,1,1,1,mem256_m,zmmreg,imm8,');
  FOpCodeList.Add('vextractf32x8,1,1,1,ymmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextractf64x2,1,1,1,mem128_m,ymmreg,imm8,');
  FOpCodeList.Add('vextractf64x2,1,1,1,mem128_m,zmmreg,imm8,');
  FOpCodeList.Add('vextractf64x2,1,1,1,xmmreg_mz,ymmreg,imm8,');
  FOpCodeList.Add('vextractf64x2,1,1,1,xmmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextractf64x4,1,1,1,mem256_m,zmmreg,imm8,');
  FOpCodeList.Add('vextractf64x4,1,1,1,ymmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextracti32x4,1,1,1,mem128_m,ymmreg,imm8,');
  FOpCodeList.Add('vextracti32x4,1,1,1,mem128_m,zmmreg,imm8,');
  FOpCodeList.Add('vextracti32x4,1,1,1,xmmreg_mz,ymmreg,imm8,');
  FOpCodeList.Add('vextracti32x4,1,1,1,xmmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextracti32x8,1,1,1,mem256_m,zmmreg,imm8,');
  FOpCodeList.Add('vextracti32x8,1,1,1,ymmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextracti64x2,1,1,1,mem128_m,ymmreg,imm8,');
  FOpCodeList.Add('vextracti64x2,1,1,1,mem128_m,zmmreg,imm8,');
  FOpCodeList.Add('vextracti64x2,1,1,1,xmmreg_mz,ymmreg,imm8,');
  FOpCodeList.Add('vextracti64x2,1,1,1,xmmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vextracti64x4,1,1,1,mem256_m,zmmreg,imm8,');
  FOpCodeList.Add('vextracti64x4,1,1,1,ymmreg_mz,zmmreg,imm8,');
  FOpCodeList.Add('vfixupimmpd,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vfixupimmpd,1,1,1,xmmreg_mz,xmmreg,2b64,imm8');
  FOpCodeList.Add('vfixupimmpd,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vfixupimmpd,1,1,1,ymmreg_mz,ymmreg,4b64,imm8');
  FOpCodeList.Add('vfixupimmpd,1,1,1,zmmreg_mz,zmmreg,mem512,imm8');
  FOpCodeList.Add('vfixupimmpd,1,1,1,zmmreg_mz,zmmreg,8b64,imm8');
  FOpCodeList.Add('vfixupimmpd,1,1,1,zmmreg_mz,zmmreg,zmmreg_sae,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,xmmreg_mz,xmmreg,4b32,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,ymmreg_mz,ymmreg,8b32,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,zmmreg_mz,zmmreg,mem512,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,zmmreg_mz,zmmreg,16b32,imm8');
  FOpCodeList.Add('vfixupimmps,1,1,1,zmmreg_mz,zmmreg,zmmreg_sae,imm8');
  FOpCodeList.Add('vfixupimmsd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vfixupimmsd,1,1,1,xmmreg_mz,xmmreg,mem64,imm8');
  FOpCodeList.Add('vfixupimmss,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vfixupimmss,1,1,1,xmmreg_mz,xmmreg,mem32,imm8');
  FOpCodeList.Add('vfmadd132pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmadd132pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmadd132pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmadd132pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmadd132pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmadd132pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmadd132pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmadd132ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmadd132sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfmadd132sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmadd132ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmadd132ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmadd213pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmadd213ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmadd213sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmadd213sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfmadd213ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmadd213ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmadd231pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmadd231ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmadd231sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfmadd231sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmadd231ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfmadd231ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmaddsub132pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmaddsub132ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmaddsub213pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmaddsub213ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmaddsub231pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmaddsub231ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmsub132pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmsub132ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub132sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmsub132sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfmsub132ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfmsub132ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmsub213pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmsub213ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub213sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmsub213sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfmsub213ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmsub213ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmsub231pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmsub231ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsub231sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmsub231sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfmsub231ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfmsub231ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmsubadd132pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmsubadd132ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmsubadd213pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmsubadd213ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfmsubadd231pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfmsubadd231ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfnmadd132pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfnmadd132ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd132sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfnmadd132sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmadd132ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmadd132ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfnmadd213pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfnmadd213ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd213sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfnmadd213sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmadd213ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmadd213ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfnmadd231pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfnmadd231ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmadd231sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmadd231ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfnmsub132pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfnmsub132ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmsub132sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmsub132sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfnmsub132ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmsub132ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfnmsub213pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfnmsub213ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmsub213sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfnmsub213sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmsub213ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfnmsub213ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vfnmsub231pd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vfnmsub231ps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vfnmsub231sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmsub231sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vfnmsub231ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vfnmsub231ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vfpclasspd,1,1,1,kreg_m,xmmrm,imm8,');
  FOpCodeList.Add('vfpclasspd,1,1,1,kreg_m,2b64,imm8,');
  FOpCodeList.Add('vfpclasspd,1,1,1,kreg_m,ymmrm,imm8,');
  FOpCodeList.Add('vfpclasspd,1,1,1,kreg_m,4b64,imm8,');
  FOpCodeList.Add('vfpclasspd,1,1,1,kreg_m,zmmrm,imm8,');
  FOpCodeList.Add('vfpclasspd,1,1,1,kreg_m,8b64,imm8,');
  FOpCodeList.Add('vfpclassps,1,1,1,kreg_m,xmmrm,imm8,');
  FOpCodeList.Add('vfpclassps,1,1,1,kreg_m,4b32,imm8,');
  FOpCodeList.Add('vfpclassps,1,1,1,kreg_m,ymmrm,imm8,');
  FOpCodeList.Add('vfpclassps,1,1,1,kreg_m,8b32,imm8,');
  FOpCodeList.Add('vfpclassps,1,1,1,kreg_m,zmmrm,imm8,');
  FOpCodeList.Add('vfpclassps,1,1,1,kreg_m,16b32,imm8,');
  FOpCodeList.Add('vgetexppd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vgetexppd,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vgetexppd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vgetexppd,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vgetexppd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vgetexppd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vgetexppd,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vgetexpps,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vgetexpps,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vgetexpps,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vgetexpps,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vgetexpps,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vgetexpps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vgetexpps,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vgetexpsd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vgetexpsd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,');
  FOpCodeList.Add('vgetexpss,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,');
  FOpCodeList.Add('vgetexpss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vgetmantpd,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vgetmantpd,1,1,1,xmmreg_mz,2b64,imm8,');
  FOpCodeList.Add('vgetmantpd,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vgetmantpd,1,1,1,ymmreg_mz,4b64,imm8,');
  FOpCodeList.Add('vgetmantpd,1,1,1,zmmreg_mz,mem512,imm8,');
  FOpCodeList.Add('vgetmantpd,1,1,1,zmmreg_mz,8b64,imm8,');
  FOpCodeList.Add('vgetmantpd,1,1,1,zmmreg_mz,zmmreg_sae,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,xmmreg_mz,4b32,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,ymmreg_mz,8b32,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,zmmreg_mz,mem512,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,zmmreg_mz,16b32,imm8,');
  FOpCodeList.Add('vgetmantps,1,1,1,zmmreg_mz,zmmreg_sae,imm8,');
  FOpCodeList.Add('vgetmantsd,1,1,1,xmmreg_mz,xmmreg,mem64,imm8');
  FOpCodeList.Add('vgetmantsd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vgetmantss,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vgetmantss,1,1,1,xmmreg_mz,xmmreg,mem32,imm8');
  FOpCodeList.Add('vinsertf32x4,1,1,1,ymmreg_mz,ymmreg,xmmrm,imm8');
  FOpCodeList.Add('vinsertf32x4,1,1,1,zmmreg_mz,zmmreg,xmmrm,imm8');
  FOpCodeList.Add('vinsertf32x8,1,1,1,zmmreg_mz,zmmreg,ymmrm,imm8');
  FOpCodeList.Add('vinsertf64x2,1,1,1,ymmreg_mz,ymmreg,xmmrm,imm8');
  FOpCodeList.Add('vinsertf64x2,1,1,1,zmmreg_mz,zmmreg,xmmrm,imm8');
  FOpCodeList.Add('vinsertf64x4,1,1,1,zmmreg_mz,zmmreg,ymmrm,imm8');
  FOpCodeList.Add('vinserti32x4,1,1,1,ymmreg_mz,ymmreg,xmmrm,imm8');
  FOpCodeList.Add('vinserti32x4,1,1,1,zmmreg_mz,zmmreg,xmmrm,imm8');
  FOpCodeList.Add('vinserti32x8,1,1,1,zmmreg_mz,zmmreg,ymmrm,imm8');
  FOpCodeList.Add('vinserti64x2,1,1,1,ymmreg_mz,ymmreg,xmmrm,imm8');
  FOpCodeList.Add('vinserti64x2,1,1,1,zmmreg_mz,zmmreg,xmmrm,imm8');
  FOpCodeList.Add('vinserti64x4,1,1,1,zmmreg_mz,zmmreg,ymmrm,imm8');
  FOpCodeList.Add('vmovdqa32,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,mem128_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,mem256_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqa32,1,1,1,mem512_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,mem128_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,mem256_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqa64,1,1,1,mem512_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,mem128_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,mem256_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu16,1,1,1,mem512_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,mem128_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,mem256_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu32,1,1,1,mem512_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,mem128_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,mem256_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu64,1,1,1,mem512_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,mem128_mz,xmmreg,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,mem256_mz,ymmreg,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vmovdqu8,1,1,1,mem512_mz,zmmreg,,');
  FOpCodeList.Add('vpabsq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vpabsq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vpabsq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vpabsq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vpabsq,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vpabsq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vpandd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpandd,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpandd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpandd,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpandd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpandd,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpandnd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpandnd,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpandnd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpandnd,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpandnd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpandnd,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpandnq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpandnq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpandnq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpandnq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpandnq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpandnq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpandq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpandq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpandq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpandq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpandq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpandq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpblendmb,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpblendmb,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpblendmb,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpblendmd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpblendmd,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpblendmd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpblendmd,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpblendmd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpblendmd,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpblendmq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpblendmq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpblendmq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpblendmq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpblendmq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpblendmq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpblendmw,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpblendmw,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpblendmw,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,xmmreg_mz,mem32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,xmmreg_mz,reg32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,ymmreg_mz,mem32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,ymmreg_mz,reg32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,ymmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,zmmreg_mz,mem32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,zmmreg_mz,reg32,,');
  FOpCodeList.Add('vpbroadcastd,1,1,1,zmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpbroadcastmb2q  xmmreg,kreg,1,1,1,void,,,');
  FOpCodeList.Add('vpbroadcastmb2q  ymmreg,kreg,1,1,1,void,,,');
  FOpCodeList.Add('vpbroadcastmb2q  zmmreg,kreg,1,1,1,void,,,');
  FOpCodeList.Add('vpbroadcastmw2d  xmmreg,kreg,1,1,1,void,,,');
  FOpCodeList.Add('vpbroadcastmw2d  ymmreg,kreg,1,1,1,void,,,');
  FOpCodeList.Add('vpbroadcastmw2d  zmmreg,kreg,1,1,1,void,,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,xmmreg_mz,mem64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,xmmreg_mz,reg64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,ymmreg_mz,mem64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,ymmreg_mz,reg64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,ymmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,zmmreg_mz,mem64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,zmmreg_mz,reg64,,');
  FOpCodeList.Add('vpbroadcastq,1,1,1,zmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpcmpb,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpb,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpb,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpd,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpd,1,1,1,kreg_m,xmmreg,4b32,imm8');
  FOpCodeList.Add('vpcmpd,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpd,1,1,1,kreg_m,ymmreg,8b32,imm8');
  FOpCodeList.Add('vpcmpd,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpd,1,1,1,kreg_m,zmmreg,16b32,imm8');
  FOpCodeList.Add('vpcmpq,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpq,1,1,1,kreg_m,xmmreg,2b64,imm8');
  FOpCodeList.Add('vpcmpq,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpq,1,1,1,kreg_m,ymmreg,4b64,imm8');
  FOpCodeList.Add('vpcmpq,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpq,1,1,1,kreg_m,zmmreg,8b64,imm8');
  FOpCodeList.Add('vpcmpub,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpub,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpub,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpud,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpud,1,1,1,kreg_m,xmmreg,4b32,imm8');
  FOpCodeList.Add('vpcmpud,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpud,1,1,1,kreg_m,ymmreg,8b32,imm8');
  FOpCodeList.Add('vpcmpud,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpud,1,1,1,kreg_m,zmmreg,16b32,imm8');
  FOpCodeList.Add('vpcmpuq,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpuq,1,1,1,kreg_m,xmmreg,2b64,imm8');
  FOpCodeList.Add('vpcmpuq,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpuq,1,1,1,kreg_m,ymmreg,4b64,imm8');
  FOpCodeList.Add('vpcmpuq,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpuq,1,1,1,kreg_m,zmmreg,8b64,imm8');
  FOpCodeList.Add('vpcmpuw,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpuw,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpuw,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcmpw,1,1,1,kreg_m,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpcmpw,1,1,1,kreg_m,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpcmpw,1,1,1,kreg_m,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpcompressd,1,1,1,mem128_m,xmmreg,,');
  FOpCodeList.Add('vpcompressd,1,1,1,mem256_m,ymmreg,,');
  FOpCodeList.Add('vpcompressd,1,1,1,mem512_m,zmmreg,,');
  FOpCodeList.Add('vpcompressd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpcompressd,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpcompressd,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpcompressq,1,1,1,mem128_m,xmmreg,,');
  FOpCodeList.Add('vpcompressq,1,1,1,mem256_m,ymmreg,,');
  FOpCodeList.Add('vpcompressq,1,1,1,mem512_m,zmmreg,,');
  FOpCodeList.Add('vpcompressq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpcompressq,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpcompressq,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpconflictd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vpconflictd,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vpconflictd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vpconflictd,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vpconflictd,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vpconflictd,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vpconflictq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vpconflictq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vpconflictq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vpconflictq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vpconflictq,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vpconflictq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vpermb,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermb,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermb,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermi2b,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermi2b,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermi2b,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermi2d,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermi2d,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpermi2d,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermi2d,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpermi2d,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermi2d,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpermi2pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermi2pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpermi2pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermi2pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpermi2pd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermi2pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpermi2ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermi2ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpermi2ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermi2ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpermi2ps,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermi2ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpermi2q,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermi2q,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpermi2q,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermi2q,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpermi2q,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermi2q,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpermi2w,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermi2w,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermi2w,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermt2b,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermt2b,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermt2b,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermt2d,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermt2d,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpermt2d,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermt2d,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpermt2d,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermt2d,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpermt2pd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermt2pd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpermt2pd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermt2pd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpermt2pd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermt2pd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpermt2ps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermt2ps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpermt2ps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermt2ps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpermt2ps,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermt2ps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpermt2q,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermt2q,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpermt2q,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermt2q,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpermt2q,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermt2q,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpermt2w,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermt2w,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermt2w,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpermw,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpermw,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpermw,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpexpandd,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vpexpandd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpexpandd,1,1,1,ymmreg_mz,mem256,,');
  FOpCodeList.Add('vpexpandd,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpexpandd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vpexpandd,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpexpandq,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('vpexpandq,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpexpandq,1,1,1,ymmreg_mz,mem256,,');
  FOpCodeList.Add('vpexpandq,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpexpandq,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vpexpandq,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vplzcntd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vplzcntd,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vplzcntd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vplzcntd,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vplzcntd,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vplzcntd,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vplzcntq,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vplzcntq,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vplzcntq,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vplzcntq,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vplzcntq,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vplzcntq,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vpmadd52huq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpmadd52huq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpmadd52huq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpmadd52huq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpmadd52huq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpmadd52huq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpmadd52luq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpmadd52luq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpmadd52luq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpmadd52luq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpmadd52luq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpmadd52luq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpmaxsq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpmaxsq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpmaxsq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpmaxsq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpmaxsq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpmaxsq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpmaxuq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpmaxuq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpmaxuq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpmaxuq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpmaxuq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpmaxuq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpminsq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpminsq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpminsq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpminsq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpminsq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpminsq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpminuq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpminuq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpminuq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpminuq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpminuq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpminuq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpmovb2m,1,1,1,kreg,xmmreg,,');
  FOpCodeList.Add('vpmovb2m,1,1,1,kreg,ymmreg,,');
  FOpCodeList.Add('vpmovb2m,1,1,1,kreg,zmmreg,,');
  FOpCodeList.Add('vpmovd2m,1,1,1,kreg,xmmreg,,');
  FOpCodeList.Add('vpmovd2m,1,1,1,kreg,ymmreg,,');
  FOpCodeList.Add('vpmovd2m,1,1,1,kreg,zmmreg,,');
  FOpCodeList.Add('vpmovdb,1,1,1,mem128_m,zmmreg,,');
  FOpCodeList.Add('vpmovdb,1,1,1,mem32_m,xmmreg,,');
  FOpCodeList.Add('vpmovdb,1,1,1,mem64_m,ymmreg,,');
  FOpCodeList.Add('vpmovdb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovdb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovdb,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovdw,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovdw,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovdw,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovdw,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovdw,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovdw,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovm2b,1,1,1,xmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2b,1,1,1,ymmreg,kreg,,');
  FOpCodeList.Add('vpmovm2b,1,1,1,zmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2d,1,1,1,xmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2d,1,1,1,ymmreg,kreg,,');
  FOpCodeList.Add('vpmovm2d,1,1,1,zmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2q,1,1,1,xmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2q,1,1,1,ymmreg,kreg,,');
  FOpCodeList.Add('vpmovm2q,1,1,1,zmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2w,1,1,1,xmmreg,kreg,,');
  FOpCodeList.Add('vpmovm2w,1,1,1,ymmreg,kreg,,');
  FOpCodeList.Add('vpmovm2w,1,1,1,zmmreg,kreg,,');
  FOpCodeList.Add('vpmovq2m,1,1,1,kreg,xmmreg,,');
  FOpCodeList.Add('vpmovq2m,1,1,1,kreg,ymmreg,,');
  FOpCodeList.Add('vpmovq2m,1,1,1,kreg,zmmreg,,');
  FOpCodeList.Add('vpmovqb,1,1,1,mem16_m,xmmreg,,');
  FOpCodeList.Add('vpmovqb,1,1,1,mem32_m,ymmreg,,');
  FOpCodeList.Add('vpmovqb,1,1,1,mem64_m,zmmreg,,');
  FOpCodeList.Add('vpmovqb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovqb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovqb,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovqd,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovqd,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovqd,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovqd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovqd,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovqd,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovqw,1,1,1,mem128_m,zmmreg,,');
  FOpCodeList.Add('vpmovqw,1,1,1,mem32_m,xmmreg,,');
  FOpCodeList.Add('vpmovqw,1,1,1,mem64_m,ymmreg,,');
  FOpCodeList.Add('vpmovqw,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovqw,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovqw,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovsdb,1,1,1,mem128_m,zmmreg,,');
  FOpCodeList.Add('vpmovsdb,1,1,1,mem32_m,xmmreg,,');
  FOpCodeList.Add('vpmovsdb,1,1,1,mem64_m,ymmreg,,');
  FOpCodeList.Add('vpmovsdb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovsdb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovsdb,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovsdw,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovsdw,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovsdw,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovsdw,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovsdw,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovsdw,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovsqb,1,1,1,mem16_m,xmmreg,,');
  FOpCodeList.Add('vpmovsqb,1,1,1,mem32_m,ymmreg,,');
  FOpCodeList.Add('vpmovsqb,1,1,1,mem64_m,zmmreg,,');
  FOpCodeList.Add('vpmovsqb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovsqb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovsqb,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovsqd,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovsqd,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovsqd,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovsqd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovsqd,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovsqd,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovsqw,1,1,1,mem128_m,zmmreg,,');
  FOpCodeList.Add('vpmovsqw,1,1,1,mem32_m,xmmreg,,');
  FOpCodeList.Add('vpmovsqw,1,1,1,mem64_m,ymmreg,,');
  FOpCodeList.Add('vpmovsqw,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovsqw,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovsqw,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovswb,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovswb,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovswb,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovswb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovswb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovswb,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovusdb,1,1,1,mem128_m,zmmreg,,');
  FOpCodeList.Add('vpmovusdb,1,1,1,mem32_m,xmmreg,,');
  FOpCodeList.Add('vpmovusdb,1,1,1,mem64_m,ymmreg,,');
  FOpCodeList.Add('vpmovusdb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovusdb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovusdb,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovusdw,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovusdw,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovusdw,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovusdw,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovusdw,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovusdw,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovusqb,1,1,1,mem16_m,xmmreg,,');
  FOpCodeList.Add('vpmovusqb,1,1,1,mem32_m,ymmreg,,');
  FOpCodeList.Add('vpmovusqb,1,1,1,mem64_m,zmmreg,,');
  FOpCodeList.Add('vpmovusqb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovusqb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovusqb,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovusqd,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovusqd,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovusqd,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovusqd,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovusqd,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovusqd,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovusqw,1,1,1,mem128_m,zmmreg,,');
  FOpCodeList.Add('vpmovusqw,1,1,1,mem32_m,xmmreg,,');
  FOpCodeList.Add('vpmovusqw,1,1,1,mem64_m,ymmreg,,');
  FOpCodeList.Add('vpmovusqw,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovusqw,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovusqw,1,1,1,xmmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovuswb,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovuswb,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovuswb,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovuswb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovuswb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovuswb,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmovw2m,1,1,1,kreg,xmmreg,,');
  FOpCodeList.Add('vpmovw2m,1,1,1,kreg,ymmreg,,');
  FOpCodeList.Add('vpmovw2m,1,1,1,kreg,zmmreg,,');
  FOpCodeList.Add('vpmovwb,1,1,1,mem128_m,ymmreg,,');
  FOpCodeList.Add('vpmovwb,1,1,1,mem256_m,zmmreg,,');
  FOpCodeList.Add('vpmovwb,1,1,1,mem64_m,xmmreg,,');
  FOpCodeList.Add('vpmovwb,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('vpmovwb,1,1,1,xmmreg_mz,ymmreg,,');
  FOpCodeList.Add('vpmovwb,1,1,1,ymmreg_mz,zmmreg,,');
  FOpCodeList.Add('vpmullq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpmullq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpmullq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpmullq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpmullq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpmullq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpmultishiftqb,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpmultishiftqb,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpmultishiftqb,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpmultishiftqb,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpmultishiftqb,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpmultishiftqb,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpord,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpord,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpord,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpord,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpord,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpord,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vporq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vporq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vporq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vporq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vporq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vporq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vprold,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vprold,1,1,1,xmmreg_mz,4b32,imm8,');
  FOpCodeList.Add('vprold,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vprold,1,1,1,ymmreg_mz,8b32,imm8,');
  FOpCodeList.Add('vprold,1,1,1,zmmreg_mz,zmmrm,imm8,');
  FOpCodeList.Add('vprold,1,1,1,zmmreg_mz,16b32,imm8,');
  FOpCodeList.Add('vprolq,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vprolq,1,1,1,xmmreg_mz,2b64,imm8,');
  FOpCodeList.Add('vprolq,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vprolq,1,1,1,ymmreg_mz,4b64,imm8,');
  FOpCodeList.Add('vprolq,1,1,1,zmmreg_mz,zmmrm,imm8,');
  FOpCodeList.Add('vprolq,1,1,1,zmmreg_mz,8b64,imm8,');
  FOpCodeList.Add('vprolvd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vprolvd,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vprolvd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vprolvd,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vprolvd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vprolvd,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vprolvq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vprolvq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vprolvq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vprolvq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vprolvq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vprolvq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vprord,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vprord,1,1,1,xmmreg_mz,4b32,imm8,');
  FOpCodeList.Add('vprord,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vprord,1,1,1,ymmreg_mz,8b32,imm8,');
  FOpCodeList.Add('vprord,1,1,1,zmmreg_mz,zmmrm,imm8,');
  FOpCodeList.Add('vprord,1,1,1,zmmreg_mz,16b32,imm8,');
  FOpCodeList.Add('vprorq,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vprorq,1,1,1,xmmreg_mz,2b64,imm8,');
  FOpCodeList.Add('vprorq,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vprorq,1,1,1,ymmreg_mz,4b64,imm8,');
  FOpCodeList.Add('vprorq,1,1,1,zmmreg_mz,zmmrm,imm8,');
  FOpCodeList.Add('vprorq,1,1,1,zmmreg_mz,8b64,imm8,');
  FOpCodeList.Add('vprorvd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vprorvd,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vprorvd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vprorvd,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vprorvd,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vprorvd,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vprorvq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vprorvq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vprorvq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vprorvq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vprorvq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vprorvq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpscatterdd,1,1,1,xmem32_m,xmmreg,,');
  FOpCodeList.Add('vpscatterdd,1,1,1,ymem32_m,ymmreg,,');
  FOpCodeList.Add('vpscatterdd,1,1,1,zmem32_m,zmmreg,,');
  FOpCodeList.Add('vpscatterdq,1,1,1,xmem64_m,xmmreg,,');
  FOpCodeList.Add('vpscatterdq,1,1,1,xmem64_m,ymmreg,,');
  FOpCodeList.Add('vpscatterdq,1,1,1,ymem64_m,zmmreg,,');
  FOpCodeList.Add('vpscatterqd,1,1,1,xmem32_m,xmmreg,,');
  FOpCodeList.Add('vpscatterqd,1,1,1,ymem32_m,xmmreg,,');
  FOpCodeList.Add('vpscatterqd,1,1,1,zmem32_m,ymmreg,,');
  FOpCodeList.Add('vpscatterqq,1,1,1,xmem64_m,xmmreg,,');
  FOpCodeList.Add('vpscatterqq,1,1,1,ymem64_m,ymmreg,,');
  FOpCodeList.Add('vpscatterqq,1,1,1,zmem64_m,zmmreg,,');
  FOpCodeList.Add('vpsllvw,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpsllvw,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpsllvw,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpsraq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpsraq,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vpsraq,1,1,1,xmmreg_mz,2b64,imm8,');
  FOpCodeList.Add('vpsraq,1,1,1,ymmreg_mz,ymmreg,xmmrm,');
  FOpCodeList.Add('vpsraq,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vpsraq,1,1,1,ymmreg_mz,4b64,imm8,');
  FOpCodeList.Add('vpsraq,1,1,1,zmmreg_mz,zmmreg,xmmrm,');
  FOpCodeList.Add('vpsraq,1,1,1,zmmreg_mz,zmmrm,imm8,');
  FOpCodeList.Add('vpsraq,1,1,1,zmmreg_mz,8b64,imm8,');
  FOpCodeList.Add('vpsravq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpsravq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpsravq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpsravq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpsravq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpsravq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vpsravw,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpsravw,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpsravw,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpsrlvw,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpsrlvw,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpsrlvw,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpternlogd,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpternlogd,1,1,1,xmmreg_mz,xmmreg,4b32,imm8');
  FOpCodeList.Add('vpternlogd,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpternlogd,1,1,1,ymmreg_mz,ymmreg,8b32,imm8');
  FOpCodeList.Add('vpternlogd,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpternlogd,1,1,1,zmmreg_mz,zmmreg,16b32,imm8');
  FOpCodeList.Add('vpternlogq,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vpternlogq,1,1,1,xmmreg_mz,xmmreg,2b64,imm8');
  FOpCodeList.Add('vpternlogq,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vpternlogq,1,1,1,ymmreg_mz,ymmreg,4b64,imm8');
  FOpCodeList.Add('vpternlogq,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vpternlogq,1,1,1,zmmreg_mz,zmmreg,8b64,imm8');
  FOpCodeList.Add('vptestmb,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestmb,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestmb,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestmd,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestmd,1,1,1,kreg_m,xmmreg,4b32,');
  FOpCodeList.Add('vptestmd,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestmd,1,1,1,kreg_m,ymmreg,8b32,');
  FOpCodeList.Add('vptestmd,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestmd,1,1,1,kreg_m,zmmreg,16b32,');
  FOpCodeList.Add('vptestmq,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestmq,1,1,1,kreg_m,xmmreg,2b64,');
  FOpCodeList.Add('vptestmq,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestmq,1,1,1,kreg_m,ymmreg,4b64,');
  FOpCodeList.Add('vptestmq,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestmq,1,1,1,kreg_m,zmmreg,8b64,');
  FOpCodeList.Add('vptestmw,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestmw,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestmw,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestnmb,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestnmb,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestnmb,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestnmd,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestnmd,1,1,1,kreg_m,xmmreg,4b32,');
  FOpCodeList.Add('vptestnmd,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestnmd,1,1,1,kreg_m,ymmreg,8b32,');
  FOpCodeList.Add('vptestnmd,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestnmd,1,1,1,kreg_m,zmmreg,16b32,');
  FOpCodeList.Add('vptestnmq,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestnmq,1,1,1,kreg_m,xmmreg,2b64,');
  FOpCodeList.Add('vptestnmq,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestnmq,1,1,1,kreg_m,ymmreg,4b64,');
  FOpCodeList.Add('vptestnmq,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vptestnmq,1,1,1,kreg_m,zmmreg,8b64,');
  FOpCodeList.Add('vptestnmw,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('vptestnmw,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('vptestnmw,1,1,1,kreg_m,zmmreg,zmmrm,');
  FOpCodeList.Add('vpxord,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpxord,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vpxord,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpxord,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vpxord,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpxord,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vpxorq,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vpxorq,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vpxorq,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vpxorq,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vpxorq,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('vpxorq,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vrangepd,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vrangepd,1,1,1,xmmreg_mz,xmmreg,2b64,imm8');
  FOpCodeList.Add('vrangepd,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vrangepd,1,1,1,ymmreg_mz,ymmreg,4b64,imm8');
  FOpCodeList.Add('vrangepd,1,1,1,zmmreg_mz,zmmreg,mem512,imm8');
  FOpCodeList.Add('vrangepd,1,1,1,zmmreg_mz,zmmreg,8b64,imm8');
  FOpCodeList.Add('vrangepd,1,1,1,zmmreg_mz,zmmreg,zmmreg_sae,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,xmmreg_mz,xmmreg,4b32,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,ymmreg_mz,ymmreg,8b32,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,zmmreg_mz,zmmreg,mem512,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,zmmreg_mz,zmmreg,16b32,imm8');
  FOpCodeList.Add('vrangeps,1,1,1,zmmreg_mz,zmmreg,zmmreg_sae,imm8');
  FOpCodeList.Add('vrangesd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vrangesd,1,1,1,xmmreg_mz,xmmreg,mem64,imm8');
  FOpCodeList.Add('vrangess,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vrangess,1,1,1,xmmreg_mz,xmmreg,mem32,imm8');
  FOpCodeList.Add('vrcp14pd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vrcp14pd,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vrcp14pd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vrcp14pd,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vrcp14pd,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vrcp14pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vrcp14ps,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vrcp14ps,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vrcp14ps,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vrcp14ps,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vrcp14ps,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vrcp14ps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vrcp14sd,1,1,1,xmmreg_mz,xmmreg,xmmreg,');
  FOpCodeList.Add('vrcp14sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vrcp14ss,1,1,1,xmmreg_mz,xmmreg,xmmreg,');
  FOpCodeList.Add('vrcp14ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vrcp28pd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vrcp28pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vrcp28pd,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vrcp28ps,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vrcp28ps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vrcp28ps,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vrcp28sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,');
  FOpCodeList.Add('vrcp28sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vrcp28ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,');
  FOpCodeList.Add('vrcp28ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vreducepd,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vreducepd,1,1,1,xmmreg_mz,2b64,imm8,');
  FOpCodeList.Add('vreducepd,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vreducepd,1,1,1,ymmreg_mz,4b64,imm8,');
  FOpCodeList.Add('vreducepd,1,1,1,zmmreg_mz,mem512,imm8,');
  FOpCodeList.Add('vreducepd,1,1,1,zmmreg_mz,8b64,imm8,');
  FOpCodeList.Add('vreducepd,1,1,1,zmmreg_mz,zmmreg_sae,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,xmmreg_mz,4b32,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,ymmreg_mz,8b32,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,zmmreg_mz,mem512,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,zmmreg_mz,16b32,imm8,');
  FOpCodeList.Add('vreduceps,1,1,1,zmmreg_mz,zmmreg_sae,imm8,');
  FOpCodeList.Add('vreducesd,1,1,1,xmmreg_mz,xmmreg,mem64,imm8');
  FOpCodeList.Add('vreducesd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vreducess,1,1,1,xmmreg_mz,xmmreg,mem32,imm8');
  FOpCodeList.Add('vreducess,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vrndscalepd,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vrndscalepd,1,1,1,xmmreg_mz,2b64,imm8,');
  FOpCodeList.Add('vrndscalepd,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vrndscalepd,1,1,1,ymmreg_mz,4b64,imm8,');
  FOpCodeList.Add('vrndscalepd,1,1,1,zmmreg_mz,mem512,imm8,');
  FOpCodeList.Add('vrndscalepd,1,1,1,zmmreg_mz,8b64,imm8,');
  FOpCodeList.Add('vrndscalepd,1,1,1,zmmreg_mz,zmmreg_sae,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,xmmreg_mz,xmmrm,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,xmmreg_mz,4b32,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,ymmreg_mz,ymmrm,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,ymmreg_mz,8b32,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,zmmreg_mz,mem512,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,zmmreg_mz,16b32,imm8,');
  FOpCodeList.Add('vrndscaleps,1,1,1,zmmreg_mz,zmmreg_sae,imm8,');
  FOpCodeList.Add('vrndscalesd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vrndscalesd,1,1,1,xmmreg_mz,xmmreg,mem64,imm8');
  FOpCodeList.Add('vrndscaless,1,1,1,xmmreg_mz,xmmreg,mem32,imm8');
  FOpCodeList.Add('vrndscaless,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,imm8');
  FOpCodeList.Add('vrsqrt14pd,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vrsqrt14pd,1,1,1,xmmreg_mz,2b64,,');
  FOpCodeList.Add('vrsqrt14pd,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vrsqrt14pd,1,1,1,ymmreg_mz,4b64,,');
  FOpCodeList.Add('vrsqrt14pd,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vrsqrt14pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vrsqrt14ps,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('vrsqrt14ps,1,1,1,xmmreg_mz,4b32,,');
  FOpCodeList.Add('vrsqrt14ps,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('vrsqrt14ps,1,1,1,ymmreg_mz,8b32,,');
  FOpCodeList.Add('vrsqrt14ps,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('vrsqrt14ps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vrsqrt14sd,1,1,1,xmmreg_mz,xmmreg,xmmreg,');
  FOpCodeList.Add('vrsqrt14sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vrsqrt14ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vrsqrt14ss,1,1,1,xmmreg_mz,xmmreg,xmmreg,');
  FOpCodeList.Add('vrsqrt28pd,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vrsqrt28pd,1,1,1,zmmreg_mz,8b64,,');
  FOpCodeList.Add('vrsqrt28pd,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vrsqrt28ps,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('vrsqrt28ps,1,1,1,zmmreg_mz,16b32,,');
  FOpCodeList.Add('vrsqrt28ps,1,1,1,zmmreg_mz,zmmreg_sae,,');
  FOpCodeList.Add('vrsqrt28sd,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,');
  FOpCodeList.Add('vrsqrt28sd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vrsqrt28ss,1,1,1,xmmreg_mz,xmmreg,xmmreg_sae,');
  FOpCodeList.Add('vrsqrt28ss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vscalefpd,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vscalefpd,1,1,1,xmmreg_mz,xmmreg,2b64,');
  FOpCodeList.Add('vscalefpd,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vscalefpd,1,1,1,ymmreg_mz,ymmreg,4b64,');
  FOpCodeList.Add('vscalefpd,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vscalefpd,1,1,1,zmmreg_mz,zmmreg,8b64,');
  FOpCodeList.Add('vscalefpd,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vscalefps,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('vscalefps,1,1,1,xmmreg_mz,xmmreg,4b32,');
  FOpCodeList.Add('vscalefps,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('vscalefps,1,1,1,ymmreg_mz,ymmreg,8b32,');
  FOpCodeList.Add('vscalefps,1,1,1,zmmreg_mz,zmmreg,mem512,');
  FOpCodeList.Add('vscalefps,1,1,1,zmmreg_mz,zmmreg,16b32,');
  FOpCodeList.Add('vscalefps,1,1,1,zmmreg_mz,zmmreg,zmmreg_er,');
  FOpCodeList.Add('vscalefsd,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vscalefsd,1,1,1,xmmreg_mz,xmmreg,mem64,');
  FOpCodeList.Add('vscalefss,1,1,1,xmmreg_mz,xmmreg,xmmreg_er,');
  FOpCodeList.Add('vscalefss,1,1,1,xmmreg_mz,xmmreg,mem32,');
  FOpCodeList.Add('vscatterdpd,1,1,1,xmem64_m,xmmreg,,');
  FOpCodeList.Add('vscatterdpd,1,1,1,xmem64_m,ymmreg,,');
  FOpCodeList.Add('vscatterdpd,1,1,1,ymem64_m,zmmreg,,');
  FOpCodeList.Add('vscatterdps,1,1,1,xmem32_m,xmmreg,,');
  FOpCodeList.Add('vscatterdps,1,1,1,ymem32_m,ymmreg,,');
  FOpCodeList.Add('vscatterdps,1,1,1,zmem32_m,zmmreg,,');
  FOpCodeList.Add('vscatterqpd,1,1,1,xmem64_m,xmmreg,,');
  FOpCodeList.Add('vscatterqpd,1,1,1,ymem64_m,ymmreg,,');
  FOpCodeList.Add('vscatterqpd,1,1,1,zmem64_m,zmmreg,,');
  FOpCodeList.Add('vscatterqps,1,1,1,xmem32_m,xmmreg,,');
  FOpCodeList.Add('vscatterqps,1,1,1,ymem32_m,xmmreg,,');
  FOpCodeList.Add('vscatterqps,1,1,1,zmem32_m,ymmreg,,');
  FOpCodeList.Add('vshuff32x4,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vshuff32x4,1,1,1,ymmreg_mz,ymmreg,8b32,imm8');
  FOpCodeList.Add('vshuff32x4,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vshuff32x4,1,1,1,zmmreg_mz,zmmreg,16b32,imm8');
  FOpCodeList.Add('vshuff64x2,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vshuff64x2,1,1,1,ymmreg_mz,ymmreg,4b64,imm8');
  FOpCodeList.Add('vshuff64x2,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vshuff64x2,1,1,1,zmmreg_mz,zmmreg,8b64,imm8');
  FOpCodeList.Add('vshufi32x4,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vshufi32x4,1,1,1,ymmreg_mz,ymmreg,8b32,imm8');
  FOpCodeList.Add('vshufi32x4,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vshufi32x4,1,1,1,zmmreg_mz,zmmreg,16b32,imm8');
  FOpCodeList.Add('vshufi64x2,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('vshufi64x2,1,1,1,ymmreg_mz,ymmreg,4b64,imm8');
  FOpCodeList.Add('vshufi64x2,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('vshufi64x2,1,1,1,zmmreg_mz,zmmreg,8b64,imm8');

  FOpCodeList.Add('movntss,1,1,0,MEM32,XMMREG,');
  FOpCodeList.Add('movntsd,1,1,0,MEM64,XMMREG,');

  FOpCodeList.Add('VAESDEC,1,1,1,xmmreg,xmmreg,xmmrm,');
  FOpCodeList.Add('VAESDEC,1,1,1,zmmreg,zmmreg,zmmrm,');
  FOpCodeList.Add('VAESDECLAST,1,1,1,xmmreg,xmmreg,xmmrm,');
  FOpCodeList.Add('VAESDECLAST,1,1,1,zmmreg,zmmreg,zmmrm,');
  FOpCodeList.Add('VAESENC,1,1,1,xmmreg,xmmreg,xmmrm,');
  FOpCodeList.Add('VAESENC,1,1,1,zmmreg,zmmreg,zmmrm,');
  FOpCodeList.Add('VAESENCLAST,1,1,1,xmmreg,xmmreg,xmmrm,');
  FOpCodeList.Add('VAESENCLAST,1,1,1,zmmreg,zmmreg,zmmrm,');
  FOpCodeList.Add('VPCOMPRESSB,1,1,1,mem128_m,xmmreg,,');
  FOpCodeList.Add('VPCOMPRESSB,1,1,1,mem256_m,ymmreg,,');
  FOpCodeList.Add('VPCOMPRESSB,1,1,1,mem512_m,zmmreg,,');
  FOpCodeList.Add('VPCOMPRESSB,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('VPCOMPRESSB,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('VPCOMPRESSB,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('VPCOMPRESSW,1,1,1,mem128_m,xmmreg,,');
  FOpCodeList.Add('VPCOMPRESSW,1,1,1,mem256_m,ymmreg,,');
  FOpCodeList.Add('VPCOMPRESSW,1,1,1,mem512_m,zmmreg,,');
  FOpCodeList.Add('VPCOMPRESSW,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('VPCOMPRESSW,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('VPCOMPRESSW,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('VPDPBUSD,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPDPBUSD,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('VPDPBUSD,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPDPBUSD,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('VPDPBUSD,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPDPBUSD,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('VPDPBUSDS,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPDPBUSDS,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('VPDPBUSDS,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPDPBUSDS,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('VPDPBUSDS,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPDPBUSDS,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('VPDPWSSD,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPDPWSSD,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('VPDPWSSD,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPDPWSSD,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('VPDPWSSD,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPDPWSSD,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('VPDPWSSDS,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPDPWSSDS,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('VPDPWSSDS,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPDPWSSDS,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('VPDPWSSDS,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPDPWSSDS,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('VPEXPANDB,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('VPEXPANDB,1,1,1,ymmreg_mz,mem256,,');
  FOpCodeList.Add('VPEXPANDB,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('VPEXPANDB,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('VPEXPANDB,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('VPEXPANDB,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('VPEXPANDW,1,1,1,xmmreg_mz,mem128,,');
  FOpCodeList.Add('VPEXPANDW,1,1,1,ymmreg_mz,mem256,,');
  FOpCodeList.Add('VPEXPANDW,1,1,1,zmmreg_mz,mem512,,');
  FOpCodeList.Add('VPEXPANDW,1,1,1,xmmreg_mz,xmmreg,,');
  FOpCodeList.Add('VPEXPANDW,1,1,1,ymmreg_mz,ymmreg,,');
  FOpCodeList.Add('VPEXPANDW,1,1,1,zmmreg_mz,zmmreg,,');
  FOpCodeList.Add('VPOPCNTB,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('VPOPCNTB,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('VPOPCNTB,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('VPOPCNTD,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('VPOPCNTD,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('VPOPCNTD,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('VPOPCNTQ,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('VPOPCNTQ,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('VPOPCNTQ,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('VPOPCNTW,1,1,1,xmmreg_mz,xmmrm,,');
  FOpCodeList.Add('VPOPCNTW,1,1,1,ymmreg_mz,ymmrm,,');
  FOpCodeList.Add('VPOPCNTW,1,1,1,zmmreg_mz,zmmrm,,');
  FOpCodeList.Add('VPSHLDD,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('VPSHLDD,1,1,1,xmmreg_mz,xmmreg,4B32,imm8');
  FOpCodeList.Add('VPSHLDD,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('VPSHLDD,1,1,1,ymmreg_mz,ymmreg,8B32,imm8');
  FOpCodeList.Add('VPSHLDD,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('VPSHLDD,1,1,1,zmmreg_mz,zmmreg,16B32,imm8');
  FOpCodeList.Add('VPSHLDQ,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('VPSHLDQ,1,1,1,xmmreg_mz,xmmreg,2B64,imm8');
  FOpCodeList.Add('VPSHLDQ,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('VPSHLDQ,1,1,1,ymmreg_mz,ymmreg,4B64,imm8');
  FOpCodeList.Add('VPSHLDQ,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('VPSHLDQ,1,1,1,zmmreg_mz,zmmreg,8B64,imm8');
  FOpCodeList.Add('VPSHLDVD,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHLDVD,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('VPSHLDVD,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHLDVD,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('VPSHLDVD,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPSHLDVD,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('VPSHLDVQ,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHLDVQ,1,1,1,xmmreg_mz,xmmreg,2B64,');
  FOpCodeList.Add('VPSHLDVQ,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHLDVQ,1,1,1,ymmreg_mz,ymmreg,4B64,');
  FOpCodeList.Add('VPSHLDVQ,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPSHLDVQ,1,1,1,zmmreg_mz,zmmreg,8B64,');
  FOpCodeList.Add('VPSHLDVW,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHLDVW,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHLDVW,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPSHLDW,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('VPSHLDW,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('VPSHLDW,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('VPSHRDD,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('VPSHRDD,1,1,1,xmmreg_mz,xmmreg,4B32,imm8');
  FOpCodeList.Add('VPSHRDD,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('VPSHRDD,1,1,1,ymmreg_mz,ymmreg,8B32,imm8');
  FOpCodeList.Add('VPSHRDD,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('VPSHRDD,1,1,1,zmmreg_mz,zmmreg,16B32,imm8');
  FOpCodeList.Add('VPSHRDQ,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('VPSHRDQ,1,1,1,xmmreg_mz,xmmreg,2B64,imm8');
  FOpCodeList.Add('VPSHRDQ,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('VPSHRDQ,1,1,1,ymmreg_mz,ymmreg,4B64,imm8');
  FOpCodeList.Add('VPSHRDQ,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('VPSHRDQ,1,1,1,zmmreg_mz,zmmreg,8B64,imm8');
  FOpCodeList.Add('VPSHRDVD,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHRDVD,1,1,1,xmmreg_mz,xmmreg,4B32,');
  FOpCodeList.Add('VPSHRDVD,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHRDVD,1,1,1,ymmreg_mz,ymmreg,8B32,');
  FOpCodeList.Add('VPSHRDVD,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPSHRDVD,1,1,1,zmmreg_mz,zmmreg,16B32,');
  FOpCodeList.Add('VPSHRDVQ,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHRDVQ,1,1,1,xmmreg_mz,xmmreg,2B64,');
  FOpCodeList.Add('VPSHRDVQ,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHRDVQ,1,1,1,ymmreg_mz,ymmreg,4B64,');
  FOpCodeList.Add('VPSHRDVQ,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPSHRDVQ,1,1,1,zmmreg_mz,zmmreg,8B64,');
  FOpCodeList.Add('VPSHRDVW,1,1,1,xmmreg_mz,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHRDVW,1,1,1,ymmreg_mz,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHRDVW,1,1,1,zmmreg_mz,zmmreg,zmmrm,');
  FOpCodeList.Add('VPSHRDW,1,1,1,xmmreg_mz,xmmreg,xmmrm,imm8');
  FOpCodeList.Add('VPSHRDW,1,1,1,ymmreg_mz,ymmreg,ymmrm,imm8');
  FOpCodeList.Add('VPSHRDW,1,1,1,zmmreg_mz,zmmreg,zmmrm,imm8');
  FOpCodeList.Add('VPSHUFBITQMB,1,1,1,kreg_m,xmmreg,xmmrm,');
  FOpCodeList.Add('VPSHUFBITQMB,1,1,1,kreg_m,ymmreg,ymmrm,');
  FOpCodeList.Add('VPSHUFBITQMB,1,1,1,kreg_m,zmmreg,zmmrm,');
{$endif TEST_ALL}  
end;

function TAVXTestGenerator.SaveFile(aAsmList: TStringList; aOpcode, aDestPath,
  aFileExt: String; aHeaderList, aFooterList: TStringList): boolean;
begin
  begin
    result := false;

    if aAsmList.Count > 0 then
    begin
      aAsmList.Insert(0, StringReplace(aHeaderList.Text, '$$$OPCODE$$$', aOpCode, [rfReplaceAll]));
      aAsmList.AddStrings(StringReplace(aFooterList.Text, '$$$OPCODE$$$', aOpCode, [rfReplaceAll]));

      aAsmList.SaveToFile(IncludeTrailingBackslash(aDestPath) + aOpCode + aFileExt);
    end;
  end;
end;

function TAVXTestGenerator.InternalMakeTestFiles(aMRef, aX64, aAVX512, aSAE: boolean; aDestPath, aFilemask, aFileExt: String;
                                        aOpCodeList, aHeaderList, aFooterList: TStringList): boolean;
var
  i,j: integer;
  sData: string;
  sDestFile: string;
  sLocalVarDataTyp: string;
  sl: TStringList;
  slAsm: TStringList;
  slLocalHeader: TStringList;
  slFilemask: TStringList;
  LastOpCode: String;
  NewOpCode: String;
  FoundNewOpcode: boolean;

  //function SaveFile(aAsmList: TStringList; aOpcode, aDestPath, aFileExt: String; aHeaderList, aFooterList: TStringList): boolean;
  //begin
  //  result := false;
  //
  //  if aAsmList.Count > 0 then
  //  begin
  //    aAsmList.Insert(0, StringReplace(aHeaderList.Text, '$$$OPCODE$$$', aOpCode, [rfReplaceAll]));
  //    aAsmList.AddStrings(StringReplace(aFooterList.Text, '$$$OPCODE$$$', aOpCode, [rfReplaceAll]));
  //
  //    aAsmList.SaveToFile(IncludeTrailingBackslash(aDestPath) + aOpCode + aFileExt);
  //  end;
  //end;

begin
  result := false;

  aOpCodeList.Sort;

  sl := TStringList.Create;
  try
    slAsm := TStringList.Create;
    try
      slFilemask := TStringList.Create;
      try
        slFilemask.CommaText := ansilowercase(aFilemask);

        LastOpCode := '';

        for i := 0 to aOpCodeList.Count - 1 do
        begin
          sl.Clear;
          sl.CommaText := aOpCodeList[i];

          while sl.Count < 8 do sl.Add('');

          NewOpCode := ansilowercase(sl[0]);

          FoundNewOpcode := false;
          for j := 0 to slFilemask.Count - 1 do
          begin
            if Pos(slFilemask[j], NewOpCode) = 1 then
             FoundNewOpcode := true;
          end;

          if not(FoundNewOpcode) and (slFilemask.Count > 0) then
           NewOpcode := '';

          if NewOpCode <> '' then
          begin
            if (not(aX64) and (sl[1] = '1')) or // i386
               (aX64 and (sl[2] = '1')) then    // x86_64
            begin
	      sDestFile := format('%s_%d%s', [NewOpcode, i, trim(copy(sl[4],1,1) + copy(sl[5],1,1) + copy(sl[6],1,1) + copy(sl[7],1,1))]);

              slLocalHeader := TStringList.Create;
              try
                slLocalHeader.Text := aHeaderList.text;

	        if (sl[4]  = '') and
                   (sl[5]  = '') and
                   (sl[6]  = '') and
                   (sl[7]  = '') then
                begin                                        // Opcode with no Params, e.g. VZEROALL
                  slAsm.Add('    ' + sl[0]);
                end
                else
	        begin
                  if aMREF then
	          begin
                    sLocalVarDataTyp := '';
 	            TAsmTestGenerator.CalcTestDataMREF(aX64, aAVX512 and (sl[3] = '1'), aSAE, sl[0], sl[4], sl[5], sl[6], sl[7], slAsm);
		    sDestFile := 'MREF_' + sDestFile;

		    if trim(sLocalVarDataTyp) = '' then
		     sLocalVarDataTyp := 'byte';

                    slLocalHeader.Text :=  StringReplace(aHeaderList.Text, '$$$LOCALVARDATATYP$$$', sLocalVarDataTyp, [rfReplaceAll]);
	          end
   	          else TAsmTestGenerator.CalcTestData(aX64, aAVX512 and (sl[3] = '1'), aSAE, sl[0], sl[4], sl[5], sl[6], sl[7], slAsm);
	        end;

                SaveFile(slAsm, sDestFile, aDestPath, aFileExt, slLocalHeader, aFooterList);
                writeln(format('%s%s%s', [aDestPath, sDestFile, aFileExt]));

              finally
                FreeAndNil(slLocalHeader);
              end;

              slAsm.Clear;
            end;
          end;
        end;
      finally
        FreeAndNil(slFilemask);
      end;
    finally
      FreeAndNil(slAsm);
    end;
  finally
    FreeAndNil(sl);
  end;
end;

function TAVXTestGenerator.InternalMakeTestFilesCDisp8(aX64, aAVX512,
  aSAE: boolean; aDestPath, aFilemask, aFileExt: String; aOpCodeList,
  aHeaderList, aFooterList: TStringList): boolean;
var
  i,j: integer;
  sData: string;
  sDestFile: string;
  sLocalVarDataTyp: string;
  sl: TStringList;
  slAsm: TStringList;
  slLocalHeader: TStringList;
  slFilemask: TStringList;
  LastOpCode: String;
  NewOpCode: String;
  FoundNewOpcode: boolean;

begin
  result := false;

  aOpCodeList.Sort;

  sl := TStringList.Create;
  try
    slAsm := TStringList.Create;
    try
      slFilemask := TStringList.Create;
      try
        slFilemask.CommaText := ansilowercase(aFilemask);

        LastOpCode := '';

        for i := 0 to aOpCodeList.Count - 1 do
        begin
          sl.Clear;
          sl.CommaText := aOpCodeList[i];

          while sl.Count < 8 do sl.Add('');

          NewOpCode := ansilowercase(sl[0]);

          FoundNewOpcode := false;
          for j := 0 to slFilemask.Count - 1 do
          begin
            if Pos(slFilemask[j], NewOpCode) = 1 then
             FoundNewOpcode := true;
          end;

          if not(FoundNewOpcode) and (slFilemask.Count > 0) then
           NewOpcode := '';

          if NewOpCode <> '' then
          begin
            if (
                (not(aX64) and (sl[1] = '1')) or // i386
                (aX64 and (sl[2] = '1'))
               ) and
               (
                sl[3] = '1'
               )

                then    // x86_64
            begin
	      sDestFile := format('%s_%d%s', [NewOpcode, i, trim(copy(sl[4],1,1) + copy(sl[5],1,1) + copy(sl[6],1,1) + copy(sl[7],1,1))]);

              slLocalHeader := TStringList.Create;
              try
                slLocalHeader.Text := aHeaderList.text;

	        if (sl[4]  = '') and
                   (sl[5]  = '') and
                   (sl[6]  = '') and
                   (sl[7]  = '') then
                begin                                        // Opcode with no Params, e.g. VZEROALL
                  slAsm.Add('    ' + sl[0]);
                end
                else
	        begin
   	          TAsmTestGenerator.CalcTestDataCDisp8(aX64, aAVX512 and (sl[3] = '1'), aSAE, sl[0], sl[4], sl[5], sl[6], sl[7], slAsm);
	        end;

                if trim(slAsm.Text) <> '' then
                begin
                  sDestFile := 'CDISP8_' + sDestFile;
                  SaveFile(slAsm, sDestFile, aDestPath, aFileExt, slLocalHeader, aFooterList);
                  writeln(format('%s%s%s', [aDestPath, sDestFile, aFileExt]));
                end;
              finally
                FreeAndNil(slLocalHeader);
              end;

              slAsm.Clear;
            end;
          end;
        end;
      finally
        FreeAndNil(slFilemask);
      end;
    finally
      FreeAndNil(slAsm);
    end;
  finally
    FreeAndNil(sl);
  end;
end;

function TAVXTestGenerator.MakeTestFiles(aTyp: TTestFileTyp; aX64, aAVX512, aSAE: boolean;
  aDestPath, aFilemask: String): boolean;
var
  slHeader: TStringList;
  slFooter: TStringList;
  FileExt: String;
  i: integer;
const
  cPlatform: array[boolean] of String = (('i386'), ('x86_64'));
begin
  result := false;

  slHeader := TStringList.Create;
  try
    slFooter := TStringList.Create;
    try
      case aTyp of
         tfFPC: begin
                  writeln(format('outputformat: fpc  platform: %s  path: %s',
                                 [cPlatform[aX64], aDestPath]));

                  FileExt := '.pp';

                  slHeader.Add('Program $$$OPCODE$$$;');
                  slHeader.Add('{$asmmode intel}');
                  slHeader.Add('begin');
                  slHeader.Add('  asm');

                  for i := 1 to 10 do
                   slHeader.Add('NOP');

                  for i := 1 to 10 do
                   slFooter.Add('NOP');

                  slFooter.Add('  end;');
                  slFooter.Add('end.');
                end;
         tfFPCMRef:
                begin
                  writeln(format('outputformat: fpc  platform: %s  path: %s',
                                 [cPlatform[aX64], aDestPath]));

                  FileExt := '.pp';

                  slHeader.Add('Program $$$OPCODE$$$;');
                  slHeader.Add('{$asmmode intel}');

                  slHeader.Add('type');
                  slHeader.Add('  rec = record');

                  slHeader.Add('    rByte: byte;');
                  slHeader.Add('    rWord: word;');
                  slHeader.Add('    rDWord: dword;');
                  slHeader.Add('    rQWord: qword;');
                  slHeader.Add('    rOWord: array[0..15] of byte;');
                  slHeader.Add('    rYWord: array[0..31] of byte;');
                  slHeader.Add('    rZWord: array[0..63] of byte;');

                  slHeader.Add('  end;');


		  slHeader.Add('var');
                  slHeader.Add('   gRec: rec;');
		  slHeader.Add('   gByte: byte;');
		  slHeader.Add('   gWord: word;');
		  slHeader.Add('  gDWord: dword;');
		  slHeader.Add('  gQWord: qword;');
		  slHeader.Add('  gOWord: array[0..15] of byte;');
		  slHeader.Add('  gYWord: array[0..31] of byte;');
		  slHeader.Add('  gZWord: array[0..63] of byte;');

		  slHeader.Add('const');
		  slHeader.Add('   cgByte: byte = 0;');
		  slHeader.Add('   cgWord: word = 0;');
		  slHeader.Add('  cgDWord: dword = 0;');
		  slHeader.Add('  cgQWord: qword = 0;');
		  slHeader.Add('  cgOWord: array[0..15] of byte = ((0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0));');

		  slHeader.Add('  cgYWord: array[0..31] of byte = ((0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0));');

		  slHeader.Add('  cgZWord: array[0..63] of byte = ((0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                  '(0),(0),(0),(0),(0),(0),(0),(0));');

//  slHeader.Add('  cgZWord: array[0..63] of byte;');

                  slHeader.Add(' procedure dummyproc;');
		  slHeader.Add(' var');
                  slHeader.Add('     lRec: rec;');
		  slHeader.Add('     lByte: byte;');
		  slHeader.Add('     lWord: word;');
		  slHeader.Add('    lDWord: dword;');
		  slHeader.Add('    lQWord: qword;');
		  slHeader.Add('    lOWord: array[0..15] of byte;');
		  slHeader.Add('    lYWord: array[0..31] of byte;');
		  slHeader.Add('    lSingle: single;');

		  slHeader.Add('    lDouble: double;');
		  slHeader.Add('    lZWord: array[0..63] of byte;');

                  slHeader.Add(' const');
		  slHeader.Add('     clByte: byte = 0;');
		  slHeader.Add('     clWord: word = 0;');
		  slHeader.Add('    clDWord: dword = 0;');
		  slHeader.Add('    clQWord: qword = 0;');
		  slHeader.Add('    clOWord: array[0..15] of byte = ((0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0));');

		  slHeader.Add('    clYWord: array[0..31] of byte = ((0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0));');

		  slHeader.Add('    clZWord: array[0..63] of byte = ((0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
		                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0),' +
                                                                    '(0),(0),(0),(0),(0),(0),(0),(0));');



                  slHeader.Add(' begin');
                  slHeader.Add('   asm');
                  for i := 1 to 10 do
                   slHeader.Add('    NOP');


                  for i := 1 to 10 do
                   slFooter.Add('    NOP');

		  slFooter.Add('  end;');
		  slFooter.Add(' end;');
                  slFooter.Add('begin');
                  slFooter.Add('end.');
                end;
         tfFPCCDisp8:
                begin
                  writeln(format('outputformat: fpc  platform: %s  path: %s',
                                 [cPlatform[aX64], aDestPath]));

                  FileExt := '.pp';

                  slHeader.Add('Program $$$OPCODE$$$;');
                  slHeader.Add('{$asmmode intel}');
                  slHeader.Add('{$mode objfpc}{$H+}');

                  slHeader.Add('uses sysutils;');

                  slHeader.Add('const');
                  slHeader.Add('  cDataBlockByte: Array[0..255] of byte = ( $00, $01, $02, $03, $04, $05, $06, $07, $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,');
                  slHeader.Add('                                            $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $1A, $1B, $1C, $1D, $1E, $1F,');
                  slHeader.Add('                                            $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,');
                  slHeader.Add('                                            $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,');
                  slHeader.Add('                                            $40, $41, $42, $43, $44, $45, $46, $47, $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,');
                  slHeader.Add('                                            $50, $51, $52, $53, $54, $55, $56, $57, $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,');
                  slHeader.Add('                                            $60, $61, $62, $63, $64, $65, $66, $67, $68, $69, $6A, $6B, $6C, $6D, $6E, $6F,');
                  slHeader.Add('                                            $70, $71, $72, $73, $74, $75, $76, $77, $78, $79, $7A, $7B, $7C, $7D, $7E, $7F,');
                  slHeader.Add('                                            $80, $81, $82, $83, $84, $85, $86, $87, $88, $89, $8A, $8B, $8C, $8D, $8E, $8F,');
                  slHeader.Add('                                            $90, $91, $92, $93, $94, $95, $96, $97, $98, $99, $9A, $9B, $9C, $9D, $9E, $9F,');
                  slHeader.Add('                                            $A0, $A1, $A2, $A3, $A4, $A5, $A6, $A7, $A8, $A9, $AA, $AB, $AC, $AD, $AE, $AF,');
                  slHeader.Add('                                            $B0, $B1, $B2, $B3, $B4, $B5, $B6, $B7, $B8, $B9, $BA, $BB, $BC, $BD, $BE, $BF,');
                  slHeader.Add('                                            $C0, $C1, $C2, $C3, $C4, $C5, $C6, $C7, $C8, $C9, $CA, $CB, $CC, $CD, $CE, $CF,');
                  slHeader.Add('                                            $D0, $D1, $D2, $D3, $D4, $D5, $D6, $D7, $D8, $D9, $DA, $DB, $DC, $DD, $DE, $DF,');
                  slHeader.Add('                                            $E0, $E1, $E2, $E3, $E4, $E5, $E6, $E7, $E8, $E9, $EA, $EB, $EC, $ED, $EE, $EF,');
                  slHeader.Add('                                            $F0, $F1, $F2, $F3, $F4, $F5, $F6, $F7, $F8, $F9, $FA, $FB, $FC, $FD, $FE, $FF);');
                  slHeader.Add('var');
                  slHeader.Add('  DataBlock: Array[0..$3FFF] of dword;');
                  slHeader.Add('  i: integer;');

                  slHeader.Add('procedure writelnK7;');
                  slHeader.Add('var');
                  slHeader.Add('  iK7: dword;');
                  slHeader.Add('begin');
                  slHeader.Add('  asm');
                  slHeader.Add('    kmovd  iK7, k7');
                  slHeader.Add('  end;');
                  slHeader.Add('  writeln(''K7: '' + ' + 'inttostr(iK7));');
                  slHeader.Add('end;');

                  slHeader.Add('procedure writelnOK;');
                  slHeader.Add('begin');
                  slHeader.Add('  writeln('' OK '');');
                  slHeader.Add('end;');


                  slHeader.Add('begin');
                  slHeader.Add('  for i := 0 to high(DataBlock) do');
                  slHeader.Add('   DataBlock[i] := cDataBlockByte[i mod 256];');

                  slHeader.Add('  write(Paramstr(0) + '': '');');

                  slHeader.Add('  try');
                  slHeader.Add('    asm');

                  slHeader.Add('      vpxord   zmm0,  zmm0,  zmm0');
                  slHeader.Add('      vpxord   xmm1,  xmm1,  xmm1');
                  slHeader.Add('      vpxord   xmm2,  xmm2,  xmm2');
                  slHeader.Add('      vpxord   xmm3,  xmm3,  xmm3');
                  slHeader.Add('      vpxord   xmm4,  xmm4,  xmm4');
                  slHeader.Add('      vpcmpeqb   k1,  zmm0,  zmm0');

                  if aX64 then
                  begin
                    slHeader.Add('      lea       rax, @@CHECKRESULT');
                    slHeader.Add('      kmovq      k6, rax');

                    slHeader.Add('      lea       rax, DataBlock');
                    slHeader.Add('      push      rax');
                  end
                  else
                  begin
                    slHeader.Add('      lea       eax, @@CHECKRESULT');
                    slHeader.Add('      kmovd      k6, eax');

                    slHeader.Add('      lea       eax, DataBlock');
                    slHeader.Add('      push      eax');
                  end;


                  for i := 1 to 10 do
                   slHeader.Add('NOP');


                  for i := 1 to 10 do
                   slFooter.Add('NOP');

                  slFooter.Add('      call writelnOK');
                  slFooter.Add('      jmp  @@END');


                  slFooter.Add('  @@CHECKRESULT:   ');
                  slFooter.Add('      kmovd  eax, k7');
                  slFooter.Add('      call writelnK7');
                  slFooter.Add('  @@END:   ');


                  if aX64 then slFooter.Add('        pop rax')
                   else slFooter.Add('        pop eax');


                  slFooter.Add('    end;');
                  slFooter.Add('  except');
                  slFooter.Add('    on E: EInvalidOp do');
                  slFooter.Add('      begin');
                  slFooter.Add('        writeln(''Error - Invalid Op: '' + E.Message);');
                  slFooter.Add('      end;');

                  slFooter.Add('    on E: Exception do');
                  slFooter.Add('      begin');
                  slFooter.Add('        writeln(''Fehler: '' + E.Message);');
                  slFooter.Add('      end;');
                  slFooter.Add('  end;');
                  slFooter.Add('end.');

                end;
         tfFPCInc: begin
                  writeln(format('outputformat: fpc  platform: %s  path: %s',
                                 [cPlatform[aX64], aDestPath]));

                  FileExt := '.pp';

                  slHeader.Add('Program Test$$$OPCODE$$$;');
                  slHeader.Add('{$asmmode intel}');
                  slHeader.Add('{$warn 7102 off}');
                  slHeader.Add('{$I $$$OPCODE$$$.inc}');
                  slHeader.Add('Procedure Proc$$$OPCODE$$$;assembler;nostackframe;');
                  slHeader.Add('  asm');

                  for i := 1 to 10 do
                   slHeader.Add(#9'NOP');

                  for i := 1 to 10 do
                   slFooter.Add(#9'NOP');

                  slFooter.Add('  end;');
                  slFooter.Add('procedure check(const id: string; const expected: array of byte; p: pointer);');
                  slFooter.Add('var');
                  slFooter.Add('  i : longint;');
                  slFooter.Add('begin');
                  slFooter.Add('  for i:=0 to high(expected) do');
                  slFooter.Add('    if expected[i]<>pbyte(p)[i] then');
                  slFooter.Add('      begin');
                  slFooter.Add('        writeln(id, '' mismatch at offset $'',hexstr(i,4), '', expected=$'',hexstr(expected[i],2),'' actual=$'',hexstr(pbyte(p)[i],2));');
                  slFooter.Add('        halt(1);');
                  slFooter.Add('      end;');
                  slFooter.Add('end;');

                  slFooter.Add('begin');
                  if aX64 then
                    slFooter.Add('  check(''x86_64'',$$$OPCODE$$$,@Proc$$$OPCODE$$$);')
                  else
                    slFooter.Add('  check(''i386'',$$$OPCODE$$$,@Proc$$$OPCODE$$$);');
                  slFooter.Add('  writeln(''ok'');');
                  slFooter.Add('end.');
                end;
        tfNasm: begin
                  writeln(format('outputformat: Nasm  platform: %s  path: %s',
                                 [cPlatform[aX64], aDestPath]));

                  FileExt := '.asm';

                  if aX64 then slHeader.Add('[BITS 64]')
                   else slHeader.Add('[BITS 32]');

                  for i := 1 to 10 do
                   slHeader.Add('NOP');

                  for i := 1 to 10 do
                   slFooter.Add('NOP');
                end;
        tfFasm: begin
                  writeln(format('outputformat: Fasm  platform: %s  path: %s',
                                 [cPlatform[aX64], aDestPath]));

                  FileExt := '.asm';

                  if aX64 then slHeader.Add('format MS64 COFF')
                   else slHeader.Add('format MS COFF');

                  slHeader.Add('section ''.text'' code readable executable');
                  slHeader.Add('myproc:');

                  for i := 1 to 10 do
                   slHeader.Add('NOP');

                  for i := 1 to 10 do
                   slFooter.Add('NOP');
                end;
      end;

      case aTyp of
        tfFPCCDisp8: InternalMakeTestFilesCDisp8(aX64, aAVX512, aSAE, aDestPath, aFilemask, Fileext, FOpCodeList, slHeader, slFooter);
                else InternalMakeTestFiles(aTyp = tfFPCMRef, aX64, aAVX512, aSAE, aDestPath, aFilemask, Fileext, FOpCodeList, slHeader, slFooter);
      end;

    finally
      FreeAndNil(slFooter);
    end;
  finally
    FreeAndNil(slHeader);
  end;
end;

procedure TAVXTestGenerator.ListMemRefState;
begin
  TAsmTestGenerator.ListMemRefState;
end;

end.

