{%MainUnit sysutils.pp}
{
  This file is in the public domain.
}

{
  This codepage information is based on what is documented at
    1. http://wiki.whatwg.org/wiki/Web_Encodings
    2. http://msdn.microsoft.com/en-us/library/windows/desktop/dd317756(v=vs.85).aspx

    This file only uses bare facts and API information from the above pages
    rather than descriptions or code, neither of which are copyrightable.
}

type
  TCodePageHashEntry = record
    hash: LongWord;
    cp: TSystemCodePage;
    name: PAnsiChar;
  end;
const
  { this array contains many labels for the same codepage. 
    all labels are stored in lowercase and each record has a 
    hash value for the fast search. hash value was get using 
    SysUtils.HashName() function }
  CodePageHashes: array[0..421] of TCodePageHashEntry = (
    (hash: $000004F1; cp: 28591; name: 'l1'),
    (hash: $000004F2; cp: 28592; name: 'l2'),
    (hash: $000004F3; cp: 28593; name: 'l3'),
    (hash: $000004F4; cp: 28594; name: 'l4'),
    (hash: $000004F5; cp: 28599; name: 'l5'),
    (hash: $000004F9; cp: 28605; name: 'l9'),
    (hash: $000005A3; cp: 20127; name: 'us'),
    (hash: $00003767; cp: 437; name: '437'),
    (hash: $00004B6B; cp: 936; name: 'gbk'),
    (hash: $00004E76; cp: 20105; name: 'irv'),
    (hash: $00005039; cp: 20866; name: 'koi'),
    (hash: $000051DB; cp: 3021; name: 'mik'),
    (hash: $00046DA5; cp: 950; name: 'big5'),
    (hash: $000503C8; cp: 20866; name: 'koi8'),
    (hash: $00057EE3; cp: 932; name: 'sjis'),
    (hash: $00270BA4; cp: 50225; name: 'iso-2022-kr-7bit'),
    (hash: $00277BA4; cp: 51949; name: 'iso-2022-kr-8bit'),
    (hash: $003CB225; cp: 21866; name: 'koi8-ru'),
    (hash: $004677D9; cp: 20127; name: 'ascii'),
    (hash: $004811B2; cp: 936; name: 'cn-gb'),
    (hash: $00483367; cp: 37; name: 'cp037'),
    (hash: $004835A3; cp: 20273; name: 'cp273'),
    (hash: $004835A8; cp: 20278; name: 'cp278'),
    (hash: $004835B0; cp: 20280; name: 'cp280'),
    (hash: $004835B4; cp: 20284; name: 'cp284'),
    (hash: $004835B5; cp: 20285; name: 'cp285'),
    (hash: $004835C0; cp: 20290; name: 'cp290'),
    (hash: $004835C7; cp: 20297; name: 'cp297'),
    (hash: $00483697; cp: 20127; name: 'cp367'),
    (hash: $00483750; cp: 20420; name: 'cp420'),
    (hash: $00483753; cp: 20423; name: 'cp423'),
    (hash: $00483754; cp: 20424; name: 'cp424'),
    (hash: $00483767; cp: 437; name: 'cp437'),
    (hash: $00483830; cp: 500; name: 'cp500'),
    (hash: $00483B49; cp: 28591; name: 'cp819'),
    (hash: $00483B80; cp: 850; name: 'cp850'),
    (hash: $00483B82; cp: 852; name: 'cp852'),
    (hash: $00483B85; cp: 855; name: 'cp855'),
    (hash: $00483B86; cp: 856; name: 'cp856'),
    (hash: $00483B87; cp: 857; name: 'cp857'),
    (hash: $00483B88; cp: 858; name: 'cp858'),
    (hash: $00483B90; cp: 860; name: 'cp860'),
    (hash: $00483B91; cp: 861; name: 'cp861'),
    (hash: $00483B92; cp: 862; name: 'cp862'),
    (hash: $00483B93; cp: 863; name: 'cp863'),
    (hash: $00483B94; cp: 864; name: 'cp864'),
    (hash: $00483B95; cp: 865; name: 'cp865'),
    (hash: $00483B96; cp: 866; name: 'cp866'),
    (hash: $00483B99; cp: 869; name: 'cp869'),
    (hash: $00483BA0; cp: 870; name: 'cp870'),
    (hash: $00483BA1; cp: 20871; name: 'cp871'),
    (hash: $00483BA5; cp: 875; name: 'cp875'),
    (hash: $00483BB0; cp: 20880; name: 'cp880'),
    (hash: $00483C35; cp: 20905; name: 'cp905'),
    (hash: $00483C60; cp: 50930; name: 'cp930'),
    (hash: $00483C63; cp: 50933; name: 'cp933'),
    (hash: $00483C65; cp: 50935; name: 'cp935'),
    (hash: $00483C67; cp: 50937; name: 'cp937'),
    (hash: $00483C69; cp: 50939; name: 'cp939'),
    (hash: $004C699B; cp: 28597; name: 'greek'),
    (hash: $004F3C52; cp: 1361; name: 'johab'),
    (hash: $00503CD2; cp: 20866; name: 'koi8r'),
    (hash: $00598602; cp: 1200; name: 'ucs-2'),
    (hash: $005A8907; cp: 65000; name: 'utf-7'),
    (hash: $005A8908; cp: 65001; name: 'utf-8'),
    (hash: $005B1A93; cp: 51932; name: 'x-euc'),
    (hash: $005B1D45; cp: 20105; name: 'x-ia5'),
    (hash: $00764A5F; cp: 858; name: 'pc-multilingual-850+euro'),
    (hash: $00768961; cp: 949; name: 'ksc5601'),
    (hash: $00BF6421; cp: 28591; name: 'iso-8859-1'),
    (hash: $00BF6422; cp: 28592; name: 'iso-8859-2'),
    (hash: $00BF6423; cp: 28593; name: 'iso-8859-3'),
    (hash: $00BF6424; cp: 28594; name: 'iso-8859-4'),
    (hash: $00BF6425; cp: 28595; name: 'iso-8859-5'),
    (hash: $00BF6426; cp: 28596; name: 'iso-8859-6'),
    (hash: $00BF6427; cp: 28597; name: 'iso-8859-7'),
    (hash: $00BF6428; cp: 28598; name: 'iso-8859-8'),
    (hash: $00BF6429; cp: 28599; name: 'iso-8859-9'),
    (hash: $013BD70C; cp: 28598; name: 'logical'),
    (hash: $014A28F8; cp: 28597; name: 'elot_928'),
    (hash: $0160D951; cp: 949; name: 'ks-c-5601'),
    (hash: $0161DA43; cp: 20000; name: 'x-chinese-cns'),
    (hash: $016EFA43; cp: 20000; name: 'x-chinese_cns'),
    (hash: $01834030; cp: 1250; name: 'x-cp1250'),
    (hash: $01834031; cp: 1251; name: 'x-cp1251'),
    (hash: $01A96440; cp: 51932; name: 'x-euc-jp'),
    (hash: $01A964CE; cp: 51936; name: 'x-euc-cn'),
    (hash: $01AA71F1; cp: 29001; name: 'x-europa'),
    (hash: $01B43A77; cp: 949; name: 'csksc56011987'),
    (hash: $01B45C05; cp: 51932; name: 'extended_unix_code_packed_format_for_japanese'),
    (hash: $01B59A95; cp: 51932; name: 'cseucpkdfmtjapanese'),
    (hash: $01E1EC10; cp: 28591; name: 'iso-ir-100'),
    (hash: $01E1EC11; cp: 28592; name: 'iso-ir-101'),
    (hash: $01E1EC19; cp: 28593; name: 'iso-ir-109'),
    (hash: $01E1EC48; cp: 28598; name: 'iso-ir-138'),
    (hash: $01E1EC54; cp: 28595; name: 'iso-ir-144'),
    (hash: $01E1EC58; cp: 28599; name: 'iso-ir-148'),
    (hash: $01E1EC59; cp: 949; name: 'iso-ir-149'),
    (hash: $01E1EC60; cp: 28594; name: 'iso-ir-110'),
    (hash: $01E1EC76; cp: 28597; name: 'iso-ir-126'),
    (hash: $01E1EC77; cp: 28596; name: 'iso-ir-127'),
    (hash: $01F4A887; cp: 65000; name: 'unicode-1-1-utf-7'),
    (hash: $01F4A888; cp: 65001; name: 'unicode-1-1-utf-8'),
    (hash: $02014ABE; cp: 10010; name: 'x-mac-romanian'),
    (hash: $021564C5; cp: 10029; name: 'x-mac-ce'),
    (hash: $021B2870; cp: 50221; name: 'csiso2022jp'),
    (hash: $021B2982; cp: 50225; name: 'csiso2022kr'),
    (hash: $021E1E08; cp: 936; name: 'iso-ir-58'),
    (hash: $022F03D8; cp: 20127; name: 'ansi_x3.4-1968'),
    (hash: $022F03F6; cp: 20127; name: 'ansi_x3.4-1986'),
    (hash: $026BE397; cp: 65000; name: 'csunicode11utf7'),
    (hash: $0278D191; cp: 20108; name: 'ns_4551-1'),
    (hash: $0287A808; cp: 10081; name: 'x-mac-turkish'),
    (hash: $028E6912; cp: 20423; name: 'ebcdic-cp-gr'),
    (hash: $028E6915; cp: 20424; name: 'ebcdic-cp-he'),
    (hash: $028E6933; cp: 20871; name: 'ebcdic-cp-is'),
    (hash: $028E6934; cp: 20280; name: 'ebcdic-cp-it'),
    (hash: $028E695B; cp: 20277; name: 'ebcdic-cp-dk'),
    (hash: $028E6962; cp: 20285; name: 'ebcdic-cp-gb'),
    (hash: $028E6962; cp: 20297; name: 'ebcdic-cp-fr'),
    (hash: $028E6973; cp: 20284; name: 'ebcdic-cp-es'),
    (hash: $028E6979; cp: 20278; name: 'ebcdic-cp-fi'),
    (hash: $028E69A1; cp: 37; name: 'ebcdic-cp-ca'),
    (hash: $028E69A8; cp: 500; name: 'ebcdic-cp-ch'),
    (hash: $028E69B5; cp: 500; name: 'ebcdic-cp-be'),
    (hash: $028E6A14; cp: 37; name: 'ebcdic-cp-wt'),
    (hash: $028E6A35; cp: 870; name: 'ebcdic-cp-yu'),
    (hash: $028E6A42; cp: 20905; name: 'ebcdic-cp-tr'),
    (hash: $028E6A73; cp: 37; name: 'ebcdic-cp-us'),
    (hash: $028E6AA5; cp: 20278; name: 'ebcdic-cp-se'),
    (hash: $028E6AFC; cp: 37; name: 'ebcdic-cp-nl'),
    (hash: $028E6AFF; cp: 20277; name: 'ebcdic-cp-no'),
    (hash: $0297DC23; cp: 20127; name: 'iso646-us'),
    (hash: $029F3787; cp: 437; name: 'cspc8codepage437'),
    (hash: $02A0AB5F; cp: 20924; name: 'ebcdic-latin9--euro'),
    (hash: $02B16815; cp: 950; name: 'x-x-big5'),
    (hash: $02BBC681; cp: 28591; name: 'iso8859-1'),
    (hash: $02BBC682; cp: 28592; name: 'iso8859-2'),
    (hash: $02BF6451; cp: 28591; name: 'iso_8859-1'),
    (hash: $02BF6452; cp: 28592; name: 'iso_8859-2'),
    (hash: $02BF6453; cp: 28593; name: 'iso_8859-3'),
    (hash: $02BF6454; cp: 28594; name: 'iso_8859-4'),
    (hash: $02BF6455; cp: 28595; name: 'iso_8859-5'),
    (hash: $02BF6456; cp: 28596; name: 'iso_8859-6'),
    (hash: $02BF6457; cp: 28597; name: 'iso_8859-7'),
    (hash: $02BF6458; cp: 28598; name: 'iso_8859-8'),
    (hash: $02BF6459; cp: 28599; name: 'iso_8859-9'),
    (hash: $02F4A387; cp: 65000; name: 'unicode-2-0-utf-7'),
    (hash: $02F4A388; cp: 65001; name: 'unicode-2-0-utf-8'),
    (hash: $0392D9A1; cp: 949; name: 'ks_c_5601'),
    (hash: $03A4C608; cp: 20107; name: 'x-ia5-swedish'),
    (hash: $03D38725; cp: 1201; name: 'unicodefffe'),
    (hash: $040BC5DE; cp: 20106; name: 'x-ia5-german'),
    (hash: $041D4FDE; cp: 20002; name: 'x_chinese-eten'),
    (hash: $0429DBD3; cp: 20106; name: 'din_66003'),
    (hash: $044EF491; cp: 28591; name: 'csisolatin1'),
    (hash: $044EF492; cp: 28592; name: 'csisolatin2'),
    (hash: $044EF493; cp: 28593; name: 'csisolatin3'),
    (hash: $044EF494; cp: 28594; name: 'csisolatin4'),
    (hash: $044EF495; cp: 28599; name: 'csisolatin5'),
    (hash: $044EF499; cp: 28605; name: 'csisolatin9'),
    (hash: $04514E25; cp: 10001; name: 'x-mac-japanese'),
    (hash: $04567C3E; cp: 10003; name: 'x-mac-korean'),
    (hash: $046656D3; cp: 28596; name: 'arabic'),
    (hash: $047B63C7; cp: 10005; name: 'x-mac-hebrew'),
    (hash: $04834355; cp: 21025; name: 'cp1025'),
    (hash: $04834356; cp: 1026; name: 'cp1026'),
    (hash: $04834586; cp: 1256; name: 'cp1256'),
    (hash: $04836351; cp: 3021; name: 'cp3021'),
    (hash: $04876DA5; cp: 950; name: 'csbig5'),
    (hash: $049FE4CA; cp: 932; name: 'windows-31j'),
    (hash: $049FE934; cp: 874; name: 'windows-874'),
    (hash: $04A8276B; cp: 28597; name: 'csisolatingreek'),
    (hash: $04A9617E; cp: 51936; name: 'euc-cn'),
    (hash: $04A961F0; cp: 20932; name: 'euc-jp'),
    (hash: $04A961F0; cp: 51932; name: 'euc-jp'),
    (hash: $04A96202; cp: 51949; name: 'euc-kr'),
    (hash: $04B55642; cp: 936; name: 'gb2312'),
    (hash: $04BA715E; cp: 20106; name: 'german'),
    (hash: $04C699E8; cp: 28597; name: 'greek8'),
    (hash: $04C976A7; cp: 28598; name: 'hebrew'),
    (hash: $04D443B3; cp: 10004; name: 'x-mac-arabic'),
    (hash: $04D70367; cp: 37; name: 'ibm037'),
    (hash: $04D705A3; cp: 20273; name: 'ibm273'),
    (hash: $04D705A7; cp: 20277; name: 'ibm277'),
    (hash: $04D705A8; cp: 20278; name: 'ibm278'),
    (hash: $04D705B0; cp: 20280; name: 'ibm280'),
    (hash: $04D705B4; cp: 20284; name: 'ibm284'),
    (hash: $04D705B5; cp: 20285; name: 'ibm285'),
    (hash: $04D705C0; cp: 20290; name: 'ibm290'),
    (hash: $04D705C7; cp: 20297; name: 'ibm297'),
    (hash: $04D70697; cp: 20127; name: 'ibm367'),
    (hash: $04D70750; cp: 20420; name: 'ibm420'),
    (hash: $04D70753; cp: 20423; name: 'ibm423'),
    (hash: $04D70754; cp: 20424; name: 'ibm424'),
    (hash: $04D70767; cp: 437; name: 'ibm437'),
    (hash: $04D70830; cp: 500; name: 'ibm500'),
    (hash: $04D70A67; cp: 737; name: 'ibm737'),
    (hash: $04D70AA5; cp: 775; name: 'ibm775'),
    (hash: $04D70B49; cp: 28591; name: 'ibm819'),
    (hash: $04D70B80; cp: 850; name: 'ibm850'),
    (hash: $04D70B82; cp: 852; name: 'ibm852'),
    (hash: $04D70B85; cp: 855; name: 'ibm855'),
    (hash: $04D70B87; cp: 857; name: 'ibm857'),
    (hash: $04D70B90; cp: 860; name: 'ibm860'),
    (hash: $04D70B91; cp: 861; name: 'ibm861'),
    (hash: $04D70B92; cp: 862; name: 'ibm862'),
    (hash: $04D70B93; cp: 863; name: 'ibm863'),
    (hash: $04D70B94; cp: 864; name: 'ibm864'),
    (hash: $04D70B95; cp: 865; name: 'ibm865'),
    (hash: $04D70B96; cp: 866; name: 'ibm866'),
    (hash: $04D70B99; cp: 869; name: 'ibm869'),
    (hash: $04D70BA0; cp: 870; name: 'ibm870'),
    (hash: $04D70BA1; cp: 20871; name: 'ibm871'),
    (hash: $04D70BB0; cp: 20880; name: 'ibm880'),
    (hash: $04D70C35; cp: 20905; name: 'ibm905'),
    (hash: $0503CB22; cp: 20866; name: 'koi8-r'),
    (hash: $0503CB25; cp: 21866; name: 'koi8-u'),
    (hash: $0504695E; cp: 949; name: 'korean'),
    (hash: $05068E11; cp: 28591; name: 'latin1'),
    (hash: $05068E12; cp: 28592; name: 'latin2'),
    (hash: $05068E13; cp: 28593; name: 'latin3'),
    (hash: $05068E14; cp: 28594; name: 'latin4'),
    (hash: $05068E15; cp: 28599; name: 'latin5'),
    (hash: $05068E19; cp: 28605; name: 'latin9'),
    (hash: $050E3671; cp: 20127; name: 'iso_646.irv:1991'),
    (hash: $0523E96E; cp: 10082; name: 'x-mac-croatian'),
    (hash: $0546BAF8; cp: 28593; name: 'iso_8859-3:1988'),
    (hash: $0552C200; cp: 936; name: 'csgb231280'),
    (hash: $05564100; cp: 936; name: 'gb231280'),
    (hash: $0556BAF8; cp: 28594; name: 'iso_8859-4:1988'),
    (hash: $05610890; cp: 936; name: 'gb_2312-80'),
    (hash: $05641BE0; cp: 936; name: 'gb2312-80'),
    (hash: $0566BAF7; cp: 28591; name: 'iso_8859-1:1987'),
    (hash: $05673E49; cp: 10021; name: 'x-mac-thai'),
    (hash: $0576BAF7; cp: 28592; name: 'iso_8859-2:1987'),
    (hash: $057BD3F0; cp: 50220; name: 'iso-2022-jp'),
    (hash: $057BD3F0; cp: 50222; name: 'iso-2022-jp'),
    (hash: $057BD402; cp: 50225; name: 'iso-2022-kr'),
    (hash: $0586BAF7; cp: 28597; name: 'iso_8859-7:1987'),
    (hash: $0596BAF8; cp: 28598; name: 'iso_8859-8:1988'),
    (hash: $05A6BAF8; cp: 28595; name: 'iso_8859-5:1988'),
    (hash: $05A89046; cp: 1200; name: 'utf-16'),
    (hash: $05A89062; cp: 12000; name: 'utf-32'),
    (hash: $05AE895C; cp: 28598; name: 'visual'),
    (hash: $05B16379; cp: 1252; name: 'x-ansi'),
    (hash: $05B27EE3; cp: 932; name: 'x-sjis'),
    (hash: $05B6BAF7; cp: 28596; name: 'iso_8859-6:1987'),
    (hash: $05E6BAF9; cp: 28599; name: 'iso_8859-9:1989'),
    (hash: $06167279; cp: 20127; name: 'us-ascii'),
    (hash: $06168C31; cp: 949; name: 'ks-c5601'),
    (hash: $061D4F8E; cp: 20002; name: 'x-chinese-eten'),
    (hash: $061D8E42; cp: 932; name: 'x-ms-cp932'),
    (hash: $064748CB; cp: 10006; name: 'x-mac-greek'),
    (hash: $0650F60F; cp: 1148; name: 'ebcdic-international-500+euro'),
    (hash: $06AC1195; cp: 870; name: 'ebcdic-cp-roece'),
    (hash: $07028889; cp: 20838; name: 'ibm-thai'),
    (hash: $07033884; cp: 20924; name: 'ibm00924'),
    (hash: $07033F58; cp: 858; name: 'ibm00858'),
    (hash: $070340A0; cp: 1140; name: 'ibm01140'),
    (hash: $070340A1; cp: 1141; name: 'ibm01141'),
    (hash: $070340A2; cp: 1142; name: 'ibm01142'),
    (hash: $070340A3; cp: 1143; name: 'ibm01143'),
    (hash: $070340A4; cp: 1144; name: 'ibm01144'),
    (hash: $070340A5; cp: 1145; name: 'ibm01145'),
    (hash: $070340A6; cp: 1146; name: 'ibm01146'),
    (hash: $070340A7; cp: 1147; name: 'ibm01147'),
    (hash: $070340A8; cp: 1148; name: 'ibm01148'),
    (hash: $070340A9; cp: 1149; name: 'ibm01149'),
    (hash: $070347A7; cp: 1047; name: 'ibm01047'),
    (hash: $070C5E7E; cp: 10017; name: 'x-mac-ukrainian'),
    (hash: $07781011; cp: 57008; name: 'x-iscii-ka'),
    (hash: $07781025; cp: 57010; name: 'x-iscii-gu'),
    (hash: $07781065; cp: 57002; name: 'x-iscii-de'),
    (hash: $07781083; cp: 57006; name: 'x-iscii-as'),
    (hash: $07781085; cp: 57003; name: 'x-iscii-be'),
    (hash: $077811A2; cp: 57007; name: 'x-iscii-or'),
    (hash: $077811F1; cp: 57009; name: 'x-iscii-ma'),
    (hash: $07781361; cp: 57004; name: 'x-iscii-ta'),
    (hash: $07781365; cp: 57005; name: 'x-iscii-te'),
    (hash: $077813A1; cp: 57011; name: 'x-iscii-pa'),
    (hash: $07928C31; cp: 949; name: 'ksc_5601'),
    (hash: $07B552C2; cp: 936; name: 'csgb2312'),
    (hash: $07B9EE1E; cp: 20108; name: 'norwegian'),
    (hash: $07CE2A35; cp: 936; name: 'chinese'),
    (hash: $07D70123; cp: 20273; name: 'csibm273'),
    (hash: $07D70127; cp: 20277; name: 'csibm277'),
    (hash: $07D70128; cp: 20278; name: 'csibm278'),
    (hash: $07D70130; cp: 20280; name: 'csibm280'),
    (hash: $07D70134; cp: 20284; name: 'csibm284'),
    (hash: $07D70135; cp: 20285; name: 'csibm285'),
    (hash: $07D70140; cp: 20290; name: 'csibm290'),
    (hash: $07D70147; cp: 20297; name: 'csibm297'),
    (hash: $07D703D0; cp: 20420; name: 'csibm420'),
    (hash: $07D703D3; cp: 20423; name: 'csibm423'),
    (hash: $07D703D4; cp: 20424; name: 'csibm424'),
    (hash: $07D707E7; cp: 37; name: 'csibm037'),
    (hash: $07D708B5; cp: 20905; name: 'csibm905'),
    (hash: $07D70CB0; cp: 500; name: 'csibm500'),
    (hash: $07D70F20; cp: 870; name: 'csibm870'),
    (hash: $07D70F21; cp: 20871; name: 'csibm871'),
    (hash: $07D70F30; cp: 20880; name: 'csibm880'),
    (hash: $07E3E528; cp: 10000; name: 'macintosh'),
    (hash: $080AD2EF; cp: 1142; name: 'ebcdic-no-277+euro'),
    (hash: $081112EF; cp: 1142; name: 'ebcdic-dk-277+euro'),
    (hash: $08116DE5; cp: 950; name: 'cn-big5'),
    (hash: $081400D4; cp: 28596; name: 'ecma-114'),
    (hash: $081400D8; cp: 28597; name: 'ecma-118'),
    (hash: $08196A23; cp: 950; name: 'big5-hkscs'),
    (hash: $081EB2EF; cp: 1143; name: 'ebcdic-se-278+euro'),
    (hash: $0821E1E6; cp: 20127; name: 'iso-ir-6'),
    (hash: $08220E58; cp: 708; name: 'asmo-708'),
    (hash: $082372EF; cp: 1143; name: 'ebcdic-fi-278+euro'),
    (hash: $08333BC8; cp: 858; name: 'cp00858'),
    (hash: $08333C14; cp: 20924; name: 'cp00924'),
    (hash: $08334430; cp: 1140; name: 'cp01140'),
    (hash: $08334431; cp: 1141; name: 'cp01141'),
    (hash: $08334432; cp: 1142; name: 'cp01142'),
    (hash: $08334433; cp: 1143; name: 'cp01143'),
    (hash: $08334434; cp: 1144; name: 'cp01144'),
    (hash: $08334435; cp: 1145; name: 'cp01145'),
    (hash: $08334436; cp: 1146; name: 'cp01146'),
    (hash: $08334437; cp: 1147; name: 'cp01147'),
    (hash: $08334438; cp: 1148; name: 'cp01148'),
    (hash: $08334439; cp: 1149; name: 'cp01149'),
    (hash: $08351847; cp: 21027; name: 'x-cp21027'),
    (hash: $08356769; cp: 20949; name: 'x-cp20949'),
    (hash: $08356776; cp: 20936; name: 'x-cp20936'),
    (hash: $08356821; cp: 20001; name: 'x-cp20001'),
    (hash: $08356823; cp: 20003; name: 'x-cp20003'),
    (hash: $08356824; cp: 20004; name: 'x-cp20004'),
    (hash: $08356825; cp: 20005; name: 'x-cp20005'),
    (hash: $08356E81; cp: 20261; name: 'x-cp20261'),
    (hash: $08356E89; cp: 20269; name: 'x-cp20269'),
    (hash: $08386E47; cp: 50227; name: 'x-cp50227'),
    (hash: $08386E49; cp: 50229; name: 'x-cp50229'),
    (hash: $08767799; cp: 20127; name: 'csascii'),
    (hash: $087A9842; cp: 51949; name: 'cseuckr'),
    (hash: $08803C92; cp: 20866; name: 'cskoi8r'),
    (hash: $08904FC5; cp: 1201; name: 'utf-16be'),
    (hash: $089050A5; cp: 1200; name: 'utf-16le'),
    (hash: $089063C5; cp: 12001; name: 'utf-32be'),
    (hash: $08B7920F; cp: 1149; name: 'ebcdic-is-871+euro'),
    (hash: $08B98E28; cp: 20107; name: 'swedish'),
    (hash: $08D1B2EF; cp: 1141; name: 'ebcdic-de-273+euro'),
    (hash: $08E60900; cp: 874; name: 'tis-620'),
    (hash: $08E69B71; cp: 20420; name: 'ebcdic-cp-ar1'),
    (hash: $08F94B01; cp: 50931; name: 'x-ebcdic-japaneseanduscanada'),
    (hash: $093F67C9; cp: 932; name: 'ms_kanji'),
    (hash: $09460A10; cp: 720; name: 'dos-720'),
    (hash: $09460BD2; cp: 862; name: 'dos-862'),
    (hash: $09460BE4; cp: 874; name: 'dos-874'),
    (hash: $09546E83; cp: 10079; name: 'x-mac-icelandic'),
    (hash: $096928A1; cp: 20290; name: 'ebcdic-jp-kana'),
    (hash: $09A782EF; cp: 1144; name: 'ebcdic-it-280+euro'),
    (hash: $09E13833; cp: 20880; name: 'ebcdic-cyrillic'),
    (hash: $09E392EF; cp: 1145; name: 'ebcdic-es-284+euro'),
    (hash: $09F2E2EF; cp: 1146; name: 'ebcdic-gb-285+euro'),
    (hash: $09FE6CC0; cp: 1250; name: 'windows-1250'),
    (hash: $09FE6CC1; cp: 1251; name: 'windows-1251'),
    (hash: $09FE6CC2; cp: 1252; name: 'windows-1252'),
    (hash: $09FE6CC3; cp: 1253; name: 'windows-1253'),
    (hash: $09FE6CC4; cp: 1254; name: 'windows-1254'),
    (hash: $09FE6CC5; cp: 1255; name: 'windows-1255'),
    (hash: $09FE6CC6; cp: 1256; name: 'windows-1256'),
    (hash: $09FE6CC7; cp: 1257; name: 'windows-1257'),
    (hash: $09FE6CC8; cp: 1258; name: 'windows-1258'),
    (hash: $0A196127; cp: 949; name: 'ks_c_5601-1987'),
    (hash: $0A196129; cp: 949; name: 'ks_c_5601-1989'),
    (hash: $0A22B993; cp: 28596; name: 'csisolatinarabic'),
    (hash: $0A2D83D5; cp: 1200; name: 'unicode'),
    (hash: $0A6B6127; cp: 949; name: 'ks_c_5601_1987'),
    (hash: $0A835A13; cp: 28595; name: 'csisolatincyrillic'),
    (hash: $0A8D99E7; cp: 28598; name: 'csisolatinhebrew'),
    (hash: $0AF1E70E; cp: 20108; name: 'x-ia5-norwegian'),
    (hash: $0B2DF3F2; cp: 1200; name: 'iso-10646-ucs-2'),
    (hash: $0B548B52; cp: 52936; name: 'hz-gb-2312'),
    (hash: $0B54B320; cp: 54936; name: 'gb18030'),
    (hash: $0B84A337; cp: 65000; name: 'x-unicode-2-0-utf-7'),
    (hash: $0B84A338; cp: 65001; name: 'x-unicode-2-0-utf-8'),
    (hash: $0BB469EF; cp: 1140; name: 'ebcdic-us-37+euro'),
    (hash: $0BD40277; cp: 50225; name: 'iso-2022-kr-7'),
    (hash: $0BD40278; cp: 51949; name: 'iso-2022-kr-8'),
    (hash: $0BD48170; cp: 936; name: 'csiso58gb231280'),
    (hash: $0BF64240; cp: 28600; name: 'iso-8859-10'),
    (hash: $0BF64241; cp: 874; name: 'iso-8859-11'),
    (hash: $0BF64243; cp: 28603; name: 'iso-8859-13'),
    (hash: $0BF64244; cp: 28604; name: 'iso-8859-14'),
    (hash: $0BF64245; cp: 28605; name: 'iso-8859-15'),
    (hash: $0BF64246; cp: 28606; name: 'iso-8859-16'),
    (hash: $0BF64565; cp: 28605; name: 'iso_8859-15'),
    (hash: $0C367B24; cp: 10002; name: 'x-mac-chinesetrad'),
    (hash: $0C369150; cp: 10008; name: 'x-mac-chinesesimp'),
    (hash: $0C7974E3; cp: 10007; name: 'x-mac-cyrillic'),
    (hash: $0C84A837; cp: 65000; name: 'x-unicode-1-1-utf-7'),
    (hash: $0C84A838; cp: 65001; name: 'x-unicode-1-1-utf-8'),
    (hash: $0CDF0693; cp: 932; name: 'csshiftjis'),
    (hash: $0D3F1D23; cp: 51932; name: 'iso-2022-jpeuc'),
    (hash: $0D4F7882; cp: 20107; name: 'sen_850200_b'),
    (hash: $0D700B26; cp: 1026; name: 'csibm1026'),
    (hash: $0D704316; cp: 1026; name: 'ibm1026'),
    (hash: $0D72C429; cp: 20838; name: 'csibmthai'),
    (hash: $0D773C00; cp: 1140; name: 'ccsid01140'),
    (hash: $0D773C01; cp: 1141; name: 'ccsid01141'),
    (hash: $0D773C02; cp: 1142; name: 'ccsid01142'),
    (hash: $0D773C03; cp: 1143; name: 'ccsid01143'),
    (hash: $0D773C04; cp: 1144; name: 'ccsid01144'),
    (hash: $0D773C05; cp: 1145; name: 'ccsid01145'),
    (hash: $0D773C06; cp: 1146; name: 'ccsid01146'),
    (hash: $0D773C07; cp: 1147; name: 'ccsid01147'),
    (hash: $0D773C08; cp: 1148; name: 'ccsid01148'),
    (hash: $0D773C09; cp: 1149; name: 'ccsid01149'),
    (hash: $0D7743F8; cp: 858; name: 'ccsid00858'),
    (hash: $0D774424; cp: 20924; name: 'ccsid00924'),
    (hash: $0DB74923; cp: 932; name: 'shift-jis'),
    (hash: $0DBA6923; cp: 932; name: 'shift_jis'),
    (hash: $0DC4D87A; cp: 932; name: 'cswindows31j'),
    (hash: $0E12E2EF; cp: 1147; name: 'ebcdic-fr-297+euro'),
    (hash: $0E373294; cp: 20833; name: 'x-ebcdic-koreanextended'),
    (hash: $0E58CBFC; cp: 28598; name: 'iso-8859-8 visual'),
    (hash: $0E6E1453; cp: 28595; name: 'cyrillic'),
    (hash: $0F642BA9; cp: 38598; name: 'iso-8859-8-i')
);

type
  TCodePageEntry = record
    cp: TSystemCodePage;
    name: PAnsiChar;
  end;
const
  { this array contains only one name for one codepage. 
    it is stored in codepage order and is used to search
    a codepage name by codepage number }
  CodePageNames: array[0..155] of TCodePageEntry = (
    (cp: 37; name: 'ibm037'),
    (cp: 437; name: 'ibm437'),
    (cp: 500; name: 'IBM500'),
    (cp: 708; name: 'asmo-708'),
    (cp: 720; name: 'DOS-720'),
    (cp: 737; name: 'ibm737'),
    (cp: 775; name: 'ibm775'),
    (cp: 850; name: 'ibm850'),
    (cp: 852; name: 'ibm852'),
    (cp: 855; name: 'IBM855'),
    (cp: 856; name: 'cp856'),
    (cp: 857; name: 'ibm857'),
    (cp: 858; name: 'ibm00858'),
    (cp: 860; name: 'IBM860'),
    (cp: 861; name: 'ibm861'),
    (cp: 862; name: 'DOS-862'),
    (cp: 863; name: 'IBM863'),
    (cp: 864; name: 'IBM864'),
    (cp: 865; name: 'IBM865'),
    (cp: 866; name: 'cp866'),
    (cp: 869; name: 'ibm869'),
    (cp: 870; name: 'IBM870'),
    (cp: 874; name: 'windows-874'),
    (cp: 875; name: 'cp875'),
    (cp: 932; name: 'shift_jis'),
    (cp: 936; name: 'gb2312'),
    (cp: 949; name: 'ks_c_5601-1987'),
    (cp: 950; name: 'big5'),
    (cp: 1026; name: 'ibm1026'),
    (cp: 1047; name: 'ibm01047'),
    (cp: 1140; name: 'ibm01140'),
    (cp: 1141; name: 'IBM01141'),
    (cp: 1142; name: 'IBM01142'),
    (cp: 1143; name: 'IBM01143'),
    (cp: 1144; name: 'IBM01144'),
    (cp: 1145; name: 'ibm01145'),
    (cp: 1146; name: 'ibm01146'),
    (cp: 1147; name: 'ibm01147'),
    (cp: 1148; name: 'IBM01148'),
    (cp: 1149; name: 'IBM01149'),
    (cp: 1200; name: 'utf-16'),
    (cp: 1201; name: 'unicodefffe'),
    (cp: 1250; name: 'windows-1250'),
    (cp: 1251; name: 'windows-1251'),
    (cp: 1252; name: 'windows-1252'),
    (cp: 1253; name: 'windows-1253'),
    (cp: 1254; name: 'windows-1254'),
    (cp: 1255; name: 'windows-1255'),
    (cp: 1256; name: 'windows-1256'),
    (cp: 1257; name: 'windows-1257'),
    (cp: 1258; name: 'windows-1258'),
    (cp: 1361; name: 'Johab'),
    (cp: 3021; name: 'MIK'),
    (cp: 10000; name: 'macintosh'),
    (cp: 10001; name: 'x-mac-japanese'),
    (cp: 10002; name: 'x-mac-chinesetrad'),
    (cp: 10003; name: 'x-mac-korean'),
    (cp: 10004; name: 'x-mac-arabic'),
    (cp: 10005; name: 'x-mac-hebrew'),
    (cp: 10006; name: 'x-mac-greek'),
    (cp: 10007; name: 'x-mac-cyrillic'),
    (cp: 10008; name: 'x-mac-chinesesimp'),
    (cp: 10010; name: 'x-mac-romanian'),
    (cp: 10017; name: 'x-mac-ukrainian'),
    (cp: 10021; name: 'x-mac-thai'),
    (cp: 10029; name: 'x-mac-ce'),
    (cp: 10079; name: 'x-mac-icelandic'),
    (cp: 10081; name: 'x-mac-turkish'),
    (cp: 10082; name: 'x-mac-croatian'),
    (cp: 12000; name: 'utf-32'),
    (cp: 12001; name: 'utf-32BE'),
    (cp: 20000; name: 'x-Chinese_CNS'),
    (cp: 20000; name: 'x-chinese-cns'),
    (cp: 20001; name: 'x-cp20001'),
    (cp: 20002; name: 'x_Chinese-Eten'),
    (cp: 20002; name: 'x-chinese-eten'),
    (cp: 20003; name: 'x-cp20003'),
    (cp: 20004; name: 'x-cp20004'),
    (cp: 20005; name: 'x-cp20005'),
    (cp: 20105; name: 'x-IA5'),
    (cp: 20106; name: 'x-ia5-german'),
    (cp: 20107; name: 'x-IA5-Swedish'),
    (cp: 20108; name: 'x-IA5-Norwegian'),
    (cp: 20127; name: 'us-ascii'),
    (cp: 20261; name: 'x-cp20261'),
    (cp: 20269; name: 'x-cp20269'),
    (cp: 20273; name: 'ibm273'),
    (cp: 20277; name: 'ibm277'),
    (cp: 20278; name: 'ibm278'),
    (cp: 20280; name: 'ibm280'),
    (cp: 20284; name: 'ibm284'),
    (cp: 20285; name: 'IBM285'),
    (cp: 20290; name: 'IBM290'),
    (cp: 20297; name: 'IBM297'),
    (cp: 20420; name: 'ibm420'),
    (cp: 20423; name: 'ibm423'),
    (cp: 20424; name: 'IBM424'),
    (cp: 20833; name: 'x-EBCDIC-KoreanExtended'),
    (cp: 20838; name: 'ibm-thai'),
    (cp: 20866; name: 'koi8-r'),
    (cp: 20871; name: 'ibm871'),
    (cp: 20880; name: 'ibm880'),
    (cp: 20905; name: 'ibm905'),
    (cp: 20924; name: 'IBM00924'),
    (cp: 20932; name: 'EUC-JP'),
    (cp: 20936; name: 'x-cp20936'),
    (cp: 20949; name: 'x-cp20949'),
    (cp: 21025; name: 'cp1025'),
    (cp: 21027; name: 'x-cp21027'),
    (cp: 21866; name: 'koi8-u'),
    (cp: 28591; name: 'iso-8859-1'),
    (cp: 28592; name: 'iso-8859-2'),
    (cp: 28593; name: 'iso-8859-3'),
    (cp: 28594; name: 'iso-8859-4'),
    (cp: 28595; name: 'iso-8859-5'),
    (cp: 28596; name: 'iso-8859-6'),
    (cp: 28597; name: 'iso-8859-7'),
    (cp: 28598; name: 'iso-8859-8'),
    (cp: 28599; name: 'iso-8859-9'),
    (cp: 28600; name: 'iso-8859-10'),
    (cp: 28601; name: 'iso-8859-11'),
    (cp: 28603; name: 'iso-8859-13'),
    (cp: 28604; name: 'iso-8859-14'),
    (cp: 28605; name: 'iso-8859-15'),
    (cp: 28606; name: 'iso-8859-16'),
    (cp: 29001; name: 'x-Europa'),
    (cp: 38598; name: 'iso-8859-8-i'),
    (cp: 50220; name: 'iso-2022-jp'),
    (cp: 50221; name: 'csISO2022JP'),
    (cp: 50222; name: 'iso-2022-jp'),
    (cp: 50225; name: 'iso-2022-kr'),
    (cp: 50227; name: 'x-cp50227'),
    (cp: 50229; name: 'x-cp50229'),
    (cp: 50930; name: 'cp930'),
    (cp: 50931; name: 'x-ebcdic-japaneseanduscanada'),
    (cp: 50933; name: 'cp933'),
    (cp: 50935; name: 'cp935'),
    (cp: 50937; name: 'cp937'),
    (cp: 50939; name: 'cp939'),
    (cp: 51932; name: 'euc-jp'),
    (cp: 51936; name: 'euc-cn'),
    (cp: 51949; name: 'euc-kr'),
    (cp: 52936; name: 'hz-gb-2312'),
    (cp: 54936; name: 'gb18030'),
    (cp: 57002; name: 'x-iscii-de'),
    (cp: 57003; name: 'x-iscii-be'),
    (cp: 57004; name: 'x-iscii-ta'),
    (cp: 57005; name: 'x-iscii-te'),
    (cp: 57006; name: 'x-iscii-as'),
    (cp: 57007; name: 'x-iscii-or'),
    (cp: 57008; name: 'x-iscii-ka'),
    (cp: 57009; name: 'x-iscii-ma'),
    (cp: 57010; name: 'x-iscii-gu'),
    (cp: 57011; name: 'x-iscii-pa'),
    (cp: 65000; name: 'utf-7'),
    (cp: 65001; name: 'utf-8')
  );

function CodePageToCodePageName(cp: TSystemCodePage): AnsiString;
var
  FoundCp: TSystemCodePage;
  L, H, I: Integer;
begin
  L := Low(CodePageNames);
  H := High(CodePageNames);
  while L <= H do
  begin
    I := (L + H) shr 1;
    FoundCp := CodePageNames[I].cp;
    if FoundCp = cp then
    begin
      Exit(CodePageNames[I].name);
      Break;
    end;
    if cp > FoundCp then
      L := I + 1
    else
      H := I - 1;
  end;
  Result := '';
end;

function CodePageNameToCodePage(const cpname: AnsiString): TSystemCodePage;
var
  SearchName: AnsiString;
  SearchHash, FoundHash: LongWord;
  L, H, I: Integer;
begin
  SearchName := LowerCase(cpname);
  SearchHash := HashName(PAnsiChar(SearchName));
  L := Low(CodePageHashes);
  H := High(CodePageHashes);
  while L <= H do
  begin
    I := (L + H) shr 1;
    FoundHash := CodePageHashes[I].hash;
    if FoundHash = SearchHash then
    begin
      // search down since hashes can repeat in table
      while (I > Low(CodePageHashes)) and (CodePageHashes[Pred(I)].hash = FoundHash) do
        Dec(I);
      while (I <= High(CodePageHashes)) and (CodePageHashes[I].hash = FoundHash) do
      begin
        if SearchName = CodePageHashes[I].name then
          Exit(CodePageHashes[I].cp);
        Inc(I);
      end;
      Break;
    end;
    if SearchHash > FoundHash then
      L := I + 1
    else
      H := I - 1;
  end;
  Result := $FFFF;
end;
