{
    This file is part of the Free Pascal run time library.
    Copyright (c) 2017 by Michael Van Canneyt
    member of the Free Pascal development team.

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    Original copyright statement follows.
}
{
  Copyright (c) Microsoft Corporation. All rights reserved.

  Module Name:

      winhttp.h

  Abstract:

      Contains manifests, macros, types and prototypes for Windows HTTP Services

}	
{$IFNDEF FPC_DOTTEDUNITS}
unit WinHTTP;
{$ENDIF FPC_DOTTEDUNITS}

interface

{$IFDEF FPC_DOTTEDUNITS}
uses WinApi.Windows;
{$ELSE FPC_DOTTEDUNITS}
uses Windows;
{$ENDIF FPC_DOTTEDUNITS}

{
  Automatically converted by H2Pas 1.0.0 from winhttp.h
  The following command line parameters were used:
    -D
    -w
    -S
    -l
    winhttp.dll
    winhttp.h
}

const
  External_library='winhttp.dll'; {Setup as you need}

{$IFDEF FPC}
  {$PACKRECORDS C}
{$ENDIF}

type
  PLPVOID = ^LPVOID;
  LPUSHORT = ^USHORT;
  

const
  INTERNET_DEFAULT_PORT = 0;
  INTERNET_DEFAULT_HTTP_PORT = 80;
  INTERNET_DEFAULT_HTTPS_PORT = 443;
  WINHTTP_FLAG_ASYNC = $10000000;
  WINHTTP_FLAG_SECURE = $00800000;
  WINHTTP_FLAG_ESCAPE_PERCENT = $00000004;
  WINHTTP_FLAG_NULL_CODEPAGE = $00000008;
  WINHTTP_FLAG_BYPASS_PROXY_CACHE = $00000100;
  WINHTTP_FLAG_REFRESH = WINHTTP_FLAG_BYPASS_PROXY_CACHE;
  WINHTTP_FLAG_ESCAPE_DISABLE = $00000040;
  WINHTTP_FLAG_ESCAPE_DISABLE_QUERY = $00000080;
  SECURITY_FLAG_IGNORE_UNKNOWN_CA = $00000100;
  SECURITY_FLAG_IGNORE_CERT_DATE_INVALID = $00002000;
  SECURITY_FLAG_IGNORE_CERT_CN_INVALID = $00001000;
  SECURITY_FLAG_IGNORE_CERT_WRONG_USAGE = $00000200;

  INTERNET_SCHEME_HTTP = 1;
  INTERNET_SCHEME_HTTPS = 2;
  INTERNET_SCHEME_FTP = 3;
  INTERNET_SCHEME_SOCKS = 4;
  WINHTTP_AUTOPROXY_AUTO_DETECT = $00000001;
  WINHTTP_AUTOPROXY_CONFIG_URL = $00000002;
  WINHTTP_AUTOPROXY_HOST_KEEPCASE = $00000004;
  WINHTTP_AUTOPROXY_HOST_LOWERCASE = $00000008;
  WINHTTP_AUTOPROXY_ALLOW_AUTOCONFIG = $00000100;
  WINHTTP_AUTOPROXY_ALLOW_STATIC = $00000200;
  WINHTTP_AUTOPROXY_ALLOW_CM = $00000400;
  WINHTTP_AUTOPROXY_RUN_INPROCESS = $00010000;
  WINHTTP_AUTOPROXY_RUN_PROCESS_ONLY = $00020000;
  WINHTTP_AUTOPROXY_NO_DIRECTACCESS = $00040000;
  WINHTTP_AUTOPROXY_NO_CACHE_CLIENT = $00080000;
  WINHTTP_AUTOPROXY_NO_CACHE_SVC = $00100000;
  WINHTTP_AUTOPROXY_SORT_RESULTS = $00400000;
  WINHTTP_AUTO_DETECT_TYPE_DHCP = $00000001;
  WINHTTP_AUTO_DETECT_TYPE_DNS_A = $00000002;
  NETWORKING_KEY_BUFSIZE = 128;
  WINHTTP_TIME_FORMAT_BUFSIZE = 62;
  WINHTTP_OPTION_CALLBACK = 1;
  WINHTTP_FIRST_OPTION = WINHTTP_OPTION_CALLBACK;
  WINHTTP_OPTION_RESOLVE_TIME = 2;
  WINHTTP_OPTION_CONNECT_TIME = 3;
  WINHTTP_OPTION_CONNECT_RETRIES = 4;
  WINHTTP_OPTION_SEND_TIME = 5;
  WINHTTP_OPTION_RECEIVE_TIME = 6;
  WINHTTP_OPTION_RECEIVE_RESPONSE_TIME = 7;
  WINHTTP_OPTION_HANDLE_TYPE = 9;
  WINHTTP_OPTION_READ_BUFFER_SIZE = 12;
  WINHTTP_OPTION_WRITE_BUFFER_SIZE = 13;
  WINHTTP_OPTION_PARENT_HANDLE = 21;
  WINHTTP_OPTION_EXTENDED_ERROR = 24;
  WINHTTP_OPTION_SECURITY_FLAGS = 31;
  WINHTTP_OPTION_SECURITY_CERTIFICATE_STRUCT = 32;
  WINHTTP_OPTION_URL = 34;
  WINHTTP_OPTION_SECURITY_KEY_BITNESS = 36;
  WINHTTP_OPTION_PROXY = 38;
  WINHTTP_OPTION_PROXY_RESULT_ENTRY = 39;
  WINHTTP_OPTION_USER_AGENT = 41;
  WINHTTP_OPTION_CONTEXT_VALUE = 45;
  WINHTTP_OPTION_CLIENT_CERT_CONTEXT = 47;
  WINHTTP_OPTION_REQUEST_PRIORITY = 58;
  WINHTTP_OPTION_HTTP_VERSION = 59;
  WINHTTP_OPTION_DISABLE_FEATURE = 63;
  WINHTTP_OPTION_CODEPAGE = 68;
  WINHTTP_OPTION_MAX_CONNS_PER_SERVER = 73;
  WINHTTP_OPTION_MAX_CONNS_PER_1_0_SERVER = 74;
  WINHTTP_OPTION_AUTOLOGON_POLICY = 77;
  WINHTTP_OPTION_SERVER_CERT_CONTEXT = 78;
  WINHTTP_OPTION_ENABLE_FEATURE = 79;
  WINHTTP_OPTION_WORKER_THREAD_COUNT = 80;
  WINHTTP_OPTION_PASSPORT_COBRANDING_TEXT = 81;
  WINHTTP_OPTION_PASSPORT_COBRANDING_URL = 82;
  WINHTTP_OPTION_CONFIGURE_PASSPORT_AUTH = 83;
  WINHTTP_OPTION_SECURE_PROTOCOLS = 84;
  WINHTTP_OPTION_ENABLETRACING = 85;
  WINHTTP_OPTION_PASSPORT_SIGN_ = 86;
  WINHTTP_OPTION_PASSPORT_RETURN_URL = 87;
  WINHTTP_OPTION_REDIRECT_POLICY = 88;
  WINHTTP_OPTION_MAX_HTTP_AUTOMATIC_REDIRECTS = 89;
  WINHTTP_OPTION_MAX_HTTP_STATUS_CONTINUE = 90;
  WINHTTP_OPTION_MAX_RESPONSE_HEADER_SIZE = 91;
  WINHTTP_OPTION_MAX_RESPONSE_DRAIN_SIZE = 92;
  WINHTTP_OPTION_CONNECTION_INFO = 93;
  WINHTTP_OPTION_CLIENT_CERT_ISSUER_LIST = 94;
  WINHTTP_OPTION_SPN = 96;
  WINHTTP_OPTION_GLOBAL_PROXY_CREDS = 97;
  WINHTTP_OPTION_GLOBAL_SERVER_CREDS = 98;
  WINHTTP_OPTION_UNLOAD_NOTIFY_EVENT = 99;
  WINHTTP_OPTION_REJECT_USERPWD_IN_URL = 100;
  WINHTTP_OPTION_USE_GLOBAL_SERVER_CREDENTIALS = 101;
  WINHTTP_OPTION_RECEIVE_PROXY_CONNECT_RESPONSE = 103;
  WINHTTP_OPTION_IS_PROXY_CONNECT_RESPONSE = 104;
  WINHTTP_OPTION_SERVER_SPN_USED = 106;
  WINHTTP_OPTION_PROXY_SPN_USED = 107;
  WINHTTP_OPTION_SERVER_CBT = 108;
  WINHTTP_OPTION_UNSAFE_HEADER_PARSING = 110;
  WINHTTP_OPTION_ASSURED_NON_BLOCKING_CALLBACKS = 111;
  WINHTTP_OPTION_UPGRADE_TO_WEB_SOCKET = 114;
  WINHTTP_OPTION_WEB_SOCKET_CLOSE_TIME = 115;
  WINHTTP_OPTION_WEB_SOCKET_KEEPALIVE_INTERVAL = 116;
  WINHTTP_OPTION_DECOMPRESSION = 118;
  WINHTTP_OPTION_WEB_SOCKET_RECEIVE_BUFFER_SIZE = 122;
  WINHTTP_OPTION_WEB_SOCKET_SEND_BUFFER_SIZE = 123;
  WINHTTP_OPTION_CONNECTION_FILTER = 131;
  WINHTTP_OPTION_ENABLE_HTTP_PROTOCOL = 133;
  WINHTTP_OPTION_HTTP_PROTOCOL_USED = 134;
  WINHTTP_OPTION_KDC_PROXY_SETTINGS = 136;
  WINHTTP_LAST_OPTION = WINHTTP_OPTION_KDC_PROXY_SETTINGS;
  WINHTTP_OPTION_USERNAME = $1000;
  WINHTTP_OPTION_PASSWORD = $1001;
  WINHTTP_OPTION_PROXY_USERNAME = $1002;
  WINHTTP_OPTION_PROXY_PASSWORD = $1003;
  WINHTTP_CONNS_PER_SERVER_UNLIMITED = $FFFFFFFF;
  WINHTTP_DECOMPRESSION_FLAG_GZIP = $00000001;
  WINHTTP_DECOMPRESSION_FLAG_DEFLATE = $00000002;
  WINHTTP_DECOMPRESSION_FLAG_ALL = WINHTTP_DECOMPRESSION_FLAG_GZIP or WINHTTP_DECOMPRESSION_FLAG_DEFLATE;
  WINHTTP_PROTOCOL_FLAG_HTTP2 = $1;
  WINHTTP_PROTOCOL_MASK = WINHTTP_PROTOCOL_FLAG_HTTP2;
  WINHTTP_AUTOLOGON_SECURITY_LEVEL_MEDIUM = 0;
  WINHTTP_AUTOLOGON_SECURITY_LEVEL_LOW = 1;
  WINHTTP_AUTOLOGON_SECURITY_LEVEL_HIGH = 2;
  WINHTTP_AUTOLOGON_SECURITY_LEVEL_DEFAULT = WINHTTP_AUTOLOGON_SECURITY_LEVEL_MEDIUM;
  WINHTTP_OPTION_REDIRECT_POLICY_NEVER = 0;
  WINHTTP_OPTION_REDIRECT_POLICY_DISALLOW_HTTPS_TO_HTTP = 1;
  WINHTTP_OPTION_REDIRECT_POLICY_ALWAYS = 2;
  WINHTTP_OPTION_REDIRECT_POLICY_LAST = WINHTTP_OPTION_REDIRECT_POLICY_ALWAYS;
  WINHTTP_OPTION_REDIRECT_POLICY_DEFAULT = WINHTTP_OPTION_REDIRECT_POLICY_DISALLOW_HTTPS_TO_HTTP;
  WINHTTP_DISABLE_PASSPORT_AUTH = $00000000;
  WINHTTP_ENABLE_PASSPORT_AUTH = $10000000;
  WINHTTP_DISABLE_PASSPORT_KEYRING = $20000000;
  WINHTTP_ENABLE_PASSPORT_KEYRING = $40000000;
  WINHTTP_DISABLE_COOKIES = $00000001;
  WINHTTP_DISABLE_REDIRECTS = $00000002;
  WINHTTP_DISABLE_AUTHENTICATION = $00000004;
  WINHTTP_DISABLE_KEEP_ALIVE = $00000008;
  WINHTTP_ENABLE_SSL_REVOCATION = $00000001;
  WINHTTP_ENABLE_SSL_REVERT_IMPERSONATION = $00000002;
  WINHTTP_DISABLE_SPN_SERVER_PORT = $00000000;
  WINHTTP_ENABLE_SPN_SERVER_PORT = $00000001;
  WINHTTP_OPTION_SPN_MASK = WINHTTP_ENABLE_SPN_SERVER_PORT;


const
  WINHTTP_HANDLE_TYPE_SESSION = 1;
  WINHTTP_HANDLE_TYPE_CONNECT = 2;
  WINHTTP_HANDLE_TYPE_REQUEST = 3;
  WINHTTP_AUTH_SCHEME_BASIC = $00000001;
  WINHTTP_AUTH_SCHEME_NTLM = $00000002;
  WINHTTP_AUTH_SCHEME_PASSPORT = $00000004;
  WINHTTP_AUTH_SCHEME_DIGEST = $00000008;
  WINHTTP_AUTH_SCHEME_NEGOTIATE = $00000010;
  WINHTTP_AUTH_TARGET_SERVER = $00000000;
  WINHTTP_AUTH_TARGET_PROXY = $00000001;
  SECURITY_FLAG_SECURE = $00000001;
  SECURITY_FLAG_STRENGTH_WEAK = $10000000;
  SECURITY_FLAG_STRENGTH_MEDIUM = $40000000;
  SECURITY_FLAG_STRENGTH_STRONG = $20000000;
  WINHTTP_CALLBACK_STATUS_FLAG_CERT_REV_FAILED = $00000001;
  WINHTTP_CALLBACK_STATUS_FLAG_INVALID_CERT = $00000002;
  WINHTTP_CALLBACK_STATUS_FLAG_CERT_REVOKED = $00000004;
  WINHTTP_CALLBACK_STATUS_FLAG_INVALID_CA = $00000008;
  WINHTTP_CALLBACK_STATUS_FLAG_CERT_CN_INVALID = $00000010;
  WINHTTP_CALLBACK_STATUS_FLAG_CERT_DATE_INVALID = $00000020;
  WINHTTP_CALLBACK_STATUS_FLAG_CERT_WRONG_USAGE = $00000040;
  WINHTTP_CALLBACK_STATUS_FLAG_SECURITY_CHANNEL_ERROR = $80000000;
  WINHTTP_FLAG_SECURE_PROTOCOL_SSL2 = $00000008;
  WINHTTP_FLAG_SECURE_PROTOCOL_SSL3 = $00000020;
  WINHTTP_FLAG_SECURE_PROTOCOL_TLS1 = $00000080;
  WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_1 = $00000200;
  WINHTTP_FLAG_SECURE_PROTOCOL_TLS1_2 = $00000800;
  WINHTTP_FLAG_SECURE_PROTOCOL_ALL = (WINHTTP_FLAG_SECURE_PROTOCOL_SSL2 or WINHTTP_FLAG_SECURE_PROTOCOL_SSL3) or WINHTTP_FLAG_SECURE_PROTOCOL_TLS1;

  WINHTTP_CALLBACK_STATUS_RESOLVING_NAME = $00000001;
  WINHTTP_CALLBACK_STATUS_NAME_RESOLVED = $00000002;
  WINHTTP_CALLBACK_STATUS_CONNECTING_TO_SERVER = $00000004;
  WINHTTP_CALLBACK_STATUS_CONNECTED_TO_SERVER = $00000008;
  WINHTTP_CALLBACK_STATUS_SENDING_REQUEST = $00000010;
  WINHTTP_CALLBACK_STATUS_REQUEST_SENT = $00000020;
  WINHTTP_CALLBACK_STATUS_RECEIVING_RESPONSE = $00000040;
  WINHTTP_CALLBACK_STATUS_RESPONSE_RECEIVED = $00000080;
  WINHTTP_CALLBACK_STATUS_CLOSING_CONNECTION = $00000100;
  WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED = $00000200;
  WINHTTP_CALLBACK_STATUS_HANDLE_CREATED = $00000400;
  WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING = $00000800;
  WINHTTP_CALLBACK_STATUS_DETECTING_PROXY = $00001000;
  WINHTTP_CALLBACK_STATUS_REDIRECT = $00004000;
  WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE = $00008000;
  WINHTTP_CALLBACK_STATUS_SECURE_FAILURE = $00010000;
  WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE = $00020000;
  WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE = $00040000;
  WINHTTP_CALLBACK_STATUS_READ_COMPLETE = $00080000;
  WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE = $00100000;
  WINHTTP_CALLBACK_STATUS_REQUEST_ERROR = $00200000;
  WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE = $00400000;
  WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE = $01000000;
  WINHTTP_CALLBACK_STATUS_CLOSE_COMPLETE = $02000000;
  WINHTTP_CALLBACK_STATUS_SHUTDOWN_COMPLETE = $04000000;
  WINHTTP_CALLBACK_STATUS_SETTINGS_WRITE_COMPLETE = $10000000;
  WINHTTP_CALLBACK_STATUS_SETTINGS_READ_COMPLETE = $20000000;
  API_RECEIVE_RESPONSE = 1;
  API_QUERY_DATA_AVAILABLE = 2;
  API_READ_DATA = 3;
  API_WRITE_DATA = 4;
  API_SEND_REQUEST = 5;
  API_GET_PROXY_FOR_URL = 6;
  WINHTTP_CALLBACK_FLAG_RESOLVE_NAME = WINHTTP_CALLBACK_STATUS_RESOLVING_NAME or WINHTTP_CALLBACK_STATUS_NAME_RESOLVED;
  WINHTTP_CALLBACK_FLAG_CONNECT_TO_SERVER = WINHTTP_CALLBACK_STATUS_CONNECTING_TO_SERVER or WINHTTP_CALLBACK_STATUS_CONNECTED_TO_SERVER;
  WINHTTP_CALLBACK_FLAG_SEND_REQUEST = WINHTTP_CALLBACK_STATUS_SENDING_REQUEST or WINHTTP_CALLBACK_STATUS_REQUEST_SENT;
  WINHTTP_CALLBACK_FLAG_RECEIVE_RESPONSE = WINHTTP_CALLBACK_STATUS_RECEIVING_RESPONSE or WINHTTP_CALLBACK_STATUS_RESPONSE_RECEIVED;
  WINHTTP_CALLBACK_FLAG_CLOSE_CONNECTION = WINHTTP_CALLBACK_STATUS_CLOSING_CONNECTION or WINHTTP_CALLBACK_STATUS_CONNECTION_CLOSED;
  WINHTTP_CALLBACK_FLAG_HANDLES = WINHTTP_CALLBACK_STATUS_HANDLE_CREATED or WINHTTP_CALLBACK_STATUS_HANDLE_CLOSING;
  WINHTTP_CALLBACK_FLAG_DETECTING_PROXY = WINHTTP_CALLBACK_STATUS_DETECTING_PROXY;
  WINHTTP_CALLBACK_FLAG_REDIRECT = WINHTTP_CALLBACK_STATUS_REDIRECT;
  WINHTTP_CALLBACK_FLAG_INTERMEDIATE_RESPONSE = WINHTTP_CALLBACK_STATUS_INTERMEDIATE_RESPONSE;
  WINHTTP_CALLBACK_FLAG_SECURE_FAILURE = WINHTTP_CALLBACK_STATUS_SECURE_FAILURE;
  WINHTTP_CALLBACK_FLAG_SENDREQUEST_COMPLETE = WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE;
  WINHTTP_CALLBACK_FLAG_HEADERS_AVAILABLE = WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE;
  WINHTTP_CALLBACK_FLAG_DATA_AVAILABLE = WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE;
  WINHTTP_CALLBACK_FLAG_READ_COMPLETE = WINHTTP_CALLBACK_STATUS_READ_COMPLETE;
  WINHTTP_CALLBACK_FLAG_WRITE_COMPLETE = WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE;
  WINHTTP_CALLBACK_FLAG_REQUEST_ERROR = WINHTTP_CALLBACK_STATUS_REQUEST_ERROR;
  WINHTTP_CALLBACK_FLAG_GETPROXYFORURL_COMPLETE = WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE;
  WINHTTP_CALLBACK_FLAG_ALL_COMPLETIONS = (((((WINHTTP_CALLBACK_STATUS_SENDREQUEST_COMPLETE or WINHTTP_CALLBACK_STATUS_HEADERS_AVAILABLE) or WINHTTP_CALLBACK_STATUS_DATA_AVAILABLE) or WINHTTP_CALLBACK_STATUS_READ_COMPLETE) or WINHTTP_CALLBACK_STATUS_WRITE_COMPLETE) or WINHTTP_CALLBACK_STATUS_REQUEST_ERROR) or WINHTTP_CALLBACK_STATUS_GETPROXYFORURL_COMPLETE;
  WINHTTP_CALLBACK_FLAG_ALL_NOTIFICATIONS = $ffffffff;
  WINHTTP_QUERY_MIME_VERSION = 0;
  WINHTTP_QUERY_CONTENT_TYPE = 1;
  WINHTTP_QUERY_CONTENT_TRANSFER_ENCODING = 2;
  WINHTTP_QUERY_CONTENT_ID = 3;
  WINHTTP_QUERY_CONTENT_DESCRIPTION = 4;
  WINHTTP_QUERY_CONTENT_LENGTH = 5;
  WINHTTP_QUERY_CONTENT_LANGUAGE = 6;
  WINHTTP_QUERY_ALLOW = 7;
  WINHTTP_QUERY_PUBLIC = 8;
  WINHTTP_QUERY_DATE = 9;
  WINHTTP_QUERY_EXPIRES = 10;
  WINHTTP_QUERY_LAST_MODIFIED = 11;
  WINHTTP_QUERY_MESSAGE_ID = 12;
  WINHTTP_QUERY_URI = 13;
  WINHTTP_QUERY_DERIVED_FROM = 14;
  WINHTTP_QUERY_COST = 15;
  WINHTTP_QUERY_LINK = 16;
  WINHTTP_QUERY_PRAGMA = 17;
  WINHTTP_QUERY_VERSION = 18;
  WINHTTP_QUERY_STATUS_CODE = 19;
  WINHTTP_QUERY_STATUS_TEXT = 20;
  WINHTTP_QUERY_RAW_HEADERS = 21;
  WINHTTP_QUERY_RAW_HEADERS_CRLF = 22;
  WINHTTP_QUERY_CONNECTION = 23;
  WINHTTP_QUERY_ACCEPT = 24;
  WINHTTP_QUERY_ACCEPT_CHARSET = 25;
  WINHTTP_QUERY_ACCEPT_ENCODING = 26;
  WINHTTP_QUERY_ACCEPT_LANGUAGE = 27;
  WINHTTP_QUERY_AUTHORIZATION = 28;
  WINHTTP_QUERY_CONTENT_ENCODING = 29;
  WINHTTP_QUERY_FORWARDED = 30;
  WINHTTP_QUERY_FROM = 31;
  WINHTTP_QUERY_IF_MODIFIED_SINCE = 32;
  WINHTTP_QUERY_LOCATION = 33;
  WINHTTP_QUERY_ORIG_URI = 34;
  WINHTTP_QUERY_REFERER = 35;
  WINHTTP_QUERY_RETRY_AFTER = 36;
  WINHTTP_QUERY_SERVER = 37;
  WINHTTP_QUERY_TITLE = 38;
  WINHTTP_QUERY_USER_AGENT = 39;
  WINHTTP_QUERY_WWW_AUTHENTICATE = 40;
  WINHTTP_QUERY_PROXY_AUTHENTICATE = 41;
  WINHTTP_QUERY_ACCEPT_RANGES = 42;
  WINHTTP_QUERY_SET_COOKIE = 43;
  WINHTTP_QUERY_COOKIE = 44;
  WINHTTP_QUERY_REQUEST_METHOD = 45;
  WINHTTP_QUERY_REFRESH = 46;
  WINHTTP_QUERY_CONTENT_DISPOSITION = 47;
  WINHTTP_QUERY_AGE = 48;
  WINHTTP_QUERY_CACHE_CONTROL = 49;
  WINHTTP_QUERY_CONTENT_BASE = 50;
  WINHTTP_QUERY_CONTENT_LOCATION = 51;
  WINHTTP_QUERY_CONTENT_MD5 = 52;
  WINHTTP_QUERY_CONTENT_RANGE = 53;
  WINHTTP_QUERY_ETAG = 54;
  WINHTTP_QUERY_HOST = 55;
  WINHTTP_QUERY_IF_MATCH = 56;
  WINHTTP_QUERY_IF_NONE_MATCH = 57;
  WINHTTP_QUERY_IF_RANGE = 58;
  WINHTTP_QUERY_IF_UNMODIFIED_SINCE = 59;
  WINHTTP_QUERY_MAX_FORWARDS = 60;
  WINHTTP_QUERY_PROXY_AUTHORIZATION = 61;
  WINHTTP_QUERY_RANGE = 62;
  WINHTTP_QUERY_TRANSFER_ENCODING = 63;
  WINHTTP_QUERY_UPGRADE = 64;
  WINHTTP_QUERY_VARY = 65;
  WINHTTP_QUERY_VIA = 66;
  WINHTTP_QUERY_WARNING = 67;
  WINHTTP_QUERY_EXPECT = 68;
  WINHTTP_QUERY_PROXY_CONNECTION = 69;
  WINHTTP_QUERY_UNLESS_MODIFIED_SINCE = 70;
  WINHTTP_QUERY_PROXY_SUPPORT = 75;
  WINHTTP_QUERY_AUTHENTICATION_INFO = 76;
  WINHTTP_QUERY_PASSPORT_URLS = 77;
  WINHTTP_QUERY_PASSPORT_CONFIG = 78;
  WINHTTP_QUERY_MAX = 78;
  WINHTTP_QUERY_CUSTOM = 65535;
  WINHTTP_QUERY_FLAG_REQUEST_HEADERS = $80000000;
  WINHTTP_QUERY_FLAG_SYSTEMTIME = $40000000;
  WINHTTP_QUERY_FLAG_NUMBER = $20000000;
  WINHTTP_QUERY_FLAG_NUMBER64 = $08000000;
  HTTP_STATUS_CONTINUE = 100;
  HTTP_STATUS_SWITCH_PROTOCOLS = 101;
  HTTP_STATUS_OK = 200;
  HTTP_STATUS_CREATED = 201;
  HTTP_STATUS_ACCEPTED = 202;
  HTTP_STATUS_PARTIAL = 203;
  HTTP_STATUS_NO_CONTENT = 204;
  HTTP_STATUS_RESET_CONTENT = 205;
  HTTP_STATUS_PARTIAL_CONTENT = 206;
  HTTP_STATUS_WEBDAV_MULTI_STATUS = 207;
  HTTP_STATUS_AMBIGUOUS = 300;
  HTTP_STATUS_MOVED = 301;
  HTTP_STATUS_REDIRECT = 302;
  HTTP_STATUS_REDIRECT_METHOD = 303;
  HTTP_STATUS_NOT_MODIFIED = 304;
  HTTP_STATUS_USE_PROXY = 305;
  HTTP_STATUS_REDIRECT_KEEP_VERB = 307;
  HTTP_STATUS_PERMANENT_REDIRECT = 308;
  HTTP_STATUS_BAD_REQUEST = 400;
  HTTP_STATUS_DENIED = 401;
  HTTP_STATUS_PAYMENT_REQ = 402;
  HTTP_STATUS_FORBIDDEN = 403;
  HTTP_STATUS_NOT_FOUND = 404;
  HTTP_STATUS_BAD_METHOD = 405;
  HTTP_STATUS_NONE_ACCEPTABLE = 406;
  HTTP_STATUS_PROXY_AUTH_REQ = 407;
  HTTP_STATUS_REQUEST_TIME = 408;
  HTTP_STATUS_CONFLICT = 409;
  HTTP_STATUS_GONE = 410;
  HTTP_STATUS_LENGTH_REQUIRED = 411;
  HTTP_STATUS_PRECOND_FAILED = 412;
  HTTP_STATUS_REQUEST_TOO_LARGE = 413;
  HTTP_STATUS_URI_TOO_LONG = 414;
  HTTP_STATUS_UNSUPPORTED_MEDIA = 415;
  HTTP_STATUS_RETRY_WITH = 449;
  HTTP_STATUS_SERVER_ERROR = 500;
  HTTP_STATUS_NOT_SUPPORTED = 501;
  HTTP_STATUS_BAD_GATEWAY = 502;
  HTTP_STATUS_SERVICE_UNAVAIL = 503;
  HTTP_STATUS_GATEWAY_TIME = 504;
  HTTP_STATUS_VERSION_NOT_SUP = 505;
  HTTP_STATUS_FIRST = HTTP_STATUS_CONTINUE;
  HTTP_STATUS_LAST = HTTP_STATUS_VERSION_NOT_SUP;
  ICU_NO_ENCODE = $20000000;
  ICU_DECODE = $10000000;
  ICU_NO_META = $08000000;
  ICU_ENCODE_SPACES_ONLY = $04000000;
  ICU_BROWSER_MODE = $02000000;
  ICU_ENCODE_PERCENT = $00001000;
  ICU_ESCAPE = $80000000;
  ICU_ESCAPE_AUTHORITY = $00002000;
  ICU_REJECT_USERPWD = $00004000;
  WINHTTP_ACCESS_TYPE_DEFAULT_PROXY = 0;
  WINHTTP_ACCESS_TYPE_NO_PROXY = 1;
  WINHTTP_ACCESS_TYPE_NAMED_PROXY = 3;
  WINHTTP_ACCESS_TYPE_AUTOMATIC_PROXY = 4;
  WINHTTP_NO_PROXY_NAME = Nil;
  WINHTTP_NO_PROXY_BYPASS = Nil;
  WINHTTP_NO_CLIENT_CERT_CONTEXT = Nil;
  WINHTTP_NO_REFERER = Nil;
  WINHTTP_DEFAULT_ACCEPT_TYPES = Nil;
  WINHTTP_ADDREQ_INDEX_MASK = $0000FFFF;
  WINHTTP_ADDREQ_FLAGS_MASK = $FFFF0000;
  WINHTTP_ADDREQ_FLAG_ADD_IF_NEW = $10000000;
  WINHTTP_ADDREQ_FLAG_ADD = $20000000;
  WINHTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA = $40000000;
  WINHTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON = $01000000;
  WINHTTP_ADDREQ_FLAG_COALESCE = WINHTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA;
  WINHTTP_ADDREQ_FLAG_REPLACE = $80000000;
  WINHTTP_IGNORE_REQUEST_TOTAL_LENGTH = 0;
  WINHTTP_NO_ADDITIONAL_HEADERS = Nil;
  WINHTTP_NO_REQUEST_DATA = Nil;
  WINHTTP_HEADER_NAME_BY_INDEX = Nil;
  WINHTTP_NO_PUT_BUFFER = Nil;
  WINHTTP_ERROR_BASE = 12000;
  ERROR_WINHTTPOF_HANDLES = WINHTTP_ERROR_BASE+1;
  ERROR_WINHTTP_TIME = WINHTTP_ERROR_BASE+2;
  ERROR_WINHTTP_INTERNAL_ERROR = WINHTTP_ERROR_BASE+4;
  ERROR_WINHTTP_INVALID_URL = WINHTTP_ERROR_BASE+5;
  ERROR_WINHTTP_UNRECOGNIZED_SCHEME = WINHTTP_ERROR_BASE+6;
  ERROR_WINHTTP_NAME_NOT_RESOLVED = WINHTTP_ERROR_BASE+7;
  ERROR_WINHTTP_INVALID_OPTION = WINHTTP_ERROR_BASE+9;
  ERROR_WINHTTP_OPTION_NOT_SETTABLE = WINHTTP_ERROR_BASE+11;
  ERROR_WINHTTP_SHUTDOWN = WINHTTP_ERROR_BASE+12;
  ERROR_WINHTTP_LOGIN_FAILURE = WINHTTP_ERROR_BASE+15;
  ERROR_WINHTTP_OPERATION_CANCELLED = WINHTTP_ERROR_BASE+17;
  ERROR_WINHTTP_INCORRECT_HANDLE_TYPE = WINHTTP_ERROR_BASE+18;
  ERROR_WINHTTP_INCORRECT_HANDLE_STATE = WINHTTP_ERROR_BASE+19;
  ERROR_WINHTTP_CANNOT_CONNECT = WINHTTP_ERROR_BASE+29;
  ERROR_WINHTTP_CONNECTION_ERROR = WINHTTP_ERROR_BASE+30;
  ERROR_WINHTTP_RESEND_REQUEST = WINHTTP_ERROR_BASE+32;
  ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED = WINHTTP_ERROR_BASE+44;
  ERROR_WINHTTP_CANNOT_CALL_BEFORE_OPEN = WINHTTP_ERROR_BASE+100;
  ERROR_WINHTTP_CANNOT_CALL_BEFORE_SEND = WINHTTP_ERROR_BASE+101;
  ERROR_WINHTTP_CANNOT_CALL_AFTER_SEND = WINHTTP_ERROR_BASE+102;
  ERROR_WINHTTP_CANNOT_CALL_AFTER_OPEN = WINHTTP_ERROR_BASE+103;
  ERROR_WINHTTP_HEADER_NOT_FOUND = WINHTTP_ERROR_BASE+150;
  ERROR_WINHTTP_INVALID_SERVER_RESPONSE = WINHTTP_ERROR_BASE+152;
  ERROR_WINHTTP_INVALID_HEADER = WINHTTP_ERROR_BASE+153;
  ERROR_WINHTTP_INVALID_QUERY_REQUEST = WINHTTP_ERROR_BASE+154;
  ERROR_WINHTTP_HEADER_ALREADY_EXISTS = WINHTTP_ERROR_BASE+155;
  ERROR_WINHTTP_REDIRECT_FAILED = WINHTTP_ERROR_BASE+156;
  ERROR_WINHTTP_AUTO_PROXY_SERVICE_ERROR = WINHTTP_ERROR_BASE+178;
  ERROR_WINHTTP_BAD_AUTO_PROXY_SCRIPT = WINHTTP_ERROR_BASE+166;
  ERROR_WINHTTP_UNABLE_TO_DOWNLOAD_SCRIPT = WINHTTP_ERROR_BASE+167;
  ERROR_WINHTTP_UNHANDLED_SCRIPT_TYPE = WINHTTP_ERROR_BASE+176;
  ERROR_WINHTTP_SCRIPT_EXECUTION_ERROR = WINHTTP_ERROR_BASE+177;
  ERROR_WINHTTP_NOT_INITIALIZED = WINHTTP_ERROR_BASE+172;
  ERROR_WINHTTP_SECURE_FAILURE = WINHTTP_ERROR_BASE+175;
  ERROR_WINHTTP_SECURE_CERT_DATE_INVALID = WINHTTP_ERROR_BASE+37;
  ERROR_WINHTTP_SECURE_CERT_CN_INVALID = WINHTTP_ERROR_BASE+38;
  ERROR_WINHTTP_SECURE_INVALID_CA = WINHTTP_ERROR_BASE+45;
  ERROR_WINHTTP_SECURE_CERT_REV_FAILED = WINHTTP_ERROR_BASE+57;
  ERROR_WINHTTP_SECURE_CHANNEL_ERROR = WINHTTP_ERROR_BASE+157;
  ERROR_WINHTTP_SECURE_INVALID_CERT = WINHTTP_ERROR_BASE+169;
  ERROR_WINHTTP_SECURE_CERT_REVOKED = WINHTTP_ERROR_BASE+170;
  ERROR_WINHTTP_SECURE_CERT_WRONG_USAGE = WINHTTP_ERROR_BASE+179;
  ERROR_WINHTTP_AUTODETECTION_FAILED = WINHTTP_ERROR_BASE+180;
  ERROR_WINHTTP_HEADER_COUNT_EXCEEDED = WINHTTP_ERROR_BASE+181;
  ERROR_WINHTTP_HEADER_SIZE_OVERFLOW = WINHTTP_ERROR_BASE+182;
  ERROR_WINHTTP_CHUNKED_ENCODING_HEADER_SIZE_OVERFLOW = WINHTTP_ERROR_BASE+183;
  ERROR_WINHTTP_RESPONSE_DRAIN_OVERFLOW = WINHTTP_ERROR_BASE+184;
  ERROR_WINHTTP_CLIENT_CERT_NO_PRIVATE_KEY = WINHTTP_ERROR_BASE+185;
  ERROR_WINHTTP_CLIENT_CERT_NO_ACCESS_PRIVATE_KEY = WINHTTP_ERROR_BASE+186;
  ERROR_WINHTTP_CLIENT_AUTH_CERT_NEEDED_PROXY = WINHTTP_ERROR_BASE+187;
  ERROR_WINHTTP_SECURE_FAILURE_PROXY = WINHTTP_ERROR_BASE+188;
  WINHTTP_ERROR_LAST = WINHTTP_ERROR_BASE+188;
  WINHTTP_RESET_STATE = $00000001;
  WINHTTP_RESET_SWPAD_CURRENT_NETWORK = $00000002;
  WINHTTP_RESET_SWPAD_ALL = $00000004;
  WINHTTP_RESET_SCRIPT_CACHE = $00000008;
  WINHTTP_RESET_ALL = $0000FFFF;
  WINHTTP_RESET_NOTIFY_NETWORK_CHANGED = $00010000;
  WINHTTP_RESETOF_PROC = $00020000;
  WINHTTP_NO_HEADER_INDEX = Nil;
  WINHTTP_WEB_SOCKET_MAX_CLOSE_REASON_LENGTH = 123;
  WINHTTP_WEB_SOCKET_MIN_KEEPALIVE_VALUE = 15000;

type
  HINTERNET = LPVOID;
  LPHINTERNET = ^HINTERNET;
  PHINTERNET = ^HINTERNET;
   
  INTERNET_PORT = WORD;
  LPINTERNET_PORT = ^INTERNET_PORT;
  WINHTTP_ASYNC_RESULT = record
    dwResult : DWORD_PTR;
    dwError : DWORD;
  end;
  LPWINHTTP_ASYNC_RESULT = ^WINHTTP_ASYNC_RESULT;

  HTTP_VERSION_INFO = record
    dwMajorVersion : DWORD;
    dwMinorVersion : DWORD;
  end;
  LPHTTP_VERSION_INFO = ^HTTP_VERSION_INFO;

  INTERNET_SCHEME = longint;
  LPINTERNET_SCHEME = ^INTERNET_SCHEME;

  URL_COMPONENTS = record
    dwStructSize : DWORD;
    lpszScheme : LPWSTR;
    dwSchemeLength : DWORD;
    nScheme : INTERNET_SCHEME;
    lpszHostName : LPWSTR;
    dwHostNameLength : DWORD;
    nPort : INTERNET_PORT;
    lpszUserName : LPWSTR;
    dwUserNameLength : DWORD;
    lpszPassword : LPWSTR;
    dwPasswordLength : DWORD;
    lpszUrlPath : LPWSTR;
    dwUrlPathLength : DWORD;
    lpszExtraInfo : LPWSTR;
    dwExtraInfoLength : DWORD;
  end;
  LPURL_COMPONENTS = ^URL_COMPONENTS;

  URL_COMPONENTSW = URL_COMPONENTS;

  LPURL_COMPONENTSW = LPURL_COMPONENTS;

  WINHTTP_PROXY_INFO = record
    dwAccessType : DWORD;
    lpszProxy : LPWSTR;
    lpszProxyBypass : LPWSTR;
  end;
  LPWINHTTP_PROXY_INFO = ^WINHTTP_PROXY_INFO;
  PWINHTTP_PROXY_INFO = LPWINHTTP_PROXY_INFO;

  WINHTTP_PROXY_INFOW = WINHTTP_PROXY_INFO;
  LPWINHTTP_PROXY_INFOW = LPWINHTTP_PROXY_INFO;

  WINHTTP_AUTOPROXY_OPTIONS = record
    dwFlags : DWORD;
    dwAutoDetectFlags : DWORD;
    lpszAutoConfigUrl : LPCWSTR;
    lpvReserved : LPVOID;
    dwReserved : DWORD;
    fAutoLogonIfChallenged : BOOL;
  end;
  PWINHTTP_AUTOPROXY_OPTIONS = ^WINHTTP_AUTOPROXY_OPTIONS;


  _WINHTTP_PROXY_RESULT_ENTRY = record
    fProxy : BOOL;
    fBypass : BOOL;
    ProxyScheme : INTERNET_SCHEME;
    pwszProxy : PWSTR;
    ProxyPort : INTERNET_PORT;
  end;
  WINHTTP_PROXY_RESULT_ENTRY = _WINHTTP_PROXY_RESULT_ENTRY;
  PWINHTTP_PROXY_RESULT_ENTRY = ^WINHTTP_PROXY_RESULT_ENTRY;
    
  _WINHTTP_PROXY_RESULT = record
    cEntries : DWORD;
    pEntries : ^WINHTTP_PROXY_RESULT_ENTRY;
  end;
  WINHTTP_PROXY_RESULT = _WINHTTP_PROXY_RESULT;
  PWINHTTP_PROXY_RESULT = ^WINHTTP_PROXY_RESULT;
    
  _WINHTTP_PROXY_RESULT_EX = record
    cEntries : DWORD;
    pEntries : ^WINHTTP_PROXY_RESULT_ENTRY;
    hProxyDetectionHandle : HANDLE;
    dwProxyInterfaceAffinity : DWORD;
  end;
  WINHTTP_PROXY_RESULT_EX = _WINHTTP_PROXY_RESULT_EX;
  PWINHTTP_PROXY_RESULT_EX = ^WINHTTP_PROXY_RESULT_EX;
    
  _WinHttpProxyNetworkKey = record
    pbBuffer : array[0..(NETWORKING_KEY_BUFSIZE)-1] of byte;
  end;
  WINHTTP_PROXY_NETWORKING_KEY = _WinHttpProxyNetworkKey;
  PWINHTTP_PROXY_NETWORKING_KEY = ^_WinHttpProxyNetworkKey;

  _WINHTTP_PROXY_SETTINGS = record
    dwStructSize : DWORD;
    dwFlags : DWORD;
    dwCurrentSettingsVersion : DWORD;
    pwszConnectionName : PWSTR;
    pwszProxy : PWSTR;
    pwszProxyBypass : PWSTR;
    pwszAutoconfigUrl : PWSTR;
    pwszAutoconfigSecondaryUrl : PWSTR;
    dwAutoDiscoveryFlags : DWORD;
    pwszLastKnownGoodAutoConfigUrl : PWSTR;
    dwAutoconfigReloadDelayMins : DWORD;
    ftLastKnownDetectTime : FILETIME;
    dwDetectedInterfaceIpCount : DWORD;
    pdwDetectedInterfaceIp : PDWORD;
    cNetworkKeys : DWORD;
    pNetworkKeys : PWINHTTP_PROXY_NETWORKING_KEY;
  end;
  WINHTTP_PROXY_SETTINGS = _WINHTTP_PROXY_SETTINGS;
  PWINHTTP_PROXY_SETTINGS = ^_WINHTTP_PROXY_SETTINGS;

  WINHTTP_CERTIFICATE_INFO = record
    ftExpiry : FILETIME;
    ftStart : FILETIME;
    lpszSubjectInfo : LPWSTR;
    lpszIssuerInfo : LPWSTR;
    lpszProtocolName : LPWSTR;
    lpszSignatureAlgName : LPWSTR;
    lpszEncryptionAlgName : LPWSTR;
    dwKeySize : DWORD;
  end;
  PWINHTTP_CERTIFICATE_INFO =  ^WINHTTP_CERTIFICATE_INFO;
    
  tagWINHTTP_CREDS = record
    lpszUserName : LPSTR;
    lpszPassword : LPSTR;
    lpszRealm : LPSTR;
    dwAuthScheme : DWORD;
    lpszHostName : LPSTR;
    dwPort : DWORD;
  end;
  WINHTTP_CREDS = tagWINHTTP_CREDS;
  PWINHTTP_CREDS = ^tagWINHTTP_CREDS;

  tagWINHTTP_CREDS_EX = record
    lpszUserName : LPSTR;
    lpszPassword : LPSTR;
    lpszRealm : LPSTR;
    dwAuthScheme : DWORD;
    lpszHostName : LPSTR;
    dwPort : DWORD;
    lpszUrl : LPSTR;
  end;
  WINHTTP_CREDS_EX = tagWINHTTP_CREDS_EX;
  PWINHTTP_CREDS_EX = ^tagWINHTTP_CREDS_EX;

  WINHTTP_STATUS_CALLBACK = procedure(hInterneth: HINTERNET;
    dwContext: DWORD_PTR; dwInternetStatus: DWORD; lpvStatusInformation: LPVOID;
    dwStatusInformationLength: DWORD); stdcall;
	LPWINHTTP_STATUS_CALLBACK = ^WINHTTP_STATUS_CALLBACK;
	
  WINHTTP_CURRENT_USER_IE_PROXY_CONFIG = record
    fAutoDetect : BOOL;
    lpszAutoConfigUrl : LPWSTR;
    lpszProxy : LPWSTR;
    lpszProxyBypass : LPWSTR;
  end;
  PWINHTTP_CURRENT_USER_IE_PROXY_CONFIG = ^WINHTTP_CURRENT_USER_IE_PROXY_CONFIG;
     
  _WINHTTP_WEB_SOCKET_OPERATION = (
    WINHTTP_WEB_SOCKET_SEND_OPERATION := 0,
    WINHTTP_WEB_SOCKET_RECEIVE_OPERATION := 1,
    WINHTTP_WEB_SOCKET_CLOSE_OPERATION := 2,
    WINHTTP_WEB_SOCKET_SHUTDOWN_OPERATION := 3
  );
  WINHTTP_WEB_SOCKET_OPERATION = _WINHTTP_WEB_SOCKET_OPERATION;

  _WINHTTP_WEB_SOCKET_BUFFER_TYPE = (
    WINHTTP_WEB_SOCKET_BINARY_MESSAGE_BUFFER_TYPE := 0,
    WINHTTP_WEB_SOCKET_BINARY_FRAGMENT_BUFFER_TYPE := 1,
    WINHTTP_WEB_SOCKET_UTF8_MESSAGE_BUFFER_TYPE := 2,
    WINHTTP_WEB_SOCKET_UTF8_FRAGMENT_BUFFER_TYPE := 3,
    WINHTTP_WEB_SOCKET_CLOSE_BUFFER_TYPE := 4
  );
  WINHTTP_WEB_SOCKET_BUFFER_TYPE = _WINHTTP_WEB_SOCKET_BUFFER_TYPE;
  PWINHTTP_WEB_SOCKET_BUFFER_TYPE = ^WINHTTP_WEB_SOCKET_BUFFER_TYPE;
    
  _WINHTTP_WEB_SOCKET_CLOSE_STATUS = (
    WINHTTP_WEB_SOCKET_SUCCESS_CLOSE_STATUS := 1000,
    WINHTTP_WEB_SOCKET_ENDPOINT_TERMINATED_CLOSE_STATUS := 1001,
    WINHTTP_WEB_SOCKET_PROTOCOL_ERROR_CLOSE_STATUS := 1002,
    WINHTTP_WEB_SOCKET_INVALID_DATA_TYPE_CLOSE_STATUS := 1003,
    WINHTTP_WEB_SOCKET_EMPTY_CLOSE_STATUS := 1005,
    WINHTTP_WEB_SOCKET_ABORTED_CLOSE_STATUS := 1006,
    WINHTTP_WEB_SOCKET_INVALID_PAYLOAD_CLOSE_STATUS := 1007,
    WINHTTP_WEB_SOCKET_POLICY_VIOLATION_CLOSE_STATUS := 1008,
    WINHTTP_WEB_SOCKET_MESSAGE_TOO_BIG_CLOSE_STATUS := 1009,
    WINHTTP_WEB_SOCKET_UNSUPPORTED_EXTENSIONS_CLOSE_STATUS := 1010,
    WINHTTP_WEB_SOCKET_SERVER_ERROR_CLOSE_STATUS := 1011,
    WINHTTP_WEB_SOCKET_SECURE_HANDSHAKE_ERROR_CLOSE_STATUS := 1015
  );
  WINHTTP_WEB_SOCKET_CLOSE_STATUS = _WINHTTP_WEB_SOCKET_CLOSE_STATUS;

  _WINHTTP_WEB_SOCKET_ASYNC_RESULT = record
    AsyncResult : WINHTTP_ASYNC_RESULT;
    Operation : WINHTTP_WEB_SOCKET_OPERATION;
  end;
  WINHTTP_WEB_SOCKET_ASYNC_RESULT = _WINHTTP_WEB_SOCKET_ASYNC_RESULT;

  _WINHTTP_WEB_SOCKET_STATUS = record
    dwBytesTransferred : DWORD;
    eBufferType : WINHTTP_WEB_SOCKET_BUFFER_TYPE;
  end;
  WINHTTP_WEB_SOCKET_STATUS = _WINHTTP_WEB_SOCKET_STATUS;

  function WINHTTP_INVALID_STATUS_CALLBACK : WINHTTP_STATUS_CALLBACK;    

  function WinHttpSetStatusCallback(hInternet:HINTERNET; lpfnInternetCallback:WINHTTP_STATUS_CALLBACK; dwNotificationFlags:DWORD; dwReserved:DWORD_PTR):WINHTTP_STATUS_CALLBACK; stdcall; external External_library;
  function WinHttpTimeFromSystemTime(var pst:SYSTEMTIME; pwszTime:LPWSTR):WINBOOL; stdcall; external External_library;
  function WinHttpTimeFromSystemTime(pst:PSYSTEMTIME; pwszTime:LPWSTR):WINBOOL; stdcall; overload; external External_library;
  function WinHttpTimeToSystemTime(pwszTime:LPCWSTR; var pst:SYSTEMTIME):WINBOOL; stdcall; overload; external External_library;
  function WinHttpTimeToSystemTime(pwszTime:LPCWSTR; pst:PSYSTEMTIME):WINBOOL; stdcall; overload; external External_library;
  function WinHttpCrackUrl(pwszUrl:LPCWSTR; dwUrlLength:DWORD; dwFlags:DWORD; lpUrlComponents:LPURL_COMPONENTS):WINBOOL; stdcall; external External_library;
  function WinHttpCreateUrl(lpUrlComponents:LPURL_COMPONENTS; dwFlags:DWORD; pwszUrl:LPWSTR; pdwUrlLength:LPDWORD):WINBOOL; stdcall; external External_library;
  function WinHttpCheckPlatform:WINBOOL; stdcall; external External_library;
  function WinHttpGetDefaultProxyConfiguration(var pProxyInfo:WINHTTP_PROXY_INFO):BOOL; stdcall; overload; external External_library;
  function WinHttpSetDefaultProxyConfiguration(var pProxyInfo:WINHTTP_PROXY_INFO):BOOL; stdcall; overload; external External_library;
  function WinHttpGetDefaultProxyConfiguration(pProxyInfo:PWINHTTP_PROXY_INFO):BOOL; stdcall; overload; external External_library;
  function WinHttpSetDefaultProxyConfiguration(pProxyInfo:PWINHTTP_PROXY_INFO):BOOL; stdcall; overload; external External_library;
  function WinHttpOpen(pszAgentW:LPCWSTR; dwAccessType:DWORD; pszProxyW:LPCWSTR; pszProxyBypassW:LPCWSTR; dwFlags:DWORD):HINTERNET; stdcall; external External_library;
  function WinHttpCloseHandle(hInternet:HINTERNET):WINBOOL; stdcall; external External_library;
  function WinHttpConnect(hSession:HINTERNET; pswzServerName:LPCWSTR; nServerPort:INTERNET_PORT; dwReserved:DWORD):HINTERNET; stdcall; external External_library;
  function WinHttpReadData(hRequest:HINTERNET; lpBuffer:LPVOID; dwNumberOfBytesToRead:DWORD; lpdwNumberOfBytesRead:LPDWORD):WINBOOL; stdcall; external External_library;
  function WinHttpWriteData(hRequest:HINTERNET; lpBuffer:LPCVOID; dwNumberOfBytesToWrite:DWORD; lpdwNumberOfBytesWritten:LPDWORD):WINBOOL; stdcall; external External_library;
  function WinHttpQueryDataAvailable(hRequest:HINTERNET; lpdwNumberOfBytesAvailable:LPDWORD):WINBOOL; stdcall; external External_library;
  function WinHttpQueryOption(hInternet:HINTERNET; dwOption:DWORD; lpBuffer:LPVOID; lpdwBufferLength:LPDWORD):WINBOOL; stdcall; external External_library;
  function WinHttpSetOption(hInternet:HINTERNET; dwOption:DWORD; lpBuffer:LPVOID; dwBufferLength:DWORD):WINBOOL; stdcall; external External_library;
  function WinHttpSetTimes(hInternet:HINTERNET; nResolveTime:longint; nConnectTime:longint; nSendTime:longint; nReceiveTime:longint):WINBOOL; stdcall; external External_library;
  function WinHttpIsHostInProxyBypassList(var pProxyInfo:WINHTTP_PROXY_INFO; pwszHost:PCWSTR; tScheme:INTERNET_SCHEME; nPort:INTERNET_PORT; var pfIsInBypassList:BOOL):DWORD; stdcall; overload; external External_library;
  function WinHttpIsHostInProxyBypassList(pProxyInfo:PWINHTTP_PROXY_INFO; pwszHost:PCWSTR; tScheme:INTERNET_SCHEME; nPort:INTERNET_PORT; pfIsInBypassList:PBOOL):DWORD; stdcall; overload; external External_library;
  function WinHttpOpenRequest(hConnect:HINTERNET; pwszVerb:LPCWSTR; pwszObjectName:LPCWSTR; pwszVersion:LPCWSTR; pwszReferrer:LPCWSTR; 
            ppwszAcceptTypes:LPPCWSTR; dwFlags:DWORD):HINTERNET; stdcall; external External_library;
  function WinHttpAddRequestHeaders(hRequest:HINTERNET; lpszHeaders:LPCWSTR; dwHeadersLength:DWORD; dwModifiers:DWORD):WINBOOL; stdcall; external External_library;
  function WinHttpSendRequest(hRequest:HINTERNET; lpszHeaders:LPCWSTR; dwHeadersLength:DWORD; lp:LPVOID; dwLength:DWORD; 
            dwTotalLength:DWORD; dwContext:DWORD_PTR):WINBOOL; stdcall; external External_library;
 function WinHttpSetCredentials(hRequest:HINTERNET; AuthTargets:DWORD; AuthScheme:DWORD; pwszUserName:LPCWSTR; pwszPassword:LPCWSTR; 
             pAuthParams:LPVOID):WINBOOL; stdcall; external External_library;
  function WinHttpQueryAuthSchemes(hRequest:HINTERNET; lpdwSupportedSchemes:LPDWORD; lpdwFirstScheme:LPDWORD; pdwAuthTarget:LPDWORD):WINBOOL;stdcall;external External_library name 'WinHttpQueryAuthSchemes';
  function WinHttpQueryAuthParams(hRequest:HINTERNET; AuthScheme:DWORD; var pAuthParams:LPVOID):WINBOOL; stdcall; overload; external External_library;
  function WinHttpQueryAuthParams(hRequest:HINTERNET; AuthScheme:DWORD; pAuthParams:PLPVOID):WINBOOL; stdcall; overload; external External_library;
  function WinHttpReceiveResponse(hRequest:HINTERNET; lpReserved:LPVOID):BOOL; stdcall; external External_library;
  function WinHttpQueryHeaders(hRequest:HINTERNET; dwInfoLevel:DWORD; pwszName:LPCWSTR; lpBuffer:LPVOID; lpdwBufferLength:LPDWORD; 
             lpdwIndex:LPDWORD):WINBOOL; stdcall; external External_library;
  function WinHttpDetectAutoProxyConfigUrl(dwAutoDetectFlags:DWORD; var ppwstrAutoConfigUrl:LPWSTR):WINBOOL; stdcall; overload; external External_library;
  function WinHttpDetectAutoProxyConfigUrl(dwAutoDetectFlags:DWORD; ppwstrAutoConfigUrl:PLPWSTR):WINBOOL; stdcall; overload; external External_library;
  function WinHttpGetProxyForUrl(hSession:HINTERNET; lpcwszUrl:LPCWSTR; var pAutoProxyOptions:WINHTTP_AUTOPROXY_OPTIONS; var pProxyInfo:WINHTTP_PROXY_INFO):WINBOOL; stdcall; overload; external External_library;
  function WinHttpGetProxyForUrl(hSession:HINTERNET; lpcwszUrl:LPCWSTR; pAutoProxyOptions:PWINHTTP_AUTOPROXY_OPTIONS; pProxyInfo:PWINHTTP_PROXY_INFO):WINBOOL; stdcall; overload; external External_library;
  function WinHttpCreateProxyResolver(hSession:HINTERNET; var phResolver:HINTERNET):DWORD; stdcall; overload; external External_library;
  function WinHttpCreateProxyResolver(hSession:HINTERNET; phResolver:PHINTERNET):DWORD;stdcall; overload; external External_library;
  function WinHttpGetProxyForUrlEx(hResolver:HINTERNET; pcwszUrl:PCWSTR; var pAutoProxyOptions:WINHTTP_AUTOPROXY_OPTIONS; pContext:DWORD_PTR):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyForUrlEx(hResolver:HINTERNET; pcwszUrl:PCWSTR; pAutoProxyOptions:PWINHTTP_AUTOPROXY_OPTIONS; pContext:DWORD_PTR):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyForUrlEx2(hResolver:HINTERNET; pcwszUrl:PCWSTR; var pAutoProxyOptions:WINHTTP_AUTOPROXY_OPTIONS; cbInterfaceSelectionContext:DWORD; var pInterfaceSelectionContext:BYTE; pContext:DWORD_PTR):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyForUrlEx2(hResolver:HINTERNET; pcwszUrl:PCWSTR; pAutoProxyOptions:PWINHTTP_AUTOPROXY_OPTIONS; cbInterfaceSelectionContext:DWORD; pInterfaceSelectionContext: PBYTE; pContext:DWORD_PTR):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyResult(hResolver:HINTERNET; var pProxyResult:WINHTTP_PROXY_RESULT):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyResult(hResolver:HINTERNET; pProxyResult:PWINHTTP_PROXY_RESULT):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyResultEx(hResolver:HINTERNET; var pProxyResultEx:WINHTTP_PROXY_RESULT_EX):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxyResultEx(hResolver:HINTERNET; pProxyResultEx:PWINHTTP_PROXY_RESULT_EX):DWORD; stdcall; overload; external External_library;
  procedure WinHttpFreeProxyResult(var pProxyResult:WINHTTP_PROXY_RESULT); stdcall; overload; external External_library;
  procedure WinHttpFreeProxyResult(pProxyResult:PWINHTTP_PROXY_RESULT); stdcall; overload; external External_library;
  procedure WinHttpFreeProxyResultEx(var pProxyResultEx:WINHTTP_PROXY_RESULT_EX); stdcall; overload; external External_library;
  procedure WinHttpFreeProxyResultEx(pProxyResultEx:PWINHTTP_PROXY_RESULT_EX); stdcall; overload; external External_library;
  function WinHttpResetAutoProxy(hSession:HINTERNET; dwFlags:DWORD):DWORD; stdcall; external External_library;
  function WinHttpGetIEProxyConfigForCurrentUser(var pProxyConfig:WINHTTP_CURRENT_USER_IE_PROXY_CONFIG):WINBOOL; stdcall; overload; external External_library;
  function WinHttpGetIEProxyConfigForCurrentUser(pProxyConfig:PWINHTTP_CURRENT_USER_IE_PROXY_CONFIG):WINBOOL; stdcall; overload; external External_library;
  function WinHttpWriteProxySettings(hSession:HINTERNET; fForceUpdate:BOOL; var pWinHttpProxySettings:WINHTTP_PROXY_SETTINGS):DWORD; stdcall; overload; external External_library;
  function WinHttpWriteProxySettings(hSession:HINTERNET; fForceUpdate:BOOL; pWinHttpProxySettings:PWINHTTP_PROXY_SETTINGS):DWORD; stdcall; overload; external External_library;
  function WinHttpReadProxySettings(hSession:HINTERNET; pcwszConnectionName:PCWSTR; fFallBackToDefaultSettings:BOOL; fSetAutoDiscoverForDefaultSettings:BOOL; var pdwSettingsVersion:DWORD;  var pfDefaultSettingsAreReturned:BOOL; var pWinHttpProxySettings:WINHTTP_PROXY_SETTINGS):DWORD; stdcall; overload; external External_library;
  function WinHttpReadProxySettings(hSession:HINTERNET; pcwszConnectionName:PCWSTR; fFallBackToDefaultSettings:BOOL; fSetAutoDiscoverForDefaultSettings:BOOL; pdwSettingsVersion:LPDWORD; pfDefaultSettingsAreReturned:LPBOOL; pWinHttpProxySettings:PWINHTTP_PROXY_SETTINGS):DWORD; stdcall; overload; external External_library;
  procedure WinHttpFreeProxySettings(var pWinHttpProxySettings:WINHTTP_PROXY_SETTINGS); stdcall; overload; external External_library;
  procedure WinHttpFreeProxySettings(pWinHttpProxySettings:PWINHTTP_PROXY_SETTINGS); stdcall; overload; external External_library;
  function WinHttpGetProxySettingsVersion(hSession:HINTERNET; var pdwProxySettingsVersion:DWORD):DWORD; stdcall; overload; external External_library;
  function WinHttpGetProxySettingsVersion(hSession:HINTERNET; pdwProxySettingsVersion:PDWORD):DWORD; stdcall; overload; external External_library;
  function WinHttpWebSocketCompleteUpgrade(hRequest:HINTERNET; pContext:DWORD_PTR):HINTERNET; stdcall; external External_library;
  function WinHttpWebSocketSend(hWebSocket:HINTERNET; eBufferType:WINHTTP_WEB_SOCKET_BUFFER_TYPE; pvBuffer:PVOID; dwBufferLength:DWORD):DWORD; stdcall; external External_library;
  function WinHttpWebSocketReceive(hWebSocket:HINTERNET; pvBuffer:PVOID; dwBufferLength:DWORD; var pdwBytesRead:DWORD; var peBufferType:WINHTTP_WEB_SOCKET_BUFFER_TYPE):DWORD; stdcall; overload; external External_library;
  function WinHttpWebSocketReceive(hWebSocket:HINTERNET; pvBuffer:PVOID; dwBufferLength:DWORD; pdwBytesRead:LPDWORD; peBufferType:PWINHTTP_WEB_SOCKET_BUFFER_TYPE):DWORD; stdcall; overload; external External_library;
  function WinHttpWebSocketShutdown(hWebSocket:HINTERNET; usStatus:USHORT; pvReason:PVOID; dwReasonLength:DWORD):DWORD; stdcall; external External_library;
  function WinHttpWebSocketClose(hWebSocket:HINTERNET; usStatus:USHORT; pvReason:PVOID; dwReasonLength:DWORD):DWORD; stdcall; external External_library;
  function WinHttpWebSocketQueryCloseStatus(hWebSocket:HINTERNET; var pusStatus:USHORT; pvReason:PVOID; dwReasonLength:DWORD; var pdwReasonLengthConsumed:DWORD):DWORD; stdcall; overload; external External_library;
  function WinHttpWebSocketQueryCloseStatus(hWebSocket:HINTERNET; pusStatus:LPUSHORT; pvReason:PVOID; dwReasonLength:DWORD; pdwReasonLengthConsumed:LPDWORD):DWORD; stdcall; overload; external External_library;


implementation

  function WINHTTP_INVALID_STATUS_CALLBACK : WINHTTP_STATUS_CALLBACK;
    begin
      WINHTTP_INVALID_STATUS_CALLBACK:=WINHTTP_STATUS_CALLBACK(-(1));
    end;

end.
