{
    This file is part of the Free Pascal run time library.
    Copyright (c) 2007-2008 Free Pascal development team.

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{ Declarations for tapi WinCE API, note than on WinCE tapi functions originally
  based in coredll.dll
}

{ this port based on Windows Mobile 5 Smartphone Edition SDK
  contact S0vNark0m for more information snk_post@mail.ru (en, ru)
}

{$IFNDEF FPC_DOTTEDUNITS}
unit tapi;
{$ENDIF FPC_DOTTEDUNITS}

interface

{$IFDEF FPC_DOTTEDUNITS}
uses WinApi.Windows;
{$ELSE FPC_DOTTEDUNITS}
uses windows;
{$ENDIF FPC_DOTTEDUNITS}

{$calling cdecl}

//*****************************************************************************
// consts
//*****************************************************************************

const

  TAPI_CURRENT_VERSION = $00020000;

  { Messages for Phones and Lines }

  LINE_ADDRESSSTATE = 0;
  LINE_CALLINFO = 1;
  LINE_CALLSTATE = 2;
  LINE_CLOSE = 3;
  LINE_DEVSPECIFIC = 4;
  LINE_DEVSPECIFICFEATURE = 5;
  LINE_GATHERDIGITS = 6;
  LINE_GENERATE = 7;
  LINE_LINEDEVSTATE = 8;
  LINE_MONITORDIGITS = 9;
  LINE_MONITORMEDIA = 10;
  LINE_MONITORTONE = 11;
  LINE_REPLY = 12;
  LINE_REQUEST = 13;
  PHONE_BUTTON = 14;
  PHONE_CLOSE = 15;
  PHONE_DEVSPECIFIC = 16;
  PHONE_REPLY = 17;
  PHONE_STATE = 18;
  LINE_CREATE = 19;       { TAPI v1.4 }
  PHONE_CREATE = 20;       { TAPI v1.4 }

  LINE_AGENTSPECIFIC = 21;       { TAPI v2.0 }
  LINE_AGENTSTATUS = 22;       { TAPI v2.0 }
  LINE_APPNEWCALL = 23;       { TAPI v2.0 }
  LINE_PROXYREQUEST = 24;       { TAPI v2.0 }
  LINE_REMOVE = 25;       { TAPI v2.0 }
  PHONE_REMOVE = 26;       { TAPI v2.0 }

  INITIALIZE_NEGOTIATION = $FFFFFFFF;

  LINEADDRCAPFLAGS_FWDNUMRINGS = $00000001;
  LINEADDRCAPFLAGS_PICKUPGROUPID = $00000002;
  LINEADDRCAPFLAGS_SECURE = $00000004;
  LINEADDRCAPFLAGS_BLOCKIDDEFAULT = $00000008;
  LINEADDRCAPFLAGS_BLOCKIDOVERRIDE = $00000010;
  LINEADDRCAPFLAGS_DIALED = $00000020;
  LINEADDRCAPFLAGS_ORIGOFFHOOK = $00000040;
  LINEADDRCAPFLAGS_DESTOFFHOOK = $00000080;
  LINEADDRCAPFLAGS_FWDCONSULT = $00000100;
  LINEADDRCAPFLAGS_SETUPCONFNULL = $00000200;
  LINEADDRCAPFLAGS_AUTORECONNECT = $00000400;
  LINEADDRCAPFLAGS_COMPLETIONID = $00000800;
  LINEADDRCAPFLAGS_TRANSFERHELD = $00001000;
  LINEADDRCAPFLAGS_TRANSFERMAKE = $00002000;
  LINEADDRCAPFLAGS_CONFERENCEHELD = $00004000;
  LINEADDRCAPFLAGS_CONFERENCEMAKE = $00008000;
  LINEADDRCAPFLAGS_PARTIALDIAL = $00010000;
  LINEADDRCAPFLAGS_FWDSTATUSVALID = $00020000;
  LINEADDRCAPFLAGS_FWDINTEXTADDR = $00040000;
  LINEADDRCAPFLAGS_FWDBUSYNAADDR = $00080000;
  LINEADDRCAPFLAGS_ACCEPTTOALERT = $00100000;
  LINEADDRCAPFLAGS_CONFDROP = $00200000;
  LINEADDRCAPFLAGS_PICKUPCALLWAIT = $00400000;
  LINEADDRCAPFLAGS_PREDICTIVEDIALER = $00800000;       { TAPI v2.0 }
  LINEADDRCAPFLAGS_QUEUE = $01000000;       { TAPI v2.0 }
  LINEADDRCAPFLAGS_ROUTEPOINT = $02000000;       { TAPI v2.0 }
  LINEADDRCAPFLAGS_HOLDMAKESNEW = $04000000;       { TAPI v2.0 }
  LINEADDRCAPFLAGS_NOINTERNALCALLS = $08000000;       { TAPI v2.0 }
  LINEADDRCAPFLAGS_NOEXTERNALCALLS = $10000000;       { TAPI v2.0 }
  LINEADDRCAPFLAGS_SETCALLINGID = $20000000;       { TAPI v2.0 }

  LINEADDRESSMODE_ADDRESSID = $00000001;
  LINEADDRESSMODE_DIALABLEADDR = $00000002;

  LINEADDRESSSHARING_PRIVATE = $00000001;
  LINEADDRESSSHARING_BRIDGEDEXCL = $00000002;
  LINEADDRESSSHARING_BRIDGEDNEW = $00000004;
  LINEADDRESSSHARING_BRIDGEDSHARED = $00000008;
  LINEADDRESSSHARING_MONITORED = $00000010;

  LINEADDRESSSTATE_OTHER = $00000001;
  LINEADDRESSSTATE_DEVSPECIFIC = $00000002;
  LINEADDRESSSTATE_INUSEZERO = $00000004;
  LINEADDRESSSTATE_INUSEONE = $00000008;
  LINEADDRESSSTATE_INUSEMANY = $00000010;
  LINEADDRESSSTATE_NUMCALLS = $00000020;
  LINEADDRESSSTATE_FORWARD = $00000040;
  LINEADDRESSSTATE_TERMINALS = $00000080;
  LINEADDRESSSTATE_CAPSCHANGE = $00000100;       { TAPI v1.4 }

  LINEADDRESSTYPE_PHONENUMBER = $00000001;
  LINEADDRESSTYPE_SDP = $00000002;
  LINEADDRESSTYPE_EMAILNAME = $00000004;
  LINEADDRESSTYPE_DOMAINNAME = $00000008;
  LINEADDRESSTYPE_IPADDRESS = $00000010;

  LINEADDRFEATURE_FORWARD = $00000001;
  LINEADDRFEATURE_MAKECALL = $00000002;
  LINEADDRFEATURE_PICKUP = $00000004;
  LINEADDRFEATURE_SETMEDIACONTROL = $00000008;
  LINEADDRFEATURE_SETTERMINAL = $00000010;
  LINEADDRFEATURE_SETUPCONF = $00000020;
  LINEADDRFEATURE_UNCOMPLETECALL = $00000040;
  LINEADDRFEATURE_UNPARK = $00000080;
  LINEADDRFEATURE_PICKUPHELD = $00000100;       { TAPI v2.0 }
  LINEADDRFEATURE_PICKUPGROUP = $00000200;       { TAPI v2.0 }
  LINEADDRFEATURE_PICKUPDIRECT = $00000400;       { TAPI v2.0 }
  LINEADDRFEATURE_PICKUPWAITING = $00000800;       { TAPI v2.0 }
  LINEADDRFEATURE_FORWARDFWD = $00001000;       { TAPI v2.0 }
  LINEADDRFEATURE_FORWARDDND = $00002000;       { TAPI v2.0 }

  LINEAGENTFEATURE_SETAGENTGROUP = $00000001;       { TAPI v2.0 }
  LINEAGENTFEATURE_SETAGENTSTATE = $00000002;       { TAPI v2.0 }
  LINEAGENTFEATURE_SETAGENTACTIVITY = $00000004;       { TAPI v2.0 }
  LINEAGENTFEATURE_AGENTSPECIFIC = $00000008;       { TAPI v2.0 }
  LINEAGENTFEATURE_GETAGENTACTIVITYLIST = $00000010;       { TAPI v2.0 }
  LINEAGENTFEATURE_GETAGENTGROUP = $00000020;       { TAPI v2.0 }

  LINEAGENTSTATE_LOGGEDOFF = $00000001;       { TAPI v2.0 }
  LINEAGENTSTATE_NOTREADY = $00000002;       { TAPI v2.0 }
  LINEAGENTSTATE_READY = $00000004;       { TAPI v2.0 }
  LINEAGENTSTATE_BUSYACD = $00000008;       { TAPI v2.0 }
  LINEAGENTSTATE_BUSYINCOMING = $00000010;       { TAPI v2.0 }
  LINEAGENTSTATE_BUSYOUTBOUND = $00000020;       { TAPI v2.0 }
  LINEAGENTSTATE_BUSYOTHER = $00000040;       { TAPI v2.0 }
  LINEAGENTSTATE_WORKINGAFTERCALL = $00000080;       { TAPI v2.0 }
  LINEAGENTSTATE_UNKNOWN = $00000100;       { TAPI v2.0 }
  LINEAGENTSTATE_UNAVAIL = $00000200;       { TAPI v2.0 }

  LINEAGENTSTATUS_GROUP = $00000001;       { TAPI v2.0 }
  LINEAGENTSTATUS_STATE = $00000002;       { TAPI v2.0 }
  LINEAGENTSTATUS_NEXTSTATE = $00000004;       { TAPI v2.0 }
  LINEAGENTSTATUS_ACTIVITY = $00000008;       { TAPI v2.0 }
  LINEAGENTSTATUS_ACTIVITYLIST = $00000010;       { TAPI v2.0 }
  LINEAGENTSTATUS_GROUPLIST = $00000020;       { TAPI v2.0 }
  LINEAGENTSTATUS_CAPSCHANGE = $00000040;       { TAPI v2.0 }
  LINEAGENTSTATUS_VALIDSTATES = $00000080;       { TAPI v2.0 }
  LINEAGENTSTATUS_VALIDNEXTSTATES = $00000100;       { TAPI v2.0 }

  LINEANSWERMODE_NONE = $00000001;
  LINEANSWERMODE_DROP = $00000002;
  LINEANSWERMODE_HOLD = $00000004;
  LINEBEARERMODE_VOICE = $00000001;
  LINEBEARERMODE_SPEECH = $00000002;
  LINEBEARERMODE_MULTIUSE = $00000004;
  LINEBEARERMODE_DATA = $00000008;
  LINEBEARERMODE_ALTSPEECHDATA = $00000010;
  LINEBEARERMODE_NONCALLSIGNALING = $00000020;
  LINEBEARERMODE_PASSTHROUGH = $00000040;       { TAPI v1.4 }
  LINEBEARERMODE_RESTRICTEDDATA = $00000080;       { TAPI v2.0 }

  LINEBUSYMODE_STATION = $00000001;
  LINEBUSYMODE_TRUNK = $00000002;
  LINEBUSYMODE_UNKNOWN = $00000004;
  LINEBUSYMODE_UNAVAIL = $00000008;

  LINECALLCOMPLCOND_BUSY = $00000001;
  LINECALLCOMPLCOND_NOANSWER = $00000002;

  LINECALLCOMPLMODE_CAMPON = $00000001;
  LINECALLCOMPLMODE_CALLBACK = $00000002;
  LINECALLCOMPLMODE_INTRUDE = $00000004;
  LINECALLCOMPLMODE_MESSAGE = $00000008;

  LINECALLFEATURE_ACCEPT = $00000001;
  LINECALLFEATURE_ADDTOCONF = $00000002;
  LINECALLFEATURE_ANSWER = $00000004;
  LINECALLFEATURE_BLINDTRANSFER = $00000008;
  LINECALLFEATURE_COMPLETECALL = $00000010;
  LINECALLFEATURE_COMPLETETRANSF = $00000020;
  LINECALLFEATURE_DIAL = $00000040;
  LINECALLFEATURE_DROP = $00000080;
  LINECALLFEATURE_GATHERDIGITS = $00000100;
  LINECALLFEATURE_GENERATEDIGITS = $00000200;
  LINECALLFEATURE_GENERATETONE = $00000400;
  LINECALLFEATURE_HOLD = $00000800;
  LINECALLFEATURE_MONITORDIGITS = $00001000;
  LINECALLFEATURE_MONITORMEDIA = $00002000;
  LINECALLFEATURE_MONITORTONES = $00004000;
  LINECALLFEATURE_PARK = $00008000;
  LINECALLFEATURE_PREPAREADDCONF = $00010000;
  LINECALLFEATURE_REDIRECT = $00020000;
  LINECALLFEATURE_REMOVEFROMCONF = $00040000;
  LINECALLFEATURE_SECURECALL = $00080000;
  LINECALLFEATURE_SENDUSERUSER = $00100000;
  LINECALLFEATURE_SETCALLPARAMS = $00200000;
  LINECALLFEATURE_SETMEDIACONTROL = $00400000;
  LINECALLFEATURE_SETTERMINAL = $00800000;
  LINECALLFEATURE_SETUPCONF = $01000000;
  LINECALLFEATURE_SETUPTRANSFER = $02000000;
  LINECALLFEATURE_SWAPHOLD = $04000000;
  LINECALLFEATURE_UNHOLD = $08000000;
  LINECALLFEATURE_RELEASEUSERUSERINFO = $10000000;       { TAPI v1.4 }
  LINECALLFEATURE_SETTREATMENT = $20000000;       { TAPI v2.0 }
  LINECALLFEATURE_SETQOS = $40000000;       { TAPI v2.0 }
  LINECALLFEATURE_SETCALLDATA = $80000000;       { TAPI v2.0 }

  LINECALLFEATURE2_NOHOLDCONFERENCE = $00000001;       { TAPI v2.0 }
  LINECALLFEATURE2_ONESTEPTRANSFER = $00000002;       { TAPI v2.0 }
  LINECALLFEATURE2_COMPLCAMPON = $00000004;       { TAPI v2.0 }
  LINECALLFEATURE2_COMPLCALLBACK = $00000008;       { TAPI v2.0 }
  LINECALLFEATURE2_COMPLINTRUDE = $00000010;       { TAPI v2.0 }
  LINECALLFEATURE2_COMPLMESSAGE = $00000020;       { TAPI v2.0 }
  LINECALLFEATURE2_TRANSFERNORM = $00000040;       { TAPI v2.0 }
  LINECALLFEATURE2_TRANSFERCONF = $00000080;       { TAPI v2.0 }
  LINECALLFEATURE2_PARKDIRECT = $00000100;       { TAPI v2.0 }
  LINECALLFEATURE2_PARKNONDIRECT = $00000200;       { TAPI v2.0 }

  LINECALLINFOSTATE_OTHER = $00000001;
  LINECALLINFOSTATE_DEVSPECIFIC = $00000002;
  LINECALLINFOSTATE_BEARERMODE = $00000004;
  LINECALLINFOSTATE_RATE = $00000008;
  LINECALLINFOSTATE_MEDIAMODE = $00000010;
  LINECALLINFOSTATE_APPSPECIFIC = $00000020;
  LINECALLINFOSTATE_CALLID = $00000040;
  LINECALLINFOSTATE_RELATEDCALLID = $00000080;
  LINECALLINFOSTATE_ORIGIN = $00000100;
  LINECALLINFOSTATE_REASON = $00000200;
  LINECALLINFOSTATE_COMPLETIONID = $00000400;
  LINECALLINFOSTATE_NUMOWNERINCR = $00000800;
  LINECALLINFOSTATE_NUMOWNERDECR = $00001000;
  LINECALLINFOSTATE_NUMMONITORS = $00002000;
  LINECALLINFOSTATE_TRUNK = $00004000;
  LINECALLINFOSTATE_CALLERID = $00008000;
  LINECALLINFOSTATE_CALLEDID = $00010000;
  LINECALLINFOSTATE_CONNECTEDID = $00020000;
  LINECALLINFOSTATE_REDIRECTIONID = $00040000;
  LINECALLINFOSTATE_REDIRECTINGID = $00080000;
  LINECALLINFOSTATE_DISPLAY = $00100000;
  LINECALLINFOSTATE_USERUSERINFO = $00200000;
  LINECALLINFOSTATE_HIGHLEVELCOMP = $00400000;
  LINECALLINFOSTATE_LOWLEVELCOMP = $00800000;
  LINECALLINFOSTATE_CHARGINGINFO = $01000000;
  LINECALLINFOSTATE_TERMINAL = $02000000;
  LINECALLINFOSTATE_DIALPARAMS = $04000000;
  LINECALLINFOSTATE_MONITORMODES = $08000000;
  LINECALLINFOSTATE_TREATMENT = $10000000;       { TAPI v2.0 }
  LINECALLINFOSTATE_QOS = $20000000;       { TAPI v2.0 }
  LINECALLINFOSTATE_CALLDATA = $40000000;       { TAPI v2.0 }

  LINECALLORIGIN_OUTBOUND = $00000001;
  LINECALLORIGIN_INTERNAL = $00000002;
  LINECALLORIGIN_EXTERNAL = $00000004;
  LINECALLORIGIN_UNKNOWN = $00000010;
  LINECALLORIGIN_UNAVAIL = $00000020;
  LINECALLORIGIN_CONFERENCE = $00000040;
  LINECALLORIGIN_INBOUND = $00000080;       { TAPI v1.4 }

  LINECALLPARAMFLAGS_SECURE = $00000001;
  LINECALLPARAMFLAGS_IDLE = $00000002;
  LINECALLPARAMFLAGS_BLOCKID = $00000004;
  LINECALLPARAMFLAGS_ORIGOFFHOOK = $00000008;
  LINECALLPARAMFLAGS_DESTOFFHOOK = $00000010;
  LINECALLPARAMFLAGS_NOHOLDCONFERENCE = $00000020;       { TAPI v2.0 }
  LINECALLPARAMFLAGS_PREDICTIVEDIAL = $00000040;       { TAPI v2.0 }
  LINECALLPARAMFLAGS_ONESTEPTRANSFER = $00000080;       { TAPI v2.0 }

  LINECALLPARTYID_BLOCKED = $00000001;
  LINECALLPARTYID_OUTOFAREA = $00000002;
  LINECALLPARTYID_NAME = $00000004;
  LINECALLPARTYID_ADDRESS = $00000008;
  LINECALLPARTYID_PARTIAL = $00000010;
  LINECALLPARTYID_UNKNOWN = $00000020;
  LINECALLPARTYID_UNAVAIL = $00000040;

  LINECALLPRIVILEGE_NONE = $00000001;
  LINECALLPRIVILEGE_MONITOR = $00000002;
  LINECALLPRIVILEGE_OWNER = $00000004;

  LINECALLREASON_DIRECT = $00000001;
  LINECALLREASON_FWDBUSY = $00000002;
  LINECALLREASON_FWDNOANSWER = $00000004;
  LINECALLREASON_FWDUNCOND = $00000008;
  LINECALLREASON_PICKUP = $00000010;
  LINECALLREASON_UNPARK = $00000020;
  LINECALLREASON_REDIRECT = $00000040;
  LINECALLREASON_CALLCOMPLETION = $00000080;
  LINECALLREASON_TRANSFER = $00000100;
  LINECALLREASON_REMINDER = $00000200;
  LINECALLREASON_UNKNOWN = $00000400;
  LINECALLREASON_UNAVAIL = $00000800;
  LINECALLREASON_INTRUDE = $00001000;       { TAPI v1.4 }
  LINECALLREASON_PARKED = $00002000;       { TAPI v1.4 }
  LINECALLREASON_CAMPEDON = $00004000;       { TAPI v2.0 }
  LINECALLREASON_ROUTEREQUEST = $00008000;       { TAPI v2.0 }

  LINECALLSELECT_LINE = $00000001;
  LINECALLSELECT_ADDRESS = $00000002;
  LINECALLSELECT_CALL = $00000004;
  LINECALLSELECT_DEVICEID = $00000008;       { TAPI v2.1 }
  LINECALLSELECT_CALLID = $00000010;       { TAPI v3.0 }

  LINECALLSTATE_IDLE = $00000001;
  LINECALLSTATE_OFFERING = $00000002;
  LINECALLSTATE_ACCEPTED = $00000004;
  LINECALLSTATE_DIALTONE = $00000008;
  LINECALLSTATE_DIALING = $00000010;
  LINECALLSTATE_RINGBACK = $00000020;
  LINECALLSTATE_BUSY = $00000040;
  LINECALLSTATE_SPECIALINFO = $00000080;
  LINECALLSTATE_CONNECTED = $00000100;
  LINECALLSTATE_PROCEEDING = $00000200;
  LINECALLSTATE_ONHOLD = $00000400;
  LINECALLSTATE_CONFERENCED = $00000800;
  LINECALLSTATE_ONHOLDPENDCONF = $00001000;
  LINECALLSTATE_ONHOLDPENDTRANSFER = $00002000;
  LINECALLSTATE_DISCONNECTED = $00004000;
  LINECALLSTATE_UNKNOWN = $00008000;

  LINECALLTREATMENT_SILENCE = $00000001;       { TAPI v2.0 }
  LINECALLTREATMENT_RINGBACK = $00000002;       { TAPI v2.0 }
  LINECALLTREATMENT_BUSY = $00000003;       { TAPI v2.0 }
  LINECALLTREATMENT_MUSIC = $00000004;       { TAPI v2.0 }

  LINECARDOPTION_PREDEFINED = $00000001;       { TAPI v1.4 }
  LINECARDOPTION_HIDDEN = $00000002;       { TAPI v1.4 }

  LINECONNECTEDMODE_ACTIVE = $00000001;       { TAPI v1.4 }
  LINECONNECTEDMODE_INACTIVE = $00000002;       { TAPI v1.4 }
  LINECONNECTEDMODE_ACTIVEHELD = $00000004;       { TAPI v2.0 }
  LINECONNECTEDMODE_INACTIVEHELD = $00000008;       { TAPI v2.0 }
  LINECONNECTEDMODE_CONFIRMED = $00000010;       { TAPI v2.0 }

  LINEDEVCAPFLAGS_CROSSADDRCONF = $00000001;
  LINEDEVCAPFLAGS_HIGHLEVCOMP = $00000002;
  LINEDEVCAPFLAGS_LOWLEVCOMP = $00000004;
  LINEDEVCAPFLAGS_MEDIACONTROL = $00000008;
  LINEDEVCAPFLAGS_MULTIPLEADDR = $00000010;
  LINEDEVCAPFLAGS_CLOSEDROP = $00000020;
  LINEDEVCAPFLAGS_DIALBILLING = $00000040;
  LINEDEVCAPFLAGS_DIALQUIET = $00000080;
  LINEDEVCAPFLAGS_DIALDIALTONE = $00000100;
  LINEDEVCAPFLAGS_MSP = $00000200;       { TAPI v3.0 }
  LINEDEVCAPFLAGS_CALLHUB = $00000400;       { TAPI v3.0 }
  LINEDEVCAPFLAGS_CALLHUBTRACKING = $00000800;       { TAPI v3.0 }
  LINEDEVCAPFLAGS_PRIVATEOBJECTS = $00001000;       { TAPI v3.0 }

  LINEDEVSTATE_OTHER = $00000001;
  LINEDEVSTATE_RINGING = $00000002;
  LINEDEVSTATE_CONNECTED = $00000004;
  LINEDEVSTATE_DISCONNECTED = $00000008;
  LINEDEVSTATE_MSGWAITON = $00000010;
  LINEDEVSTATE_MSGWAITOFF = $00000020;
  LINEDEVSTATE_INSERVICE = $00000040;
  LINEDEVSTATE_OUTOFSERVICE = $00000080;
  LINEDEVSTATE_MAINTENANCE = $00000100;
  LINEDEVSTATE_OPEN = $00000200;
  LINEDEVSTATE_CLOSE = $00000400;
  LINEDEVSTATE_NUMCALLS = $00000800;
  LINEDEVSTATE_NUMCOMPLETIONS = $00001000;
  LINEDEVSTATE_TERMINALS = $00002000;
  LINEDEVSTATE_ROAMMODE = $00004000;
  LINEDEVSTATE_BATTERY = $00008000;
  LINEDEVSTATE_SIGNAL = $00010000;
  LINEDEVSTATE_DEVSPECIFIC = $00020000;
  LINEDEVSTATE_REINIT = $00040000;
  LINEDEVSTATE_LOCK = $00080000;
  LINEDEVSTATE_CAPSCHANGE = $00100000;       { TAPI v1.4 }
  LINEDEVSTATE_CONFIGCHANGE = $00200000;       { TAPI v1.4 }
  LINEDEVSTATE_TRANSLATECHANGE = $00400000;       { TAPI v1.4 }
  LINEDEVSTATE_COMPLCANCEL = $00800000;       { TAPI v1.4 }
  LINEDEVSTATE_REMOVED = $01000000;       { TAPI v1.4 }

  LINEDEVSTATUSFLAGS_CONNECTED = $00000001;
  LINEDEVSTATUSFLAGS_MSGWAIT = $00000002;
  LINEDEVSTATUSFLAGS_INSERVICE = $00000004;
  LINEDEVSTATUSFLAGS_LOCKED = $00000008;

  LINEDIALTONEMODE_NORMAL = $00000001;
  LINEDIALTONEMODE_SPECIAL = $00000002;
  LINEDIALTONEMODE_INTERNAL = $00000004;
  LINEDIALTONEMODE_EXTERNAL = $00000008;
  LINEDIALTONEMODE_UNKNOWN = $00000010;
  LINEDIALTONEMODE_UNAVAIL = $00000020;

  LINEDIGITMODE_PULSE = $00000001;
  LINEDIGITMODE_DTMF = $00000002;
  LINEDIGITMODE_DTMFEND = $00000004;

  LINEDISCONNECTMODE_NORMAL = $00000001;
  LINEDISCONNECTMODE_UNKNOWN = $00000002;
  LINEDISCONNECTMODE_REJECT = $00000004;
  LINEDISCONNECTMODE_PICKUP = $00000008;
  LINEDISCONNECTMODE_FORWARDED = $00000010;
  LINEDISCONNECTMODE_BUSY = $00000020;
  LINEDISCONNECTMODE_NOANSWER = $00000040;
  LINEDISCONNECTMODE_BADADDRESS = $00000080;
  LINEDISCONNECTMODE_UNREACHABLE = $00000100;
  LINEDISCONNECTMODE_CONGESTION = $00000200;
  LINEDISCONNECTMODE_INCOMPATIBLE = $00000400;
  LINEDISCONNECTMODE_UNAVAIL = $00000800;
  LINEDISCONNECTMODE_NODIALTONE = $00001000;       { TAPI v1.4 }
  LINEDISCONNECTMODE_NUMBERCHANGED = $00002000;       { TAPI v2.0 }
  LINEDISCONNECTMODE_OUTOFORDER = $00004000;       { TAPI v2.0 }
  LINEDISCONNECTMODE_TEMPFAILURE = $00008000;       { TAPI v2.0 }
  LINEDISCONNECTMODE_QOSUNAVAIL = $00010000;       { TAPI v2.0 }
  LINEDISCONNECTMODE_BLOCKED = $00020000;       { TAPI v2.0 }
  LINEDISCONNECTMODE_DONOTDISTURB = $00040000;       { TAPI v2.0 }
  LINEDISCONNECTMODE_CANCELLED = $00080000;       { TAPI v2.0 }

  LINEERR_ALLOCATED = $80000001;
  LINEERR_BADDEVICEID = $80000002;
  LINEERR_BEARERMODEUNAVAIL = $80000003;
  LINEERR_CALLUNAVAIL = $80000005;
  LINEERR_COMPLETIONOVERRUN = $80000006;
  LINEERR_CONFERENCEFULL = $80000007;
  LINEERR_DIALBILLING = $80000008;
  LINEERR_DIALDIALTONE = $80000009;
  LINEERR_DIALPROMPT = $8000000A;
  LINEERR_DIALQUIET = $8000000B;
  LINEERR_INCOMPATIBLEAPIVERSION = $8000000C;
  LINEERR_INCOMPATIBLEEXTVERSION = $8000000D;
  LINEERR_INIFILECORRUPT = $8000000E;
  LINEERR_INUSE = $8000000F;
  LINEERR_INVALADDRESS = $80000010;
  LINEERR_INVALADDRESSID = $80000011;
  LINEERR_INVALADDRESSMODE = $80000012;
  LINEERR_INVALADDRESSSTATE = $80000013;
  LINEERR_INVALAPPHANDLE = $80000014;
  LINEERR_INVALAPPNAME = $80000015;
  LINEERR_INVALBEARERMODE = $80000016;
  LINEERR_INVALCALLCOMPLMODE = $80000017;
  LINEERR_INVALCALLHANDLE = $80000018;
  LINEERR_INVALCALLPARAMS = $80000019;
  LINEERR_INVALCALLPRIVILEGE = $8000001A;
  LINEERR_INVALCALLSELECT = $8000001B;
  LINEERR_INVALCALLSTATE = $8000001C;
  LINEERR_INVALCALLSTATELIST = $8000001D;
  LINEERR_INVALCARD = $8000001E;
  LINEERR_INVALCOMPLETIONID = $8000001F;
  LINEERR_INVALCONFCALLHANDLE = $80000020;
  LINEERR_INVALCONSULTCALLHANDLE = $80000021;
  LINEERR_INVALCOUNTRYCODE = $80000022;
  LINEERR_INVALDEVICECLASS = $80000023;
  LINEERR_INVALDEVICEHANDLE = $80000024;
  LINEERR_INVALDIALPARAMS = $80000025;
  LINEERR_INVALDIGITLIST = $80000026;
  LINEERR_INVALDIGITMODE = $80000027;
  LINEERR_INVALDIGITS = $80000028;
  LINEERR_INVALEXTVERSION = $80000029;
  LINEERR_INVALGROUPID = $8000002A;
  LINEERR_INVALLINEHANDLE = $8000002B;
  LINEERR_INVALLINESTATE = $8000002C;
  LINEERR_INVALLOCATION = $8000002D;
  LINEERR_INVALMEDIALIST = $8000002E;
  LINEERR_INVALMEDIAMODE = $8000002F;
  LINEERR_INVALMESSAGEID = $80000030;
  LINEERR_INVALPARAM = $80000032;
  LINEERR_INVALPARKID = $80000033;
  LINEERR_INVALPARKMODE = $80000034;
  LINEERR_INVALPOINTER = $80000035;
  LINEERR_INVALPRIVSELECT = $80000036;
  LINEERR_INVALRATE = $80000037;
  LINEERR_INVALREQUESTMODE = $80000038;
  LINEERR_INVALTERMINALID = $80000039;
  LINEERR_INVALTERMINALMODE = $8000003A;
  LINEERR_INVALTIMEOUT = $8000003B;
  LINEERR_INVALTONE = $8000003C;
  LINEERR_INVALTONELIST = $8000003D;
  LINEERR_INVALTONEMODE = $8000003E;
  LINEERR_INVALTRANSFERMODE = $8000003F;
  LINEERR_LINEMAPPERFAILED = $80000040;
  LINEERR_NOCONFERENCE = $80000041;
  LINEERR_NODEVICE = $80000042;
  LINEERR_NODRIVER = $80000043;
  LINEERR_NOMEM = $80000044;
  LINEERR_NOREQUEST = $80000045;
  LINEERR_NOTOWNER = $80000046;
  LINEERR_NOTREGISTERED = $80000047;
  LINEERR_OPERATIONFAILED = $80000048;
  LINEERR_OPERATIONUNAVAIL = $80000049;
  LINEERR_RATEUNAVAIL = $8000004A;
  LINEERR_RESOURCEUNAVAIL = $8000004B;
  LINEERR_REQUESTOVERRUN = $8000004C;
  LINEERR_STRUCTURETOOSMALL = $8000004D;
  LINEERR_TARGETNOTFOUND = $8000004E;
  LINEERR_TARGETSELF = $8000004F;
  LINEERR_UNINITIALIZED = $80000050;
  LINEERR_USERUSERINFOTOOBIG = $80000051;
  LINEERR_REINIT = $80000052;
  LINEERR_ADDRESSBLOCKED = $80000053;
  LINEERR_BILLINGREJECTED = $80000054;
  LINEERR_INVALFEATURE = $80000055;
  LINEERR_NOMULTIPLEINSTANCE = $80000056;
  LINEERR_INVALAGENTID = $80000057;       { TAPI v2.0 }
  LINEERR_INVALAGENTGROUP = $80000058;       { TAPI v2.0 }
  LINEERR_INVALPASSWORD = $80000059;       { TAPI v2.0 }
  LINEERR_INVALAGENTSTATE = $8000005A;       { TAPI v2.0 }
  LINEERR_INVALAGENTACTIVITY = $8000005B;       { TAPI v2.0 }
  LINEERR_DIALVOICEDETECT = $8000005C;       { TAPI v2.0 }

  LINEFEATURE_DEVSPECIFIC = $00000001;
  LINEFEATURE_DEVSPECIFICFEAT = $00000002;
  LINEFEATURE_FORWARD = $00000004;
  LINEFEATURE_MAKECALL = $00000008;
  LINEFEATURE_SETMEDIACONTROL = $00000010;
  LINEFEATURE_SETTERMINAL = $00000020;
  LINEFEATURE_SETDEVSTATUS = $00000040;       { TAPI v2.0 }
  LINEFEATURE_FORWARDFWD = $00000080;       { TAPI v2.0 }
  LINEFEATURE_FORWARDDND = $00000100;       { TAPI v2.0 }

  LINEFORWARDMODE_UNCOND = $00000001;
  LINEFORWARDMODE_UNCONDINTERNAL = $00000002;
  LINEFORWARDMODE_UNCONDEXTERNAL = $00000004;
  LINEFORWARDMODE_UNCONDSPECIFIC = $00000008;
  LINEFORWARDMODE_BUSY = $00000010;
  LINEFORWARDMODE_BUSYINTERNAL = $00000020;
  LINEFORWARDMODE_BUSYEXTERNAL = $00000040;
  LINEFORWARDMODE_BUSYSPECIFIC = $00000080;
  LINEFORWARDMODE_NOANSW = $00000100;
  LINEFORWARDMODE_NOANSWINTERNAL = $00000200;
  LINEFORWARDMODE_NOANSWEXTERNAL = $00000400;
  LINEFORWARDMODE_NOANSWSPECIFIC = $00000800;
  LINEFORWARDMODE_BUSYNA = $00001000;
  LINEFORWARDMODE_BUSYNAINTERNAL = $00002000;
  LINEFORWARDMODE_BUSYNAEXTERNAL = $00004000;
  LINEFORWARDMODE_BUSYNASPECIFIC = $00008000;
  LINEFORWARDMODE_UNKNOWN = $00010000;       { TAPI v1.4 }
  LINEFORWARDMODE_UNAVAIL = $00020000;       { TAPI v1.4 }

  LINEGATHERTERM_BUFFERFULL = $00000001;
  LINEGATHERTERM_TERMDIGIT = $00000002;
  LINEGATHERTERM_FIRSTTIMEOUT = $00000004;
  LINEGATHERTERM_INTERTIMEOUT = $00000008;
  LINEGATHERTERM_CANCEL = $00000010;

  LINEGENERATETERM_DONE = $00000001;
  LINEGENERATETERM_CANCEL = $00000002;

 { These constants are mutually exclusive - there's no way to specify more }
 { than one at a time (and it doesn't make sense, either) so they're }
 { ordinal rather than bits. }

  LINEINITIALIZEEXOPTION_USEHIDDENWINDOW = $00000001;       { TAPI v2.0 }
  LINEINITIALIZEEXOPTION_USEEVENT = $00000002;       { TAPI v2.0 }
  LINEINITIALIZEEXOPTION_USECOMPLETIONPORT = $00000003;       { TAPI v2.0 }

  LINELOCATIONOPTION_PULSEDIAL = $00000001;       { TAPI v1.4 }

  LINEMAPPER = $FFFFFFFF;

  LINEMEDIACONTROL_NONE = $00000001;
  LINEMEDIACONTROL_START = $00000002;
  LINEMEDIACONTROL_RESET = $00000004;
  LINEMEDIACONTROL_PAUSE = $00000008;
  LINEMEDIACONTROL_RESUME = $00000010;
  LINEMEDIACONTROL_RATEUP = $00000020;
  LINEMEDIACONTROL_RATEDOWN = $00000040;
  LINEMEDIACONTROL_RATENORMAL = $00000080;
  LINEMEDIACONTROL_VOLUMEUP = $00000100;
  LINEMEDIACONTROL_VOLUMEDOWN = $00000200;
  LINEMEDIACONTROL_VOLUMENORMAL = $00000400;

  LINEMEDIAMODE_UNKNOWN = $00000002;
  LINEMEDIAMODE_INTERACTIVEVOICE = $00000004;
  LINEMEDIAMODE_AUTOMATEDVOICE = $00000008;
  LINEMEDIAMODE_DATAMODEM = $00000010;
  LINEMEDIAMODE_G3FAX = $00000020;
  LINEMEDIAMODE_TDD = $00000040;
  LINEMEDIAMODE_G4FAX = $00000080;
  LINEMEDIAMODE_DIGITALDATA = $00000100;
  LINEMEDIAMODE_TELETEX = $00000200;
  LINEMEDIAMODE_VIDEOTEX = $00000400;
  LINEMEDIAMODE_TELEX = $00000800;
  LINEMEDIAMODE_MIXED = $00001000;
  LINEMEDIAMODE_ADSI = $00002000;
  LINEMEDIAMODE_VOICEVIEW = $00004000;       { TAPI v1.4 }
  LAST_LINEMEDIAMODE = $00004000;

  LINEOFFERINGMODE_ACTIVE = $00000001;       { TAPI v1.4 }
  LINEOFFERINGMODE_INACTIVE = $00000002;       { TAPI v1.4 }

  LINEOPENOPTION_SINGLEADDRESS = $80000000;       { TAPI v2.0 }
  LINEOPENOPTION_PROXY = $40000000;       { TAPI v2.0 }

  LINEPARKMODE_DIRECTED = $00000001;
  LINEPARKMODE_NONDIRECTED = $00000002;

  LINEPROXYREQUEST_SETAGENTGROUP = $00000001;       { TAPI v2.0 }
  LINEPROXYREQUEST_SETAGENTSTATE = $00000002;       { TAPI v2.0 }
  LINEPROXYREQUEST_SETAGENTACTIVITY = $00000003;       { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTCAPS = $00000004;       { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTSTATUS = $00000005;       { TAPI v2.0 }
  LINEPROXYREQUEST_AGENTSPECIFIC = $00000006;       { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTACTIVITYLIST = $00000007;       { TAPI v2.0 }
  LINEPROXYREQUEST_GETAGENTGROUPLIST = $00000008;       { TAPI v2.0 }

  LINEREMOVEFROMCONF_NONE = $00000001;
  LINEREMOVEFROMCONF_LAST = $00000002;
  LINEREMOVEFROMCONF_ANY = $00000003;

  LINEREQUESTMODE_MAKECALL = $00000001;
  LINEREQUESTMODE_MEDIACALL = $00000002;
  LINEREQUESTMODE_DROP = $00000004;

  LAST_LINEREQUESTMODE = LINEREQUESTMODE_MEDIACALL;

  LINEROAMMODE_UNKNOWN = $00000001;
  LINEROAMMODE_UNAVAIL = $00000002;
  LINEROAMMODE_HOME = $00000004;
  LINEROAMMODE_ROAMA = $00000008;
  LINEROAMMODE_ROAMB = $00000010;

  LINESPECIALINFO_NOCIRCUIT = $00000001;
  LINESPECIALINFO_CUSTIRREG = $00000002;
  LINESPECIALINFO_REORDER = $00000004;
  LINESPECIALINFO_UNKNOWN = $00000008;
  LINESPECIALINFO_UNAVAIL = $00000010;

  LINETERMDEV_PHONE = $00000001;
  LINETERMDEV_HEADSET = $00000002;
  LINETERMDEV_SPEAKER = $00000004;

  LINETERMMODE_BUTTONS = $00000001;
  LINETERMMODE_LAMPS = $00000002;
  LINETERMMODE_DISPLAY = $00000004;
  LINETERMMODE_RINGER = $00000008;
  LINETERMMODE_HOOKSWITCH = $00000010;
  LINETERMMODE_MEDIATOLINE = $00000020;
  LINETERMMODE_MEDIAFROMLINE = $00000040;
  LINETERMMODE_MEDIABIDIRECT = $00000080;

  LINETERMSHARING_PRIVATE = $00000001;
  LINETERMSHARING_SHAREDEXCL = $00000002;
  LINETERMSHARING_SHAREDCONF = $00000004;

  LINETOLLLISTOPTION_ADD = $00000001;
  LINETOLLLISTOPTION_REMOVE = $00000002;

  LINETONEMODE_CUSTOM = $00000001;
  LINETONEMODE_RINGBACK = $00000002;
  LINETONEMODE_BUSY = $00000004;
  LINETONEMODE_BEEP = $00000008;
  LINETONEMODE_BILLING = $00000010;

  LINETRANSFERMODE_TRANSFER = $00000001;
  LINETRANSFERMODE_CONFERENCE = $00000002;

  LINETRANSLATEOPTION_CARDOVERRIDE = $00000001;
  LINETRANSLATEOPTION_CANCELCALLWAITING = $00000002;       { TAPI v1.4 }
  LINETRANSLATEOPTION_FORCELOCAL = $00000004;       { TAPI v1.4 }
  LINETRANSLATEOPTION_FORCELD = $00000008;       { TAPI v1.4 }
  LINETRANSLATERESULT_CANONICAL = $00000001;
  LINETRANSLATERESULT_INTERNATIONAL = $00000002;
  LINETRANSLATERESULT_LONGDISTANCE = $00000004;
  LINETRANSLATERESULT_LOCAL = $00000008;
  LINETRANSLATERESULT_INTOLLLIST = $00000010;
  LINETRANSLATERESULT_NOTINTOLLLIST = $00000020;
  LINETRANSLATERESULT_DIALBILLING = $00000040;
  LINETRANSLATERESULT_DIALQUIET = $00000080;
  LINETRANSLATERESULT_DIALDIALTONE = $00000100;
  LINETRANSLATERESULT_DIALPROMPT = $00000200;
  LINETRANSLATERESULT_VOICEDETECT = $00000400;       { TAPI v2.0 }

  PHONEBUTTONFUNCTION_UNKNOWN = $00000000;
  PHONEBUTTONFUNCTION_CONFERENCE = $00000001;
  PHONEBUTTONFUNCTION_TRANSFER = $00000002;
  PHONEBUTTONFUNCTION_DROP = $00000003;
  PHONEBUTTONFUNCTION_HOLD = $00000004;
  PHONEBUTTONFUNCTION_RECALL = $00000005;
  PHONEBUTTONFUNCTION_DISCONNECT = $00000006;
  PHONEBUTTONFUNCTION_CONNECT = $00000007;
  PHONEBUTTONFUNCTION_MSGWAITON = $00000008;
  PHONEBUTTONFUNCTION_MSGWAITOFF = $00000009;
  PHONEBUTTONFUNCTION_SELECTRING = $0000000A;
  PHONEBUTTONFUNCTION_ABBREVDIAL = $0000000B;
  PHONEBUTTONFUNCTION_FORWARD = $0000000C;
  PHONEBUTTONFUNCTION_PICKUP = $0000000D;
  PHONEBUTTONFUNCTION_RINGAGAIN = $0000000E;
  PHONEBUTTONFUNCTION_PARK = $0000000F;
  PHONEBUTTONFUNCTION_REJECT = $00000010;
  PHONEBUTTONFUNCTION_REDIRECT = $00000011;
  PHONEBUTTONFUNCTION_MUTE = $00000012;
  PHONEBUTTONFUNCTION_VOLUMEUP = $00000013;
  PHONEBUTTONFUNCTION_VOLUMEDOWN = $00000014;
  PHONEBUTTONFUNCTION_SPEAKERON = $00000015;
  PHONEBUTTONFUNCTION_SPEAKEROFF = $00000016;
  PHONEBUTTONFUNCTION_FLASH = $00000017;
  PHONEBUTTONFUNCTION_DATAON = $00000018;
  PHONEBUTTONFUNCTION_DATAOFF = $00000019;
  PHONEBUTTONFUNCTION_DONOTDISTURB = $0000001A;
  PHONEBUTTONFUNCTION_INTERCOM = $0000001B;
  PHONEBUTTONFUNCTION_BRIDGEDAPP = $0000001C;
  PHONEBUTTONFUNCTION_BUSY = $0000001D;
  PHONEBUTTONFUNCTION_CALLAPP = $0000001E;
  PHONEBUTTONFUNCTION_DATETIME = $0000001F;
  PHONEBUTTONFUNCTION_DIRECTORY = $00000020;
  PHONEBUTTONFUNCTION_COVER = $00000021;
  PHONEBUTTONFUNCTION_CALLID = $00000022;
  PHONEBUTTONFUNCTION_LASTNUM = $00000023;
  PHONEBUTTONFUNCTION_NIGHTSRV = $00000024;
  PHONEBUTTONFUNCTION_SENDCALLS = $00000025;
  PHONEBUTTONFUNCTION_MSGINDICATOR = $00000026;
  PHONEBUTTONFUNCTION_REPDIAL = $00000027;
  PHONEBUTTONFUNCTION_SETREPDIAL = $00000028;
  PHONEBUTTONFUNCTION_SYSTEMSPEED = $00000029;
  PHONEBUTTONFUNCTION_STATIONSPEED = $0000002A;
  PHONEBUTTONFUNCTION_CAMPON = $0000002B;
  PHONEBUTTONFUNCTION_SAVEREPEAT = $0000002C;
  PHONEBUTTONFUNCTION_QUEUECALL = $0000002D;
  PHONEBUTTONFUNCTION_NONE = $0000002E;

  PHONEBUTTONMODE_DUMMY = $00000001;
  PHONEBUTTONMODE_CALL = $00000002;
  PHONEBUTTONMODE_FEATURE = $00000004;
  PHONEBUTTONMODE_KEYPAD = $00000008;
  PHONEBUTTONMODE_LOCAL = $00000010;
  PHONEBUTTONMODE_DISPLAY = $00000020;

  PHONEBUTTONSTATE_UP = $00000001;
  PHONEBUTTONSTATE_DOWN = $00000002;
  PHONEBUTTONSTATE_UNKNOWN = $00000004;       { TAPI v1.4 }
  PHONEBUTTONSTATE_UNAVAIL = $00000008;       { TAPI v1.4 }

  PHONEERR_ALLOCATED = $90000001;
  PHONEERR_BADDEVICEID = $90000002;
  PHONEERR_INCOMPATIBLEAPIVERSION = $90000003;
  PHONEERR_INCOMPATIBLEEXTVERSION = $90000004;
  PHONEERR_INIFILECORRUPT = $90000005;
  PHONEERR_INUSE = $90000006;
  PHONEERR_INVALAPPHANDLE = $90000007;
  PHONEERR_INVALAPPNAME = $90000008;
  PHONEERR_INVALBUTTONLAMPID = $90000009;
  PHONEERR_INVALBUTTONMODE = $9000000A;
  PHONEERR_INVALBUTTONSTATE = $9000000B;
  PHONEERR_INVALDATAID = $9000000C;
  PHONEERR_INVALDEVICECLASS = $9000000D;
  PHONEERR_INVALEXTVERSION = $9000000E;
  PHONEERR_INVALHOOKSWITCHDEV = $9000000F;
  PHONEERR_INVALHOOKSWITCHMODE = $90000010;
  PHONEERR_INVALLAMPMODE = $90000011;
  PHONEERR_INVALPARAM = $90000012;
  PHONEERR_INVALPHONEHANDLE = $90000013;
  PHONEERR_INVALPHONESTATE = $90000014;
  PHONEERR_INVALPOINTER = $90000015;
  PHONEERR_INVALPRIVILEGE = $90000016;
  PHONEERR_INVALRINGMODE = $90000017;
  PHONEERR_NODEVICE = $90000018;
  PHONEERR_NODRIVER = $90000019;
  PHONEERR_NOMEM = $9000001A;
  PHONEERR_NOTOWNER = $9000001B;
  PHONEERR_OPERATIONFAILED = $9000001C;
  PHONEERR_OPERATIONUNAVAIL = $9000001D;
  PHONEERR_RESOURCEUNAVAIL = $9000001F;
  PHONEERR_REQUESTOVERRUN = $90000020;
  PHONEERR_STRUCTURETOOSMALL = $90000021;
  PHONEERR_UNINITIALIZED = $90000022;
  PHONEERR_REINIT = $90000023;

  PHONEFEATURE_GETBUTTONINFO = $00000001;       { TAPI v2.0 }
  PHONEFEATURE_GETDATA = $00000002;       { TAPI v2.0 }
  PHONEFEATURE_GETDISPLAY = $00000004;       { TAPI v2.0 }
  PHONEFEATURE_GETGAINHANDSET = $00000008;       { TAPI v2.0 }
  PHONEFEATURE_GETGAINSPEAKER = $00000010;       { TAPI v2.0 }
  PHONEFEATURE_GETGAINHEADSET = $00000020;       { TAPI v2.0 }
  PHONEFEATURE_GETHOOKSWITCHHANDSET = $00000040;       { TAPI v2.0 }
  PHONEFEATURE_GETHOOKSWITCHSPEAKER = $00000080;       { TAPI v2.0 }
  PHONEFEATURE_GETHOOKSWITCHHEADSET = $00000100;       { TAPI v2.0 }
  PHONEFEATURE_GETLAMP = $00000200;       { TAPI v2.0 }
  PHONEFEATURE_GETRING = $00000400;       { TAPI v2.0 }
  PHONEFEATURE_GETVOLUMEHANDSET = $00000800;       { TAPI v2.0 }
  PHONEFEATURE_GETVOLUMESPEAKER = $00001000;       { TAPI v2.0 }
  PHONEFEATURE_GETVOLUMEHEADSET = $00002000;       { TAPI v2.0 }
  PHONEFEATURE_SETBUTTONINFO = $00004000;       { TAPI v2.0 }
  PHONEFEATURE_SETDATA = $00008000;       { TAPI v2.0 }
  PHONEFEATURE_SETDISPLAY = $00010000;       { TAPI v2.0 }
  PHONEFEATURE_SETGAINHANDSET = $00020000;       { TAPI v2.0 }
  PHONEFEATURE_SETGAINSPEAKER = $00040000;       { TAPI v2.0 }
  PHONEFEATURE_SETGAINHEADSET = $00080000;       { TAPI v2.0 }
  PHONEFEATURE_SETHOOKSWITCHHANDSET = $00100000;       { TAPI v2.0 }
  PHONEFEATURE_SETHOOKSWITCHSPEAKER = $00200000;       { TAPI v2.0 }
  PHONEFEATURE_SETHOOKSWITCHHEADSET = $00400000;       { TAPI v2.0 }
  PHONEFEATURE_SETLAMP = $00800000;       { TAPI v2.0 }
  PHONEFEATURE_SETRING = $01000000;       { TAPI v2.0 }
  PHONEFEATURE_SETVOLUMEHANDSET = $02000000;       { TAPI v2.0 }
  PHONEFEATURE_SETVOLUMESPEAKER = $04000000;       { TAPI v2.0 }
  PHONEFEATURE_SETVOLUMEHEADSET = $08000000;       { TAPI v2.0 }

  PHONEHOOKSWITCHDEV_HANDSET = $00000001;
  PHONEHOOKSWITCHDEV_SPEAKER = $00000002;
  PHONEHOOKSWITCHDEV_HEADSET = $00000004;

  PHONEHOOKSWITCHMODE_ONHOOK = $00000001;
  PHONEHOOKSWITCHMODE_MIC = $00000002;
  PHONEHOOKSWITCHMODE_SPEAKER = $00000004;
  PHONEHOOKSWITCHMODE_MICSPEAKER = $00000008;
  PHONEHOOKSWITCHMODE_UNKNOWN = $00000010;

  PHONEINITIALIZEEXOPTION_USEHIDDENWINDOW = $00000001;       { TAPI v2.0 }
  PHONEINITIALIZEEXOPTION_USEEVENT = $00000002;       { TAPI v2.0 }
  PHONEINITIALIZEEXOPTION_USECOMPLETIONPORT = $00000003;       { TAPI v2.0 }

  PHONELAMPMODE_DUMMY = $00000001;
  PHONELAMPMODE_OFF = $00000002;
  PHONELAMPMODE_STEADY = $00000004;
  PHONELAMPMODE_WINK = $00000008;
  PHONELAMPMODE_FLASH = $00000010;
  PHONELAMPMODE_FLUTTER = $00000020;
  PHONELAMPMODE_BROKENFLUTTER = $00000040;
  PHONELAMPMODE_UNKNOWN = $00000080;

  PHONEPRIVILEGE_MONITOR = $00000001;
  PHONEPRIVILEGE_OWNER = $00000002;

  PHONESTATE_OTHER = $00000001;
  PHONESTATE_CONNECTED = $00000002;
  PHONESTATE_DISCONNECTED = $00000004;
  PHONESTATE_OWNER = $00000008;
  PHONESTATE_MONITORS = $00000010;
  PHONESTATE_DISPLAY = $00000020;
  PHONESTATE_LAMP = $00000040;
  PHONESTATE_RINGMODE = $00000080;
  PHONESTATE_RINGVOLUME = $00000100;
  PHONESTATE_HANDSETHOOKSWITCH = $00000200;
  PHONESTATE_HANDSETVOLUME = $00000400;
  PHONESTATE_HANDSETGAIN = $00000800;
  PHONESTATE_SPEAKERHOOKSWITCH = $00001000;
  PHONESTATE_SPEAKERVOLUME = $00002000;
  PHONESTATE_SPEAKERGAIN = $00004000;
  PHONESTATE_HEADSETHOOKSWITCH = $00008000;
  PHONESTATE_HEADSETVOLUME = $00010000;
  PHONESTATE_HEADSETGAIN = $00020000;
  PHONESTATE_SUSPEND = $00040000;
  PHONESTATE_RESUME = $00080000;
  PHONESTATE_DEVSPECIFIC = $00100000;
  PHONESTATE_REINIT = $00200000;
  PHONESTATE_CAPSCHANGE = $00400000;       { TAPI v1.4 }
  PHONESTATE_REMOVED = $00800000;       { TAPI v1.4 }

  PHONESTATUSFLAGS_CONNECTED = $00000001;
  PHONESTATUSFLAGS_SUSPENDED = $00000002;

  STRINGFORMAT_ASCII = $00000001;
  STRINGFORMAT_DBCS = $00000002;
  STRINGFORMAT_UNICODE = $00000003;
  STRINGFORMAT_BINARY = $00000004;

  TAPI_REPLY = WM_USER + 99;

  TAPIERR_CONNECTED = 0;
  TAPIERR_DROPPED = -(1);
  TAPIERR_NOREQUESTRECIPIENT = -(2);
  TAPIERR_REQUESTQUEUEFULL = -(3);
  TAPIERR_INVALDESTADDRESS = -(4);
  TAPIERR_INVALWINDOWHANDLE = -(5);
  TAPIERR_INVALDEVICECLASS = -(6);
  TAPIERR_INVALDEVICEID = -(7);
  TAPIERR_DEVICECLASSUNAVAIL = -(8);
  TAPIERR_DEVICEIDUNAVAIL = -(9);
  TAPIERR_DEVICEINUSE = -(10);
  TAPIERR_DESTBUSY = -(11);
  TAPIERR_DESTNOANSWER = -(12);
  TAPIERR_DESTUNAVAIL = -(13);
  TAPIERR_UNKNOWNWINHANDLE = -(14);
  TAPIERR_UNKNOWNREQUESTID = -(15);
  TAPIERR_REQUESTFAILED = -(16);
  TAPIERR_REQUESTCANCELLED = -(17);
  TAPIERR_INVALPOINTER = -(18);

  TAPIMAXDESTADDRESSSIZE = 80;
  TAPIMAXAPPNAMESIZE = 40;
  TAPIMAXCALLEDPARTYSIZE = 40;
  TAPIMAXCOMMENTSIZE = 80;
  TAPIMAXDEVICECLASSSIZE = 40;
  TAPIMAXDEVICEIDSIZE = 40;

//*****************************************************************************
// types
//*****************************************************************************

type

  HCALL = HANDLE;
  LPHCALL = ^HCALL;

  HLINE = HANDLE;
  LPHLINE = ^HLINE;

  HPHONE = HANDLE;
  LPHPHONE = ^HPHONE;

  HLINEAPP = HANDLE;
  LPHLINEAPP = ^HLINEAPP;

  HPHONEAPP = HANDLE;
  LPHPHONEAPP = ^HPHONEAPP;

  LINECALLBACK = procedure (hDevice:DWORD; dwMessage:DWORD; dwInstance:DWORD; dwParam1:DWORD; dwParam2:DWORD;
                 dwParam3:DWORD);

  PHONECALLBACK = procedure (hDevice:DWORD; dwMessage:DWORD; dwInstance:DWORD; dwParam1:DWORD; dwParam2:DWORD;
                  dwParam3:DWORD);

  lineaddresscaps_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwLineDeviceID : DWORD;
       dwAddressSize : DWORD;
       dwAddressOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;
       dwAddressSharing : DWORD;
       dwAddressStates : DWORD;
       dwCallInfoStates : DWORD;
       dwCallerIDFlags : DWORD;
       dwCalledIDFlags : DWORD;
       dwConnectedIDFlags : DWORD;
       dwRedirectionIDFlags : DWORD;
       dwRedirectingIDFlags : DWORD;
       dwCallStates : DWORD;
       dwDialToneModes : DWORD;
       dwBusyModes : DWORD;
       dwSpecialInfo : DWORD;
       dwDisconnectModes : DWORD;
       dwMaxNumActiveCalls : DWORD;
       dwMaxNumOnHoldCalls : DWORD;
       dwMaxNumOnHoldPendingCalls : DWORD;
       dwMaxNumConference : DWORD;
       dwMaxNumTransConf : DWORD;
       dwAddrCapFlags : DWORD;
       dwCallFeatures : DWORD;
       dwRemoveFromConfCaps : DWORD;
       dwRemoveFromConfState : DWORD;
       dwTransferModes : DWORD;
       dwParkModes : DWORD;
       dwForwardModes : DWORD;
       dwMaxForwardEntries : DWORD;
       dwMaxSpecificEntries : DWORD;
       dwMinFwdNumRings : DWORD;
       dwMaxFwdNumRings : DWORD;
       dwMaxCallCompletions : DWORD;
       dwCallCompletionConds : DWORD;
       dwCallCompletionModes : DWORD;
       dwNumCompletionMessages : DWORD;
       dwCompletionMsgTextEntrySize : DWORD;
       dwCompletionMsgTextSize : DWORD;
       dwCompletionMsgTextOffset : DWORD;

       dwAddressFeatures : DWORD; // TAPI v1.4

       dwPredictiveAutoTransferStates : DWORD; // TAPI v2.0
       dwNumCallTreatments : DWORD;            // TAPI v2.0
       dwCallTreatmentListSize : DWORD;        // TAPI v2.0
       dwCallTreatmentListOffset : DWORD;      // TAPI v2.0
       dwDeviceClassesSize : DWORD;            // TAPI v2.0
       dwDeviceClassesOffset : DWORD;          // TAPI v2.0
       dwMaxCallDataSize : DWORD;              // TAPI v2.0
       dwCallFeatures2 : DWORD;                // TAPI v2.0
       dwMaxNoAnswerTimeout : DWORD;           // TAPI v2.0
       dwConnectedModes : DWORD;               // TAPI v2.0
       dwOfferingModes : DWORD;                // TAPI v2.0
       dwAvailableMediaModes : DWORD;          // TAPI v2.0
    end;
  TLINEADDRESSCAPS = lineaddresscaps_tag;
  LPLINEADDRESSCAPS = ^lineaddresscaps_tag;

  lineaddressstatus_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwNumInUse : DWORD;
       dwNumActiveCalls : DWORD;
       dwNumOnHoldCalls : DWORD;
       dwNumOnHoldPendCalls : DWORD;
       dwAddressFeatures : DWORD;
       dwNumRingsNoAnswer : DWORD;
       dwForwardNumEntries : DWORD;
       dwForwardSize : DWORD;
       dwForwardOffset : DWORD;
       dwTerminalModesSize : DWORD;
       dwTerminalModesOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;
    end;
  TLINEADDRESSSTATUS = lineaddressstatus_tag;
  LPLINEADDRESSSTATUS = ^lineaddressstatus_tag;

  linedialparams_tag = record
       dwDialPause : DWORD;
       dwDialSpeed : DWORD;
       dwDigitDuration : DWORD;
       dwWaitForDialtone : DWORD;
    end;
  TLINEDIALPARAMS = linedialparams_tag;
  LPLINEDIALPARAMS = ^linedialparams_tag;

  linecallinfo_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       hLine : HLINE;
       dwLineDeviceID : DWORD;
       dwAddressID : DWORD;
       dwBearerMode : DWORD;
       dwRate : DWORD;
       dwMediaMode : DWORD;
       dwAppSpecific : DWORD;
       dwCallID : DWORD;
       dwRelatedCallID : DWORD;
       dwCallParamFlags : DWORD;
       dwCallStates : DWORD;
       dwMonitorDigitModes : DWORD;
       dwMonitorMediaModes : DWORD;
       DialParams : TLINEDIALPARAMS;
       dwOrigin : DWORD;
       dwReason : DWORD;
       dwCompletionID : DWORD;
       dwNumOwners : DWORD;
       dwNumMonitors : DWORD;
       dwCountryCode : DWORD;
       dwTrunk : DWORD;
       dwCallerIDFlags : DWORD;
       dwCallerIDSize : DWORD;
       dwCallerIDOffset : DWORD;
       dwCallerIDNameSize : DWORD;
       dwCallerIDNameOffset : DWORD;
       dwCalledIDFlags : DWORD;
       dwCalledIDSize : DWORD;
       dwCalledIDOffset : DWORD;
       dwCalledIDNameSize : DWORD;
       dwCalledIDNameOffset : DWORD;
       dwConnectedIDFlags : DWORD;
       dwConnectedIDSize : DWORD;
       dwConnectedIDOffset : DWORD;
       dwConnectedIDNameSize : DWORD;
       dwConnectedIDNameOffset : DWORD;
       dwRedirectionIDFlags : DWORD;
       dwRedirectionIDSize : DWORD;
       dwRedirectionIDOffset : DWORD;
       dwRedirectionIDNameSize : DWORD;
       dwRedirectionIDNameOffset : DWORD;
       dwRedirectingIDFlags : DWORD;
       dwRedirectingIDSize : DWORD;
       dwRedirectingIDOffset : DWORD;
       dwRedirectingIDNameSize : DWORD;
       dwRedirectingIDNameOffset : DWORD;
       dwAppNameSize : DWORD;
       dwAppNameOffset : DWORD;
       dwDisplayableAddressSize : DWORD;
       dwDisplayableAddressOffset : DWORD;
       dwCalledPartySize : DWORD;
       dwCalledPartyOffset : DWORD;
       dwCommentSize : DWORD;
       dwCommentOffset : DWORD;
       dwDisplaySize : DWORD;
       dwDisplayOffset : DWORD;
       dwUserUserInfoSize : DWORD;
       dwUserUserInfoOffset : DWORD;
       dwHighLevelCompSize : DWORD;
       dwHighLevelCompOffset : DWORD;
       dwLowLevelCompSize : DWORD;
       dwLowLevelCompOffset : DWORD;
       dwChargingInfoSize : DWORD;
       dwChargingInfoOffset : DWORD;
       dwTerminalModesSize : DWORD;
       dwTerminalModesOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;
       dwCallTreatment : DWORD;                // TAPI v2.0
       dwCallDataSize : DWORD;                 // TAPI v2.0
       dwCallDataOffset : DWORD;               // TAPI v2.0
       dwSendingFlowspecSize : DWORD;          // TAPI v2.0
       dwSendingFlowspecOffset : DWORD;        // TAPI v2.0
       dwReceivingFlowspecSize : DWORD;        // TAPI v2.0
       dwReceivingFlowspecOffset : DWORD;      // TAPI v2.0
       dwAddressType : DWORD;                  // TAPI v3.0
    end;
  TLINECALLINFO = linecallinfo_tag;
  LPLINECALLINFO = ^linecallinfo_tag;

  linecalllist_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwCallsNumEntries : DWORD;
       dwCallsSize : DWORD;
       dwCallsOffset : DWORD;
    end;
  TLINECALLLIST = linecalllist_tag;
  LPLINECALLLIST = ^linecalllist_tag;

  linecallparams_tag = record                 // Defaults:
       dwTotalSize : DWORD;
       dwBearerMode : DWORD;                  // voice
       dwMinRate : DWORD;                     // (3.1kHz)
       dwMaxRate : DWORD;                     // (3.1kHz)
       dwMediaMode : DWORD;                   // interactiveVoice
       dwCallParamFlags : DWORD;              // 0
       dwAddressMode : DWORD;
       dwAddressID : DWORD;                   // (any available)
       DialParams : TLINEDIALPARAMS;           // (0, 0, 0, 0)
       dwOrigAddressSize : DWORD;             // 0
       dwOrigAddressOffset : DWORD;
       dwDisplayableAddressSize : DWORD;
       dwDisplayableAddressOffset : DWORD;
       dwCalledPartySize : DWORD;             // 0
       dwCalledPartyOffset : DWORD;
       dwCommentSize : DWORD;                 // 0
       dwCommentOffset : DWORD;
       dwUserUserInfoSize : DWORD;            // 0
       dwUserUserInfoOffset : DWORD;
       dwHighLevelCompSize : DWORD;           // 0
       dwHighLevelCompOffset : DWORD;
       dwLowLevelCompSize : DWORD;            // 0
       dwLowLevelCompOffset : DWORD;
       dwDevSpecificSize : DWORD;             // 0
       dwDevSpecificOffset : DWORD;
       dwPredictiveAutoTransferStates : DWORD;      // TAPI v2.0
       dwTargetAddressSize : DWORD;                 // TAPI v2.0
       dwTargetAddressOffset : DWORD;               // TAPI v2.0
       dwSendingFlowspecSize : DWORD;               // TAPI v2.0
       dwSendingFlowspecOffset : DWORD;             // TAPI v2.0
       dwReceivingFlowspecSize : DWORD;             // TAPI v2.0
       dwReceivingFlowspecOffset : DWORD;           // TAPI v2.0
       dwDeviceClassSize : DWORD;                   // TAPI v2.0
       dwDeviceClassOffset : DWORD;                 // TAPI v2.0
       dwDeviceConfigSize : DWORD;                  // TAPI v2.0
       dwDeviceConfigOffset : DWORD;                // TAPI v2.0
       dwCallDataSize : DWORD;                      // TAPI v2.0
       dwCallDataOffset : DWORD;                    // TAPI v2.0
       dwNoAnswerTimeout : DWORD;                   // TAPI v2.0
       dwCallingPartyIDSize : DWORD;                // TAPI v2.0
       dwCallingPartyIDOffset : DWORD;              // TAPI v2.0
       dwAddressType : DWORD;                       // TAPI v3.0
    end;
  TLINECALLPARAMS = linecallparams_tag;
  LPLINECALLPARAMS = ^linecallparams_tag;

  linecallstatus_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwCallState : DWORD;
       dwCallStateMode : DWORD;
       dwCallPrivilege : DWORD;
       dwCallFeatures : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;

       dwCallFeatures2 : DWORD;                    // TAPI v2.0
       tStateEntryTime : SYSTEMTIME;               // TAPI v2.0
    end;
  TLINECALLSTATUS = linecallstatus_tag;
  LPLINECALLSTATUS = ^linecallstatus_tag;

  linecalltreatmententry_tag = record
       dwCallTreatmentID : DWORD;                  // TAPI v2.0
       dwCallTreatmentNameSize : DWORD;            // TAPI v2.0
       dwCallTreatmentNameOffset : DWORD;          // TAPI v2.0
    end;
  TLINECALLTREATMENTENTRY = linecalltreatmententry_tag;
  LPLINECALLTREATMENTENTRY = ^linecalltreatmententry_tag;

  linecardentry_tag = record
       dwPermanentCardID : DWORD;
       dwCardNameSize : DWORD;
       dwCardNameOffset : DWORD;
       dwCardNumberDigits : DWORD;                // TAPI v1.4
       dwSameAreaRuleSize : DWORD;                // TAPI v1.4
       dwSameAreaRuleOffset : DWORD;              // TAPI v1.4
       dwLongDistanceRuleSize : DWORD;            // TAPI v1.4
       dwLongDistanceRuleOffset : DWORD;          // TAPI v1.4
       dwInternationalRuleSize : DWORD;           // TAPI v1.4
       dwInternationalRuleOffset : DWORD;         // TAPI v1.4
       dwOptions : DWORD;                         // TAPI v1.4
    end;
  TLINECARDENTRY = linecardentry_tag;
  LPLINECARDENTRY = ^linecardentry_tag;

  linecountryentry_tag = record                   // TAPI v1.4
       dwCountryID : DWORD;                       // TAPI v1.4
       dwCountryCode : DWORD;                     // TAPI v1.4
       dwNextCountryID : DWORD;                   // TAPI v1.4
       dwCountryNameSize : DWORD;                 // TAPI v1.4
       dwCountryNameOffset : DWORD;               // TAPI v1.4
       dwSameAreaRuleSize : DWORD;                // TAPI v1.4
       dwSameAreaRuleOffset : DWORD;              // TAPI v1.4
       dwLongDistanceRuleSize : DWORD;            // TAPI v1.4
       dwLongDistanceRuleOffset : DWORD;          // TAPI v1.4
       dwInternationalRuleSize : DWORD;           // TAPI v1.4
       dwInternationalRuleOffset : DWORD;         // TAPI v1.4
    end;
  TLINECOUNTRYENTRY = linecountryentry_tag;
  LPLINECOUNTRYENTRY = ^linecountryentry_tag;

  linecountrylist_tag = record
       dwTotalSize : DWORD;                       // TAPI v1.4
       dwNeededSize : DWORD;                      // TAPI v1.4
       dwUsedSize : DWORD;                        // TAPI v1.4
       dwNumCountries : DWORD;                    // TAPI v1.4
       dwCountryListSize : DWORD;                 // TAPI v1.4
       dwCountryListOffset : DWORD;               // TAPI v1.4
    end;
  TLINECOUNTRYLIST = linecountrylist_tag;
  LPLINECOUNTRYLIST = ^linecountrylist_tag;

  linedevcaps_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwProviderInfoSize : DWORD;
       dwProviderInfoOffset : DWORD;
       dwSwitchInfoSize : DWORD;
       dwSwitchInfoOffset : DWORD;
       dwPermanentLineID : DWORD;
       dwLineNameSize : DWORD;
       dwLineNameOffset : DWORD;
       dwStringFormat : DWORD;
       dwAddressModes : DWORD;
       dwNumAddresses : DWORD;
       dwBearerModes : DWORD;
       dwMaxRate : DWORD;
       dwMediaModes : DWORD;
       dwGenerateToneModes : DWORD;
       dwGenerateToneMaxNumFreq : DWORD;
       dwGenerateDigitModes : DWORD;
       dwMonitorToneMaxNumFreq : DWORD;
       dwMonitorToneMaxNumEntries : DWORD;
       dwMonitorDigitModes : DWORD;
       dwGatherDigitsMinTimeout : DWORD;
       dwGatherDigitsMaxTimeout : DWORD;
       dwMedCtlDigitMaxListSize : DWORD;
       dwMedCtlMediaMaxListSize : DWORD;
       dwMedCtlToneMaxListSize : DWORD;
       dwMedCtlCallStateMaxListSize : DWORD;
       dwDevCapFlags : DWORD;
       dwMaxNumActiveCalls : DWORD;
       dwAnswerMode : DWORD;
       dwRingModes : DWORD;
       dwLineStates : DWORD;
       dwUUIAcceptSize : DWORD;
       dwUUIAnswerSize : DWORD;
       dwUUIMakeCallSize : DWORD;
       dwUUIDropSize : DWORD;
       dwUUISendUserUserInfoSize : DWORD;
       dwUUICallInfoSize : DWORD;
       MinDialParams : TLINEDIALPARAMS;
       MaxDialParams : TLINEDIALPARAMS;
       DefaultDialParams : TLINEDIALPARAMS;
       dwNumTerminals : DWORD;
       dwTerminalCapsSize : DWORD;
       dwTerminalCapsOffset : DWORD;
       dwTerminalTextEntrySize : DWORD;
       dwTerminalTextSize : DWORD;
       dwTerminalTextOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;

       dwLineFeatures : DWORD;                    // TAPI v1.4

       dwSettableDevStatus : DWORD;               // TAPI v2.0
       dwDeviceClassesSize : DWORD;               // TAPI v2.0
       dwDeviceClassesOffset : DWORD;             // TAPI v2.0
       PermanentLineGuid : GUID;                  // TAPI v2.2
       dwAddressTypes : DWORD;                    // TAPI v3.0
       ProtocolGuid : GUID;                       // TAPI v3.0
       dwAvailableTracking : DWORD;               // TAPI v3.0
    end;
  TLINEDEVCAPS = linedevcaps_tag;
  LPLINEDEVCAPS = ^linedevcaps_tag;

  linedevstatus_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwNumOpens : DWORD;
       dwOpenMediaModes : DWORD;
       dwNumActiveCalls : DWORD;
       dwNumOnHoldCalls : DWORD;
       dwNumOnHoldPendCalls : DWORD;
       dwLineFeatures : DWORD;
       dwNumCallCompletions : DWORD;
       dwRingMode : DWORD;
       dwSignalLevel : DWORD;
       dwBatteryLevel : DWORD;
       dwRoamMode : DWORD;
       dwDevStatusFlags : DWORD;
       dwTerminalModesSize : DWORD;
       dwTerminalModesOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;

       dwAvailableMediaModes : DWORD;             // TAPI v2.0
       dwAppInfoSize : DWORD;                     // TAPI v2.0
       dwAppInfoOffset : DWORD;                   // TAPI v2.0
    end;
  LINEDEVSTATUS = linedevstatus_tag;
  LPLINEDEVSTATUS = ^linedevstatus_tag;

  lineextensionid_tag = record
       dwExtensionID0 : DWORD;
       dwExtensionID1 : DWORD;
       dwExtensionID2 : DWORD;
       dwExtensionID3 : DWORD;
    end;
  TLINEEXTENSIONID = lineextensionid_tag;
  LPLINEEXTENSIONID = ^lineextensionid_tag;

  lineforward_tag = record
       dwForwardMode : DWORD;
       dwCallerAddressSize : DWORD;
       dwCallerAddressOffset : DWORD;
       dwDestCountryCode : DWORD;
       dwDestAddressSize : DWORD;
       dwDestAddressOffset : DWORD;
    end;
  TLINEFORWARD = lineforward_tag;
  LPLINEFORWARD = ^lineforward_tag;

  lineforwardlist_tag = record
       dwTotalSize : DWORD;
       dwNumEntries : DWORD;
       ForwardList : array[0..0] of TLINEFORWARD;
    end;
  TLINEFORWARDLIST = lineforwardlist_tag;
  LPLINEFORWARDLIST = ^lineforwardlist_tag;

  linegeneratetone_tag = record
       dwFrequency : DWORD;
       dwCadenceOn : DWORD;
       dwCadenceOff : DWORD;
       dwVolume : DWORD;
    end;
  TLINEGENERATETONE = linegeneratetone_tag;
  LPLINEGENERATETONE = ^linegeneratetone_tag;

  lineinitializeexparams_tag = record
       dwTotalSize : DWORD;                       // TAPI v2.0
       dwNeededSize : DWORD;                      // TAPI v2.0
       dwUsedSize : DWORD;                        // TAPI v2.0
       dwOptions : DWORD;                         // TAPI v2.0

       Handles : record
           case longint of
              0 : ( hEvent : HANDLE );            // TAPI v2.0
              1 : ( hCompletionPort : HANDLE );   // TAPI v2.0
           end;
       dwCompletionKey : DWORD;                   // TAPI v2.0
    end;
  TLINEINITIALIZEEXPARAMS = lineinitializeexparams_tag;
  LPLINEINITIALIZEEXPARAMS = ^lineinitializeexparams_tag;

  linelocationentry_tag = record
       dwPermanentLocationID : DWORD;
       dwLocationNameSize : DWORD;
       dwLocationNameOffset : DWORD;
       dwCountryCode : DWORD;
       dwCityCodeSize : DWORD;
       dwCityCodeOffset : DWORD;
       dwPreferredCardID : DWORD;

       dwLocalAccessCodeSize : DWORD;             // TAPI v1.4
       dwLocalAccessCodeOffset : DWORD;           // TAPI v1.4
       dwLongDistanceAccessCodeSize : DWORD;      // TAPI v1.4
       dwLongDistanceAccessCodeOffset : DWORD;    // TAPI v1.4
       dwTollPrefixListSize : DWORD;              // TAPI v1.4
       dwTollPrefixListOffset : DWORD;            // TAPI v1.4
       dwCountryID : DWORD;                       // TAPI v1.4
       dwOptions : DWORD;                         // TAPI v1.4
       dwCancelCallWaitingSize : DWORD;           // TAPI v1.4
       dwCancelCallWaitingOffset : DWORD;         // TAPI v1.4
    end;
  TLINELOCATIONENTRY = linelocationentry_tag;
  LPLINELOCATIONENTRY = ^linelocationentry_tag;

  linemediacontrolcallstate_tag = record
       dwCallStates : DWORD;
       dwMediaControl : DWORD;
    end;
  TLINEMEDIACONTROLCALLSTATE = linemediacontrolcallstate_tag;
  LPLINEMEDIACONTROLCALLSTATE = ^linemediacontrolcallstate_tag;

  linemediacontroldigit_tag = record
       dwDigit : DWORD;
       dwDigitModes : DWORD;
       dwMediaControl : DWORD;
    end;
  TLINEMEDIACONTROLDIGIT = linemediacontroldigit_tag;
  LPLINEMEDIACONTROLDIGIT = ^linemediacontroldigit_tag;

  linemediacontrolmedia_tag = record
       dwMediaModes : DWORD;
       dwDuration : DWORD;
       dwMediaControl : DWORD;
    end;
  TLINEMEDIACONTROLMEDIA = linemediacontrolmedia_tag;
  LPLINEMEDIACONTROLMEDIA = ^linemediacontrolmedia_tag;

  linemediacontroltone_tag = record
       dwAppSpecific : DWORD;
       dwDuration : DWORD;
       dwFrequency1 : DWORD;
       dwFrequency2 : DWORD;
       dwFrequency3 : DWORD;
       dwMediaControl : DWORD;
    end;
  TLINEMEDIACONTROLTONE = linemediacontroltone_tag;
  LPLINEMEDIACONTROLTONE = ^linemediacontroltone_tag;

  linemessage_tag = record
       hDevice : DWORD;                           // TAPI v2.0
       dwMessageID : DWORD;                       // TAPI v2.0
       dwCallbackInstance : DWORD;                // TAPI v2.0
       dwParam1 : DWORD;                          // TAPI v2.0
       dwParam2 : DWORD;                          // TAPI v2.0
       dwParam3 : DWORD;                          // TAPI v2.0
    end;
  TLINEMESSAGE = linemessage_tag;
  LPLINEMESSAGE = ^linemessage_tag;

  linemonitortone_tag = record
       dwAppSpecific : DWORD;
       dwDuration : DWORD;
       dwFrequency1 : DWORD;
       dwFrequency2 : DWORD;
       dwFrequency3 : DWORD;
    end;
  TLINEMONITORTONE = linemonitortone_tag;
  LPLINEMONITORTONE = ^linemonitortone_tag;

  lineproviderentry_tag = record
       dwPermanentProviderID : DWORD;             // TAPI v1.4
       dwProviderFilenameSize : DWORD;            // TAPI v1.4
       dwProviderFilenameOffset : DWORD;          // TAPI v1.4
    end;
  TLINEPROVIDERENTRY = lineproviderentry_tag;
  LPLINEPROVIDERENTRY = ^lineproviderentry_tag;

  lineproviderlist_tag = record
       dwTotalSize : DWORD;                       // TAPI v1.4
       dwNeededSize : DWORD;                      // TAPI v1.4
       dwUsedSize : DWORD;                        // TAPI v1.4
       dwNumProviders : DWORD;                    // TAPI v1.4
       dwProviderListSize : DWORD;                // TAPI v1.4
       dwProviderListOffset : DWORD;              // TAPI v1.4
    end;
  TLINEPROVIDERLIST = lineproviderlist_tag;
  LPLINEPROVIDERLIST = ^lineproviderlist_tag;

  linetermcaps_tag = record
       dwTermDev : DWORD;
       dwTermModes : DWORD;
       dwTermSharing : DWORD;
    end;
  TLINETERMCAPS = linetermcaps_tag;
  LPLINETERMCAPS = ^linetermcaps_tag;

  linetranslatecaps_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwNumLocations : DWORD;
       dwLocationListSize : DWORD;
       dwLocationListOffset : DWORD;
       dwCurrentLocationID : DWORD;
       dwNumCards : DWORD;
       dwCardListSize : DWORD;
       dwCardListOffset : DWORD;
       dwCurrentPreferredCardID : DWORD;
    end;
  TLINETRANSLATECAPS = linetranslatecaps_tag;
  LPLINETRANSLATECAPS = ^linetranslatecaps_tag;

  linetranslateoutput_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwDialableStringSize : DWORD;
       dwDialableStringOffset : DWORD;
       dwDisplayableStringSize : DWORD;
       dwDisplayableStringOffset : DWORD;
       dwCurrentCountry : DWORD;
       dwDestCountry : DWORD;
       dwTranslateResults : DWORD;
    end;
  TLINETRANSLATEOUTPUT = linetranslateoutput_tag;
  LPLINETRANSLATEOUTPUT = ^linetranslateoutput_tag;

  phonebuttoninfo_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwButtonMode : DWORD;
       dwButtonFunction : DWORD;
       dwButtonTextSize : DWORD;
       dwButtonTextOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;

       dwButtonState : DWORD;                     // TAPI v1.4
    end;
  TPHONEBUTTONINFO = phonebuttoninfo_tag;
  LPPHONEBUTTONINFO = ^phonebuttoninfo_tag;

  phonecaps_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwProviderInfoSize : DWORD;
       dwProviderInfoOffset : DWORD;
       dwPhoneInfoSize : DWORD;
       dwPhoneInfoOffset : DWORD;
       dwPermanentPhoneID : DWORD;
       dwPhoneNameSize : DWORD;
       dwPhoneNameOffset : DWORD;
       dwStringFormat : DWORD;
       dwPhoneStates : DWORD;
       dwHookSwitchDevs : DWORD;
       dwHandsetHookSwitchModes : DWORD;
       dwSpeakerHookSwitchModes : DWORD;
       dwHeadsetHookSwitchModes : DWORD;
       dwVolumeFlags : DWORD;
       dwGainFlags : DWORD;
       dwDisplayNumRows : DWORD;
       dwDisplayNumColumns : DWORD;
       dwNumRingModes : DWORD;
       dwNumButtonLamps : DWORD;
       dwButtonModesSize : DWORD;
       dwButtonModesOffset : DWORD;
       dwButtonFunctionsSize : DWORD;
       dwButtonFunctionsOffset : DWORD;
       dwLampModesSize : DWORD;
       dwLampModesOffset : DWORD;
       dwNumSetData : DWORD;
       dwSetDataSize : DWORD;
       dwSetDataOffset : DWORD;
       dwNumGetData : DWORD;
       dwGetDataSize : DWORD;
       dwGetDataOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;
       dwDeviceClassesSize : DWORD;               // TAPI v2.0
       dwDeviceClassesOffset : DWORD;             // TAPI v2.0
       dwPhoneFeatures : DWORD;                   // TAPI v2.0
       dwSettableHandsetHookSwitchModes : DWORD;  // TAPI v2.0
       dwSettableSpeakerHookSwitchModes : DWORD;  // TAPI v2.0
       dwSettableHeadsetHookSwitchModes : DWORD;  // TAPI v2.0
       dwMonitoredHandsetHookSwitchModes : DWORD; // TAPI v2.0
       dwMonitoredSpeakerHookSwitchModes : DWORD; // TAPI v2.0
       dwMonitoredHeadsetHookSwitchModes : DWORD; // TAPI v2.0
       PermanentPhoneGuid : GUID;                 // TAPI v2.2
    end;
  TPHONECAPS = phonecaps_tag;
  LPPHONECAPS = ^phonecaps_tag;

  phoneextensionid_tag = record
       dwExtensionID0 : DWORD;
       dwExtensionID1 : DWORD;
       dwExtensionID2 : DWORD;
       dwExtensionID3 : DWORD;
    end;
  TPHONEEXTENSIONID = phoneextensionid_tag;
  LPPHONEEXTENSIONID = ^phoneextensionid_tag;

  phoneinitializeexparams_tag = record
       dwTotalSize : DWORD;                       // TAPI v2.0
       dwNeededSize : DWORD;                      // TAPI v2.0
       dwUsedSize : DWORD;                        // TAPI v2.0
       dwOptions : DWORD;                         // TAPI v2.0

       Handles : record
           case longint of
              0 : ( hEvent : HANDLE );            // TAPI v2.0
              1 : ( hCompletionPort : HANDLE );   // TAPI v2.0
           end;

       dwCompletionKey : DWORD;                   // TAPI v2.0
    end;
  TPHONEINITIALIZEEXPARAMS = phoneinitializeexparams_tag;
  LPPHONEINITIALIZEEXPARAMS = ^phoneinitializeexparams_tag;

  phonemessage_tag = record
       hDevice : DWORD;                           // TAPI v2.0
       dwMessageID : DWORD;                       // TAPI v2.0
       dwCallbackInstance : DWORD;                // TAPI v2.0
       dwParam1 : DWORD;                          // TAPI v2.0
       dwParam2 : DWORD;                          // TAPI v2.0
       dwParam3 : DWORD;                          // TAPI v2.0
    end;
  TPHONEMESSAGE = phonemessage_tag;
  LPPHONEMESSAGE = ^phonemessage_tag;

  phonestatus_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwStatusFlags : DWORD;
       dwNumOwners : DWORD;
       dwNumMonitors : DWORD;
       dwRingMode : DWORD;
       dwRingVolume : DWORD;
       dwHandsetHookSwitchMode : DWORD;
       dwHandsetVolume : DWORD;
       dwHandsetGain : DWORD;
       dwSpeakerHookSwitchMode : DWORD;
       dwSpeakerVolume : DWORD;
       dwSpeakerGain : DWORD;
       dwHeadsetHookSwitchMode : DWORD;
       dwHeadsetVolume : DWORD;
       dwHeadsetGain : DWORD;
       dwDisplaySize : DWORD;
       dwDisplayOffset : DWORD;
       dwLampModesSize : DWORD;
       dwLampModesOffset : DWORD;
       dwOwnerNameSize : DWORD;
       dwOwnerNameOffset : DWORD;
       dwDevSpecificSize : DWORD;
       dwDevSpecificOffset : DWORD;

       dwPhoneFeatures : DWORD;                   // TAPI v2.0
    end;
  TPHONESTATUS = phonestatus_tag;
  LPPHONESTATUS = ^phonestatus_tag;

  varstring_tag = record
       dwTotalSize : DWORD;
       dwNeededSize : DWORD;
       dwUsedSize : DWORD;
       dwStringFormat : DWORD;
       dwStringSize : DWORD;
       dwStringOffset : DWORD;
    end;
  TVARSTRING = varstring_tag;
  LPVARSTRING = ^varstring_tag;

//*****************************************************************************
// functions
//*****************************************************************************

function lineAccept(hCall:HCALL; lpsUserUserInfo:LPCSTR; dwSize:DWORD):LONG;external KernelDLL name 'lineAccept';
function lineAddProvider(lpszProviderFilename:LPCWSTR; hwndOwner:HWND;
 lpdwPermanentProviderID:LPDWORD):LONG;external KernelDLL name 'lineAddProvider';
function lineAddToConference(hConfCall:HCALL; hConsultCall:HCALL):LONG;external KernelDLL name 'lineAddToConference';
function lineAnswer(hCall:HCALL; lpsUserUserInfo:LPCSTR; dwSize:DWORD):LONG;external KernelDLL name 'lineAnswer';
function lineBlindTransfer(hCall:HCALL; lpszDestAddressW:LPCWSTR;
 dwCountryCode:DWORD):LONG;external KernelDLL name 'lineBlindTransfer';
function lineClose(hLine:HLINE):LONG;external KernelDLL name 'lineClose';
function lineCompleteTransfer(hCall:HCALL; hConsultCall:HCALL; lphConfCall:LPHCALL;
 dwTransferMode:DWORD):LONG;external KernelDLL name 'lineCompleteTransfer';
function lineConfigDialogEdit(dwDeviceID:DWORD; hwndOwner:HWND; lpszDeviceClass:LPCWSTR; lpDeviceConfigIn:LPVOID;
 dwSize:DWORD; lpDeviceConfigOut:LPVARSTRING):LONG;external KernelDLL name 'lineConfigDialogEdit';
function lineDeallocateCall(hCall:HCALL):LONG;external KernelDLL name 'lineDeallocateCall';
function lineDevSpecific(hLine:HLINE; dwAddressID:DWORD; hCall:HCALL; lpParams:LPVOID;
 dwSize:DWORD):LONG;external KernelDLL name 'lineDevSpecific';
function lineDial(hCall:HCALL; lpszDestAddress:LPCWSTR; dwCountryCode:DWORD):LONG;external KernelDLL name 'lineDial';
function lineDrop(hCall:HCALL; lpsUserUserInfo:LPCSTR; dwSize:DWORD):LONG;external KernelDLL name 'lineDrop';
function lineForward(hLine:HLINE; bAllAddresses:DWORD; dwAddressID:DWORD; lpForwardList:LPLINEFORWARDLIST;
 dwNumRingsNoAnswer:DWORD; lphConsultCall:LPHCALL; lpCallParams:LPLINECALLPARAMS):LONG;external KernelDLL name 'lineForward';
function lineGenerateDigits(hCall:HCALL; dwDigitMode:DWORD; lpszDigits:LPCWSTR;  dwDuration:DWORD):LONG;
 external KernelDLL name 'lineGenerateDigits';
function lineGenerateTone(hCall:HCALL; dwToneMode:DWORD; dwDuration:DWORD; dwNumTones:DWORD; lpTones:LPLINEGENERATETONE):LONG;
 external KernelDLL name 'lineGenerateTone';
function lineGetAddressCaps(hLineApp:HLINEAPP; dwDeviceID:DWORD; dwAddressID:DWORD; dwAPIVersion:DWORD;
 dwExtVersion:DWORD; lpAddressCaps:LPLINEADDRESSCAPS):LONG;external KernelDLL name 'lineGetAddressCaps';
function lineGetAddressID(hLine:HLINE; lpdwAddressID:LPDWORD; dwAddressMode:DWORD; lpsAddress:LPCWSTR;
 dwSize:DWORD):LONG;external KernelDLL name 'lineGetAddressID';
function tAddressStatus(hLine:HLINE; dwAddressID:DWORD;  lpAddressStatus:LPLINEADDRESSSTATUS):LONG;
 external KernelDLL name 'lineGetAddressStatus';
function lineGetAppPriority(lpszAppFilename:LPCWSTR; dwMediaMode:DWORD; lpExtensionID:LPLINEEXTENSIONID;
 dwRequestMode:DWORD; lpExtensionName:LPVARSTRING; lpdwPriority:LPDWORD):LONG;external KernelDLL name 'lineGetAppPriority'; { TAPI v1.4 }
function lineGetCallInfo(hCall:HCALL; lpCallInfo:LPLINECALLINFO):LONG;external KernelDLL name 'lineGetCallInfo';
function lineGetCallStatus(hCall:HCALL; lpCallStatus:LPLINECALLSTATUS):LONG;external KernelDLL name 'lineGetCallStatus';
function lineGetConfRelatedCalls(hCall:HCALL; lpCallList:LPLINECALLLIST):LONG;external KernelDLL name 'lineGetConfRelatedCalls';
function lineGetDevCaps(hLineApp:HLINEAPP; dwDeviceID:DWORD; dwAPIVersion:DWORD; dwExtVersion:DWORD;
 lpLineDevCaps:LPLINEDEVCAPS):LONG;external KernelDLL name 'lineGetDevCaps';
function lineGetDevConfig(dwDeviceID:DWORD; lpDeviceConfig:LPVARSTRING; lpszDeviceClass:LPCWSTR):LONG;
 external KernelDLL name 'lineGetDevConfig';
function lineGetNewCalls(hLine:HLINE; dwAddressID:DWORD; dwSelect:DWORD; lpCallList:LPLINECALLLIST):LONG;
 external KernelDLL name 'lineGetNewCalls';
function lineGetIcon(dwDeviceID:DWORD; lpszDeviceClass:LPCWSTR; lphIcon:LPHICON):LONG;external KernelDLL name 'lineGetIcon';
function lineGetID(hLine:HLINE; dwAddressID:DWORD; hCall:HCALL; dwSelect:DWORD; lpDeviceID:LPVARSTRING;
               lpszDeviceClass:LPCWSTR):LONG;external KernelDLL name 'lineGetID';
function lineGetLineDevStatus(hLine:HLINE; lpLineDevStatus:LPLINEDEVSTATUS):LONG;external KernelDLL name 'lineGetLineDevStatus';
function lineGetMessage(hLineApp:HLINEAPP; lpMessage:LPLINEMESSAGE; dwTimeout:DWORD):LONG;external KernelDLL name 'lineGetMessage';
function lineGetNumRings(hLine:HLINE; dwAddressID:DWORD; lpdwNumRings:LPDWORD):LONG;external KernelDLL name 'lineGetNumRings';
function lineGetProviderList(dwAPIVersion:DWORD; lpProviderList:LPLINEPROVIDERLIST):LONG;
 external KernelDLL name 'lineGetProviderList'; { TAPI v1.4 }
function lineGetStatusMessages(hLine:HLINE; lpdwLineStates:LPDWORD; lpdwAddressStates:LPDWORD):LONG;
 external KernelDLL name 'lineGetStatusMessages';
function lineGetTranslateCaps(hLineApp:HLINEAPP; dwAPIVersion:DWORD; lpTranslateCaps:LPLINETRANSLATECAPS):LONG;
 external KernelDLL name 'lineGetTranslateCaps';
function lineHandoff(hCall:HCALL; lpszFileName:LPCWSTR; dwMediaMode:DWORD):LONG;external KernelDLL name 'lineHandoff';
function lineHold(hCall:HCALL):LONG;external KernelDLL name 'lineHold';
function lineInitialize(lphLineApp:LPHLINEAPP; hInstance:HINST; lpfnCallback:LINECALLBACK; lpszAppName:LPCWSTR;
 lpdwNumDevs:LPDWORD):LONG;external KernelDLL name 'lineInitialize';
function lineInitializeEx(lphLineApp:LPHLINEAPP; hInstance:HINST; lpfnCallback:LINECALLBACK; lpszFriendlyAppName:LPCWSTR;
 lpdwNumDevs:LPDWORD; lpdwAPIVersion:LPDWORD; lpLineInitializeExParams:LPLINEINITIALIZEEXPARAMS):LONG;
 external KernelDLL name 'lineInitializeEx';
function lineMakeCall(hLine:HLINE; lphCall:LPHCALL; lpszDestAddress:LPCWSTR; dwCountryCode:DWORD;
 lpCallParams:LPLINECALLPARAMS):LONG;external KernelDLL name 'lineMakeCall';
function lineMonitorDigits(hCall:HCALL; dwDigitModes:DWORD):LONG;external KernelDLL name 'lineMonitorDigits';
function lineMonitorMedia(hCall:HCALL; dwMediaModes:DWORD):LONG;external KernelDLL name 'lineMonitorMedia';
function lineNegotiateAPIVersion(hLineApp:HLINEAPP; dwDeviceID:DWORD; dwAPILowVersion:DWORD; dwAPIHighVersion:DWORD;
 lpdwAPIVersion:LPDWORD; lpExtensionID:LPLINEEXTENSIONID):LONG;external KernelDLL name 'lineNegotiateAPIVersion';
function lineNegotiateExtVersion(hLineApp:HLINEAPP; dwDeviceID:DWORD; dwAPIVersion:DWORD; dwExtLowVersion:DWORD;
 dwExtHighVersion:DWORD; lpdwExtVersion:LPDWORD):LONG;external KernelDLL name 'lineNegotiateExtVersion';
function lineOpen(hLineApp:HLINEAPP; dwDeviceID:DWORD; lphLine:LPHLINE; dwAPIVersion:DWORD; dwExtVersion:DWORD;
 dwCallbackInstance:DWORD; dwPrivileges:DWORD; dwMediaModes:DWORD; lpCallParams:LPLINECALLPARAMS):LONG;
 external KernelDLL name 'lineOpen';
function linePickup(hLine:HLINE; dwAddressID:DWORD; lphCall:LPHCALL; lpszDestAddress:LPCWSTR; lpszGroupID:LPCWSTR):LONG;
 external KernelDLL name 'linePickup';
function linePrepareAddToConference(hConfCall:HCALL; lphConsultCall:LPHCALL; lpCallParams:LPLINECALLPARAMS):LONG;
 external KernelDLL name 'linePrepareAddToConference';
function lineRedirect(hCall:HCALL; lpszDestAddress:LPCWSTR; dwCountryCode:DWORD):LONG;external KernelDLL name 'lineRedirect';
function lineReleaseUserUserInfo(hCall:HCALL):LONG;external KernelDLL name 'lineReleaseUserUserInfo'; { TAPI v1.4 }
function lineRemoveFromConference(hCall:HCALL):LONG;external KernelDLL name 'lineRemoveFromConference';
function lineSendUserUserInfo(hCall:HCALL; lpsUserUserInfo:LPCSTR; dwSize:DWORD):LONG;external KernelDLL name 'lineSendUserUserInfo';
function lineSetAppPriority(lpszAppFilename:LPCWSTR; dwMediaMode:DWORD; lpExtensionID:LPLINEEXTENSIONID; dwRequestMode:DWORD;
 lpszExtensionName:LPCWSTR; dwPriority:DWORD):LONG;external KernelDLL name 'lineSetAppPriority'; { TAPI v1.4 }
function lineSetCallParams(hCall:HCALL; dwBearerMode:DWORD; dwMinRate:DWORD; dwMaxRate:DWORD; lpDialParams:LPLINEDIALPARAMS):LONG;
 external KernelDLL name 'lineSetCallParams';
function lineSetCallPrivilege(hCall:HCALL; dwCallPrivilege:DWORD):LONG;external KernelDLL name 'lineSetCallPrivilege';
function lineSetCurrentLocation(hLineApp:HLINEAPP; dwLocation:DWORD):LONG;external KernelDLL name 'lineSetCurrentLocation';
function lineSetDevConfig(dwDeviceID:DWORD; lpDeviceConfig:LPVOID; dwSize:DWORD; lpszDeviceClass:LPCWSTR):LONG;
 external KernelDLL name 'lineSetDevConfig';
function lineSetMediaMode(hCall:HCALL; dwMediaModes:DWORD):LONG;external KernelDLL name 'lineSetMediaMode';
function lineSetNumRings(hLine:HLINE; dwAddressID:DWORD; dwNumRings:DWORD):LONG;external KernelDLL name 'lineSetNumRings';
function lineSetStatusMessages(hLine:HLINE; dwLineStates:DWORD; dwAddressStates:DWORD):LONG;
 external KernelDLL name 'lineSetStatusMessages';
function lineSetTerminal(hLine:HLINE; dwAddressID:DWORD; hCall:HCALL; dwSelect:DWORD; dwTerminalModes:DWORD;
 dwTerminalID:DWORD; bEnable:DWORD):LONG;external KernelDLL name 'lineSetTerminal';
function lineSetTollList(hLineApp:HLINEAPP; dwDeviceID:DWORD; lpszAddressIn:LPCWSTR; dwTollListOption:DWORD):LONG;
 external KernelDLL name 'lineSetTollList';
function lineSetupConference(hCall:HCALL; hLine:HLINE; lphConfCall:LPHCALL; lphConsultCall:LPHCALL; dwNumParties:DWORD;
 lpCallParams:LPLINECALLPARAMS):LONG;external KernelDLL name 'lineSetupConference';
function lineSetupTransfer(hCall:HCALL; lphConsultCall:LPHCALL; lpCallParams:LPLINECALLPARAMS):LONG;
 external KernelDLL name 'lineSetupTransfer';
function lineShutdown(hLineApp:HLINEAPP):LONG;external KernelDLL name 'lineShutdown';
function lineSwapHold(hActiveCall:HCALL; hHeldCall:HCALL):LONG;external KernelDLL name 'lineSwapHold';
function lineTranslateAddress(hLineApp:HLINEAPP; dwDeviceID:DWORD; dwAPIVersion:DWORD; lpszAddressIn:LPCWSTR; dwCard:DWORD;
 dwTranslateOptions:DWORD; lpTranslateOutput:LPLINETRANSLATEOUTPUT):LONG;external KernelDLL name 'lineTranslateAddress';
function lineTranslateDialog(hLineApp:HLINEAPP; dwDeviceID:DWORD; dwAPIVersion:DWORD; hwndOwner:HWND;
 lpszAddressIn:LPCWSTR):LONG;external KernelDLL name 'lineTranslateDialog'; { TAPI v1.4 }
function lineUnhold(hCall:HCALL):LONG;external KernelDLL name 'lineUnhold';

function phoneClose(hPhone:HPHONE):LONG;external KernelDLL name 'phoneClose';
function phoneConfigDialog(dwDeviceID:DWORD; hwndOwner:HWND; lpszDeviceClass:LPCWSTR):LONG;external KernelDLL name 'phoneConfigDialog';
function phoneDevSpecific(hPhone:HPHONE; lpParams:LPVOID; dwSize:DWORD):LONG;external KernelDLL name 'phoneDevSpecific';
function phoneGetDevCaps(hPhoneApp:HPHONEAPP; dwDeviceID:DWORD; dwAPIVersion:DWORD; dwExtVersion:DWORD;
 lpPhoneCaps:LPPHONECAPS):LONG;external KernelDLL name 'phoneGetDevCaps';
function phoneGetGain(hPhone:HPHONE; dwHookSwitchDev:DWORD; lpdwGain:LPDWORD):LONG;external KernelDLL name 'phoneGetGain';
function phoneGetHookSwitch(hPhone:HPHONE; lpdwHookSwitchDevs:LPDWORD):LONG;external KernelDLL name 'phoneGetHookSwitch';
function phoneGetIcon(dwDeviceID:DWORD; lpszDeviceClass:LPCWSTR; lphIcon:LPHICON):LONG;external KernelDLL name 'phoneGetIcon';
function phoneGetID(hPhone:HPHONE; lpDeviceID:LPVARSTRING; lpszDeviceClass:LPCWSTR):LONG;external KernelDLL name 'phoneGetID';
function phoneGetMessage(hPhoneApp:HPHONEAPP; lpMessage:LPPHONEMESSAGE; dwTimeout:DWORD):LONG;external KernelDLL name 'phoneGetMessage';
function phoneGetRing(hPhone:HPHONE; lpdwRingMode:LPDWORD; lpdwVolume:LPDWORD):LONG;external KernelDLL name 'phoneGetRing';
function phoneGetStatus(hPhone:HPHONE; lpPhoneStatus:LPPHONESTATUS):LONG;external KernelDLL name 'phoneGetStatus';
function phoneGetStatusMessages(hPhone:HPHONE; lpdwPhoneStates:LPDWORD; lpdwButtonModes:LPDWORD; lpdwButtonStates:LPDWORD):LONG;
 external KernelDLL name 'phoneGetStatusMessages';
function phoneGetVolume(hPhone:HPHONE; dwHookSwitchDev:DWORD; lpdwVolume:LPDWORD):LONG;external KernelDLL name 'phoneGetVolume';
function phoneInitializeEx(lphPhoneApp:LPHPHONEAPP; hInstance:HINST; lpfnCallback:PHONECALLBACK; lpszFriendlyAppName:LPCWSTR;
 lpdwNumDevs:LPDWORD; lpdwAPIVersion:LPDWORD; lpPhoneInitializeExParams:LPPHONEINITIALIZEEXPARAMS):LONG;
 external KernelDLL name 'phoneInitializeEx';
function phoneNegotiateAPIVersion(hPhoneApp:HPHONEAPP; dwDeviceID:DWORD; dwAPILowVersion:DWORD; dwAPIHighVersion:DWORD;
 lpdwAPIVersion:LPDWORD; lpExtensionID:LPPHONEEXTENSIONID):LONG;external KernelDLL name 'phoneNegotiateAPIVersion';
function phoneNegotiateExtVersion(hPhoneApp:HPHONEAPP; dwDeviceID:DWORD; dwAPIVersion:DWORD; dwExtLowVersion:DWORD;
 dwExtHighVersion:DWORD; lpdwExtVersion:LPDWORD):LONG;external KernelDLL name 'phoneNegotiateExtVersion';
function phoneOpen(hPhoneApp:HPHONEAPP; dwDeviceID:DWORD; lphPhone:LPHPHONE; dwAPIVersion:DWORD; dwExtVersion:DWORD;
 dwCallbackInstance:DWORD; dwPrivilege:DWORD):LONG;external KernelDLL name 'phoneOpen';
function phoneSetGain(hPhone:HPHONE; dwHookSwitchDev:DWORD; dwGain:DWORD):LONG;external KernelDLL name 'phoneSetGain';
function phoneSetHookSwitch(hPhone:HPHONE; dwHookSwitchDevs:DWORD; dwHookSwitchMode:DWORD):LONG;
 external KernelDLL name 'phoneSetHookSwitch';
function phoneSetRing(hPhone:HPHONE; dwRingMode:DWORD; dwVolume:DWORD):LONG;external KernelDLL name 'phoneSetRing';
function phoneSetStatusMessages(hPhone:HPHONE; dwPhoneStates:DWORD; dwButtonModes:DWORD; dwButtonStates:DWORD):LONG;
 external KernelDLL name 'phoneSetStatusMessages';
function phoneSetVolume(hPhone:HPHONE; dwHookSwitchDev:DWORD; dwVolume:DWORD):LONG;external KernelDLL name 'phoneSetVolume';
function phoneShutdown(hPhoneApp:HPHONEAPP):LONG;external KernelDLL name 'phoneShutdown';

function TAPIERROR_FORMATMESSAGE(const AErrCode: Longword): Longword; // C Macros conversion, may be wrong

implementation

function TAPIERROR_FORMATMESSAGE(const AErrCode: Longword): Longword;
begin
 if AErrCode>$FFFF0000 then Exit(AErrCode and $0000FFFF);
 if (AErrCode and $10000000)<>0 then Exit(AErrCode-$90000000+$F000);
 Exit(AErrCode-$80000000+$E000);
end;

end.
