/* 
 * This software has been developed by TIXEO.
 * 
 * Copyright (c) 2004-2024 TIXE - All Rights Reserved.
 * 
 * COPYRIGHT:
 * This file is the property of TIXEO. 
 * It can not be used, modified, copied without the explicit written
 * authorization from a mandated member of TIXEO.
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * WARRANTY:
 * This software is provided "AS IS" and any express or implied warranties,
 * including, but not limited to, the implied warranties of merchantability and
 * fitness for a particular purpose are disclaimed. In no no event shall copyright
 * holders be liable for any direct, indirect, incidental, special, exemplary
 * or consequential damages (including, but not limited to, procurement of 
 * substitute goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether in
 * contract, strict liability, or tort (including negligence or otherwise)
 * arising in any way out of the use of this software, even if advised or the
 * possibility of such damage.
 * 
 *   SOURCE : https://github.com/othree/webidl.git
 *   WEBIDL LISTING : 
 *        AbortController 
 *        AbortSignal 
 *        AbstractRange 
 *        AbstractWorker 
 *        AccessibleNode 
 *        AddonEvent 
 *        AddonManager 
 *        AnalyserNode 
 *        Animatable 
 *        Animation 
 *        AnimationEffect 
 *        AnimationEvent 
 *        AnimationFrameProvider 
 *        AnimationPlaybackEvent 
 *        AnimationTimeline 
 *        AnonymousContent 
 *        AppInfo 
 *        AppNotificationServiceOptions 
 *        APZTestData 
 *        ARIAMixin 
 *        Attr 
 *        AudioBuffer 
 *        AudioBufferSourceNode 
 *        AudioContext 
 *        AudioData 
 *        AudioDecoder 
 *        AudioDestinationNode 
 *        AudioEncoder 
 *        AudioListener 
 *        AudioNode 
 *        AudioParam 
 *        AudioParamDescriptor 
 *        AudioParamMap 
 *        AudioProcessingEvent 
 *        AudioScheduledSourceNode 
 *        AudioTrack 
 *        AudioTrackList 
 *        AudioWorklet 
 *        AudioWorkletGlobalScope 
 *        AudioWorkletNode 
 *        AudioWorkletProcessor 
 *        AutocompleteInfo 
 *        BarProp 
 *        BaseAudioContext 
 *        BaseKeyframeTypes 
 *        BasicCardPayment 
 *        BatteryManager 
 *        BeforeUnloadEvent 
 *        BiquadFilterNode 
 *        Blob 
 *        BlobEvent 
 *        BroadcastChannel 
 *        BrowserElementDictionaries 
 *        Cache 
 *        CacheStorage 
 *        CancelContentJSOptions 
 *        CanvasCaptureMediaStream 
 *        CanvasRenderingContext2D 
 *        CaretPosition 
 *        CaretStateChangedEvent 
 *        CDATASection 
 *        ChannelMergerNode 
 *        ChannelSplitterNode 
 *        CharacterData 
 *        CheckerboardReportService 
 *        ChildNode 
 *        Client 
 *        Clients 
 *        Clipboard 
 *        ClipboardEvent 
 *        CloseEvent 
 *        Comment 
 *        CompositionEvent 
 *        CompressionStream 
 *        Console 
 *        ConstantSourceNode 
 *        ContentVisibilityAutoStateChangeEvent 
 *        ConvolverNode 
 *        CreateOfferRequest 
 *        CredentialManagement 
 *        Crypto 
 *        CSPDictionaries 
 *        CSPReport 
 *        CSS 
 *        CSSAnimation 
 *        CSSConditionRule 
 *        CSSContainerRule 
 *        CSSCounterStyleRule 
 *        CSSFontFaceRule 
 *        CSSFontFeatureValuesRule 
 *        CSSFontPaletteValuesRule 
 *        CSSGroupingRule 
 *        CSSImportRule 
 *        CSSKeyframeRule 
 *        CSSKeyframesRule 
 *        CSSLayerBlockRule 
 *        CSSLayerStatementRule 
 *        CSSMediaRule 
 *        CSSMozDocumentRule 
 *        CSSNamespaceRule 
 *        CSSPageRule 
 *        CSSPropertyRule 
 *        CSSPseudoElement 
 *        CSSRule 
 *        CSSRuleList 
 *        CSSScopeRule 
 *        CSSStyleDeclaration 
 *        CSSStyleRule 
 *        CSSStyleSheet 
 *        CSSSupportsRule 
 *        CSSTransition 
 *        CustomElementRegistry 
 *        CustomEvent 
 *        DataTransfer 
 *        DataTransferItem 
 *        DataTransferItemList 
 *        DecoderDoctorNotification 
 *        DecompressionStream 
 *        DedicatedWorkerGlobalScope 
 *        DelayNode 
 *        DeviceLightEvent 
 *        DeviceMotionEvent 
 *        DeviceOrientationEvent 
 *        Directory 
 *        Document 
 *        DocumentFragment 
 *        DocumentOrShadowRoot 
 *        DocumentTimeline 
 *        DocumentType 
 *        DOMException 
 *        DOMImplementation 
 *        DOMLocalization 
 *        DOMMatrix 
 *        DOMParser 
 *        DOMPoint 
 *        DOMQuad 
 *        DOMRect 
 *        DOMRectList 
 *        DOMStringList 
 *        DOMStringMap 
 *        DOMTokenList 
 *        DragEvent 
 *        DynamicsCompressorNode 
 *        Element 
 *        ElementInternals 
 *        EncodedAudioChunk 
 *        EncodedVideoChunk 
 *        ErrorEvent 
 *        Event 
 *        EventHandler 
 *        EventListener 
 *        EventSource 
 *        EventTarget 
 *        ExtendableEvent 
 *        ExtendableMessageEvent 
 *        ExtensionAlarms 
 *        ExtensionBrowser 
 *        ExtensionBrowserSettings 
 *        ExtensionBrowserSettingsColorManagement 
 *        ExtensionDns 
 *        ExtensionEventManager 
 *        ExtensionMockAPI 
 *        ExtensionPort 
 *        ExtensionProxy 
 *        ExtensionRuntime 
 *        ExtensionScripting 
 *        ExtensionSetting 
 *        ExtensionTest 
 *        External 
 *        FailedCertSecurityInfo 
 *        FakePluginTagInit 
 *        FeaturePolicy 
 *        Fetch 
 *        FetchEvent 
 *        FetchObserver 
 *        File 
 *        FileList 
 *        FileMode 
 *        FileReader 
 *        FileReaderSync 
 *        FileSystem 
 *        FileSystemDirectoryEntry 
 *        FileSystemDirectoryHandle 
 *        FileSystemDirectoryIterator 
 *        FileSystemDirectoryReader 
 *        FileSystemEntry 
 *        FileSystemFileEntry 
 *        FileSystemFileHandle 
 *        FileSystemHandle 
 *        FileSystemSyncAccessHandle 
 *        FileSystemWritableFileStream 
 *        FinalizationRegistry 
 *        FocusEvent 
 *        FontFace 
 *        FontFaceSet 
 *        FontFaceSetLoadEvent 
 *        FontFaceSource 
 *        FormData 
 *        FormDataEvent 
 *        FragmentDirective 
 *        FrameCrashedEvent 
 *        Function 
 *        FuzzingFunctions 
 *        GainNode 
 *        Gamepad 
 *        GamepadAxisMoveEvent 
 *        GamepadButtonEvent 
 *        GamepadEvent 
 *        GamepadHapticActuator 
 *        GamepadLightIndicator 
 *        GamepadPose 
 *        GamepadServiceTest 
 *        GamepadTouch 
 *        GenericTransformStream 
 *        Geolocation 
 *        GeolocationCoordinates 
 *        GeolocationPosition 
 *        GeolocationPositionError 
 *        GeometryUtils 
 *        GetUserMediaRequest 
 *        Glean 
 *        GleanMetrics 
 *        GleanPings 
 *        GPUUncapturedErrorEvent 
 *        HashChangeEvent 
 *        Headers 
 *        Highlight 
 *        History 
 *        HTMLAllCollection 
 *        HTMLAnchorElement 
 *        HTMLAreaElement 
 *        HTMLAudioElement 
 *        HTMLBaseElement 
 *        HTMLBodyElement 
 *        HTMLBRElement 
 *        HTMLButtonElement 
 *        HTMLCanvasElement 
 *        HTMLCollection 
 *        HTMLDataElement 
 *        HTMLDataListElement 
 *        HTMLDetailsElement 
 *        HTMLDialogElement 
 *        HTMLDirectoryElement 
 *        HTMLDivElement 
 *        HTMLDListElement 
 *        HTMLDocument 
 *        HTMLElement 
 *        HTMLEmbedElement 
 *        HTMLFieldSetElement 
 *        HTMLFontElement 
 *        HTMLFormControlsCollection 
 *        HTMLFormElement 
 *        HTMLFrameElement 
 *        HTMLFrameSetElement 
 *        HTMLHeadElement 
 *        HTMLHeadingElement 
 *        HTMLHRElement 
 *        HTMLHtmlElement 
 *        HTMLHyperlinkElementUtils 
 *        HTMLIFrameElement 
 *        HTMLImageElement 
 *        HTMLInputElement 
 *        HTMLLabelElement 
 *        HTMLLegendElement 
 *        HTMLLIElement 
 *        HTMLLinkElement 
 *        HTMLMapElement 
 *        HTMLMarqueeElement 
 *        HTMLMediaElement 
 *        HTMLMenuElement 
 *        HTMLMetaElement 
 *        HTMLMeterElement 
 *        HTMLModElement 
 *        HTMLObjectElement 
 *        HTMLOListElement 
 *        HTMLOptGroupElement 
 *        HTMLOptionElement 
 *        HTMLOptionsCollection 
 *        HTMLOutputElement 
 *        HTMLParagraphElement 
 *        HTMLParamElement 
 *        HTMLPictureElement 
 *        HTMLPreElement 
 *        HTMLProgressElement 
 *        HTMLQuoteElement 
 *        HTMLScriptElement 
 *        HTMLSelectElement 
 *        HTMLSlotElement 
 *        HTMLSourceElement 
 *        HTMLSpanElement 
 *        HTMLStyleElement 
 *        HTMLTableCaptionElement 
 *        HTMLTableCellElement 
 *        HTMLTableColElement 
 *        HTMLTableElement 
 *        HTMLTableRowElement 
 *        HTMLTableSectionElement 
 *        HTMLTemplateElement 
 *        HTMLTextAreaElement 
 *        HTMLTimeElement 
 *        HTMLTitleElement 
 *        HTMLTrackElement 
 *        HTMLUListElement 
 *        HTMLVideoElement 
 *        IDBCursor 
 *        IDBDatabase 
 *        IDBFactory 
 *        IDBIndex 
 *        IDBKeyRange 
 *        IDBObjectStore 
 *        IDBOpenDBRequest 
 *        IDBRequest 
 *        IDBTransaction 
 *        IDBVersionChangeEvent 
 *        IdentityCredential 
 *        IdleDeadline 
 *        IIRFilterNode 
 *        ImageBitmap 
 *        ImageBitmapRenderingContext 
 *        ImageCapture 
 *        ImageCaptureErrorEvent 
 *        ImageData 
 *        ImageDocument 
 *        InputEvent 
 *        InstallTrigger 
 *        IntersectionObserver 
 *        IntlUtils 
 *        InvokeEvent 
 *        InvokerElement 
 *        IterableIterator 
 *        KeyAlgorithm 
 *        KeyboardEvent 
 *        KeyEvent 
 *        KeyframeAnimationOptions 
 *        KeyframeEffect 
 *        KeyIdsInitData 
 *        LinkStyle 
 *        Localization 
 *        Location 
 *        Lock 
 *        LockManager 
 *        MathMLElement 
 *        MediaCapabilities 
 *        MediaDebugInfo 
 *        MediaDeviceInfo 
 *        MediaDevices 
 *        MediaElementAudioSourceNode 
 *        MediaEncryptedEvent 
 *        MediaError 
 *        MediaKeyError 
 *        MediaKeyMessageEvent 
 *        MediaKeys 
 *        MediaKeySession 
 *        MediaKeysRequestStatus 
 *        MediaKeyStatusMap 
 *        MediaKeySystemAccess 
 *        MediaList 
 *        MediaQueryList 
 *        MediaQueryListEvent 
 *        MediaRecorder 
 *        MediaRecorderErrorEvent 
 *        MediaSession 
 *        MediaSource 
 *        MediaStream 
 *        MediaStreamAudioDestinationNode 
 *        MediaStreamAudioSourceNode 
 *        MediaStreamError 
 *        MediaStreamEvent 
 *        MediaStreamTrack 
 *        MediaStreamTrackAudioSourceNode 
 *        MediaStreamTrackEvent 
 *        MediaTrackSettings 
 *        MediaTrackSupportedConstraints 
 *        MerchantValidationEvent 
 *        MessageChannel 
 *        MessageEvent 
 *        MessagePort 
 *        MIDIAccess 
 *        MIDIConnectionEvent 
 *        MIDIInput 
 *        MIDIInputMap 
 *        MIDIMessageEvent 
 *        MIDIOptions 
 *        MIDIOutput 
 *        MIDIOutputMap 
 *        MIDIPort 
 *        MimeType 
 *        MimeTypeArray 
 *        MouseEvent 
 *        MouseScrollEvent 
 *        MozApplicationEvent 
 *        MozFrameLoaderOwner 
 *        MutationEvent 
 *        MutationObserver 
 *        NamedNodeMap 
 *        NavigationPreloadManager 
 *        Navigator 
 *        NetErrorInfo 
 *        NetworkInformation 
 *        NetworkOptions 
 *        Node 
 *        NodeFilter 
 *        NodeIterator 
 *        NodeList 
 *        NonElementParentNode 
 *        Notification 
 *        NotificationEvent 
 *        NotifyPaintEvent 
 *        OfflineAudioCompletionEvent 
 *        OfflineAudioContext 
 *        OffscreenCanvas 
 *        OffscreenCanvasRenderingContext2D 
 *        OscillatorNode 
 *        PageTransitionEvent 
 *        PaintRequest 
 *        PaintRequestList 
 *        PaintWorkletGlobalScope 
 *        PannerNode 
 *        ParentNode 
 *        PaymentAddress 
 *        PaymentMethodChangeEvent 
 *        PaymentRequest 
 *        PaymentRequestUpdateEvent 
 *        PaymentResponse 
 *        PeerConnectionImpl 
 *        PeerConnectionObserver 
 *        PeerConnectionObserverEnums 
 *        Performance 
 *        PerformanceEntry 
 *        PerformanceEntryEvent 
 *        PerformanceEventTiming 
 *        PerformanceLargestContentfulPaint 
 *        PerformanceMark 
 *        PerformanceMeasure 
 *        PerformanceNavigation 
 *        PerformanceNavigationTiming 
 *        PerformanceObserver 
 *        PerformanceObserverEntryList 
 *        PerformancePaintTiming 
 *        PerformanceResourceTiming 
 *        PerformanceServerTiming 
 *        PerformanceTiming 
 *        PeriodicWave 
 *        Permissions 
 *        PermissionStatus 
 *        Plugin 
 *        PluginArray 
 *        PointerEvent 
 *        PopoverInvokerElement 
 *        PopStateEvent 
 *        PopupBlockedEvent 
 *        PositionStateEvent 
 *        ProcessingInstruction 
 *        ProgressEvent 
 *        Promise 
 *        PromiseRejectionEvent 
 *        PushEvent 
 *        PushManager 
 *        PushMessageData 
 *        PushSubscription 
 *        PushSubscriptionOptions 
 *        QueuingStrategy 
 *        RadioNodeList 
 *        Range 
 *        ReadableByteStreamController 
 *        ReadableStream 
 *        ReadableStreamBYOBReader 
 *        ReadableStreamBYOBRequest 
 *        ReadableStreamDefaultController 
 *        ReadableStreamDefaultReader 
 *        ReferrerPolicy 
 *        Reporting 
 *        Request 
 *        ResizeObserver 
 *        Response 
 *        RTCCertificate 
 *        RTCConfiguration 
 *        RTCDataChannel 
 *        RTCDataChannelEvent 
 *        RTCDtlsTransport 
 *        RTCDTMFSender 
 *        RTCDTMFToneChangeEvent 
 *        RTCEncodedAudioFrame 
 *        RTCEncodedVideoFrame 
 *        RTCIceCandidate 
 *        RTCIceTransport 
 *        RTCIdentityAssertion 
 *        RTCIdentityProvider 
 *        RTCPeerConnection 
 *        RTCPeerConnectionIceEvent 
 *        RTCPeerConnectionStatic 
 *        RTCRtpCapabilities 
 *        RTCRtpParameters 
 *        RTCRtpReceiver 
 *        RTCRtpScriptTransform 
 *        RTCRtpScriptTransformer 
 *        RTCRtpSender 
 *        RTCRtpSources 
 *        RTCRtpTransceiver 
 *        RTCSctpTransport 
 *        RTCSessionDescription 
 *        RTCStatsReport 
 *        RTCTrackEvent 
 *        RTCTransformEvent 
 *        Sanitizer 
 *        Screen 
 *        ScreenOrientation 
 *        ScriptProcessorNode 
 *        ScrollAreaEvent 
 *        ScrollViewChangeEvent 
 *        SecurityPolicyViolationEvent 
 *        Selection 
 *        ServiceWorker 
 *        ServiceWorkerContainer 
 *        ServiceWorkerGlobalScope 
 *        ServiceWorkerRegistration 
 *        ShadowRealmGlobalScope 
 *        ShadowRoot 
 *        SharedWorker 
 *        SharedWorkerGlobalScope 
 *        SimpleGestureEvent 
 *        SocketCommon 
 *        SourceBuffer 
 *        SourceBufferList 
 *        SpeechGrammar 
 *        SpeechGrammarList 
 *        SpeechRecognition 
 *        SpeechRecognitionAlternative 
 *        SpeechRecognitionError 
 *        SpeechRecognitionEvent 
 *        SpeechRecognitionResult 
 *        SpeechRecognitionResultList 
 *        SpeechSynthesis 
 *        SpeechSynthesisErrorEvent 
 *        SpeechSynthesisEvent 
 *        SpeechSynthesisUtterance 
 *        SpeechSynthesisVoice 
 *        StaticRange 
 *        StereoPannerNode 
 *        Storage 
 *        StorageEvent 
 *        StorageManager 
 *        StreamFilter 
 *        StreamFilterDataEvent 
 *        StructuredCloneTester 
 *        StyleSheet 
 *        StyleSheetList 
 *        SubmitEvent 
 *        SubtleCrypto 
 *        SVGAElement 
 *        SVGAngle 
 *        SVGAnimatedAngle 
 *        SVGAnimatedBoolean 
 *        SVGAnimatedEnumeration 
 *        SVGAnimatedInteger 
 *        SVGAnimatedLength 
 *        SVGAnimatedLengthList 
 *        SVGAnimatedNumber 
 *        SVGAnimatedNumberList 
 *        SVGAnimatedPathData 
 *        SVGAnimatedPoints 
 *        SVGAnimatedPreserveAspectRatio 
 *        SVGAnimatedRect 
 *        SVGAnimatedString 
 *        SVGAnimatedTransformList 
 *        SVGAnimateElement 
 *        SVGAnimateMotionElement 
 *        SVGAnimateTransformElement 
 *        SVGAnimationElement 
 *        SVGCircleElement 
 *        SVGClipPathElement 
 *        SVGComponentTransferFunctionElement 
 *        SVGDefsElement 
 *        SVGDescElement 
 *        SVGElement 
 *        SVGEllipseElement 
 *        SVGFEBlendElement 
 *        SVGFEColorMatrixElement 
 *        SVGFEComponentTransferElement 
 *        SVGFECompositeElement 
 *        SVGFEConvolveMatrixElement 
 *        SVGFEDiffuseLightingElement 
 *        SVGFEDisplacementMapElement 
 *        SVGFEDistantLightElement 
 *        SVGFEDropShadowElement 
 *        SVGFEFloodElement 
 *        SVGFEFuncAElement 
 *        SVGFEFuncBElement 
 *        SVGFEFuncGElement 
 *        SVGFEFuncRElement 
 *        SVGFEGaussianBlurElement 
 *        SVGFEImageElement 
 *        SVGFEMergeElement 
 *        SVGFEMergeNodeElement 
 *        SVGFEMorphologyElement 
 *        SVGFEOffsetElement 
 *        SVGFEPointLightElement 
 *        SVGFESpecularLightingElement 
 *        SVGFESpotLightElement 
 *        SVGFETileElement 
 *        SVGFETurbulenceElement 
 *        SVGFilterElement 
 *        SVGFilterPrimitiveStandardAttributes 
 *        SVGFitToViewBox 
 *        SVGForeignObjectElement 
 *        SVGGElement 
 *        SVGGeometryElement 
 *        SVGGradientElement 
 *        SVGGraphicsElement 
 *        SVGImageElement 
 *        SVGLength 
 *        SVGLengthList 
 *        SVGLinearGradientElement 
 *        SVGLineElement 
 *        SVGMarkerElement 
 *        SVGMaskElement 
 *        SVGMatrix 
 *        SVGMetadataElement 
 *        SVGMPathElement 
 *        SVGNumber 
 *        SVGNumberList 
 *        SVGPathElement 
 *        SVGPathSeg 
 *        SVGPathSegList 
 *        SVGPatternElement 
 *        SVGPoint 
 *        SVGPointList 
 *        SVGPolygonElement 
 *        SVGPolylineElement 
 *        SVGPreserveAspectRatio 
 *        SVGRadialGradientElement 
 *        SVGRect 
 *        SVGRectElement 
 *        SVGScriptElement 
 *        SVGSetElement 
 *        SVGStopElement 
 *        SVGStringList 
 *        SVGStyleElement 
 *        SVGSVGElement 
 *        SVGSwitchElement 
 *        SVGSymbolElement 
 *        SVGTests 
 *        SVGTextContentElement 
 *        SVGTextElement 
 *        SVGTextPathElement 
 *        SVGTextPositioningElement 
 *        SVGTitleElement 
 *        SVGTransform 
 *        SVGTransformList 
 *        SVGTSpanElement 
 *        SVGUnitTypes 
 *        SVGURIReference 
 *        SVGUseElement 
 *        SVGViewElement 
 *        SVGZoomAndPan 
 *        TaskPriorityChangeEvent 
 *        TCPServerSocket 
 *        TCPServerSocketEvent 
 *        TCPSocket 
 *        TCPSocketErrorEvent 
 *        TCPSocketEvent 
 *        TestFunctions 
 *        TestInterfaceJS 
 *        TestInterfaceJSDictionaries 
 *        TestInterfaceJSMaplikeSetlikeIterable 
 *        TestInterfaceObservableArray 
 *        TestUtils 
 *        Text 
 *        TextClause 
 *        TextDecoder 
 *        TextDecoderStream 
 *        TextEncoder 
 *        TextEncoderStream 
 *        TextTrack 
 *        TextTrackCue 
 *        TextTrackCueList 
 *        TextTrackList 
 *        TimeEvent 
 *        TimeRanges 
 *        ToggleEvent 
 *        Touch 
 *        TouchEvent 
 *        TouchList 
 *        TrackEvent 
 *        Transformer 
 *        TransformStream 
 *        TransformStreamDefaultController 
 *        TransitionEvent 
 *        TreeWalker 
 *        TrustedTypes 
 *        UDPMessageEvent 
 *        UDPSocket 
 *        UIEvent 
 *        UnderlyingSink 
 *        UnderlyingSource 
 *        URL 
 *        URLSearchParams 
 *        UserActivation 
 *        UserProximityEvent 
 *        ValidityState 
 *        VideoColorSpace 
 *        VideoDecoder 
 *        VideoEncoder 
 *        VideoFrame 
 *        VideoPlaybackQuality 
 *        VideoTrack 
 *        VideoTrackList 
 *        VisualViewport 
 *        VRDisplay 
 *        VRDisplayEvent 
 *        VRServiceTest 
 *        VTTCue 
 *        VTTRegion 
 *        WakeLock 
 *        WakeLockSentinel 
 *        WaveShaperNode 
 *        WebAuthentication 
 *        WebGL2RenderingContext 
 *        WebGLContextEvent 
 *        WebGLRenderingContext 
 *        WebGPU 
 *        WebrtcGlobalInformation 
 *        WebSocket 
 *        WebTaskScheduling 
 *        WebTransport 
 *        WebTransportDatagramDuplexStream 
 *        WebTransportError 
 *        WebTransportSendReceiveStream 
 *        WebXR 
 *        WheelEvent 
 *        Window 
 *        WindowOrWorkerGlobalScope 
 *        Worker 
 *        WorkerDebuggerGlobalScope 
 *        WorkerGlobalScope 
 *        WorkerLocation 
 *        WorkerNavigator 
 *        WorkerTestUtils 
 *        Worklet 
 *        WorkletGlobalScope 
 *        WritableStream 
 *        WritableStreamDefaultController 
 *        WritableStreamDefaultWriter 
 *        XMLDocument 
 *        XMLHttpRequest 
 *        XMLHttpRequestEventTarget 
 *        XMLHttpRequestUpload 
 *        XMLSerializer 
 *        XPathEvaluator 
 *        XPathExpression 
 *        XPathNSResolver 
 *        XPathResult 
 *        XRInputSourceEvent 
 *        XRInputSourcesChangeEvent 
 *        XRReferenceSpaceEvent 
 *        XRSessionEvent 
 *        XSLTProcessor 
 */
 
/* ---------------------- AbortController ----------------------------- */ 
/* ./webidl/AbortController.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#abortcontroller
 */

[Exposed=*]
interface AbortController {
  [Throws]
  constructor();

  [SameObject] readonly attribute AbortSignal signal;

  undefined abort(optional any reason);
};
 
/* ---------------------- AbortSignal ----------------------------- */ 
/* ./webidl/AbortSignal.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#abortsignal
 */

[Exposed=*]
interface AbortSignal : EventTarget {
  [NewObject] static AbortSignal abort(optional any reason);
  [Exposed=(Window,Worker), NewObject, Throws]
  static AbortSignal timeout([EnforceRange] unsigned long long milliseconds);
  [NewObject] static AbortSignal _any(sequence<AbortSignal> signals);

  readonly attribute boolean aborted;
  readonly attribute any reason;
  [Throws] undefined throwIfAborted();

  attribute EventHandler onabort;
};
 
/* ---------------------- AbstractRange ----------------------------- */ 
/* ./webidl/AbstractRange.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#abstractrange
 *
 * Copyright  2012 W3C  (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface AbstractRange {
  [BinaryName="GetStartContainer"]
  readonly attribute Node startContainer;
  readonly attribute unsigned long startOffset;
  [BinaryName="GetEndContainer"]
  readonly attribute Node endContainer;
  readonly attribute unsigned long endOffset;
  readonly attribute boolean collapsed;
};
 
/* ---------------------- AbstractWorker ----------------------------- */ 
/* ./webidl/AbstractWorker.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=(Window,Worker)]
interface mixin AbstractWorker {
    attribute EventHandler onerror;
};
 
/* ---------------------- AccessibleNode ----------------------------- */ 
/* ./webidl/AccessibleNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Func="mozilla::dom::AccessibleNode::IsAOMEnabled",
 Exposed=Window]
interface AccessibleNode {
  readonly attribute DOMString computedRole;
  [Frozen, Cached, Pure]
  readonly attribute sequence<DOMString> states;
  [Frozen, Cached, Pure]
  readonly attribute sequence<DOMString> attributes;
  readonly attribute Node? DOMNode;

  boolean is(DOMString... states);
  boolean has(DOMString... attributes);
  [Throws]
  any get(DOMString attribute);

  attribute DOMString? role;
  attribute DOMString? roleDescription;

  // Accessible label and descriptor
  attribute DOMString? label;

  // Global states and properties
  attribute DOMString? current;

  // Accessible properties
  attribute DOMString? autocomplete;
  attribute DOMString? keyShortcuts;
  attribute boolean? modal;
  attribute boolean? multiline;
  attribute boolean? multiselectable;
  attribute DOMString? orientation;
  attribute boolean? readOnly;
  attribute boolean? required;
  attribute DOMString? sort;

  // Range values
  attribute DOMString? placeholder;
  attribute double? valueMax;
  attribute double? valueMin;
  attribute double? valueNow;
  attribute DOMString? valueText;

  // Accessible states
  attribute DOMString? checked;
  attribute boolean? disabled;
  attribute boolean? expanded;
  attribute DOMString? hasPopUp;
  attribute boolean? hidden;
  attribute DOMString? invalid;
  attribute DOMString? pressed;
  attribute boolean? selected;

  // Live regions
  attribute boolean? atomic;
  attribute boolean? busy;
  attribute DOMString? live;
  attribute DOMString? relevant;

  // Other relationships
  attribute AccessibleNode? activeDescendant;
  attribute AccessibleNode? details;
  attribute AccessibleNode? errorMessage;

  // Collections.
  attribute long? colCount;
  attribute unsigned long? colIndex;
  attribute unsigned long? colSpan;
  attribute unsigned long? level;
  attribute unsigned long? posInSet;
  attribute long? rowCount;
  attribute unsigned long? rowIndex;
  attribute unsigned long? rowSpan;
  attribute long? setSize;
};
 
/* ---------------------- AddonEvent ----------------------------- */ 
/* ./webidl/AddonEvent.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

[Func="mozilla::AddonManagerWebAPI::IsAPIEnabled",
 Exposed=Window]
interface AddonEvent : Event {
  constructor(DOMString type, AddonEventInit eventInitDict);

  readonly attribute DOMString id;
};

dictionary AddonEventInit : EventInit {
  required DOMString id;
};
 
/* ---------------------- AddonManager ----------------------------- */ 
/* ./webidl/AddonManager.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/* We need a JSImplementation but cannot get one without a contract ID.
   Since Addon and AddonInstall are only ever created from JS they don't need
   real contract IDs. */
[ChromeOnly, JSImplementation="dummy",
 Exposed=Window]
interface Addon {
  // The add-on's ID.
  readonly attribute DOMString id;
  // The add-on's version.
  readonly attribute DOMString version;
  // The add-on's type (extension, theme, etc.).
  readonly attribute DOMString type;
  // The add-on's name in the current locale.
  readonly attribute DOMString name;
  // The add-on's description in the current locale.
  readonly attribute DOMString description;
  // If the user has enabled this add-on, note that it still may not be running
  // depending on whether enabling requires a restart or if the add-on is
  // incompatible in some way.
  readonly attribute boolean isEnabled;
  // If the add-on is currently active in the browser.
  readonly attribute boolean isActive;
  // If the add-on may be uninstalled
  readonly attribute boolean canUninstall;

  Promise<boolean> uninstall();
  Promise<undefined> setEnabled(boolean value);
};

[ChromeOnly, JSImplementation="dummy",
 Exposed=Window]
interface AddonInstall : EventTarget {
  // One of the STATE_* symbols from AddonManager.sys.mjs
  readonly attribute DOMString state;
  // One of the ERROR_* symbols from AddonManager.sys.mjs, or null
  readonly attribute DOMString? error;
  // How many bytes have been downloaded
  readonly attribute long long progress;
  // How many total bytes will need to be downloaded or -1 if unknown
  readonly attribute long long maxProgress;

  Promise<undefined> install();
  Promise<undefined> cancel();
};

dictionary addonInstallOptions {
  required DOMString url;
  // If a non-empty string is passed for "hash", it is used to verify the
  // checksum of the downloaded XPI before installing.  If is omitted or if
  // it is null or empty string, no checksum verification is performed.
  DOMString? hash = null;
};

[HeaderFile="mozilla/AddonManagerWebAPI.h",
 Func="mozilla::AddonManagerWebAPI::IsAPIEnabled",
 JSImplementation="@mozilla.org/addon-web-api/manager;1",
 WantsEventListenerHooks,
 Exposed=Window]
interface AddonManager : EventTarget {
  /**
   * Gets information about an add-on
   *
   * @param  id
   *         The ID of the add-on to test for.
   * @return A promise. It will resolve to an Addon if the add-on is installed.
   */
  Promise<Addon> getAddonByID(DOMString id);

  /**
   * Creates an AddonInstall object for a given URL.
   *
   * @param options
   *        Only one supported option: 'url', the URL of the addon to install.
   * @return A promise that resolves to an instance of AddonInstall.
   */
  Promise<AddonInstall> createInstall(optional addonInstallOptions options = {});

  /**
   * Opens an Abuse Report dialog window for the addon with the given id.
   * The addon may be currently installed (in which case the report will
   * include the details available locally), or not (in which case the report
   * will include the details that can be retrieved from the AMO API endpoint).
   *
   * @param  id
   *         The ID of the add-on to report.
   * @return A promise that resolves to a boolean (true when the report
   *         has been submitted successfully, false if the user cancelled
   *         the report). The Promise is rejected is the report fails
   *         for a reason other than user cancellation.
   */
  Promise<boolean> reportAbuse(DOMString id);

  // Indicator to content whether handing off the reports to the integrated
  // abuse report panel is enabled.
  readonly attribute boolean abuseReportPanelEnabled;
};

[ChromeOnly,Exposed=Window,HeaderFile="mozilla/AddonManagerWebAPI.h"]
namespace AddonManagerPermissions {
  boolean isHostPermitted(DOMString host);
};
 
/* ---------------------- AnalyserNode ----------------------------- */ 
/* ./webidl/AnalyserNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary AnalyserOptions : AudioNodeOptions {
             unsigned long fftSize = 2048;
             double        maxDecibels = -30;
             double        minDecibels = -100;
             double        smoothingTimeConstant = 0.8;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AnalyserNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context,
                optional AnalyserOptions options = {});

    // Real-time frequency-domain data
    undefined getFloatFrequencyData(Float32Array array);
    undefined getByteFrequencyData(Uint8Array array);

    // Real-time waveform data
    undefined getFloatTimeDomainData(Float32Array array);
    undefined getByteTimeDomainData(Uint8Array array);

    [SetterThrows, Pure]
    attribute unsigned long fftSize;
    [Pure]
    readonly attribute unsigned long frequencyBinCount;

    [SetterThrows, Pure]
    attribute double minDecibels;
    [SetterThrows, Pure]
    attribute double maxDecibels;

    [SetterThrows, Pure]
    attribute double smoothingTimeConstant;

};

// Mozilla extension
AnalyserNode includes AudioNodePassThrough;
 
/* ---------------------- Animatable ----------------------------- */ 
/* ./webidl/Animatable.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/fxtf/web-animations/#the-animatable-interface
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary KeyframeAnimationOptions : KeyframeEffectOptions {
  DOMString id = "";
};

dictionary GetAnimationsOptions {
  boolean subtree = false;
};

interface mixin Animatable {
  [Throws]
  Animation animate(object? keyframes,
                    optional UnrestrictedDoubleOrKeyframeAnimationOptions options = {});
  sequence<Animation> getAnimations(optional GetAnimationsOptions options = {});
};
 
/* ---------------------- Animation ----------------------------- */ 
/* ./webidl/Animation.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#animation
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum AnimationPlayState { "idle", "running", "paused", "finished" };

enum AnimationReplaceState { "active", "removed", "persisted" };

[Exposed=Window]
interface Animation : EventTarget {
  [Throws]
  constructor(optional AnimationEffect? effect = null,
              optional AnimationTimeline? timeline);

  attribute DOMString id;
  [Pure]
  attribute AnimationEffect? effect;
  // Bug 1676794. Drop BinaryName once we support ScrollTimeline interface.
  [Func="Document::AreWebAnimationsTimelinesEnabled",
   BinaryName="timelineFromJS"]
  attribute AnimationTimeline? timeline;

  [BinaryName="startTimeAsDouble"]
  attribute double? startTime;
  [SetterThrows, BinaryName="currentTimeAsDouble"]
  attribute double? currentTime;

           attribute double             playbackRate;
  [BinaryName="playStateFromJS"]
  readonly attribute AnimationPlayState playState;
  [BinaryName="pendingFromJS"]
  readonly attribute boolean            pending;
  readonly attribute AnimationReplaceState replaceState;
  [Throws]
  readonly attribute Promise<Animation> ready;
  [Throws]
  readonly attribute Promise<Animation> finished;
           attribute EventHandler       onfinish;
           attribute EventHandler       oncancel;
           attribute EventHandler       onremove;
  undefined cancel();
  [Throws]
  undefined finish();
  [Throws, BinaryName="playFromJS"]
  undefined play();
  [Throws, BinaryName="pauseFromJS"]
  undefined pause();
  undefined updatePlaybackRate (double playbackRate);
  [Throws]
  undefined reverse();
  undefined persist();
  [CEReactions, Throws]
  undefined commitStyles();
};

// Non-standard extensions
partial interface Animation {
  [ChromeOnly] readonly attribute boolean isRunningOnCompositor;
};
 
/* ---------------------- AnimationEffect ----------------------------- */ 
/* ./webidl/AnimationEffect.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#animationeffectreadonly
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum FillMode {
  "none",
  "forwards",
  "backwards",
  "both",
  "auto"
};

enum PlaybackDirection {
  "normal",
  "reverse",
  "alternate",
  "alternate-reverse"
};

dictionary EffectTiming {
  double                              delay = 0.0;
  double                              endDelay = 0.0;
  FillMode                            fill = "auto";
  double                              iterationStart = 0.0;
  unrestricted double                 iterations = 1.0;
  (unrestricted double or DOMString)  duration = "auto";
  PlaybackDirection                   direction = "normal";
  UTF8String                          easing = "linear";
};

dictionary OptionalEffectTiming {
  double                              delay;
  double                              endDelay;
  FillMode                            fill;
  double                              iterationStart;
  unrestricted double                 iterations;
  (unrestricted double or DOMString)  duration;
  PlaybackDirection                   direction;
  UTF8String                          easing;
};

dictionary ComputedEffectTiming : EffectTiming {
  unrestricted double   endTime = 0.0;
  unrestricted double   activeDuration = 0.0;
  double?               localTime = null;
  double?               progress = null;
  unrestricted double?  currentIteration = null;
};

[Exposed=Window]
interface AnimationEffect {
  EffectTiming getTiming();
  [BinaryName="getComputedTimingAsDict"]
  ComputedEffectTiming getComputedTiming();
  [Throws]
  undefined updateTiming(optional OptionalEffectTiming timing = {});
};
 
/* ---------------------- AnimationEvent ----------------------------- */ 
/* ./webidl/AnimationEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/css3-animations/#animation-events-
 * http://dev.w3.org/csswg/css3-animations/#animation-events-
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface AnimationEvent : Event {
  constructor(DOMString type, optional AnimationEventInit eventInitDict = {});

  readonly attribute DOMString animationName;
  readonly attribute float     elapsedTime;
  readonly attribute DOMString pseudoElement;
};

dictionary AnimationEventInit : EventInit {
  DOMString animationName = "";
  float elapsedTime = 0;
  DOMString pseudoElement = "";
};
 
/* ---------------------- AnimationFrameProvider ----------------------------- */ 
/* ./webidl/AnimationFrameProvider.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/imagebitmap-and-animations.html#animation-frames
 */

callback FrameRequestCallback = undefined (DOMHighResTimeStamp time);

interface mixin AnimationFrameProvider {
  [Throws] long requestAnimationFrame(FrameRequestCallback callback);
  [Throws] undefined cancelAnimationFrame(long handle);
};
 
/* ---------------------- AnimationPlaybackEvent ----------------------------- */ 
/* ./webidl/AnimationPlaybackEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#animationplaybackevent
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface AnimationPlaybackEvent : Event {
  constructor(DOMString type,
              optional AnimationPlaybackEventInit eventInitDict = {});

  readonly attribute double? currentTime;
  readonly attribute double? timelineTime;
};

dictionary AnimationPlaybackEventInit : EventInit {
  double? currentTime = null;
  double? timelineTime = null;
};
 
/* ---------------------- AnimationTimeline ----------------------------- */ 
/* ./webidl/AnimationTimeline.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#animationtimeline
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Func="Document::AreWebAnimationsTimelinesEnabled",
 Exposed=Window]
interface AnimationTimeline {
  [BinaryName="currentTimeAsDouble"]
  readonly attribute double? currentTime;
};
 
/* ---------------------- AnonymousContent ----------------------------- */ 
/* ./webidl/AnonymousContent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * This file declares the AnonymousContent interface which is used to
 * manipulate content that has been inserted into the document's canvasFrame
 * anonymous container. See Document.insertAnonymousContent.
 * Users of this API must never remove the host of the shadow root.
 */

[ChromeOnly, Exposed=Window]
interface AnonymousContent {
  readonly attribute ShadowRoot root;
};
 
/* ---------------------- AppInfo ----------------------------- */ 
/* ./webidl/AppInfo.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
  * This dictionnary holds the parameters supporting the app:// protocol.
  */
dictionary AppInfo
{
  DOMString path = "";
  boolean   isCoreApp = false;
};
 
/* ---------------------- AppNotificationServiceOptions ----------------------------- */ 
/* ./webidl/AppNotificationServiceOptions.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

interface MozObserver;

dictionary AppNotificationServiceOptions {
  boolean textClickable = false;
  DOMString manifestURL = "";
  DOMString id = "";
  DOMString dbId = "";
  DOMString dir = "";
  DOMString lang = "";
  DOMString tag = "";
  DOMString data = "";
  NotificationBehavior mozbehavior = {};
};
 
/* ---------------------- APZTestData ----------------------------- */ 
/* ./webidl/APZTestData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * This file declares data structures used to communicate data logged by
 * various components for the purpose of APZ testing (see bug 961289 and
 * gfx/layers/apz/test/APZTestData.h) to JS test code.
 */

// A single key-value pair in the data.
dictionary ScrollFrameDataEntry {
  DOMString key;
  DOMString value;
};

// All the key-value pairs associated with a given scrollable frame.
// The scrollable frame is identified by a scroll id.
dictionary ScrollFrameData {
  unsigned long long scrollId;
  sequence<ScrollFrameDataEntry> entries;
};

// All the scrollable frames associated with a given paint or repaint request.
// The paint or repaint request is identified by a sequence number.
dictionary APZBucket {
  unsigned long sequenceNumber;
  sequence<ScrollFrameData> scrollFrames;
};

[Pref="apz.test.logging_enabled",
 Exposed=Window]
namespace APZHitResultFlags {
  // These constants should be kept in sync with mozilla::gfx::CompositorHitTestInfo
  const unsigned short INVISIBLE = 0;
  const unsigned short VISIBLE = 0x0001;
  const unsigned short IRREGULAR_AREA = 0x0002;
  const unsigned short APZ_AWARE_LISTENERS = 0x0004;
  const unsigned short INACTIVE_SCROLLFRAME = 0x0008;
  const unsigned short PAN_X_DISABLED = 0x0010;
  const unsigned short PAN_Y_DISABLED = 0x0020;
  const unsigned short PINCH_ZOOM_DISABLED = 0x0040;
  const unsigned short DOUBLE_TAP_ZOOM_DISABLED = 0x0080;
  const unsigned short SCROLLBAR = 0x0100;
  const unsigned short SCROLLBAR_THUMB = 0x0200;
  const unsigned short SCROLLBAR_VERTICAL = 0x0400;
  const unsigned short REQUIRES_TARGET_CONFIRMATION = 0x0800;
};

dictionary APZHitResult {
  float screenX;
  float screenY;
  unsigned short hitResult; // combination of the APZHitResultFlags.* flags
  unsigned long long layersId;
  unsigned long long scrollId;
};

dictionary APZSampledResult {
  float scrollOffsetX;
  float scrollOffsetY;
  DOMHighResTimeStamp sampledTimeStamp;
  unsigned long long layersId;
  unsigned long long scrollId;
};

dictionary AdditionalDataEntry {
  DOMString key;
  DOMString value;
};

// All the paints and repaint requests. This is the top-level data structure.
[GenerateConversionToJS]
dictionary APZTestData {
  sequence<APZBucket> paints;
  sequence<APZBucket> repaintRequests;
  sequence<APZHitResult> hitResults;
  sequence<APZSampledResult> sampledResults;
  sequence<AdditionalDataEntry> additionalData;
};

// A frame uniformity measurement for every scrollable layer
dictionary FrameUniformity {
  unsigned long layerAddress;
  float frameUniformity;
};

[GenerateConversionToJS]
dictionary FrameUniformityResults {
  sequence<FrameUniformity> layerUniformities;
};
 
/* ---------------------- ARIAMixin ----------------------------- */ 
/* ./webidl/ARIAMixin.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/aria/#ARIAMixin
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

interface mixin ARIAMixin {
  [Pref="accessibility.ARIAElementReflection.enabled", CEReactions]
  attribute Element? ariaActiveDescendantElement;

  [CEReactions, SetterThrows]
  attribute DOMString? role;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaAtomic;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaAutoComplete;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaBrailleLabel;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaBrailleRoleDescription;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaBusy;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaChecked;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaColCount;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaColIndex;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaColIndexText;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaColSpan;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaCurrent;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaDescription;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaDisabled;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaExpanded;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaHasPopup;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaHidden;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaInvalid;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaKeyShortcuts;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaLabel;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaLevel;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaLive;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaModal;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaMultiLine;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaMultiSelectable;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaOrientation;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaPlaceholder;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaPosInSet;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaPressed;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaReadOnly;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRelevant;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRequired;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRoleDescription;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRowCount;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRowIndex;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRowIndexText;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaRowSpan;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaSelected;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaSetSize;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaSort;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaValueMax;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaValueMin;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaValueNow;

  [CEReactions, SetterThrows]
  attribute DOMString? ariaValueText;
};
 
/* ---------------------- Attr ----------------------------- */ 
/* ./webidl/Attr.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface Attr : Node {
  readonly attribute DOMString localName;
           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString value;

  [Constant]
  readonly attribute DOMString name;
  [Constant]
  readonly attribute DOMString? namespaceURI;
  [Constant]
  readonly attribute DOMString? prefix;

  readonly attribute boolean specified;
};

// Mozilla extensions

partial interface Attr {
  readonly attribute Element? ownerElement;
};
 
/* ---------------------- AudioBuffer ----------------------------- */ 
/* ./webidl/AudioBuffer.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary AudioBufferOptions {
             unsigned long numberOfChannels = 1;
    required unsigned long length;
    required float         sampleRate;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioBuffer {
    [Throws]
    constructor(AudioBufferOptions options);

    readonly attribute float sampleRate;
    readonly attribute unsigned long length;

    // in seconds
    readonly attribute double duration;

    readonly attribute unsigned long numberOfChannels;

    [Throws]
    Float32Array getChannelData(unsigned long channel);

    [Throws]
    undefined copyFromChannel(Float32Array destination, unsigned long channelNumber, optional unsigned long startInChannel = 0);
    [Throws]
    undefined copyToChannel(Float32Array source, unsigned long channelNumber, optional unsigned long startInChannel = 0);
};
 
/* ---------------------- AudioBufferSourceNode ----------------------------- */ 
/* ./webidl/AudioBufferSourceNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary AudioBufferSourceOptions {
             AudioBuffer? buffer;
             float        detune = 0;
             boolean      loop = false;
             double       loopEnd = 0;
             double       loopStart = 0;
             float        playbackRate = 1;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioBufferSourceNode : AudioScheduledSourceNode {
    constructor(BaseAudioContext context,
                optional AudioBufferSourceOptions options = {});

    [SetterThrows]
    attribute AudioBuffer? buffer;

    readonly attribute AudioParam playbackRate;
    readonly attribute AudioParam detune;

    attribute boolean loop;
    attribute double loopStart;
    attribute double loopEnd;

    [Throws]
    undefined start(optional double when = 0, optional double grainOffset = 0,
                    optional double grainDuration);
};

// Mozilla extensions
AudioBufferSourceNode includes AudioNodePassThrough;
 
/* ---------------------- AudioContext ----------------------------- */ 
/* ./webidl/AudioContext.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary AudioContextOptions {
             float        sampleRate;
};

dictionary AudioTimestamp {
  double contextTime;
  DOMHighResTimeStamp performanceTime;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioContext : BaseAudioContext {
    [Throws]
    constructor(optional AudioContextOptions contextOptions = {});

    readonly        attribute double               baseLatency;
    readonly        attribute double               outputLatency;
    AudioTimestamp                  getOutputTimestamp();

    [NewObject]
    Promise<undefined> suspend();
    [NewObject]
    Promise<undefined> close();

    [NewObject, Throws]
    MediaElementAudioSourceNode createMediaElementSource(HTMLMediaElement mediaElement);

    [NewObject, Throws]
    MediaStreamAudioSourceNode createMediaStreamSource(MediaStream mediaStream);

    [NewObject, Throws]
    MediaStreamTrackAudioSourceNode createMediaStreamTrackSource(MediaStreamTrack mediaStreamTrack);

    [NewObject, Throws]
    MediaStreamAudioDestinationNode createMediaStreamDestination();
};
 
/* ---------------------- AudioData ----------------------------- */ 
/* ./webidl/AudioData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webcodecs/#audiodata
 */

// [Serializable, Transferable] are implemented without adding attributes here,
// but directly with {Read,Write}StructuredClone and Transfer/FromTransfered.
[Exposed=(Window,DedicatedWorker), Pref="dom.media.webcodecs.enabled"]
interface AudioData {
  [Throws]
  constructor(AudioDataInit init);

  readonly attribute AudioSampleFormat? format;
  readonly attribute float sampleRate;
  readonly attribute unsigned long numberOfFrames;
  readonly attribute unsigned long numberOfChannels;
  readonly attribute unsigned long long duration;  // microseconds
  readonly attribute long long timestamp;          // microseconds

  [Throws]
  unsigned long allocationSize(AudioDataCopyToOptions options);
  [Throws]
  undefined copyTo(
      // bug 1696216: Should be `copyTo(AllowSharedBufferSource destination, ...)`
      ([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) destination,
       AudioDataCopyToOptions options);
  [Throws]
  AudioData clone();
  undefined close();
};

dictionary AudioDataInit {
  required AudioSampleFormat format;
  required float sampleRate;
  required [EnforceRange] unsigned long numberOfFrames;
  required [EnforceRange] unsigned long numberOfChannels;
  required [EnforceRange] long long timestamp;  // microseconds
  // bug 1696216: Should be AllowSharedBufferSource
  required ([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) data;
  sequence<ArrayBuffer> transfer = [];
};

enum AudioSampleFormat {
  "u8",
  "s16",
  "s32",
  "f32",
  "u8-planar",
  "s16-planar",
  "s32-planar",
  "f32-planar",
};

dictionary AudioDataCopyToOptions {
  required [EnforceRange] unsigned long planeIndex;
  [EnforceRange] unsigned long frameOffset = 0;
  [EnforceRange] unsigned long frameCount;
  AudioSampleFormat format;
};
 
/* ---------------------- AudioDecoder ----------------------------- */ 
/* ./webidl/AudioDecoder.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webcodecs/#audiodecoder
 */

[Exposed=(Window,DedicatedWorker), SecureContext, Pref="dom.media.webcodecs.enabled"]
interface AudioDecoder : EventTarget {
  [Throws]
  constructor(AudioDecoderInit init);

  readonly attribute CodecState state;
  readonly attribute unsigned long decodeQueueSize;
  attribute EventHandler ondequeue;

  [Throws]
  undefined configure(AudioDecoderConfig config);
  [Throws]
  undefined decode(EncodedAudioChunk chunk);
  [NewObject, Throws]
  Promise<undefined> flush();
  [Throws]
  undefined reset();
  [Throws]
  undefined close();

  [NewObject, Throws]
  static Promise<AudioDecoderSupport> isConfigSupported(AudioDecoderConfig config);
};

dictionary AudioDecoderInit {
  required AudioDataOutputCallback output;
  required WebCodecsErrorCallback error;
};

callback AudioDataOutputCallback = undefined(AudioData output);

dictionary AudioDecoderSupport {
  boolean supported;
  AudioDecoderConfig config;
};

dictionary AudioDecoderConfig {
  required DOMString codec;
  required [EnforceRange] unsigned long sampleRate;
  required [EnforceRange] unsigned long numberOfChannels;

  // Bug 1696216: Should be AllowSharedBufferSource
  ([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) description;
};
 
/* ---------------------- AudioDestinationNode ----------------------------- */ 
/* ./webidl/AudioDestinationNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioDestinationNode : AudioNode {

    readonly attribute unsigned long maxChannelCount;

};
 
/* ---------------------- AudioEncoder ----------------------------- */ 
/* ./webidl/AudioEncoder.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webcodecs/#audioencoder

 * Some members of this API are codec-specific, in which case the source of the
 * IDL are in the codec-specific registry entries, that are listed in
 * https://w3c.github.io/webcodecs/codec_registry.html. Those members are
 * commented with a link of the document in which the member is listed.
 */

dictionary AudioEncoderSupport {
  boolean supported;
  AudioEncoderConfig config;
};

dictionary AudioEncoderConfig {
  required DOMString codec;
  [EnforceRange] unsigned long sampleRate;
  [EnforceRange] unsigned long numberOfChannels;
  [EnforceRange] unsigned long long bitrate;
  BitrateMode bitrateMode = "variable";
  OpusEncoderConfig opus;
};

// Opus specific configuration options:
// https://w3c.github.io/webcodecs/opus_codec_registration.html
enum OpusBitstreamFormat {
  "opus",
  "ogg",
};

dictionary OpusEncoderConfig {
  OpusBitstreamFormat format = "opus";
  [EnforceRange] unsigned long long frameDuration = 20000;
  [EnforceRange] unsigned long complexity;
  [EnforceRange] unsigned long packetlossperc = 0;
  boolean useinbandfec = false;
  boolean usedtx = false;
};

[Exposed=(Window,DedicatedWorker), SecureContext, Pref="dom.media.webcodecs.enabled"]
interface AudioEncoder : EventTarget {
  [Throws]
  constructor(AudioEncoderInit init);

  readonly attribute CodecState state;
  readonly attribute unsigned long encodeQueueSize;
  attribute EventHandler ondequeue;

  [Throws]
  undefined configure(AudioEncoderConfig config);
  [Throws, BinaryName="AudioEncoder::EncodeAudioData"]
  undefined encode(AudioData data);
  [Throws]
  Promise<undefined> flush();
  [Throws]
  undefined reset();
  [Throws]
  undefined close();

  [NewObject, Throws]
  static Promise<AudioEncoderSupport> isConfigSupported(AudioEncoderConfig config);
};

dictionary AudioEncoderInit {
  required EncodedAudioChunkOutputCallback output;
  required WebCodecsErrorCallback error;
};

callback EncodedAudioChunkOutputCallback =
    undefined (EncodedAudioChunk output,
               optional EncodedAudioChunkMetadata metadata = {});

dictionary EncodedAudioChunkMetadata {
  AudioDecoderConfig decoderConfig;
};
 
/* ---------------------- AudioListener ----------------------------- */ 
/* ./webidl/AudioListener.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioListener {
    // Uses a 3D cartesian coordinate system
    undefined setPosition(double x, double y, double z);
    undefined setOrientation(double x, double y, double z, double xUp, double yUp, double zUp);
};
 
/* ---------------------- AudioNode ----------------------------- */ 
/* ./webidl/AudioNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum ChannelCountMode {
    "max",
    "clamped-max",
    "explicit"
};

enum ChannelInterpretation {
    "speakers",
    "discrete"
};

dictionary AudioNodeOptions {
             unsigned long         channelCount;
             ChannelCountMode      channelCountMode;
             ChannelInterpretation channelInterpretation;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioNode : EventTarget {

    [Throws]
    AudioNode connect(AudioNode destination, optional unsigned long output = 0, optional unsigned long input = 0);
    [Throws]
    undefined connect(AudioParam destination, optional unsigned long output = 0);
    [Throws]
    undefined disconnect();
    [Throws]
    undefined disconnect(unsigned long output);
    [Throws]
    undefined disconnect(AudioNode destination);
    [Throws]
    undefined disconnect(AudioNode destination, unsigned long output);
    [Throws]
    undefined disconnect(AudioNode destination, unsigned long output, unsigned long input);
    [Throws]
    undefined disconnect(AudioParam destination);
    [Throws]
    undefined disconnect(AudioParam destination, unsigned long output);

    readonly attribute BaseAudioContext context;
    readonly attribute unsigned long numberOfInputs;
    readonly attribute unsigned long numberOfOutputs;

    // Channel up-mixing and down-mixing rules for all inputs.
    [SetterThrows]
    attribute unsigned long channelCount;
    [SetterThrows, BinaryName="channelCountModeValue"]
    attribute ChannelCountMode channelCountMode;
    [SetterThrows, BinaryName="channelInterpretationValue"]
    attribute ChannelInterpretation channelInterpretation;

};

// Mozilla extension
partial interface AudioNode {
  [ChromeOnly]
  readonly attribute unsigned long id;
};
interface mixin AudioNodePassThrough {
  [ChromeOnly]
  attribute boolean passThrough;
};
 
/* ---------------------- AudioParam ----------------------------- */ 
/* ./webidl/AudioParam.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#enumdef-automationrate
 * https://webaudio.github.io/web-audio-api/#audioparam
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum AutomationRate {
    "a-rate",
    "k-rate"
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioParam {
    [SetterThrows]
                    attribute float value;
    readonly        attribute float defaultValue;
    readonly        attribute float minValue;
    readonly        attribute float maxValue;

    // Parameter automation.
    [Throws]
    AudioParam setValueAtTime(float value, double startTime);
    [Throws]
    AudioParam linearRampToValueAtTime(float value, double endTime);
    [Throws]
    AudioParam exponentialRampToValueAtTime(float value, double endTime);

    // Exponentially approach the target value with a rate having the given time constant.
    [Throws]
    AudioParam setTargetAtTime(float target, double startTime, double timeConstant);

    // Sets an array of arbitrary parameter values starting at time for the given duration.
    // The number of values will be scaled to fit into the desired duration.
    [Throws]
    AudioParam setValueCurveAtTime(sequence<float> values, double startTime, double duration);

    // Cancels all scheduled parameter changes with times greater than or equal to startTime.
    [Throws]
    AudioParam cancelScheduledValues(double startTime);

};

// Mozilla extension
partial interface AudioParam {
  // The ID of the AudioNode this AudioParam belongs to.
  [ChromeOnly]
  readonly attribute unsigned long parentNodeId;
  // The name of the AudioParam
  [ChromeOnly]
  readonly attribute DOMString name;
};

partial interface AudioParam {
  // This attribute is used for mochitest only.
  [ChromeOnly]
  readonly attribute boolean isTrackSuspended;
};
 
/* ---------------------- AudioParamDescriptor ----------------------------- */ 
/* ./webidl/AudioParamDescriptor.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#dictdef-audioparamdescriptor
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[GenerateInit]
dictionary AudioParamDescriptor {
    required DOMString name;
    float defaultValue = 0;
    float minValue = -3.4028235e38;
    float maxValue = 3.4028235e38;
    // AutomationRate for AudioWorklet is not needed until bug 1504984 is
    // implemented
    // AutomationRate automationRate = "a-rate";
};
 
/* ---------------------- AudioParamMap ----------------------------- */ 
/* ./webidl/AudioParamMap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#audioparammap
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[SecureContext, Exposed=Window]
interface AudioParamMap {
    readonly maplike<DOMString, AudioParam>;
};
 
/* ---------------------- AudioProcessingEvent ----------------------------- */ 
/* ./webidl/AudioProcessingEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface AudioProcessingEvent : Event {

  readonly attribute double playbackTime;

  [Throws]
  readonly attribute AudioBuffer inputBuffer;
  [Throws]
  readonly attribute AudioBuffer outputBuffer;

};
 
/* ---------------------- AudioScheduledSourceNode ----------------------------- */ 
/* ./webidl/AudioScheduledSourceNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#idl-def-AudioScheduledSourceNode
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface AudioScheduledSourceNode : AudioNode {
                    attribute EventHandler onended;
    [Throws]
    undefined start (optional double when = 0);

    [Throws]
    undefined stop (optional double when = 0);
};
 
/* ---------------------- AudioTrack ----------------------------- */ 
/* ./webidl/AudioTrack.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#audiotrack
 */

[Pref="media.track.enabled",
 Exposed=Window]
interface AudioTrack {
  readonly attribute DOMString id;
  readonly attribute DOMString kind;
  readonly attribute DOMString label;
  readonly attribute DOMString language;
           attribute boolean enabled;
};
 
/* ---------------------- AudioTrackList ----------------------------- */ 
/* ./webidl/AudioTrackList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#audiotracklist
 */

[Pref="media.track.enabled",
 Exposed=Window]
interface AudioTrackList : EventTarget {
  readonly attribute unsigned long length;
  getter AudioTrack (unsigned long index);
  AudioTrack? getTrackById(DOMString id);

           attribute EventHandler onchange;
           attribute EventHandler onaddtrack;
           attribute EventHandler onremovetrack;
};
 
/* ---------------------- AudioWorklet ----------------------------- */ 
/* ./webidl/AudioWorklet.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window, SecureContext]
interface AudioWorklet : Worklet {
};
 
/* ---------------------- AudioWorkletGlobalScope ----------------------------- */ 
/* ./webidl/AudioWorkletGlobalScope.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#audioworkletglobalscope
 */

callback constructor AudioWorkletProcessorConstructor = AudioWorkletProcessor (object options);

[Global=(Worklet,AudioWorklet),Exposed=AudioWorklet]
interface AudioWorkletGlobalScope : WorkletGlobalScope {
    [Throws]
    undefined registerProcessor (DOMString name, AudioWorkletProcessorConstructor processorCtor);
    readonly  attribute   unsigned long long currentFrame;
    readonly  attribute   double currentTime;
    readonly  attribute   float sampleRate;
};
 
/* ---------------------- AudioWorkletNode ----------------------------- */ 
/* ./webidl/AudioWorkletNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[GenerateConversionToJS]
dictionary AudioWorkletNodeOptions : AudioNodeOptions {
             unsigned long             numberOfInputs = 1;
             unsigned long             numberOfOutputs = 1;
             sequence<unsigned long>   outputChannelCount;
             record<DOMString, double> parameterData;
             object                    processorOptions;
};

[SecureContext, Exposed=Window]
interface AudioWorkletNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context, DOMString name,
                optional AudioWorkletNodeOptions options = {});

    [Throws]
    readonly        attribute AudioParamMap              parameters;
    readonly        attribute MessagePort                port;
                    attribute EventHandler               onprocessorerror;
};
 
/* ---------------------- AudioWorkletProcessor ----------------------------- */ 
/* ./webidl/AudioWorkletProcessor.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#audioworkletprocessor
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=AudioWorklet]
interface AudioWorkletProcessor {
  [Throws]
  constructor();

  readonly attribute MessagePort port;
};
 
/* ---------------------- AutocompleteInfo ----------------------------- */ 
/* ./webidl/AutocompleteInfo.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * This dictionary is used for the input, textarea and select element's
 * getAutocompleteInfo method.
 */

dictionary AutocompleteInfo {
  DOMString section = "";
  DOMString addressType = "";
  DOMString contactType = "";
  DOMString fieldName = "";
  DOMString credentialType = "";
  boolean canAutomaticallyPersist = true;
};
 
/* ---------------------- BarProp ----------------------------- */ 
/* ./webidl/BarProp.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface BarProp
{
  [Throws, NeedsCallerType]
           attribute boolean visible;
};
 
/* ---------------------- BaseAudioContext ----------------------------- */ 
/* ./webidl/BaseAudioContext.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/#idl-def-BaseAudioContext
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

callback DecodeSuccessCallback = undefined (AudioBuffer decodedData);
callback DecodeErrorCallback = undefined (DOMException error);

enum AudioContextState {
    "suspended",
    "running",
    "closed"
};

[Exposed=Window]
interface BaseAudioContext : EventTarget {
    readonly        attribute AudioDestinationNode destination;
    readonly        attribute float                sampleRate;
    readonly        attribute double               currentTime;
    readonly        attribute AudioListener        listener;
    readonly        attribute AudioContextState    state;
    [Throws, SameObject, SecureContext]
    readonly        attribute AudioWorklet         audioWorklet;

    [NewObject]
    Promise<undefined> resume();

                    attribute EventHandler         onstatechange;

    [NewObject, Throws]
    AudioBuffer            createBuffer (unsigned long numberOfChannels,
                                         unsigned long length,
                                         float sampleRate);

    [NewObject]
    Promise<AudioBuffer> decodeAudioData(ArrayBuffer audioData,
                                         optional DecodeSuccessCallback successCallback,
                                         optional DecodeErrorCallback errorCallback);

    // AudioNode creation
    [NewObject]
    AudioBufferSourceNode createBufferSource();

    [NewObject]
    ConstantSourceNode createConstantSource();

    [NewObject, Throws]
    ScriptProcessorNode createScriptProcessor(optional unsigned long bufferSize = 0,
                                              optional unsigned long numberOfInputChannels = 2,
                                              optional unsigned long numberOfOutputChannels = 2);

    [NewObject, Throws]
    AnalyserNode createAnalyser();

    [NewObject, Throws]
    GainNode createGain();

    [NewObject, Throws]
    DelayNode createDelay(optional double maxDelayTime = 1); // TODO: no = 1

    [NewObject, Throws]
    BiquadFilterNode createBiquadFilter();

    [NewObject, Throws]
    IIRFilterNode createIIRFilter(sequence<double> feedforward, sequence<double> feedback);

    [NewObject, Throws]
    WaveShaperNode createWaveShaper();

    [NewObject, Throws]
    PannerNode createPanner();

    [NewObject, Throws]
    StereoPannerNode createStereoPanner();

    [NewObject, Throws]
    ConvolverNode createConvolver();

    [NewObject, Throws]
    ChannelSplitterNode createChannelSplitter(optional unsigned long numberOfOutputs = 6);

    [NewObject, Throws]
    ChannelMergerNode createChannelMerger(optional unsigned long numberOfInputs = 6);

    [NewObject, Throws]
    DynamicsCompressorNode createDynamicsCompressor();

    [NewObject, Throws]
    OscillatorNode createOscillator();

    [NewObject, Throws]
    PeriodicWave createPeriodicWave(sequence<float> real,
                                    sequence<float> imag,
                                    optional PeriodicWaveConstraints constraints = {});
};
 
/* ---------------------- BaseKeyframeTypes ----------------------------- */ 
/* ./webidl/BaseKeyframeTypes.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#the-compositeoperation-enumeration
 * https://drafts.csswg.org/web-animations/#dictdef-basepropertyindexedkeyframe
 * https://drafts.csswg.org/web-animations/#dictdef-basekeyframe
 * https://drafts.csswg.org/web-animations/#dictdef-basecomputedkeyframe
 *
 * Copyright © 2016 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum CompositeOperation { "replace", "add", "accumulate" };

// NOTE: The order of the values in this enum are important.
//
// We assume that CompositeOperation is a subset of CompositeOperationOrAuto so
// that we can cast between the two types (provided the value is not "auto").
//
// If that assumption ceases to hold we will need to update the conversion
// in KeyframeUtils::GetAnimationPropertiesFromKeyframes.
enum CompositeOperationOrAuto { "replace", "add", "accumulate", "auto" };

// The following dictionary types are not referred to by other .webidl files,
// but we use it for manual JS->IDL and IDL->JS conversions in KeyframeEffect's
// implementation.

[GenerateInit]
dictionary BasePropertyIndexedKeyframe {
  (double? or sequence<double?>) offset = [];
  (UTF8String or sequence<UTF8String>) easing = [];
  (CompositeOperationOrAuto or sequence<CompositeOperationOrAuto>) composite = [];
};

[GenerateInit]
dictionary BaseKeyframe {
  double? offset = null;
  UTF8String easing = "linear";
  [Pref="dom.animations-api.compositing.enabled"]
  CompositeOperationOrAuto composite = "auto";

  // Non-standard extensions

  // Member to allow testing when StyleAnimationValue::ComputeValues fails.
  //
  // Note that we currently only apply this to shorthand properties since
  // it's easier to annotate shorthand property values and because we have
  // only ever observed ComputeValues failing on shorthand values.
  //
  // Bug 1216844 should remove this member since after that bug is fixed we will
  // have a well-defined behavior to use when animation endpoints are not
  // available.
  [ChromeOnly] boolean simulateComputeValuesFailure = false;
};

[GenerateConversionToJS]
dictionary BaseComputedKeyframe : BaseKeyframe {
  double computedOffset;
};
 
/* ---------------------- BasicCardPayment ----------------------------- */ 
/* ./webidl/BasicCardPayment.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https://www.w3.org/TR/payment-method-basic-card/
 */

[GenerateInit]
dictionary BasicCardRequest {
  sequence<DOMString> supportedNetworks = [];
  boolean requestSecurityCode = true;
};

[GenerateConversionToJS]
dictionary BasicCardResponse {
           DOMString cardholderName = "";
  required DOMString cardNumber;
           DOMString expiryMonth = "";
           DOMString expiryYear = "";
           DOMString cardSecurityCode = "";
           PaymentAddress? billingAddress = null;
};

[GenerateConversionToJS]
dictionary BasicCardChangeDetails {
  PaymentAddress? billingAddress = null;
};

[GenerateInit]
dictionary BasicCardErrors {
  DOMString cardNumber;
  DOMString cardholderName;
  DOMString cardSecurityCode;
  DOMString expiryMonth;
  DOMString expiryYear;
  AddressErrors billingAddress;
};
 
/* ---------------------- BatteryManager ----------------------------- */ 
/* ./webidl/BatteryManager.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/battery-status/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[ChromeOnly, Exposed=Window]
interface BatteryManager : EventTarget {
    readonly attribute boolean             charging;
    readonly attribute unrestricted double chargingTime;
    readonly attribute unrestricted double dischargingTime;
    readonly attribute double              level;

             attribute EventHandler        onchargingchange;
             attribute EventHandler        onchargingtimechange;
             attribute EventHandler        ondischargingtimechange;
             attribute EventHandler        onlevelchange;
};
 
/* ---------------------- BeforeUnloadEvent ----------------------------- */ 
/* ./webidl/BeforeUnloadEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * http://www.whatwg.org/specs/web-apps/current-work/#beforeunloadevent
 */

[Exposed=Window]
interface BeforeUnloadEvent : Event {
  attribute DOMString returnValue;
};
 
/* ---------------------- BiquadFilterNode ----------------------------- */ 
/* ./webidl/BiquadFilterNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum BiquadFilterType {
  "lowpass",
  "highpass",
  "bandpass",
  "lowshelf",
  "highshelf",
  "peaking",
  "notch",
  "allpass"
};

dictionary BiquadFilterOptions : AudioNodeOptions {
             BiquadFilterType type = "lowpass";
             float            Q = 1;
             float            detune = 0;
             float            frequency = 350;
             float            gain = 0;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface BiquadFilterNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context,
                optional BiquadFilterOptions options = {});

    attribute BiquadFilterType type;
    readonly attribute AudioParam frequency; // in Hertz
    readonly attribute AudioParam detune; // in Cents
    readonly attribute AudioParam Q; // Quality factor
    readonly attribute AudioParam gain; // in Decibels

    [Throws]
    undefined getFrequencyResponse(Float32Array frequencyHz,
                                   Float32Array magResponse,
                                   Float32Array phaseResponse);

};

// Mozilla extension
BiquadFilterNode includes  AudioNodePassThrough;
 
/* ---------------------- Blob ----------------------------- */ 
/* ./webidl/Blob.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/FileAPI/#blob
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

typedef (BufferSource or Blob or UTF8String) BlobPart;

[Exposed=(Window,Worker)]
interface Blob {
  [Throws]
  constructor(optional sequence<BlobPart> blobParts,
              optional BlobPropertyBag options = {});

  [GetterThrows]
  readonly attribute unsigned long long size;

  readonly attribute DOMString type;

  //slice Blob into byte-ranged chunks

  [Throws]
  Blob slice(optional [Clamp] long long start,
             optional [Clamp] long long end,
             optional DOMString contentType);

  // read from the Blob.
  [NewObject, Throws] ReadableStream stream();
  [NewObject] Promise<USVString> text();
  [NewObject] Promise<ArrayBuffer> arrayBuffer();
};

enum EndingType { "transparent", "native" };

dictionary BlobPropertyBag {
  DOMString type = "";
  EndingType endings = "transparent";
};

partial interface Blob {
  // This returns the type of BlobImpl used for this Blob.
  [ChromeOnly]
  readonly attribute DOMString blobImplType;
};
 
/* ---------------------- BlobEvent ----------------------------- */ 
/* ./webidl/BlobEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is:
 * https://w3c.github.io/mediacapture-record/#blobevent-section
 */

[Exposed=Window]
interface BlobEvent : Event
{
  constructor(DOMString type, BlobEventInit eventInitDict);
  readonly attribute Blob data;
};

dictionary BlobEventInit : EventInit
{
  required Blob data;
};
 
/* ---------------------- BroadcastChannel ----------------------------- */ 
/* ./webidl/BroadcastChannel.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://html.spec.whatwg.org/#broadcastchannel
 */

[Exposed=(Window,Worker)]
interface BroadcastChannel : EventTarget {
  [Throws]
  constructor(DOMString channel);

  readonly attribute DOMString name;

  [Throws]
  undefined postMessage(any message);

  undefined close();

  attribute EventHandler onmessage;
  attribute EventHandler onmessageerror;
};
 
/* ---------------------- BrowserElementDictionaries ----------------------------- */ 
/* ./webidl/BrowserElementDictionaries.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[GenerateConversionToJS]
dictionary OpenWindowEventDetail {
  DOMString url = "";
  DOMString name = "";
  DOMString features = "";
  Node? frameElement = null;
  boolean forceNoReferrer = false;
};

[GenerateConversionToJS]
dictionary DOMWindowResizeEventDetail {
  long width = 0;
  long height = 0;
};
 
/* ---------------------- Cache ----------------------------- */ 
/* ./webidl/Cache.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/ServiceWorker/#cache-interface
 */

[Exposed=(Window,Worker),
 Func="nsGlobalWindowInner::CachesEnabled"]
interface Cache {
  [NewObject]
  Promise<Response> match(RequestInfo request, optional CacheQueryOptions options = {});
  [NewObject]
  Promise<sequence<Response>> matchAll(optional RequestInfo request, optional CacheQueryOptions options = {});
  [NewObject, NeedsCallerType]
  Promise<undefined> add(RequestInfo request);
  [NewObject, NeedsCallerType]
  Promise<undefined> addAll(sequence<RequestInfo> requests);
  [NewObject]
  Promise<undefined> put(RequestInfo request, Response response);
  [NewObject]
  Promise<boolean> delete(RequestInfo request, optional CacheQueryOptions options = {});
  [NewObject]
  Promise<sequence<Request>> keys(optional RequestInfo request, optional CacheQueryOptions options = {});
};

dictionary CacheQueryOptions {
  boolean ignoreSearch = false;
  boolean ignoreMethod = false;
  boolean ignoreVary = false;
};

dictionary CacheBatchOperation {
  DOMString type;
  Request request;
  Response response;
  CacheQueryOptions options;
};
 
/* ---------------------- CacheStorage ----------------------------- */ 
/* ./webidl/CacheStorage.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/ServiceWorker/#cachestorage-interface
 */

interface Principal;

[Exposed=(Window,Worker),
 Func="nsGlobalWindowInner::CachesEnabled"]
interface CacheStorage {
  [Throws, ChromeOnly]
  constructor(CacheStorageNamespace namespace, Principal principal);

  [NewObject]
  Promise<Response> match(RequestInfo request, optional MultiCacheQueryOptions options = {});
  [NewObject]
  Promise<boolean> has(DOMString cacheName);
  [NewObject]
  Promise<Cache> open(DOMString cacheName);
  [NewObject]
  Promise<boolean> delete(DOMString cacheName);
  [NewObject]
  Promise<sequence<DOMString>> keys();
};

dictionary MultiCacheQueryOptions : CacheQueryOptions {
  DOMString cacheName;
};

// chrome-only, gecko specific extension
enum CacheStorageNamespace {
  "content", "chrome"
};
 
/* ---------------------- CancelContentJSOptions ----------------------------- */ 
/* ./webidl/CancelContentJSOptions.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

[GenerateInit]
dictionary CancelContentJSOptions {
  long index = 0;
  URI? uri = null;
  long epoch = 0;
};
 
/* ---------------------- CanvasCaptureMediaStream ----------------------------- */ 
/* ./webidl/CanvasCaptureMediaStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/mediacapture-fromelement/index.html
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface CanvasCaptureMediaStream : MediaStream {
    readonly attribute HTMLCanvasElement canvas;
    undefined requestFrame();
};
 
/* ---------------------- CanvasRenderingContext2D ----------------------------- */ 
/* ./webidl/CanvasRenderingContext2D.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

enum CanvasWindingRule { "nonzero", "evenodd" };

enum CanvasLineCap { "butt", "round", "square" };
enum CanvasLineJoin { "round", "bevel", "miter" };
enum CanvasTextAlign { "start", "end", "left", "right", "center" };
enum CanvasTextBaseline { "top", "hanging", "middle", "alphabetic", "ideographic", "bottom" };
enum CanvasDirection { "ltr", "rtl", "inherit" };
enum CanvasFontKerning { "auto", "normal", "none" };
enum CanvasFontStretch { "ultra-condensed", "extra-condensed", "condensed", "semi-condensed", "normal", "semi-expanded", "expanded", "extra-expanded", "ultra-expanded" };
enum CanvasFontVariantCaps { "normal", "small-caps", "all-small-caps", "petite-caps", "all-petite-caps", "unicase", "titling-caps" };
enum CanvasTextRendering { "auto", "optimizeSpeed", "optimizeLegibility", "geometricPrecision" };

[GenerateInit]
dictionary CanvasRenderingContext2DSettings {
  // signal if the canvas contains an alpha channel
  boolean alpha = true;

  boolean desynchronized = false;

  PredefinedColorSpace colorSpace = "srgb";

  // whether or not we're planning to do a lot of readback operations
  boolean willReadFrequently = false;
};

dictionary HitRegionOptions {
  Path2D? path = null;
  DOMString id = "";
  Element? control = null;
};

typedef (HTMLImageElement or
         SVGImageElement) HTMLOrSVGImageElement;

typedef (HTMLOrSVGImageElement or
         HTMLCanvasElement or
         HTMLVideoElement or
         OffscreenCanvas or
         ImageBitmap or
         VideoFrame) CanvasImageSource;

[Exposed=Window]
interface CanvasRenderingContext2D {

  // back-reference to the canvas.  Might be null if we're not
  // associated with a canvas.
  readonly attribute HTMLCanvasElement? canvas;

  CanvasRenderingContext2DSettings getContextAttributes();

  // Show the caret if appropriate when drawing
  [Func="CanvasUtils::HasDrawWindowPrivilege"]
  const unsigned long DRAWWINDOW_DRAW_CARET   = 0x01;
  // Don't flush pending layout notifications that could otherwise
  // be batched up
  [Func="CanvasUtils::HasDrawWindowPrivilege"]
  const unsigned long DRAWWINDOW_DO_NOT_FLUSH = 0x02;
  // Draw scrollbars and scroll the viewport if they are present
  [Func="CanvasUtils::HasDrawWindowPrivilege"]
  const unsigned long DRAWWINDOW_DRAW_VIEW    = 0x04;
  // Use the widget layer manager if available. This means hardware
  // acceleration may be used, but it might actually be slower or
  // lower quality than normal. It will however more accurately reflect
  // the pixels rendered to the screen.
  [Func="CanvasUtils::HasDrawWindowPrivilege"]
  const unsigned long DRAWWINDOW_USE_WIDGET_LAYERS = 0x08;
  // Don't synchronously decode images - draw what we have
  [Func="CanvasUtils::HasDrawWindowPrivilege"]
  const unsigned long DRAWWINDOW_ASYNC_DECODE_IMAGES = 0x10;

  /**
   * Renders a region of a window into the canvas.  The contents of
   * the window's viewport are rendered, ignoring viewport clipping
   * and scrolling.
   *
   * @param x
   * @param y
   * @param w
   * @param h specify the area of the window to render, in CSS
   * pixels.
   *
   * @param backgroundColor the canvas is filled with this color
   * before we render the window into it. This color may be
   * transparent/translucent. It is given as a CSS color string
   * (e.g., rgb() or rgba()).
   *
   * @param flags Used to better control the drawWindow call.
   * Flags can be ORed together.
   *
   * Of course, the rendering obeys the current scale, transform and
   * globalAlpha values.
   *
   * Hints:
   * -- If 'rgba(0,0,0,0)' is used for the background color, the
   * drawing will be transparent wherever the window is transparent.
   * -- Top-level browsed documents are usually not transparent
   * because the user's background-color preference is applied,
   * but IFRAMEs are transparent if the page doesn't set a background.
   * -- If an opaque color is used for the background color, rendering
   * will be faster because we won't have to compute the window's
   * transparency.
   *
   * This API cannot currently be used by Web content. It is chrome
   * and Web Extensions (with a permission) only.
   */
  [Throws, NeedsSubjectPrincipal, Func="CanvasUtils::HasDrawWindowPrivilege"]
  undefined drawWindow(Window window, double x, double y, double w, double h,
                       UTF8String bgColor, optional unsigned long flags = 0);

  /**
   * This causes a context that is currently using a hardware-accelerated
   * backend to fallback to a software one. All state should be preserved.
   */
  [ChromeOnly]
  undefined demote();
};

CanvasRenderingContext2D includes CanvasState;
CanvasRenderingContext2D includes CanvasTransform;
CanvasRenderingContext2D includes CanvasCompositing;
CanvasRenderingContext2D includes CanvasImageSmoothing;
CanvasRenderingContext2D includes CanvasFillStrokeStyles;
CanvasRenderingContext2D includes CanvasShadowStyles;
CanvasRenderingContext2D includes CanvasFilters;
CanvasRenderingContext2D includes CanvasRect;
CanvasRenderingContext2D includes CanvasDrawPath;
CanvasRenderingContext2D includes CanvasUserInterface;
CanvasRenderingContext2D includes CanvasText;
CanvasRenderingContext2D includes CanvasDrawImage;
CanvasRenderingContext2D includes CanvasImageData;
CanvasRenderingContext2D includes CanvasPathDrawingStyles;
CanvasRenderingContext2D includes CanvasTextDrawingStyles;
CanvasRenderingContext2D includes CanvasPathMethods;


interface mixin CanvasState {
  // state
  undefined save(); // push state on state stack
  undefined restore(); // pop state stack and restore state
  undefined reset(); // reset the rendering context to its default state
  boolean isContextLost(); // return whether context is lost
};

interface mixin CanvasTransform {
  // transformations (default transform is the identity matrix)
  [Throws, LenientFloat]
  undefined scale(double x, double y);
  [Throws, LenientFloat]
  undefined rotate(double angle);
  [Throws, LenientFloat]
  undefined translate(double x, double y);
  [Throws, LenientFloat]
  undefined transform(double a, double b, double c, double d, double e, double f);

  [NewObject, Throws] DOMMatrix getTransform();
  [Throws, LenientFloat]
  undefined setTransform(double a, double b, double c, double d, double e, double f);
  [Throws]
  undefined setTransform(optional DOMMatrix2DInit transform = {});
  [Throws]
  undefined resetTransform();
};

interface mixin CanvasCompositing {
  attribute unrestricted double globalAlpha; // (default 1.0)
  [Throws]
  attribute DOMString globalCompositeOperation; // (default source-over)
};

interface mixin CanvasImageSmoothing {
  // drawing images
  attribute boolean imageSmoothingEnabled;
};

interface mixin CanvasFillStrokeStyles {
  // colors and styles (see also the CanvasPathDrawingStyles interface)
  attribute (UTF8String or CanvasGradient or CanvasPattern) strokeStyle; // (default black)
  attribute (UTF8String or CanvasGradient or CanvasPattern) fillStyle; // (default black)
  [NewObject]
  CanvasGradient createLinearGradient(double x0, double y0, double x1, double y1);
  [NewObject, Throws]
  CanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1);
  [NewObject]
  CanvasGradient createConicGradient(double angle, double cx, double cy);
  [NewObject, Throws]
  CanvasPattern? createPattern(CanvasImageSource image, [LegacyNullToEmptyString] DOMString repetition);
};

interface mixin CanvasShadowStyles {
  [LenientFloat]
  attribute double shadowOffsetX; // (default 0)
  [LenientFloat]
  attribute double shadowOffsetY; // (default 0)
  [LenientFloat]
  attribute double shadowBlur; // (default 0)
  attribute UTF8String shadowColor; // (default transparent black)
};

interface mixin CanvasFilters {
  [SetterThrows]
  attribute UTF8String filter; // (default empty string = no filter)
};

interface mixin CanvasRect {
  [LenientFloat]
  undefined clearRect(double x, double y, double w, double h);
  [LenientFloat]
  undefined fillRect(double x, double y, double w, double h);
  [LenientFloat]
  undefined strokeRect(double x, double y, double w, double h);
};

interface mixin CanvasDrawPath {
  // path API (see also CanvasPathMethods)
  undefined beginPath();
  undefined fill(optional CanvasWindingRule winding = "nonzero");
  undefined fill(Path2D path, optional CanvasWindingRule winding = "nonzero");
  undefined stroke();
  undefined stroke(Path2D path);
  undefined clip(optional CanvasWindingRule winding = "nonzero");
  undefined clip(Path2D path, optional CanvasWindingRule winding = "nonzero");
// NOT IMPLEMENTED  undefined resetClip();
  [NeedsSubjectPrincipal]
  boolean isPointInPath(unrestricted double x, unrestricted double y, optional CanvasWindingRule winding = "nonzero");
  [NeedsSubjectPrincipal] // Only required because overloads can't have different extended attributes.
  boolean isPointInPath(Path2D path, unrestricted double x, unrestricted double y, optional CanvasWindingRule winding = "nonzero");
  [NeedsSubjectPrincipal]
  boolean isPointInStroke(double x, double y);
  [NeedsSubjectPrincipal] // Only required because overloads can't have different extended attributes.
  boolean isPointInStroke(Path2D path, unrestricted double x, unrestricted double y);
};

interface mixin CanvasUserInterface {
  [Throws] undefined drawFocusIfNeeded(Element element);
// NOT IMPLEMENTED  undefined scrollPathIntoView();
// NOT IMPLEMENTED  undefined scrollPathIntoView(Path path);
};

interface mixin CanvasText {
  // text (see also the CanvasPathDrawingStyles interface)
  [Throws, LenientFloat]
  undefined fillText(DOMString text, double x, double y, optional double maxWidth);
  [Throws, LenientFloat]
  undefined strokeText(DOMString text, double x, double y, optional double maxWidth);
  [NewObject, Throws]
  TextMetrics measureText(DOMString text);
};

interface mixin CanvasDrawImage {
  [Throws, LenientFloat]
  undefined drawImage(CanvasImageSource image, double dx, double dy);
  [Throws, LenientFloat]
  undefined drawImage(CanvasImageSource image, double dx, double dy, double dw, double dh);
  [Throws, LenientFloat]
  undefined drawImage(CanvasImageSource image, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh);
};

// See https://github.com/whatwg/html/issues/6262 for [EnforceRange] usage.
interface mixin CanvasImageData {
  // pixel manipulation
  [NewObject, Throws]
  ImageData createImageData([EnforceRange] long sw, [EnforceRange] long sh);
  [NewObject, Throws]
  ImageData createImageData(ImageData imagedata);
  [NewObject, Throws, NeedsSubjectPrincipal]
  ImageData getImageData([EnforceRange] long sx, [EnforceRange] long sy, [EnforceRange] long sw, [EnforceRange] long sh);
  [Throws]
  undefined putImageData(ImageData imagedata, [EnforceRange] long dx, [EnforceRange] long dy);
  [Throws]
  undefined putImageData(ImageData imagedata, [EnforceRange] long dx, [EnforceRange] long dy, [EnforceRange] long dirtyX, [EnforceRange] long dirtyY, [EnforceRange] long dirtyWidth, [EnforceRange] long dirtyHeight);
};

interface mixin CanvasPathDrawingStyles {
  // line caps/joins
  [LenientFloat]
  attribute double lineWidth; // (default 1)
  attribute CanvasLineCap lineCap; // (default "butt")
  attribute CanvasLineJoin lineJoin; // (default "miter")
  [LenientFloat]
  attribute double miterLimit; // (default 10)

  // dashed lines
  [LenientFloat, Throws] undefined setLineDash(sequence<double> segments); // default empty
  sequence<double> getLineDash();
  [LenientFloat] attribute double lineDashOffset;
};

interface mixin CanvasTextDrawingStyles {
  // text
  [SetterThrows]
  attribute UTF8String font; // (default 10px sans-serif)
  attribute CanvasTextAlign textAlign; // (default: "start")
  attribute CanvasTextBaseline textBaseline; // (default: "alphabetic")
  attribute CanvasDirection direction; // (default: "inherit")
  attribute UTF8String letterSpacing; // default: "0px"
  attribute CanvasFontKerning fontKerning; // (default: "auto")
  attribute CanvasFontStretch fontStretch; // (default: "normal")
  attribute CanvasFontVariantCaps fontVariantCaps; // (default: "normal")
  attribute CanvasTextRendering textRendering; // (default: "auto")
  attribute UTF8String wordSpacing; // default: "0px"
};

interface mixin CanvasPathMethods {
  // shared path API methods
  undefined closePath();
  [LenientFloat]
  undefined moveTo(double x, double y);
  [LenientFloat]
  undefined lineTo(double x, double y);
  [LenientFloat]
  undefined quadraticCurveTo(double cpx, double cpy, double x, double y);

  [LenientFloat]
  undefined bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y);

  [Throws, LenientFloat]
  undefined arcTo(double x1, double y1, double x2, double y2, double radius);
// NOT IMPLEMENTED  [LenientFloat] undefined arcTo(double x1, double y1, double x2, double y2, double radiusX, double radiusY, double rotation);

  [LenientFloat]
  undefined rect(double x, double y, double w, double h);

  [Throws]
  undefined roundRect(unrestricted double x, unrestricted double y, unrestricted double w, unrestricted double h, optional (unrestricted double or DOMPointInit or sequence<(unrestricted double or DOMPointInit)>) radii = 0);

  [Throws, LenientFloat]
  undefined arc(double x, double y, double radius, double startAngle, double endAngle, optional boolean anticlockwise = false);

  [Throws, LenientFloat]
  undefined ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, optional boolean anticlockwise = false);
};

[Exposed=(Window,Worker),
 Func="mozilla::dom::OffscreenCanvas::PrefEnabledOnWorkerThread"]
interface CanvasGradient {
  // opaque object
  [Throws]
  // addColorStop should take a double
  undefined addColorStop(float offset, UTF8String color);
};

[Exposed=(Window,Worker),
 Func="mozilla::dom::OffscreenCanvas::PrefEnabledOnWorkerThread"]
interface CanvasPattern {
  // opaque object
  // [Throws, LenientFloat] - could not do this overload because of bug 1020975
  // undefined setTransform(double a, double b, double c, double d, double e, double f);

  [Throws]
  undefined setTransform(optional DOMMatrix2DInit matrix = {});
};

[Exposed=(Window,Worker)]
interface TextMetrics {

  // x-direction
  readonly attribute double width; // advance width

  // [experimental] actualBoundingBox* attributes
  [Pref="dom.textMetrics.actualBoundingBox.enabled"]
  readonly attribute double actualBoundingBoxLeft;
  [Pref="dom.textMetrics.actualBoundingBox.enabled"]
  readonly attribute double actualBoundingBoxRight;

  // y-direction
  // [experimental] fontBoundingBox* attributes
  [Pref="dom.textMetrics.fontBoundingBox.enabled"]
  readonly attribute double fontBoundingBoxAscent;
  [Pref="dom.textMetrics.fontBoundingBox.enabled"]
  readonly attribute double fontBoundingBoxDescent;

  // [experimental] actualBoundingBox* attributes
  [Pref="dom.textMetrics.actualBoundingBox.enabled"]
  readonly attribute double actualBoundingBoxAscent;
  [Pref="dom.textMetrics.actualBoundingBox.enabled"]
  readonly attribute double actualBoundingBoxDescent;

  // [experimental] emHeight* attributes
  [Pref="dom.textMetrics.emHeight.enabled"]
  readonly attribute double emHeightAscent;
  [Pref="dom.textMetrics.emHeight.enabled"]
  readonly attribute double emHeightDescent;

  // [experimental] *Baseline attributes
  [Pref="dom.textMetrics.baselines.enabled"]
  readonly attribute double hangingBaseline;
  [Pref="dom.textMetrics.baselines.enabled"]
  readonly attribute double alphabeticBaseline;
  [Pref="dom.textMetrics.baselines.enabled"]
  readonly attribute double ideographicBaseline;
};

[Exposed=(Window,Worker)]
interface Path2D
{
  constructor();
  constructor(Path2D other);
  constructor(DOMString pathString);

  [Throws] undefined addPath(Path2D path, optional DOMMatrix2DInit transform = {});
};
Path2D includes CanvasPathMethods;
 
/* ---------------------- CaretPosition ----------------------------- */ 
/* ./webidl/CaretPosition.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

[Exposed=Window]
interface CaretPosition {

  /**
   * The offsetNode could potentially be null due to anonymous content.
   */
  readonly attribute Node? offsetNode;
  readonly attribute unsigned long offset;

};

/**
 * Gecko specific methods and properties for CaretPosition.
 */
partial interface CaretPosition {
  DOMRect? getClientRect();
};
 
/* ---------------------- CaretStateChangedEvent ----------------------------- */ 
/* ./webidl/CaretStateChangedEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

enum CaretChangedReason {
  "visibilitychange",
  "updateposition",
  "longpressonemptycontent",
  "taponcaret",
  "presscaret",
  "releasecaret",
  "scroll",
  "dragcaret"
};

dictionary CaretStateChangedEventInit : EventInit {
  boolean collapsed = true;
  DOMRectReadOnly? boundingClientRect = null;
  CaretChangedReason reason = "visibilitychange";
  boolean caretVisible = false;
  boolean caretVisuallyVisible = false;
  boolean selectionVisible = false;
  boolean selectionEditable = false;
  DOMString selectedTextContent = "";
  long clientX = 0;
  long clientY = 0;
};

[ChromeOnly,
 Exposed=Window]
interface CaretStateChangedEvent : Event {
  constructor(DOMString type,
              optional CaretStateChangedEventInit eventInit = {});

  readonly attribute boolean collapsed;
  /* The bounding client rect is relative to the visual viewport. */
  readonly attribute DOMRectReadOnly? boundingClientRect;
  readonly attribute CaretChangedReason reason;
  readonly attribute boolean caretVisible;
  readonly attribute boolean caretVisuallyVisible;
  readonly attribute boolean selectionVisible;
  readonly attribute boolean selectionEditable;
  readonly attribute DOMString selectedTextContent;
  [Pref="layout.accessiblecaret.magnifier.enabled"]
  readonly attribute long clientX;
  [Pref="layout.accessiblecaret.magnifier.enabled"]
  readonly attribute long clientY;
};
 
/* ---------------------- CDATASection ----------------------------- */ 
/* ./webidl/CDATASection.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface CDATASection : Text {
};
 
/* ---------------------- ChannelMergerNode ----------------------------- */ 
/* ./webidl/ChannelMergerNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary ChannelMergerOptions : AudioNodeOptions {
             unsigned long numberOfInputs = 6;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface ChannelMergerNode : AudioNode {
  [Throws]
  constructor(BaseAudioContext context,
              optional ChannelMergerOptions options = {});
};
 
/* ---------------------- ChannelSplitterNode ----------------------------- */ 
/* ./webidl/ChannelSplitterNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary ChannelSplitterOptions : AudioNodeOptions {
             unsigned long numberOfOutputs = 6;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface ChannelSplitterNode : AudioNode {
  [Throws]
  constructor(BaseAudioContext context,
              optional ChannelSplitterOptions options = {});
};
 
/* ---------------------- CharacterData ----------------------------- */ 
/* ./webidl/CharacterData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#characterdata
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface CharacterData : Node {
  [Pure, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString data;
  [Pure]
  readonly attribute unsigned long length;
  [Throws]
  DOMString substringData(unsigned long offset, unsigned long count);
  [Throws]
  undefined appendData(DOMString data);
  [Throws]
  undefined insertData(unsigned long offset, DOMString data);
  [Throws]
  undefined deleteData(unsigned long offset, unsigned long count);
  [Throws]
  undefined replaceData(unsigned long offset, unsigned long count, DOMString data);
};

CharacterData includes ChildNode;
CharacterData includes NonDocumentTypeChildNode;
 
/* ---------------------- CheckerboardReportService ----------------------------- */ 
/* ./webidl/CheckerboardReportService.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * This file declares data structures used to communicate checkerboard reports
 * from C++ code to about:checkerboard (see bug 1238042). These dictionaries
 * are NOT exposed to standard web content.
 */

enum CheckerboardReason {
  "severe",
  "recent"
};

// Individual checkerboard report. Contains fields for the severity of the
// checkerboard event, the timestamp at which it was reported, the detailed
// log of the event, and the reason this report was saved (currently either
// "severe" or "recent").
dictionary CheckerboardReport {
  unsigned long severity;
  DOMTimeStamp timestamp; // milliseconds since epoch
  DOMString log;
  CheckerboardReason reason;
};

// The guard function only allows creation of this interface on the
// about:checkerboard page, and only if it's in the parent process.
[Func="mozilla::dom::CheckerboardReportService::IsEnabled",
 Exposed=Window]
interface CheckerboardReportService {
  constructor();

  /**
   * Gets the available checkerboard reports.
   */
  sequence<CheckerboardReport> getReports();

  /**
   * Gets the state of the apz.record_checkerboarding pref.
   */
  boolean isRecordingEnabled();

  /**
   * Sets the state of the apz.record_checkerboarding pref.
   */
  undefined setRecordingEnabled(boolean aEnabled);

  /**
   * Flush any in-progress checkerboard reports. Since this happens
   * asynchronously, the caller may register an observer with the observer
   * service to be notified when this operation is complete. The observer should
   * listen for the topic "APZ:FlushActiveCheckerboard:Done". Upon receiving
   * this notification, the caller may call getReports() to obtain the flushed
   * reports, along with any other reports that are available.
   */
  undefined flushActiveReports();
};
 
/* ---------------------- ChildNode ----------------------------- */ 
/* ./webidl/ChildNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#interface-childnode
 */

interface mixin ChildNode {
  [CEReactions, Throws, Unscopable]
  undefined before((Node or DOMString)... nodes);
  [CEReactions, Throws, Unscopable]
  undefined after((Node or DOMString)... nodes);
  [CEReactions, Throws, Unscopable]
  undefined replaceWith((Node or DOMString)... nodes);
  [CEReactions, Unscopable]
  undefined remove();
};

interface mixin NonDocumentTypeChildNode {
  [Pure]
  readonly attribute Element? previousElementSibling;
  [Pure]
  readonly attribute Element? nextElementSibling;
};
 
/* ---------------------- Client ----------------------------- */ 
/* ./webidl/Client.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/ServiceWorker/#client-interface
 *
 */

[Exposed=ServiceWorker]
interface Client {
  readonly attribute USVString url;

  // Remove frameType in bug 1290936
  [BinaryName="GetFrameType"]
  readonly attribute FrameType frameType;

  readonly attribute ClientType type;
  readonly attribute DOMString id;

  // Implement reserved in bug 1264177
  // readonly attribute boolean reserved;

  [Throws]
  undefined postMessage(any message, sequence<object> transfer);
  [Throws]
  undefined postMessage(any message, optional StructuredSerializeOptions aOptions = {});
};

[Exposed=ServiceWorker]
interface WindowClient : Client {
  [BinaryName="GetVisibilityState"]
  readonly attribute VisibilityState visibilityState;
  readonly attribute boolean focused;

  // Implement ancestorOrigins in bug 1264180
  // [SameObject] readonly attribute FrozenArray<USVString> ancestorOrigins;

  [Throws, NewObject, NeedsCallerType]
  Promise<WindowClient> focus();

  [Throws, NewObject]
  Promise<WindowClient> navigate(USVString url);
};

// Remove FrameType in bug 1290936
enum FrameType {
  "auxiliary",
  "top-level",
  "nested",
  "none"
};
 
/* ---------------------- Clients ----------------------------- */ 
/* ./webidl/Clients.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html
 *
 */

[Exposed=ServiceWorker]
interface Clients {
  // The objects returned will be new instances every time
  [NewObject]
  Promise<(Client or undefined)> get(DOMString id);
  [NewObject]
  Promise<sequence<Client>> matchAll(optional ClientQueryOptions options = {});
  [NewObject]
  Promise<WindowClient?> openWindow(USVString url);
  [NewObject]
  Promise<undefined> claim();
};

dictionary ClientQueryOptions {
  boolean includeUncontrolled = false;
  ClientType type = "window";
};

enum ClientType {
  "window",
  "worker",
  "sharedworker",
  // https://github.com/w3c/ServiceWorker/issues/1036
  "serviceworker",
  "all"
};
 
/* ---------------------- Clipboard ----------------------------- */ 
/* ./webidl/Clipboard.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/clipboard-apis/
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

typedef sequence<ClipboardItem> ClipboardItems;

[SecureContext,
 Exposed=Window,
 InstrumentedProps=(read,readText,write)]
interface Clipboard : EventTarget {
  [Pref="dom.events.asyncClipboard.clipboardItem", NewObject, NeedsSubjectPrincipal]
  Promise<ClipboardItems> read();
  [Func="Clipboard::ReadTextEnabled", NewObject, NeedsSubjectPrincipal]
  Promise<DOMString> readText();

  [Pref="dom.events.asyncClipboard.clipboardItem", NewObject, NeedsSubjectPrincipal]
  Promise<undefined> write(ClipboardItems data);

  [NewObject, NeedsSubjectPrincipal]
  Promise<undefined> writeText(DOMString data);
};

typedef (DOMString or Blob) ClipboardItemDataType;
typedef Promise<ClipboardItemDataType> ClipboardItemData;
// callback ClipboardItemDelayedCallback = ClipboardItemData ();

[SecureContext, Exposed=Window, Pref="dom.events.asyncClipboard.clipboardItem"]
interface ClipboardItem {
  [Throws]
  constructor(record<DOMString, ClipboardItemData> items,
              optional ClipboardItemOptions options = {});

  // static ClipboardItem createDelayed(
  //     record<DOMString, ClipboardItemDelayedCallback> items,
  //     optional ClipboardItemOptions options = {});

  readonly attribute PresentationStyle presentationStyle;
  // readonly attribute long long lastModified;
  // readonly attribute boolean delayed;

  // TODO: Use FrozenArray once available. (Bug 1236777)
  // readonly attribute FrozenArray<DOMString> types;
  [Frozen, Cached, Pure]
  readonly attribute sequence<DOMString> types;

  [NewObject]
  Promise<Blob> getType(DOMString type);
};

enum PresentationStyle { "unspecified", "inline", "attachment" };

dictionary ClipboardItemOptions {
  PresentationStyle presentationStyle = "unspecified";
};
 
/* ---------------------- ClipboardEvent ----------------------------- */ 
/* ./webidl/ClipboardEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface please see
 * http://dev.w3.org/2006/webapi/clipops/#x5-clipboard-event-interfaces
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface ClipboardEvent : Event
{
  [Throws]
  constructor(DOMString type, optional ClipboardEventInit eventInitDict = {});

  readonly attribute DataTransfer? clipboardData;
};

dictionary ClipboardEventInit : EventInit
{
  DOMString data = "";
  DOMString dataType = "";
};
 
/* ---------------------- CloseEvent ----------------------------- */ 
/* ./webidl/CloseEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The nsIDOMCloseEvent interface is the interface to the event
 * close on a WebSocket object.
 *
 * For more information on this interface, please see
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/network.html#closeevent
 */

[LegacyEventInit,
 Exposed=(Window,Worker)]
interface CloseEvent : Event
{
  constructor(DOMString type, optional CloseEventInit eventInitDict = {});

  readonly attribute boolean wasClean;
  readonly attribute unsigned short code;
  readonly attribute DOMString reason;
};

dictionary CloseEventInit : EventInit
{
  boolean wasClean = false;
  unsigned short code = 0;
  DOMString reason = "";
};
 
/* ---------------------- Comment ----------------------------- */ 
/* ./webidl/Comment.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#comment
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface Comment : CharacterData {
  [Throws]
  constructor(optional DOMString data = "");
};
 
/* ---------------------- CompositionEvent ----------------------------- */ 
/* ./webidl/CompositionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://w3c.github.io/uievents/#interface-compositionevent
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface CompositionEvent : UIEvent
{
  constructor(DOMString type, optional CompositionEventInit eventInitDict = {});

  readonly attribute DOMString? data;
  // locale is currently non-standard
  readonly attribute DOMString  locale;

 /**
  * ranges is trying to expose TextRangeArray in Gecko so a
  * js-plugin couble be able to know the clauses information
  */
  [ChromeOnly,Cached,Pure]
  readonly attribute sequence<TextClause> ranges;
};

dictionary CompositionEventInit : UIEventInit {
  DOMString data = "";
};

partial interface CompositionEvent
{
  undefined initCompositionEvent(DOMString typeArg,
                                 optional boolean canBubbleArg = false,
                                 optional boolean cancelableArg = false,
                                 optional Window? viewArg = null,
                                 optional DOMString? dataArg = null,
                                 optional DOMString localeArg = "");
};
 
/* ---------------------- CompressionStream ----------------------------- */ 
/* ./webidl/CompressionStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://wicg.github.io/compression/#compression-stream
 */

enum CompressionFormat {
  "deflate",
  "deflate-raw",
  "gzip",
};

[Exposed=*, Pref="dom.compression_streams.enabled"]
interface CompressionStream {
  [Throws]
  constructor(CompressionFormat format);
};
CompressionStream includes GenericTransformStream;
 
/* ---------------------- Console ----------------------------- */ 
/* ./webidl/Console.webidl */ 
 
/* -*- Mode: IDL; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://console.spec.whatwg.org/#console-namespace
 */

[Exposed=(Window,Worker,WorkerDebugger,Worklet),
 ClassString="Console",
 ProtoObjectHack]
namespace console {

  // NOTE: if you touch this namespace, remember to update the ConsoleInstance
  // interface as well! - dom/chrome-webidl/ConsoleInstance.webidl

  // Logging
  [UseCounter]
  undefined assert(optional boolean condition = false, any... data);
  [UseCounter]
  undefined clear();
  [UseCounter]
  undefined count(optional DOMString label = "default");
  [UseCounter]
  undefined countReset(optional DOMString label = "default");
  [UseCounter]
  undefined debug(any... data);
  [UseCounter]
  undefined error(any... data);
  [UseCounter]
  undefined info(any... data);
  [UseCounter]
  undefined log(any... data);
  [UseCounter]
  undefined table(any... data); // FIXME: The spec is still unclear about this.
  [UseCounter]
  undefined trace(any... data);
  [UseCounter]
  undefined warn(any... data);
  [UseCounter]
  undefined dir(any... data); // FIXME: This doesn't follow the spec yet.
  [UseCounter]
  undefined dirxml(any... data);

  // Grouping
  [UseCounter]
  undefined group(any... data);
  [UseCounter]
  undefined groupCollapsed(any... data);
  [UseCounter]
  undefined groupEnd();

  // Timing
  [UseCounter]
  undefined time(optional DOMString label = "default");
  [UseCounter]
  undefined timeLog(optional DOMString label = "default", any... data);
  [UseCounter]
  undefined timeEnd(optional DOMString label = "default");

  // Mozilla only or Webcompat methods

  [UseCounter]
  undefined _exception(any... data);
  [UseCounter]
  undefined timeStamp(optional any data);

  [UseCounter]
  undefined profile(any... data);
  [UseCounter]
  undefined profileEnd(any... data);

  [ChromeOnly]
  const boolean IS_NATIVE_CONSOLE = true;

  [ChromeOnly, NewObject]
  ConsoleInstance createInstance(optional ConsoleInstanceOptions options = {});
};
 
/* ---------------------- ConstantSourceNode ----------------------------- */ 
/* ./webidl/ConstantSourceNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary ConstantSourceOptions {
    float offset = 1;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface ConstantSourceNode :  AudioScheduledSourceNode {
    constructor(BaseAudioContext context,
                optional ConstantSourceOptions options = {});

    readonly        attribute AudioParam   offset;
};
 
/* ---------------------- ContentVisibilityAutoStateChangeEvent ----------------------------- */ 
/* ./webidl/ContentVisibilityAutoStateChangeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://drafts.csswg.org/css-contain-2/#content-visibility-auto-state-changed
 */

[Exposed=Window, Pref="layout.css.content-visibility.enabled"]
interface ContentVisibilityAutoStateChangeEvent : Event {
  constructor(DOMString type,
              optional ContentVisibilityAutoStateChangeEventInit eventInitDict = {});
  readonly attribute boolean skipped;
};

dictionary ContentVisibilityAutoStateChangeEventInit : EventInit {
  boolean skipped = false;
};
 
/* ---------------------- ConvolverNode ----------------------------- */ 
/* ./webidl/ConvolverNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary ConvolverOptions : AudioNodeOptions {
             AudioBuffer? buffer;
             boolean      disableNormalization = false;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface ConvolverNode : AudioNode {
      [Throws]
      constructor(BaseAudioContext context, optional
                  ConvolverOptions options = {});

      [SetterThrows]
      attribute AudioBuffer? buffer;
      attribute boolean normalize;

};

// Mozilla extension
ConvolverNode includes AudioNodePassThrough;
 
/* ---------------------- CreateOfferRequest ----------------------------- */ 
/* ./webidl/CreateOfferRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This is an internal IDL file
 */

[ChromeOnly,
 JSImplementation="@mozilla.org/dom/createofferrequest;1",
 Exposed=Window]
interface CreateOfferRequest {
  readonly attribute unsigned long long windowID;
  readonly attribute unsigned long long innerWindowID;
  readonly attribute DOMString callID;
  readonly attribute boolean isSecure;
};
 
/* ---------------------- CredentialManagement ----------------------------- */ 
/* ./webidl/CredentialManagement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webappsec-credential-management/
 * and
 * https://w3c.github.io/webauthn/
 * and
 * https://fedidcg.github.io/FedCM/
 */

[Exposed=Window, SecureContext]
interface Credential {
  readonly attribute USVString id;
  readonly attribute DOMString type;
};

[Exposed=Window, SecureContext]
interface CredentialsContainer {
  [NewObject]
  Promise<Credential?> get(optional CredentialRequestOptions options = {});
  [NewObject]
  Promise<Credential?> create(optional CredentialCreationOptions options = {});
  [NewObject]
  Promise<Credential> store(Credential credential);
  [NewObject]
  Promise<undefined> preventSilentAccess();
};

dictionary CredentialRequestOptions {
  CredentialMediationRequirement mediation = "optional";
  AbortSignal signal;
  // This is taken from the partial definition in
  // https://w3c.github.io/webauthn/#sctn-credentialrequestoptions-extension
  [Pref="security.webauth.webauthn"]
  PublicKeyCredentialRequestOptions publicKey;
  // This is taken from the partial definition in
  // https://fedidcg.github.io/FedCM/#browser-api-credential-request-options
  [Pref="dom.security.credentialmanagement.identity.enabled"]
  IdentityCredentialRequestOptions identity;
};

enum CredentialMediationRequirement {
  "silent",
  "optional",
  "conditional",
  "required"
};

dictionary CredentialCreationOptions {
  // This is taken from the partial definition in
  // https://w3c.github.io/webauthn/#sctn-credentialcreationoptions-extension
  [Pref="security.webauth.webauthn"]
  PublicKeyCredentialCreationOptions publicKey;
  AbortSignal signal;
};
 
/* ---------------------- Crypto ----------------------------- */ 
/* ./webidl/Crypto.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/webcrypto-api/raw-file/tip/spec/Overview.html#crypto-interface
 */

[Exposed=(Window,Worker)]
interface mixin GlobalCrypto {
  [Throws] readonly attribute Crypto crypto;
};

[Exposed=(Window,Worker)]
interface Crypto {
  [SecureContext]
  readonly attribute SubtleCrypto subtle;

  [Throws]
  ArrayBufferView getRandomValues(ArrayBufferView array);

  [SecureContext]
  UTF8String randomUUID();
};
 
/* ---------------------- CSPDictionaries ----------------------------- */ 
/* ./webidl/CSPDictionaries.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
  * Dictionary used to display CSP info.
  */

dictionary CSP {
  boolean report-only = false;

  sequence<DOMString> default-src;
  sequence<DOMString> script-src;
  sequence<DOMString> object-src;
  sequence<DOMString> style-src;
  sequence<DOMString> img-src;
  sequence<DOMString> media-src;
  sequence<DOMString> frame-src;
  sequence<DOMString> font-src;
  sequence<DOMString> connect-src;
  sequence<DOMString> report-uri;
  sequence<DOMString> frame-ancestors;
  // sequence<DOMString> reflected-xss; // not supported in Firefox
  sequence<DOMString> base-uri;
  sequence<DOMString> form-action;
  sequence<DOMString> referrer;
  sequence<DOMString> manifest-src;
  sequence<DOMString> upgrade-insecure-requests;
  sequence<DOMString> child-src;
  sequence<DOMString> block-all-mixed-content;
  sequence<DOMString> sandbox;
  sequence<DOMString> worker-src;
  sequence<DOMString> script-src-elem;
  sequence<DOMString> script-src-attr;
};

[GenerateToJSON]
dictionary CSPPolicies {
  sequence<CSP> csp-policies;
};
 
/* ---------------------- CSPReport ----------------------------- */ 
/* ./webidl/CSPReport.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
  * This dictionary holds the parameters used to send
  * CSP reports in JSON format.
  *
  * Based on https://w3c.github.io/webappsec-csp/#deprecated-serialize-violation
  */

dictionary CSPReportProperties {
  DOMString document-uri = "";
  DOMString referrer = "";
  DOMString blocked-uri = "";
  DOMString effective-directive = "";
  DOMString violated-directive = "";
  DOMString original-policy= "";
  SecurityPolicyViolationEventDisposition disposition = "report";
  long status-code = 0;

  DOMString source-file;
  DOMString script-sample;
  long line-number;
  long column-number;
};

[GenerateToJSON]
dictionary CSPReport {
  // We always want to have a "csp-report" property, so just pre-initialize it
  // to an empty dictionary..
  CSPReportProperties csp-report = {};
};
 
/* ---------------------- CSS ----------------------------- */ 
/* ./webidl/CSS.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css3-conditional/
 * http://dev.w3.org/csswg/cssom/#the-css.escape%28%29-method
 * https://www.w3.org/TR/css-highlight-api-1/#registration
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
namespace CSS {
  boolean supports(UTF8String property, UTF8String value);
  boolean supports(UTF8String conditionText);
};

// http://dev.w3.org/csswg/cssom/#the-css.escape%28%29-method
partial namespace CSS {
  DOMString escape(DOMString ident);
};

// https://www.w3.org/TR/css-highlight-api-1/#registration
partial namespace CSS {
  [Pref="dom.customHighlightAPI.enabled", GetterThrows]
  readonly attribute HighlightRegistry highlights;
};

// https://drafts.css-houdini.org/css-properties-values-api-1/#registering-custom-properties
// See https://github.com/w3c/css-houdini-drafts/pull/1100 for DOMString vs. UTF8String
dictionary PropertyDefinition {
  required UTF8String name;
           UTF8String syntax       = "*";
  required boolean    inherits;
           UTF8String initialValue;
};
partial namespace CSS {
  [Pref="layout.css.properties-and-values.enabled", Throws]
  undefined registerProperty(PropertyDefinition definition);
};
 
/* ---------------------- CSSAnimation ----------------------------- */ 
/* ./webidl/CSSAnimation.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css-animations-2/#the-CSSAnimation-interface
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[HeaderFile="nsAnimationManager.h", Exposed=Window]
interface CSSAnimation : Animation {
  [Constant] readonly attribute DOMString animationName;
};
 
/* ---------------------- CSSConditionRule ----------------------------- */ 
/* ./webidl/CSSConditionRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-conditional/#the-cssconditionrule-interface
 */

// https://drafts.csswg.org/css-conditional/#the-cssconditionrule-interface
[Exposed=Window]
interface CSSConditionRule : CSSGroupingRule {
  readonly attribute UTF8String conditionText;
};
 
/* ---------------------- CSSContainerRule ----------------------------- */ 
/* ./webidl/CSSContainerRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-contain-3/#the-csscontainerrule-interface
 */

// https://drafts.csswg.org/css-contain-3/#the-csscontainerrule-interface
[Exposed=Window, Pref="layout.css.container-queries.enabled"]
interface CSSContainerRule : CSSConditionRule {
  readonly attribute UTF8String containerName;
  readonly attribute UTF8String containerQuery;

  // Performs a container query look-up for an element.
  [ChromeOnly] Element? queryContainerFor(Element element);
};
 
/* ---------------------- CSSCounterStyleRule ----------------------------- */ 
/* ./webidl/CSSCounterStyleRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-counter-styles-3/#the-csscounterstylerule-interface
 */

// https://drafts.csswg.org/css-counter-styles-3/#the-csscounterstylerule-interface
[Exposed=Window]
interface CSSCounterStyleRule : CSSRule {
  attribute DOMString name;
  attribute UTF8String system;
  attribute UTF8String symbols;
  attribute UTF8String additiveSymbols;
  attribute UTF8String negative;
  attribute UTF8String prefix;
  attribute UTF8String suffix;
  attribute UTF8String range;
  attribute UTF8String pad;
  attribute UTF8String speakAs;
  attribute UTF8String fallback;
};
 
/* ---------------------- CSSFontFaceRule ----------------------------- */ 
/* ./webidl/CSSFontFaceRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-fonts/#om-fontface
 */

// https://drafts.csswg.org/css-fonts/#om-fontface
// But we implement a very old draft, apparently....
// See bug 1058408 for implementing the current spec.
[Exposed=Window]
interface CSSFontFaceRule : CSSRule {
  [SameObject] readonly attribute CSSStyleDeclaration style;
};
 
/* ---------------------- CSSFontFeatureValuesRule ----------------------------- */ 
/* ./webidl/CSSFontFeatureValuesRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-fonts/#om-fontfeaturevalues
 */

// https://drafts.csswg.org/css-fonts/#om-fontfeaturevalues
// but we don't implement anything remotely resembling the spec.
[Exposed=Window]
interface CSSFontFeatureValuesRule : CSSRule {
  [SetterThrows]
  attribute UTF8String fontFamily;

  // Not yet implemented
  //  readonly attribute CSSFontFeatureValuesMap annotation;
  //  readonly attribute CSSFontFeatureValuesMap ornaments;
  //  readonly attribute CSSFontFeatureValuesMap stylistic;
  //  readonly attribute CSSFontFeatureValuesMap swash;
  //  readonly attribute CSSFontFeatureValuesMap characterVariant;
  //  readonly attribute CSSFontFeatureValuesMap styleset;
};

partial interface CSSFontFeatureValuesRule {
  // Gecko addition?
  [SetterThrows]
  attribute UTF8String valueText;
};
 
/* ---------------------- CSSFontPaletteValuesRule ----------------------------- */ 
/* ./webidl/CSSFontPaletteValuesRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-fonts/#om-fontpalettevalues
 */

[Exposed=Window, Pref="layout.css.font-palette.enabled"]
interface CSSFontPaletteValuesRule : CSSRule {
  readonly attribute UTF8String name;
  readonly attribute UTF8String fontFamily;
  readonly attribute UTF8String basePalette;
  readonly attribute UTF8String overrideColors;
};
 
/* ---------------------- CSSGroupingRule ----------------------------- */ 
/* ./webidl/CSSGroupingRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#cssgroupingrule
 */

// https://drafts.csswg.org/cssom/#cssgroupingrule
[Exposed=Window]
interface CSSGroupingRule : CSSRule {
  [SameObject] readonly attribute CSSRuleList cssRules;
  [Throws]
  unsigned long insertRule(UTF8String rule, optional unsigned long index = 0);
  [Throws]
  undefined deleteRule(unsigned long index);
};
 
/* ---------------------- CSSImportRule ----------------------------- */ 
/* ./webidl/CSSImportRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#cssimportrule
 */

// https://drafts.csswg.org/cssom/#cssimportrule
[Exposed=Window]
interface CSSImportRule : CSSRule {
  readonly attribute DOMString href;
  // Per spec, the .media is never null, but in our implementation it can
  // be since stylesheet can be null, and in Stylo, media is derived from
  // the stylesheet.  See <https://bugzilla.mozilla.org/show_bug.cgi?id=1326509>.
  [SameObject, PutForwards=mediaText] readonly attribute MediaList? media;
  [SameObject, BinaryName="styleSheetForBindings"] readonly attribute CSSStyleSheet? styleSheet;
  readonly attribute UTF8String? layerName;
  readonly attribute UTF8String? supportsText;
};
 
/* ---------------------- CSSKeyframeRule ----------------------------- */ 
/* ./webidl/CSSKeyframeRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-animations/#interface-csskeyframerule
 */

// https://drafts.csswg.org/css-animations/#interface-csskeyframerule
[Exposed=Window]
interface CSSKeyframeRule : CSSRule {
  attribute UTF8String keyText;
  [SameObject, PutForwards=cssText] readonly attribute CSSStyleDeclaration style;
};
 
/* ---------------------- CSSKeyframesRule ----------------------------- */ 
/* ./webidl/CSSKeyframesRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-animations/#interface-csskeyframesrule
 */

// https://drafts.csswg.org/css-animations/#interface-csskeyframesrule
[Exposed=Window]
interface CSSKeyframesRule : CSSRule {
           attribute DOMString   name;
  readonly attribute CSSRuleList cssRules;

  getter CSSKeyframeRule (unsigned long index);
  readonly attribute unsigned long length;

  undefined        appendRule(DOMString rule);
  undefined        deleteRule(DOMString select);
  CSSKeyframeRule? findRule(DOMString select);
};
 
/* ---------------------- CSSLayerBlockRule ----------------------------- */ 
/* ./webidl/CSSLayerBlockRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-cascade-5/#the-csslayerblockrule-interface
 */
[Exposed=Window]
interface CSSLayerBlockRule : CSSGroupingRule {
  readonly attribute UTF8String name;
};
 
/* ---------------------- CSSLayerStatementRule ----------------------------- */ 
/* ./webidl/CSSLayerStatementRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-cascade-5/#the-csslayerstatementrule-interface
 */
[Exposed=Window]
interface CSSLayerStatementRule : CSSRule {
  // readonly attribute FrozenArray<CSSOMString> nameList;
  [Frozen, Cached, Pure]
  readonly attribute sequence<UTF8String> nameList;
};
 
/* ---------------------- CSSMediaRule ----------------------------- */ 
/* ./webidl/CSSMediaRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#the-cssmediarule-interface
 * https://drafts.csswg.org/css-conditional/#the-cssmediarule-interface
 */

// https://drafts.csswg.org/cssom/#the-cssmediarule-interface and
// https://drafts.csswg.org/css-conditional/#the-cssmediarule-interface
// except they disagree with each other.  We're taking the inheritance from
// css-conditional and the PutForwards behavior from cssom.
[Exposed=Window]
interface CSSMediaRule : CSSConditionRule {
  [SameObject, PutForwards=mediaText] readonly attribute MediaList media;
};
 
/* ---------------------- CSSMozDocumentRule ----------------------------- */ 
/* ./webidl/CSSMozDocumentRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

// This is a non-standard interface for @-moz-document rules
[Exposed=Window]
interface CSSMozDocumentRule : CSSConditionRule {
  // XXX Add access to the URL list.
};
 
/* ---------------------- CSSNamespaceRule ----------------------------- */ 
/* ./webidl/CSSNamespaceRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#cssnamespacerule
 */

// https://drafts.csswg.org/cssom/#cssnamespacerule
[Exposed=Window]
interface CSSNamespaceRule : CSSRule {
  readonly attribute DOMString namespaceURI;
  readonly attribute DOMString prefix;
};
 
/* ---------------------- CSSPageRule ----------------------------- */ 
/* ./webidl/CSSPageRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#the-csspagerule-interface
 */

// https://drafts.csswg.org/cssom/#the-csspagerule-interface
// Per spec, this should inherit from CSSGroupingRule, but we don't
// implement this yet.
[Exposed=Window]
interface CSSPageRule : CSSRule {
  attribute UTF8String selectorText;
  [SameObject, PutForwards=cssText] readonly attribute CSSStyleDeclaration style;
};
 
/* ---------------------- CSSPropertyRule ----------------------------- */ 
/* ./webidl/CSSPropertyRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.css-houdini.org/css-properties-values-api-1/#the-css-property-rule-interface
 */

// https://drafts.css-houdini.org/css-properties-values-api-1/#the-css-property-rule-interface
[Exposed=Window, Pref="layout.css.properties-and-values.enabled"]
interface CSSPropertyRule : CSSRule {
  readonly attribute UTF8String name;
  readonly attribute UTF8String syntax;
  readonly attribute boolean inherits;
  readonly attribute UTF8String? initialValue;
};
 
/* ---------------------- CSSPseudoElement ----------------------------- */ 
/* ./webidl/CSSPseudoElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-pseudo-4/#csspseudoelement
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.css_pseudo_element.enabled",
 Exposed=Window]
interface CSSPseudoElement {
  readonly attribute DOMString type;
  readonly attribute Element element;
};
 
/* ---------------------- CSSRule ----------------------------- */ 
/* ./webidl/CSSRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#the-cssrule-interface
 * https://drafts.csswg.org/css-animations/#interface-cssrule
 * https://drafts.csswg.org/css-counter-styles-3/#extentions-to-cssrule-interface
 * https://drafts.csswg.org/css-conditional-3/#extentions-to-cssrule-interface
 * https://drafts.csswg.org/css-fonts-3/#om-fontfeaturevalues
 */

// https://drafts.csswg.org/cssom/#the-cssrule-interface
[Exposed=Window]
interface CSSRule {

  const unsigned short STYLE_RULE = 1;
  const unsigned short CHARSET_RULE = 2; // historical
  const unsigned short IMPORT_RULE = 3;
  const unsigned short MEDIA_RULE = 4;
  const unsigned short FONT_FACE_RULE = 5;
  const unsigned short PAGE_RULE = 6;
  // FIXME: We don't support MARGIN_RULE yet.
  // XXXbz Should we expose the constant anyway?
  // const unsigned short MARGIN_RULE = 9;
  const unsigned short NAMESPACE_RULE = 10;
  [BinaryName="typeForBindings"] readonly attribute unsigned short type;
  attribute UTF8String cssText;
  readonly attribute CSSRule? parentRule;
  readonly attribute CSSStyleSheet? parentStyleSheet;
};

// https://drafts.csswg.org/css-animations/#interface-cssrule
partial interface CSSRule {
    const unsigned short KEYFRAMES_RULE = 7;
    const unsigned short KEYFRAME_RULE = 8;
};

// https://drafts.csswg.org/css-counter-styles-3/#extentions-to-cssrule-interface
partial interface CSSRule {
    const unsigned short COUNTER_STYLE_RULE = 11;
};

// https://drafts.csswg.org/css-conditional-3/#extentions-to-cssrule-interface
partial interface CSSRule {
    const unsigned short SUPPORTS_RULE = 12;
};

// Non-standard extension for @-moz-document rules.
partial interface CSSRule {
    [ChromeOnly]
    const unsigned short DOCUMENT_RULE = 13;
};

// https://drafts.csswg.org/css-fonts-3/#om-fontfeaturevalues
partial interface CSSRule {
  const unsigned short FONT_FEATURE_VALUES_RULE = 14;
};
 
/* ---------------------- CSSRuleList ----------------------------- */ 
/* ./webidl/CSSRuleList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface CSSRuleList {
  readonly attribute unsigned long length;
  getter CSSRule? item(unsigned long index);
};
 
/* ---------------------- CSSScopeRule ----------------------------- */ 
/* ./webidl/CSSScopeRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-cascade-6/#the-cssscoperule-interface
 */

[Exposed=Window, Pref="layout.css.at-scope.enabled"]
interface CSSScopeRule : CSSGroupingRule {
  readonly attribute UTF8String? start;
  readonly attribute UTF8String? end;
};
 
/* ---------------------- CSSStyleDeclaration ----------------------------- */ 
/* ./webidl/CSSStyleDeclaration.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/cssom/
 */

 // Because of getComputedStyle, many CSSStyleDeclaration objects can be
 // short-living.
[ProbablyShortLivingWrapper,
 Exposed=Window]
interface CSSStyleDeclaration {
  [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
  attribute UTF8String cssText;

  readonly attribute unsigned long length;
  getter UTF8String item(unsigned long index);

  [Throws, ChromeOnly]
  sequence<UTF8String> getCSSImageURLs(UTF8String property);

  [ChromeOnly]
  readonly attribute float usedFontSize;

  UTF8String getPropertyValue(UTF8String property);
  UTF8String getPropertyPriority(UTF8String property);
  [CEReactions, NeedsSubjectPrincipal=NonSystem, Throws]
  undefined setProperty(UTF8String property, [LegacyNullToEmptyString] UTF8String value, optional [LegacyNullToEmptyString] UTF8String priority = "");
  [CEReactions, Throws]
  UTF8String removeProperty(UTF8String property);

  readonly attribute CSSRule? parentRule;
};
 
/* ---------------------- CSSStyleRule ----------------------------- */ 
/* ./webidl/CSSStyleRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom/#the-cssstylerule-interface
 */

// https://drafts.csswg.org/cssom/#the-cssstylerule-interface
[Exposed=Window]
interface CSSStyleRule : CSSGroupingRule {
  attribute UTF8String selectorText;
  [SameObject, PutForwards=cssText] readonly attribute CSSStyleDeclaration style;

  [ChromeOnly] readonly attribute unsigned long selectorCount;
  [ChromeOnly] UTF8String selectorTextAt(unsigned long index, optional boolean desugared = false);
  [ChromeOnly] unsigned long long selectorSpecificityAt(unsigned long index, optional boolean desugared = false);
  [ChromeOnly] boolean selectorMatchesElement(
    unsigned long selectorIndex,
    Element element,
    optional [LegacyNullToEmptyString] DOMString pseudo = "",
    optional boolean includeVisitedStyle = false);
  [ChromeOnly] sequence<SelectorWarning> getSelectorWarnings();
};

enum SelectorWarningKind {
  "UnconstrainedHas",
};

dictionary SelectorWarning {
  required unsigned long index;
  required SelectorWarningKind kind;
};
 
/* ---------------------- CSSStyleSheet ----------------------------- */ 
/* ./webidl/CSSStyleSheet.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/cssom/
 * https://wicg.github.io/construct-stylesheets/
 */

enum CSSStyleSheetParsingMode {
  "author",
  "user",
  "agent"
};

dictionary CSSStyleSheetInit {
  (MediaList or UTF8String) media = "";
  boolean disabled = false;
  UTF8String baseURL;
};

[Exposed=Window]
interface CSSStyleSheet : StyleSheet {
  [Throws]
  constructor(optional CSSStyleSheetInit options = {});
  [Pure, BinaryName="DOMOwnerRule"]
  readonly attribute CSSRule? ownerRule;
  [Throws, NeedsSubjectPrincipal]
  readonly attribute CSSRuleList cssRules;
  [ChromeOnly, BinaryName="parsingModeDOM"]
  readonly attribute CSSStyleSheetParsingMode parsingMode;
  [Throws, NeedsSubjectPrincipal]
  unsigned long insertRule(UTF8String rule, optional unsigned long index = 0);
  [Throws, NeedsSubjectPrincipal]
  undefined deleteRule(unsigned long index);
  [NewObject]
  Promise<CSSStyleSheet> replace(UTF8String text);
  [Throws]
  undefined replaceSync(UTF8String text);

  // Non-standard WebKit things.
  [Throws, NeedsSubjectPrincipal, BinaryName="cssRules"]
  readonly attribute CSSRuleList rules;
  [Throws, NeedsSubjectPrincipal, BinaryName="deleteRule"]
  undefined removeRule(optional unsigned long index = 0);
  [Throws, NeedsSubjectPrincipal]
  long addRule(optional UTF8String selector = "undefined", optional UTF8String style = "undefined", optional unsigned long index);
};
 
/* ---------------------- CSSSupportsRule ----------------------------- */ 
/* ./webidl/CSSSupportsRule.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-conditional/#the-csssupportsrule-interface
 */

// https://drafts.csswg.org/css-conditional/#the-csssupportsrule-interface
[Exposed=Window]
interface CSSSupportsRule : CSSConditionRule {
};
 
/* ---------------------- CSSTransition ----------------------------- */ 
/* ./webidl/CSSTransition.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css-transitions-2/#the-CSSTransition-interface
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[HeaderFile="nsTransitionManager.h", Exposed=Window]
interface CSSTransition : Animation {
  [Constant] readonly attribute DOMString transitionProperty;
};
 
/* ---------------------- CustomElementRegistry ----------------------------- */ 
/* ./webidl/CustomElementRegistry.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

// https://html.spec.whatwg.org/#dom-window-customelements
[Exposed=Window]
interface CustomElementRegistry {
  [CEReactions, Throws, UseCounter]
  undefined define(DOMString name, CustomElementConstructor constructor,
                   optional ElementDefinitionOptions options = {});
  [ChromeOnly, Throws]
  undefined setElementCreationCallback(DOMString name, CustomElementCreationCallback callback);
  (CustomElementConstructor or undefined) get(DOMString name);
  DOMString? getName(CustomElementConstructor constructor);
  [Throws]
  Promise<CustomElementConstructor> whenDefined(DOMString name);
  [CEReactions] undefined upgrade(Node root);
};

dictionary ElementDefinitionOptions {
  DOMString extends;
};

enum RestoreReason {
  "restore",
  "autocomplete",
};

callback constructor CustomElementConstructor = any ();

[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback CustomElementCreationCallback = undefined (DOMString name);

[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleConnectedCallback = undefined();
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleDisconnectedCallback = undefined();
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleAdoptedCallback = undefined(Document? oldDocument,
                                              Document? newDocment);
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleAttributeChangedCallback = undefined(DOMString attrName,
                                                       DOMString? oldValue,
                                                       DOMString? newValue,
                                                       DOMString? namespaceURI);
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleFormAssociatedCallback = undefined(HTMLFormElement? form);
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleFormResetCallback = undefined();
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleFormDisabledCallback = undefined(boolean disabled);
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleFormStateRestoreCallback = undefined((File or USVString or FormData)? state, RestoreReason reason);
[MOZ_CAN_RUN_SCRIPT_BOUNDARY]
callback LifecycleGetCustomInterfaceCallback = object?(any iid);

// Unsorted is necessary until https://github.com/whatwg/html/issues/3580 is resolved.
[GenerateInit, Unsorted]
dictionary LifecycleCallbacks {
  LifecycleConnectedCallback connectedCallback;
  LifecycleDisconnectedCallback disconnectedCallback;
  LifecycleAdoptedCallback adoptedCallback;
  LifecycleAttributeChangedCallback attributeChangedCallback;
  [ChromeOnly] LifecycleGetCustomInterfaceCallback getCustomInterfaceCallback;
};

[GenerateInit, Unsorted]
dictionary FormAssociatedLifecycleCallbacks {
  LifecycleFormAssociatedCallback formAssociatedCallback;
  LifecycleFormResetCallback formResetCallback;
  LifecycleFormDisabledCallback formDisabledCallback;
  LifecycleFormStateRestoreCallback formStateRestoreCallback;
};
 
/* ---------------------- CustomEvent ----------------------------- */ 
/* ./webidl/CustomEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window, Worker)]
interface CustomEvent : Event
{
  constructor(DOMString type, optional CustomEventInit eventInitDict = {});

  readonly attribute any detail;

  // initCustomEvent is a Gecko specific deprecated method.
  undefined initCustomEvent(DOMString type,
                            optional boolean canBubble = false,
                            optional boolean cancelable = false,
                            optional any detail = null);
};

dictionary CustomEventInit : EventInit
{
  any detail = null;
};
 
/* ---------------------- DataTransfer ----------------------------- */ 
/* ./webidl/DataTransfer.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is:
 * http://www.whatwg.org/specs/web-apps/current-work/#the-datatransfer-interface
 */
interface ContentSecurityPolicy;

[Exposed=Window]
interface DataTransfer {
  constructor();

           attribute DOMString dropEffect;
           attribute DOMString effectAllowed;

  readonly attribute DataTransferItemList items;

  undefined setDragImage(Element image, long x, long y);

  [Frozen, Cached, Pure, NeedsCallerType]
  readonly attribute sequence<DOMString> types;
  [Throws, NeedsSubjectPrincipal]
  DOMString getData(DOMString format);
  [Throws, NeedsSubjectPrincipal]
  undefined setData(DOMString format, DOMString data);
  [Throws, NeedsSubjectPrincipal]
  undefined clearData(optional DOMString format);
  [NeedsSubjectPrincipal]
  readonly attribute FileList? files;
};

// Mozilla specific stuff
partial interface DataTransfer {
  /*
   * Set the drag source. Usually you would not change this, but it will
   * affect which node the drag and dragend events are fired at. The
   * default target is the node that was dragged.
   *
   * @param element drag source to use
   * @throws NO_MODIFICATION_ALLOWED_ERR if the item cannot be modified
   */
  [Throws, UseCounter]
  undefined addElement(Element element);

  /**
   * The number of items being dragged.
   */
  [ChromeOnly]
  readonly attribute unsigned long mozItemCount;

  /**
   * Sets the drag cursor state. Primarily used to control the cursor during
   * tab drags, but could be expanded to other uses. XXX Currently implemented
   * on Win32 only.
   *
   * Possible values:
   *  auto - use default system behavior.
   *  default - set the cursor to an arrow during the drag operation.
   *
   * Values other than 'default' are indentical to setting mozCursor to
   * 'auto'.
   */
  [UseCounter]
  attribute DOMString mozCursor;

  /**
   * Holds a list of the format types of the data that is stored for an item
   * at the specified index. If the index is not in the range from 0 to
   * itemCount - 1, an empty string list is returned.
   */
  [Throws, ChromeOnly]
  DOMStringList mozTypesAt(unsigned long index);

  /**
   * Remove the data associated with the given format for an item at the
   * specified index. The index is in the range from zero to itemCount - 1.
   *
   * If the last format for the item is removed, the entire item is removed,
   * reducing the itemCount by one.
   *
   * If format is empty, then the data associated with all formats is removed.
   * If the format is not found, then this method has no effect.
   *
   * @param format the format to remove
   * @throws NS_ERROR_DOM_INDEX_SIZE_ERR if index is greater or equal than itemCount
   * @throws NO_MODIFICATION_ALLOWED_ERR if the item cannot be modified
   */
  [Throws, ChromeOnly]
  undefined mozClearDataAt(DOMString format, unsigned long index);

  /*
   * A data transfer may store multiple items, each at a given zero-based
   * index. setDataAt may only be called with an index argument less than
   * itemCount in which case an existing item is modified, or equal to
   * itemCount in which case a new item is added, and the itemCount is
   * incremented by one.
   *
   * Data should be added in order of preference, with the most specific
   * format added first and the least specific format added last. If data of
   * the given format already exists, it is replaced in the same position as
   * the old data.
   *
   * The data should be either a string, a primitive boolean or number type
   * (which will be converted into a string) or an nsISupports.
   *
   * @param format the format to add
   * @param data the data to add
   * @throws NS_ERROR_NULL_POINTER if the data is null
   * @throws NS_ERROR_DOM_INDEX_SIZE_ERR if index is greater than itemCount
   * @throws NO_MODIFICATION_ALLOWED_ERR if the item cannot be modified
   */
  [Throws, ChromeOnly]
  undefined mozSetDataAt(DOMString format, any data, unsigned long index);

  /**
   * Retrieve the data associated with the given format for an item at the
   * specified index, or null if it does not exist. The index should be in the
   * range from zero to itemCount - 1.
   *
   * @param format the format of the data to look up
   * @returns the data of the given format, or null if it doesn't exist.
   * @throws NS_ERROR_DOM_INDEX_SIZE_ERR if index is greater or equal than itemCount
   */
  [Throws, ChromeOnly]
  any mozGetDataAt(DOMString format, unsigned long index);

  /**
   * Update the drag image. Arguments are the same as setDragImage. This is only
   * valid within the parent chrome process.
   */
  [ChromeOnly]
  undefined updateDragImage(Element image, long x, long y);

  /**
   * Will be true when the user has cancelled the drag (typically by pressing
   * Escape) and when the drag has been cancelled unexpectedly.  This will be
   * false otherwise, including when the drop has been rejected by its target.
   * This property is only relevant for the dragend event.
   */
  [UseCounter]
  readonly attribute boolean mozUserCancelled;

  /**
   * The node that the mouse was pressed over to begin the drag. For external
   * drags, or if the caller cannot access this node, this will be null.
   */
  [UseCounter]
  readonly attribute Node? mozSourceNode;

  /**
   * The top-level window context that mouse was pressed over to begin the drag.
   * For external drags, this will be null.
   */
  [ChromeOnly]
  readonly attribute WindowContext? sourceTopWindowContext;

  /**
   * The URI spec of the triggering principal.  This may be different than
   * sourceNode's principal when sourceNode is xul:browser and the drag is
   * triggered in a browsing context inside it.
   */
  [ChromeOnly]
  readonly attribute DOMString mozTriggeringPrincipalURISpec;

  [ChromeOnly]
  readonly attribute ContentSecurityPolicy? mozCSP;

  /**
   * Copy the given DataTransfer for the given event. Used by testing code for
   * creating emulated Drag and Drop events in the UI.
   *
   * NOTE: Don't expose a DataTransfer produced with this method to the web or
   * use this for non-testing purposes. It can easily be used to get the
   * DataTransfer into an invalid state, and is an unstable implementation
   * detail of EventUtils.synthesizeDrag.
   */
  [Throws, ChromeOnly]
  DataTransfer mozCloneForEvent(DOMString event);

  /**
   * Whether to show the "fail" animation that returns a dragged item
   * to its source. Only works on macOS, and has to be set early in the drag
   * on that platform.
   * Defaults to true.
   */
  [ChromeOnly]
  attribute boolean mozShowFailAnimation;
};
 
/* ---------------------- DataTransferItem ----------------------------- */ 
/* ./webidl/DataTransferItem.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is:
 * https://html.spec.whatwg.org/multipage/interaction.html#the-datatransferitem-interface
 * https://wicg.github.io/entries-api/#idl-index
 */

[InstrumentedProps=(webkitGetAsEntry),Exposed=Window]
interface DataTransferItem {
  readonly attribute DOMString kind;
  readonly attribute DOMString type;
  [Throws, NeedsSubjectPrincipal]
  undefined getAsString(FunctionStringCallback? callback);
  [Throws, NeedsSubjectPrincipal]
  File? getAsFile();
};

callback FunctionStringCallback = undefined (DOMString data);

// https://wicg.github.io/entries-api/#idl-index
partial interface DataTransferItem {
  [Pref="dom.webkitBlink.filesystem.enabled", BinaryName="getAsEntry", Throws,
   NeedsSubjectPrincipal]
  FileSystemEntry? webkitGetAsEntry();
};
 
/* ---------------------- DataTransferItemList ----------------------------- */ 
/* ./webidl/DataTransferItemList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is:
 * https://html.spec.whatwg.org/multipage/interaction.html#the-datatransferitemlist-interface
 */

[Exposed=Window]
interface DataTransferItemList {
  readonly attribute unsigned long length;
  getter DataTransferItem (unsigned long index);
  [Throws, NeedsSubjectPrincipal]
  DataTransferItem? add(DOMString data, DOMString type);
  [Throws, NeedsSubjectPrincipal]
  DataTransferItem? add(File data);
  [Throws, NeedsSubjectPrincipal]
  undefined remove(unsigned long index);
  [Throws, NeedsSubjectPrincipal]
  undefined clear();
};
 
/* ---------------------- DecoderDoctorNotification ----------------------------- */ 
/* ./webidl/DecoderDoctorNotification.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

enum DecoderDoctorNotificationType {
  "cannot-play",
  "platform-decoder-not-found",
  "can-play-but-some-missing-decoders",
  "cannot-initialize-pulseaudio",
  "unsupported-libavcodec",
  "decode-error",
  "decode-warning",
};

enum DecoderDoctorReportType {
  "mediawidevinenowmf",
  "mediawmfneeded",
  "mediaplatformdecodernotfound",
  "mediacannotplaynodecoders",
  "medianodecoders",
  "mediacannotinitializepulseaudio",
  "mediaunsupportedlibavcodec",
  "mediadecodeerror",
  "mediadecodewarning",
};

[GenerateToJSON]
dictionary DecoderDoctorNotification {
  required DecoderDoctorNotificationType type;
  // True when the issue has been solved.
  required boolean isSolved;
  // Key from dom.properties, used for telemetry and prefs.
  required DOMString decoderDoctorReportId;
  // If provided, formats (or key systems) at issue.
  DOMString formats;
  // If provided, technical details about the decode-error/warning.
  DOMString decodeIssue;
  // If provided, URL of the document where the issue happened.
  DOMString docURL;
  // If provided, URL of the media resource that caused a decode-error/warning.
  DOMString resourceURL;
};
 
/* ---------------------- DecompressionStream ----------------------------- */ 
/* ./webidl/DecompressionStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://wicg.github.io/compression/#decompression-stream
 */

[Exposed=*, Pref="dom.compression_streams.enabled"]
interface DecompressionStream {
  [Throws]
  constructor(CompressionFormat format);
};
DecompressionStream includes GenericTransformStream;
 
/* ---------------------- DedicatedWorkerGlobalScope ----------------------------- */ 
/* ./webidl/DedicatedWorkerGlobalScope.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/workers.html#the-workerglobalscope-common-interface
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and Opera
 * Software ASA.
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

[Global=(Worker,DedicatedWorker),
 Exposed=DedicatedWorker]
interface DedicatedWorkerGlobalScope : WorkerGlobalScope {
  [Replaceable]
  readonly attribute DOMString name;

  [Throws]
  undefined postMessage(any message, sequence<object> transfer);
  [Throws]
  undefined postMessage(any message, optional StructuredSerializeOptions options = {});

  undefined close();

  attribute EventHandler onmessage;
  attribute EventHandler onmessageerror;
};

// https://w3c.github.io/webrtc-encoded-transform/#RTCEncodedAudioFrame-methods
partial interface DedicatedWorkerGlobalScope {
  [Pref="media.peerconnection.enabled",
   Pref="media.peerconnection.scripttransform.enabled"] attribute EventHandler onrtctransform;
};

// https://html.spec.whatwg.org/multipage/imagebitmap-and-animations.html#animation-frames
DedicatedWorkerGlobalScope includes AnimationFrameProvider;
 
/* ---------------------- DelayNode ----------------------------- */ 
/* ./webidl/DelayNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary DelayOptions : AudioNodeOptions {
             double maxDelayTime = 1;
             double delayTime = 0;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface DelayNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context, optional DelayOptions options = {});

    readonly attribute AudioParam delayTime;

};

// Mozilla extension
DelayNode includes AudioNodePassThrough;
 
/* ---------------------- DeviceLightEvent ----------------------------- */ 
/* ./webidl/DeviceLightEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Pref="device.sensors.ambientLight.enabled", Func="nsGlobalWindowInner::DeviceSensorsEnabled",
 Exposed=Window]
interface DeviceLightEvent : Event
{
  constructor(DOMString type, optional DeviceLightEventInit eventInitDict = {});

  readonly attribute unrestricted double value;
};

dictionary DeviceLightEventInit : EventInit
{
  unrestricted double value = Infinity;
};
 
/* ---------------------- DeviceMotionEvent ----------------------------- */ 
/* ./webidl/DeviceMotionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://w3c.github.io/deviceorientation/
 */

[LegacyNoInterfaceObject,
  Exposed=Window]
interface DeviceAcceleration {
  readonly attribute double? x;
  readonly attribute double? y;
  readonly attribute double? z;
};

[LegacyNoInterfaceObject,
 Exposed=Window]
interface DeviceRotationRate {
  readonly attribute double? alpha;
  readonly attribute double? beta;
  readonly attribute double? gamma;
};

[Pref="device.sensors.motion.enabled", Func="nsGlobalWindowInner::DeviceSensorsEnabled",
 Exposed=Window]
interface DeviceMotionEvent : Event {
  constructor(DOMString type,
              optional DeviceMotionEventInit eventInitDict = {});

  readonly attribute DeviceAcceleration? acceleration;
  readonly attribute DeviceAcceleration? accelerationIncludingGravity;
  readonly attribute DeviceRotationRate? rotationRate;
  readonly attribute double? interval;
};

dictionary DeviceAccelerationInit {
  double? x = null;
  double? y = null;
  double? z = null;
};

dictionary DeviceRotationRateInit {
  double? alpha = null;
  double? beta = null;
  double? gamma = null;
};

dictionary DeviceMotionEventInit : EventInit {
  // FIXME: bug 1493860: should this "= {}" be here?
  DeviceAccelerationInit acceleration = {};
  // FIXME: bug 1493860: should this "= {}" be here?
  DeviceAccelerationInit accelerationIncludingGravity = {};
  // FIXME: bug 1493860: should this "= {}" be here?
  DeviceRotationRateInit rotationRate = {};
  double? interval = null;
};

// Mozilla extensions.
partial interface DeviceMotionEvent {
  undefined initDeviceMotionEvent(DOMString type,
                                  optional boolean canBubble = false,
                                  optional boolean cancelable = false,
                                  optional DeviceAccelerationInit acceleration = {},
                                  optional DeviceAccelerationInit accelerationIncludingGravity = {},
                                  optional DeviceRotationRateInit rotationRate = {},
                                  optional double? interval = null);
};
 
/* ---------------------- DeviceOrientationEvent ----------------------------- */ 
/* ./webidl/DeviceOrientationEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Pref="device.sensors.orientation.enabled", Func="nsGlobalWindowInner::DeviceSensorsEnabled", LegacyEventInit,
 Exposed=Window]
interface DeviceOrientationEvent : Event
{
  constructor(DOMString type,
              optional DeviceOrientationEventInit eventInitDict = {});

  readonly attribute double? alpha;
  readonly attribute double? beta;
  readonly attribute double? gamma;
  readonly attribute boolean absolute;

  // initDeviceOrientationEvent is a Gecko specific deprecated method.
  undefined initDeviceOrientationEvent(DOMString type,
                                       optional boolean canBubble = false,
                                       optional boolean cancelable = false,
                                       optional double? alpha = null,
                                       optional double? beta = null,
                                       optional double? gamma = null,
                                       optional boolean absolute = false);
};

dictionary DeviceOrientationEventInit : EventInit
{
  double? alpha = null;
  double? beta = null;
  double? gamma = null;
  boolean absolute = false;
};
 
/* ---------------------- Directory ----------------------------- */ 
/* ./webidl/Directory.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * All functions on Directory that accept DOMString arguments for file or
 * directory names only allow relative path to current directory itself. The
 * path should be a descendent path like "path/to/file.txt" and not contain a
 * segment of ".." or ".". So the paths aren't allowed to walk up the directory
 * tree. For example, paths like "../foo", "..", "/foo/bar" or "foo/../bar" are
 * not allowed.
 *
 * http://w3c.github.io/filesystem-api/#idl-def-Directory
 * https://microsoftedge.github.io/directory-upload/proposal.html#directory-interface
 */

[Exposed=(Window,Worker)]
interface Directory {
  // This ChromeOnly constructor is used by the MockFilePicker for testing only.
  [Throws, ChromeOnly]
  constructor(DOMString path);

  /*
   * The leaf name of the directory.
   */
  [Throws]
  readonly attribute DOMString name;
};

[Exposed=(Window,Worker)]
partial interface Directory {
  // Already defined in the main interface declaration:
  //readonly attribute DOMString name;

  /*
   * The path of the Directory (includes both its basename and leafname).
   * The path begins with the name of the ancestor Directory that was
   * originally exposed to content (say via a directory picker) and traversed
   * to obtain this Directory.  Full filesystem paths are not exposed to
   * unprivilaged content.
   */
  [Throws]
  readonly attribute DOMString path;

  /*
   * Getter for the immediate children of this directory.
   */
  [NewObject]
  Promise<sequence<(File or Directory)>> getFilesAndDirectories();

  [NewObject]
  Promise<sequence<File>> getFiles(optional boolean recursiveFlag = false);
};
 
/* ---------------------- Document ----------------------------- */ 
/* ./webidl/Document.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://dom.spec.whatwg.org/#interface-document
 * https://html.spec.whatwg.org/multipage/dom.html#the-document-object
 * https://html.spec.whatwg.org/multipage/obsolete.html#other-elements%2C-attributes-and-apis
 * https://fullscreen.spec.whatwg.org/#api
 * https://w3c.github.io/pointerlock/#extensions-to-the-document-interface
 * https://w3c.github.io/pointerlock/#extensions-to-the-documentorshadowroot-mixin
 * https://w3c.github.io/page-visibility/#extensions-to-the-document-interface
 * https://drafts.csswg.org/cssom/#extensions-to-the-document-interface
 * https://drafts.csswg.org/cssom-view/#extensions-to-the-document-interface
 * https://wicg.github.io/feature-policy/#policy
 * https://wicg.github.io/scroll-to-text-fragment/#feature-detectability
 */

interface ContentSecurityPolicy;
interface Principal;
interface WindowProxy;
interface nsISupports;
interface URI;
interface nsIDocShell;
interface nsILoadGroup;
interface nsIReferrerInfo;
interface nsICookieJarSettings;
interface nsIPermissionDelegateHandler;
interface XULCommandDispatcher;

enum VisibilityState { "hidden", "visible" };

/* https://dom.spec.whatwg.org/#dictdef-elementcreationoptions */
dictionary ElementCreationOptions {
  DOMString is;

  [ChromeOnly]
  DOMString pseudo;
};

/* https://dom.spec.whatwg.org/#interface-document */
[Exposed=Window,
 InstrumentedProps=(caretRangeFromPoint,
                    exitPictureInPicture,
                    featurePolicy,
                    onbeforecopy,
                    onbeforecut,
                    onbeforepaste,
                    oncancel,
                    onfreeze,
                    onmousewheel,
                    onresume,
                    onsearch,
                    onwebkitfullscreenchange,
                    onwebkitfullscreenerror,
                    pictureInPictureElement,
                    pictureInPictureEnabled,
                    registerElement,
                    wasDiscarded,
                    webkitCancelFullScreen,
                    webkitCurrentFullScreenElement,
                    webkitExitFullscreen,
                    webkitFullscreenElement,
                    webkitFullscreenEnabled,
                    webkitHidden,
                    webkitIsFullScreen,
                    webkitVisibilityState,
                    xmlEncoding,
                    xmlStandalone,
                    xmlVersion)]
interface Document : Node {
  [Throws]
  constructor();

  [Throws]
  readonly attribute DOMImplementation implementation;
  [Pure, Throws, BinaryName="documentURIFromJS", NeedsCallerType]
  readonly attribute DOMString URL;
  [Pure, Throws, BinaryName="documentURIFromJS", NeedsCallerType]
  readonly attribute DOMString documentURI;
  [Pure]
  readonly attribute DOMString compatMode;
  [Pure]
  readonly attribute DOMString characterSet;
  [Pure,BinaryName="characterSet"]
  readonly attribute DOMString charset; // legacy alias of .characterSet
  [Pure,BinaryName="characterSet"]
  readonly attribute DOMString inputEncoding; // legacy alias of .characterSet
  [Pure]
  readonly attribute DOMString contentType;

  [Pure]
  readonly attribute DocumentType? doctype;
  [Pure]
  readonly attribute Element? documentElement;
  [Pure]
  HTMLCollection getElementsByTagName(DOMString localName);
  [Pure, Throws]
  HTMLCollection getElementsByTagNameNS(DOMString? namespace, DOMString localName);
  [Pure]
  HTMLCollection getElementsByClassName(DOMString classNames);

  // These DOM methods cannot be accessed by UA Widget scripts
  // because the DOM element reflectors will be in the content scope,
  // instead of the desired UA Widget scope.
  [CEReactions, NewObject, Throws, Func="IsNotUAWidget"]
  Element createElement(DOMString localName, optional (ElementCreationOptions or DOMString) options = {});
  [CEReactions, NewObject, Throws, Func="IsNotUAWidget"]
  Element createElementNS(DOMString? namespace, DOMString qualifiedName, optional (ElementCreationOptions or DOMString) options = {});
  [NewObject]
  DocumentFragment createDocumentFragment();
  [NewObject, Func="IsNotUAWidget"]
  Text createTextNode(DOMString data);
  [NewObject, Func="IsNotUAWidget"]
  Comment createComment(DOMString data);
  [NewObject, Throws]
  ProcessingInstruction createProcessingInstruction(DOMString target, DOMString data);

  [CEReactions, Throws, Func="IsNotUAWidget"]
  Node importNode(Node node, optional boolean deep = false);
  [CEReactions, Throws, Func="IsNotUAWidget"]
  Node adoptNode(Node node);

  [NewObject, Throws, NeedsCallerType]
  Event createEvent(DOMString interface);

  [NewObject, Throws]
  Range createRange();

  // NodeFilter.SHOW_ALL = 0xFFFFFFFF
  [NewObject, Throws]
  NodeIterator createNodeIterator(Node root, optional unsigned long whatToShow = 0xFFFFFFFF, optional NodeFilter? filter = null);
  [NewObject, Throws]
  TreeWalker createTreeWalker(Node root, optional unsigned long whatToShow = 0xFFFFFFFF, optional NodeFilter? filter = null);

  // NEW
  // No support for prepend/append yet
  // undefined prepend((Node or DOMString)... nodes);
  // undefined append((Node or DOMString)... nodes);

  // These are not in the spec, but leave them for now for backwards compat.
  // So sort of like Gecko extensions
  [NewObject, Throws]
  CDATASection createCDATASection(DOMString data);
  [NewObject, Throws]
  Attr createAttribute(DOMString name);
  [NewObject, Throws]
  Attr createAttributeNS(DOMString? namespace, DOMString name);
};

// https://html.spec.whatwg.org/multipage/dom.html#the-document-object
partial interface Document {
  [Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  static Document parseHTMLUnsafe(DOMString html);

  [PutForwards=href, LegacyUnforgeable] readonly attribute Location? location;
  [SetterThrows]                           attribute DOMString domain;
  readonly attribute DOMString referrer;
  [Throws] attribute DOMString cookie;
  readonly attribute DOMString lastModified;
  readonly attribute DOMString readyState;

  // DOM tree accessors
  //(Not proxy yet)getter object (DOMString name);
  [CEReactions, SetterThrows, Pure]
           attribute DOMString title;
  [CEReactions, Pure]
           attribute DOMString dir;
  [CEReactions, Pure, SetterThrows]
           attribute HTMLElement? body;
  [Pure]
  readonly attribute HTMLHeadElement? head;
  [SameObject] readonly attribute HTMLCollection images;
  [SameObject] readonly attribute HTMLCollection embeds;
  [SameObject] readonly attribute HTMLCollection plugins;
  [SameObject] readonly attribute HTMLCollection links;
  [SameObject] readonly attribute HTMLCollection forms;
  [SameObject] readonly attribute HTMLCollection scripts;
  [Pure]
  NodeList getElementsByName(DOMString elementName);
  //(Not implemented)readonly attribute DOMElementMap cssElementMap;

  // dynamic markup insertion
  [CEReactions, Throws]
  Document open(optional DOMString unused1, optional DOMString unused2); // both arguments are ignored
  [CEReactions, Throws]
  WindowProxy? open(USVString url, DOMString name, DOMString features);
  [CEReactions, Throws]
  undefined close();
  [CEReactions, Throws]
  undefined write(DOMString... text);
  [CEReactions, Throws]
  undefined writeln(DOMString... text);

  // user interaction
  [Pure]
  readonly attribute WindowProxy? defaultView;
  [Throws]
  boolean hasFocus();
  [CEReactions, SetterThrows, SetterNeedsSubjectPrincipal]
           attribute DOMString designMode;
  [CEReactions, Throws, NeedsSubjectPrincipal]
  boolean execCommand(DOMString commandId, optional boolean showUI = false,
                      optional DOMString value = "");
  [Throws, NeedsSubjectPrincipal]
  boolean queryCommandEnabled(DOMString commandId);
  [Throws]
  boolean queryCommandIndeterm(DOMString commandId);
  [Throws]
  boolean queryCommandState(DOMString commandId);
  [Throws, NeedsCallerType]
  boolean queryCommandSupported(DOMString commandId);
  [Throws]
  DOMString queryCommandValue(DOMString commandId);
  //(Not implemented)readonly attribute HTMLCollection commands;

  // special event handler IDL attributes that only apply to Document objects
  [LegacyLenientThis] attribute EventHandler onreadystatechange;

  // Gecko extensions?
                attribute EventHandler onbeforescriptexecute;
                attribute EventHandler onafterscriptexecute;

  /**
   * True if this document is synthetic : stand alone image, video, audio file,
   * etc.
   */
  [Func="IsChromeOrUAWidget"] readonly attribute boolean mozSyntheticDocument;
  /**
   * Returns the script element whose script is currently being processed.
   *
   * @see <https://developer.mozilla.org/en/DOM/document.currentScript>
   */
  [Pure]
  readonly attribute Element? currentScript;
  /**
   * Release the current mouse capture if it is on an element within this
   * document.
   *
   * @see <https://developer.mozilla.org/en/DOM/document.releaseCapture>
   */
  [Deprecated=DocumentReleaseCapture, Pref="dom.mouse_capture.enabled"]
  undefined releaseCapture();
  /**
   * Use the given DOM element as the source image of target |-moz-element()|.
   *
   * This function introduces a new special ID (called "image element ID"),
   * which is only used by |-moz-element()|, and associates it with the given
   * DOM element.  Image elements ID's have the higher precedence than general
   * HTML id's, so if |document.mozSetImageElement(<id>, <element>)| is called,
   * |-moz-element(#<id>)| uses |<element>| as the source image even if there
   * is another element with id attribute = |<id>|.  To unregister an image
   * element ID |<id>|, call |document.mozSetImageElement(<id>, null)|.
   *
   * Example:
   * <script>
   *   canvas = document.createElement("canvas");
   *   canvas.setAttribute("width", 100);
   *   canvas.setAttribute("height", 100);
   *   // draw to canvas
   *   document.mozSetImageElement("canvasbg", canvas);
   * </script>
   * <div style="background-image: -moz-element(#canvasbg);"></div>
   *
   * @param aImageElementId an image element ID to associate with
   * |aImageElement|
   * @param aImageElement a DOM element to be used as the source image of
   * |-moz-element(#aImageElementId)|. If this is null, the function will
   * unregister the image element ID |aImageElementId|.
   *
   * @see <https://developer.mozilla.org/en/DOM/document.mozSetImageElement>
   */
  [UseCounter]
  undefined mozSetImageElement(DOMString aImageElementId,
                               Element? aImageElement);

  [ChromeOnly]
  readonly attribute URI? documentURIObject;

  /**
   * Current referrer policy - one of the referrer policy value from
   * ReferrerPolicy.webidl.
   */
  [ChromeOnly]
  readonly attribute ReferrerPolicy referrerPolicy;

    /**
   * Current referrer info, which holds all referrer related information
   * including referrer policy and raw referrer of document.
   */
  [ChromeOnly]
  readonly attribute nsIReferrerInfo referrerInfo;

};

// https://html.spec.whatwg.org/multipage/obsolete.html#other-elements%2C-attributes-and-apis
partial interface Document {
  [CEReactions] attribute [LegacyNullToEmptyString] DOMString fgColor;
  [CEReactions] attribute [LegacyNullToEmptyString] DOMString linkColor;
  [CEReactions] attribute [LegacyNullToEmptyString] DOMString vlinkColor;
  [CEReactions] attribute [LegacyNullToEmptyString] DOMString alinkColor;
  [CEReactions] attribute [LegacyNullToEmptyString] DOMString bgColor;

  [SameObject] readonly attribute HTMLCollection anchors;
  [SameObject] readonly attribute HTMLCollection applets;

  undefined clear();
  // @deprecated These are old Netscape 4 methods. Do not use,
  //             the implementation is no-op.
  // XXXbz do we actually need these anymore?
  undefined captureEvents();
  undefined releaseEvents();

  [SameObject] readonly attribute HTMLAllCollection all;
};

// https://fullscreen.spec.whatwg.org/#api
partial interface Document {
  // Note: Per spec the 'S' in these two is lowercase, but the "Moz"
  // versions have it uppercase.
  [LegacyLenientSetter, Unscopable]
  readonly attribute boolean fullscreen;
  [BinaryName="fullscreen"]
  readonly attribute boolean mozFullScreen;
  [LegacyLenientSetter, NeedsCallerType]
  readonly attribute boolean fullscreenEnabled;
  [BinaryName="fullscreenEnabled", NeedsCallerType]
  readonly attribute boolean mozFullScreenEnabled;

  [NewObject]
  Promise<undefined> exitFullscreen();
  [NewObject, BinaryName="exitFullscreen"]
  Promise<undefined> mozCancelFullScreen();

  // Events handlers
  attribute EventHandler onfullscreenchange;
  attribute EventHandler onfullscreenerror;
};

// https://w3c.github.io/pointerlock/#extensions-to-the-document-interface
// https://w3c.github.io/pointerlock/#extensions-to-the-documentorshadowroot-mixin
partial interface Document {
  undefined exitPointerLock();

  // Event handlers
  attribute EventHandler onpointerlockchange;
  attribute EventHandler onpointerlockerror;
};

// Mozilla-internal document extensions specific to error pages.
partial interface Document {
  [Func="Document::CallerIsTrustedAboutCertError", NewObject]
  Promise<any> addCertException(boolean isTemporary);

  [Func="Document::CallerIsTrustedAboutHttpsOnlyError"]
  undefined reloadWithHttpsOnlyException();

  [Func="Document::CallerIsTrustedAboutCertError", Throws]
  FailedCertSecurityInfo getFailedCertSecurityInfo();

  [Func="Document::CallerIsTrustedAboutNetError", Throws]
  NetErrorInfo getNetErrorInfo();
};

// https://w3c.github.io/page-visibility/#extensions-to-the-document-interface
partial interface Document {
  readonly attribute boolean hidden;
  readonly attribute VisibilityState visibilityState;
           attribute EventHandler onvisibilitychange;
};

// https://drafts.csswg.org/cssom/#extensions-to-the-document-interface
partial interface Document {
    attribute DOMString? selectedStyleSheetSet;
    readonly attribute DOMString? lastStyleSheetSet;
    readonly attribute DOMString? preferredStyleSheetSet;
    [Constant]
    readonly attribute DOMStringList styleSheetSets;
    undefined enableStyleSheetsForSet (DOMString? name);
};

// https://drafts.csswg.org/cssom-view/#extensions-to-the-document-interface
partial interface Document {
    CaretPosition? caretPositionFromPoint (float x, float y);

    readonly attribute Element? scrollingElement;
};

// https://drafts.csswg.org/web-animations/#extensions-to-the-document-interface
partial interface Document {
  [Func="Document::AreWebAnimationsTimelinesEnabled"]
  readonly attribute DocumentTimeline timeline;
};

// https://svgwg.org/svg2-draft/struct.html#InterfaceDocumentExtensions
partial interface Document {
  [BinaryName="SVGRootElement"]
  readonly attribute SVGSVGElement? rootElement;
};

//  Mozilla extensions of various sorts
partial interface Document {
  // Creates a new XUL element regardless of the document's default type.
  [ChromeOnly, CEReactions, NewObject, Throws]
  Element createXULElement(DOMString localName, optional (ElementCreationOptions or DOMString) options = {});
  // Wether the document was loaded using a nsXULPrototypeDocument.
  [ChromeOnly]
  readonly attribute boolean loadedFromPrototype;

  // The principal to use for the storage area of this document
  [ChromeOnly]
  readonly attribute Principal effectiveStoragePrincipal;

  // You should probably not be using this principal getter since it performs
  // no checks to ensure that the partitioned principal should really be used
  // here.  It is only designed to be used in very specific circumstances, such
  // as when inheriting the document/storage principal.
  [ChromeOnly]
  readonly attribute Principal partitionedPrincipal;

  // The cookieJarSettings of this document
  [ChromeOnly]
  readonly attribute nsICookieJarSettings cookieJarSettings;

  // Touch bits
  // XXXbz I can't find the sane spec for this stuff, so just cribbing
  // from our xpidl for now.
  [NewObject, Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
  Touch createTouch(optional Window? view = null,
                    optional EventTarget? target = null,
                    optional long identifier = 0,
                    optional long pageX = 0,
                    optional long pageY = 0,
                    optional long screenX = 0,
                    optional long screenY = 0,
                    optional long clientX = 0,
                    optional long clientY = 0,
                    optional long radiusX = 0,
                    optional long radiusY = 0,
                    optional float rotationAngle = 0,
                    optional float force = 0);
  // XXXbz a hack to get around the fact that we don't support variadics as
  // distinguishing arguments yet.  Once this hack is removed. we can also
  // remove the corresponding overload on Document, since Touch... and
  // sequence<Touch> look the same in the C++.
  [NewObject, Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
  TouchList createTouchList(Touch touch, Touch... touches);
  // XXXbz and another hack for the fact that we can't usefully have optional
  // distinguishing arguments but need a working zero-arg form of
  // createTouchList().
  [NewObject, Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
  TouchList createTouchList();
  [NewObject, Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
  TouchList createTouchList(sequence<Touch> touches);

  [ChromeOnly]
  attribute boolean styleSheetChangeEventsEnabled;

  [ChromeOnly]
  attribute boolean devToolsAnonymousAndShadowEventsEnabled;

  [ChromeOnly, BinaryName="contentLanguageForBindings"] readonly attribute DOMString contentLanguage;

  [ChromeOnly] readonly attribute nsILoadGroup? documentLoadGroup;

  // Blocks the initial document parser until the given promise is settled.
  [ChromeOnly, NewObject]
  Promise<any> blockParsing(Promise<any> promise,
                            optional BlockParsingOptions options = {});

  [Func="nsContentUtils::IsSystemOrPDFJS", BinaryName="blockUnblockOnloadForSystemOrPDFJS"]
  undefined blockUnblockOnload(boolean block);

  // like documentURI, except that for error pages, it returns the URI we were
  // trying to load when we hit an error, rather than the error page's own URI.
  [ChromeOnly] readonly attribute URI? mozDocumentURIIfNotForErrorPages;

  // A promise that is resolved when we have both fired DOMContentLoaded and
  // are ready to start layout.
  // This is used for the  "document_idle" webextension script injection point.
  [ChromeOnly, Throws]
  readonly attribute Promise<undefined> documentReadyForIdle;

  // Lazily created command dispatcher, returns null if the document is not
  // chrome privileged.
  [ChromeOnly]
  readonly attribute XULCommandDispatcher? commandDispatcher;

  [ChromeOnly]
  attribute boolean devToolsWatchingDOMMutations;

  /**
   * Returns all the shadow roots connected to the document, in no particular
   * order, and without regard to open/closed-ness. Also returns UA widgets
   * (like <video> controls), which can be checked using
   * ShadowRoot.isUAWidget().
   */
  [ChromeOnly]
  sequence<ShadowRoot> getConnectedShadowRoots();
};

dictionary BlockParsingOptions {
  /**
   * If true, blocks script-created parsers (created via document.open()) in
   * addition to network-created parsers.
   */
  boolean blockScriptCreated = true;
};

// Extension to give chrome JS the ability to determine when a document was
// created to satisfy an iframe with srcdoc attribute.
partial interface Document {
  [ChromeOnly] readonly attribute boolean isSrcdocDocument;
};


// Extension to give chrome JS the ability to get the underlying
// sandbox flag attribute
partial interface Document {
  [ChromeOnly] readonly attribute DOMString? sandboxFlagsAsString;
};


/**
 * Chrome document anonymous content management.
 * This is a Chrome-only API that allows inserting fixed positioned anonymous
 * content on top of the current page displayed in the document.
 */
partial interface Document {
  /**
   * If aForce is true, tries to update layout to be able to insert the element
   * synchronously.
   */
  [ChromeOnly, NewObject, Throws]
  AnonymousContent insertAnonymousContent(optional boolean aForce = false);

  /**
   * Removes the element inserted into the CanvasFrame given an AnonymousContent
   * instance.
   */
  [ChromeOnly]
  undefined removeAnonymousContent(AnonymousContent aContent);
};

// http://w3c.github.io/selection-api/#extensions-to-document-interface
partial interface Document {
  [Throws]
  Selection? getSelection();
};

// https://github.com/whatwg/html/issues/3338
partial interface Document {
  [Pref="dom.storage_access.enabled", NewObject]
  Promise<boolean> hasStorageAccess();
  [Pref="dom.storage_access.enabled", NewObject]
  Promise<undefined> requestStorageAccess();
  // https://github.com/privacycg/storage-access/pull/100
  [Pref="dom.storage_access.forward_declared.enabled", NewObject]
  Promise<undefined> requestStorageAccessUnderSite(DOMString serializedSite);
  [Pref="dom.storage_access.forward_declared.enabled", NewObject]
  Promise<undefined> completeStorageAccessRequestFromSite(DOMString serializedSite);
};

// A privileged API to give chrome privileged code and the content script of the
// webcompat extension the ability to request the storage access for a given
// third party.
partial interface Document {
  [Func="Document::CallerCanAccessPrivilegeSSA", NewObject]
  Promise<undefined> requestStorageAccessForOrigin(DOMString thirdPartyOrigin, optional boolean requireUserInteraction = true);
};

// Extension to give chrome JS the ability to determine whether
// the user has interacted with the document or not.
partial interface Document {
  [ChromeOnly] readonly attribute boolean userHasInteracted;
};

// Extension to give chrome JS the ability to simulate activate the document
// by user gesture.
partial interface Document {
  [ChromeOnly]
  undefined notifyUserGestureActivation();
  // For testing only.
  [ChromeOnly]
  undefined clearUserGestureActivation();
  [ChromeOnly]
  readonly attribute boolean hasBeenUserGestureActivated;
  [ChromeOnly]
  readonly attribute boolean hasValidTransientUserGestureActivation;
  [ChromeOnly]
  readonly attribute DOMHighResTimeStamp lastUserGestureTimeStamp;
  [ChromeOnly]
  boolean consumeTransientUserGestureActivation();
};

// Extension to give chrome JS the ability to set an event handler which is
// called with certain events that happened while events were suppressed in the
// document or one of its subdocuments.
partial interface Document {
  [ChromeOnly]
  undefined setSuppressedEventListener(EventListener? aListener);
};

// Allows frontend code to query a CSP which needs to be passed for a
// new load into docshell. Further, allows to query the CSP in JSON
// format for testing purposes.
partial interface Document {
  [ChromeOnly] readonly attribute ContentSecurityPolicy? csp;
  [ChromeOnly] readonly attribute DOMString cspJSON;
};

partial interface Document {
  [Func="Document::DocumentSupportsL10n"] readonly attribute DocumentL10n? l10n;
  [Func="Document::DocumentSupportsL10n"] readonly attribute boolean hasPendingL10nMutations;
};

Document includes XPathEvaluatorMixin;
Document includes GlobalEventHandlers;
Document includes TouchEventHandlers;
Document includes ParentNode;
Document includes OnErrorEventHandlerForNodes;
Document includes GeometryUtils;
Document includes FontFaceSource;
Document includes DocumentOrShadowRoot;

// https://w3c.github.io/webappsec-feature-policy/#idl-index
partial interface Document {
    [SameObject, Pref="dom.security.featurePolicy.webidl.enabled"]
    readonly attribute FeaturePolicy featurePolicy;
};

// Extension to give chrome JS the ability to specify a non-default keypress
// event model.
partial interface Document {
  /**
   * setKeyPressEventModel() is called when we need to check whether the web
   * app requires specific keypress event model or not.
   *
   * @param aKeyPressEventModel  Proper keypress event model for the web app.
   *   KEYPRESS_EVENT_MODEL_DEFAULT:
   *     Use default keypress event model.  I.e., depending on
   *     "dom.keyboardevent.keypress.set_keycode_and_charcode_to_same_value"
   *     pref.
   *   KEYPRESS_EVENT_MODEL_SPLIT:
   *     Use split model.  I.e, if keypress event inputs a character,
   *     keyCode should be 0.  Otherwise, charCode should be 0.
   *   KEYPRESS_EVENT_MODEL_CONFLATED:
   *     Use conflated model.  I.e., keyCode and charCode values of each
   *     keypress event should be set to same value.
   */
  [ChromeOnly]
  const unsigned short KEYPRESS_EVENT_MODEL_DEFAULT = 0;
  [ChromeOnly]
  const unsigned short KEYPRESS_EVENT_MODEL_SPLIT = 1;
  [ChromeOnly]
  const unsigned short KEYPRESS_EVENT_MODEL_CONFLATED = 2;
  [ChromeOnly]
  undefined setKeyPressEventModel(unsigned short aKeyPressEventModel);
};

// Extensions to return information about about the nodes blocked by the
// Safebrowsing API inside a document.
partial interface Document {
  /*
   * Number of nodes that have been blocked by the Safebrowsing API to prevent
   * tracking, cryptomining and so on. This method is for testing only.
   */
  [ChromeOnly, Pure]
  readonly attribute long blockedNodeByClassifierCount;

  /*
   * List of nodes that have been blocked by the Safebrowsing API to prevent
   * tracking, fingerprinting, cryptomining and so on. This method is for
   * testing only.
   */
  [ChromeOnly, Pure]
  readonly attribute NodeList blockedNodesByClassifier;
};

// Extension to programmatically simulate a user interaction on a document,
// used for testing.
partial interface Document {
  [ChromeOnly, BinaryName="setUserHasInteracted"]
  undefined userInteractionForTesting();
};

// Extension for permission delegation.
partial interface Document {
  [ChromeOnly, Pure]
  readonly attribute nsIPermissionDelegateHandler permDelegateHandler;
};

// Extension used by the password manager to infer form submissions.
partial interface Document {
  /*
   * Set whether the document notifies an event when a fetch or
   * XHR completes successfully.
   */
  [ChromeOnly]
  undefined setNotifyFetchSuccess(boolean aShouldNotify);

  /*
   * Set whether a form and a password field notify an event when it is
   * removed from the DOM tree.
   */
  [ChromeOnly]
  undefined setNotifyFormOrPasswordRemoved(boolean aShouldNotify);
};

// Extension to allow chrome code to detect initial about:blank documents.
partial interface Document {
  [ChromeOnly]
  readonly attribute boolean isInitialDocument;
};

// Extension to allow chrome code to get some wireframe-like structure.
enum WireframeRectType {
  "image",
  "background",
  "text",
  "unknown",
};
dictionary WireframeTaggedRect {
  unrestricted double x = 0;
  unrestricted double y = 0;
  unrestricted double width = 0;
  unrestricted double height = 0;
  unsigned long color = 0; // in nscolor format
  WireframeRectType type;
  Node? node;
};
[GenerateInit]
dictionary Wireframe {
  unsigned long canvasBackground = 0; // in nscolor format
  sequence<WireframeTaggedRect> rects;
  unsigned long version = 1; // Increment when the wireframe structure changes in backwards-incompatible ways
};
partial interface Document {
  [ChromeOnly]
  Wireframe? getWireframe(optional boolean aIncludeNodes = false);
};

partial interface Document {
  // Returns true if the document is the current active document in a browsing
  // context which isn't in bfcache.
  [ChromeOnly]
  boolean isActive();
};

Document includes NonElementParentNode;

/**
 * Extension to add the fragmentDirective property.
 * https://wicg.github.io/scroll-to-text-fragment/#feature-detectability
 */
partial interface Document {
    [Pref="dom.text_fragments.enabled", Exposed=Window, SameObject]
    readonly attribute FragmentDirective fragmentDirective;
};
 
/* ---------------------- DocumentFragment ----------------------------- */ 
/* ./webidl/DocumentFragment.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#documentfragment
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface DocumentFragment : Node {
  [Throws]
  constructor();
};

DocumentFragment includes ParentNode;
DocumentFragment includes NonElementParentNode;
 
/* ---------------------- DocumentOrShadowRoot ----------------------------- */ 
/* ./webidl/DocumentOrShadowRoot.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#documentorshadowroot
 * http://w3c.github.io/webcomponents/spec/shadow/#extensions-to-the-documentorshadowroot-mixin
 * https://wicg.github.io/construct-stylesheets/#using-constructed-stylesheets
 */

interface mixin DocumentOrShadowRoot {
  // Not implemented yet: bug 1430308.
  // Selection? getSelection();
  Element? elementFromPoint(float x, float y);
  sequence<Element> elementsFromPoint(float x, float y);

  // TODO: Avoid making these ChromeOnly, see:
  // https://github.com/w3c/csswg-drafts/issues/556
  [ChromeOnly]
  Node? nodeFromPoint(float x, float y);
  [ChromeOnly]
  sequence<Node> nodesFromPoint(float x, float y);

  // Not implemented yet: bug 1430307.
  // CaretPosition? caretPositionFromPoint (float x, float y);

  readonly attribute Element? activeElement;
  readonly attribute StyleSheetList styleSheets;

  readonly attribute Element? pointerLockElement;
  [LegacyLenientSetter]
  readonly attribute Element? fullscreenElement;
  [BinaryName="fullscreenElement"]
  readonly attribute Element? mozFullScreenElement;
};

// https://drafts.csswg.org/web-animations-1/#extensions-to-the-documentorshadowroot-interface-mixin
partial interface mixin DocumentOrShadowRoot {
  sequence<Animation> getAnimations();
};

// https://wicg.github.io/construct-stylesheets/#using-constructed-stylesheets
partial interface mixin DocumentOrShadowRoot {
  // We are using [Pure, Cached, Frozen] sequence until `FrozenArray` is implemented.
  // See https://bugzilla.mozilla.org/show_bug.cgi?id=1236777 for more details.
  attribute ObservableArray<CSSStyleSheet> adoptedStyleSheets;
};
 
/* ---------------------- DocumentTimeline ----------------------------- */ 
/* ./webidl/DocumentTimeline.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#documenttimeline
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary DocumentTimelineOptions {
  DOMHighResTimeStamp originTime = 0;
};

[Func="Document::AreWebAnimationsTimelinesEnabled",
 Exposed=Window]
interface DocumentTimeline : AnimationTimeline {
  [Throws]
  constructor(optional DocumentTimelineOptions options = {});
};
 
/* ---------------------- DocumentType ----------------------------- */ 
/* ./webidl/DocumentType.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#documenttype
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface DocumentType : Node {
  readonly attribute DOMString name;
  readonly attribute DOMString publicId;
  readonly attribute DOMString systemId;
};

DocumentType includes ChildNode;
 
/* ---------------------- DOMException ----------------------------- */ 
/* ./webidl/DOMException.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webidl.spec.whatwg.org/#idl-DOMException
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */


// This is the WebIDL version of nsIException.  This is mostly legacy stuff.

interface StackFrame;

interface mixin ExceptionMembers
{
  // The nsresult associated with this exception.
  readonly attribute unsigned long           result;

  // Filename location.  This is the location that caused the
  // error, which may or may not be a source file location.
  // For example, standard language errors would generally have
  // the same location as their top stack entry.  File
  // parsers may put the location of the file they were parsing,
  // etc.

  // null indicates "no data"
  readonly attribute DOMString               filename;
  // Valid line numbers begin at '1'. '0' indicates unknown.
  readonly attribute unsigned long           lineNumber;
  // Valid column numbers begin at 0.
  // We don't have an unambiguous indicator for unknown.
  readonly attribute unsigned long           columnNumber;

  // A stack trace, if available.  nsIStackFrame does not have classinfo so
  // this was only ever usefully available to chrome JS.
  [ChromeOnly, Exposed=Window]
  readonly attribute StackFrame?             location;

  // Arbitary data for the implementation.
  [Exposed=Window]
  readonly attribute nsISupports?            data;

  // Formatted exception stack
  [Replaceable]
  readonly attribute DOMString               stack;
};

[LegacyNoInterfaceObject, Exposed=(Window,Worker)]
interface Exception {
  // The name of the error code (ie, a string repr of |result|).
  readonly attribute DOMString               name;
  // A custom message set by the thrower.
  [BinaryName="messageMoz"]
  readonly attribute DOMString               message;
  // A generic formatter - make it suitable to print, etc.
  stringifier;
};

Exception includes ExceptionMembers;

// XXXkhuey this is an 'exception', not an interface, but we don't have any
// parser or codegen mechanisms for dealing with exceptions.
[ExceptionClass,
 Exposed=(Window, Worker),
 Serializable]
interface DOMException {
  constructor(optional DOMString message = "", optional DOMString name);

  // The name of the error code (ie, a string repr of |result|).
  readonly attribute DOMString               name;
  // A custom message set by the thrower.
  [BinaryName="messageMoz"]
  readonly attribute DOMString               message;
  readonly attribute unsigned short code;

  const unsigned short INDEX_SIZE_ERR = 1;
  const unsigned short DOMSTRING_SIZE_ERR = 2; // historical
  const unsigned short HIERARCHY_REQUEST_ERR = 3;
  const unsigned short WRONG_DOCUMENT_ERR = 4;
  const unsigned short INVALID_CHARACTER_ERR = 5;
  const unsigned short NO_DATA_ALLOWED_ERR = 6; // historical
  const unsigned short NO_MODIFICATION_ALLOWED_ERR = 7;
  const unsigned short NOT_FOUND_ERR = 8;
  const unsigned short NOT_SUPPORTED_ERR = 9;
  const unsigned short INUSE_ATTRIBUTE_ERR = 10; // historical
  const unsigned short INVALID_STATE_ERR = 11;
  const unsigned short SYNTAX_ERR = 12;
  const unsigned short INVALID_MODIFICATION_ERR = 13;
  const unsigned short NAMESPACE_ERR = 14;
  const unsigned short INVALID_ACCESS_ERR = 15;
  const unsigned short VALIDATION_ERR = 16; // historical
  const unsigned short TYPE_MISMATCH_ERR = 17; // historical; use JavaScript's TypeError instead
  const unsigned short SECURITY_ERR = 18;
  const unsigned short NETWORK_ERR = 19;
  const unsigned short ABORT_ERR = 20;
  const unsigned short URL_MISMATCH_ERR = 21;
  const unsigned short QUOTA_EXCEEDED_ERR = 22;
  const unsigned short TIMEOUT_ERR = 23;
  const unsigned short INVALID_NODE_TYPE_ERR = 24;
  const unsigned short DATA_CLONE_ERR = 25;
};

// XXXkhuey copy all of Gecko's non-standard stuff onto DOMException, but leave
// the prototype chain sane.
DOMException includes ExceptionMembers;
 
/* ---------------------- DOMImplementation ----------------------------- */ 
/* ./webidl/DOMImplementation.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#interface-domimplementation
 *
 * Copyright:
 * To the extent possible under law, the editors have waived all copyright and
 * related or neighboring rights to this work.
 */

[Exposed=Window]
interface DOMImplementation {
  boolean hasFeature();

  [Throws]
  DocumentType createDocumentType(DOMString qualifiedName, DOMString publicId,
                                  DOMString systemId);
  [Throws]
  Document createDocument(DOMString? namespace,
                          [LegacyNullToEmptyString] DOMString qualifiedName,
                          optional DocumentType? doctype = null);
  [Throws]
  Document createHTMLDocument(optional DOMString title);
};
 
/* ---------------------- DOMLocalization ----------------------------- */ 
/* ./webidl/DOMLocalization.webidl */ 
 
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * DOMLocalization is an extension of the Fluent Localization API.
 *
 * DOMLocalization adds a state for storing `roots` - DOM elements
 * which translation status is controlled by the DOMLocalization
 * instance and monitored for mutations.
 * DOMLocalization also adds methods dedicated to DOM manipulation.
 *
 * Methods:
 *    - connectRoot        - add a root
 *    - disconnectRoot     - remove a root
 *    - pauseObserving     - pause observing of roots
 *    - resumeObserving    - resume observing of roots
 *    - setAttributes      - set l10n attributes of an element
 *    - getAttributes      - retrieve l10n attributes of an element
 *    - translateFragment  - translate a DOM fragment
 *    - translateElements  - translate a list of DOM elements
 *    - translateRoots     - translate all attached roots
 *
 */

[Func="IsChromeOrUAWidget", Exposed=Window]
interface DOMLocalization : Localization {
  /**
   * Constructor arguments:
   *    - aResourceids       - a list of localization resource URIs
   *                           which will provide messages for this
   *                           Localization instance.
   *    - aSync              - Specifies if the initial state of the DOMLocalization
   *                           and the underlying Localization API is synchronous.
   *                           This enables a number of synchronous methods on the
   *                           Localization API and uses it for `TranslateElements`
   *                           making the method return a synchronusly resolved promise.
   *    - aRegistry            - optional custom L10nRegistry to be used by this Localization instance.
   *    - aLocales             - custom set of locales to be used for this Localization.
   */
  [Throws]
  constructor(sequence<L10nResourceId> aResourceIds,
              optional boolean aSync = false,
              optional L10nRegistry aRegistry,
              optional sequence<UTF8String> aLocales);

  /**
   * Adds a node to nodes observed for localization
   * related changes.
   */
  undefined connectRoot(Node aElement);

  /**
   * Removes a node from nodes observed for localization
   * related changes.
   */
  undefined disconnectRoot(Node aElement);

  /**
   * Pauses the MutationObserver set to observe
   * localization related DOM mutations.
   */
  undefined pauseObserving();

  /**
   * Resumes the MutationObserver set to observe
   * localization related DOM mutations.
   */
  undefined resumeObserving();

  /**
   * A helper function which allows the user to set localization-specific attributes
   * on an element.
   * This method lives on `document.l10n` for compatibility reasons with the
   * JS FluentDOM implementation. We may consider moving it onto Element.
   *
   * Example:
   *    document.l10n.setAttributes(h1, "key1", { emailCount: 5 });
   *
   *    <h1 data-l10n-id="key1" data-l10n-args="{\"emailCount\": 5}"/>
   */
  [Throws] undefined setAttributes(Element aElement, DOMString aId, optional object? aArgs);

  /**
   * A helper function which allows the user to retrieve a set of localization-specific
   * attributes from an element.
   * This method lives on `document.l10n` for compatibility reasons with the
   * JS FluentDOM implementation. We may consider moving it onto Element.
   *
   * Example:
   *    let l10nAttrs = document.l10n.getAttributes(h1);
   *    assert.deepEqual(l10nAttrs, {id: "key1", args: { emailCount: 5});
   */
  [Throws] L10nIdArgs getAttributes(Element aElement);

  /**
   * A helper function which allows the user to set the l10n args for an element. This
   * is similar to the setAttributes method, but does not require the l10n ID.
   *
   * Example:
   *
   *    <h1 data-l10n-id="key1" />
   *
   *    document.l10n.setArgs(h1, { emailCount: 5 });
   *
   *    <h1 data-l10n-id="key1" data-l10n-args="{\"emailCount\": 5}" />
   *
   *    document.l10n.setArgs(h1);
   *
   *    <h1 data-l10n-id="key1" />
   */
  [Throws] undefined setArgs(Element aElement, optional object? aArgs);

  /**
   * Triggers translation of a subtree rooted at aNode.
   *
   * The method finds all translatable descendants of the argument and
   * localizes them.
   *
   * This method is mainly useful to trigger translation not covered by the
   * DOMLocalization's MutationObserver - for example before it gets attached
   * to the tree.
   * In such cases, when the already-translated fragment gets
   * injected into the observed root, one should `pauseObserving`,
   * then append the fragment, and finally `resumeObserving`.
   *
   * Example:
   *    await document.l10n.translatFragment(frag);
   *    root.pauseObserving();
   *    parent.appendChild(frag);
   *    root.resumeObserving();
   */
  [NewObject] Promise<any> translateFragment(Node aNode);

  /**
   * Triggers translation of a list of Elements using the localization context.
   *
   * The method only translates the elements directly passed to the method,
   * not any descendant nodes.
   *
   * This method is mainly useful to trigger translation not covered by the
   * DOMLocalization's MutationObserver - for example before it gets attached
   * to the tree.
   * In such cases, when the already-translated fragment gets
   * injected into the observed root, one should `pauseObserving`,
   * then append the fragment, and finally `resumeObserving`.
   *
   * Example:
   *    await document.l10n.translateElements([elem1, elem2]);
   *    root.pauseObserving();
   *    parent.appendChild(elem1);
   *    root.resumeObserving();
   *    alert(elem2.textContent);
   */
  [NewObject] Promise<undefined> translateElements(sequence<Element> aElements);

  /**
   * Triggers translation of all attached roots and sets their
   * locale info and directionality attributes.
   *
   * Example:
   *    await document.l10n.translateRoots();
   */
  [NewObject] Promise<undefined> translateRoots();
};
 
/* ---------------------- DOMMatrix ----------------------------- */ 
/* ./webidl/DOMMatrix.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.fxtf.org/geometry/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker),
 Serializable]
interface DOMMatrixReadOnly {
    [Throws]
    constructor(optional (UTF8String or sequence<unrestricted double> or DOMMatrixReadOnly) init);

    [NewObject, Throws] static DOMMatrixReadOnly fromMatrix(optional DOMMatrixInit other = {});
    [NewObject, Throws] static DOMMatrixReadOnly fromFloat32Array(Float32Array array32);
    [NewObject, Throws] static DOMMatrixReadOnly fromFloat64Array(Float64Array array64);


    // These attributes are simple aliases for certain elements of the 4x4 matrix
    readonly attribute unrestricted double a;
    readonly attribute unrestricted double b;
    readonly attribute unrestricted double c;
    readonly attribute unrestricted double d;
    readonly attribute unrestricted double e;
    readonly attribute unrestricted double f;

    readonly attribute unrestricted double m11;
    readonly attribute unrestricted double m12;
    readonly attribute unrestricted double m13;
    readonly attribute unrestricted double m14;
    readonly attribute unrestricted double m21;
    readonly attribute unrestricted double m22;
    readonly attribute unrestricted double m23;
    readonly attribute unrestricted double m24;
    readonly attribute unrestricted double m31;
    readonly attribute unrestricted double m32;
    readonly attribute unrestricted double m33;
    readonly attribute unrestricted double m34;
    readonly attribute unrestricted double m41;
    readonly attribute unrestricted double m42;
    readonly attribute unrestricted double m43;
    readonly attribute unrestricted double m44;

    // Immutable transform methods
    DOMMatrix translate(optional unrestricted double tx = 0,
                        optional unrestricted double ty = 0,
                        optional unrestricted double tz = 0);
    [NewObject] DOMMatrix scale(optional unrestricted double scaleX = 1,
                                optional unrestricted double scaleY,
                                optional unrestricted double scaleZ = 1,
                                optional unrestricted double originX = 0,
                                optional unrestricted double originY = 0,
                                optional unrestricted double originZ = 0);
    [NewObject] DOMMatrix scaleNonUniform(optional unrestricted double scaleX = 1,
                                          optional unrestricted double scaleY = 1);
    DOMMatrix scale3d(optional unrestricted double scale = 1,
                      optional unrestricted double originX = 0,
                      optional unrestricted double originY = 0,
                      optional unrestricted double originZ = 0);
    [NewObject] DOMMatrix rotate(optional unrestricted double rotX = 0,
                                 optional unrestricted double rotY,
                                 optional unrestricted double rotZ);
    [NewObject] DOMMatrix rotateFromVector(optional unrestricted double x = 0,
                                           optional unrestricted double y = 0);
    [NewObject] DOMMatrix rotateAxisAngle(optional unrestricted double x = 0,
                                          optional unrestricted double y = 0,
                                          optional unrestricted double z = 0,
                                          optional unrestricted double angle = 0);
    DOMMatrix skewX(optional unrestricted double sx = 0);
    DOMMatrix skewY(optional unrestricted double sy = 0);
    [NewObject, Throws] DOMMatrix multiply(optional DOMMatrixInit other = {});
    DOMMatrix flipX();
    DOMMatrix flipY();
    DOMMatrix inverse();

    // Helper methods
    readonly attribute boolean is2D;
    readonly attribute boolean isIdentity;
    DOMPoint                   transformPoint(optional DOMPointInit point = {});
    [Throws] Float32Array      toFloat32Array();
    [Throws] Float64Array      toFloat64Array();
    [Exposed=Window, Throws]   stringifier;
    [Default] object           toJSON();
};

[Exposed=(Window,Worker),
 Serializable,
 LegacyWindowAlias=WebKitCSSMatrix]
interface DOMMatrix : DOMMatrixReadOnly {
    [Throws]
    constructor(optional (UTF8String or sequence<unrestricted double> or DOMMatrixReadOnly) init);

    [NewObject, Throws] static DOMMatrix fromMatrix(optional DOMMatrixInit other = {});
    [NewObject, Throws] static DOMMatrix fromFloat32Array(Float32Array array32);
    [NewObject, Throws] static DOMMatrix fromFloat64Array(Float64Array array64);


    // These attributes are simple aliases for certain elements of the 4x4 matrix
    inherit attribute unrestricted double a;
    inherit attribute unrestricted double b;
    inherit attribute unrestricted double c;
    inherit attribute unrestricted double d;
    inherit attribute unrestricted double e;
    inherit attribute unrestricted double f;

    inherit attribute unrestricted double m11;
    inherit attribute unrestricted double m12;
    inherit attribute unrestricted double m13;
    inherit attribute unrestricted double m14;
    inherit attribute unrestricted double m21;
    inherit attribute unrestricted double m22;
    inherit attribute unrestricted double m23;
    inherit attribute unrestricted double m24;
    inherit attribute unrestricted double m31;
    inherit attribute unrestricted double m32;
    inherit attribute unrestricted double m33;
    inherit attribute unrestricted double m34;
    inherit attribute unrestricted double m41;
    inherit attribute unrestricted double m42;
    inherit attribute unrestricted double m43;
    inherit attribute unrestricted double m44;

    // Mutable transform methods
    [Throws] DOMMatrix multiplySelf(optional DOMMatrixInit other = {});
    [Throws] DOMMatrix preMultiplySelf(optional DOMMatrixInit other = {});
    DOMMatrix translateSelf(optional unrestricted double tx = 0,
                            optional unrestricted double ty = 0,
                            optional unrestricted double tz = 0);
    DOMMatrix scaleSelf(optional unrestricted double scaleX = 1,
                        optional unrestricted double scaleY,
                        optional unrestricted double scaleZ = 1,
                        optional unrestricted double originX = 0,
                        optional unrestricted double originY = 0,
                        optional unrestricted double originZ = 0);
    DOMMatrix scale3dSelf(optional unrestricted double scale = 1,
                          optional unrestricted double originX = 0,
                          optional unrestricted double originY = 0,
                          optional unrestricted double originZ = 0);
    DOMMatrix rotateSelf(optional unrestricted double rotX = 0,
                         optional unrestricted double rotY,
                         optional unrestricted double rotZ);
    DOMMatrix rotateFromVectorSelf(optional unrestricted double x = 0,
                                   optional unrestricted double y = 0);
    DOMMatrix rotateAxisAngleSelf(optional unrestricted double x = 0,
                                  optional unrestricted double y = 0,
                                  optional unrestricted double z = 0,
                                  optional unrestricted double angle = 0);
    DOMMatrix skewXSelf(optional unrestricted double sx = 0);
    DOMMatrix skewYSelf(optional unrestricted double sy = 0);
    DOMMatrix invertSelf();
    [Exposed=Window, Throws] DOMMatrix setMatrixValue(UTF8String transformList);
};

dictionary DOMMatrix2DInit {
    unrestricted double a;
    unrestricted double b;
    unrestricted double c;
    unrestricted double d;
    unrestricted double e;
    unrestricted double f;
    unrestricted double m11;
    unrestricted double m12;
    unrestricted double m21;
    unrestricted double m22;
    unrestricted double m41;
    unrestricted double m42;
};

dictionary DOMMatrixInit : DOMMatrix2DInit {
    unrestricted double m13 = 0;
    unrestricted double m14 = 0;
    unrestricted double m23 = 0;
    unrestricted double m24 = 0;
    unrestricted double m31 = 0;
    unrestricted double m32 = 0;
    unrestricted double m33 = 1;
    unrestricted double m34 = 0;
    unrestricted double m43 = 0;
    unrestricted double m44 = 1;
    boolean is2D;
};
 
/* ---------------------- DOMParser ----------------------------- */ 
/* ./webidl/DOMParser.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://domparsing.spec.whatwg.org/#the-domparser-interface
 */

interface Principal;
interface URI;
interface InputStream;

enum SupportedType {
  "text/html",
  "text/xml",
  "application/xml",
  "application/xhtml+xml",
  "image/svg+xml"
};

[Exposed=Window]
interface DOMParser {
  [Throws]
  constructor();

  [NewObject, Throws, UseCounter]
  Document parseFromString(DOMString str, SupportedType type);

  [NewObject, ChromeOnly, Throws]
  Document parseFromSafeString(DOMString str, SupportedType type);

  // Mozilla-specific stuff
  [NewObject, Throws, ChromeOnly]
  Document parseFromBuffer(sequence<octet> buf, SupportedType type);
  [NewObject, Throws, ChromeOnly]
  Document parseFromBuffer(Uint8Array buf, SupportedType type);
  [NewObject, Throws, ChromeOnly]
  Document parseFromStream(InputStream stream, DOMString? charset,
                           long contentLength, SupportedType type);
  // Can be used to allow a DOMParser to parse XUL/XBL no matter what
  // principal it's using for the document.
  [ChromeOnly]
  undefined forceEnableXULXBL();

  // Can be used to allow a DOMParser to load DTDs from URLs that
  // normally would not be allowed based on the document principal.
  [Func="IsChromeOrUAWidget"]
  undefined forceEnableDTD();
};
 
/* ---------------------- DOMPoint ----------------------------- */ 
/* ./webidl/DOMPoint.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.fxtf.org/geometry/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker),
 Serializable]
interface DOMPointReadOnly {
    constructor(optional unrestricted double x = 0,
                optional unrestricted double y = 0,
                optional unrestricted double z = 0,
                optional unrestricted double w = 1);

    [NewObject] static DOMPointReadOnly fromPoint(optional DOMPointInit other = {});

    readonly attribute unrestricted double x;
    readonly attribute unrestricted double y;
    readonly attribute unrestricted double z;
    readonly attribute unrestricted double w;

    [NewObject, Throws] DOMPoint matrixTransform(optional DOMMatrixInit matrix = {});

    [Default] object toJSON();
};

[Exposed=(Window,Worker),
 Serializable]
interface DOMPoint : DOMPointReadOnly {
    constructor(optional unrestricted double x = 0,
                optional unrestricted double y = 0,
                optional unrestricted double z = 0,
                optional unrestricted double w = 1);

    [NewObject] static DOMPoint fromPoint(optional DOMPointInit other = {});

    inherit attribute unrestricted double x;
    inherit attribute unrestricted double y;
    inherit attribute unrestricted double z;
    inherit attribute unrestricted double w;
};

dictionary DOMPointInit {
    unrestricted double x = 0;
    unrestricted double y = 0;
    unrestricted double z = 0;
    unrestricted double w = 1;
};
 
/* ---------------------- DOMQuad ----------------------------- */ 
/* ./webidl/DOMQuad.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.fxtf.org/geometry/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker),
 Serializable]
interface DOMQuad {
    constructor(optional DOMPointInit p1 = {}, optional DOMPointInit p2 = {},
                optional DOMPointInit p3 = {}, optional DOMPointInit p4 = {});
    constructor(DOMRectReadOnly rect);

    [NewObject] static DOMQuad fromRect(optional DOMRectInit other = {});
    [NewObject] static DOMQuad fromQuad(optional DOMQuadInit other = {});

    [SameObject] readonly attribute DOMPoint p1;
    [SameObject] readonly attribute DOMPoint p2;
    [SameObject] readonly attribute DOMPoint p3;
    [SameObject] readonly attribute DOMPoint p4;
    [NewObject] DOMRectReadOnly getBounds();

    [Default] object toJSON();
};

dictionary DOMQuadInit {
    DOMPointInit p1 = {};
    DOMPointInit p2 = {};
    DOMPointInit p3 = {};
    DOMPointInit p4 = {};
};
 
/* ---------------------- DOMRect ----------------------------- */ 
/* ./webidl/DOMRect.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.fxtf.org/geometry/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker),
 Serializable]
interface DOMRect : DOMRectReadOnly {
    constructor(optional unrestricted double x = 0,
                optional unrestricted double y = 0,
                optional unrestricted double width = 0,
                optional unrestricted double height = 0);

    [NewObject] static DOMRect fromRect(optional DOMRectInit other = {});

    inherit attribute unrestricted double x;
    inherit attribute unrestricted double y;
    inherit attribute unrestricted double width;
    inherit attribute unrestricted double height;
};

[ProbablyShortLivingWrapper,
 Exposed=(Window,Worker),
 Serializable]
interface DOMRectReadOnly {
    constructor(optional unrestricted double x = 0,
                optional unrestricted double y = 0,
                optional unrestricted double width = 0,
                optional unrestricted double height = 0);

    [NewObject] static DOMRectReadOnly fromRect(optional DOMRectInit other = {});

    readonly attribute unrestricted double x;
    readonly attribute unrestricted double y;
    readonly attribute unrestricted double width;
    readonly attribute unrestricted double height;
    readonly attribute unrestricted double top;
    readonly attribute unrestricted double right;
    readonly attribute unrestricted double bottom;
    readonly attribute unrestricted double left;

    [Default] object toJSON();
};

dictionary DOMRectInit {
    unrestricted double x = 0;
    unrestricted double y = 0;
    unrestricted double width = 0;
    unrestricted double height = 0;
};
 
/* ---------------------- DOMRectList ----------------------------- */ 
/* ./webidl/DOMRectList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface DOMRectList {
  readonly attribute unsigned long length;
  getter DOMRect? item(unsigned long index);
};
 
/* ---------------------- DOMStringList ----------------------------- */ 
/* ./webidl/DOMStringList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker)]
interface DOMStringList {
  readonly attribute unsigned long length;
  getter DOMString? item(unsigned long index);
  boolean contains(DOMString string);
};
 
/* ---------------------- DOMStringMap ----------------------------- */ 
/* ./webidl/DOMStringMap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/common-dom-interfaces.html#domstringmap-0
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[LegacyOverrideBuiltIns,
 Exposed=Window]
interface DOMStringMap {
  getter DOMString (DOMString name);
  [CEReactions, Throws]
  setter undefined (DOMString name, DOMString value);
  [CEReactions]
  deleter undefined (DOMString name);
};
 
/* ---------------------- DOMTokenList ----------------------------- */ 
/* ./webidl/DOMTokenList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#interface-domtokenlist
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface DOMTokenList {
  [Pure]
  readonly attribute unsigned long length;
  [Pure]
  getter DOMString? item(unsigned long index);
  [Pure]
  boolean contains(DOMString token);
  [CEReactions, Throws]
  undefined add(DOMString... tokens);
  [CEReactions, Throws]
  undefined remove(DOMString... tokens);
  [CEReactions, Throws]
  boolean replace(DOMString token, DOMString newToken);
  [CEReactions, Throws]
  boolean toggle(DOMString token, optional boolean force);
  [Throws]
  boolean supports(DOMString token);
  [CEReactions, SetterThrows, Pure]
  stringifier attribute DOMString value;
  iterable<DOMString?>;
};
 
/* ---------------------- DragEvent ----------------------------- */ 
/* ./webidl/DragEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/#dragevent
 */

[Exposed=Window]
interface DragEvent : MouseEvent
{
  constructor(DOMString type, optional DragEventInit eventInitDict = {});

  readonly attribute DataTransfer? dataTransfer;

  undefined initDragEvent(DOMString type,
                          optional boolean canBubble = false,
                          optional boolean cancelable = false,
                          optional Window? aView = null,
                          optional long aDetail = 0,
                          optional long aScreenX = 0,
                          optional long aScreenY = 0,
                          optional long aClientX = 0,
                          optional long aClientY = 0,
                          optional boolean aCtrlKey = false,
                          optional boolean aAltKey = false,
                          optional boolean aShiftKey = false,
                          optional boolean aMetaKey = false,
                          optional unsigned short aButton = 0,
                          optional EventTarget? aRelatedTarget = null,
                          optional DataTransfer? aDataTransfer = null);
};

dictionary DragEventInit : MouseEventInit
{
  DataTransfer? dataTransfer = null;
};
 
/* ---------------------- DynamicsCompressorNode ----------------------------- */ 
/* ./webidl/DynamicsCompressorNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary DynamicsCompressorOptions : AudioNodeOptions {
             float attack = 0.003;
             float knee = 30;
             float ratio = 12;
             float release = 0.25;
             float threshold = -24;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface DynamicsCompressorNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context,
                optional DynamicsCompressorOptions options = {});

    readonly attribute AudioParam threshold; // in Decibels
    readonly attribute AudioParam knee; // in Decibels
    readonly attribute AudioParam ratio; // unit-less
    readonly attribute float reduction; // in Decibels
    readonly attribute AudioParam attack; // in Seconds
    [BinaryName="getRelease"]
    readonly attribute AudioParam release; // in Seconds

};

// Mozilla extension
DynamicsCompressorNode includes AudioNodePassThrough;
 
/* ---------------------- Element ----------------------------- */ 
/* ./webidl/Element.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#interface-element
 * https://domparsing.spec.whatwg.org/
 * https://drafts.csswg.org/cssom-view/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

interface nsIScreen;

[Exposed=Window,
 InstrumentedProps=(computedStyleMap,onmousewheel,scrollIntoViewIfNeeded)]
interface Element : Node {
  [Constant]
  readonly attribute DOMString? namespaceURI;
  [Constant]
  readonly attribute DOMString? prefix;
  [Constant]
  readonly attribute DOMString localName;

  // Not [Constant] because it depends on which document we're in
  [Pure]
  readonly attribute DOMString tagName;

  [CEReactions, Pure]
           attribute DOMString id;
  [CEReactions, Pure]
           attribute DOMString className;
  [Constant, PutForwards=value]
  readonly attribute DOMTokenList classList;

  // https://drafts.csswg.org/css-shadow-parts/#idl
  [SameObject, PutForwards=value]
  readonly attribute DOMTokenList part;

  [SameObject]
  readonly attribute NamedNodeMap attributes;
  [Pure]
  sequence<DOMString> getAttributeNames();
  [Pure]
  DOMString? getAttribute(DOMString name);
  [Pure]
  DOMString? getAttributeNS(DOMString? namespace, DOMString localName);
  [CEReactions, NeedsSubjectPrincipal=NonSystem, Throws]
  boolean toggleAttribute(DOMString name, optional boolean force);
  [CEReactions, NeedsSubjectPrincipal=NonSystem, Throws]
  undefined setAttribute(DOMString name, DOMString value);
  [CEReactions, NeedsSubjectPrincipal=NonSystem, Throws]
  undefined setAttributeNS(DOMString? namespace, DOMString name, DOMString value);
  [CEReactions, Throws]
  undefined removeAttribute(DOMString name);
  [CEReactions, Throws]
  undefined removeAttributeNS(DOMString? namespace, DOMString localName);
  [Pure]
  boolean hasAttribute(DOMString name);
  [Pure]
  boolean hasAttributeNS(DOMString? namespace, DOMString localName);
  [Pure]
  boolean hasAttributes();

  [Throws, Pure]
  Element? closest(UTF8String selector);

  [Throws, Pure]
  boolean matches(UTF8String selector);
  [Throws, Pure, BinaryName="matches"]
  boolean webkitMatchesSelector(UTF8String selector);

  [Pure]
  HTMLCollection getElementsByTagName(DOMString localName);
  [Throws, Pure]
  HTMLCollection getElementsByTagNameNS(DOMString? namespace, DOMString localName);
  [Pure]
  HTMLCollection getElementsByClassName(DOMString classNames);

  [CEReactions, Throws]
  Element? insertAdjacentElement(DOMString where, Element element); // historical

  [Throws]
  undefined insertAdjacentText(DOMString where, DOMString data); // historical

  /**
   * The ratio of font-size-inflated text font size to computed font
   * size for this element. This will query the element for its primary frame,
   * and then use this to get font size inflation information about the frame.
   * This will be 1.0 if font size inflation is not enabled, and -1.0 if an
   * error occurred during the retrieval of the font size inflation.
   *
   * @note The font size inflation ratio that is returned is actually the
   *       font size inflation data for the element's _primary frame_, not the
   *       element itself, but for most purposes, this should be sufficient.
   */
  [ChromeOnly]
  readonly attribute float fontSizeInflation;

  /**
   * Returns the pseudo-element string if this element represents a
   * pseudo-element, or null otherwise.
   */
  [ChromeOnly]
  readonly attribute DOMString? implementedPseudoElement;

  // Selectors API
  /**
   * Returns whether this element would be selected by the given selector
   * string.
   *
   * https://dom.spec.whatwg.org/#dom-element-matches
   */
  [Throws, Pure, BinaryName="matches"]
  boolean mozMatchesSelector(UTF8String selector);

  // Pointer events methods.
  [UseCounter, Throws]
  undefined setPointerCapture(long pointerId);
  [UseCounter, Throws]
  undefined releasePointerCapture(long pointerId);
  boolean hasPointerCapture(long pointerId);

  // Proprietary extensions
  /**
   * Set this during a mousedown event to grab and retarget all mouse events
   * to this element until the mouse button is released or releaseCapture is
   * called. If retargetToElement is true, then all events are targetted at
   * this element. If false, events can also fire at descendants of this
   * element.
   *
   */
  [Deprecated=ElementSetCapture, Pref="dom.mouse_capture.enabled"]
  undefined setCapture(optional boolean retargetToElement = false);

  /**
   * If this element has captured the mouse, release the capture. If another
   * element has captured the mouse, this method has no effect.
   */
  [Deprecated=ElementReleaseCapture, Pref="dom.mouse_capture.enabled"]
  undefined releaseCapture();

  /*
   * Chrome-only version of setCapture that works outside of a mousedown event.
   */
  [ChromeOnly]
  undefined setCaptureAlways(optional boolean retargetToElement = false);

  // Mozilla extensions

  // Obsolete methods.
  Attr? getAttributeNode(DOMString name);
  [CEReactions, Throws]
  Attr? setAttributeNode(Attr newAttr);
  [CEReactions, Throws]
  Attr? removeAttributeNode(Attr oldAttr);
  Attr? getAttributeNodeNS(DOMString? namespaceURI, DOMString localName);
  [CEReactions, Throws]
  Attr? setAttributeNodeNS(Attr newAttr);

  [Func="nsContentUtils::IsCallerChromeOrElementTransformGettersEnabled"]
  DOMMatrixReadOnly getTransformToAncestor(Element ancestor);
  [Func="nsContentUtils::IsCallerChromeOrElementTransformGettersEnabled"]
  DOMMatrixReadOnly getTransformToParent();
  [Func="nsContentUtils::IsCallerChromeOrElementTransformGettersEnabled"]
  DOMMatrixReadOnly getTransformToViewport();
};

// https://html.spec.whatwg.org/#focus-management-apis
dictionary FocusOptions {
  boolean preventScroll = false;
  boolean focusVisible;
};

interface mixin HTMLOrForeignElement {
  [SameObject] readonly attribute DOMStringMap dataset;
  // See bug 1389421
  // attribute DOMString nonce; // intentionally no [CEReactions]

  [CEReactions, SetterThrows, Pure] attribute boolean autofocus;
  [CEReactions, SetterThrows, Pure] attribute long tabIndex;
  [Throws, NeedsCallerType] undefined focus(optional FocusOptions options = {});
  [Throws] undefined blur();
};

// https://drafts.csswg.org/cssom/#the-elementcssinlinestyle-mixin
interface mixin ElementCSSInlineStyle {
  [SameObject, PutForwards=cssText]
  readonly attribute CSSStyleDeclaration style;
};

// https://drafts.csswg.org/cssom-view/
enum ScrollLogicalPosition { "start", "center", "end", "nearest" };
dictionary ScrollIntoViewOptions : ScrollOptions {
  ScrollLogicalPosition block = "start";
  ScrollLogicalPosition inline = "nearest";
};

dictionary CheckVisibilityOptions {
  boolean checkOpacity = false;
  boolean checkVisibilityCSS = false;
  boolean contentVisibilityAuto = false;
  boolean opacityProperty = false;
  boolean visibilityProperty = false;
  [ChromeOnly] boolean flush = true;
};

// https://drafts.csswg.org/cssom-view/#extensions-to-the-element-interface
partial interface Element {
  DOMRectList getClientRects();
  DOMRect getBoundingClientRect();

  boolean checkVisibility(optional CheckVisibilityOptions options = {});

  // scrolling
  undefined scrollIntoView(optional (boolean or ScrollIntoViewOptions) arg = {});
  // None of the CSSOM attributes are [Pure], because they flush
           attribute long scrollTop;   // scroll on setting
           attribute long scrollLeft;  // scroll on setting
  readonly attribute long scrollWidth;
  readonly attribute long scrollHeight;

  [BinaryName="scrollTo"]
  undefined scroll(unrestricted double x, unrestricted double y);
  [BinaryName="scrollTo"]
  undefined scroll(optional ScrollToOptions options = {});
  undefined scrollTo(unrestricted double x, unrestricted double y);
  undefined scrollTo(optional ScrollToOptions options = {});
  undefined scrollBy(unrestricted double x, unrestricted double y);
  undefined scrollBy(optional ScrollToOptions options = {});
  // mozScrollSnap is used by chrome to perform scroll snapping after the
  // user performs actions that may affect scroll position
  // mozScrollSnap is deprecated, to be replaced by a web accessible API, such
  // as an extension to the ScrollOptions dictionary.  See bug 1137937.
  [ChromeOnly] undefined mozScrollSnap();

  readonly attribute long clientTop;
  readonly attribute long clientLeft;
  readonly attribute long clientWidth;
  readonly attribute long clientHeight;

  // Return the screen coordinates of the element, in CSS pixels relative to
  // the window's screen.
  [ChromeOnly] readonly attribute long screenX;
  [ChromeOnly] readonly attribute long screenY;
  [ChromeOnly] readonly attribute nsIScreen? screen;

  // Mozilla specific stuff
  /* The minimum/maximum offset that the element can be scrolled to
     (i.e., the value that scrollLeft/scrollTop would be clamped to if they were
     set to arbitrarily large values. */
  [ChromeOnly] readonly attribute long scrollTopMin;
               readonly attribute long scrollTopMax;
  [ChromeOnly] readonly attribute long scrollLeftMin;
               readonly attribute long scrollLeftMax;

  [Pref="layout.css.zoom.enabled"] readonly attribute double currentCSSZoom;
};

// http://domparsing.spec.whatwg.org/#extensions-to-the-element-interface
partial interface Element {
  [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, Pure, SetterThrows, GetterCanOOM]
  attribute [LegacyNullToEmptyString] DOMString innerHTML;
  [CEReactions, Pure, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString outerHTML;
  [CEReactions, Throws]
  undefined insertAdjacentHTML(DOMString position, DOMString text);
};

// https://dom.spec.whatwg.org/#dictdef-shadowrootinit
dictionary ShadowRootInit {
  required ShadowRootMode mode;
  boolean delegatesFocus = false;
  SlotAssignmentMode slotAssignment = "named";
  [Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  boolean clonable = false;
};

// https://dom.spec.whatwg.org/#element
partial interface Element {
  // Shadow DOM v1
  [Throws, UseCounter]
  ShadowRoot attachShadow(ShadowRootInit shadowRootInitDict);
  [BinaryName="shadowRootByMode"]
  readonly attribute ShadowRoot? shadowRoot;

  [Func="Document::IsCallerChromeOrAddon", BinaryName="shadowRoot"]
  readonly attribute ShadowRoot? openOrClosedShadowRoot;

  [BinaryName="assignedSlotByMode"]
  readonly attribute HTMLSlotElement? assignedSlot;

  [ChromeOnly, BinaryName="assignedSlot"]
  readonly attribute HTMLSlotElement? openOrClosedAssignedSlot;

  [CEReactions, Unscopable, SetterThrows]
           attribute DOMString slot;
};

Element includes ChildNode;
Element includes NonDocumentTypeChildNode;
Element includes ParentNode;
Element includes Animatable;
Element includes GeometryUtils;
Element includes ARIAMixin;

// https://fullscreen.spec.whatwg.org/#api
partial interface Element {
  [NewObject, NeedsCallerType]
  Promise<undefined> requestFullscreen();
  [NewObject, BinaryName="requestFullscreen", NeedsCallerType, Deprecated="MozRequestFullScreenDeprecatedPrefix"]
  Promise<undefined> mozRequestFullScreen();

  // Events handlers
  attribute EventHandler onfullscreenchange;
  attribute EventHandler onfullscreenerror;
};

// https://w3c.github.io/pointerlock/#extensions-to-the-element-interface
partial interface Element {
  [NeedsCallerType, Pref="dom.pointer-lock.enabled"]
  undefined requestPointerLock();
};

// Mozilla-specific additions to support devtools
partial interface Element {
  // Support reporting of Flexbox properties
  /**
   * If this element has a display:flex or display:inline-flex style,
   * this property returns an object with computed values for flex
   * properties, as well as a property that exposes the flex lines
   * in this container.
   */
  [ChromeOnly, Pure]
  Flex? getAsFlexContainer();

  // Support reporting of Grid properties
  /**
   * If this element has a display:grid or display:inline-grid style,
   * this property returns an object with computed values for grid
   * tracks and lines.
   */
  [ChromeOnly, Pure]
  sequence<Grid> getGridFragments();

  /**
   * Returns whether there are any grid fragments on this element.
   */
  [ChromeOnly, Pure]
  boolean hasGridFragments();

  /**
   * Returns a sequence of all the descendent elements of this element
   * that have display:grid or display:inline-grid style and generate
   * a frame.
   */
  [ChromeOnly, Pure]
  sequence<Element> getElementsWithGrid();

  /**
   * Set attribute on the Element with a customized Content-Security-Policy
   * appropriate to devtools, which includes:
   * style-src 'unsafe-inline'
   */
  [ChromeOnly, CEReactions, Throws]
  undefined setAttributeDevtools(DOMString name, DOMString value);
  [ChromeOnly, CEReactions, Throws]
  undefined setAttributeDevtoolsNS(DOMString? namespace, DOMString name, DOMString value);

  /**
   * Provide a direct way to determine if this Element has visible
   * scrollbars. Flushes layout.
   */
  [ChromeOnly]
  readonly attribute boolean hasVisibleScrollbars;
};

// These variables are used in vtt.js, they are used for positioning vtt cues.
partial interface Element {
  // These two attributes are a double version of the clientHeight and the
  // clientWidth.
  [ChromeOnly]
  readonly attribute double clientHeightDouble;
  [ChromeOnly]
  readonly attribute double clientWidthDouble;
  // This attribute returns the block size of the first line box under the different
  // writing directions. If the direction is horizontal, it represents box's
  // height. If the direction is vertical, it represents box's width.
  [ChromeOnly]
  readonly attribute double firstLineBoxBSize;
};


// Sanitizer API, https://wicg.github.io/sanitizer-api/
dictionary SetHTMLOptions {
  SanitizerConfig sanitizer;
};

partial interface Element {
  [SecureContext, UseCounter, Throws, Pref="dom.security.setHTML.enabled"]
  undefined setHTML(DOMString aInnerHTML, optional SetHTMLOptions options = {});
};

partial interface Element {
  // https://html.spec.whatwg.org/#dom-element-sethtmlunsafe
  [Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  undefined setHTMLUnsafe(DOMString html);
};
 
/* ---------------------- ElementInternals ----------------------------- */ 
/* ./webidl/ElementInternals.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/#elementinternals
 */

[Exposed=Window]
interface ElementInternals {
  // Shadow root access
  readonly attribute ShadowRoot? shadowRoot;

  // Form-associated custom elements
  [Throws]
  undefined setFormValue((File or USVString or FormData)? value,
                         optional (File or USVString or FormData)? state);

  [Throws]
  readonly attribute HTMLFormElement? form;

  [Throws]
  undefined setValidity(optional ValidityStateFlags flags = {},
                        optional DOMString message,
                        optional HTMLElement anchor);
  [Throws]
  readonly attribute boolean willValidate;
  [Throws]
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  [Throws]
  boolean checkValidity();
  [Throws]
  boolean reportValidity();

  [Throws]
  readonly attribute NodeList labels;

  [Pref="dom.element.customstateset.enabled", SameObject] readonly attribute CustomStateSet states;
};

[Pref="dom.element.customstateset.enabled", Exposed=Window]
interface CustomStateSet {
  setlike<DOMString>;
};

partial interface CustomStateSet {
  // Setlike methods need to be overriden.
  [Throws]
  undefined add(DOMString state);

  [Throws]
  boolean delete(DOMString state);

  [Throws]
  undefined clear();
};

partial interface ElementInternals {
  [ChromeOnly, Throws]
  readonly attribute HTMLElement? validationAnchor;
};

ElementInternals includes ARIAMixin;

dictionary ValidityStateFlags {
  boolean valueMissing = false;
  boolean typeMismatch = false;
  boolean patternMismatch = false;
  boolean tooLong = false;
  boolean tooShort = false;
  boolean rangeUnderflow = false;
  boolean rangeOverflow = false;
  boolean stepMismatch = false;
  boolean badInput = false;
  boolean customError = false;
};
 
/* ---------------------- EncodedAudioChunk ----------------------------- */ 
/* ./webidl/EncodedAudioChunk.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webcodecs/#encodedaudiochunk
 */

// [Serializable] is implemented without adding attribute here.
[Exposed=(Window,DedicatedWorker), Pref="dom.media.webcodecs.enabled"]
interface EncodedAudioChunk {
  [Throws]
  constructor(EncodedAudioChunkInit init);
  readonly attribute EncodedAudioChunkType type;
  readonly attribute long long timestamp;          // microseconds
  readonly attribute unsigned long long? duration; // microseconds
  readonly attribute unsigned long byteLength;

  [Throws]
  undefined copyTo(
      // bug 1696216: Should be `copyTo(AllowSharedBufferSource destination, ...)`
      ([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) destination);
};

dictionary EncodedAudioChunkInit {
  required EncodedAudioChunkType type;
  required [EnforceRange] long long timestamp;    // microseconds
  [EnforceRange] unsigned long long duration;     // microseconds
  // bug 1696216: Should be AllowSharedBufferSource
  required ([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) data;
  sequence<ArrayBuffer> transfer = [];
};

enum EncodedAudioChunkType {
    "key",
    "delta"
};
 
/* ---------------------- EncodedVideoChunk ----------------------------- */ 
/* ./webidl/EncodedVideoChunk.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webcodecs/#encodedvideochunk
 */

// [Serializable] is implemented without adding attribute here.
[Exposed=(Window,DedicatedWorker), Pref="dom.media.webcodecs.enabled"]
interface EncodedVideoChunk {
  [Throws]
  constructor(EncodedVideoChunkInit init);
  readonly attribute EncodedVideoChunkType type;
  readonly attribute long long timestamp;             // microseconds
  readonly attribute unsigned long long? duration;    // microseconds
  readonly attribute unsigned long byteLength;

  // bug 1696216: Should be `copyTo([AllowShared] BufferSource destination)`
  [Throws]
  undefined copyTo(([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) destination);
};

dictionary EncodedVideoChunkInit {
  required EncodedVideoChunkType type;
  required [EnforceRange] long long timestamp;        // microseconds
  [EnforceRange] unsigned long long duration;         // microseconds
  // bug 1696216: Should be `required BufferSource data`
  required ([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) data;
};

enum EncodedVideoChunkType {
    "key",
    "delta",
};
 
/* ---------------------- ErrorEvent ----------------------------- */ 
/* ./webidl/ErrorEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/#the-errorevent-interface
 */

[Exposed=(Window,Worker)]
interface ErrorEvent : Event
{
  constructor(DOMString type, optional ErrorEventInit eventInitDict = {});

  readonly attribute DOMString message;
  readonly attribute DOMString filename;
  readonly attribute unsigned long lineno;
  readonly attribute unsigned long colno;
  readonly attribute any error;
};

dictionary ErrorEventInit : EventInit
{
  DOMString message = "";
  DOMString filename = "";
  unsigned long lineno = 0;
  unsigned long colno = 0;
  any error;
};
 
/* ---------------------- Event ----------------------------- */ 
/* ./webidl/Event.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker,AudioWorklet), ProbablyShortLivingWrapper]
interface Event {
  constructor(DOMString type, optional EventInit eventInitDict = {});

  [Pure]
  readonly attribute DOMString type;
  [Pure, BindingAlias="srcElement"]
  readonly attribute EventTarget? target;
  [Pure]
  readonly attribute EventTarget? currentTarget;

  sequence<EventTarget> composedPath();

  const unsigned short NONE = 0;
  const unsigned short CAPTURING_PHASE = 1;
  const unsigned short AT_TARGET = 2;
  const unsigned short BUBBLING_PHASE = 3;
  [Pure]
  readonly attribute unsigned short eventPhase;

  undefined stopPropagation();
  undefined stopImmediatePropagation();

  [Pure]
  readonly attribute boolean bubbles;
  [Pure]
  readonly attribute boolean cancelable;
  [NeedsCallerType]
  attribute boolean returnValue;
  [NeedsCallerType]
  undefined preventDefault();
  [Pure, NeedsCallerType]
  readonly attribute boolean defaultPrevented;
  [ChromeOnly, Pure]
  readonly attribute boolean defaultPreventedByChrome;
  [ChromeOnly, Pure]
  readonly attribute boolean defaultPreventedByContent;
  [Pure]
  readonly attribute boolean composed;

  [LegacyUnforgeable, Pure]
  readonly attribute boolean isTrusted;
  [Pure]
  readonly attribute DOMHighResTimeStamp timeStamp;

  undefined initEvent(DOMString type,
                      optional boolean bubbles = false,
                      optional boolean cancelable = false);
  attribute boolean cancelBubble;
};

// Mozilla specific legacy stuff.
partial interface Event {
  const long ALT_MASK     = 0x00000001;
  const long CONTROL_MASK = 0x00000002;
  const long SHIFT_MASK   = 0x00000004;
  const long META_MASK    = 0x00000008;

  /** The original target of the event, before any retargetings. */
  readonly attribute EventTarget? originalTarget;
  /**
   * The explicit original target of the event.  If the event was retargeted
   * for some reason other than an anonymous boundary crossing, this will be set
   * to the target before the retargeting occurs.  For example, mouse events
   * are retargeted to their parent node when they happen over text nodes (bug
   * 185889), and in that case .target will show the parent and
   * .explicitOriginalTarget will show the text node.
   * .explicitOriginalTarget differs from .originalTarget in that it will never
   * contain anonymous content.
   */
  readonly attribute EventTarget? explicitOriginalTarget;
  [ChromeOnly] readonly attribute EventTarget? composedTarget;
  [ChromeOnly] undefined preventMultipleActions();
  [ChromeOnly] readonly attribute boolean multipleActionsPrevented;
  [ChromeOnly] readonly attribute boolean isSynthesized;
  /**
   * When the event target is a remote browser, calling this will fire an
   * reply event in the chrome process.
   */
  [ChromeOnly] undefined requestReplyFromRemoteContent();
  /**
   * Returns true when the event shouldn't be handled by chrome.
   */
  [ChromeOnly] readonly attribute boolean isWaitingReplyFromRemoteContent;
  /**
   * Returns true when the event is a reply event from a remote process.
   */
  [ChromeOnly] readonly attribute boolean isReplyEventFromRemoteContent;
};

dictionary EventInit {
  boolean bubbles = false;
  boolean cancelable = false;
  boolean composed = false;
};
 
/* ---------------------- EventHandler ----------------------------- */ 
/* ./webidl/EventHandler.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#eventhandler
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */
[LegacyTreatNonObjectAsNull]
callback EventHandlerNonNull = any (Event event);
typedef EventHandlerNonNull? EventHandler;

[LegacyTreatNonObjectAsNull]
callback OnBeforeUnloadEventHandlerNonNull = DOMString? (Event event);
typedef OnBeforeUnloadEventHandlerNonNull? OnBeforeUnloadEventHandler;

[LegacyTreatNonObjectAsNull]
callback OnErrorEventHandlerNonNull = any ((Event or DOMString) event, optional DOMString source, optional unsigned long lineno, optional unsigned long column, optional any error);
typedef OnErrorEventHandlerNonNull? OnErrorEventHandler;

interface mixin GlobalEventHandlers {
           attribute EventHandler onabort;
           attribute EventHandler onblur;
// We think the spec is wrong here. See OnErrorEventHandlerForNodes/Window
// below.
//         attribute OnErrorEventHandler onerror;
           attribute EventHandler onfocus;
           attribute EventHandler oncancel;
           attribute EventHandler onauxclick;
           attribute EventHandler onbeforeinput;
           [Pref="dom.element.popover.enabled"]
           attribute EventHandler onbeforetoggle;
           attribute EventHandler oncanplay;
           attribute EventHandler oncanplaythrough;
           attribute EventHandler onchange;
           attribute EventHandler onclick;
           attribute EventHandler onclose;
           attribute EventHandler oncontextlost;
           attribute EventHandler oncontextmenu;
           attribute EventHandler oncontextrestored;
           attribute EventHandler oncopy;
           attribute EventHandler oncuechange;
           attribute EventHandler oncut;
           attribute EventHandler ondblclick;
           attribute EventHandler ondrag;
           attribute EventHandler ondragend;
           attribute EventHandler ondragenter;
           [Func="Event::IsDragExitEnabled"]
           attribute EventHandler ondragexit;
           attribute EventHandler ondragleave;
           attribute EventHandler ondragover;
           attribute EventHandler ondragstart;
           attribute EventHandler ondrop;
           attribute EventHandler ondurationchange;
           attribute EventHandler onemptied;
           attribute EventHandler onended;
           attribute EventHandler onformdata;
           attribute EventHandler oninput;
           attribute EventHandler oninvalid;
           attribute EventHandler onkeydown;
           attribute EventHandler onkeypress;
           attribute EventHandler onkeyup;
           attribute EventHandler onload;
           attribute EventHandler onloadeddata;
           attribute EventHandler onloadedmetadata;
           attribute EventHandler onloadstart;
           attribute EventHandler onmousedown;
  [LegacyLenientThis] attribute EventHandler onmouseenter;
  [LegacyLenientThis] attribute EventHandler onmouseleave;
           attribute EventHandler onmousemove;
           attribute EventHandler onmouseout;
           attribute EventHandler onmouseover;
           attribute EventHandler onmouseup;
           attribute EventHandler onwheel;
           attribute EventHandler onpaste;
           attribute EventHandler onpause;
           attribute EventHandler onplay;
           attribute EventHandler onplaying;
           attribute EventHandler onprogress;
           attribute EventHandler onratechange;
           attribute EventHandler onreset;
           attribute EventHandler onresize;
           attribute EventHandler onscroll;
           attribute EventHandler onscrollend;
           attribute EventHandler onsecuritypolicyviolation;
           attribute EventHandler onseeked;
           attribute EventHandler onseeking;
           attribute EventHandler onselect;
           attribute EventHandler onslotchange;
           //(Not implemented)attribute EventHandler onsort;
           attribute EventHandler onstalled;
           attribute EventHandler onsubmit;
           attribute EventHandler onsuspend;
           attribute EventHandler ontimeupdate;
           attribute EventHandler onvolumechange;
           attribute EventHandler onwaiting;

           attribute EventHandler onselectstart;
           attribute EventHandler onselectionchange;

           attribute EventHandler ontoggle;

           // Pointer events handlers
           attribute EventHandler onpointercancel;
           attribute EventHandler onpointerdown;
           attribute EventHandler onpointerup;
           attribute EventHandler onpointermove;
           attribute EventHandler onpointerout;
           attribute EventHandler onpointerover;
           attribute EventHandler onpointerenter;
           attribute EventHandler onpointerleave;
           attribute EventHandler ongotpointercapture;
           attribute EventHandler onlostpointercapture;

           // Mozilla-specific handlers. Unprefixed handlers live in
           // Document rather than here.
           [Deprecated="MozfullscreenchangeDeprecatedPrefix"]
           attribute EventHandler onmozfullscreenchange;
           [Deprecated="MozfullscreenerrorDeprecatedPrefix"]
           attribute EventHandler onmozfullscreenerror;

           // CSS-Animation and CSS-Transition handlers.
           attribute EventHandler onanimationcancel;
           attribute EventHandler onanimationend;
           attribute EventHandler onanimationiteration;
           attribute EventHandler onanimationstart;
           attribute EventHandler ontransitioncancel;
           attribute EventHandler ontransitionend;
           attribute EventHandler ontransitionrun;
           attribute EventHandler ontransitionstart;

           // CSS-Animation and CSS-Transition legacy handlers.
           // This handler isn't standard.
           [BinaryName="onwebkitAnimationEnd"]
           attribute EventHandler onwebkitanimationend;
           [BinaryName="onwebkitAnimationIteration"]
           attribute EventHandler onwebkitanimationiteration;
           [BinaryName="onwebkitAnimationStart"]
           attribute EventHandler onwebkitanimationstart;
           [BinaryName="onwebkitTransitionEnd"]
           attribute EventHandler onwebkittransitionend;
};

interface mixin WindowEventHandlers {
           attribute EventHandler onafterprint;
           attribute EventHandler onbeforeprint;
           attribute OnBeforeUnloadEventHandler onbeforeunload;
           attribute EventHandler onhashchange;
           attribute EventHandler onlanguagechange;
           attribute EventHandler onmessage;
           attribute EventHandler onmessageerror;
           attribute EventHandler onoffline;
           attribute EventHandler ononline;
           attribute EventHandler onpagehide;
           attribute EventHandler onpageshow;
           attribute EventHandler onpopstate;
           attribute EventHandler onrejectionhandled;
           attribute EventHandler onstorage;
           attribute EventHandler onunhandledrejection;
           attribute EventHandler onunload;
};

// https://w3c.github.io/gamepad/#extensions-to-the-windoweventhandlers-interface-mixin
partial interface mixin WindowEventHandlers {
  attribute EventHandler ongamepadconnected;
  attribute EventHandler ongamepaddisconnected;
};

// The spec has |attribute OnErrorEventHandler onerror;| on
// GlobalEventHandlers, and calls the handler differently depending on
// whether an ErrorEvent was fired. We don't do that, and until we do we'll
// need to distinguish between onerror on Window or on nodes.

interface mixin OnErrorEventHandlerForNodes {
           attribute EventHandler onerror;
};

interface mixin OnErrorEventHandlerForWindow {
           attribute OnErrorEventHandler onerror;
};
 
/* ---------------------- EventListener ----------------------------- */ 
/* ./webidl/EventListener.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
callback interface EventListener {
  undefined handleEvent(Event event);
};
 
/* ---------------------- EventSource ----------------------------- */ 
/* ./webidl/EventSource.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/comms.html#the-eventsource-interface
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=(Window,DedicatedWorker,SharedWorker)]
interface EventSource : EventTarget {
  [Throws]
  constructor(USVString url, optional EventSourceInit eventSourceInitDict = {});

  [Constant]
  readonly attribute DOMString url;
  [Constant]
  readonly attribute boolean withCredentials;

  // ready state
  const unsigned short CONNECTING = 0;
  const unsigned short OPEN = 1;
  const unsigned short CLOSED = 2;
  readonly attribute unsigned short readyState;

  // networking
  attribute EventHandler onopen;
  attribute EventHandler onmessage;
  attribute EventHandler onerror;
  undefined close();
};

dictionary EventSourceInit {
  boolean withCredentials = false;
};
 
/* ---------------------- EventTarget ----------------------------- */ 
/* ./webidl/EventTarget.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */


dictionary EventListenerOptions {
  boolean capture = false;
  /* Setting to true make the listener be added to the system group. */
  [Func="ThreadSafeIsChromeOrUAWidget"]
  boolean mozSystemGroup = false;
};

dictionary AddEventListenerOptions : EventListenerOptions {
  boolean passive;
  boolean once = false;
  AbortSignal signal;
  [ChromeOnly]
  boolean wantUntrusted;
};

[Exposed=*]
interface EventTarget {
  [Throws]
  constructor();

  /* Passing null for wantsUntrusted means "default behavior", which
     differs in content and chrome.  In content that default boolean
     value is true, while in chrome the default boolean value is
     false. */
  [Throws]
  undefined addEventListener(DOMString type,
                             EventListener? listener,
                             optional (AddEventListenerOptions or boolean) options = {},
                             optional boolean? wantsUntrusted = null);
  [Throws]
  undefined removeEventListener(DOMString type,
                                EventListener? listener,
                                optional (EventListenerOptions or boolean) options = {});
  [Throws, NeedsCallerType]
  boolean dispatchEvent(Event event);
};

// Mozilla extensions for use by JS-implemented event targets to
// implement on* properties.
partial interface EventTarget {
  // The use of [TreatNonCallableAsNull] here is a bit of a hack: it just makes
  // the codegen check whether the type involved is either
  // [TreatNonCallableAsNull] or [TreatNonObjectAsNull] and if it is handle it
  // accordingly.  In particular, it will NOT actually treat a non-null
  // non-callable object as null here.
  [ChromeOnly, Throws]
  undefined setEventHandler(DOMString type,
                            [TreatNonCallableAsNull] EventHandler handler);

  [ChromeOnly]
  EventHandler getEventHandler(DOMString type);
};

// Mozilla extension to make firing events on event targets from
// chrome easier.  This returns the window which can be used to create
// events to fire at this EventTarget, or null if there isn't one.
partial interface EventTarget {
  [ChromeOnly, Exposed=Window, BinaryName="ownerGlobalForBindings"]
  readonly attribute WindowProxy? ownerGlobal;
};
 
/* ---------------------- ExtendableEvent ----------------------------- */ 
/* ./webidl/ExtendableEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html
 */

[Exposed=ServiceWorker]
interface ExtendableEvent : Event {
  constructor(DOMString type, optional ExtendableEventInit eventInitDict = {});

  // https://github.com/slightlyoff/ServiceWorker/issues/261
  [Throws]
  undefined waitUntil(Promise<any> p);
};

dictionary ExtendableEventInit : EventInit {
  // Defined for the forward compatibility across the derived events
};
 
/* ---------------------- ExtendableMessageEvent ----------------------------- */ 
/* ./webidl/ExtendableMessageEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://w3c.github.io/ServiceWorker/#extendablemessage-event-section
 */

[Exposed=(ServiceWorker)]
interface ExtendableMessageEvent : ExtendableEvent {
  constructor(DOMString type,
              optional ExtendableMessageEventInit eventInitDict = {});

  /**
   * Custom data associated with this event.
   */
  [GetterThrows]
  readonly attribute any data;

  /**
   * The origin of the site from which this event originated.
   */
  readonly attribute DOMString origin;

  /**
   * The last event ID string of the event source.
   */
  readonly attribute DOMString lastEventId;

  /**
   * The client, service worker or port which originated this event.
   */
  readonly attribute (Client or ServiceWorker or MessagePort)? source;

  [Constant, Cached, Frozen]
  readonly attribute sequence<MessagePort> ports;
};

dictionary ExtendableMessageEventInit : ExtendableEventInit {
  any data = null;
  DOMString origin = "";
  DOMString lastEventId = "";
  (Client or ServiceWorker or MessagePort)? source = null;
  sequence<MessagePort> ports = [];
};
 
/* ---------------------- ExtensionAlarms ----------------------------- */ 
/* ./webidl/ExtensionAlarms.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- alarms
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "alarms" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionAlarms {
  // API methods.

  [Throws, WebExtensionStub="NoReturn"]
  undefined create(DOMString name, any alarmInfo);
  [Throws, WebExtensionStub="NoReturn"]
  undefined create(any alarmInfo);

  [Throws, WebExtensionStub="Async"]
  any get(DOMString name, optional Function callback);
  [Throws, WebExtensionStub="Async"]
  any get(optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any getAll(optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any clear(DOMString name, optional Function callback);
  [Throws, WebExtensionStub="Async"]
  any clear(optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any clearAll(optional Function callback);

  // API events.

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onAlarm;
};
 
/* ---------------------- ExtensionBrowser ----------------------------- */ 
/* ./webidl/ExtensionBrowser.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 *
 * This IDL file is related to interface mixin for the additional globals that should be
 * available in windows and service workers allowed to access the WebExtensions API and
 * the WebExtensions browser API namespace.
 *
 * More info about generating webidl API bindings for WebExtensions API at:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 * A short summary of the special setup used by these WebIDL files (meant to aid
 * webidl peers reviews and sign-offs) is available in the following section:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

// WebExtensions API interface mixin (used to include ExtensionBrowser interface
// in the ServiceWorkerGlobalScope and Window).
[Exposed=(ServiceWorker)]
interface mixin ExtensionGlobalsMixin {
  [Replaceable, SameObject, BinaryName="AcquireExtensionBrowser",
   BindingAlias="chrome", Func="extensions::ExtensionAPIAllowed"]
  readonly attribute ExtensionBrowser browser;
};

[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionBrowser {
  // A mock API only exposed in tests to unit test the internals
  // meant to be reused by the real WebExtensions API bindings
  // in xpcshell tests.
  [Replaceable, SameObject, BinaryName="GetExtensionMockAPI",
   Func="mozilla::extensions::ExtensionMockAPI::IsAllowed",
   Pref="extensions.webidl-api.expose_mock_interface"]
  readonly attribute ExtensionMockAPI mockExtensionAPI;

  // `browser.alarms` API namespace
  [Replaceable, SameObject, BinaryName="GetExtensionAlarms",
   Func="mozilla::extensions::ExtensionAlarms::IsAllowed"]
  readonly attribute ExtensionAlarms alarms;

  // `browser.browserSettings` API namespace
  [Replaceable, SameObject, BinaryName="GetExtensionBrowserSettings",
   Func="mozilla::extensions::ExtensionBrowserSettings::IsAllowed"]
  readonly attribute ExtensionBrowserSettings browserSettings;

  // `browser.dns` API namespace
  [Replaceable, SameObject, BinaryName="GetExtensionDns",
   Func="mozilla::extensions::ExtensionDns::IsAllowed"]
  readonly attribute ExtensionDns dns;

  // `browser.proxy` API namespace
  [Replaceable, SameObject, BinaryName="GetExtensionProxy",
   Func="mozilla::extensions::ExtensionProxy::IsAllowed"]
  readonly attribute ExtensionProxy proxy;

  // `browser.runtime` API namespace
  [Replaceable, SameObject, BinaryName="GetExtensionRuntime",
   Func="mozilla::extensions::ExtensionRuntime::IsAllowed"]
  readonly attribute ExtensionRuntime runtime;

  // `browser.scripting` API namespace
  [Replaceable, SameObject, BinaryName="GetExtensionScripting",
    Func="mozilla::extensions::ExtensionScripting::IsAllowed"]
  readonly attribute ExtensionScripting scripting;

  // `browser.test` API namespace, available in tests.
  [Replaceable, SameObject, BinaryName="GetExtensionTest",
   Func="mozilla::extensions::ExtensionTest::IsAllowed"]
  readonly attribute ExtensionTest test;
};
 
/* ---------------------- ExtensionBrowserSettings ----------------------------- */ 
/* ./webidl/ExtensionBrowserSettings.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- browserSettings
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "browserSettings" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionBrowserSettings {
  // API properties.

  [Replaceable]
  readonly attribute ExtensionSetting allowPopupsForUserEvents;

  [Replaceable]
  readonly attribute ExtensionSetting cacheEnabled;

  [Replaceable]
  readonly attribute ExtensionSetting closeTabsByDoubleClick;

  [Replaceable]
  readonly attribute ExtensionSetting contextMenuShowEvent;

  [Replaceable]
  readonly attribute ExtensionSetting ftpProtocolEnabled;

  [Replaceable]
  readonly attribute ExtensionSetting homepageOverride;

  [Replaceable]
  readonly attribute ExtensionSetting imageAnimationBehavior;

  [Replaceable]
  readonly attribute ExtensionSetting newTabPageOverride;

  [Replaceable]
  readonly attribute ExtensionSetting newTabPosition;

  [Replaceable]
  readonly attribute ExtensionSetting openBookmarksInNewTabs;

  [Replaceable]
  readonly attribute ExtensionSetting openSearchResultsInNewTabs;

  [Replaceable]
  readonly attribute ExtensionSetting openUrlbarResultsInNewTabs;

  [Replaceable]
  readonly attribute ExtensionSetting webNotificationsDisabled;

  [Replaceable]
  readonly attribute ExtensionSetting overrideDocumentColors;

  [Replaceable]
  readonly attribute ExtensionSetting overrideContentColorScheme;

  [Replaceable]
  readonly attribute ExtensionSetting useDocumentFonts;

  [Replaceable]
  readonly attribute ExtensionSetting zoomFullPage;

  [Replaceable]
  readonly attribute ExtensionSetting zoomSiteSpecific;

  // API child namespaces.

  [Replaceable, SameObject,
  BinaryName="GetExtensionBrowserSettingsColorManagement",
  Func="mozilla::extensions::ExtensionBrowserSettingsColorManagement::IsAllowed"]
  readonly attribute ExtensionBrowserSettingsColorManagement colorManagement;
};
 
/* ---------------------- ExtensionBrowserSettingsColorManagement ----------------------------- */ 
/* ./webidl/ExtensionBrowserSettingsColorManagement.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- browserSettings.colorManagement
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "browserSettings.colorManagement" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionBrowserSettingsColorManagement {
  // API properties.

  [Replaceable]
  readonly attribute ExtensionSetting mode;

  [Replaceable]
  readonly attribute ExtensionSetting useNativeSRGB;

  [Replaceable]
  readonly attribute ExtensionSetting useWebRenderCompositor;
};
 
/* ---------------------- ExtensionDns ----------------------------- */ 
/* ./webidl/ExtensionDns.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- dns
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "dns" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionDns {
  // API methods.

  [Throws, WebExtensionStub="AsyncAmbiguous"]
  any resolve(any... args);
};
 
/* ---------------------- ExtensionEventManager ----------------------------- */ 
/* ./webidl/ExtensionEventManager.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 *
 * This IDL file is related to the WebExtensions API object.
 *
 * More info about generating webidl API bindings for WebExtensions API at:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 * A short summary of the special setup used by these WebIDL files (meant to aid
 * webidl peers reviews and sign-offs) is available in the following section:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionEventManager {
  [Throws]
  undefined addListener(Function callback, optional object listenerOptions);

  [Throws]
  undefined removeListener(Function callback);

  [Throws]
  boolean hasListener(Function callback);

  [Throws]
  boolean hasListeners();
};
 
/* ---------------------- ExtensionMockAPI ----------------------------- */ 
/* ./webidl/ExtensionMockAPI.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 *
 * This IDL file is related to the WebExtensions API object only used in
 * unit tests.
 *
 * More info about generating webidl API bindings for WebExtensions API at:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 * A short summary of the special setup used by these WebIDL files (meant to aid
 * webidl peers reviews and sign-offs) is available in the following section:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

// WebIDL definition for the "mockExtensionAPI" WebExtensions API,
// only available in tests and locked behind an about:config preference
// ("extensions.webidl-api.expose_mock_interface").
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionMockAPI {
  // Test API methods scenarios.

  [Throws, WebExtensionStub]
  any methodSyncWithReturn(any... args);

  [Throws, WebExtensionStub="NoReturn"]
  undefined methodNoReturn(any... args);

  [Throws, WebExtensionStub="Async"]
  any methodAsync(any arg0, optional Function cb);

  [Throws, WebExtensionStub="AsyncAmbiguous"]
  any methodAmbiguousArgsAsync(any... args);

  [Throws, WebExtensionStub="ReturnsPort"]
  ExtensionPort methodReturnsPort(DOMString testName);

  // Test API properties.

  [Replaceable]
  readonly attribute any propertyAsErrorObject;

  [Replaceable]
  readonly attribute DOMString propertyAsString;

  // Test API events.

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onTestEvent;
};
 
/* ---------------------- ExtensionPort ----------------------------- */ 
/* ./webidl/ExtensionPort.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 *
 * This IDL file is related to the WebExtensions browser.runtime's Port.
 *
 * More info about generating webidl API bindings for WebExtensions API at:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 * A short summary of the special setup used by these WebIDL files (meant to aid
 * webidl peers reviews and sign-offs) is available in the following section:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionPort {
  [Replaceable]
  readonly attribute DOMString name;
  [Replaceable]
  readonly attribute any sender;
  [Replaceable]
  readonly attribute any error;

  [Throws, WebExtensionStub="NoReturn"]
  undefined disconnect();
  [Throws, WebExtensionStub="NoReturn"]
  undefined postMessage(any message);

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onDisconnect;
  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onMessage;
};

// Dictionary used by ExtensionAPIRequestForwarder and ExtensionCallabck to receive from the
// mozIExtensionAPIRequestHandler an internal description of a runtime.Port (and then used in
// the webidl implementation to create an ExtensionPort instance).
[GenerateInit]
dictionary ExtensionPortDescriptor {
  required DOMString portId;
  DOMString name = "";
};
 
/* ---------------------- ExtensionProxy ----------------------------- */ 
/* ./webidl/ExtensionProxy.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- proxy
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "proxy" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionProxy {
  // API events.

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onRequest;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onError;

  // API properties.

  [Replaceable]
  readonly attribute ExtensionSetting settings;
};
 
/* ---------------------- ExtensionRuntime ----------------------------- */ 
/* ./webidl/ExtensionRuntime.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- runtime
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "runtime" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionRuntime {
  // API methods.

  [Throws, WebExtensionStub="Async"]
  any openOptionsPage(optional Function callback);

  [Throws, WebExtensionStub]
  any getManifest();

  [Throws, WebExtensionStub="ReturnsString"]
  DOMString getURL(DOMString path);

  [Throws, WebExtensionStub="Async"]
  any setUninstallURL(DOMString url, optional Function callback);
  [Throws, WebExtensionStub="Async"]
  any setUninstallURL(optional Function callback);

  [Throws, WebExtensionStub="NoReturn"]
  undefined reload();

  [Throws, WebExtensionStub="ReturnsPort"]
  ExtensionPort connect(DOMString extensionId, any connectInfo);
  [Throws, WebExtensionStub="ReturnsPort"]
  ExtensionPort connect(any connectInfo);
  [Throws, WebExtensionStub="ReturnsPort"]
  ExtensionPort connect();

  [Throws, WebExtensionStub="ReturnsPort"]
  ExtensionPort connectNative(DOMString application);

  [Throws, WebExtensionStub="AsyncAmbiguous"]
  any sendMessage(any... args);

  [Throws, WebExtensionStub="Async"]
  any sendNativeMessage(DOMString application, any message, optional Function responseCallback);

  [Throws, WebExtensionStub="Async"]
  any getBrowserInfo(optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any getPlatformInfo(optional Function callback);

  // API events.

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onStartup;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onInstalled;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onUpdateAvailable;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onConnect;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onConnectExternal;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onMessage;

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onMessageExternal;

  // API properties.

  [Replaceable]
  readonly attribute any lastError;

  [Replaceable]
  readonly attribute DOMString id;
};
 
/* ---------------------- ExtensionScripting ----------------------------- */ 
/* ./webidl/ExtensionScripting.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- scripting
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "scripting" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionScripting {
  // API methods.

  [Throws, WebExtensionStub="NotImplementedAsync"]
  any executeScript(any injection, optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any insertCSS(any injection, optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any removeCSS(any injection, optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any registerContentScripts(any scripts, optional Function callback);

  [Throws, WebExtensionStub="AsyncAmbiguous"]
  any getRegisteredContentScripts(any... args);

  [Throws, WebExtensionStub="AsyncAmbiguous"]
  any unregisterContentScripts(any... args);

  [Throws, WebExtensionStub="Async"]
  any updateContentScripts(any scripts, optional Function callback);
};
 
/* ---------------------- ExtensionSetting ----------------------------- */ 
/* ./webidl/ExtensionSetting.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 *
 * This IDL file is related to the WebExtensions API object.
 *
 * The ExtensionSetting interface is used by the API namespace that expose
 * settings API sub-namespaces (in particular browserSettings, proxy,
 * captivePortal and privacy WebExtensions APIs).
 *
 * More info about generating webidl API bindings for WebExtensions API at:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 * A short summary of the special setup used by these WebIDL files (meant to aid
 * webidl peers reviews and sign-offs) is available in the following section:
 *
 * https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionSetting {
  // API methods.

  [Throws, WebExtensionStub="Async"]
  any get(object details, optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any set(object details, optional Function callback);

  [Throws, WebExtensionStub="Async"]
  any clear(object details, optional Function callback);

  // API events.

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onChange;
};
 
/* ---------------------- ExtensionTest ----------------------------- */ 
/* ./webidl/ExtensionTest.webidl */ 
 
/*
 *  THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT
 *
 *  The content of this file has been generated based on the WebExtensions API
 *  JSONSchema using the following command:
 *
 *  export SCRIPT_DIR="toolkit/components/extensions/webidl-api"
 *  mach python $SCRIPT_DIR/GenerateWebIDLBindings.py -- test
 *
 *  More info about generating webidl API bindings for WebExtensions API at:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html
 *
 *  A short summary of the special setup used by these WebIDL files (meant to aid
 *  webidl peers reviews and sign-offs) is available in the following section:
 *
 *  https://firefox-source-docs.mozilla.org/toolkit/components/extensions/webextensions/webidl_bindings.html#review-process-on-changes-to-webidl-definitions
 */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

// WebIDL definition for the "test" WebExtensions API
[Exposed=(ServiceWorker), LegacyNoInterfaceObject]
interface ExtensionTest {
  // API methods.

  [Throws, WebExtensionStub="NotImplementedNoReturn"]
  undefined withHandlingUserInput(Function callback);

  [Throws, WebExtensionStub="NoReturn"]
  undefined notifyFail(DOMString message);

  [Throws, WebExtensionStub="NoReturn"]
  undefined notifyPass(DOMString message);
  [Throws, WebExtensionStub="NoReturn"]
  undefined notifyPass();

  [Throws, WebExtensionStub="NoReturn"]
  undefined log(DOMString message);

  [Throws, WebExtensionStub="NoReturn"]
  undefined sendMessage(any... args);

  [Throws, WebExtensionStub="NoReturn"]
  undefined fail(any message);
  [Throws, WebExtensionStub="NoReturn"]
  undefined fail();

  [Throws, WebExtensionStub="NoReturn"]
  undefined succeed(any message);
  [Throws, WebExtensionStub="NoReturn"]
  undefined succeed();

  [Throws, WebExtensionStub="NoReturn"]
  undefined assertTrue(any... args);

  [Throws, WebExtensionStub="NoReturn"]
  undefined assertFalse(any... args);

  [Throws, WebExtensionStub="NoReturn"]
  undefined assertDeepEq(any... args);

  [Throws, WebExtensionStub="AssertEq"]
  undefined assertEq(any... args);

  [Throws]
  any assertRejects(Promise<any> promise, any expectedError, DOMString message, optional Function callback);
  [Throws]
  any assertRejects(Promise<any> promise, any expectedError, optional Function callback);

  [Throws]
  undefined assertThrows(Function func, any expectedError, DOMString message);
  [Throws]
  undefined assertThrows(Function func, any expectedError);

  // API events.

  [Replaceable, SameObject]
  readonly attribute ExtensionEventManager onMessage;
};
 
/* ---------------------- External ----------------------------- */ 
/* ./webidl/External.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[LegacyNoInterfaceObject, Exposed=Window]
interface External {
  [Deprecated="External_AddSearchProvider"]
  undefined AddSearchProvider();
  undefined IsSearchProviderInstalled();
};
 
/* ---------------------- FailedCertSecurityInfo ----------------------------- */ 
/* ./webidl/FailedCertSecurityInfo.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * This dictionary is used for exposing failed channel certificate information
 * to about:certerror to display information.
 */

enum OverridableErrorCategory {
  "unset",
  "trust-error",
  "domain-mismatch",
  "expired-or-not-yet-valid",
};

dictionary FailedCertSecurityInfo {
  DOMString errorCodeString = "";
  OverridableErrorCategory overridableErrorCategory = "unset";
  DOMTimeStamp validNotBefore = 0;
  DOMTimeStamp validNotAfter = 0;
  DOMString issuerCommonName = "";
  DOMTimeStamp certValidityRangeNotAfter = 0;
  DOMTimeStamp certValidityRangeNotBefore = 0;
  DOMString errorMessage = "";
  boolean hasHSTS = true;
  boolean hasHPKP = true;
  sequence<DOMString> certChainStrings;
};
 
/* ---------------------- FakePluginTagInit ----------------------------- */ 
/* ./webidl/FakePluginTagInit.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * A fake plugin is fundamentally identified by its handlerURI.
 *
 * In addition to that, a fake plugin registration needs to provide at least one
 * FakePluginMimeEntry so we'll know what types(s) the plugin is registered for.
 * Other information is optional, though having usable niceName is highly
 * recommended.
 */
[GenerateInit]
dictionary FakePluginTagInit {
  required DOMString handlerURI;
  required sequence<FakePluginMimeEntry> mimeEntries;

  // The niceName should really be provided, and be unique, if possible; it can
  // be used as a key to persist state for this plug-in.
  DOMString niceName = "";

  // Other things can be provided but don't really matter that much.
  DOMString fullPath = "";
  DOMString name = "";
  DOMString description = "";
  DOMString fileName = "";
  DOMString version = "";

  /**
   * Optional script to run in a sandbox when instantiating a plugin. The script
   * runs in a sandbox with system principal in the process that contains the
   * element that instantiates the plugin (ie the EMBED or OBJECT element). The
   * sandbox global has a 'pluginElement' property that the script can use to
   * access the element that instantiates the plugin.
   */
  DOMString sandboxScript = "";
};

/**
 * A single MIME entry for the fake plugin.
 */
dictionary FakePluginMimeEntry {
  required DOMString type;
  DOMString description = "";
  DOMString extension = "";
};
 
/* ---------------------- FeaturePolicy ----------------------------- */ 
/* ./webidl/FeaturePolicy.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://w3c.github.io/webappsec-feature-policy/#idl-index
 */

[LegacyNoInterfaceObject,
 Exposed=Window]
interface FeaturePolicy {
  boolean allowsFeature(DOMString feature, optional DOMString origin);
  sequence<DOMString> features();
  sequence<DOMString> allowedFeatures();
  sequence<DOMString> getAllowlistForFeature(DOMString feature);
};

[Pref="dom.reporting.featurePolicy.enabled",
 Exposed=Window]
interface FeaturePolicyViolationReportBody : ReportBody {
  readonly attribute DOMString featureId;
  readonly attribute DOMString? sourceFile;
  readonly attribute long? lineNumber;
  readonly attribute long? columnNumber;
  readonly attribute DOMString disposition;
};
 
/* ---------------------- Fetch ----------------------------- */ 
/* ./webidl/Fetch.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://fetch.spec.whatwg.org/
 */

typedef object JSON;
typedef (Blob or BufferSource or FormData or URLSearchParams or USVString) XMLHttpRequestBodyInit;
/* no support for request body streams yet */
typedef XMLHttpRequestBodyInit BodyInit;

interface mixin Body {
  readonly attribute boolean bodyUsed;
  [NewObject]
  Promise<ArrayBuffer> arrayBuffer();
  [NewObject]
  Promise<Blob> blob();
  [NewObject]
  Promise<FormData> formData();
  [NewObject]
  Promise<JSON> json();
  [NewObject]
  Promise<USVString> text();
};

// These are helper dictionaries for the parsing of a
// getReader().read().then(data) parsing.
// See more about how these 2 helpers are used in
// dom/fetch/FetchStreamReader.cpp
[GenerateInit]
dictionary FetchReadableStreamReadDataDone {
  boolean done = false;
};

[GenerateInit]
dictionary FetchReadableStreamReadDataArray {
  Uint8Array value;
};
 
/* ---------------------- FetchEvent ----------------------------- */ 
/* ./webidl/FetchEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html
 */

[Func="ServiceWorkerVisible",
 Exposed=(ServiceWorker)]
interface FetchEvent : ExtendableEvent {
  constructor(DOMString type, FetchEventInit eventInitDict);

  [SameObject, BinaryName="request_"] readonly attribute Request request;
  [Pref="dom.serviceWorkers.navigationPreload.enabled"]
  readonly attribute Promise<any> preloadResponse;
  readonly attribute DOMString clientId;
  readonly attribute DOMString resultingClientId;
  readonly attribute Promise<undefined> handled;

  [Throws]
  undefined respondWith(Promise<Response> r);
};

dictionary FetchEventInit : EventInit {
  required Request request;
  DOMString clientId = "";
  DOMString resultingClientId = "";
};
 
/* ---------------------- FetchObserver ----------------------------- */ 
/* ./webidl/FetchObserver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
callback interface ObserverCallback {
  undefined handleEvent(FetchObserver observer);
};

enum FetchState {
  // Pending states
  "requesting", "responding",
  // Final states
  "aborted", "errored", "complete"
};

[Exposed=(Window,Worker),
 Pref="dom.fetchObserver.enabled"]
interface FetchObserver : EventTarget {
  readonly attribute FetchState state;

  // Events
  attribute EventHandler onstatechange;
  attribute EventHandler onrequestprogress;
  attribute EventHandler onresponseprogress;
};
 
/* ---------------------- File ----------------------------- */ 
/* ./webidl/File.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/FileAPI/#file
 * https://wicg.github.io/entries-api
 */

interface nsIFile;

[Exposed=(Window,Worker)]
interface File : Blob {
  [Throws]
  constructor(sequence<BlobPart> fileBits,
              USVString fileName, optional FilePropertyBag options = {});

  readonly attribute DOMString name;

  [GetterThrows]
  readonly attribute long long lastModified;
};

dictionary FilePropertyBag : BlobPropertyBag {
  long long lastModified;
};

dictionary ChromeFilePropertyBag : FilePropertyBag {
  DOMString name = "";
  boolean existenceCheck = true;
};

// https://wicg.github.io/entries-api
partial interface File {
  [BinaryName="relativePath", Pref="dom.webkitBlink.dirPicker.enabled"]
  readonly attribute USVString webkitRelativePath;
};

// Mozilla extensions
partial interface File {
  [GetterThrows, ChromeOnly, NeedsCallerType]
  readonly attribute DOMString mozFullPath;
};

// Mozilla extensions
// These 2 methods can be used only in these conditions:
// - the main-thread
// - parent process OR file process OR, only for testing, with pref
//   `dom.file.createInChild' set to true.
[Exposed=(Window)]
partial interface File {
  [ChromeOnly, NewObject, NeedsCallerType]
  static Promise<File> createFromNsIFile(nsIFile file,
                                         optional ChromeFilePropertyBag options = {});

  [ChromeOnly, NewObject, NeedsCallerType]
  static Promise<File> createFromFileName(USVString fileName,
                                          optional ChromeFilePropertyBag options = {});
};
 
/* ---------------------- FileList ----------------------------- */ 
/* ./webidl/FileList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2006/webapi/FileAPI/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker)]
interface FileList {
  getter File? item(unsigned long index);
  readonly attribute unsigned long length;
};
 
/* ---------------------- FileMode ----------------------------- */ 
/* ./webidl/FileMode.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

enum FileMode { "readonly", "readwrite" };
 
/* ---------------------- FileReader ----------------------------- */ 
/* ./webidl/FileReader.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/FileAPI/#APIASynch
 *
 * Copyright © 2013 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker)]
interface FileReader : EventTarget {
  constructor();

  // async read methods
  [Throws]
  undefined readAsArrayBuffer(Blob blob);
  [Throws]
  undefined readAsBinaryString(Blob filedata);
  [Throws]
  undefined readAsText(Blob blob, optional DOMString label);
  [Throws]
  undefined readAsDataURL(Blob blob);

  undefined abort();

  // states
  const unsigned short EMPTY = 0;
  const unsigned short LOADING = 1;
  const unsigned short DONE = 2;


  readonly attribute unsigned short readyState;

  readonly attribute (DOMString or ArrayBuffer)? result;

  readonly attribute DOMException? error;

  // event handler attributes
  attribute EventHandler onloadstart;
  attribute EventHandler onprogress;
  attribute EventHandler onload;
  attribute EventHandler onabort;
  attribute EventHandler onerror;
  attribute EventHandler onloadend;
};
 
/* ---------------------- FileReaderSync ----------------------------- */ 
/* ./webidl/FileReaderSync.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2006/webapi/FileAPI/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(DedicatedWorker,SharedWorker)]
interface FileReaderSync {
  constructor();

  // Synchronously return strings

  [Throws]
  ArrayBuffer readAsArrayBuffer(Blob blob);
  [Throws]
  DOMString readAsBinaryString(Blob blob);
  [Throws]
  DOMString readAsText(Blob blob, optional DOMString encoding);
  [Throws]
  DOMString readAsDataURL(Blob blob);
};
 
/* ---------------------- FileSystem ----------------------------- */ 
/* ./webidl/FileSystem.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://wicg.github.io/entries-api/#idl-index
 */

dictionary FileSystemFlags {
    boolean create = false;
    boolean exclusive = false;
};

callback FileSystemEntryCallback = undefined (FileSystemEntry entry);

callback ErrorCallback = undefined (DOMException err);

[Exposed=Window]
interface FileSystem {
    readonly    attribute USVString name;
    readonly    attribute FileSystemDirectoryEntry root;
};
 
/* ---------------------- FileSystemDirectoryEntry ----------------------------- */ 
/* ./webidl/FileSystemDirectoryEntry.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://wicg.github.io/entries-api/#idl-index
 */

[Exposed=Window]
interface FileSystemDirectoryEntry : FileSystemEntry {
    FileSystemDirectoryReader createReader();

    undefined getFile(optional USVString? path,
                      optional FileSystemFlags options = {},
                      optional FileSystemEntryCallback successCallback,
                      optional ErrorCallback errorCallback);

    undefined getDirectory(optional USVString? path,
                           optional FileSystemFlags options = {},
                           optional FileSystemEntryCallback successCallback,
                           optional ErrorCallback errorCallback);
};
 
/* ---------------------- FileSystemDirectoryHandle ----------------------------- */ 
/* ./webidl/FileSystemDirectoryHandle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

dictionary FileSystemGetFileOptions {
  boolean create = false;
};

dictionary FileSystemGetDirectoryOptions {
  boolean create = false;
};

dictionary FileSystemRemoveOptions {
  boolean recursive = false;
};

[Exposed=(Window,Worker), SecureContext, Serializable, Pref="dom.fs.enabled"]
interface FileSystemDirectoryHandle : FileSystemHandle {

  async iterable<USVString, FileSystemHandle>;

  [NewObject]
  Promise<FileSystemFileHandle> getFileHandle(USVString name, optional FileSystemGetFileOptions options = {});

  [NewObject]
  Promise<FileSystemDirectoryHandle> getDirectoryHandle(USVString name, optional FileSystemGetDirectoryOptions options = {});

  [NewObject]
  Promise<undefined> removeEntry(USVString name, optional FileSystemRemoveOptions options = {});

  [NewObject]
  Promise<sequence<USVString>?> resolve(FileSystemHandle possibleDescendant);
};
 
/* ---------------------- FileSystemDirectoryIterator ----------------------------- */ 
/* ./webidl/FileSystemDirectoryIterator.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// To implement FileSystemDirectoryHandle's async iteration until we can use
// a natively supported `async iterable`.
[Exposed=(Window,Worker), SecureContext, LegacyNoInterfaceObject]
interface FileSystemDirectoryIterator {
  [NewObject]
  Promise<any> next();
};
 
/* ---------------------- FileSystemDirectoryReader ----------------------------- */ 
/* ./webidl/FileSystemDirectoryReader.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://wicg.github.io/entries-api/#idl-index
 */

callback FileSystemEntriesCallback = undefined (sequence<FileSystemEntry> entries);

[Exposed=Window]
interface FileSystemDirectoryReader {

    // readEntries can be called just once. The second time it returns no data.

    [Throws]
    undefined readEntries(FileSystemEntriesCallback successCallback,
                          optional ErrorCallback errorCallback);
};
 
/* ---------------------- FileSystemEntry ----------------------------- */ 
/* ./webidl/FileSystemEntry.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://wicg.github.io/entries-api/#idl-index
 */

[Exposed=Window]
interface FileSystemEntry {
    readonly attribute boolean isFile;
    readonly attribute boolean isDirectory;

    [GetterThrows]
    readonly attribute USVString name;

    [GetterThrows]
    readonly attribute USVString fullPath;

    readonly attribute FileSystem filesystem;

    undefined getParent(optional FileSystemEntryCallback successCallback,
                        optional ErrorCallback errorCallback);
};
 
/* ---------------------- FileSystemFileEntry ----------------------------- */ 
/* ./webidl/FileSystemFileEntry.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://wicg.github.io/entries-api/#idl-index
 */

callback FileCallback = undefined (File file);

[Exposed=Window]
interface FileSystemFileEntry : FileSystemEntry {
    [BinaryName="GetFile"]
    undefined file (FileCallback successCallback,
                    optional ErrorCallback errorCallback);
};
 
/* ---------------------- FileSystemFileHandle ----------------------------- */ 
/* ./webidl/FileSystemFileHandle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

dictionary FileSystemCreateWritableOptions {
  boolean keepExistingData = false;
};

[Exposed=(Window,Worker), SecureContext, Serializable, Pref="dom.fs.enabled"]
interface FileSystemFileHandle : FileSystemHandle {
  [NewObject]
  Promise<File> getFile();

  [NewObject]
  Promise<FileSystemWritableFileStream> createWritable(optional FileSystemCreateWritableOptions options = {});

  [Exposed=DedicatedWorker, NewObject]
  Promise<FileSystemSyncAccessHandle> createSyncAccessHandle();
};
 
/* ---------------------- FileSystemHandle ----------------------------- */ 
/* ./webidl/FileSystemHandle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

enum FileSystemHandleKind {
  "file",
  "directory",
};

[Exposed=(Window,Worker), SecureContext, Serializable, Pref="dom.fs.enabled"]
interface FileSystemHandle {
  readonly attribute FileSystemHandleKind kind;
  readonly attribute USVString name;

  /* https://whatpr.org/fs/10.html#api-filesystemhandle */
  [NewObject]
  Promise<undefined> move(USVString name);
  [NewObject]
  Promise<undefined> move(FileSystemDirectoryHandle parent);
  [NewObject]
  Promise<undefined> move(FileSystemDirectoryHandle parent, USVString name);

  [NewObject]
  Promise<boolean> isSameEntry(FileSystemHandle other);
};
 
/* ---------------------- FileSystemSyncAccessHandle ----------------------------- */ 
/* ./webidl/FileSystemSyncAccessHandle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

dictionary FileSystemReadWriteOptions {
  [EnforceRange] unsigned long long at;
};

[Exposed=(DedicatedWorker), SecureContext, Pref="dom.fs.enabled"]
interface FileSystemSyncAccessHandle {
  // TODO: Use `[AllowShared] BufferSource data` once it works (bug 1696216)
  [Throws] unsigned long long read(([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) buffer, optional FileSystemReadWriteOptions options = {});
  [Throws] unsigned long long write(([AllowShared] ArrayBufferView or [AllowShared] ArrayBuffer) buffer, optional FileSystemReadWriteOptions options = {});

  [Throws] undefined truncate([EnforceRange] unsigned long long size);
  [Throws] unsigned long long getSize();
  [Throws] undefined flush();
  undefined close();
};
 
/* ---------------------- FileSystemWritableFileStream ----------------------------- */ 
/* ./webidl/FileSystemWritableFileStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

enum WriteCommandType {
  "write",
  "seek",
  "truncate"
};

[GenerateConversionToJS]
dictionary WriteParams {
  required WriteCommandType type;
  unsigned long long? size;
  unsigned long long? position;
  (BufferSource or Blob or UTF8String)? data;
};

typedef (BufferSource or Blob or UTF8String or WriteParams) FileSystemWriteChunkType;

[Exposed=(Window,Worker), SecureContext, Pref="dom.fs.enabled"]
interface FileSystemWritableFileStream : WritableStream {
  [NewObject, Throws]
  Promise<undefined> write(FileSystemWriteChunkType data);
  [NewObject]
  Promise<undefined> seek(unsigned long long position);
  [NewObject]
  Promise<undefined> truncate(unsigned long long size);
};
 
/* ---------------------- FinalizationRegistry ----------------------------- */ 
/* ./webidl/FinalizationRegistry.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This IDL file contains a callback used to integrate JS FinalizationRegistry
 * objects with the browser.
 */

callback FinalizationRegistryCleanupCallback = undefined();
 
/* ---------------------- FocusEvent ----------------------------- */ 
/* ./webidl/FocusEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface please see
 * http://dev.w3.org/2006/webapi/DOM-Level-3-Events/html/DOM3-Events.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface FocusEvent : UIEvent {
  constructor(DOMString typeArg,
              optional FocusEventInit focusEventInitDict = {});

  // Introduced in DOM Level 3:
  readonly attribute EventTarget?   relatedTarget;
};

dictionary FocusEventInit : UIEventInit {
    EventTarget? relatedTarget = null;
};
 
/* ---------------------- FontFace ----------------------------- */ 
/* ./webidl/FontFace.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css-font-loading/#fontface-interface
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

typedef (ArrayBuffer or ArrayBufferView) BinaryData;

dictionary FontFaceDescriptors {
  UTF8String style = "normal";
  UTF8String weight = "normal";
  UTF8String stretch = "normal";
  UTF8String unicodeRange = "U+0-10FFFF";
  UTF8String variant = "normal";
  UTF8String featureSettings = "normal";
  [Pref="layout.css.font-variations.enabled"] UTF8String variationSettings = "normal";
  UTF8String display = "auto";
  UTF8String ascentOverride = "normal";
  UTF8String descentOverride = "normal";
  UTF8String lineGapOverride = "normal";
  [Pref="layout.css.size-adjust.enabled"] UTF8String sizeAdjust = "100%";
};

enum FontFaceLoadStatus { "unloaded", "loading", "loaded", "error" };

[Exposed=(Window,Worker)]
interface FontFace {
  [Throws]
  constructor(UTF8String family,
              (UTF8String or BinaryData) source,
              optional FontFaceDescriptors descriptors = {});

  [SetterThrows] attribute UTF8String family;
  [SetterThrows] attribute UTF8String style;
  [SetterThrows] attribute UTF8String weight;
  [SetterThrows] attribute UTF8String stretch;
  [SetterThrows] attribute UTF8String unicodeRange;
  [SetterThrows] attribute UTF8String variant;
  [SetterThrows] attribute UTF8String featureSettings;
  [SetterThrows, Pref="layout.css.font-variations.enabled"] attribute UTF8String variationSettings;
  [SetterThrows] attribute UTF8String display;
  [SetterThrows] attribute UTF8String ascentOverride;
  [SetterThrows] attribute UTF8String descentOverride;
  [SetterThrows] attribute UTF8String lineGapOverride;
  [SetterThrows, Pref="layout.css.size-adjust.enabled"] attribute UTF8String sizeAdjust;

  readonly attribute FontFaceLoadStatus status;

  [Throws]
  Promise<FontFace> load();

  [Throws]
  readonly attribute Promise<FontFace> loaded;
};
 
/* ---------------------- FontFaceSet ----------------------------- */ 
/* ./webidl/FontFaceSet.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css-font-loading/#FontFaceSet-interface
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// To implement FontFaceSet's iterator until we can use setlike.
dictionary FontFaceSetIteratorResult
{
  required any value;
  required boolean done;
};

// To implement FontFaceSet's iterator until we can use setlike.
[LegacyNoInterfaceObject,
 Exposed=(Window,Worker)]
interface FontFaceSetIterator {
  [Throws] FontFaceSetIteratorResult next();
};

callback FontFaceSetForEachCallback = undefined (FontFace value, FontFace key, FontFaceSet set);

enum FontFaceSetLoadStatus { "loading", "loaded" };

[Exposed=(Window,Worker)]
interface FontFaceSet : EventTarget {
  // Bug 1072762 is for the FontFaceSet constructor.
  // constructor(sequence<FontFace> initialFaces);

  // Emulate setlike behavior until we can use that directly.
  readonly attribute unsigned long size;
  [Throws] undefined add(FontFace font);
  boolean has(FontFace font);
  boolean delete(FontFace font);
  undefined clear();
  [NewObject] FontFaceSetIterator entries();
  // Iterator keys();
  [NewObject, Alias=keys, Alias="@@iterator"] FontFaceSetIterator values();
  [Throws] undefined forEach(FontFaceSetForEachCallback cb, optional any thisArg);

  // -- events for when loading state changes
  attribute EventHandler onloading;
  attribute EventHandler onloadingdone;
  attribute EventHandler onloadingerror;

  // check and start loads if appropriate
  // and fulfill promise when all loads complete
  [NewObject] Promise<sequence<FontFace>> load(UTF8String font, optional DOMString text = " ");

  // return whether all fonts in the fontlist are loaded
  // (does not initiate load if not available)
  [Throws] boolean check(UTF8String font, optional DOMString text = " ");

  // async notification that font loading and layout operations are done
  [Throws] readonly attribute Promise<undefined> ready;

  // loading state, "loading" while one or more fonts loading, "loaded" otherwise
  readonly attribute FontFaceSetLoadStatus status;
};
 
/* ---------------------- FontFaceSetLoadEvent ----------------------------- */ 
/* ./webidl/FontFaceSetLoadEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css-font-loading/#FontFaceSet-interface
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary FontFaceSetLoadEventInit : EventInit {
  sequence<FontFace> fontfaces = [];
};

[Exposed=(Window,Worker)]
interface FontFaceSetLoadEvent : Event {
  constructor(DOMString type,
              optional FontFaceSetLoadEventInit eventInitDict = {});

  [Cached, Constant, Frozen] readonly attribute sequence<FontFace> fontfaces;
};
 
/* ---------------------- FontFaceSource ----------------------------- */ 
/* ./webidl/FontFaceSource.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/css-font-loading/#font-face-source
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

interface mixin FontFaceSource {
  [Throws]
  readonly attribute FontFaceSet fonts;
};
 
/* ---------------------- FormData ----------------------------- */ 
/* ./webidl/FormData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://xhr.spec.whatwg.org
 */

typedef (Blob or Directory or USVString) FormDataEntryValue;

[Exposed=(Window,Worker)]
interface FormData {
  [Throws]
  constructor(optional HTMLFormElement form, optional HTMLElement? submitter = null);

  [Throws]
  undefined append(USVString name, Blob value, optional USVString filename);
  [Throws]
  undefined append(USVString name, USVString value);
  undefined delete(USVString name);
  FormDataEntryValue? get(USVString name);
  sequence<FormDataEntryValue> getAll(USVString name);
  boolean has(USVString name);
  [Throws]
  undefined set(USVString name, Blob value, optional USVString filename);
  [Throws]
  undefined set(USVString name, USVString value);
  iterable<USVString, FormDataEntryValue>;
};
 
/* ---------------------- FormDataEvent ----------------------------- */ 
/* ./webidl/FormDataEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#the-formdataevent-interface
 */

[Exposed=Window]
interface FormDataEvent : Event {
  constructor(DOMString type, optional FormDataEventInit eventInitDict = {});

  // C++ can't deal with a method called FormData() in the generated code
  [BinaryName="GetFormData"]
  readonly attribute FormData formData;
};

dictionary FormDataEventInit : EventInit {
  required FormData formData;
};
 
/* ---------------------- FragmentDirective ----------------------------- */ 
/* ./webidl/FragmentDirective.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://wicg.github.io/scroll-to-text-fragment/
 */
[Exposed=Window, Pref="dom.text_fragments.enabled"]
interface FragmentDirective {
};
 
/* ---------------------- FrameCrashedEvent ----------------------------- */ 
/* ./webidl/FrameCrashedEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[ChromeOnly,
 Exposed=Window]
interface FrameCrashedEvent : Event
{
  constructor(DOMString type,
              optional FrameCrashedEventInit eventInitDict = {});

  /**
   * The browsingContextId of the frame that crashed.
   */
  readonly attribute unsigned long long browsingContextId;

  /**
   * True if the top-most frame crashed.
   */
  readonly attribute boolean isTopFrame;

  /**
   * Internal process identifier of the frame that crashed. This will be
   * 0 if this identifier is not known, for example a process that failed
   * to start.
   */
  readonly attribute unsigned long long childID;
};

dictionary FrameCrashedEventInit : EventInit
{
  unsigned long long browsingContextId = 0;
  boolean isTopFrame = true;
  unsigned long long childID = 0;
};
 
/* ---------------------- Function ----------------------------- */ 
/* ./webidl/Function.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#functiocn
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */
callback Function = any(any... arguments);

callback VoidFunction = undefined ();
 
/* ---------------------- FuzzingFunctions ----------------------------- */ 
/* ./webidl/FuzzingFunctions.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * Various functions useful for automated fuzzing that are enabled
 * only in --enable-fuzzing builds, because they may be dangerous to
 * enable on untrusted pages.
*/

[Pref="fuzzing.enabled",
 Exposed=Window]
namespace FuzzingFunctions {
  /**
   * Synchronously perform a garbage collection.
   */
  undefined garbageCollect();

  /**
   * Synchronously perform a compacting garbage collection.
   */
  undefined garbageCollectCompacting();

  /**
   * Trigger a forced crash.
   */
  undefined crash(optional DOMString reason = "");

  /**
   * Synchronously perform a cycle collection.
   */
  undefined cycleCollect();

  /**
   * Send a memory pressure event, causes shrinking GC, cycle collection and
   * other actions.
   */
  undefined memoryPressure();

  /**
   * Enable accessibility.
   */
  [Throws]
  undefined enableAccessibility();

  /**
   * Send IPC fuzzing ready event to parent.
   */
  undefined signalIPCReady();

  /**
   * synthesizeKeyboardEvents() synthesizes a set of "keydown",
   * "keypress" (only when it's necessary) and "keyup" events in top DOM window
   * in current process (and the synthesized events will be retargeted to
   * focused window/document/element).  I.e, this is currently not dispatched
   * via the main process if you call this in a content process.  Therefore, in
   * the case, some default action handlers which are only in the main process
   * will never run.  Note that this does not allow to synthesize keyboard
   * events if this is called from a keyboard event or composition event
   * listener.
   *
   * @param aKeyValue          If you want to synthesize non-printable key
   *                           events, you need to set one of key values
   *                           defined by "UI Events KeyboardEvent key Values".
   *                           You can check our current support values in
   *                           dom/events/KeyNameList.h
   *                           If you want to synthesize printable key events,
   *                           you can set any string value including empty
   *                           string.
   *                           Note that |key| value in aDictionary is always
   *                           ignored.
   * @param aDictionary        If you want to synthesize simple key press
   *                           without any modifiers, you can omit this.
   *                           Otherwise, specify this with proper values.
   *                           If |code| is omitted or empty string, this
   *                           guesses proper code value in US-English
   *                           keyboard.  Otherwise, the value must be empty
   *                           string or known code value defined by "UI Events
   *                           KeyboardEvent code Values".  You can check our
   *                           current support values in
   *                           dom/events/PhysicalKeyCodeNameList.h.
   *                           If |keyCode| is omitted or 0, this guesses
   *                           proper keyCode value in US-English keyboard.
   *                           If |location| is omitted or 0, this assumes
   *                           that left modifier key is pressed if aKeyValue
   *                           is one of such modifier keys.
   *                           |key|, |isComposing|, |charCode| and |which|
   *                           are always ignored.
   *                           Modifier states like |shiftKey|, |altKey|,
   *                           |modifierAltGraph|, |modifierCapsLock| and
   *                           |modifierNumLock| are not adjusted for
   *                           aKeyValue.  Please specify them manually if
   *                           necessary.
   *                           Note that this API does not allow to dispatch
   *                           known key events with empty |code| value and
   *                           0 |keyCode| value since it's unsual situation
   *                           especially 0 |keyCode| value with known key.
   *                           Note that when you specify only one of |code|
   *                           and |keyCode| value, the other will be guessed
   *                           from US-English keyboard layout.  So, if you
   *                           want to emulate key press with another keyboard
   *                           layout, you should specify both values.
   *
   * For example:
   *   // Synthesize "Tab" key events.
   *   synthesizeKeyboardEvents("Tab");
   *   // Synthesize Shift + Tab key events.
   *   synthesizeKeyboardEvents("Tab", { shiftKey: true });
   *   // Synthesize Control + A key events.
   *   synthesizeKeyboardEvents("a", { controlKey: true });
   *   // Synthesize Control + Shift + A key events.
   *   synthesizeKeyboardEvents("A", { controlKey: true,
   *                                   shitKey: true });
   *   // Synthesize "Enter" key on numpad.
   *   synthesizeKeyboardEvents("Enter", { code: "NumpadEnter" });
   *   // Synthesize right "Shift" key.
   *   synthesizeKeyboardEvents("Shift", { code: "ShiftRight" });
   *   // Synthesize "1" on numpad.
   *   synthesizeKeyboardEvents("1", { code: "Numpad1",
   *                                   modifierNumLock: true });
   *   // Synthesize "End" on numpad.
   *   synthesizeKeyboardEvents("End", { code: "Numpad1" });
   *   // Synthesize "%" key of US-English keyboard layout.
   *   synthesizeKeyboardEvents("%", { shiftKey: true });
   *   // Synthesize "*" key of Japanese keyboard layout.
   *   synthesizeKeyboardEvents("*", { code: "Quote",
   *                                   shiftKey: true,
   *                                   keyCode: KeyboardEvent.DOM_VK_COLON });
   */
  [Throws]
  undefined synthesizeKeyboardEvents(DOMString aKeyValue,
                                     optional KeyboardEventInit aDictionary = {});
};
 
/* ---------------------- GainNode ----------------------------- */ 
/* ./webidl/GainNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary GainOptions : AudioNodeOptions {
             float gain = 1.0;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface GainNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context, optional GainOptions options = {});

    readonly attribute AudioParam gain;

};

// Mozilla extension
GainNode includes AudioNodePassThrough;
 
/* ---------------------- Gamepad ----------------------------- */ 
/* ./webidl/Gamepad.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/gamepad/
 * https://w3c.github.io/gamepad/extensions.html
 * https://w3c.github.io/webvr/spec/1.1/#interface-gamepad
 */

[Pref="dom.gamepad.enabled",
 Exposed=Window]
interface GamepadButton {
  readonly    attribute boolean pressed;
  readonly    attribute boolean touched;
  readonly    attribute double  value;
};

enum GamepadHand {
  "",
  "left",
  "right"
};

/**
 * https://www.w3.org/TR/gamepad/#gamepadmappingtype-enum
 * https://immersive-web.github.io/webxr-gamepads-module/#enumdef-gamepadmappingtype
 */
enum GamepadMappingType {
  "",
  "standard",
  "xr-standard"
};

[Pref="dom.gamepad.enabled",
 Exposed=Window]
interface Gamepad {
  /**
   * An identifier, unique per type of device.
   */
  readonly attribute DOMString id;

  /**
   * The game port index for the device. Unique per device
   * attached to this system.
   */
  readonly attribute long index;

  /**
   * The mapping in use for this device. The empty string
   * indicates that no mapping is in use.
   */
  readonly attribute GamepadMappingType mapping;

  /**
   * The hand in use for this device. The empty string
   * indicates that unknown, both hands, or not applicable
   */
  [Pref="dom.gamepad.extensions.enabled"]
  readonly attribute GamepadHand hand;

  /**
   * The displayId in use for as an association point in the VRDisplay API
   * to identify which VRDisplay that the gamepad is associated with.
   */
  [Pref="dom.vr.enabled"]
  readonly attribute unsigned long displayId;

  /**
   * true if this gamepad is currently connected to the system.
   */
  readonly attribute boolean connected;

  /**
   * The current state of all buttons on the device, an
   * array of GamepadButton.
   */
  [Pure, Cached, Frozen]
  readonly attribute sequence<GamepadButton> buttons;

  /**
   * The current position of all axes on the device, an
   * array of doubles.
   */
  [Pure, Cached, Frozen]
  readonly attribute sequence<double> axes;

  /**
   * Timestamp from when the data of this device was last updated.
   */
  readonly attribute DOMHighResTimeStamp timestamp;

  /**
   * The current pose of the device, a GamepadPose.
   */
  [Pref="dom.gamepad.extensions.enabled"]
  readonly attribute GamepadPose? pose;

  /**
   * The current haptic actuator of the device, an array of
   * GamepadHapticActuator.
   */
  [Constant, Cached, Frozen, Pref="dom.gamepad.extensions.enabled"]
  readonly attribute sequence<GamepadHapticActuator> hapticActuators;

  [Constant, Cached, Frozen, Pref="dom.gamepad.extensions.enabled", Pref="dom.gamepad.extensions.lightindicator"]
  readonly attribute sequence<GamepadLightIndicator> lightIndicators;

  [Constant, Cached, Frozen, Pref="dom.gamepad.extensions.enabled", Pref="dom.gamepad.extensions.multitouch"]
  readonly attribute sequence<GamepadTouch> touchEvents;
};
 
/* ---------------------- GamepadAxisMoveEvent ----------------------------- */ 
/* ./webidl/GamepadAxisMoveEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Pref="dom.gamepad.non_standard_events.enabled",
 Exposed=Window]
interface GamepadAxisMoveEvent : GamepadEvent
{
  constructor(DOMString type,
              optional GamepadAxisMoveEventInit eventInitDict = {});

  readonly attribute unsigned long axis;
  readonly attribute double value;
};

dictionary GamepadAxisMoveEventInit : GamepadEventInit
{
  unsigned long axis = 0;
  double value = 0;
};
 
/* ---------------------- GamepadButtonEvent ----------------------------- */ 
/* ./webidl/GamepadButtonEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Pref="dom.gamepad.non_standard_events.enabled",
 Exposed=Window]
interface GamepadButtonEvent : GamepadEvent
{
  constructor(DOMString type,
              optional GamepadButtonEventInit eventInitDict = {});

  readonly attribute unsigned long button;
};

dictionary GamepadButtonEventInit : GamepadEventInit
{
  unsigned long button = 0;
};
 
/* ---------------------- GamepadEvent ----------------------------- */ 
/* ./webidl/GamepadEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/gamepad/#gamepadevent-interface
 */

[Pref="dom.gamepad.enabled",
 Exposed=Window]
interface GamepadEvent : Event
{
  constructor(DOMString type, optional GamepadEventInit eventInitDict = {});

  readonly attribute Gamepad? gamepad;
};

dictionary GamepadEventInit : EventInit
{
  Gamepad? gamepad = null;
};
 
/* ---------------------- GamepadHapticActuator ----------------------------- */ 
/* ./webidl/GamepadHapticActuator.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/gamepad/extensions.html#gamepadhapticactuator-interface
 */

enum GamepadHapticActuatorType {
  "vibration"
};

[Pref="dom.gamepad.extensions.enabled",
 HeaderFile="mozilla/dom/GamepadHapticActuator.h",
 Exposed=Window]
interface GamepadHapticActuator
{
  readonly attribute GamepadHapticActuatorType type;
  [Throws, NewObject]
  Promise<boolean> pulse(double value, double duration);
};
 
/* ---------------------- GamepadLightIndicator ----------------------------- */ 
/* ./webidl/GamepadLightIndicator.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://github.com/knyg/gamepad/blob/lightindicator/extensions.html
 */

enum GamepadLightIndicatorType {
  "on-off",
  "rgb"
};

dictionary GamepadLightColor {
  required octet red;
  required octet green;
  required octet blue;
};

[Pref="dom.gamepad.extensions.lightindicator",
 Exposed=Window]
interface GamepadLightIndicator
{
  readonly attribute GamepadLightIndicatorType type;
  [Throws, NewObject]
  Promise<boolean> setColor(GamepadLightColor color);
};
 
/* ---------------------- GamepadPose ----------------------------- */ 
/* ./webidl/GamepadPose.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/gamepad/extensions.html#gamepadpose-interface
 */

[Pref="dom.gamepad.extensions.enabled",
 Exposed=Window]
interface GamepadPose
{
  readonly attribute boolean hasOrientation;
  readonly attribute boolean hasPosition;

  /**
   * position, linearVelocity, and linearAcceleration are 3-component vectors.
   * position is relative to a sitting space. Transforming this point with
   * VRStageParameters.sittingToStandingTransform converts this to standing space.
   */
  [Constant, Throws] readonly attribute Float32Array? position;
  [Constant, Throws] readonly attribute Float32Array? linearVelocity;
  [Constant, Throws] readonly attribute Float32Array? linearAcceleration;

  /* orientation is a 4-entry array representing the components of a quaternion. */
  [Constant, Throws] readonly attribute Float32Array? orientation;
  /* angularVelocity and angularAcceleration are the components of 3-dimensional vectors. */
  [Constant, Throws] readonly attribute Float32Array? angularVelocity;
  [Constant, Throws] readonly attribute Float32Array? angularAcceleration;
};
 
/* ---------------------- GamepadServiceTest ----------------------------- */ 
/* ./webidl/GamepadServiceTest.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

[Pref="dom.gamepad.test.enabled",
 Exposed=Window]
interface GamepadServiceTest
{
  readonly attribute GamepadMappingType noMapping;
  readonly attribute GamepadMappingType standardMapping;
  readonly attribute GamepadHand noHand;
  readonly attribute GamepadHand leftHand;
  readonly attribute GamepadHand rightHand;

  [NewObject]
  Promise<unsigned long> addGamepad(DOMString id,
                                    GamepadMappingType mapping,
                                    GamepadHand hand,
                                    unsigned long numButtons,
                                    unsigned long numAxes,
                                    unsigned long numHaptics,
                                    unsigned long numLightIndicator,
                                    unsigned long numTouchEvents);

  [NewObject]
  Promise<unsigned long> removeGamepad(unsigned long index);

  [NewObject]
  Promise<unsigned long> newButtonEvent(unsigned long index,
                      unsigned long button,
                      boolean pressed,
                      boolean touched);

  [NewObject]
  Promise<unsigned long> newButtonValueEvent(unsigned long index,
                                             unsigned long button,
                                             boolean pressed,
                                             boolean touched,
                                             double value);

  [NewObject]
  Promise<unsigned long> newAxisMoveEvent(unsigned long index,
                        unsigned long axis,
                        double value);
  [NewObject]
  Promise<unsigned long> newPoseMove(unsigned long index,
                   Float32Array? orient,
                   Float32Array? pos,
                   Float32Array? angVelocity,
                   Float32Array? angAcceleration,
                   Float32Array? linVelocity,
                   Float32Array? linAcceleration);

  [NewObject]
  Promise<unsigned long> newTouch(unsigned long index, unsigned long aTouchArrayIndex,
                unsigned long touchId, octet surfaceId,
                Float32Array position, Float32Array? surfaceDimension);
};
 
/* ---------------------- GamepadTouch ----------------------------- */ 
/* ./webidl/GamepadTouch.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://github.com/knyg/gamepad/blob/multitouch/extensions.html
 */

[Pref="dom.gamepad.extensions.multitouch",
 Exposed=Window]
interface GamepadTouch {
  readonly attribute unsigned long touchId;
  readonly attribute octet surfaceId;
  [Constant, Throws] readonly attribute Float32Array position;
  [Constant, Throws] readonly attribute Uint32Array? surfaceDimensions;
};
 
/* ---------------------- GenericTransformStream ----------------------------- */ 
/* ./webidl/GenericTransformStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#other-specs-ts-wrapping
 */

interface mixin GenericTransformStream {
  readonly attribute ReadableStream readable;
  readonly attribute WritableStream writable;
};
 
/* ---------------------- Geolocation ----------------------------- */ 
/* ./webidl/Geolocation.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/geolocation-API
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary PositionOptions {
  boolean enableHighAccuracy = false;
  [Clamp] unsigned long timeout = 0x7fffffff;
  [Clamp] unsigned long maximumAge = 0;
};

[Exposed=Window]
interface Geolocation {
  [Throws, NeedsCallerType]
  undefined getCurrentPosition(PositionCallback successCallback,
                               optional PositionErrorCallback? errorCallback = null,
                               optional PositionOptions options = {});

  [Throws, NeedsCallerType]
  long watchPosition(PositionCallback successCallback,
                     optional PositionErrorCallback? errorCallback = null,
                     optional PositionOptions options = {});

  undefined clearWatch(long watchId);
};

callback PositionCallback = undefined (GeolocationPosition position);

callback PositionErrorCallback = undefined (GeolocationPositionError positionError);
 
/* ---------------------- GeolocationCoordinates ----------------------------- */ 
/* ./webidl/GeolocationCoordinates.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/geolocation-API
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window, SecureContext]
interface GeolocationCoordinates {
  readonly attribute double latitude;
  readonly attribute double longitude;
  readonly attribute double? altitude;
  readonly attribute double accuracy;
  readonly attribute double? altitudeAccuracy;
  readonly attribute double? heading;
  readonly attribute double? speed;
};
 
/* ---------------------- GeolocationPosition ----------------------------- */ 
/* ./webidl/GeolocationPosition.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/geolocation-API
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window, SecureContext]
interface GeolocationPosition {
  readonly attribute GeolocationCoordinates coords;
  readonly attribute EpochTimeStamp timestamp;
};
 
/* ---------------------- GeolocationPositionError ----------------------------- */ 
/* ./webidl/GeolocationPositionError.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/geolocation-API
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface GeolocationPositionError {
  const unsigned short PERMISSION_DENIED = 1;
  const unsigned short POSITION_UNAVAILABLE = 2;
  const unsigned short TIMEOUT = 3;
  readonly attribute unsigned short code;
  readonly attribute DOMString message;
};
 
/* ---------------------- GeometryUtils ----------------------------- */ 
/* ./webidl/GeometryUtils.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/cssom-view/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum CSSBoxType { "margin", "border", "padding", "content" };
dictionary BoxQuadOptions {
  CSSBoxType box = "border";
  GeometryNode relativeTo;
  [ChromeOnly]
  boolean createFramesForSuppressedWhitespace = true;
};

dictionary ConvertCoordinateOptions {
  CSSBoxType fromBox = "border";
  CSSBoxType toBox = "border";
};

interface mixin GeometryUtils {
  [Throws, Func="nsINode::HasBoxQuadsSupport", NeedsCallerType]
  sequence<DOMQuad> getBoxQuads(optional BoxQuadOptions options = {});

  /* getBoxQuadsFromWindowOrigin is similar to getBoxQuads, but the
   * returned quads are further translated relative to the window
   * origin -- which is not the layout origin. Further translation
   * must be done to bring the quads into layout space. Typically,
   * this will be done by performing another call from the top level
   * browser process, requesting the quad of the top level content
   * document itself. The position of this quad can then be used as
   * the offset into layout space, and subtracted from the original
   * returned quads. If options.relativeTo is supplied, this method
   * will throw.
   */
  [ChromeOnly, Throws, Func="nsINode::HasBoxQuadsSupport"]
  sequence<DOMQuad> getBoxQuadsFromWindowOrigin(optional BoxQuadOptions options = {});

  [Throws, Pref="layout.css.convertFromNode.enabled", NeedsCallerType]
  DOMQuad convertQuadFromNode(DOMQuad quad, GeometryNode from, optional ConvertCoordinateOptions options = {});
  [Throws, Pref="layout.css.convertFromNode.enabled", NeedsCallerType]
  DOMQuad convertRectFromNode(DOMRectReadOnly rect, GeometryNode from, optional ConvertCoordinateOptions options = {});
  [Throws, Pref="layout.css.convertFromNode.enabled", NeedsCallerType]
  DOMPoint convertPointFromNode(DOMPointInit point, GeometryNode from, optional ConvertCoordinateOptions options = {});
};

// PseudoElement includes GeometryUtils;

typedef (Text or Element /* or PseudoElement */ or Document) GeometryNode;
 
/* ---------------------- GetUserMediaRequest ----------------------------- */ 
/* ./webidl/GetUserMediaRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This is an internal IDL file
 */

interface nsIMediaDevice;

// For gUM request start (getUserMedia:request) notification,
// rawID, mediaSource and audioOutputOptions won't be set.
// For selectAudioOutput request start (getUserMedia:request) notification,
// rawID, mediaSource and constraints won't be set.
// For gUM request stop (recording-device-stopped) notification due to page
// reload, only windowID will be set.
// For gUM request stop (recording-device-stopped) notification due to track
// stop, only type, windowID, rawID and mediaSource will be set

enum GetUserMediaRequestType {
    "getusermedia",
    "selectaudiooutput",
    "recording-device-stopped"
};

[LegacyNoInterfaceObject,
 Exposed=Window]
interface GetUserMediaRequest {
  readonly attribute GetUserMediaRequestType type;
  readonly attribute unsigned long long windowID;
  readonly attribute unsigned long long innerWindowID;
  readonly attribute DOMString callID;
  readonly attribute DOMString rawID;
  readonly attribute DOMString mediaSource;
  // The set of devices to consider
  [Constant, Cached, Frozen]
  readonly attribute sequence<nsIMediaDevice> devices;
  MediaStreamConstraints getConstraints();
  AudioOutputOptions getAudioOutputOptions();
  readonly attribute boolean isSecure;
  readonly attribute boolean isHandlingUserInput;
};
 
/* ---------------------- Glean ----------------------------- */ 
/* ./webidl/Glean.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanCategory {
  /**
   * Get a metric by name.
   *
   * Returns an object of the corresponding metric type,
   * with only the allowed functions available.
   */
  getter GleanMetric (DOMString identifier);
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanImpl {
  /**
   * Get a metric category by name.
   *
   * Returns an object for further metric lookup.
   */
  getter GleanCategory (DOMString identifier);
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanLabeled {
  /**
   * Get a specific metric for a given label.
   *
   * If a set of acceptable labels were specified in the `metrics.yaml` file,
   * and the given label is not in the set, it will be recorded under the
   * special `OTHER_LABEL` label.
   *
   * If a set of acceptable labels was not specified in the `metrics.yaml` file,
   * only the first 16 unique labels will be used.
   * After that, any additional labels will be recorded under the special
   * `OTHER_LABEL` label.
   */
  getter GleanMetric (DOMString identifier);
};
 
/* ---------------------- GleanMetrics ----------------------------- */ 
/* ./webidl/GleanMetrics.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

// The definitions in this file are not sorted.
// Please add new ones to the bottom.

/**
 * Base interface for all metric types to make typing more expressive.
 */
[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanMetric {};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanBoolean : GleanMetric {
  /**
   * Set to the specified boolean value.
   *
   * @param value the value to set.
   */
  undefined set(boolean value);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as a boolean.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  boolean? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanDatetime : GleanMetric {
  /**
   * Set the datetime to the provided value, or the local now.
   * The internal value will store the local timezone.
   *
   * Note: The metric's time_unit affects the resolution of the value, not the
   *       unit of this function's parameter (which is always PRTime/nanos).
   *
   * @param aValue The (optional) time value as PRTime (nanoseconds since epoch).
   *        Defaults to local now.
   */
  undefined set(optional long long aValue);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as a Date.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric as a JS Date with timezone,
   *         or null if there is no value.
   */
  [Throws, ChromeOnly]
  any testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanCounter : GleanMetric {
  /*
   * Increases the counter by `amount`.
   *
   * @param aAmount The (optional) amount to increase by. Should be positive. Defaults to 1.
   */
  undefined add(optional long aAmount = 1);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as an integer.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  long? testGetValue(optional UTF8String aPingName = "");
};

dictionary GleanDistributionData {
  required unsigned long long sum;
  required unsigned long long count;
  required record<UTF8String, unsigned long long> values;
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanTimingDistribution : GleanMetric {
  /**
   * Starts tracking time for the provided metric.
   *
   * @returns A unique timer id for the new timer
   */
  unsigned long long start();

  /**
   * Stops tracking time for the provided metric and timer id.
   *
   * Adds a count to the corresponding bucket in the timing distribution.
   * This will record an error if no `start` was called for this TimerId or
   * if this TimerId was used to call `cancel`.
   *
   * @param aId The TimerId associated with this timing. This allows for
   *            concurrent timing of events associated with different ids.
   */
  undefined stopAndAccumulate(unsigned long long aId);

  /**
   * Aborts a previous `start` call. No error is recorded if no `start` was
   * called. (But then where did you get that id from?)
   *
   * @param aId The TimerID whose `start` you wish to abort.
   */
  undefined cancel(unsigned long long aId);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  GleanDistributionData? testGetValue(optional UTF8String aPingName = "");

  /**
   * **Test-only API**
   *
   * Accumulates a raw numeric sample of milliseconds.
   *
   * @param aSample The sample, in milliseconds, to add.
   */
  [ChromeOnly]
  undefined testAccumulateRawMillis(unsigned long long aSample);
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanMemoryDistribution : GleanMetric {
  /**
   * Accumulates the provided signed sample in the metric.
   *
   * @param aSample The sample to be recorded by the metric. The sample is
   *                assumed to be in the confgured memory unit of the metric.
   *
   * Notes: Values bigger than 1 Terabyte (2^40 bytes) are truncated and an
   * InvalidValue error is recorded.
   */
  undefined accumulate(unsigned long long aSample);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as a DistributionData.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  GleanDistributionData? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanCustomDistribution : GleanMetric {
  /**
   * Accumulates the provided signed samples in the metric.
   *
   * @param aSamples - The vector holding the samples to be recorded by the metric.
   *
   * Notes: Discards any negative value in `samples`
   * and report an `ErrorType::InvalidValue` for each of them.
   */
  undefined accumulateSamples(sequence<long long> aSamples);

  /**
   * Accumulates the provided single signed sample in the metric.
   *
   * @param aSample - The sample to be recorded by the metric.
   *
   * Notes: Discards any negative value of `sample` and reports an
   * `ErrorType::InvalidValue`.
   */
  undefined accumulateSingleSample(long long aSample);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as a DistributionData.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  GleanDistributionData? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanString : GleanMetric {
  /**
   * Set the string to the provided value.
   *
   * @param aValue The string to set the metric to.
   */
  undefined set(UTF8String? aValue);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as a string.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  UTF8String? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanStringList : GleanMetric {
  /**
   * Adds a new string to the list.
   *
   * Truncates the value and logs an error if it is longer than 100 bytes.
   *
   * @param value The string to add.
   */
  undefined add(UTF8String value);

  /**
   * Sets the string_list to the provided list of strings.
   *
   * Truncates the list and logs an error if longer than 100 items.
   * Truncates any item longer than 100 bytes and logs an error.
   *
   * @param aValue The list of strings to set the metric to.
   */
  undefined set(sequence<UTF8String> aValue);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  sequence<UTF8String>? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanTimespan : GleanMetric {
  /**
   * Start tracking time for the provided metric.
   *
   * This records an error if it’s already tracking time (i.e. start was already
   * called with no corresponding [stop]): in that case the original
   * start time will be preserved.
   */
  undefined start();

  /**
   * Stop tracking time for the provided metric.
   *
   * Sets the metric to the elapsed time, but does not overwrite an already
   * existing value.
   * This will record an error if no [start] was called or there is an already
   * existing value.
   */
  undefined stop();

  /**
   * Aborts a previous start.
   *
   * Does not record an error if there was no previous call to start.
   */
  undefined cancel();

  /**
   * Explicitly sets the timespan value.
   *
   * This API should only be used if you cannot make use of
   * `start`/`stop`/`cancel`.
   *
   * @param aDuration The duration of this timespan, in units matching the
   *        `time_unit` of this metric's definition.
   */
  undefined setRaw(unsigned long aDuration);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  unsigned long long? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanUuid : GleanMetric {
  /**
   * Set to the specified value.
   *
   * @param aValue The UUID to set the metric to.
   */
  undefined set(UTF8String aValue);

  /**
   * Generate a new random UUID and set the metric to it.
   */
  undefined generateAndSet();

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  UTF8String? testGetValue(optional UTF8String aPingName = "");
};

dictionary GleanEventRecord {
  required unsigned long long timestamp;
  required UTF8String category;
  required UTF8String name;
  record<UTF8String, UTF8String> extra;
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanEvent : GleanMetric {

  /*
   * Record an event.
   *
   * @param aExtra An (optional) map of extra values.
   */
  undefined _record(optional record<UTF8String, UTF8String?> aExtra);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   *
   * The difference between event timestamps is in milliseconds
   * See https://mozilla.github.io/glean/book/user/metrics/event.html for further details.
   * Due to limitations of numbers in JavaScript, the timestamp will only be accurate up until 2^53.
   * (This is probably not an issue with the current clock implementation. Probably.)
   */
  [Throws, ChromeOnly]
  sequence<GleanEventRecord>? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanQuantity : GleanMetric {
  /**
   * Set to the specified value.
   *
   * @param aValue The value to set the metric to.
   */
  undefined set(long long aValue);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  long long? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanDenominator : GleanMetric {
  /*
   * Increases the counter by `aAmount`.
   *
   * @param aAmount The (optional) amount to increase by. Should be positive. Defaults to 1.
   */
  undefined add(optional long aAmount = 1);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as an integer.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  long? testGetValue(optional UTF8String aPingName = "");
};

dictionary GleanRateData {
  required long numerator;
  required long denominator;
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanNumerator : GleanMetric {
  /*
   * Increases the numerator by `aAmount`.
   *
   * @param aAmount The (optional) amount to increase by. Should be positive. Defaults to 1.
   */
  undefined addToNumerator(optional long aAmount = 1);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value in the form {numerator: n, denominator: d}
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  GleanRateData? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanRate : GleanMetric {
  /*
   * Increases the numerator by `amount`.
   *
   * @param aAmount The (optional) amount to increase by. Should be positive. Defaults to 1.
   */
  undefined addToNumerator(optional long aAmount = 1);

  /*
   * Increases the denominator by `amount`.
   *
   * @param aAmount The (optional) amount to increase by. Should be positive. Defaults to 1.
   */
  undefined addToDenominator(optional long aAmount = 1);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value in the form {numerator: n, denominator: d}
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  GleanRateData? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanUrl : GleanMetric {
  /**
   * Set to the specified value.
   *
   * @param aValue The stringified URL to set the metric to.
   */
  undefined set(UTF8String aValue);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  UTF8String? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanText : GleanMetric {
  /**
   * Set to the provided value.
   *
   * @param aValue The text to set the metric to.
   */
  undefined set(UTF8String aValue);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as a string.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or null if there is no value.
   */
  [Throws, ChromeOnly]
  UTF8String? testGetValue(optional UTF8String aPingName = "");
};

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanObject : GleanMetric {
  /**
   * Set to the specified object.
   *
   * The structure of the metric is validated against the predefined structure.
   *
   * @param object The object to set the metric to.
   */
  undefined set(object value);

  /**
   * **Test-only API**
   *
   * Gets the currently stored value as an object.
   *
   * This function will attempt to await the last parent-process task (if any)
   * writing to the the metric's storage engine before returning a value.
   * This function will not wait for data from child processes.
   *
   * This doesn't clear the stored value.
   * Parent process only. Panics in child processes.
   *
   * @param aPingName The (optional) name of the ping to retrieve the metric
   *        for. Defaults to the first value in `send_in_pings`.
   *
   * @return value of the stored metric, or undefined if there is no value.
   */
  [Throws, ChromeOnly]
  object? testGetValue(optional UTF8String aPingName = "");
};
 
/* ---------------------- GleanPings ----------------------------- */ 
/* ./webidl/GleanPings.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

interface nsIGleanPing;

[Func="nsGlobalWindowInner::IsGleanNeeded", Exposed=Window]
interface GleanPingsImpl {
  /**
   * Get a ping by name.
   */
  getter nsIGleanPing (DOMString identifier);
};
 
/* ---------------------- GPUUncapturedErrorEvent ----------------------------- */ 
/* ./webidl/GPUUncapturedErrorEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://gpuweb.github.io/gpuweb/
 */

dictionary GPUUncapturedErrorEventInit : EventInit {
    required GPUError error;
};

[Func="mozilla::webgpu::Instance::PrefEnabled",
 Exposed=(Window, DedicatedWorker), SecureContext]
interface GPUUncapturedErrorEvent: Event {
    constructor(DOMString type, GPUUncapturedErrorEventInit gpuUncapturedErrorEventInitDict);
    readonly attribute GPUError error;
};
 
/* ---------------------- HashChangeEvent ----------------------------- */ 
/* ./webidl/HashChangeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/#the-hashchangeevent-interface
 */

[LegacyEventInit,
 Exposed=Window]
interface HashChangeEvent : Event
{
  constructor(DOMString type, optional HashChangeEventInit eventInitDict = {});

  readonly attribute DOMString oldURL;
  readonly attribute DOMString newURL;

  undefined initHashChangeEvent(DOMString typeArg,
                                optional boolean canBubbleArg = false,
                                optional boolean cancelableArg = false,
                                optional DOMString oldURLArg = "",
                                optional DOMString newURLArg = "");
};

dictionary HashChangeEventInit : EventInit
{
  DOMString oldURL = "";
  DOMString newURL = "";
};
 
/* ---------------------- Headers ----------------------------- */ 
/* ./webidl/Headers.webidl */ 
 
/* -*- Mode: IDL; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://fetch.spec.whatwg.org/#headers-class
 */

typedef (sequence<sequence<ByteString>> or record<ByteString, ByteString>) HeadersInit;

enum HeadersGuardEnum {
  "none",
  "request",
  "request-no-cors",
  "response",
  "immutable"
};

[Exposed=(Window,Worker)]
interface Headers {
  [Throws]
  constructor(optional HeadersInit init);

  [Throws] undefined append(ByteString name, ByteString value);
  [Throws] undefined delete(ByteString name);
  [Throws] ByteString? get(ByteString name);
  sequence<ByteString> getSetCookie();
  [Throws] boolean has(ByteString name);
  [Throws] undefined set(ByteString name, ByteString value);
  iterable<ByteString, ByteString>;

  // Used to test different guard states from mochitest.
  // Note: Must be set prior to populating headers or will throw.
  [ChromeOnly, SetterThrows] attribute HeadersGuardEnum guard;
};
 
/* ---------------------- Highlight ----------------------------- */ 
/* ./webidl/Highlight.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/css-highlight-api-1/
 *
 * Copyright © 2021 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

/**
 * Enum defining the available highlight types.
 * See https://drafts.csswg.org/css-highlight-api-1/#enumdef-highlighttype
 */
enum HighlightType {
  "highlight",
  "spelling-error",
  "grammar-error"
};

/**
 * Definition of a highlight object, consisting of a set of ranges,
 * a priority and a highlight type.
 *
 * See https://drafts.csswg.org/css-highlight-api-1/#highlight
 */
[Pref="dom.customHighlightAPI.enabled", Exposed=Window]
interface Highlight {

  [Throws]
  constructor(AbstractRange... initialRanges);
  setlike<AbstractRange>;
  attribute long priority;
  attribute HighlightType type;
};

partial interface Highlight {
  // Setlike methods need to be overridden.
  // Iterating a setlike is not possible from C++ yet.
  // Therefore a separate data structure must be held and kept in sync.
  [Throws]
  undefined add(AbstractRange range);
  [Throws]
  undefined clear();
  [Throws]
  boolean delete(AbstractRange range);
};

/**
 * Registry object that contains all Highlights associated with a Document.
 *
 * See https://drafts.csswg.org/css-highlight-api-1/#highlightregistry
 */
[Pref="dom.customHighlightAPI.enabled", Exposed=Window]
interface HighlightRegistry {
  maplike<DOMString, Highlight>;
};

partial interface HighlightRegistry {
  // Maplike interface methods need to be overridden.
  // Iterating a maplike is not possible from C++ yet.
  // Therefore, a separate data structure must be held and kept in sync.
  [Throws]
  undefined set(DOMString key, Highlight value);
  [Throws]
  undefined clear();
  [Throws]
  boolean delete(DOMString key);
};
 
/* ---------------------- History ----------------------------- */ 
/* ./webidl/History.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-history-interface
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

enum ScrollRestoration { "auto", "manual" };

[Exposed=Window]
interface History {
  [Throws]
  readonly attribute unsigned long length;
  [Throws]
  attribute ScrollRestoration scrollRestoration;
  [Throws]
  readonly attribute any state;
  [Throws, NeedsSubjectPrincipal]
  undefined go(optional long delta = 0);
  [Throws, NeedsCallerType]
  undefined back();
  [Throws, NeedsCallerType]
  undefined forward();
  [Throws, NeedsCallerType]
  undefined pushState(any data, DOMString title, optional DOMString? url = null);
  [Throws, NeedsCallerType]
  undefined replaceState(any data, DOMString title, optional DOMString? url = null);
};
 
/* ---------------------- HTMLAllCollection ----------------------------- */ 
/* ./webidl/HTMLAllCollection.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Emulates undefined through Codegen.py. */
[LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface HTMLAllCollection {
  readonly attribute unsigned long length;
  getter Element (unsigned long index);
  getter (HTMLCollection or Element)? namedItem(DOMString name);
  (HTMLCollection or Element)? item(optional DOMString nameOrIndex);
  legacycaller (HTMLCollection or Element)? (optional DOMString nameOrIndex);
};
 
/* ---------------------- HTMLAnchorElement ----------------------------- */ 
/* ./webidl/HTMLAnchorElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-a-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-a-element
[Exposed=Window]
interface HTMLAnchorElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute DOMString target;
           [CEReactions, SetterThrows]
           attribute DOMString download;
           [CEReactions, SetterThrows]
           attribute DOMString ping;
           [CEReactions, SetterThrows]
           attribute DOMString rel;
           [CEReactions, SetterThrows]
           attribute DOMString referrerPolicy;
           [PutForwards=value]
  readonly attribute DOMTokenList relList;
           [CEReactions, SetterThrows]
           attribute DOMString hreflang;
           [CEReactions, SetterThrows]
           attribute DOMString type;

           [CEReactions, Throws]
           attribute DOMString text;
};

HTMLAnchorElement includes HTMLHyperlinkElementUtils;

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLAnchorElement {
           [CEReactions, SetterThrows]
           attribute DOMString coords;
           [CEReactions, SetterThrows]
           attribute DOMString charset;
           [CEReactions, SetterThrows]
           attribute DOMString name;
           [CEReactions, SetterThrows]
           attribute DOMString rev;
           [CEReactions, SetterThrows]
           attribute DOMString shape;
};
 
/* ---------------------- HTMLAreaElement ----------------------------- */ 
/* ./webidl/HTMLAreaElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-area-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 &
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-area-element
[Exposed=Window]
interface HTMLAreaElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute DOMString alt;
           [CEReactions, SetterThrows]
           attribute DOMString coords;
           [CEReactions, SetterThrows]
           attribute DOMString shape;
           [CEReactions, SetterThrows]
           attribute DOMString target;
           [CEReactions, SetterThrows]
           attribute DOMString download;
           [CEReactions, SetterThrows]
           attribute DOMString ping;
           [CEReactions, SetterThrows]
           attribute DOMString rel;
           [CEReactions, SetterThrows]
           attribute DOMString referrerPolicy;
           [PutForwards=value]
  readonly attribute DOMTokenList relList;
};

HTMLAreaElement includes HTMLHyperlinkElementUtils;

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLAreaElement {
           [CEReactions, SetterThrows]
           attribute boolean noHref;
};
 
/* ---------------------- HTMLAudioElement ----------------------------- */ 
/* ./webidl/HTMLAudioElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-audio-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[LegacyFactoryFunction=Audio(optional DOMString src),
 Exposed=Window]
interface HTMLAudioElement : HTMLMediaElement {
  [HTMLConstructor] constructor();
};
 
/* ---------------------- HTMLBaseElement ----------------------------- */ 
/* ./webidl/HTMLBaseElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-base-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-base-element
[Exposed=Window]
interface HTMLBaseElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows, Pure]
           attribute DOMString href;
           [CEReactions, SetterThrows, Pure]
           attribute DOMString target;
};
 
/* ---------------------- HTMLBodyElement ----------------------------- */ 
/* ./webidl/HTMLBodyElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLBodyElement : HTMLElement {
  [HTMLConstructor] constructor();

};

partial interface HTMLBodyElement {
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString text;
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString link;
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString vLink;
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString aLink;
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString bgColor;
  [CEReactions, SetterThrows]
  attribute DOMString background;
};

HTMLBodyElement includes WindowEventHandlers;
 
/* ---------------------- HTMLBRElement ----------------------------- */ 
/* ./webidl/HTMLBRElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-br-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-br-element
[Exposed=Window]
interface HTMLBRElement : HTMLElement {
  [HTMLConstructor] constructor();
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLBRElement {
             [CEReactions, SetterThrows]
             attribute DOMString clear;
};

// Mozilla extensions

partial interface HTMLBRElement {
  // Set to true if the <br> element is created by editor for placing caret
  // at proper position in empty editor.
  [ChromeOnly]
  readonly attribute boolean isPaddingForEmptyEditor;
  // Set to true if the <br> element is created by editor for placing caret
  // at proper position making last empty line in a block element in HTML
  // editor or <textarea> element visible.
  [ChromeOnly]
  readonly attribute boolean isPaddingForEmptyLastLine;
};
 
/* ---------------------- HTMLButtonElement ----------------------------- */ 
/* ./webidl/HTMLButtonElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-button-element
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-button-element
[Exposed=Window,
 InstrumentedProps=(popoverTargetAction,popoverTargetElement)]
interface HTMLButtonElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
           attribute boolean disabled;
  [Pure]
  readonly attribute HTMLFormElement? form;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString formAction;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString formEnctype;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString formMethod;
  [CEReactions, SetterThrows, Pure]
           attribute boolean formNoValidate;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString formTarget;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString name;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString type;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString value;

  readonly attribute boolean willValidate;
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  boolean checkValidity();
  boolean reportValidity();
  undefined setCustomValidity(DOMString error);

  readonly attribute NodeList labels;
};

HTMLButtonElement includes PopoverInvokerElement;

HTMLButtonElement includes InvokerElement;
 
/* ---------------------- HTMLCanvasElement ----------------------------- */ 
/* ./webidl/HTMLCanvasElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-canvas-element
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

interface nsISupports;

typedef (HTMLCanvasElement or OffscreenCanvas) CanvasSource;

[Exposed=Window]
interface HTMLCanvasElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, Pure, SetterThrows]
           attribute unsigned long width;
  [CEReactions, Pure, SetterThrows]
           attribute unsigned long height;

  [Throws]
  nsISupports? getContext(DOMString contextId, optional any contextOptions = null);

  [Throws, NeedsSubjectPrincipal]
  DOMString toDataURL(optional DOMString type = "",
                      optional any encoderOptions);
  [Throws, NeedsSubjectPrincipal]
  undefined toBlob(BlobCallback callback,
                   optional DOMString type = "",
                   optional any encoderOptions);
};

// Mozilla specific bits
partial interface HTMLCanvasElement {
  [Pure, SetterThrows]
           attribute boolean mozOpaque;

           attribute PrintCallback? mozPrintCallback;

  [Throws, NeedsSubjectPrincipal]
  CanvasCaptureMediaStream captureStream(optional double frameRate);
};

// For OffscreenCanvas
// Reference: https://wiki.whatwg.org/wiki/OffscreenCanvas
partial interface HTMLCanvasElement {
  [Pref="gfx.offscreencanvas.enabled", Throws]
  OffscreenCanvas transferControlToOffscreen();
};

[ChromeOnly,
 Exposed=Window]
interface MozCanvasPrintState
{
  // A canvas rendering context.
  readonly attribute nsISupports context;

  // To be called when rendering to the context is done.
  undefined done();
};

callback PrintCallback = undefined(MozCanvasPrintState ctx);

callback BlobCallback = undefined(Blob? blob);
 
/* ---------------------- HTMLCollection ----------------------------- */ 
/* ./webidl/HTMLCollection.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface HTMLCollection {
  readonly attribute unsigned long length;
  getter Element? item(unsigned long index);
  getter Element? namedItem(DOMString name);
};
 
/* ---------------------- HTMLDataElement ----------------------------- */ 
/* ./webidl/HTMLDataElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/text-level-semantics.html#the-data-element
 */

[Exposed=Window]
interface HTMLDataElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute DOMString value;
};
 
/* ---------------------- HTMLDataListElement ----------------------------- */ 
/* ./webidl/HTMLDataListElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLDataListElement : HTMLElement {
  [HTMLConstructor] constructor();

  readonly attribute HTMLCollection options;
};
 
/* ---------------------- HTMLDetailsElement ----------------------------- */ 
/* ./webidl/HTMLDetailsElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/forms.html#the-details-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLDetailsElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows]
  attribute boolean open;
};
 
/* ---------------------- HTMLDialogElement ----------------------------- */ 
/* ./webidl/HTMLDialogElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/forms.html#the-dialog-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLDialogElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows]
  attribute boolean open;
  attribute DOMString returnValue;
  [CEReactions, Throws, UseCounter]
  undefined show();
  [CEReactions, Throws]
  undefined showModal();
  [CEReactions]
  undefined close(optional DOMString returnValue);
};
 
/* ---------------------- HTMLDirectoryElement ----------------------------- */ 
/* ./webidl/HTMLDirectoryElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
[Exposed=Window]
interface HTMLDirectoryElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows, Pure]
           attribute boolean compact;
};
 
/* ---------------------- HTMLDivElement ----------------------------- */ 
/* ./webidl/HTMLDivElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window, ProbablyShortLivingWrapper]
interface HTMLDivElement : HTMLElement {
  [HTMLConstructor] constructor();
};

partial interface HTMLDivElement {
  [CEReactions, SetterThrows]
           attribute DOMString align;
};
 
/* ---------------------- HTMLDListElement ----------------------------- */ 
/* ./webidl/HTMLDListElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-dl-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-dl-element
[Exposed=Window]
interface HTMLDListElement : HTMLElement {
  [HTMLConstructor] constructor();

};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLDListElement {
           [CEReactions, SetterThrows]
           attribute boolean compact;
};
 
/* ---------------------- HTMLDocument ----------------------------- */ 
/* ./webidl/HTMLDocument.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[LegacyOverrideBuiltIns,
 Exposed=Window]
interface HTMLDocument : Document {
  // DOM tree accessors
  [Throws]
  getter object (DOMString name);
};
 
/* ---------------------- HTMLElement ----------------------------- */ 
/* ./webidl/HTMLElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/ and
 * http://dev.w3.org/csswg/cssom-view/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window,
 InstrumentedProps=(attributeStyleMap,hidePopover,popover,showPopover,togglePopover)]
interface HTMLElement : Element {
  [HTMLConstructor] constructor();

  // metadata attributes
  [CEReactions]
           attribute DOMString title;
  [CEReactions]
           attribute DOMString lang;
  [CEReactions, SetterThrows, Pure]
           attribute boolean translate;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString dir;

  [CEReactions, GetterThrows, Pure]
           attribute [LegacyNullToEmptyString] DOMString innerText;
  [CEReactions, GetterThrows, SetterThrows, Pure]
           attribute [LegacyNullToEmptyString] DOMString outerText;

  // user interaction
  [CEReactions, SetterThrows, Pure]
           attribute boolean hidden;
  [CEReactions, SetterThrows, Pure]
           attribute boolean inert;
  [NeedsCallerType]
  undefined click();
  [CEReactions, SetterThrows, Pure]
           attribute DOMString accessKey;
  [Pure]
  readonly attribute DOMString accessKeyLabel;
  [CEReactions, SetterThrows, Pure]
           attribute boolean draggable;
  //[PutForwards=value] readonly attribute DOMTokenList dropzone;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString contentEditable;
  [Pure]
  readonly attribute boolean isContentEditable;
  [CEReactions, SetterThrows, Pure, Pref="dom.element.popover.enabled"]
           attribute DOMString? popover;
  [CEReactions, SetterThrows, Pure]
           attribute boolean spellcheck;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString inputMode;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString enterKeyHint;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString autocapitalize;

  attribute DOMString nonce;

  // command API
  //readonly attribute DOMString? commandType;
  //readonly attribute DOMString? commandLabel;
  //readonly attribute DOMString? commandIcon;
  //readonly attribute boolean? commandHidden;
  //readonly attribute boolean? commandDisabled;
  //readonly attribute boolean? commandChecked;

  // https://html.spec.whatwg.org/multipage/custom-elements.html#dom-attachinternals
  [Throws]
  ElementInternals attachInternals();

  [Throws, Pref="dom.element.popover.enabled"]
  undefined showPopover();
  [Throws, Pref="dom.element.popover.enabled"]
  undefined hidePopover();
  [Throws, Pref="dom.element.popover.enabled"]
  boolean togglePopover(optional boolean force);
};

// http://dev.w3.org/csswg/cssom-view/#extensions-to-the-htmlelement-interface
partial interface HTMLElement {
  // CSSOM things are not [Pure] because they can flush
  readonly attribute Element? offsetParent;
  readonly attribute long offsetTop;
  readonly attribute long offsetLeft;
  readonly attribute long offsetWidth;
  readonly attribute long offsetHeight;
};

partial interface HTMLElement {
  [ChromeOnly]
  readonly attribute ElementInternals? internals;

  [ChromeOnly]
  readonly attribute boolean isFormAssociatedCustomElements;
};

interface mixin TouchEventHandlers {
  [Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
           attribute EventHandler ontouchstart;
  [Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
           attribute EventHandler ontouchend;
  [Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
           attribute EventHandler ontouchmove;
  [Func="nsGenericHTMLElement::LegacyTouchAPIEnabled"]
           attribute EventHandler ontouchcancel;
};

HTMLElement includes GlobalEventHandlers;
HTMLElement includes HTMLOrForeignElement;
HTMLElement includes ElementCSSInlineStyle;
HTMLElement includes TouchEventHandlers;
HTMLElement includes OnErrorEventHandlerForNodes;

[Exposed=Window]
interface HTMLUnknownElement : HTMLElement {};
 
/* ---------------------- HTMLEmbedElement ----------------------------- */ 
/* ./webidl/HTMLEmbedElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-embed-element
 * http://www.whatwg.org/specs/web-apps/current-work/#HTMLEmbedElement-partial
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-embed-element
[Exposed=Window]
interface HTMLEmbedElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, Pure, SetterThrows]
           attribute DOMString src;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString type;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString width;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString height;
};

// http://www.whatwg.org/specs/web-apps/current-work/#HTMLEmbedElement-partial
partial interface HTMLEmbedElement {
  [CEReactions, Pure, SetterThrows]
           attribute DOMString align;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString name;
};

partial interface HTMLEmbedElement {
  // GetSVGDocument
  [NeedsSubjectPrincipal]
  Document? getSVGDocument();
};

HTMLEmbedElement includes MozFrameLoaderOwner;
HTMLEmbedElement includes MozObjectLoadingContent;
 
/* ---------------------- HTMLFieldSetElement ----------------------------- */ 
/* ./webidl/HTMLFieldSetElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-fieldset-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLFieldSetElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows]
           attribute boolean disabled;
  readonly attribute HTMLFormElement? form;
  [CEReactions, SetterThrows]
           attribute DOMString name;

  readonly attribute DOMString type;

  readonly attribute HTMLCollection elements;

  readonly attribute boolean willValidate;
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;

  boolean checkValidity();
  boolean reportValidity();

  undefined setCustomValidity(DOMString error);
};
 
/* ---------------------- HTMLFontElement ----------------------------- */ 
/* ./webidl/HTMLFontElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLFontElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows] attribute [LegacyNullToEmptyString] DOMString color;
  [CEReactions, SetterThrows]                          attribute DOMString face;
  [CEReactions, SetterThrows]                          attribute DOMString size;
};
 
/* ---------------------- HTMLFormControlsCollection ----------------------------- */ 
/* ./webidl/HTMLFormControlsCollection.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#htmlformcontrolscollection
 *
 * © Copyright 2004-2013 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLFormControlsCollection : HTMLCollection {
  // inherits length and item()
  /* legacycaller */ getter (RadioNodeList or Element)? namedItem(DOMString name); // shadows inherited namedItem()
};
 
/* ---------------------- HTMLFormElement ----------------------------- */ 
/* ./webidl/HTMLFormElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#htmlformelement
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[LegacyOverrideBuiltIns, LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface HTMLFormElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, Pure, SetterThrows]
           attribute DOMString acceptCharset;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString action;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString autocomplete;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString enctype;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString encoding;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString method;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString name;
           [CEReactions, Pure, SetterThrows]
           attribute boolean noValidate;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString target;
           [CEReactions, Pure, SetterThrows]
           attribute DOMString rel;
           [PutForwards=value]
           readonly attribute DOMTokenList relList;

  [SameObject]
  readonly attribute HTMLFormControlsCollection elements;
  [Pure]
  readonly attribute long length;

  getter Element (unsigned long index);
  // TODO this should be: getter (RadioNodeList or HTMLInputElement or HTMLImageElement) (DOMString name);
  getter nsISupports (DOMString name);

  [Throws]
  undefined submit();
  [Throws]
  undefined requestSubmit(optional HTMLElement? submitter = null);
  [CEReactions]
  undefined reset();
  boolean checkValidity();
  boolean reportValidity();
};
 
/* ---------------------- HTMLFrameElement ----------------------------- */ 
/* ./webidl/HTMLFrameElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#htmlframeelement
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#htmlframeelement
[Exposed=Window]
interface HTMLFrameElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute DOMString name;
           [CEReactions, SetterThrows]
           attribute DOMString scrolling;
           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString src;
           [CEReactions, SetterThrows]
           attribute DOMString frameBorder;
           [CEReactions, SetterThrows]
           attribute DOMString longDesc;
           [CEReactions, SetterThrows]
           attribute boolean noResize;
  [NeedsSubjectPrincipal]
  readonly attribute Document? contentDocument;
  readonly attribute WindowProxy? contentWindow;

  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString marginHeight;
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString marginWidth;
};

HTMLFrameElement includes MozFrameLoaderOwner;
 
/* ---------------------- HTMLFrameSetElement ----------------------------- */ 
/* ./webidl/HTMLFrameSetElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLFrameSetElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows]
  attribute DOMString cols;
  [CEReactions, SetterThrows]
  attribute DOMString rows;
};

HTMLFrameSetElement includes WindowEventHandlers;
 
/* ---------------------- HTMLHeadElement ----------------------------- */ 
/* ./webidl/HTMLHeadElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-head-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-head-element
[Exposed=Window]
interface HTMLHeadElement : HTMLElement {
  [HTMLConstructor] constructor();
};
 
/* ---------------------- HTMLHeadingElement ----------------------------- */ 
/* ./webidl/HTMLHeadingElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-h1,-h2,-h3,-h4,-h5,-and-h6-elements
[Exposed=Window]
interface HTMLHeadingElement : HTMLElement {
  [HTMLConstructor] constructor();

};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLHeadingElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
};
 
/* ---------------------- HTMLHRElement ----------------------------- */ 
/* ./webidl/HTMLHRElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-hr-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-hr-element
[Exposed=Window]
interface HTMLHRElement : HTMLElement {
  [HTMLConstructor] constructor();

};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLHRElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute DOMString color;
           [CEReactions, SetterThrows]
           attribute boolean noShade;
           [CEReactions, SetterThrows]
           attribute DOMString size;
           [CEReactions, SetterThrows]
           attribute DOMString width;
};
 
/* ---------------------- HTMLHtmlElement ----------------------------- */ 
/* ./webidl/HTMLHtmlElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-html-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-html-element
[Exposed=Window]
interface HTMLHtmlElement : HTMLElement {
  [HTMLConstructor] constructor();
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLHtmlElement {
           [CEReactions, SetterThrows, Pure]
           attribute DOMString version;
};
 
/* ---------------------- HTMLHyperlinkElementUtils ----------------------------- */ 
/* ./webidl/HTMLHyperlinkElementUtils.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/semantics.html#htmlhyperlinkelementutils
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

interface mixin HTMLHyperlinkElementUtils {
  [CEReactions, SetterThrows]
  stringifier attribute USVString href;

  readonly attribute USVString origin;
  [CEReactions]
           attribute USVString protocol;
  [CEReactions]
           attribute USVString username;
  [CEReactions]
           attribute USVString password;
  [CEReactions]
           attribute USVString host;
  [CEReactions]
           attribute USVString hostname;
  [CEReactions]
           attribute USVString port;
  [CEReactions]
           attribute USVString pathname;
  [CEReactions]
           attribute USVString search;
  [CEReactions]
           attribute USVString hash;
};
 
/* ---------------------- HTMLIFrameElement ----------------------------- */ 
/* ./webidl/HTMLIFrameElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-iframe-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * https://wicg.github.io/feature-policy/#policy
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLIFrameElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows, Pure]
           attribute DOMString src;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString srcdoc;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString name;
  [PutForwards=value] readonly attribute DOMTokenList sandbox;
           // attribute boolean seamless;
  [CEReactions, SetterThrows, Pure]
           attribute boolean allowFullscreen;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString width;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString height;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString referrerPolicy;
  [CEReactions, SetterThrows, Pure, Pref="dom.iframe-lazy-loading.enabled"]
           attribute DOMString loading;
  [NeedsSubjectPrincipal]
  readonly attribute Document? contentDocument;
  readonly attribute WindowProxy? contentWindow;
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLIFrameElement {
  [CEReactions, SetterThrows, Pure]
           attribute DOMString align;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString scrolling;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString frameBorder;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString longDesc;

  [CEReactions, SetterThrows, Pure]
           attribute [LegacyNullToEmptyString] DOMString marginHeight;
  [CEReactions, SetterThrows, Pure]
           attribute [LegacyNullToEmptyString] DOMString marginWidth;
};

partial interface HTMLIFrameElement {
  // GetSVGDocument
  [NeedsSubjectPrincipal]
  Document? getSVGDocument();
};

HTMLIFrameElement includes MozFrameLoaderOwner;

// https://w3c.github.io/webappsec-feature-policy/#idl-index
partial interface HTMLIFrameElement {
  [SameObject, Pref="dom.security.featurePolicy.webidl.enabled"]
  readonly attribute FeaturePolicy featurePolicy;

  [CEReactions, SetterThrows, Pure]
           attribute DOMString allow;
};
 
/* ---------------------- HTMLImageElement ----------------------------- */ 
/* ./webidl/HTMLImageElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#htmlimageelement
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

interface imgINotificationObserver;
interface imgIRequest;
interface URI;
interface nsIStreamListener;

[LegacyFactoryFunction=Image(optional unsigned long width, optional unsigned long height),
 Exposed=Window]
interface HTMLImageElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute DOMString alt;
           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString src;
           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString srcset;
           [CEReactions, SetterThrows]
           attribute DOMString? crossOrigin;
           [CEReactions, SetterThrows]
           attribute DOMString useMap;
           [CEReactions, SetterThrows]
           attribute DOMString referrerPolicy;
           [CEReactions, SetterThrows]
           attribute boolean isMap;
           [CEReactions, SetterThrows]
           attribute unsigned long width;
           [CEReactions, SetterThrows]
           attribute unsigned long height;
           [CEReactions, SetterThrows]
           attribute DOMString decoding;
           [CEReactions, SetterThrows]
           attribute DOMString loading;
           [Pref="network.fetchpriority.enabled", CEReactions]
           attribute DOMString fetchPriority;
  readonly attribute unsigned long naturalWidth;
  readonly attribute unsigned long naturalHeight;
  readonly attribute boolean complete;
           [NewObject]
           Promise<undefined> decode();
           [NewObject, ChromeOnly]
           Promise<sequence<ImageText>> recognizeCurrentImageText();
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLImageElement {
           [CEReactions, SetterThrows]
           attribute DOMString name;
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute unsigned long hspace;
           [CEReactions, SetterThrows]
           attribute unsigned long vspace;
           [CEReactions, SetterThrows]
           attribute DOMString longDesc;

  [CEReactions, SetterThrows] attribute [LegacyNullToEmptyString] DOMString border;
};

// [Update me: not in whatwg spec yet]
// http://picture.responsiveimages.org/#the-img-element
partial interface HTMLImageElement {
           [CEReactions, SetterThrows]
           attribute DOMString sizes;
  readonly attribute DOMString currentSrc;
};

// Mozilla extensions.
partial interface HTMLImageElement {
           [CEReactions, SetterThrows]
           attribute DOMString lowsrc;

  // These attributes are offsets from the closest view (to mimic
  // NS4's "offset-from-layer" behavior).
  readonly attribute long x;
  readonly attribute long y;
};

interface mixin MozImageLoadingContent {
  // Mirrored chrome-only nsIImageLoadingContent methods.  Please make sure
  // to update this list if nsIImageLoadingContent changes.
  [ChromeOnly]
  const long UNKNOWN_REQUEST = -1;
  [ChromeOnly]
  const long CURRENT_REQUEST = 0;
  [ChromeOnly]
  const long PENDING_REQUEST = 1;

  [ChromeOnly]
  attribute boolean loadingEnabled;
  /**
   * Same as addNativeObserver but intended for scripted observers or observers
   * from another or without a document.
   */
  [ChromeOnly]
  undefined addObserver(imgINotificationObserver aObserver);
  /**
   * Same as removeNativeObserver but intended for scripted observers or
   * observers from another or without a document.
   */
  [ChromeOnly]
  undefined removeObserver(imgINotificationObserver aObserver);
  [ChromeOnly,Throws]
  imgIRequest? getRequest(long aRequestType);
  [ChromeOnly,Throws]
  long getRequestType(imgIRequest aRequest);
  [ChromeOnly]
  readonly attribute URI? currentURI;
  // Gets the final URI of the current request, if available.
  // Otherwise, returns null.
  [ChromeOnly]
  readonly attribute URI? currentRequestFinalURI;
  /**
   * forceReload forces reloading of the image pointed to by currentURI
   *
   * @param aNotify request should notify
   * @throws NS_ERROR_NOT_AVAILABLE if there is no current URI to reload
   */
  [ChromeOnly,Throws]
  undefined forceReload(optional boolean aNotify = true);
};

HTMLImageElement includes MozImageLoadingContent;
 
/* ---------------------- HTMLInputElement ----------------------------- */ 
/* ./webidl/HTMLInputElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-input-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * https://wicg.github.io/entries-api/#idl-index
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

enum SelectionMode {
  "select",
  "start",
  "end",
  "preserve",
};

interface XULControllers;

[Exposed=Window,
 InstrumentedProps=(capture,
                    incremental,
                    onsearch,
                    popoverTargetAction,
                    popoverTargetElement,
                    webkitEntries,
                    webkitdirectory)]
interface HTMLInputElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, Pure, SetterThrows]
           attribute DOMString accept;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString alt;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString autocomplete;
  [CEReactions, Pure, SetterThrows, Pref="dom.capture.enabled"]
           attribute DOMString capture;
  [CEReactions, Pure, SetterThrows]
           attribute boolean defaultChecked;
  [Pure]
           attribute boolean checked;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString dirName;
  [CEReactions, Pure, SetterThrows]
           attribute boolean disabled;
  readonly attribute HTMLFormElement? form;
  [Pure]
           attribute FileList? files;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString formAction;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString formEnctype;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString formMethod;
  [CEReactions, Pure, SetterThrows]
           attribute boolean formNoValidate;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString formTarget;
  [CEReactions, Pure, SetterThrows]
           attribute unsigned long height;
  [Pure]
           attribute boolean indeterminate;
  [Pure]
  readonly attribute HTMLDataListElement? list;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString max;
  [CEReactions, Pure, SetterThrows]
           attribute long maxLength;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString min;
  [CEReactions, Pure, SetterThrows]
           attribute long minLength;
  [CEReactions, Pure, SetterThrows]
           attribute boolean multiple;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString name;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString pattern;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString placeholder;
  [CEReactions, Pure, SetterThrows]
           attribute boolean readOnly;
  [CEReactions, Pure, SetterThrows]
           attribute boolean required;
  [CEReactions, Pure, SetterThrows]
           attribute unsigned long size;
  [CEReactions, Pure, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString src;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString step;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString type;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString defaultValue;
  [CEReactions, Pure, SetterThrows, NeedsCallerType]
           attribute [LegacyNullToEmptyString] DOMString value;
  [Throws]
           attribute object? valueAsDate;
  [Pure, SetterThrows]
           attribute unrestricted double valueAsNumber;
  [CEReactions, SetterThrows]
           attribute unsigned long width;

  [Throws]
  undefined stepUp(optional long n = 1);
  [Throws]
  undefined stepDown(optional long n = 1);

  [Pure]
  readonly attribute boolean willValidate;
  [Pure]
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  boolean checkValidity();
  boolean reportValidity();
  undefined setCustomValidity(DOMString error);

  readonly attribute NodeList? labels;

  undefined select();

  [Throws]
           attribute unsigned long? selectionStart;
  [Throws]
           attribute unsigned long? selectionEnd;
  [Throws]
           attribute DOMString? selectionDirection;
  [Throws]
  undefined setRangeText(DOMString replacement);
  [Throws]
  undefined setRangeText(DOMString replacement, unsigned long start,
    unsigned long end, optional SelectionMode selectionMode = "preserve");
  [Throws]
  undefined setSelectionRange(unsigned long start, unsigned long end, optional DOMString direction);

  [Throws]
  undefined showPicker();

  // also has obsolete members
};

partial interface HTMLInputElement {
  [CEReactions, Pure, SetterThrows]
           attribute DOMString align;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString useMap;
};

// Mozilla extensions

partial interface HTMLInputElement {
  [GetterThrows, ChromeOnly]
  readonly attribute XULControllers?       controllers;
  // Binaryname because we have a FragmentOrElement function named "TextLength()".
  [NeedsCallerType, BinaryName="inputTextLength"]
  readonly attribute long                  textLength;

  [Throws, ChromeOnly]
  sequence<DOMString> mozGetFileNameArray();

  [ChromeOnly, Throws]
  undefined mozSetFileNameArray(sequence<DOMString> fileNames);

  [ChromeOnly]
  undefined mozSetFileArray(sequence<File> files);

  // This method is meant to use for testing only.
  [ChromeOnly, Throws]
  undefined mozSetDirectory(DOMString directoryPath);

  // This method is meant to use for testing only.
  [ChromeOnly]
  undefined mozSetDndFilesAndDirectories(sequence<(File or Directory)> list);

  // This method is meant to use for testing only.
  [ChromeOnly, NewObject]
  Promise<sequence<(File or Directory)>> getFilesAndDirectories();

  boolean mozIsTextField(boolean aExcludePassword);

  [ChromeOnly]
  readonly attribute boolean hasBeenTypePassword;

  [ChromeOnly]
  attribute DOMString previewValue;

  // Last value entered by the user, not by a script.
  // NOTE(emilio): As of right now some execCommand triggered changes might be
  // considered interactive.
  [ChromeOnly]
  readonly attribute DOMString lastInteractiveValue;

  [ChromeOnly]
  // This function will return null if @autocomplete is not defined for the
  // current @type
  AutocompleteInfo? getAutocompleteInfo();

  [ChromeOnly]
  // The reveal password state for a type=password control.
  attribute boolean revealPassword;
};

interface mixin MozEditableElement {
  // Returns an nsIEditor instance which is associated with the element.
  // If the element can be associated with an editor but not yet created,
  // this creates new one automatically.
  [Pure, ChromeOnly, BinaryName="editorForBindings"]
  readonly attribute nsIEditor? editor;

  // Returns true if an nsIEditor instance has already been associated with
  // the element.
  [Pure, ChromeOnly]
  readonly attribute boolean hasEditor;

  // This is set to true if "input" event should be fired with InputEvent on
  // the element.  Otherwise, i.e., if "input" event should be fired with
  // Event, set to false.
  [ChromeOnly]
  readonly attribute boolean isInputEventTarget;

  // This is similar to set .value on nsIDOMInput/TextAreaElements, but handling
  // of the value change is closer to the normal user input, so 'change' event
  // for example will be dispatched when focusing out the element.
  [Func="IsChromeOrUAWidget", NeedsSubjectPrincipal]
  undefined setUserInput(DOMString input);
};

HTMLInputElement includes MozEditableElement;

HTMLInputElement includes MozImageLoadingContent;

HTMLInputElement includes PopoverInvokerElement;

HTMLInputElement includes InvokerElement;

// https://wicg.github.io/entries-api/#idl-index
partial interface HTMLInputElement {
  [Pref="dom.webkitBlink.filesystem.enabled", Frozen, Cached, Pure]
  readonly attribute sequence<FileSystemEntry> webkitEntries;

  [Pref="dom.webkitBlink.dirPicker.enabled", BinaryName="WebkitDirectoryAttr", SetterThrows]
          attribute boolean webkitdirectory;
};

dictionary DateTimeValue {
  long hour;
  long minute;
  long year;
  long month;
  long day;
};

partial interface HTMLInputElement {
  [ChromeOnly]
  DateTimeValue getDateTimeInputBoxValue();

  [ChromeOnly]
  readonly attribute Element? dateTimeBoxElement;

  [ChromeOnly, BinaryName="getMinimumAsDouble"]
  double getMinimum();

  [ChromeOnly, BinaryName="getMaximumAsDouble"]
  double getMaximum();

  [Func="IsChromeOrUAWidget"]
  undefined openDateTimePicker(optional DateTimeValue initialValue = {});

  [Func="IsChromeOrUAWidget"]
  undefined updateDateTimePicker(optional DateTimeValue value = {});

  [Func="IsChromeOrUAWidget"]
  undefined closeDateTimePicker();

  [Func="IsChromeOrUAWidget"]
  undefined setFocusState(boolean aIsFocused);

  [Func="IsChromeOrUAWidget"]
  undefined updateValidityState();

  [Func="IsChromeOrUAWidget", BinaryName="getStepAsDouble"]
  double getStep();

  [Func="IsChromeOrUAWidget", BinaryName="getStepBaseAsDouble"]
  double getStepBase();
};
 
/* ---------------------- HTMLLabelElement ----------------------------- */ 
/* ./webidl/HTMLLabelElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLLabelElement : HTMLElement {
  [HTMLConstructor] constructor();

  readonly attribute HTMLFormElement? form;
  [CEReactions]
           attribute DOMString htmlFor;
  readonly attribute HTMLElement? control;
};
 
/* ---------------------- HTMLLegendElement ----------------------------- */ 
/* ./webidl/HTMLLegendElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-legend-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-legend-element
[Exposed=Window]
interface HTMLLegendElement : HTMLElement {
  [HTMLConstructor] constructor();

  readonly attribute HTMLFormElement? form;
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLLegendElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
};
 
/* ---------------------- HTMLLIElement ----------------------------- */ 
/* ./webidl/HTMLLIElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-li-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-li-element
[Exposed=Window]
interface HTMLLIElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows, Pure]
           attribute long value;
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLLIElement {
           [CEReactions, SetterThrows, Pure]
           attribute DOMString type;
};
 
/* ---------------------- HTMLLinkElement ----------------------------- */ 
/* ./webidl/HTMLLinkElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-link-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// https://html.spec.whatwg.org/multipage/semantics.html#the-link-element
[Exposed=Window]
interface HTMLLinkElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
           attribute boolean disabled;
  [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows, Pure]
           attribute DOMString href;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString? crossOrigin;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString rel;
  [PutForwards=value]
  readonly attribute DOMTokenList relList;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString media;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString hreflang;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString type;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString referrerPolicy;
  [PutForwards=value] readonly attribute DOMTokenList sizes;
  [CEReactions, SetterThrows, Pure]
           attribute USVString imageSrcset;
  [CEReactions, SetterThrows, Pure]
           attribute USVString imageSizes;
  [Pref="dom.element.blocking.enabled", SameObject, PutForwards=value]
           readonly attribute DOMTokenList blocking;
  [Pref="network.fetchpriority.enabled", CEReactions]
           attribute DOMString fetchPriority;
};
HTMLLinkElement includes LinkStyle;

// https://html.spec.whatwg.org/multipage/obsolete.html#other-elements%2C-attributes-and-apis
partial interface HTMLLinkElement {
  [CEReactions, SetterThrows, Pure]
           attribute DOMString charset;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString rev;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString target;
};

// https://html.spec.whatwg.org/multipage/semantics.html#the-link-element
partial interface HTMLLinkElement {
  [CEReactions, SetterThrows]
  attribute DOMString integrity;
};

// https://html.spec.whatwg.org/multipage/links.html#link-type-preload
partial interface HTMLLinkElement {
  [SetterThrows, Pure]
           attribute DOMString as;
};
 
/* ---------------------- HTMLMapElement ----------------------------- */ 
/* ./webidl/HTMLMapElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-map-element
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-map-element
[Exposed=Window]
interface HTMLMapElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
           attribute DOMString name;
  [Constant]
  readonly attribute HTMLCollection areas;
  // Not supported yet.
  //readonly attribute HTMLCollection images;
};
 
/* ---------------------- HTMLMarqueeElement ----------------------------- */ 
/* ./webidl/HTMLMarqueeElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/obsolete.html#the-marquee-element
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// https://html.spec.whatwg.org/multipage/obsolete.html#the-marquee-element

[Exposed=Window]
interface HTMLMarqueeElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows] attribute DOMString behavior;
  [CEReactions, SetterThrows] attribute DOMString bgColor;
  [CEReactions, SetterThrows] attribute DOMString direction;
  [CEReactions, SetterThrows] attribute DOMString height;
  [CEReactions, SetterThrows] attribute unsigned long hspace;
  [CEReactions, SetterThrows] attribute long loop;
  [CEReactions, SetterThrows] attribute unsigned long scrollAmount;
  [CEReactions, SetterThrows] attribute unsigned long scrollDelay;
  [CEReactions, SetterThrows] attribute boolean trueSpeed;
  [CEReactions, SetterThrows] attribute unsigned long vspace;
  [CEReactions, SetterThrows] attribute DOMString width;

  attribute EventHandler onbounce;
  attribute EventHandler onfinish;
  attribute EventHandler onstart;

  undefined start();
  undefined stop();
};
 
/* ---------------------- HTMLMediaElement ----------------------------- */ 
/* ./webidl/HTMLMediaElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#media-elements
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window,
 InstrumentedProps=(disableRemotePlayback,remote)]
interface HTMLMediaElement : HTMLElement {

  // error state
  readonly attribute MediaError? error;

  // network state
  [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString src;
  readonly attribute DOMString currentSrc;

  [CEReactions, SetterThrows]
           attribute DOMString? crossOrigin;
  const unsigned short NETWORK_EMPTY = 0;
  const unsigned short NETWORK_IDLE = 1;
  const unsigned short NETWORK_LOADING = 2;
  const unsigned short NETWORK_NO_SOURCE = 3;
  readonly attribute unsigned short networkState;
  [CEReactions, SetterThrows]
           attribute DOMString preload;
  [NewObject]
  readonly attribute TimeRanges buffered;
  undefined load();
  DOMString canPlayType(DOMString type);

  // ready state
  const unsigned short HAVE_NOTHING = 0;
  const unsigned short HAVE_METADATA = 1;
  const unsigned short HAVE_CURRENT_DATA = 2;
  const unsigned short HAVE_FUTURE_DATA = 3;
  const unsigned short HAVE_ENOUGH_DATA = 4;
  readonly attribute unsigned short readyState;
  readonly attribute boolean seeking;

  // playback state
  [SetterThrows]
           attribute double currentTime;
  [Throws]
  undefined fastSeek(double time);
  readonly attribute unrestricted double duration;
  [ChromeOnly]
  readonly attribute boolean isEncrypted;
  // TODO: Bug 847376 - readonly attribute any startDate;
  readonly attribute boolean paused;
  [SetterThrows]
           attribute double defaultPlaybackRate;
  [SetterThrows]
           attribute double playbackRate;
  [NewObject]
  readonly attribute TimeRanges played;
  [NewObject]
  readonly attribute TimeRanges seekable;
  readonly attribute boolean ended;
  [CEReactions, SetterThrows]
           attribute boolean autoplay;
  [CEReactions, SetterThrows]
           attribute boolean loop;
  [NewObject]
  Promise<undefined> play();
  [Throws]
  undefined pause();

  // TODO: Bug 847377 - mediaGroup and MediaController
  // media controller
  //         attribute DOMString mediaGroup;
  //         attribute MediaController? controller;

  // controls
  [CEReactions, SetterThrows]
           attribute boolean controls;
  [SetterThrows]
           attribute double volume;
           attribute boolean muted;
  [CEReactions, SetterThrows]
           attribute boolean defaultMuted;

  // TODO: Bug 847379
  // tracks
  [Pref="media.track.enabled"]
  readonly attribute AudioTrackList audioTracks;
  [Pref="media.track.enabled"]
  readonly attribute VideoTrackList videoTracks;
  readonly attribute TextTrackList? textTracks;
  TextTrack addTextTrack(TextTrackKind kind,
                         optional DOMString label = "",
                         optional DOMString language = "");
};

// Mozilla extensions:
partial interface HTMLMediaElement {
  [Func="HasDebuggerOrTabsPrivilege"]
  readonly attribute MediaSource? mozMediaSourceObject;

  [Func="HasDebuggerOrTabsPrivilege", NewObject]
  Promise<HTMLMediaElementDebugInfo> mozRequestDebugInfo();

  [Func="HasDebuggerOrTabsPrivilege", NewObject]
  static undefined mozEnableDebugLog();
  [Func="HasDebuggerOrTabsPrivilege", NewObject]
  Promise<DOMString> mozRequestDebugLog();

  attribute MediaStream? srcObject;

  attribute boolean preservesPitch;

  // NB: for internal use with the video controls:
  [Func="IsChromeOrUAWidget"] attribute boolean mozAllowCasting;
  [Func="IsChromeOrUAWidget"] attribute boolean mozIsCasting;

  // Mozilla extension: stream capture
  [Throws]
  MediaStream mozCaptureStream();
  [Throws]
  MediaStream mozCaptureStreamUntilEnded();
  readonly attribute boolean mozAudioCaptured;

  // Mozilla extension: return embedded metadata from the stream as a
  // JSObject with key:value pairs for each tag. This can be used by
  // player interfaces to display the song title, artist, etc.
  [Throws]
  object? mozGetMetadata();

  // Mozilla extension: provides access to the fragment end time if
  // the media element has a fragment URI for the currentSrc, otherwise
  // it is equal to the media duration.
  readonly attribute double mozFragmentEnd;
};

// Encrypted Media Extensions
partial interface HTMLMediaElement {
  readonly attribute MediaKeys? mediaKeys;

  // undefined, not any: https://www.w3.org/Bugs/Public/show_bug.cgi?id=26457
  [NewObject]
  Promise<undefined> setMediaKeys(MediaKeys? mediaKeys);

  attribute EventHandler onencrypted;

  attribute EventHandler onwaitingforkey;
};

/**
 * These attributes are general testing attributes and they should only be used
 * in tests.
 */
partial interface HTMLMediaElement {
  [Pref="media.useAudioChannelService.testing"]
  readonly attribute double computedVolume;

  [Pref="media.useAudioChannelService.testing"]
  readonly attribute boolean computedMuted;

  // Return true if the media is suspended because its document is inactive or
  // the docshell is inactive and explicitly being set to prohibit all media
  // from playing.
  [ChromeOnly]
  readonly attribute boolean isSuspendedByInactiveDocOrDocShell;
};

/*
 * HTMLMediaElement::seekToNextFrame() is a Mozilla experimental feature.
 *
 * The SeekToNextFrame() method provides a way to access a video element's video
 * frames one by one without going through the realtime playback. So, it lets
 * authors use "frame" as unit to access the video element's underlying data,
 * instead of "time".
 *
 * The SeekToNextFrame() is a kind of seek operation, so normally, once it is
 * invoked, a "seeking" event is dispatched. However, if the media source has no
 * video data or is not seekable, the operation is ignored without filing the
 * "seeking" event.
 *
 * Once the SeekToNextFrame() is done, a "seeked" event should always be filed
 * and a "ended" event might also be filed depends on where the media element's
 * position before seeking was. There are two cases:
 * Assume the media source has n+1 video frames where n is a non-negative
 * integers and the frame sequence is indexed from zero.
 * (1) If the currentTime is at anywhere smaller than the n-th frame's beginning
 *     time, say the currentTime is now pointing to a position which is smaller
 *     than the x-th frame's beginning time and larger or equal to the (x-1)-th
 *     frame's beginning time, where x belongs to [1, n], then the
 *     SeekToNextFrame() operation seeks the media to the x-th frame, sets the
 *     media's currentTime to the x-th frame's beginning time and dispatches a
 *     "seeked" event.
 * (2) Otherwise, if the currentTime is larger or equal to the n-th frame's
 *     beginning time, then the SeekToNextFrame() operation sets the media's
 *     currentTime to the duration of the media source and dispatches a "seeked"
 *     event and an "ended" event.
 */
partial interface HTMLMediaElement {
  [NewObject, Pref="media.seekToNextFrame.enabled"]
  Promise<undefined> seekToNextFrame();
};

/* Internal testing only API */
partial interface HTMLMediaElement {
  // These APIs are used to simulate visibility changes to help debug and write
  // tests about suspend-video-decoding.
  // - SetVisible() is for simulating visibility changes.
  // - HasSuspendTaint() is for querying that the element's decoder cannot suspend
  //   video decoding because it has been tainted by an operation, such as
  //   drawImage().
  // - isInViewPort is a boolean value which indicate whether media element is
  //   in view port.
  // - isVideoDecodingSuspended() is used to know whether video decoding has
  //   suspended.
  [Pref="media.test.video-suspend"]
  undefined setVisible(boolean aVisible);

  [Pref="media.test.video-suspend"]
  boolean hasSuspendTaint();

  [ChromeOnly]
  readonly attribute boolean isInViewPort;

  [ChromeOnly]
  readonly attribute boolean isVideoDecodingSuspended;

  [ChromeOnly]
  readonly attribute double totalVideoPlayTime;

  [ChromeOnly]
  readonly attribute double totalVideoHDRPlayTime;

  [ChromeOnly]
  readonly attribute double visiblePlayTime;

  [ChromeOnly]
  readonly attribute double invisiblePlayTime;

  [ChromeOnly]
  readonly attribute double videoDecodeSuspendedTime;

  [ChromeOnly]
  readonly attribute double totalAudioPlayTime;

  [ChromeOnly]
  readonly attribute double audiblePlayTime;

  [ChromeOnly]
  readonly attribute double inaudiblePlayTime;

  [ChromeOnly]
  readonly attribute double mutedPlayTime;

  // These APIs are used for decoder doctor tests.
  [ChromeOnly]
  undefined setFormatDiagnosticsReportForMimeType(DOMString mimeType, DecoderDoctorReportType error);

  [Throws, ChromeOnly]
  undefined setDecodeError(DOMString error);

  [ChromeOnly]
  undefined setAudioSinkFailedStartup();
};

/* Audio Output Devices API
 * https://w3c.github.io/mediacapture-output/
 */
partial interface HTMLMediaElement {
  [SecureContext, Pref="media.setsinkid.enabled"]
  readonly attribute DOMString sinkId;
  [NewObject, SecureContext, Pref="media.setsinkid.enabled"]
  Promise<undefined> setSinkId(DOMString sinkId);
};

/*
 * API that exposes whether a call to HTMLMediaElement.play() would be
 * blocked by autoplay policies; whether the promise returned by play()
 * would be rejected with NotAllowedError.
 */
partial interface HTMLMediaElement {
  [Pref="media.allowed-to-play.enabled"]
  readonly attribute boolean allowedToPlay;
};
 
/* ---------------------- HTMLMenuElement ----------------------------- */ 
/* ./webidl/HTMLMenuElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/grouping-content.html#the-menu-element
 * https://html.spec.whatwg.org/multipage/obsolete.html#HTMLMenuElement-partial
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// https://html.spec.whatwg.org/multipage/grouping-content.html#the-menu-element
[Exposed=Window]
interface HTMLMenuElement : HTMLElement {
  [HTMLConstructor] constructor();
};

// https://html.spec.whatwg.org/multipage/obsolete.html#HTMLMenuElement-partial
partial interface HTMLMenuElement {
           [CEReactions, SetterThrows]
           attribute boolean compact;
};
 
/* ---------------------- HTMLMetaElement ----------------------------- */ 
/* ./webidl/HTMLMetaElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-meta-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// https://html.spec.whatwg.org/#the-meta-element
[Exposed=Window]
interface HTMLMetaElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
           attribute DOMString name;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString httpEquiv;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString content;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString media;
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLMetaElement {
  [CEReactions, SetterThrows, Pure]
           attribute DOMString scheme;
};
 
/* ---------------------- HTMLMeterElement ----------------------------- */ 
/* ./webidl/HTMLMeterElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-meter-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-meter-element
[Exposed=Window]
interface HTMLMeterElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute double value;
           [CEReactions, SetterThrows]
           attribute double min;
           [CEReactions, SetterThrows]
           attribute double max;
           [CEReactions, SetterThrows]
           attribute double low;
           [CEReactions, SetterThrows]
           attribute double high;
           [CEReactions, SetterThrows]
           attribute double optimum;
           readonly attribute NodeList labels;
};
 
/* ---------------------- HTMLModElement ----------------------------- */ 
/* ./webidl/HTMLModElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#attributes-common-to-ins-and-del-elements
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#attributes-common-to-ins-and-del-elements
[Exposed=Window]
interface HTMLModElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
           attribute DOMString cite;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString dateTime;
};
 
/* ---------------------- HTMLObjectElement ----------------------------- */ 
/* ./webidl/HTMLObjectElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-object-element
 * http://www.whatwg.org/specs/web-apps/current-work/#HTMLObjectElement-partial
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-object-element
[Exposed=Window]
interface HTMLObjectElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, Pure, SetterThrows]
           attribute DOMString data;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString type;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString name;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString useMap;
  [Pure]
  readonly attribute HTMLFormElement? form;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString width;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString height;
  // Not pure: can trigger about:blank instantiation
  [NeedsSubjectPrincipal]
  readonly attribute Document? contentDocument;
  // Not pure: can trigger about:blank instantiation
  [NeedsSubjectPrincipal]
  readonly attribute WindowProxy? contentWindow;

  readonly attribute boolean willValidate;
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  boolean checkValidity();
  boolean reportValidity();
  undefined setCustomValidity(DOMString error);
};

// http://www.whatwg.org/specs/web-apps/current-work/#HTMLObjectElement-partial
partial interface HTMLObjectElement {
  [CEReactions, Pure, SetterThrows]
           attribute DOMString align;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString archive;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString code;
  [CEReactions, Pure, SetterThrows]
           attribute boolean declare;
  [CEReactions, Pure, SetterThrows]
           attribute unsigned long hspace;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString standby;
  [CEReactions, Pure, SetterThrows]
           attribute unsigned long vspace;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString codeBase;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString codeType;

  [CEReactions, Pure, SetterThrows]
           attribute [LegacyNullToEmptyString] DOMString border;
};

partial interface HTMLObjectElement {
  // GetSVGDocument
  [NeedsSubjectPrincipal]
  Document? getSVGDocument();
};

interface mixin MozObjectLoadingContent {
  // Mirrored chrome-only scriptable nsIObjectLoadingContent methods.  Please
  // make sure to update this list if nsIObjectLoadingContent changes.  Also,
  // make sure everything on here is [ChromeOnly].
  [ChromeOnly]
  const unsigned long TYPE_LOADING     = 0;
  [ChromeOnly]
  const unsigned long TYPE_DOCUMENT    = 1;
  [ChromeOnly]
  const unsigned long TYPE_FALLBACK    = 2;

  /**
   * The actual mime type (the one we got back from the network
   * request) for the element.
   */
  [ChromeOnly]
  readonly attribute DOMString actualType;

  /**
   * Gets the type of the content that's currently loaded. See
   * the constants above for the list of possible values.
   */
  [ChromeOnly]
  readonly attribute unsigned long displayedType;

  /**
   * The URL of the data/src loaded in the object. This may be null (i.e.
   * an <embed> with no src).
   */
  [ChromeOnly]
  readonly attribute URI? srcURI;
};

HTMLObjectElement includes MozFrameLoaderOwner;
HTMLObjectElement includes MozObjectLoadingContent;
 
/* ---------------------- HTMLOListElement ----------------------------- */ 
/* ./webidl/HTMLOListElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-ol-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-ol-element
[Exposed=Window]
interface HTMLOListElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute boolean reversed;
           [CEReactions, SetterThrows]
           attribute long start;
           [CEReactions, SetterThrows]
           attribute DOMString type;
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLOListElement {
           [CEReactions, SetterThrows]
           attribute boolean compact;
};
 
/* ---------------------- HTMLOptGroupElement ----------------------------- */ 
/* ./webidl/HTMLOptGroupElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-optgroup-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLOptGroupElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute boolean disabled;
           [CEReactions, SetterThrows]
           attribute DOMString label;
};
 
/* ---------------------- HTMLOptionElement ----------------------------- */ 
/* ./webidl/HTMLOptionElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-option-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[LegacyFactoryFunction=Option(optional DOMString text = "", optional DOMString value, optional boolean defaultSelected = false, optional boolean selected = false),
 Exposed=Window]
interface HTMLOptionElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows]
  attribute boolean disabled;
  readonly attribute HTMLFormElement? form;
  [CEReactions, SetterThrows]
  attribute DOMString label;
  [CEReactions, SetterThrows]
  attribute boolean defaultSelected;
  attribute boolean selected;
  [CEReactions, SetterThrows]
  attribute DOMString value;

  [CEReactions, SetterThrows]
  attribute DOMString text;
  readonly attribute long index;
};
 
/* ---------------------- HTMLOptionsCollection ----------------------------- */ 
/* ./webidl/HTMLOptionsCollection.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-html5-20120329/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface HTMLOptionsCollection : HTMLCollection {
  [CEReactions, SetterThrows]
  attribute unsigned long length;
  [CEReactions, Throws]
  setter undefined (unsigned long index, HTMLOptionElement? option);
  [CEReactions, Throws]
  undefined add((HTMLOptionElement or HTMLOptGroupElement) element, optional (HTMLElement or long)? before = null);
  [CEReactions]
  undefined remove(long index);
  attribute long selectedIndex;
};
 
/* ---------------------- HTMLOutputElement ----------------------------- */ 
/* ./webidl/HTMLOutputElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-output-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-output-element
[Exposed=Window]
interface HTMLOutputElement : HTMLElement {
  [HTMLConstructor] constructor();

  [PutForwards=value, Constant]
  readonly attribute DOMTokenList htmlFor;
  readonly attribute HTMLFormElement? form;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString name;

  [Constant]
  readonly attribute DOMString type;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString defaultValue;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString value;

  readonly attribute boolean willValidate;
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  boolean checkValidity();
  boolean reportValidity();
  undefined setCustomValidity(DOMString error);

  readonly attribute NodeList labels;
};
 
/* ---------------------- HTMLParagraphElement ----------------------------- */ 
/* ./webidl/HTMLParagraphElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-p-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-p-element
[Exposed=Window]
interface HTMLParagraphElement : HTMLElement {
  [HTMLConstructor] constructor();

};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLParagraphElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
};
 
/* ---------------------- HTMLParamElement ----------------------------- */ 
/* ./webidl/HTMLParamElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-param-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-param-element
[Exposed=Window]
interface HTMLParamElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows, Pure]
           attribute DOMString name;
           [CEReactions, SetterThrows, Pure]
           attribute DOMString value;
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLParamElement {
           [CEReactions, SetterThrows, Pure]
           attribute DOMString type;
           [CEReactions, SetterThrows, Pure]
           attribute DOMString valueType;
};
 
/* ---------------------- HTMLPictureElement ----------------------------- */ 
/* ./webidl/HTMLPictureElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface HTMLPictureElement : HTMLElement {
  [HTMLConstructor] constructor();

};
 
/* ---------------------- HTMLPreElement ----------------------------- */ 
/* ./webidl/HTMLPreElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-pre-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-pre-element
[Exposed=Window]
interface HTMLPreElement : HTMLElement {
  [HTMLConstructor] constructor();

};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLPreElement {
           [CEReactions, SetterThrows]
           attribute long width;
};
 
/* ---------------------- HTMLProgressElement ----------------------------- */ 
/* ./webidl/HTMLProgressElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-progress-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLProgressElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute double value;
           [CEReactions, SetterThrows]
           attribute double max;
  readonly attribute double position;
  readonly attribute NodeList labels;
};
 
/* ---------------------- HTMLQuoteElement ----------------------------- */ 
/* ./webidl/HTMLQuoteElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-blockquote-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-blockquote-element
[Exposed=Window]
interface HTMLQuoteElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows, Pure]
           attribute DOMString cite;
};
 
/* ---------------------- HTMLScriptElement ----------------------------- */ 
/* ./webidl/HTMLScriptElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-script-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 */

[Exposed=Window]
interface HTMLScriptElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
  attribute DOMString src;
  [CEReactions, SetterThrows]
  attribute DOMString type;
  [CEReactions, SetterThrows]
  attribute boolean noModule;
  [CEReactions, SetterThrows]
  attribute DOMString charset;
  [CEReactions, SetterThrows]
  attribute boolean async;
  [CEReactions, SetterThrows]
  attribute boolean defer;
  [CEReactions, SetterThrows]
  attribute DOMString? crossOrigin;
  [CEReactions, SetterThrows]
  attribute DOMString referrerPolicy;
  [CEReactions, Throws]
  attribute DOMString text;
  [Pref="dom.element.blocking.enabled", SameObject, PutForwards=value]
  readonly attribute DOMTokenList blocking;
  [Pref="network.fetchpriority.enabled", CEReactions]
  attribute DOMString fetchPriority;

  static boolean supports(DOMString type);
};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLScriptElement {
  [CEReactions, SetterThrows]
  attribute DOMString event;
  [CEReactions, SetterThrows]
  attribute DOMString htmlFor;
};

// https://w3c.github.io/webappsec/specs/subresourceintegrity/#htmlscriptelement-1
partial interface HTMLScriptElement {
  [CEReactions, SetterThrows]
  attribute DOMString integrity;
};
 
/* ---------------------- HTMLSelectElement ----------------------------- */ 
/* ./webidl/HTMLSelectElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/html/#the-select-element
 */

[Exposed=Window]
interface HTMLSelectElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
  attribute DOMString autocomplete;
  [CEReactions, SetterThrows, Pure]
  attribute boolean disabled;
  [Pure]
  readonly attribute HTMLFormElement? form;
  [CEReactions, SetterThrows, Pure]
  attribute boolean multiple;
  [CEReactions, SetterThrows, Pure]
  attribute DOMString name;
  [CEReactions, SetterThrows, Pure]
  attribute boolean required;
  [CEReactions, SetterThrows, Pure]
  attribute unsigned long size;

  [Pure]
  readonly attribute DOMString type;

  [Constant]
  readonly attribute HTMLOptionsCollection options;
  [CEReactions, SetterThrows, Pure]
  attribute unsigned long length;
  getter Element? item(unsigned long index);
  HTMLOptionElement? namedItem(DOMString name);
  [CEReactions, Throws]
  undefined add((HTMLOptionElement or HTMLOptGroupElement) element, optional (HTMLElement or long)? before = null);
  [CEReactions]
  undefined remove(long index);
  [CEReactions, Throws]
  setter undefined (unsigned long index, HTMLOptionElement? option);

  readonly attribute HTMLCollection selectedOptions;
  [Pure]
  attribute long selectedIndex;
  [Pure]
  attribute DOMString value;

  readonly attribute boolean willValidate;
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  boolean checkValidity();
  boolean reportValidity();
  undefined setCustomValidity(DOMString error);

  [Throws, Pref="dom.select.showPicker.enabled"]
  undefined showPicker();

  readonly attribute NodeList labels;

  // https://www.w3.org/Bugs/Public/show_bug.cgi?id=20720
  [CEReactions]
  undefined remove();
};

// Chrome only interface

partial interface HTMLSelectElement {
  [ChromeOnly]
  undefined userFinishedInteracting(boolean changed);
  [ChromeOnly, Pure]
  readonly attribute boolean isCombobox;
  [ChromeOnly]
  attribute boolean openInParentProcess;
  [ChromeOnly]
  AutocompleteInfo getAutocompleteInfo();
  [ChromeOnly]
  attribute DOMString previewValue;
};
 
/* ---------------------- HTMLSlotElement ----------------------------- */ 
/* ./webidl/HTMLSlotElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/forms.html#the-dialog-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLSlotElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows] attribute DOMString name;
  sequence<Node> assignedNodes(optional AssignedNodesOptions options = {});
  sequence<Element> assignedElements(optional AssignedNodesOptions options = {});
  undefined assign((Element or Text)... nodes);
};

dictionary AssignedNodesOptions {
  boolean flatten = false;
};
 
/* ---------------------- HTMLSourceElement ----------------------------- */ 
/* ./webidl/HTMLSourceElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-source-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLSourceElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString src;
           [CEReactions, SetterThrows]
           attribute DOMString type;
};

partial interface HTMLSourceElement {
           [CEReactions, SetterNeedsSubjectPrincipal=NonSystem, SetterThrows]
           attribute DOMString srcset;
           [CEReactions, SetterThrows]
           attribute DOMString sizes;
           [CEReactions, SetterThrows]
           attribute DOMString media;
           [CEReactions, SetterThrows]
           attribute unsigned long width;
           [CEReactions, SetterThrows]
           attribute unsigned long height;
};
 
/* ---------------------- HTMLSpanElement ----------------------------- */ 
/* ./webidl/HTMLSpanElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-span-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-span-element
[Exposed=Window, ProbablyShortLivingWrapper]
interface HTMLSpanElement : HTMLElement {
  [HTMLConstructor] constructor();
};
 
/* ---------------------- HTMLStyleElement ----------------------------- */ 
/* ./webidl/HTMLStyleElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-style-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 */

[Exposed=Window]
interface HTMLStyleElement : HTMLElement {
  [HTMLConstructor] constructor();

           [Pure]
           attribute boolean disabled;
           [CEReactions, SetterThrows, Pure]
           attribute DOMString media;
           [CEReactions, SetterThrows, Pure]
           attribute DOMString type;
           [Pref="dom.element.blocking.enabled", SameObject, PutForwards=value]
           readonly attribute DOMTokenList blocking;
};
HTMLStyleElement includes LinkStyle;

// Mozilla-specific additions to support devtools
partial interface HTMLStyleElement {
  /**
   * Mark this style element with a devtools-specific principal that
   * skips Content Security Policy unsafe-inline checks. This triggering
   * principal will be overwritten by any callers that set textContent
   * or innerHTML on this element.
   */
  [ChromeOnly]
  undefined setDevtoolsAsTriggeringPrincipal();
};
 
/* ---------------------- HTMLTableCaptionElement ----------------------------- */ 
/* ./webidl/HTMLTableCaptionElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLTableCaptionElement : HTMLElement {
  [HTMLConstructor] constructor();
};

partial interface HTMLTableCaptionElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
};
 
/* ---------------------- HTMLTableCellElement ----------------------------- */ 
/* ./webidl/HTMLTableCellElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLTableCellElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute unsigned long colSpan;
           [CEReactions, SetterThrows]
           attribute unsigned long rowSpan;
  //[PutForwards=value] readonly attribute DOMTokenList headers;
           [CEReactions, SetterThrows]
           attribute DOMString headers;
  readonly attribute long cellIndex;

  // Mozilla-specific extensions
           [CEReactions, SetterThrows]
           attribute DOMString abbr;
           [CEReactions, SetterThrows]
           attribute DOMString scope;
};

partial interface HTMLTableCellElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute DOMString axis;
           [CEReactions, SetterThrows]
           attribute DOMString height;
           [CEReactions, SetterThrows]
           attribute DOMString width;

           [CEReactions, SetterThrows]
           attribute DOMString ch;
           [CEReactions, SetterThrows]
           attribute DOMString chOff;
           [CEReactions, SetterThrows]
           attribute boolean noWrap;
           [CEReactions, SetterThrows]
           attribute DOMString vAlign;

           [CEReactions, SetterThrows]
           attribute [LegacyNullToEmptyString] DOMString bgColor;
};
 
/* ---------------------- HTMLTableColElement ----------------------------- */ 
/* ./webidl/HTMLTableColElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLTableColElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute unsigned long span;
};

partial interface HTMLTableColElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute DOMString ch;
           [CEReactions, SetterThrows]
           attribute DOMString chOff;
           [CEReactions, SetterThrows]
           attribute DOMString vAlign;
           [CEReactions, SetterThrows]
           attribute DOMString width;
};
 
/* ---------------------- HTMLTableElement ----------------------------- */ 
/* ./webidl/HTMLTableElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLTableElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute HTMLTableCaptionElement? caption;
  HTMLElement createCaption();
  [CEReactions]
  undefined deleteCaption();
           [CEReactions, SetterThrows]
           attribute HTMLTableSectionElement? tHead;
  HTMLElement createTHead();
  [CEReactions]
  undefined deleteTHead();
           [CEReactions, SetterThrows]
           attribute HTMLTableSectionElement? tFoot;
  HTMLElement createTFoot();
  [CEReactions]
  undefined deleteTFoot();
  readonly attribute HTMLCollection tBodies;
  HTMLElement createTBody();
  readonly attribute HTMLCollection rows;
  [Throws]
  HTMLElement insertRow(optional long index = -1);
  [CEReactions, Throws]
  undefined deleteRow(long index);
  //         attribute boolean sortable;
  //undefined stopSorting();
};

partial interface HTMLTableElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute DOMString border;
           [CEReactions, SetterThrows]
           attribute DOMString frame;
           [CEReactions, SetterThrows]
           attribute DOMString rules;
           [CEReactions, SetterThrows]
           attribute DOMString summary;
           [CEReactions, SetterThrows]
           attribute DOMString width;

  [CEReactions, SetterThrows]
           attribute [LegacyNullToEmptyString] DOMString bgColor;
  [CEReactions, SetterThrows]
           attribute [LegacyNullToEmptyString] DOMString cellPadding;
  [CEReactions, SetterThrows]
           attribute [LegacyNullToEmptyString] DOMString cellSpacing;
};
 
/* ---------------------- HTMLTableRowElement ----------------------------- */ 
/* ./webidl/HTMLTableRowElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLTableRowElement : HTMLElement {
  [HTMLConstructor] constructor();

  readonly attribute long rowIndex;
  readonly attribute long sectionRowIndex;
  readonly attribute HTMLCollection cells;
  [Throws]
  HTMLElement insertCell(optional long index = -1);
  [CEReactions, Throws]
  undefined deleteCell(long index);
};

partial interface HTMLTableRowElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute DOMString ch;
           [CEReactions, SetterThrows]
           attribute DOMString chOff;
           [CEReactions, SetterThrows]
           attribute DOMString vAlign;

  [CEReactions, SetterThrows]
           attribute [LegacyNullToEmptyString] DOMString bgColor;
};
 
/* ---------------------- HTMLTableSectionElement ----------------------------- */ 
/* ./webidl/HTMLTableSectionElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface HTMLTableSectionElement : HTMLElement {
  [HTMLConstructor] constructor();

  readonly attribute HTMLCollection rows;
  [Throws]
  HTMLElement insertRow(optional long index = -1);
  [CEReactions, Throws]
  undefined deleteRow(long index);
};

partial interface HTMLTableSectionElement {
           [CEReactions, SetterThrows]
           attribute DOMString align;
           [CEReactions, SetterThrows]
           attribute DOMString ch;
           [CEReactions, SetterThrows]
           attribute DOMString chOff;
           [CEReactions, SetterThrows]
           attribute DOMString vAlign;
};
 
/* ---------------------- HTMLTemplateElement ----------------------------- */ 
/* ./webidl/HTMLTemplateElement.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/scripting.html#the-template-element
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface HTMLTemplateElement : HTMLElement {
  [HTMLConstructor] constructor();

  readonly attribute DocumentFragment content;
  [CEReactions, Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  attribute DOMString shadowRootMode;
  [CEReactions, SetterThrows, Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  attribute boolean shadowRootDelegatesFocus;
  [CEReactions, SetterThrows, Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  attribute boolean shadowRootClonable;
};
 
/* ---------------------- HTMLTextAreaElement ----------------------------- */ 
/* ./webidl/HTMLTextAreaElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-textarea-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

interface nsIEditor;
interface XULControllers;

[Exposed=Window]
interface HTMLTextAreaElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
           attribute DOMString autocomplete;
  [CEReactions, SetterThrows, Pure]
           attribute unsigned long cols;
  [CEReactions, Pure, SetterThrows]
           attribute DOMString dirName;
  [CEReactions, SetterThrows, Pure]
           attribute boolean disabled;
  [Pure]
  readonly attribute HTMLFormElement? form;
           // attribute DOMString inputMode;
  [CEReactions, SetterThrows, Pure]
           attribute long maxLength;
  [CEReactions, SetterThrows, Pure]
           attribute long minLength;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString name;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString placeholder;
  [CEReactions, SetterThrows, Pure]
           attribute boolean readOnly;
  [CEReactions, SetterThrows, Pure]
           attribute boolean required;
  [CEReactions, SetterThrows, Pure]
           attribute unsigned long rows;
  [CEReactions, SetterThrows, Pure]
           attribute DOMString wrap;

  [Constant]
  readonly attribute DOMString type;
  [CEReactions, Throws, Pure]
           attribute DOMString defaultValue;
  [CEReactions, SetterThrows] attribute [LegacyNullToEmptyString] DOMString value;
  [BinaryName="getTextLength"]
  readonly attribute unsigned long textLength;

  readonly attribute boolean willValidate;
  readonly attribute ValidityState validity;
  [Throws]
  readonly attribute DOMString validationMessage;
  boolean checkValidity();
  boolean reportValidity();
  undefined setCustomValidity(DOMString error);

  readonly attribute NodeList labels;

  undefined select();
  [Throws]
           attribute unsigned long? selectionStart;
  [Throws]
           attribute unsigned long? selectionEnd;
  [Throws]
           attribute DOMString? selectionDirection;
  [Throws]
  undefined setRangeText(DOMString replacement);
  [Throws]
  undefined setRangeText(DOMString replacement, unsigned long start,
    unsigned long end, optional SelectionMode selectionMode = "preserve");
  [Throws]
  undefined setSelectionRange(unsigned long start, unsigned long end, optional DOMString direction);
};

partial interface HTMLTextAreaElement {
  // Chrome-only Mozilla extensions

  [Throws, ChromeOnly]
  readonly attribute XULControllers controllers;
};

HTMLTextAreaElement includes MozEditableElement;

partial interface HTMLTextAreaElement {
  [ChromeOnly]
  attribute DOMString previewValue;
};
 
/* ---------------------- HTMLTimeElement ----------------------------- */ 
/* ./webidl/HTMLTimeElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/text-level-semantics.html#the-time-element
 */

[Exposed=Window]
interface HTMLTimeElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, SetterThrows]
           attribute DOMString dateTime;
};
 
/* ---------------------- HTMLTitleElement ----------------------------- */ 
/* ./webidl/HTMLTitleElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-title-element
 */

[Exposed=Window]
interface HTMLTitleElement : HTMLElement {
  [HTMLConstructor] constructor();

           [CEReactions, Throws]
           attribute DOMString text;
};
 
/* ---------------------- HTMLTrackElement ----------------------------- */ 
/* ./webidl/HTMLTrackElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-track-element
 */

[Exposed=Window]
interface HTMLTrackElement : HTMLElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows, Pure]
  attribute DOMString kind;
  [CEReactions, SetterThrows, Pure]
  attribute DOMString src;
  [CEReactions, SetterThrows, Pure]
  attribute DOMString srclang;
  [CEReactions, SetterThrows, Pure]
  attribute DOMString label;
  [CEReactions, SetterThrows, Pure]
  attribute boolean default;

  const unsigned short NONE = 0;
  const unsigned short LOADING = 1;
  const unsigned short LOADED = 2;
  const unsigned short ERROR = 3;

  [BinaryName="readyStateForBindings"]
  readonly attribute unsigned short readyState;

  readonly attribute TextTrack? track;
};
 
/* ---------------------- HTMLUListElement ----------------------------- */ 
/* ./webidl/HTMLUListElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-ul-element
 * http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// http://www.whatwg.org/specs/web-apps/current-work/#the-ul-element
[Exposed=Window]
interface HTMLUListElement : HTMLElement {
  [HTMLConstructor] constructor();

};

// http://www.whatwg.org/specs/web-apps/current-work/#other-elements,-attributes-and-apis
partial interface HTMLUListElement {
           [CEReactions, SetterThrows]
           attribute boolean compact;
           [CEReactions, SetterThrows]
           attribute DOMString type;
};
 
/* ---------------------- HTMLVideoElement ----------------------------- */ 
/* ./webidl/HTMLVideoElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/#the-video-element
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window,
 InstrumentedProps=(cancelVideoFrameCallback,
                    onenterpictureinpicture,
                    onleavepictureinpicture,
                    playsInline,
                    requestPictureInPicture,
                    requestVideoFrameCallback)]
interface HTMLVideoElement : HTMLMediaElement {
  [HTMLConstructor] constructor();

  [CEReactions, SetterThrows]
           attribute unsigned long width;
  [CEReactions, SetterThrows]
           attribute unsigned long height;
  readonly attribute unsigned long videoWidth;
  readonly attribute unsigned long videoHeight;
  [CEReactions, SetterThrows]
           attribute DOMString poster;
};

partial interface HTMLVideoElement {
  // A count of the number of video frames that have demuxed from the media
  // resource. If we were playing perfectly, we'd be able to paint this many
  // frames.
  readonly attribute unsigned long mozParsedFrames;

  // A count of the number of frames that have been decoded. We may drop
  // frames if the decode is taking too much time.
  readonly attribute unsigned long mozDecodedFrames;

  // A count of the number of frames that have been presented to the rendering
  // pipeline. We may drop frames if they arrive late at the renderer.
  readonly attribute unsigned long mozPresentedFrames;

  // Number of presented frames which were painted on screen.
  readonly attribute unsigned long mozPaintedFrames;

  // Time which the last painted video frame was late by, in seconds.
  readonly attribute double mozFrameDelay;

  // True if the video has an audio track available.
  readonly attribute boolean mozHasAudio;

  // Clones the frames playing in this <video> to the target. Cloning ends
  // when either node is removed from their DOM trees. Throws if one or
  // both <video> elements are not attached to a DOM tree.
  // Returns a promise that resolves when the target's ImageContainer has been
  // installed in this <video>'s MediaDecoder, or selected video
  // MediaStreamTrack, whichever is available first. Note that it might never
  // resolve.
  [NewObject, Func="IsChromeOrUAWidget"]
    Promise<undefined> cloneElementVisually(HTMLVideoElement target);

  // Stops a <video> from cloning visually. Does nothing if the <video>
  // wasn't cloning in the first place.
  [Func="IsChromeOrUAWidget"]
    undefined stopCloningElementVisually();

  // Returns true if the <video> is being cloned visually to another
  // <video> element (see cloneElementVisually).
  [Func="IsChromeOrUAWidget"]
    readonly attribute boolean isCloningElementVisually;
};

// https://dvcs.w3.org/hg/html-media/raw-file/default/media-source/media-source.html#idl-def-HTMLVideoElement
partial interface HTMLVideoElement {
  [Pref="media.mediasource.enabled", NewObject]
  VideoPlaybackQuality getVideoPlaybackQuality();
};

// https://w3c.github.io/picture-in-picture/#htmlvideoelement-extensions
partial interface HTMLVideoElement {
  [CEReactions, SetterThrows] attribute boolean disablePictureInPicture;
};
 
/* ---------------------- IDBCursor ----------------------------- */ 
/* ./webidl/IDBCursor.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#cursor-interface
 */

enum IDBCursorDirection {
    "next",
    "nextunique",
    "prev",
    "prevunique"
};

[Exposed=(Window,Worker)]
interface IDBCursor {
    readonly    attribute (IDBObjectStore or IDBIndex) source;

    [BinaryName="getDirection"]
    readonly    attribute IDBCursorDirection           direction;

    [Pure, Throws] readonly attribute any key;
    [Pure, Throws] readonly attribute any primaryKey;
    [SameObject] readonly attribute IDBRequest request;

    [Throws]
    undefined  advance ([EnforceRange] unsigned long count);

    [Throws]
    undefined  continue (optional any key);

    [Throws]
    undefined  continuePrimaryKey(any key, any primaryKey);

    [NewObject, Throws] IDBRequest update(any value);
    [NewObject, Throws] IDBRequest delete();
};

[Exposed=(Window,Worker)]
interface IDBCursorWithValue : IDBCursor {
    [Pure, Throws] readonly attribute any value;
};
 
/* ---------------------- IDBDatabase ----------------------------- */ 
/* ./webidl/IDBDatabase.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#database-interface
 * https://w3c.github.io/IndexedDB/#enumdef-idbtransactiondurability
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum IDBTransactionDurability { "default", "strict", "relaxed" };

dictionary IDBTransactionOptions {
  IDBTransactionDurability durability = "default";
};

[Exposed=(Window,Worker)]
interface IDBDatabase : EventTarget {
    [Constant] readonly attribute DOMString name;
    readonly    attribute unsigned long long version;

    readonly    attribute DOMStringList      objectStoreNames;

    [NewObject, Throws]
    IDBTransaction transaction((DOMString or sequence<DOMString>) storeNames,
                               optional IDBTransactionMode mode = "readonly",
                               optional IDBTransactionOptions options = {});
    [NewObject, Throws]
    IDBObjectStore createObjectStore(
        DOMString name,
        optional IDBObjectStoreParameters options = {});
    [Throws]
    undefined      deleteObjectStore (DOMString name);
    undefined      close ();

                attribute EventHandler       onabort;
                attribute EventHandler       onclose;
                attribute EventHandler       onerror;
                attribute EventHandler       onversionchange;
};
 
/* ---------------------- IDBFactory ----------------------------- */ 
/* ./webidl/IDBFactory.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#factory-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

interface Principal;

dictionary IDBOpenDBOptions
{
  [EnforceRange] unsigned long long version;
};

/**
 * Interface that defines the indexedDB property on a window.  See
 * https://w3c.github.io/IndexedDB/#idbfactory
 * for more information.
 */
[Exposed=(Window,Worker)]
interface IDBFactory {
  [NewObject, Throws, NeedsCallerType]
  IDBOpenDBRequest
  open(DOMString name,
       [EnforceRange] unsigned long long version);

  [NewObject, Throws, NeedsCallerType]
  IDBOpenDBRequest
  open(DOMString name,
       optional IDBOpenDBOptions options = {});

  [NewObject, Throws, NeedsCallerType]
  IDBOpenDBRequest
  deleteDatabase(DOMString name,
                 optional IDBOpenDBOptions options = {});

  Promise<sequence<IDBDatabaseInfo>> databases();

  [Throws]
  short
  cmp(any first,
      any second);

  [NewObject, Throws, ChromeOnly, NeedsCallerType]
  IDBOpenDBRequest
  openForPrincipal(Principal principal,
                   DOMString name,
                   [EnforceRange] unsigned long long version);

  [NewObject, Throws, ChromeOnly, NeedsCallerType]
  IDBOpenDBRequest
  openForPrincipal(Principal principal,
                   DOMString name,
                   optional IDBOpenDBOptions options = {});

  [NewObject, Throws, ChromeOnly, NeedsCallerType]
  IDBOpenDBRequest
  deleteForPrincipal(Principal principal,
                     DOMString name,
                     optional IDBOpenDBOptions options = {});
};

dictionary IDBDatabaseInfo {
  DOMString name;
  unsigned long long version;
};
 
/* ---------------------- IDBIndex ----------------------------- */ 
/* ./webidl/IDBIndex.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#index-interface
 */

dictionary IDBIndexParameters {
    boolean unique = false;
    boolean multiEntry = false;
    // <null>:   Not locale-aware, uses normal JS sorting.
    // <string>: Always sorted based on the rules of the specified
    //           locale (e.g. "en-US", etc.).
    // "auto":   Sorted by the platform default, may change based on
    //           user agent options.
    DOMString? locale = null;
};

[Exposed=(Window,Worker)]
interface IDBIndex {
    [SetterThrows] attribute DOMString name;
    [SameObject] readonly attribute IDBObjectStore objectStore;

    [Throws]
    readonly    attribute any            keyPath;

    readonly    attribute boolean        multiEntry;
    readonly    attribute boolean        unique;

    // <null>:   Not locale-aware, uses normal JS sorting.
    // <string>: Sorted based on the rules of the specified locale.
    //           Note: never returns "auto", only the current locale.
    [Pref="dom.indexedDB.experimental"]
    readonly attribute DOMString? locale;

    [Pref="dom.indexedDB.experimental"]
    readonly attribute boolean isAutoLocale;

    [NewObject, Throws] IDBRequest get(any query);
    [NewObject, Throws] IDBRequest getKey(any query);

    // If we decide to add use counters for the mozGetAll/mozGetAllKeys
    // functions, we'll need to pull them out into sepatate operations
    // with a BinaryName mapping to the same underlying implementation.
    // See also bug 1577227.
    [NewObject, Throws, Alias="mozGetAll"]
    IDBRequest getAll(optional any query,
                      optional [EnforceRange] unsigned long count);
    [NewObject, Throws, Alias="mozGetAllKeys"]
    IDBRequest getAllKeys(optional any query,
                            optional [EnforceRange] unsigned long count);

    [NewObject, Throws] IDBRequest count(optional any query);

    [NewObject, Throws]
    IDBRequest openCursor(optional any query,
                          optional IDBCursorDirection direction = "next");
    [NewObject, Throws]
    IDBRequest openKeyCursor(optional any query,
                             optional IDBCursorDirection direction = "next");
};
 
/* ---------------------- IDBKeyRange ----------------------------- */ 
/* ./webidl/IDBKeyRange.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */
/*
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#keyrange
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker)]
interface IDBKeyRange {
  [Throws]
  readonly attribute any     lower;
  [Throws]
  readonly attribute any     upper;
  [Constant]
  readonly attribute boolean lowerOpen;
  [Constant]
  readonly attribute boolean upperOpen;
  [Throws]
  boolean _includes(any key);


  [NewObject, Throws]
  static IDBKeyRange only (any value);
  [NewObject, Throws]
  static IDBKeyRange lowerBound (any lower, optional boolean open = false);
  [NewObject, Throws]
  static IDBKeyRange upperBound (any upper, optional boolean open = false);
  [NewObject, Throws]
  static IDBKeyRange bound (any lower, any upper, optional boolean lowerOpen = false, optional boolean upperOpen = false);
};
 
/* ---------------------- IDBObjectStore ----------------------------- */ 
/* ./webidl/IDBObjectStore.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#object-store-interface
 */

dictionary IDBObjectStoreParameters {
    (DOMString or sequence<DOMString>)? keyPath = null;
    boolean                             autoIncrement = false;
};

[Exposed=(Window,Worker)]
interface IDBObjectStore {
    [SetterThrows]
    attribute DOMString name;

    [Throws]
    readonly    attribute any            keyPath;

    readonly    attribute DOMStringList  indexNames;
    [SameObject] readonly attribute IDBTransaction transaction;
    readonly    attribute boolean        autoIncrement;

    [NewObject, Throws]
    IDBRequest put (any value, optional any key);
    [NewObject, Throws]
    IDBRequest add (any value, optional any key);
    [NewObject, Throws]
    IDBRequest delete (any key);
    [NewObject, Throws]
    IDBRequest clear ();
    [NewObject, Throws]
    IDBRequest get (any key);
    [NewObject, Throws]
    IDBRequest getKey (any key);

    // Success fires IDBTransactionEvent, result == array of values for given keys
    // If we decide to add use a counter for the mozGetAll function, we'll need
    // to pull it out into a sepatate operation with a BinaryName mapping to the
    // same underlying implementation.
    [NewObject, Throws, Alias="mozGetAll"]
    IDBRequest getAll(optional any query,
                      optional [EnforceRange] unsigned long count);
    [NewObject, Throws]
    IDBRequest getAllKeys(optional any query,
                          optional [EnforceRange] unsigned long count);

    [NewObject, Throws]
    IDBRequest count(optional any key);

    [NewObject, Throws]
    IDBRequest openCursor (optional any range, optional IDBCursorDirection direction = "next");
    [NewObject, Throws]
    IDBRequest openKeyCursor(optional any query,
                             optional IDBCursorDirection direction = "next");
    [NewObject, Throws]
    IDBIndex   createIndex (DOMString name, (DOMString or sequence<DOMString>) keyPath, optional IDBIndexParameters optionalParameters = {});

    [Throws]
    IDBIndex   index (DOMString name);

    [Throws]
    undefined       deleteIndex (DOMString indexName);
};
 
/* ---------------------- IDBOpenDBRequest ----------------------------- */ 
/* ./webidl/IDBOpenDBRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#idbopendbrequest
 */

[Exposed=(Window,Worker)]
interface IDBOpenDBRequest : IDBRequest {
                attribute EventHandler onblocked;

                attribute EventHandler onupgradeneeded;
};
 
/* ---------------------- IDBRequest ----------------------------- */ 
/* ./webidl/IDBRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#idbrequest
 * https://w3c.github.io/IndexedDB/#enumdef-idbrequestreadystate
 */

enum IDBRequestReadyState {
    "pending",
    "done"
};

[Exposed=(Window,Worker)]
interface IDBRequest : EventTarget {
    [Throws]
    readonly    attribute any                  result;

    [Throws]
    readonly    attribute DOMException?        error;

    readonly    attribute (IDBObjectStore or IDBIndex or IDBCursor)? source;
    readonly    attribute IDBTransaction?      transaction;
    readonly    attribute IDBRequestReadyState readyState;

                attribute EventHandler         onsuccess;

                attribute EventHandler         onerror;
};
 
/* ---------------------- IDBTransaction ----------------------------- */ 
/* ./webidl/IDBTransaction.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#idbtransaction
 * https://w3c.github.io/IndexedDB/#enumdef-idbtransactionmode
 */

enum IDBTransactionMode {
    "readonly",
    "readwrite",
    // The "readwriteflush" mode is only available when the
    // |dom.indexedDB.experimental| pref returns
    // true. This mode is not yet part of the standard.
    "readwriteflush",
    "cleanup",
    "versionchange"
};

[Exposed=(Window,Worker)]
interface IDBTransaction : EventTarget {
    [Throws]
    readonly    attribute IDBTransactionMode mode;

    [Throws]
    readonly    attribute IDBTransactionDurability durability;

    [SameObject] readonly attribute IDBDatabase db;

    readonly    attribute DOMException?      error;

    [Throws]
    IDBObjectStore objectStore (DOMString name);

    [Throws]
    undefined      commit();

    [Throws]
    undefined      abort();

                attribute EventHandler       onabort;
                attribute EventHandler       oncomplete;
                attribute EventHandler       onerror;
};

// This seems to be custom
partial interface IDBTransaction {
    readonly    attribute DOMStringList objectStoreNames;
};
 
/* ---------------------- IDBVersionChangeEvent ----------------------------- */ 
/* ./webidl/IDBVersionChangeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IndexedDB/#idbversionchangeevent
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary IDBVersionChangeEventInit : EventInit {
    unsigned long long  oldVersion = 0;
    unsigned long long? newVersion = null;
};

[Exposed=(Window,Worker)]
interface IDBVersionChangeEvent : Event {
    constructor(DOMString type,
                optional IDBVersionChangeEventInit eventInitDict = {});

    [Constant] readonly attribute unsigned long long oldVersion;
    [Constant] readonly attribute unsigned long long? newVersion;
};
 
/* ---------------------- IdentityCredential ----------------------------- */ 
/* ./webidl/IdentityCredential.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://fedidcg.github.io/FedCM
 */


[Exposed=Window, SecureContext,
 Pref="dom.security.credentialmanagement.identity.enabled"]
interface IdentityCredential : Credential {
 readonly attribute USVString? token;
 [Throws]
 static Promise<undefined> logoutRPs(sequence<IdentityCredentialLogoutRPsRequest> logoutRequests);
};

dictionary IdentityCredentialRequestOptions {
 sequence<IdentityProviderConfig> providers;
};

[GenerateConversionToJS]
dictionary IdentityProviderConfig {
 required UTF8String configURL;
 required USVString clientId;
 USVString nonce;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityproviderwellknown
[GenerateInit]
dictionary IdentityProviderWellKnown {
  required sequence<UTF8String> provider_urls;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityprovidericon
dictionary IdentityProviderIcon {
  required USVString url;
  unsigned long size;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityproviderbranding
dictionary IdentityProviderBranding {
  USVString background_color;
  USVString color;
  sequence<IdentityProviderIcon> icons;
  USVString name;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityproviderapiconfig
[GenerateInit, GenerateConversionToJS]
dictionary IdentityProviderAPIConfig {
  required UTF8String accounts_endpoint;
  required UTF8String client_metadata_endpoint;
  required UTF8String id_assertion_endpoint;
  IdentityProviderBranding branding;
};


// https://fedidcg.github.io/FedCM/#dictdef-identityprovideraccount
dictionary IdentityProviderAccount {
  required USVString id;
  required USVString name;
  required USVString email;
  USVString given_name;
  USVString picture;
  sequence<USVString> approved_clients;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityprovideraccountlist
[GenerateInit, GenerateConversionToJS]
dictionary IdentityProviderAccountList {
  sequence<IdentityProviderAccount> accounts;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityproviderclientmetadata
[GenerateInit, GenerateConversionToJS]
dictionary IdentityProviderClientMetadata {
  USVString privacy_policy_url;
  USVString terms_of_service_url;
};

// https://fedidcg.github.io/FedCM/#dictdef-identityprovidertoken
[GenerateInit]
dictionary IdentityProviderToken {
  required USVString token;
};

// https://fedidcg.github.io/FedCM/#dictdef-identitycredentiallogoutrpsrequest
dictionary IdentityCredentialLogoutRPsRequest {
  required UTF8String url;
  required UTF8String accountId;
};
 
/* ---------------------- IdleDeadline ----------------------------- */ 
/* ./webidl/IdleDeadline.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is:
 * https://w3c.github.io/requestidlecallback/
 */

[Exposed=Window]
interface IdleDeadline {
  DOMHighResTimeStamp timeRemaining();
  readonly attribute boolean didTimeout;
};
 
/* ---------------------- IIRFilterNode ----------------------------- */ 
/* ./webidl/IIRFilterNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is https://www.w3.org/TR/webaudio
 *
 * Copyright © 2016 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary IIRFilterOptions : AudioNodeOptions {
    required sequence<double> feedforward;
    required sequence<double> feedback;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface IIRFilterNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context, IIRFilterOptions options);

    undefined getFrequencyResponse(Float32Array frequencyHz, Float32Array magResponse, Float32Array phaseResponse);
};

// Mozilla extension
IIRFilterNode includes AudioNodePassThrough;
 
/* ---------------------- ImageBitmap ----------------------------- */ 
/* ./webidl/ImageBitmap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/webappapis.html#images
 *
 * The origin of the extended IDL file is
 * http://w3c.github.io/mediacapture-worker/#imagebitmap-extensions
 */

typedef (CanvasImageSource or
         Blob or
         CanvasRenderingContext2D or // This is out of spec.
         ImageData) ImageBitmapSource;

[Exposed=(Window,Worker)]
interface ImageBitmap {
  [Constant]
  readonly attribute unsigned long width;
  [Constant]
  readonly attribute unsigned long height;
};

// It's crucial that there be a way to explicitly dispose of ImageBitmaps
// since they refer to potentially large graphics resources. Some uses
// of this API proposal will result in repeated allocations of ImageBitmaps,
// and garbage collection will not reliably reclaim them quickly enough.
// Here we reuse close(), which also exists on another Transferable type,
// MessagePort. Potentially, all Transferable types should inherit from a
// new interface type "Closeable".
partial interface ImageBitmap {
  // Dispose of all graphical resources associated with this ImageBitmap.
  undefined close();
};

// ImageBitmap-extensions
// Bug 1141979 - [FoxEye] Extend ImageBitmap with interfaces to access its
// underlying image data

/*
 * An image or a video frame is conceptually a two-dimensional array of data and
 * each element in the array is called a pixel. The pixels are usually stored in
 * a one-dimensional array and could be arranged in a variety of image formats.
 * Developers need to know how the pixels are formatted so that they are able to
 * process them.
 *
 * The image format describes how pixels in an image are arranged. A single
 * pixel has at least one, but usually multiple pixel values. The range of a
 * pixel value varies, which means different image formats use different data
 * types to store a single pixel value.
 *
 * The most frequently used data type is 8-bit unsigned integer whose range is
 * from 0 to 255, others could be 16-bit integer or 32-bit floating points and
 * so forth. The number of pixel values of a single pixel is called the number
 * of channels of the image format. Multiple pixel values of a pixel are used
 * together to describe the captured property which could be color or depth
 * information. For example, if the data is a color image in RGB color space,
 * then it is a three-channel image format and a pixel is described by R, G and
 * B three pixel values with range from 0 to 255. As another example, if the
 * data is a gray image, then it is a single-channel image format with 8-bit
 * unsigned integer data type and the pixel value describes the gray scale. For
 * depth data, it is a single channel image format too, but the data type is
 * 16-bit unsigned integer and the pixel value is the depth level.
 *
 * For those image formats whose pixels contain multiple pixel values, the pixel
 * values might be arranged in one of the following ways:
 * 1) Planar pixel layout:
 *    each channel has its pixel values stored consecutively in separated
 *    buffers (a.k.a. planes) and then all channel buffers are stored
 *    consecutively in memory.
 *    (Ex: RRRRRR......GGGGGG......BBBBBB......)
 * 2) Interleaving pixel layout:
 *    each pixel has its pixel values from all channels stored together and
 *    interleaves all channels.
 *    (Ex: RGBRGBRGBRGBRGB......)
 */


/*
 * The ImageBitmap extensions use this enumeration to negotiate the image format
 * while 1) accessing the underlying data of an ImageBitmap and
 *       2) creating a new ImageBitmap.
 *
 * For each format in this enumeration, we use a 2x2 small image (4 pixels) as
 * example to illustrate the pixel layout.
 *
 * 2x2 image:   +--------+--------+
 *              | pixel1 | pixel2 |
 *              +--------+--------+
 *              | pixel3 | pixel4 |
 *              +--------+--------+
 *
 */
enum ImageBitmapFormat {
  /*
   * Channel order: R, G, B, A
   * Channel size: full rgba-chennels
   * Pixel layout: interleaving rgba-channels
   * Pixel layout illustration:
   *   [Plane1]: R1 G1 B1 A1 R2 G2 B2 A2 R3 G3 B3 A3 R4 G4 B4 A4
   * Data type: 8-bit unsigned integer
   */
  "RGBA32",

  /*
   * Channel order: B, G, R, A
   * Channel size: full bgra-channels
   * Pixel layout: interleaving bgra-channels
   * Pixel layout illustration:
   *   [Plane1]: B1 G1 R1 A1 B2 G2 R2 A2 B3 G3 R3 A3 B4 G4 R4 A4
   * Data type: 8-bit unsigned integer
   */
  "BGRA32",

  /*
   * Channel order: R, G, B
   * Channel size: full rgb-channels
   * Pixel layout: interleaving rgb-channels
   * Pixel layout illustration:
   *   [Plane1]: R1 G1 B1 R2 G2 B2 R3 G3 B3 R4 G4 B4
   * Data type: 8-bit unsigned integer
   */
  "RGB24",

  /*
   * Channel order: B, G, R
   * Channel size: full bgr-channels
   * Pixel layout: interleaving bgr-channels
   * Pixel layout illustration:
   *   [Plane1]: B1 G1 R1 B2 G2 R2 B3 G3 R3 B4 G4 R4
   * Data type: 8-bit unsigned integer
   */
  "BGR24",

  /*
   * Channel order: GRAY
   * Channel size: full gray-channel
   * Pixel layout: planar gray-channel
   * Pixel layout illustration:
   *   [Plane1]: GRAY1 GRAY2 GRAY3 GRAY4
   * Data type: 8-bit unsigned integer
   */
  "GRAY8",

  /*
   * Channel order: Y, U, V
   * Channel size: full yuv-channels
   * Pixel layout: planar yuv-channels
   * Pixel layout illustration:
   *   [Plane1]: Y1 Y2 Y3 Y4
   *   [Plane2]: U1 U2 U3 U4
   *   [Plane3]: V1 V2 V3 V4
   * Data type: 8-bit unsigned integer
   */
  "YUV444P",

  /*
   * Channel order: Y, U, V
   * Channel size: full y-channel, half uv-channels
   * Pixel layout: planar yuv-channels
   * Pixel layout illustration:
   *   [Plane1]: Y1 Y2 Y3 Y4
   *   [Plane2]: U1 U3
   *   [Plane3]: V1 V3
   * Data type: 8-bit unsigned integer
   */
  "YUV422P",

  /*
   * Channel order: Y, U, V
   * Channel size: full y-channel, quarter uv-channels
   * Pixel layout: planar yuv-channels
   * Pixel layout illustration:
   *   [Plane1]: Y1 Y2 Y3 Y4
   *   [Plane2]: U1
   *   [Plane3]: V1
   * Data type: 8-bit unsigned integer
   */
  "YUV420P",

  /*
   * Channel order: Y, U, V
   * Channel size: full y-channel, quarter uv-channels
   * Pixel layout: planar y-channel, interleaving uv-channels
   * Pixel layout illustration:
   *   [Plane1]: Y1 Y2 Y3 Y4
   *   [Plane2]: U1 V1
   * Data type: 8-bit unsigned integer
   */
  "YUV420SP_NV12",

  /*
   * Channel order: Y, V, U
   * Channel size: full y-channel, quarter vu-channels
   * Pixel layout: planar y-channel, interleaving vu-channels
   * Pixel layout illustration:
   *   [Plane1]: Y1 Y2 Y3 Y4
   *   [Plane2]: V1 U1
   * Data type: 8-bit unsigned integer
   */
  "YUV420SP_NV21",

  /*
   * Channel order: H, S, V
   * Channel size: full hsv-channels
   * Pixel layout: interleaving hsv-channels
   * Pixel layout illustration:
   *   [Plane1]: H1 S1 V1 H2 S2 V2 H3 S3 V3
   * Data type: 32-bit floating point value
   */
  "HSV",

  /*
   * Channel order: l, a, b
   * Channel size: full lab-channels
   * Pixel layout: interleaving lab-channels
   * Pixel layout illustration:
   *   [Plane1]: l1 a1 b1 l2 a2 b2 l3 a3 b3
   * Data type: 32-bit floating point value
   */
  "Lab",

  /*
   * Channel order: DEPTH
   * Channel size: full depth-channel
   * Pixel layout: planar depth-channel
   * Pixel layout illustration:
   *   [Plane1]: DEPTH1 DEPTH2 DEPTH3 DEPTH4
   * Data type: 16-bit unsigned integer
   */
  "DEPTH",
};

enum ChannelPixelLayoutDataType {
  "uint8",
  "int8",
  "uint16",
  "int16",
  "uint32",
  "int32",
  "float32",
  "float64"
};

/*
 * Two concepts, ImagePixelLayout and ChannelPixelLayout, together generalize
 * the variety of pixel layouts among image formats.
 *
 * The ChannelPixelLayout represents the pixel layout of a single channel in a
 * certain image format and the ImagePixelLayout is just the collection of
 * ChannelPixelLayouts. So, the ChannelPixelLayout is defined as a dictionary
 * type with properties to describe the layout and the ImagePixelLayout is just
 * an alias name to a sequence of ChannelPixelLayout objects.
 *
 * Since an image format is composed of at least one channel, an
 * ImagePixelLayout object contains at least one ChannelPixelLayout object.
 *
 * Although an image or a video frame is a two-dimensional structure, its data
 * is usually stored in a one-dimensional array in the row-major way and the
 * ChannelPixelLayout objects use the following properties to describe the
 * layout of pixel values in the buffer.
 *
 * 1) offset:
 *    denotes the beginning position of the channel's data relative to the
 *    beginning position of the one-dimensional array.
 * 2) width & height:
 *    denote the width and height of the channel respectively. Each channel in
 *    an image format may have different height and width.
 * 3) data type:
 *    denotes the format used to store one single pixel value.
 * 4) stride:
 *    the number of bytes between the beginning two consecutive rows in memory.
 *    (The total bytes of each row plus the padding bytes of each raw.)
 * 5) skip value:
 *    the value is zero for the planar pixel layout, and a positive integer for
 *    the interleaving pixel layout. (Describes how many bytes there are between
 *    two adjacent pixel values in this channel.)
 */

/*
 * Example1: RGBA image, width = 620, height = 480, stride = 2560
 *
 * chanel_r: offset = 0, width = 620, height = 480, data type = uint8, stride = 2560, skip = 3
 * chanel_g: offset = 1, width = 620, height = 480, data type = uint8, stride = 2560, skip = 3
 * chanel_b: offset = 2, width = 620, height = 480, data type = uint8, stride = 2560, skip = 3
 * chanel_a: offset = 3, width = 620, height = 480, data type = uint8, stride = 2560, skip = 3
 *
 *         <---------------------------- stride ---------------------------->
 *         <---------------------- width x 4 ---------------------->
 * [index] 01234   8   12  16  20  24  28                           2479    2559
 *         |||||---|---|---|---|---|---|----------------------------|-------|
 * [data]  RGBARGBARGBARGBARGBAR___R___R...                         A%%%%%%%%
 * [data]  RGBARGBARGBARGBARGBAR___R___R...                         A%%%%%%%%
 * [data]  RGBARGBARGBARGBARGBAR___R___R...                         A%%%%%%%%
 *              ^^^
 *              r-skip
 */

/*
 * Example2: YUV420P image, width = 620, height = 480, stride = 640
 *
 * chanel_y: offset = 0, width = 620, height = 480, stride = 640, skip = 0
 * chanel_u: offset = 307200, width = 310, height = 240, data type = uint8, stride = 320, skip = 0
 * chanel_v: offset = 384000, width = 310, height = 240, data type = uint8, stride = 320, skip = 0
 *
 *         <--------------------------- y-stride --------------------------->
 *         <----------------------- y-width ----------------------->
 * [index] 012345                                                  619      639
 *         ||||||--------------------------------------------------|--------|
 * [data]  YYYYYYYYYYYYYYYYYYYYYYYYYYYYY...                        Y%%%%%%%%%
 * [data]  YYYYYYYYYYYYYYYYYYYYYYYYYYYYY...                        Y%%%%%%%%%
 * [data]  YYYYYYYYYYYYYYYYYYYYYYYYYYYYY...                        Y%%%%%%%%%
 * [data]  ......
 *         <-------- u-stride ---------->
 *         <----- u-width ----->
 * [index] 307200              307509   307519
 *         |-------------------|--------|
 * [data]  UUUUUUUUUU...       U%%%%%%%%%
 * [data]  UUUUUUUUUU...       U%%%%%%%%%
 * [data]  UUUUUUUUUU...       U%%%%%%%%%
 * [data]  ......
 *         <-------- v-stride ---------->
 *         <- --- v-width ----->
 * [index] 384000              384309   384319
 *         |-------------------|--------|
 * [data]  VVVVVVVVVV...       V%%%%%%%%%
 * [data]  VVVVVVVVVV...       V%%%%%%%%%
 * [data]  VVVVVVVVVV...       V%%%%%%%%%
 * [data]  ......
 */

/*
 * Example3: YUV420SP_NV12 image, width = 620, height = 480, stride = 640
 *
 * chanel_y: offset = 0, width = 620, height = 480, stride = 640, skip = 0
 * chanel_u: offset = 307200, width = 310, height = 240, data type = uint8, stride = 640, skip = 1
 * chanel_v: offset = 307201, width = 310, height = 240, data type = uint8, stride = 640, skip = 1
 *
 *         <--------------------------- y-stride -------------------------->
 *         <----------------------- y-width ---------------------->
 * [index] 012345                                                 619      639
 *         ||||||-------------------------------------------------|--------|
 * [data]  YYYYYYYYYYYYYYYYYYYYYYYYYYYYY...                       Y%%%%%%%%%
 * [data]  YYYYYYYYYYYYYYYYYYYYYYYYYYYYY...                       Y%%%%%%%%%
 * [data]  YYYYYYYYYYYYYYYYYYYYYYYYYYYYY...                       Y%%%%%%%%%
 * [data]  ......
 *         <--------------------- u-stride / v-stride -------------------->
 *         <------------------ u-width + v-width ----------------->
 * [index] 307200(u-offset)                                       307819  307839
 *         |------------------------------------------------------|-------|
 * [index] |307201(v-offset)                                      |307820 |
 *         ||-----------------------------------------------------||------|
 * [data]  UVUVUVUVUVUVUVUVUVUVUVUVUVUVUV...                      UV%%%%%%%
 * [data]  UVUVUVUVUVUVUVUVUVUVUVUVUVUVUV...                      UV%%%%%%%
 * [data]  UVUVUVUVUVUVUVUVUVUVUVUVUVUVUV...                      UV%%%%%%%
 *          ^            ^
 *         u-skip        v-skip
 */

/*
 * Example4: DEPTH image, width = 640, height = 480, stride = 1280
 *
 * chanel_d: offset = 0, width = 640, height = 480, data type = uint16, stride = 1280, skip = 0
 *
 * note: each DEPTH value uses two bytes
 *
 *         <----------------------- d-stride ---------------------->
 *         <----------------------- d-width ----------------------->
 * [index] 02468                                                   1278
 *         |||||---------------------------------------------------|
 * [data]  DDDDDDDDDDDDDDDDDDDDDDDDDDDDD...                        D
 * [data]  DDDDDDDDDDDDDDDDDDDDDDDDDDDDD...                        D
 * [data]  DDDDDDDDDDDDDDDDDDDDDDDDDDDDD...                        D
 * [data]  ......
 */

dictionary ChannelPixelLayout {
    required unsigned long              offset;
    required unsigned long              width;
    required unsigned long              height;
    required ChannelPixelLayoutDataType dataType;
    required unsigned long              stride;
    required unsigned long              skip;
};

typedef sequence<ChannelPixelLayout> ImagePixelLayout;

enum ImageOrientation { "none", "flipY", "from-image" };
enum PremultiplyAlpha { "none", "premultiply", "default" };
enum ColorSpaceConversion { "none", "default" };
//enum ResizeQuality { "pixelated", "low", "medium", "high" };

dictionary ImageBitmapOptions {
  ImageOrientation imageOrientation = "none";
  PremultiplyAlpha premultiplyAlpha = "default";
  // options to be added  bugs: 1363861
  ColorSpaceConversion colorSpaceConversion = "default";
  [EnforceRange] unsigned long resizeWidth;
  [EnforceRange] unsigned long resizeHeight;
  //ResizeQuality resizeQuality = "low";
};
 
/* ---------------------- ImageBitmapRenderingContext ----------------------------- */ 
/* ./webidl/ImageBitmapRenderingContext.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://wiki.whatwg.org/wiki/OffscreenCanvas
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

// The new ImageBitmapRenderingContext is a canvas rendering context
// which only provides the functionality to replace the canvas's
// contents with the given ImageBitmap. Its context id (the first argument
// to getContext) is "bitmaprenderer".
[Exposed=(Window,Worker)]
interface ImageBitmapRenderingContext {
  readonly attribute CanvasSource? canvas;

  // Displays the given ImageBitmap in the canvas associated with this
  // rendering context. Ownership of the ImageBitmap is transferred to
  // the canvas. The caller may not use its reference to the ImageBitmap
  // after making this call. (This semantic is crucial to enable prompt
  // reclamation of expensive graphics resources, rather than relying on
  // garbage collection to do so.)
  //
  // The ImageBitmap conceptually replaces the canvas's bitmap, but
  // it does not change the canvas's intrinsic width or height.
  //
  // The ImageBitmap, when displayed, is clipped to the rectangle
  // defined by the canvas's instrinsic width and height. Pixels that
  // would be covered by the canvas's bitmap which are not covered by
  // the supplied ImageBitmap are rendered transparent black. Any CSS
  // styles affecting the display of the canvas are applied as usual.
  [Throws]
  undefined transferFromImageBitmap(ImageBitmap? bitmap);

  // Deprecated version of transferFromImageBitmap
  [Deprecated="ImageBitmapRenderingContext_TransferImageBitmap", Throws]
  undefined transferImageBitmap(ImageBitmap bitmap);
};
 
/* ---------------------- ImageCapture ----------------------------- */ 
/* ./webidl/ImageCapture.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/dap/raw-file/default/media-stream-capture/ImageCapture.html
 *
 * Copyright © 2012-2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Pref="dom.imagecapture.enabled",
 Exposed=Window]
interface ImageCapture : EventTarget {
  [Throws]
  constructor(MediaStreamTrack track);

  // readonly attribute PhotoSettingsOptions photoSettingsOptions;
  [BinaryName="GetVideoStreamTrack"]
  readonly attribute MediaStreamTrack videoStreamTrack;
  attribute EventHandler onphoto;
  attribute EventHandler onerror;
  // attribute EventHandler onphotosettingschange;
  // attribute EventHandler onframegrab;

  // [Throws]
  // undefined setOptions (PhotoSettings? photoSettings);
  [Throws]
  undefined takePhoto();
  // [Throws]
  // undefined getFrame();
};
 
/* ---------------------- ImageCaptureErrorEvent ----------------------------- */ 
/* ./webidl/ImageCaptureErrorEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/dap/raw-file/default/media-stream-capture/ImageCapture.html
 *
 * Copyright © 2012-2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Pref="dom.imagecapture.enabled",
 Exposed=Window]
interface ImageCaptureErrorEvent : Event {
  constructor(DOMString type,
              optional ImageCaptureErrorEventInit imageCaptureErrorInitDict = {});

  readonly attribute ImageCaptureError? imageCaptureError;
};

dictionary ImageCaptureErrorEventInit : EventInit {
  ImageCaptureError? imageCaptureError = null;
};

[LegacyNoInterfaceObject,
 Exposed=Window]
interface ImageCaptureError {
  const unsigned short FRAME_GRAB_ERROR = 1;
  const unsigned short SETTINGS_ERROR = 2;
  const unsigned short PHOTO_ERROR = 3;
  const unsigned short ERROR_UNKNOWN = 4;
  readonly attribute unsigned short code;
  readonly attribute DOMString message;
};
 
/* ---------------------- ImageData ----------------------------- */ 
/* ./webidl/ImageData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/the-canvas-element.html#imagedata
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and Opera Software ASA.
 * You are granted a license to use, reproduce and create derivative works of this document.
 */

[Exposed=(Window,Worker),
 Serializable,
 InstrumentedProps=(colorSpace)]
interface ImageData {
 [Throws]
 constructor(unsigned long sw, unsigned long sh);
 [Throws]
 constructor(Uint8ClampedArray data, unsigned long sw,
             optional unsigned long sh);

 [Constant]
 readonly attribute unsigned long width;
 [Constant]
 readonly attribute unsigned long height;
 [Constant, StoreInSlot]
 readonly attribute Uint8ClampedArray data;
};
 
/* ---------------------- ImageDocument ----------------------------- */ 
/* ./webidl/ImageDocument.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[ChromeOnly, LegacyOverrideBuiltIns,
 Exposed=Window]
interface ImageDocument : HTMLDocument {
  /* Whether the image is overflowing visible area. */
  readonly attribute boolean imageIsOverflowing;

  /* Whether the image has been resized to fit visible area. */
  readonly attribute boolean imageIsResized;

  /* Resize the image to fit visible area. */
  undefined shrinkToFit();

  /* Restore image original size. */
  undefined restoreImage();
};
 
/* ---------------------- InputEvent ----------------------------- */ 
/* ./webidl/InputEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/input-events/#interface-InputEvent
 */

[Exposed=Window]
interface InputEvent : UIEvent
{
  constructor(DOMString type, optional InputEventInit eventInitDict = {});

  readonly attribute boolean       isComposing;

  readonly attribute DOMString inputType;

  [NeedsCallerType]
  readonly attribute DOMString? data;
};

dictionary InputEventInit : UIEventInit
{
  boolean isComposing = false;
  DOMString inputType = "";
  // NOTE:  Currently, default value of `data` attribute is declared as empty
  //        string by UI Events.  However, both Chrome and Safari uses `null`,
  //        and there is a spec issue about this:
  //        https://github.com/w3c/uievents/issues/139
  //        So, we take `null` for compatibility with them.
  DOMString? data = null;
};

// https://w3c.github.io/input-events/#interface-InputEvent
// https://rawgit.com/w3c/input-events/v1/index.html#interface-InputEvent
partial interface InputEvent
{
  [NeedsCallerType]
  readonly attribute DataTransfer? dataTransfer;
  // Enable `getTargetRanges()` only when `beforeinput` event is enabled
  // because this may be used for feature detection of `beforeinput` event
  // support (due to Chrome not supporting `onbeforeinput` attribute).
  sequence<StaticRange> getTargetRanges();
};

partial dictionary InputEventInit
{
  DataTransfer? dataTransfer = null;
  sequence<StaticRange> targetRanges = [];
};
 
/* ---------------------- InstallTrigger ----------------------------- */ 
/* ./webidl/InstallTrigger.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */


/**
 * A callback function that webpages can implement to be notified when triggered
 * installs complete.
 */
callback InstallTriggerCallback = undefined(DOMString url, short status);

dictionary InstallTriggerData {
  DOMString URL;
  DOMString? IconURL;
  DOMString? Hash;
};

/**
 * The interface for the InstallTrigger object available to all websites.
 */
[ChromeOnly,
 JSImplementation="@mozilla.org/addons/installtrigger;1",
 Exposed=Window]
interface InstallTriggerImpl {
  /**
   * Retained for backwards compatibility.
   */
  const unsigned short SKIN = 1;
  const unsigned short LOCALE = 2;
  const unsigned short CONTENT = 4;
  const unsigned short PACKAGE = 7;

  /**
   * Tests if installation is enabled.
   */
  boolean enabled();

  /**
   * Tests if installation is enabled.
   *
   * @deprecated Use "enabled" in the future.
   */
  boolean updateEnabled();

  /**
   * Starts a new installation of a set of add-ons.
   *
   * @param  aArgs
   *         The add-ons to install. This should be a JS object, each property
   *         is the name of an add-on to be installed. The value of the
   *         property should either be a string URL, or an object with the
   *         following properties:
   *          * URL for the add-on's URL
   *          * IconURL for an icon for the add-on
   *          * Hash for a hash of the add-on
   * @param  aCallback
   *         A callback to call as each installation succeeds or fails
   * @return true if the installations were successfully started
   */
  [Deprecated="InstallTriggerInstallDeprecated"]
  boolean install(record<DOMString, (DOMString or InstallTriggerData)> installs,
                  optional InstallTriggerCallback callback);

  /**
   * Starts installing a new add-on.
   *
   * @deprecated use "install" in the future.
   *
   * @param  aType
   *         Unused, retained for backwards compatibility
   * @param  aUrl
   *         The URL of the add-on
   * @param  aSkin
   *         Unused, retained for backwards compatibility
   * @return true if the installation was successfully started
   */
  [Deprecated="InstallTriggerInstallDeprecated"]
  boolean installChrome(unsigned short type, DOMString url, DOMString skin);

  /**
   * Starts installing a new add-on.
   *
   * @deprecated use "install" in the future.
   *
   * @param  aUrl
   *         The URL of the add-on
   * @param  aFlags
   *         Unused, retained for backwards compatibility
   * @return true if the installation was successfully started
   */
  [Deprecated="InstallTriggerInstallDeprecated"]
  boolean startSoftwareUpdate(DOMString url, optional unsigned short flags);
};
 
/* ---------------------- IntersectionObserver ----------------------------- */ 
/* ./webidl/IntersectionObserver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/IntersectionObserver/
 */

[ProbablyShortLivingWrapper, Exposed=Window]
interface IntersectionObserverEntry {
  [Constant]
  readonly attribute DOMHighResTimeStamp time;
  [Constant]
  readonly attribute DOMRectReadOnly? rootBounds;
  [Constant]
  readonly attribute DOMRectReadOnly boundingClientRect;
  [Constant]
  readonly attribute DOMRectReadOnly intersectionRect;
  [Constant]
  readonly attribute boolean isIntersecting;
  [Constant]
  readonly attribute double intersectionRatio;
  [Constant]
  readonly attribute Element target;
};

[Exposed=Window]
interface IntersectionObserver {
  [Throws]
  constructor(IntersectionCallback intersectionCallback,
              optional IntersectionObserverInit options = {});

  [Constant]
  readonly attribute Node? root;
  [Constant]
  readonly attribute UTF8String rootMargin;
  [Constant,Cached]
  readonly attribute sequence<double> thresholds;
  undefined observe(Element target);
  undefined unobserve(Element target);
  undefined disconnect();
  sequence<IntersectionObserverEntry> takeRecords();
};

callback IntersectionCallback =
  undefined (sequence<IntersectionObserverEntry> entries, IntersectionObserver observer);

dictionary IntersectionObserverEntryInit {
  required DOMHighResTimeStamp time;
  required DOMRectInit rootBounds;
  required DOMRectInit boundingClientRect;
  required DOMRectInit intersectionRect;
  required Element target;
};

dictionary IntersectionObserverInit {
  (Element or Document)? root = null;
  UTF8String rootMargin = "0px";
  (double or sequence<double>) threshold = 0;
};
 
/* ---------------------- IntlUtils ----------------------------- */ 
/* ./webidl/IntlUtils.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

[GenerateConversionToJS]
dictionary DisplayNameOptions {
  DOMString type;
  DOMString style;
  DOMString calendar;
  sequence<DOMString> keys;
};

[GenerateInit]
dictionary DisplayNameResult {
  DOMString locale;
  DOMString type;
  DOMString style;
  DOMString calendar;
  sequence<DOMString> values;
};

[GenerateInit]
dictionary LocaleInfo {
  DOMString locale;
  DOMString direction;
};

/**
 * The IntlUtils interface provides helper functions for localization.
 */
[LegacyNoInterfaceObject,
 Exposed=Window]
interface IntlUtils {
  /**
   * Helper function to retrieve the localized values for a list of requested
   * keys.
   *
   * The function takes two arguments - locales which is a list of locale
   * strings and options which is an object with four optional properties:
   *
   *   keys:
   *     an Array of string values to localize
   *
   *   type:
   *     a String with a value "language", "region", "script", "currency",
   *     "weekday", "month", "quarter", "dayPeriod", or "dateTimeField"
   *
   *   style:
   *     a String with a value "long", "abbreviated", "short", or "narrow"
   *
   *   calendar:
   *     a String to select a specific calendar type, e.g. "gregory"
   *
   * It returns an object with properties:
   *
   *   locale:
   *     a negotiated locale string
   *
   *   type:
   *     negotiated type
   *
   *   style:
   *     negotiated style
   *
   *   calendar:
   *     negotiated calendar
   *
   *   values:
   *     a list of translated values for the requested keys
   *
   */
  [Throws]
  DisplayNameResult getDisplayNames(sequence<DOMString> locales,
                                    optional DisplayNameOptions options = {});

  /**
   * Helper function to determine if the current application locale is RTL.
   *
   * The result of this function can be overriden by this pref:
   *  - `intl.l10n.pseudo`
   */
  boolean isAppLocaleRTL();
};
 
/* ---------------------- InvokeEvent ----------------------------- */ 
/* ./webidl/InvokeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://github.com/whatwg/html/pull/9841
 */

[Pref="dom.element.invokers.enabled",
 Exposed=Window]
interface InvokeEvent : Event {
    constructor(DOMString type, optional InvokeEventInit eventInitDict = {});
    readonly attribute Element? invoker;
    readonly attribute DOMString action;
};

dictionary InvokeEventInit : EventInit {
    Element? invoker = null;
    DOMString action = "auto";
};
 
/* ---------------------- InvokerElement ----------------------------- */ 
/* ./webidl/InvokerElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://github.com/whatwg/html/pull/9841
 */

interface mixin InvokerElement {
  [Pref="dom.element.invokers.enabled", CEReactions] attribute Element? invokeTargetElement;
  [Pref="dom.element.invokers.enabled", CEReactions] attribute DOMString invokeAction;
};
 
/* ---------------------- IterableIterator ----------------------------- */ 
/* ./webidl/IterableIterator.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[GenerateConversionToJS]
dictionary IterableKeyOrValueResult {
  any value;
  boolean done = false;
};

[GenerateConversionToJS]
dictionary IterableKeyAndValueResult {
  sequence<any> value = [];
  boolean done = false;
};
 
/* ---------------------- KeyAlgorithm ----------------------------- */ 
/* ./webidl/KeyAlgorithm.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/WebCryptoAPI/
 */

dictionary KeyAlgorithm {
  required DOMString name;
};

[GenerateConversionToJS]
dictionary AesKeyAlgorithm : KeyAlgorithm {
  required unsigned short length;
};

[GenerateConversionToJS]
dictionary EcKeyAlgorithm : KeyAlgorithm {
  required DOMString namedCurve;
};

[GenerateConversionToJS]
dictionary HmacKeyAlgorithm : KeyAlgorithm {
  required KeyAlgorithm hash;
  required unsigned long length;
};

[GenerateConversionToJS]
dictionary RsaHashedKeyAlgorithm : KeyAlgorithm {
  required unsigned short modulusLength;
  required Uint8Array publicExponent;
  required KeyAlgorithm hash;
};

[GenerateConversionToJS]
dictionary DhKeyAlgorithm : KeyAlgorithm {
  required Uint8Array prime;
  required Uint8Array generator;
};
 
/* ---------------------- KeyboardEvent ----------------------------- */ 
/* ./webidl/KeyboardEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface KeyboardEvent : UIEvent
{
  [BinaryName="constructorJS"]
  constructor(DOMString typeArg,
              optional KeyboardEventInit keyboardEventInitDict= {});

  [NeedsCallerType]
  readonly attribute unsigned long    charCode;
  [NeedsCallerType]
  readonly attribute unsigned long    keyCode;

  [NeedsCallerType]
  readonly attribute boolean          altKey;
  [NeedsCallerType]
  readonly attribute boolean          ctrlKey;
  [NeedsCallerType]
  readonly attribute boolean          shiftKey;
  readonly attribute boolean          metaKey;

  [NeedsCallerType]
  boolean getModifierState(DOMString key);

  const unsigned long DOM_KEY_LOCATION_STANDARD = 0x00;
  const unsigned long DOM_KEY_LOCATION_LEFT     = 0x01;
  const unsigned long DOM_KEY_LOCATION_RIGHT    = 0x02;
  const unsigned long DOM_KEY_LOCATION_NUMPAD   = 0x03;

  readonly attribute unsigned long location;
  readonly attribute boolean       repeat;
  readonly attribute boolean       isComposing;

  readonly attribute DOMString key;
  [NeedsCallerType]
  readonly attribute DOMString code;

  [BinaryName="initKeyboardEventJS"]
  undefined initKeyboardEvent(DOMString typeArg,
                              optional boolean bubblesArg = false,
                              optional boolean cancelableArg = false,
                              optional Window? viewArg = null,
                              optional DOMString keyArg = "",
                              optional unsigned long locationArg = 0,
                              optional boolean ctrlKey = false,
                              optional boolean altKey = false,
                              optional boolean shiftKey = false,
                              optional boolean metaKey = false);

  // This returns the initialized dictionary for generating a
  // same-type keyboard event
  [Cached, ChromeOnly, Constant]
  readonly attribute KeyboardEventInit initDict;
};

dictionary KeyboardEventInit : EventModifierInit
{
  [BinaryType="nsAutoString"]
  DOMString      key           = "";
  [BinaryType="nsAutoString"]
  DOMString      code          = "";
  unsigned long  location      = 0;
  boolean        repeat        = false;
  boolean        isComposing   = false;

  // legacy attributes
  unsigned long  charCode      = 0;
  unsigned long  keyCode       = 0;
  unsigned long  which         = 0;
};

// Mozilla extensions
KeyboardEvent includes KeyEventMixin;
 
/* ---------------------- KeyEvent ----------------------------- */ 
/* ./webidl/KeyEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

// http://www.w3.org/TR/1999/WD-DOM-Level-2-19990923/events.html#Events-KeyEvent
[Exposed=Window]
interface KeyEvent
{
  // It's all mixed in.
};
KeyEvent includes KeyEventMixin;

interface mixin KeyEventMixin {
  const unsigned long DOM_VK_CANCEL         = 0x03;
  const unsigned long DOM_VK_HELP           = 0x06;
  const unsigned long DOM_VK_BACK_SPACE     = 0x08;
  const unsigned long DOM_VK_TAB            = 0x09;
  const unsigned long DOM_VK_CLEAR          = 0x0C;
  const unsigned long DOM_VK_RETURN         = 0x0D;
  // DOM_VK_ENTER has been never used for representing native key events.
  // Therefore, it's removed for preventing developers being confused.
  // const unsigned long DOM_VK_ENTER          = 0x0E;
  const unsigned long DOM_VK_SHIFT          = 0x10;
  const unsigned long DOM_VK_CONTROL        = 0x11;
  const unsigned long DOM_VK_ALT            = 0x12;
  const unsigned long DOM_VK_PAUSE          = 0x13;
  const unsigned long DOM_VK_CAPS_LOCK      = 0x14;
  const unsigned long DOM_VK_KANA           = 0x15;
  const unsigned long DOM_VK_HANGUL         = 0x15;
  const unsigned long DOM_VK_EISU           = 0x16; // Japanese Mac keyboard only
  const unsigned long DOM_VK_JUNJA          = 0x17;
  const unsigned long DOM_VK_FINAL          = 0x18;
  const unsigned long DOM_VK_HANJA          = 0x19;
  const unsigned long DOM_VK_KANJI          = 0x19;
  const unsigned long DOM_VK_ESCAPE         = 0x1B;
  const unsigned long DOM_VK_CONVERT        = 0x1C;
  const unsigned long DOM_VK_NONCONVERT     = 0x1D;
  const unsigned long DOM_VK_ACCEPT         = 0x1E;
  const unsigned long DOM_VK_MODECHANGE     = 0x1F;
  const unsigned long DOM_VK_SPACE          = 0x20;
  const unsigned long DOM_VK_PAGE_UP        = 0x21;
  const unsigned long DOM_VK_PAGE_DOWN      = 0x22;
  const unsigned long DOM_VK_END            = 0x23;
  const unsigned long DOM_VK_HOME           = 0x24;
  const unsigned long DOM_VK_LEFT           = 0x25;
  const unsigned long DOM_VK_UP             = 0x26;
  const unsigned long DOM_VK_RIGHT          = 0x27;
  const unsigned long DOM_VK_DOWN           = 0x28;
  const unsigned long DOM_VK_SELECT         = 0x29;
  const unsigned long DOM_VK_PRINT          = 0x2A;
  const unsigned long DOM_VK_EXECUTE        = 0x2B;
  const unsigned long DOM_VK_PRINTSCREEN    = 0x2C;
  const unsigned long DOM_VK_INSERT         = 0x2D;
  const unsigned long DOM_VK_DELETE         = 0x2E;

  // DOM_VK_0 - DOM_VK_9 match their ascii values
  const unsigned long DOM_VK_0              = 0x30;
  const unsigned long DOM_VK_1              = 0x31;
  const unsigned long DOM_VK_2              = 0x32;
  const unsigned long DOM_VK_3              = 0x33;
  const unsigned long DOM_VK_4              = 0x34;
  const unsigned long DOM_VK_5              = 0x35;
  const unsigned long DOM_VK_6              = 0x36;
  const unsigned long DOM_VK_7              = 0x37;
  const unsigned long DOM_VK_8              = 0x38;
  const unsigned long DOM_VK_9              = 0x39;

  const unsigned long DOM_VK_COLON          = 0x3A;
  const unsigned long DOM_VK_SEMICOLON      = 0x3B;
  const unsigned long DOM_VK_LESS_THAN      = 0x3C;
  const unsigned long DOM_VK_EQUALS         = 0x3D;
  const unsigned long DOM_VK_GREATER_THAN   = 0x3E;
  const unsigned long DOM_VK_QUESTION_MARK  = 0x3F;
  const unsigned long DOM_VK_AT             = 0x40;

  // DOM_VK_A - DOM_VK_Z match their ascii values
  const unsigned long DOM_VK_A              = 0x41;
  const unsigned long DOM_VK_B              = 0x42;
  const unsigned long DOM_VK_C              = 0x43;
  const unsigned long DOM_VK_D              = 0x44;
  const unsigned long DOM_VK_E              = 0x45;
  const unsigned long DOM_VK_F              = 0x46;
  const unsigned long DOM_VK_G              = 0x47;
  const unsigned long DOM_VK_H              = 0x48;
  const unsigned long DOM_VK_I              = 0x49;
  const unsigned long DOM_VK_J              = 0x4A;
  const unsigned long DOM_VK_K              = 0x4B;
  const unsigned long DOM_VK_L              = 0x4C;
  const unsigned long DOM_VK_M              = 0x4D;
  const unsigned long DOM_VK_N              = 0x4E;
  const unsigned long DOM_VK_O              = 0x4F;
  const unsigned long DOM_VK_P              = 0x50;
  const unsigned long DOM_VK_Q              = 0x51;
  const unsigned long DOM_VK_R              = 0x52;
  const unsigned long DOM_VK_S              = 0x53;
  const unsigned long DOM_VK_T              = 0x54;
  const unsigned long DOM_VK_U              = 0x55;
  const unsigned long DOM_VK_V              = 0x56;
  const unsigned long DOM_VK_W              = 0x57;
  const unsigned long DOM_VK_X              = 0x58;
  const unsigned long DOM_VK_Y              = 0x59;
  const unsigned long DOM_VK_Z              = 0x5A;

  const unsigned long DOM_VK_WIN            = 0x5B;
  const unsigned long DOM_VK_CONTEXT_MENU   = 0x5D;
  const unsigned long DOM_VK_SLEEP          = 0x5F;

  // Numpad keys
  const unsigned long DOM_VK_NUMPAD0        = 0x60;
  const unsigned long DOM_VK_NUMPAD1        = 0x61;
  const unsigned long DOM_VK_NUMPAD2        = 0x62;
  const unsigned long DOM_VK_NUMPAD3        = 0x63;
  const unsigned long DOM_VK_NUMPAD4        = 0x64;
  const unsigned long DOM_VK_NUMPAD5        = 0x65;
  const unsigned long DOM_VK_NUMPAD6        = 0x66;
  const unsigned long DOM_VK_NUMPAD7        = 0x67;
  const unsigned long DOM_VK_NUMPAD8        = 0x68;
  const unsigned long DOM_VK_NUMPAD9        = 0x69;
  const unsigned long DOM_VK_MULTIPLY       = 0x6A;
  const unsigned long DOM_VK_ADD            = 0x6B;
  const unsigned long DOM_VK_SEPARATOR      = 0x6C;
  const unsigned long DOM_VK_SUBTRACT       = 0x6D;
  const unsigned long DOM_VK_DECIMAL        = 0x6E;
  const unsigned long DOM_VK_DIVIDE         = 0x6F;

  const unsigned long DOM_VK_F1             = 0x70;
  const unsigned long DOM_VK_F2             = 0x71;
  const unsigned long DOM_VK_F3             = 0x72;
  const unsigned long DOM_VK_F4             = 0x73;
  const unsigned long DOM_VK_F5             = 0x74;
  const unsigned long DOM_VK_F6             = 0x75;
  const unsigned long DOM_VK_F7             = 0x76;
  const unsigned long DOM_VK_F8             = 0x77;
  const unsigned long DOM_VK_F9             = 0x78;
  const unsigned long DOM_VK_F10            = 0x79;
  const unsigned long DOM_VK_F11            = 0x7A;
  const unsigned long DOM_VK_F12            = 0x7B;
  const unsigned long DOM_VK_F13            = 0x7C;
  const unsigned long DOM_VK_F14            = 0x7D;
  const unsigned long DOM_VK_F15            = 0x7E;
  const unsigned long DOM_VK_F16            = 0x7F;
  const unsigned long DOM_VK_F17            = 0x80;
  const unsigned long DOM_VK_F18            = 0x81;
  const unsigned long DOM_VK_F19            = 0x82;
  const unsigned long DOM_VK_F20            = 0x83;
  const unsigned long DOM_VK_F21            = 0x84;
  const unsigned long DOM_VK_F22            = 0x85;
  const unsigned long DOM_VK_F23            = 0x86;
  const unsigned long DOM_VK_F24            = 0x87;

  const unsigned long DOM_VK_NUM_LOCK       = 0x90;
  const unsigned long DOM_VK_SCROLL_LOCK    = 0x91;

  // OEM specific virtual keyCode of Windows should pass through DOM keyCode
  // for compatibility with the other web browsers on Windows.
  const unsigned long DOM_VK_WIN_OEM_FJ_JISHO   = 0x92;
  const unsigned long DOM_VK_WIN_OEM_FJ_MASSHOU = 0x93;
  const unsigned long DOM_VK_WIN_OEM_FJ_TOUROKU = 0x94;
  const unsigned long DOM_VK_WIN_OEM_FJ_LOYA    = 0x95;
  const unsigned long DOM_VK_WIN_OEM_FJ_ROYA    = 0x96;

  const unsigned long DOM_VK_CIRCUMFLEX     = 0xA0;
  const unsigned long DOM_VK_EXCLAMATION    = 0xA1;
  const unsigned long DOM_VK_DOUBLE_QUOTE   = 0xA2;
  const unsigned long DOM_VK_HASH           = 0xA3;
  const unsigned long DOM_VK_DOLLAR         = 0xA4;
  const unsigned long DOM_VK_PERCENT        = 0xA5;
  const unsigned long DOM_VK_AMPERSAND      = 0xA6;
  const unsigned long DOM_VK_UNDERSCORE     = 0xA7;
  const unsigned long DOM_VK_OPEN_PAREN     = 0xA8;
  const unsigned long DOM_VK_CLOSE_PAREN    = 0xA9;
  const unsigned long DOM_VK_ASTERISK       = 0xAA;
  const unsigned long DOM_VK_PLUS           = 0xAB;
  const unsigned long DOM_VK_PIPE           = 0xAC;
  const unsigned long DOM_VK_HYPHEN_MINUS   = 0xAD;

  const unsigned long DOM_VK_OPEN_CURLY_BRACKET  = 0xAE;
  const unsigned long DOM_VK_CLOSE_CURLY_BRACKET = 0xAF;

  const unsigned long DOM_VK_TILDE          = 0xB0;

  const unsigned long DOM_VK_VOLUME_MUTE    = 0xB5;
  const unsigned long DOM_VK_VOLUME_DOWN    = 0xB6;
  const unsigned long DOM_VK_VOLUME_UP      = 0xB7;

  const unsigned long DOM_VK_COMMA          = 0xBC;
  const unsigned long DOM_VK_PERIOD         = 0xBE;
  const unsigned long DOM_VK_SLASH          = 0xBF;
  const unsigned long DOM_VK_BACK_QUOTE     = 0xC0;
  const unsigned long DOM_VK_OPEN_BRACKET   = 0xDB; // square bracket
  const unsigned long DOM_VK_BACK_SLASH     = 0xDC;
  const unsigned long DOM_VK_CLOSE_BRACKET  = 0xDD; // square bracket
  const unsigned long DOM_VK_QUOTE          = 0xDE; // Apostrophe

  const unsigned long DOM_VK_META           = 0xE0;
  const unsigned long DOM_VK_ALTGR          = 0xE1;

  // OEM specific virtual keyCode of Windows should pass through DOM keyCode
  // for compatibility with the other web browsers on Windows.
  const unsigned long DOM_VK_WIN_ICO_HELP    = 0xE3;
  const unsigned long DOM_VK_WIN_ICO_00      = 0xE4;

  // IME processed key.
  const unsigned long DOM_VK_PROCESSKEY      = 0xE5;

  // OEM specific virtual keyCode of Windows should pass through DOM keyCode
  // for compatibility with the other web browsers on Windows.
  const unsigned long DOM_VK_WIN_ICO_CLEAR   = 0xE6;
  const unsigned long DOM_VK_WIN_OEM_RESET   = 0xE9;
  const unsigned long DOM_VK_WIN_OEM_JUMP    = 0xEA;
  const unsigned long DOM_VK_WIN_OEM_PA1     = 0xEB;
  const unsigned long DOM_VK_WIN_OEM_PA2     = 0xEC;
  const unsigned long DOM_VK_WIN_OEM_PA3     = 0xED;
  const unsigned long DOM_VK_WIN_OEM_WSCTRL  = 0xEE;
  const unsigned long DOM_VK_WIN_OEM_CUSEL   = 0xEF;
  const unsigned long DOM_VK_WIN_OEM_ATTN    = 0xF0;
  const unsigned long DOM_VK_WIN_OEM_FINISH  = 0xF1;
  const unsigned long DOM_VK_WIN_OEM_COPY    = 0xF2;
  const unsigned long DOM_VK_WIN_OEM_AUTO    = 0xF3;
  const unsigned long DOM_VK_WIN_OEM_ENLW    = 0xF4;
  const unsigned long DOM_VK_WIN_OEM_BACKTAB = 0xF5;

  // Following keys are not used on most keyboards.  However, for compatibility
  // with other browsers on Windows, we should define them.
  const unsigned long DOM_VK_ATTN           = 0xF6;
  const unsigned long DOM_VK_CRSEL          = 0xF7;
  const unsigned long DOM_VK_EXSEL          = 0xF8;
  const unsigned long DOM_VK_EREOF          = 0xF9;
  const unsigned long DOM_VK_PLAY           = 0xFA;
  const unsigned long DOM_VK_ZOOM           = 0xFB;
  const unsigned long DOM_VK_PA1            = 0xFD;

  // OEM specific virtual keyCode of Windows should pass through DOM keyCode
  // for compatibility with the other web browsers on Windows.
  const unsigned long DOM_VK_WIN_OEM_CLEAR  = 0xFE;

  [BinaryName="initKeyEventJS", Func="KeyboardEvent::IsInitKeyEventAvailable"]
  undefined initKeyEvent(DOMString type,
                         optional boolean canBubble = false,
                         optional boolean cancelable = false,
                         optional Window? view = null,
                         optional boolean ctrlKey = false,
                         optional boolean altKey = false,
                         optional boolean shiftKey = false,
                         optional boolean metaKey = false,
                         optional unsigned long keyCode = 0,
                         optional unsigned long charCode = 0);
};
 
/* ---------------------- KeyframeAnimationOptions ----------------------------- */ 
/* ./webidl/KeyframeAnimationOptions.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/fxtf/web-animations/#the-animatable-interface
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// This typedef is off in its own file, because of bug 995352.
typedef (unrestricted double or KeyframeAnimationOptions) UnrestrictedDoubleOrKeyframeAnimationOptions;
 
/* ---------------------- KeyframeEffect ----------------------------- */ 
/* ./webidl/KeyframeEffect.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/web-animations/#the-keyframeeffect-interfaces
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum IterationCompositeOperation {
  "replace",
  "accumulate"
};

dictionary KeyframeEffectOptions : EffectTiming {
  [Pref="dom.animations-api.compositing.enabled"]
  IterationCompositeOperation iterationComposite = "replace";
  [Pref="dom.animations-api.compositing.enabled"]
  CompositeOperation          composite = "replace";
  DOMString?                  pseudoElement = null;
};

// KeyframeEffect should run in the caller's compartment to do custom
// processing on the `keyframes` object.
[RunConstructorInCallerCompartment, Exposed=Window]
interface KeyframeEffect : AnimationEffect {
  [Throws]
  constructor(Element? target,
              object? keyframes,
              optional (unrestricted double or KeyframeEffectOptions) options = {});
  [Throws]
  constructor(KeyframeEffect source);

  attribute Element?                  target;
  [SetterThrows] attribute DOMString? pseudoElement;
  [Pref="dom.animations-api.compositing.enabled"]
  attribute IterationCompositeOperation     iterationComposite;
  [Pref="dom.animations-api.compositing.enabled"]
  attribute CompositeOperation              composite;
  [Throws] sequence<object> getKeyframes();
  [Throws] undefined        setKeyframes(object? keyframes);
};

// Non-standard extensions
dictionary AnimationPropertyValueDetails {
  required double             offset;
           UTF8String         value;
           UTF8String         easing;
  required CompositeOperation composite;
};

dictionary AnimationPropertyDetails {
  required DOMString                               property;
  required boolean                                 runningOnCompositor;
           DOMString                               warning;
  required sequence<AnimationPropertyValueDetails> values;
};

partial interface KeyframeEffect {
  [ChromeOnly, Throws] sequence<AnimationPropertyDetails> getProperties();
};
 
/* ---------------------- KeyIdsInitData ----------------------------- */ 
/* ./webidl/KeyIdsInitData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

// "KeyIds" EME init data format definition/parser, as defined by
// https://w3c.github.io/encrypted-media/format-registry/initdata/keyids.html
[GenerateInitFromJSON]
dictionary KeyIdsInitData {
  required sequence<DOMString> kids;
};
 
/* ---------------------- LinkStyle ----------------------------- */ 
/* ./webidl/LinkStyle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/cssom/#the-linkstyle-interface
 */

interface mixin LinkStyle {
  [BinaryName="sheetForBindings"] readonly attribute StyleSheet? sheet;
};
 
/* ---------------------- Localization ----------------------------- */ 
/* ./webidl/Localization.webidl */ 
 
/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * L10nIdArgs is an object used to carry localization tuple for message
 * translation.
 *
 * Fields:
 *    id - identifier of a message.
 *  args - an optional record of arguments used to format the message.
 *         The argument will be converted to/from JSON, and the API
 *         will only handle strings and numbers.
 */
dictionary L10nIdArgs {
  UTF8String? id = null;
  L10nArgs? args = null;
};

/**
 * When no arguments are required to format a message a simple string can be
 * used instead.
 */
typedef (UTF8String or L10nIdArgs) L10nKey;

/**
 * L10nMessage is a compound translation unit from Fluent which
 * encodes the value and (optionally) a list of attributes used
 * to translate a given widget.
 *
 * Most simple imperative translations will only use the `value`,
 * but when building a Message for a UI widget, a combination
 * of a value and attributes will be used.
 */
dictionary AttributeNameValue {
  required UTF8String name;
  required UTF8String value;
};

dictionary L10nMessage {
  UTF8String? value = null;
  sequence<AttributeNameValue>? attributes = null;
};

/**
 * Localization is an implementation of the Fluent Localization API.
 *
 * An instance of a Localization class stores a state of a mix
 * of localization resources and provides the API to resolve
 * translation value for localization identifiers from the
 * resources.
 *
 * Methods:
 *    - addResourceIds     - add resources
 *    - removeResourceIds  - remove resources
 *    - formatValue        - format a single value
 *    - formatValues       - format multiple values
 *    - formatMessages     - format multiple compound messages
 *
 */
[Func="IsChromeOrUAWidget", Exposed=Window]
interface Localization {
  /**
   * Constructor arguments:
   *    - aResourceids         - a list of localization resource URIs
   *                             which will provide messages for this
   *                             Localization instance.
   *    - aSync                - Specifies if the initial state of the Localization API is synchronous.
   *                             This enables a number of synchronous methods on the
   *                             Localization API.
   *    - aRegistry            - optional custom L10nRegistry to be used by this Localization instance.
   *    - aLocales             - custom set of locales to be used for this Localization.
   */
  [Throws]
  constructor(sequence<L10nResourceId> aResourceIds,
              optional boolean aSync = false,
              optional L10nRegistry aRegistry,
              optional sequence<UTF8String> aLocales);

  /**
   * A method for adding resources to the localization context.
   */
  undefined addResourceIds(sequence<L10nResourceId> aResourceIds);

  /**
   * A method for removing resources from the localization context.
   *
   * Returns a new count of resources used by the context.
   */
  unsigned long removeResourceIds(sequence<L10nResourceId> aResourceIds);

  /**
   * Formats a value of a localization message with a given id.
   * An optional dictionary of arguments can be passed to inform
   * the message formatting logic.
   *
   * Example:
   *    let value = await document.l10n.formatValue("unread-emails", {count: 5});
   *    assert.equal(value, "You have 5 unread emails");
   */
  [NewObject] Promise<UTF8String?> formatValue(UTF8String aId, optional L10nArgs aArgs);

  /**
   * Formats values of a list of messages with given ids.
   *
   * Example:
   *    let values = await document.l10n.formatValues([
   *      {id: "hello-world"},
   *      {id: "unread-emails", args: {count: 5}
   *    ]);
   *    assert.deepEqual(values, [
   *      "Hello World",
   *      "You have 5 unread emails"
   *    ]);
   */
  [NewObject] Promise<sequence<UTF8String?>> formatValues(sequence<L10nKey> aKeys);

  /**
   * Formats values and attributes of a list of messages with given ids.
   *
   * Example:
   *    let values = await document.l10n.formatMessages([
   *      {id: "hello-world"},
   *      {id: "unread-emails", args: {count: 5}
   *    ]);
   *    assert.deepEqual(values, [
   *      {
   *        value: "Hello World",
   *        attributes: null
   *      },
   *      {
   *        value: "You have 5 unread emails",
   *        attributes: {
   *          tooltip: "Click to select them all"
   *        }
   *      }
   *    ]);
   */
  [NewObject] Promise<sequence<L10nMessage?>> formatMessages(sequence<L10nKey> aKeys);

  undefined setAsync();

  [NewObject, Throws]
  UTF8String? formatValueSync(UTF8String aId, optional L10nArgs aArgs);
  [NewObject, Throws]
  sequence<UTF8String?> formatValuesSync(sequence<L10nKey> aKeys);
  [NewObject, Throws]
  sequence<L10nMessage?> formatMessagesSync(sequence<L10nKey> aKeys);
};

/**
 * A helper dict for converting between JS Value and L10nArgs.
 */
[GenerateInitFromJSON, GenerateConversionToJS]
dictionary L10nArgsHelperDict {
  required L10nArgs args;
};
 
/* ---------------------- Location ----------------------------- */ 
/* ./webidl/Location.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/history.html#the-location-interface
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[LegacyUnforgeable,
 Exposed=Window,
 InstrumentedProps=(ancestorOrigins)]
interface Location {
  [Throws, CrossOriginWritable, NeedsSubjectPrincipal]
  stringifier attribute USVString href;
  [Throws, NeedsSubjectPrincipal]
  readonly attribute USVString origin;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString protocol;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString host;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString hostname;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString port;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString pathname;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString search;
  [Throws, NeedsSubjectPrincipal]
           attribute USVString hash;

  [Throws, NeedsSubjectPrincipal]
  undefined assign(USVString url);

  [Throws, CrossOriginCallable, NeedsSubjectPrincipal]
  undefined replace(USVString url);

  // XXXbz there is no forceget argument in the spec!  See bug 1037721.
  [Throws, NeedsSubjectPrincipal]
  undefined reload(optional boolean forceget = false);

  // Bug 1085214 [SameObject] readonly attribute USVString[] ancestorOrigins;
};
 
/* ---------------------- Lock ----------------------------- */ 
/* ./webidl/Lock.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/web-locks/
 */

[SecureContext, Exposed=(Window,Worker)]
interface Lock {
  readonly attribute DOMString name;
  readonly attribute LockMode mode;
};
 
/* ---------------------- LockManager ----------------------------- */ 
/* ./webidl/LockManager.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/web-locks/
 */

[SecureContext, Exposed=(Window,Worker)]
interface LockManager {
  [NewObject]
  Promise<any> request(DOMString name,
                       LockGrantedCallback callback);
  [NewObject]
  Promise<any> request(DOMString name,
                       LockOptions options,
                       LockGrantedCallback callback);

  [NewObject]
  Promise<LockManagerSnapshot> query();
};

callback LockGrantedCallback = Promise<any> (Lock? lock);

enum LockMode { "shared", "exclusive" };

dictionary LockOptions {
  LockMode mode = "exclusive";
  boolean ifAvailable = false;
  boolean steal = false;
  AbortSignal signal;
};

dictionary LockManagerSnapshot {
  sequence<LockInfo> held;
  sequence<LockInfo> pending;
};

dictionary LockInfo {
  DOMString name;
  LockMode mode;
  DOMString clientId;
};
 
/* ---------------------- MathMLElement ----------------------------- */ 
/* ./webidl/MathMLElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://mathml-refresh.github.io/mathml-core/
 *
 * Copyright © 2019 W3C® (MIT, ERCIM, Keio, Beihang). W3C liability, trademark
 * and permissive document license rules apply.
 */

[Exposed=Window]
interface MathMLElement : Element { };
MathMLElement includes GlobalEventHandlers;
MathMLElement includes HTMLOrForeignElement;
MathMLElement includes ElementCSSInlineStyle;
MathMLElement includes TouchEventHandlers;
MathMLElement includes OnErrorEventHandlerForNodes;
 
/* ---------------------- MediaCapabilities ----------------------------- */ 
/* ./webidl/MediaCapabilities.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/media-capabilities/
 *
 * Copyright © 2018 the Contributors to the Media Capabilities Specification
 */

dictionary MediaConfiguration {
  VideoConfiguration video;
  AudioConfiguration audio;
};

dictionary MediaDecodingConfiguration : MediaConfiguration {
  required MediaDecodingType type;
};

dictionary MediaEncodingConfiguration : MediaConfiguration {
  required MediaEncodingType type;
};

enum MediaDecodingType {
  "file",
  "media-source",
};

enum MediaEncodingType {
  "record",
  "transmission"
};

dictionary VideoConfiguration {
  required DOMString contentType;
  required unsigned long width;
  required unsigned long height;
  required unsigned long long bitrate;
  required double framerate;
  boolean hasAlphaChannel;
  HdrMetadataType hdrMetadataType;
  ColorGamut colorGamut;
  TransferFunction transferFunction;
  DOMString scalabilityMode;
};

enum HdrMetadataType {
  "smpteSt2086",
  "smpteSt2094-10",
  "smpteSt2094-40"
};

enum ColorGamut {
  "srgb",
  "p3",
  "rec2020"
};

enum TransferFunction {
  "srgb",
  "pq",
  "hlg"
};

dictionary AudioConfiguration {
  required DOMString contentType;
  DOMString channels;
  unsigned long long bitrate;
  unsigned long samplerate;
};

[Exposed=(Window, Worker), Func="mozilla::dom::MediaCapabilities::Enabled",
 HeaderFile="mozilla/dom/MediaCapabilities.h"]
interface MediaCapabilitiesInfo {
  readonly attribute boolean supported;
  readonly attribute boolean smooth;
  readonly attribute boolean powerEfficient;
};

[Exposed=(Window, Worker), Func="mozilla::dom::MediaCapabilities::Enabled"]
interface MediaCapabilities {
  [NewObject]
  Promise<MediaCapabilitiesInfo> decodingInfo(MediaDecodingConfiguration configuration);
  [NewObject]
  Promise<MediaCapabilitiesInfo> encodingInfo(MediaEncodingConfiguration configuration);
};
 
/* ---------------------- MediaDebugInfo ----------------------------- */ 
/* ./webidl/MediaDebugInfo.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * This module defines dictonaries that are filled with debug information
 * through GetDebugInfo() calls in the media component. To get the information
 * filled and returned, we have two methods that return promises, one in
 * HTMLMediaElement and one in MediaSource.
 *
 * If you need to add some extra info, there's one dictionary per class,
 * following the pattern <ClassName>DebugInfo, where you can add some fields
 * and fill them in the corresponding GetDebugInfo() call.
 *
 * Below is the structures returned.
 *
 * Used by HTMLMediaElement.GetMozRequestDebugInfo(), see HTMLMediaElement.webidl:
 *
 * HTMLMediaElementDebugInfo
 *   EMEDebugInfo
 *   MediaDecoderDebugInfo
 *     MediaFormatReaderDebugInfo
 *       MediaStateDebugInfo
 *       MediaStateDebugInfo
 *       MediaFrameStats
 *     MediaDecoderStateMachineDebugInfo
 *       MediaDecoderStateMachineDecodingStateDebugInfo
 *       MediaSinkDebugInfo
 *         VideoSinkDebugInfo
 *         AudioSinkDebugInfo
 *         DecodedStreamDebugInfo
 *           DecodedStreamDataDebugInfo
 *     MediaResourceDebugInfo
 *       MediaCacheStreamDebugInfo
 *
 * Used by MediaSource.GetMozDebugReaderData(), see MediaSource.webidl:
 *
 * MediaSourceDecoderDebugInfo
 *  MediaFormatReaderDebugInfo
 *    MediaStateDebugInfo
 *    MediaStateDebugInfo
 *    MediaFrameStats
 *  MediaSourceDemuxerDebugInfo
 *    TrackBuffersManagerDebugInfo
 *    TrackBuffersManagerDebugInfo
 */
dictionary MediaCacheStreamDebugInfo {
  long long streamLength = 0;
  long long channelOffset = 0;
  boolean cacheSuspended = false;
  boolean channelEnded = false;
  long loadID = 0;
};

dictionary MediaResourceDebugInfo {
  MediaCacheStreamDebugInfo cacheStream = {};
};

dictionary MediaDecoderDebugInfo {
  DOMString instance = "";
  unsigned long channels = 0;
  unsigned long rate = 0;
  boolean hasAudio = false;
  boolean hasVideo = false;
  DOMString PlayState = "";
  DOMString containerType = "";
  MediaFormatReaderDebugInfo reader = {};
  MediaDecoderStateMachineDebugInfo stateMachine = {};
  MediaResourceDebugInfo resource = {};
};

dictionary AudioSinkDebugInfo {
  long long startTime = 0;
  long long lastGoodPosition = 0;
  boolean isPlaying = false;
  boolean isStarted = false;
  boolean audioEnded = false;
  unsigned long outputRate = 0;
  long long written = 0;
  boolean hasErrored = false;
  boolean playbackComplete = false;
};

dictionary AudioSinkWrapperDebugInfo {
  boolean isPlaying = false;
  boolean isStarted = false;
  boolean audioEnded = false;
  AudioSinkDebugInfo audioSink = {};
};

dictionary VideoSinkDebugInfo {
  boolean isStarted = false;
  boolean isPlaying = false;
  boolean finished = false;
  long size = 0;
  long long videoFrameEndTime = 0;
  boolean hasVideo = false;
  boolean videoSinkEndRequestExists = false;
  boolean endPromiseHolderIsEmpty = false;
};

dictionary DecodedStreamDataDebugInfo {
  DOMString instance = "";
  long long audioFramesWritten = 0;
  long long streamAudioWritten = 0;
  long long streamVideoWritten = 0;
  long long nextAudioTime = 0;
  long long lastVideoStartTime = 0;
  long long lastVideoEndTime = 0;
  boolean haveSentFinishAudio = false;
  boolean haveSentFinishVideo = false;
};

dictionary DecodedStreamDebugInfo {
  DOMString instance = "";
  long long startTime = 0;
  long long lastOutputTime = 0;
  long playing = 0;
  long long lastAudio = 0;
  boolean audioQueueFinished = false;
  long audioQueueSize = 0;
  DecodedStreamDataDebugInfo data = {};
};

dictionary MediaSinkDebugInfo {
  AudioSinkWrapperDebugInfo audioSinkWrapper = {};
  VideoSinkDebugInfo videoSink = {};
  DecodedStreamDebugInfo decodedStream = {};
};

dictionary MediaDecoderStateMachineDecodingStateDebugInfo {
  boolean isPrerolling = false;
};

dictionary MediaDecoderStateMachineDebugInfo {
  long long duration = 0;
  long long mediaTime = 0;
  long long clock = 0;
  DOMString state = "";
  long playState = 0;
  boolean sentFirstFrameLoadedEvent = false;
  boolean isPlaying = false;
  DOMString audioRequestStatus = "";
  DOMString videoRequestStatus = "";
  long long decodedAudioEndTime = 0;
  long long decodedVideoEndTime = 0;
  boolean audioCompleted = false;
  boolean videoCompleted = false;
  MediaDecoderStateMachineDecodingStateDebugInfo stateObj = {};
  MediaSinkDebugInfo mediaSink = {};
  double totalBufferingTimeMs = 0;
};

dictionary MediaStateDebugInfo {
  boolean needInput = false;
  boolean hasPromise = false;
  boolean waitingPromise = false;
  boolean hasDemuxRequest = false;
  long demuxQueueSize = 0;
  boolean hasDecoder = false;
  double timeTreshold = 0.0;
  boolean timeTresholdHasSeeked = false;
  long long numSamplesInput = 0;
  long long numSamplesOutput = 0;
  long queueSize = 0;
  long pending = 0;
  boolean waitingForData = false;
  long demuxEOS = 0;
  long drainState = 0;
  boolean waitingForKey = false;
  long long lastStreamSourceID = 0;
};

dictionary MediaFrameStats {
  long long droppedDecodedFrames = 0;
  long long droppedSinkFrames = 0;
  long long droppedCompositorFrames = 0;
};

dictionary MediaFormatReaderDebugInfo {
  DOMString videoType = "";
  DOMString videoDecoderName = "";
  long videoWidth = 0;
  long videoHeight = 0;
  double videoRate = 0.0;
  DOMString audioType = "";
  DOMString audioDecoderName = "";
  boolean videoHardwareAccelerated = false;
  long long videoNumSamplesOutputTotal = 0;
  long long videoNumSamplesSkippedTotal = 0;
  long audioChannels = 0;
  double audioRate = 0.0;
  long long audioFramesDecoded = 0;
  MediaStateDebugInfo audioState = {};
  MediaStateDebugInfo videoState = {};
  MediaFrameStats frameStats = {};
  double totalReadMetadataTimeMs = 0.0;
  double totalWaitingForVideoDataTimeMs = 0.0;
};

dictionary BufferRange {
  double start = 0;
  double end = 0;
};

dictionary TrackBuffersManagerDebugInfo {
  DOMString type = "";
  double nextSampleTime = 0.0;
  long numSamples = 0;
  long bufferSize = 0;
  long evictable = 0;
  long nextGetSampleIndex = 0;
  long nextInsertionIndex = 0;
  sequence<BufferRange> ranges = [];
};

dictionary MediaSourceDemuxerDebugInfo {
  TrackBuffersManagerDebugInfo audioTrack = {};
  TrackBuffersManagerDebugInfo videoTrack = {};
};

dictionary MediaSourceDecoderDebugInfo {
  MediaFormatReaderDebugInfo reader = {};
  MediaSourceDemuxerDebugInfo demuxer = {};
};

dictionary EMEDebugInfo {
  DOMString keySystem = "";
  DOMString sessionsInfo = "";
};

dictionary HTMLMediaElementDebugInfo {
  unsigned long compositorDroppedFrames = 0;
  EMEDebugInfo EMEInfo = {};
  MediaDecoderDebugInfo decoder = {};
};
 
/* ---------------------- MediaDeviceInfo ----------------------------- */ 
/* ./webidl/MediaDeviceInfo.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/getusermedia.html
 */

enum MediaDeviceKind {
  "audioinput",
  "audiooutput",
  "videoinput"
};

[Func="Navigator::HasUserMediaSupport",
 Exposed=Window]
interface MediaDeviceInfo {
  readonly attribute DOMString       deviceId;
  readonly attribute MediaDeviceKind kind;
  readonly attribute DOMString       label;
  readonly attribute DOMString       groupId;

  [Default] object toJSON();
};
 
/* ---------------------- MediaDevices ----------------------------- */ 
/* ./webidl/MediaDevices.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/getusermedia.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Func="Navigator::HasUserMediaSupport",
 Exposed=Window]
interface MediaDevices : EventTarget {
  [Pref="media.ondevicechange.enabled"]
  attribute EventHandler ondevicechange;
  MediaTrackSupportedConstraints getSupportedConstraints();

  [NewObject, UseCounter]
  Promise<sequence<MediaDeviceInfo>> enumerateDevices();

  [NewObject, NeedsCallerType, UseCounter]
  Promise<MediaStream> getUserMedia(optional MediaStreamConstraints constraints = {});

  // We need [SecureContext] in case media.devices.insecure.enabled = true
  // because we don't want that legacy pref to expose this newer method.
  [SecureContext, Pref="media.getdisplaymedia.enabled", NewObject, NeedsCallerType, UseCounter]
  Promise<MediaStream> getDisplayMedia(optional DisplayMediaStreamConstraints constraints = {});
};

// https://w3c.github.io/mediacapture-output/#audiooutputoptions-dictionary
dictionary AudioOutputOptions {
  DOMString deviceId = "";
};
// https://w3c.github.io/mediacapture-output/#mediadevices-extensions
partial interface MediaDevices {
  [SecureContext, Pref="media.setsinkid.enabled", NewObject, NeedsCallerType]
  Promise<MediaDeviceInfo> selectAudioOutput(optional AudioOutputOptions options = {});
};
 
/* ---------------------- MediaElementAudioSourceNode ----------------------------- */ 
/* ./webidl/MediaElementAudioSourceNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary MediaElementAudioSourceOptions {
    required HTMLMediaElement mediaElement;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface MediaElementAudioSourceNode : AudioNode {
  [Throws]
  constructor(AudioContext context, MediaElementAudioSourceOptions options);

  readonly attribute HTMLMediaElement mediaElement;
};

// Mozilla extensions
MediaElementAudioSourceNode includes AudioNodePassThrough;
 
/* ---------------------- MediaEncryptedEvent ----------------------------- */ 
/* ./webidl/MediaEncryptedEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface MediaEncryptedEvent : Event {
  [Throws]
  constructor(DOMString type,
              optional MediaKeyNeededEventInit eventInitDict = {});

  readonly attribute DOMString initDataType;
  [Throws]
  readonly attribute ArrayBuffer? initData;
};

dictionary MediaKeyNeededEventInit : EventInit {
  DOMString initDataType = "";
  ArrayBuffer? initData = null;
};
 
/* ---------------------- MediaError ----------------------------- */ 
/* ./webidl/MediaError.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/html/#mediaerror
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface MediaError {
  // Keep these constants in sync with the ones defined in HTMLMediaElement.h
  const unsigned short MEDIA_ERR_ABORTED = 1;
  const unsigned short MEDIA_ERR_NETWORK = 2;
  const unsigned short MEDIA_ERR_DECODE = 3;
  const unsigned short MEDIA_ERR_SRC_NOT_SUPPORTED = 4;

  [Constant]
  readonly attribute unsigned short code;
  readonly attribute DOMString message;
};
 
/* ---------------------- MediaKeyError ----------------------------- */ 
/* ./webidl/MediaKeyError.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

// According to the spec, "The future of error events and MediaKeyError
// is uncertain."
// https://www.w3.org/Bugs/Public/show_bug.cgi?id=21798
[Exposed=Window]
interface MediaKeyError : Event {
  readonly attribute unsigned long systemCode;
};
 
/* ---------------------- MediaKeyMessageEvent ----------------------------- */ 
/* ./webidl/MediaKeyMessageEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

enum MediaKeyMessageType {
  "license-request",
  "license-renewal",
  "license-release",
  "individualization-request"
};

[Exposed=Window]
interface MediaKeyMessageEvent : Event {
  [Throws]
  constructor(DOMString type, MediaKeyMessageEventInit eventInitDict);

  readonly attribute MediaKeyMessageType messageType;
  [Throws]
  readonly attribute ArrayBuffer message;
};

dictionary MediaKeyMessageEventInit : EventInit {
  required MediaKeyMessageType messageType;
  required ArrayBuffer message;
};
 
/* ---------------------- MediaKeys ----------------------------- */ 
/* ./webidl/MediaKeys.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

// Note: "persistent-usage-record" session type is unsupported yet, as
// it's marked as "at risk" in the spec, and Chrome doesn't support it.
enum MediaKeySessionType {
  "temporary",
  "persistent-license",
  // persistent-usage-record,
};

// https://w3c.github.io/encrypted-media/#idl-def-hdcpversion
enum HDCPVersion {
    "1.0",
    "1.1",
    "1.2",
    "1.3",
    "1.4",
    "2.0",
    "2.1",
    "2.2",
    "2.3",
};

// https://w3c.github.io/encrypted-media/#idl-def-mediakeyspolicy
dictionary MediaKeysPolicy {
  HDCPVersion minHdcpVersion;
};

[Exposed=Window]
interface MediaKeys {
  readonly attribute DOMString keySystem;

  [NewObject, Throws]
  MediaKeySession createSession(optional MediaKeySessionType sessionType = "temporary");

  [NewObject]
  Promise<undefined> setServerCertificate(BufferSource serverCertificate);

  [Pref="media.eme.hdcp-policy-check.enabled", NewObject]
  Promise<MediaKeyStatus> getStatusForPolicy(optional MediaKeysPolicy policy = {});
};
 
/* ---------------------- MediaKeySession ----------------------------- */ 
/* ./webidl/MediaKeySession.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface MediaKeySession : EventTarget {
  // error state
  readonly attribute MediaKeyError? error;

  // session properties
  readonly attribute DOMString sessionId;

  readonly attribute unrestricted double expiration;

  readonly attribute Promise<undefined> closed;

  readonly attribute MediaKeyStatusMap keyStatuses;

  attribute EventHandler onkeystatuseschange;

  attribute EventHandler onmessage;

  [NewObject]
  Promise<undefined> generateRequest(DOMString initDataType, BufferSource initData);

  [NewObject]
  Promise<boolean> load(DOMString sessionId);

  // session operations
  [NewObject]
  Promise<undefined> update(BufferSource response);

  [NewObject]
  Promise<undefined> close();

  [NewObject]
  Promise<undefined> remove();
};
 
/* ---------------------- MediaKeysRequestStatus ----------------------------- */ 
/* ./webidl/MediaKeysRequestStatus.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

enum MediaKeySystemStatus {
  "available",
  "api-disabled",
  "cdm-disabled",
  "cdm-not-supported",
  "cdm-not-installed",
  "cdm-created",
};

/* Note: This dictionary and enum is only used by Gecko to convey messages
 * to chrome JS code. It is not exposed to the web.
 */
[GenerateToJSON]
dictionary RequestMediaKeySystemAccessNotification {
  required DOMString keySystem;
  required MediaKeySystemStatus status;
};
 
/* ---------------------- MediaKeyStatusMap ----------------------------- */ 
/* ./webidl/MediaKeyStatusMap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

enum MediaKeyStatus {
  "usable",
  "expired",
  "released",
  "output-restricted",
  "output-downscaled",
  "status-pending",
  "internal-error"
};

[Exposed=Window]
interface MediaKeyStatusMap {
  iterable<ArrayBuffer,MediaKeyStatus>;
  readonly attribute unsigned long size;
  boolean has (BufferSource keyId);
  [Throws]
  (MediaKeyStatus or undefined) get (BufferSource keyId);
};
 
/* ---------------------- MediaKeySystemAccess ----------------------------- */ 
/* ./webidl/MediaKeySystemAccess.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/html-media/raw-file/default/encrypted-media/encrypted-media.html
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

enum MediaKeysRequirement {
  "required",
  "optional",
  "not-allowed"
};

dictionary MediaKeySystemMediaCapability {
   DOMString contentType = "";
   DOMString robustness = "";
   [Pref="media.eme.encrypted-media-encryption-scheme.enabled"]
   DOMString? encryptionScheme = null;
};

dictionary MediaKeySystemConfiguration {
  DOMString                               label = "";
  sequence<DOMString>                     initDataTypes = [];
  sequence<MediaKeySystemMediaCapability> audioCapabilities = [];
  sequence<MediaKeySystemMediaCapability> videoCapabilities = [];
  MediaKeysRequirement                    distinctiveIdentifier = "optional";
  MediaKeysRequirement                    persistentState = "optional";
  sequence<DOMString>                     sessionTypes;
};

[Exposed=Window]
interface MediaKeySystemAccess {
  readonly    attribute DOMString keySystem;
  [NewObject]
  MediaKeySystemConfiguration getConfiguration();
  [NewObject]
  Promise<MediaKeys> createMediaKeys();
};
 
/* ---------------------- MediaList ----------------------------- */ 
/* ./webidl/MediaList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// https://drafts.csswg.org/cssom/#the-medialist-interface

[Exposed=Window]
interface MediaList {
  stringifier attribute [LegacyNullToEmptyString] UTF8String mediaText;

  readonly attribute unsigned long    length;
  getter UTF8String? item(unsigned long index);
  [Throws]
  undefined          deleteMedium(UTF8String oldMedium);
  [Throws]
  undefined          appendMedium(UTF8String newMedium);
};
 
/* ---------------------- MediaQueryList ----------------------------- */ 
/* ./webidl/MediaQueryList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/cssom-view/#mediaquerylist
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[ProbablyShortLivingWrapper,
 Exposed=Window]
interface MediaQueryList : EventTarget {
  readonly attribute UTF8String media;
  readonly attribute boolean matches;

  [Throws]
  undefined addListener(EventListener? listener);

  [Throws]
  undefined removeListener(EventListener? listener);

           attribute EventHandler onchange;
};
 
/* ---------------------- MediaQueryListEvent ----------------------------- */ 
/* ./webidl/MediaQueryListEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * https://drafts.csswg.org/cssom-view/#mediaquerylistevent
 */

[Exposed=Window]
interface MediaQueryListEvent : Event {
  constructor(DOMString type,
              optional MediaQueryListEventInit eventInitDict = {});

  readonly attribute UTF8String media;
  readonly attribute boolean matches;
};

dictionary MediaQueryListEventInit : EventInit {
  UTF8String media = "";
  boolean matches = false;
};
 
/* ---------------------- MediaRecorder ----------------------------- */ 
/* ./webidl/MediaRecorder.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/dap/raw-file/default/media-stream-capture/MediaRecorder.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */


enum BitrateMode { "constant", "variable" };

enum RecordingState { "inactive", "recording", "paused" };

[Exposed=Window]
interface MediaRecorder : EventTarget {
  [Throws]
  constructor(MediaStream stream, optional MediaRecorderOptions options = {});
  [Throws]
  constructor(AudioNode node, optional unsigned long output = 0,
              optional MediaRecorderOptions options = {});
  readonly attribute MediaStream stream;
  readonly attribute DOMString mimeType;
  readonly attribute RecordingState state;
  attribute EventHandler onstart;
  attribute EventHandler onstop;
  attribute EventHandler ondataavailable;
  attribute EventHandler onpause;
  attribute EventHandler onresume;
  attribute EventHandler onerror;
  readonly attribute unsigned long videoBitsPerSecond;
  readonly attribute unsigned long audioBitsPerSecond;


  [Throws]
  undefined start(optional unsigned long timeslice);
  [Throws]
  undefined stop();
  [Throws]
  undefined pause();
  [Throws]
  undefined resume();
  [Throws]
  undefined requestData();

  static boolean isTypeSupported(DOMString type);
};

dictionary MediaRecorderOptions {
  DOMString mimeType = "";
  unsigned long audioBitsPerSecond;
  unsigned long videoBitsPerSecond;
  unsigned long bitsPerSecond;
};
 
/* ---------------------- MediaRecorderErrorEvent ----------------------------- */ 
/* ./webidl/MediaRecorderErrorEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/mediacapture-record/
 *
 * Copyright © 2017 W3C® (MIT, ERCIM, Keio, Beihang). W3C liability, trademark
 * and document use rules apply.
 */

dictionary MediaRecorderErrorEventInit : EventInit {
  required DOMException error;
};

[Exposed=Window]
interface MediaRecorderErrorEvent : Event {
  constructor(DOMString type, MediaRecorderErrorEventInit eventInitDict);

  [SameObject] readonly attribute DOMException error;
};
 
/* ---------------------- MediaSession ----------------------------- */ 
/* ./webidl/MediaSession.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/mediasession/#idl-index
 */

enum MediaSessionPlaybackState {
  "none",
  "paused",
  "playing"
};

enum MediaSessionAction {
  "play",
  "pause",
  "seekbackward",
  "seekforward",
  "previoustrack",
  "nexttrack",
  "skipad",
  "seekto",
  "stop",
};

callback MediaSessionActionHandler = undefined(MediaSessionActionDetails details);

[Exposed=Window]
interface MediaSession {
  attribute MediaMetadata? metadata;

  attribute MediaSessionPlaybackState playbackState;

  undefined setActionHandler(MediaSessionAction action, MediaSessionActionHandler? handler);

  [Throws]
  undefined setPositionState(optional MediaPositionState state = {});

  // Fire the action handler. It's test-only for now.
  [ChromeOnly]
  undefined notifyHandler(MediaSessionActionDetails details);
};

[Exposed=Window]
interface MediaMetadata {
  [Throws]
  constructor(optional MediaMetadataInit init = {});

  attribute DOMString title;
  attribute DOMString artist;
  attribute DOMString album;
  // https://github.com/w3c/mediasession/issues/237
  // Take and return `MediaImage` on setter and getter.
  [Frozen, Cached, Pure, Throws]
  attribute sequence<object> artwork;
};

dictionary MediaMetadataInit {
  DOMString title = "";
  DOMString artist = "";
  DOMString album = "";
  sequence<MediaImage> artwork = [];
};

dictionary MediaImage {
  required USVString src;
  DOMString sizes = "";
  DOMString type = "";
};

// Spec issue https://github.com/w3c/mediasession/issues/254
dictionary MediaSessionActionDetails {
  required MediaSessionAction action;
  double seekOffset;
  double seekTime;
  boolean fastSeek;
};

dictionary MediaPositionState {
  double duration;
  double playbackRate;
  double position;
};
 
/* ---------------------- MediaSource ----------------------------- */ 
/* ./webidl/MediaSource.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/html-media/raw-file/default/media-source/media-source.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum MediaSourceReadyState {
  "closed",
  "open",
  "ended"
};

enum MediaSourceEndOfStreamError {
  "network",
  "decode"
};

[Pref="media.mediasource.enabled",
 Exposed=Window]
interface MediaSource : EventTarget {
  [Throws]
  constructor();

  readonly attribute SourceBufferList sourceBuffers;
  readonly attribute SourceBufferList activeSourceBuffers;
  readonly attribute MediaSourceReadyState readyState;
  [SetterThrows]
  attribute unrestricted double duration;
  attribute EventHandler onsourceopen;
  attribute EventHandler onsourceended;
  attribute EventHandler onsourceclose;
  [NewObject, Throws]
  SourceBuffer addSourceBuffer(DOMString type);
  [Throws]
  undefined removeSourceBuffer(SourceBuffer sourceBuffer);
  [Throws]
  undefined endOfStream(optional MediaSourceEndOfStreamError error);
  [Throws]
  undefined setLiveSeekableRange(double start, double end);
  [Throws]
  undefined clearLiveSeekableRange();
  static boolean isTypeSupported(DOMString type);
  [NewObject, ChromeOnly]
  Promise<MediaSourceDecoderDebugInfo> mozDebugReaderData();
};
 
/* ---------------------- MediaStream ----------------------------- */ 
/* ./webidl/MediaStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origins of this IDL file are
 * http://dev.w3.org/2011/webrtc/editor/getusermedia.html
 *
 * Copyright � 2012 W3C� (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// These dictionaries need to be in a separate file from their
// MediaTrackConstraints* counterparts due to a webidl compiler limitation.

dictionary MediaStreamConstraints {
    (boolean or MediaTrackConstraints) audio = false;
    (boolean or MediaTrackConstraints) video = false;
    boolean picture = false; // Mozilla legacy
    boolean fake;       // For testing purpose. Generates frames of solid
                        // colors if video is enabled, and sound of 1Khz sine
                        // wave if audio is enabled.
    DOMString? peerIdentity = null;
};

dictionary DisplayMediaStreamConstraints {
    (boolean or MediaTrackConstraints) video = true;
    (boolean or MediaTrackConstraints) audio = false;
};

[Exposed=Window]
interface MediaStream : EventTarget {
    [Throws]
    constructor();
    [Throws]
    constructor(MediaStream stream);
    [Throws]
    constructor(sequence<MediaStreamTrack> tracks);

    readonly    attribute DOMString    id;
    sequence<MediaStreamTrack> getAudioTracks ();
    sequence<MediaStreamTrack> getVideoTracks ();
    sequence<MediaStreamTrack> getTracks ();
    MediaStreamTrack?          getTrackById (DOMString trackId);
    undefined                  addTrack (MediaStreamTrack track);
    undefined                  removeTrack (MediaStreamTrack track);
    MediaStream                clone ();
    readonly    attribute boolean      active;
                attribute EventHandler onaddtrack;
                attribute EventHandler onremovetrack;

    [ChromeOnly, NewObject]
    static Promise<long> countUnderlyingStreams();

    // Webrtc allows the remote side to name a stream whatever it wants, and we
    // need to surface this to content.
    [ChromeOnly]
    undefined assignId(DOMString id);
};
 
/* ---------------------- MediaStreamAudioDestinationNode ----------------------------- */ 
/* ./webidl/MediaStreamAudioDestinationNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface MediaStreamAudioDestinationNode : AudioNode {
    [Throws]
    constructor(AudioContext context, optional AudioNodeOptions options = {});

    [BinaryName="DOMStream"]
    readonly attribute MediaStream stream;
};
 
/* ---------------------- MediaStreamAudioSourceNode ----------------------------- */ 
/* ./webidl/MediaStreamAudioSourceNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary MediaStreamAudioSourceOptions {
    required MediaStream mediaStream;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface MediaStreamAudioSourceNode : AudioNode {
  [Throws]
  constructor(AudioContext context, MediaStreamAudioSourceOptions options);

  [BinaryName="GetMediaStream"]
  readonly attribute MediaStream mediaStream;
};

// Mozilla extensions
MediaStreamAudioSourceNode includes AudioNodePassThrough;
 
/* ---------------------- MediaStreamError ----------------------------- */ 
/* ./webidl/MediaStreamError.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/mediacapture-main/getusermedia.html#idl-def-MediaStreamError
 */

// The future of MediaStreamError is uncertain.
// https://www.w3.org/Bugs/Public/show_bug.cgi?id=26776

// TODO: This is an 'exception', not an interface, by virtue of needing to be
// passed as a promise rejection-reason. Revisit if DOMException grows a customArg

[ExceptionClass, LegacyNoInterfaceObject,
 Exposed=Window]
interface MediaStreamError {
  readonly attribute DOMString  name;
  readonly attribute DOMString? message;
  readonly attribute DOMString? constraint;
};
 
/* ---------------------- MediaStreamEvent ----------------------------- */ 
/* ./webidl/MediaStreamEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/webrtc.html#mediastreamevent
 */

dictionary MediaStreamEventInit : EventInit {
    MediaStream? stream = null;
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface MediaStreamEvent : Event {
  constructor(DOMString type, optional MediaStreamEventInit eventInitDict = {});

  readonly attribute MediaStream? stream;
};
 
/* ---------------------- MediaStreamTrack ----------------------------- */ 
/* ./webidl/MediaStreamTrack.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/getusermedia.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// These two enums are in the spec even though they're not used directly in the
// API due to https://www.w3.org/Bugs/Public/show_bug.cgi?id=19936
// Their binding code is used in the implementation.

enum VideoFacingModeEnum {
    "user",
    "environment",
    "left",
    "right"
};

enum MediaSourceEnum {
    "camera",
    "screen",
    "application",
    "window",
    "browser",
    "microphone",
    "audioCapture",
    "other"
    // If values are added, adjust n_values in Histograms.json (2 places)
};

dictionary ConstrainLongRange {
    long min;
    long max;
    long exact;
    long ideal;
};

dictionary ConstrainDoubleRange {
    double min;
    double max;
    double exact;
    double ideal;
};

dictionary ConstrainBooleanParameters {
    boolean exact;
    boolean ideal;
};

dictionary ConstrainDOMStringParameters {
    (DOMString or sequence<DOMString>) exact;
    (DOMString or sequence<DOMString>) ideal;
};

typedef (long or ConstrainLongRange) ConstrainLong;
typedef (double or ConstrainDoubleRange) ConstrainDouble;
typedef (boolean or ConstrainBooleanParameters) ConstrainBoolean;
typedef (DOMString or sequence<DOMString> or ConstrainDOMStringParameters) ConstrainDOMString;

// Note: When adding new constraints, remember to update the SelectSettings()
// function in MediaManager.cpp to make OverconstrainedError's constraint work!

dictionary MediaTrackConstraintSet {
    ConstrainLong width;
    ConstrainLong height;
    ConstrainDouble frameRate;
    ConstrainDOMString facingMode;
    DOMString mediaSource;
    long long browserWindow;
    boolean scrollWithPage;
    ConstrainDOMString deviceId;
    ConstrainDOMString groupId;
    ConstrainLong viewportOffsetX;
    ConstrainLong viewportOffsetY;
    ConstrainLong viewportWidth;
    ConstrainLong viewportHeight;
    ConstrainBoolean echoCancellation;
    ConstrainBoolean noiseSuppression;
    ConstrainBoolean autoGainControl;
    ConstrainLong channelCount;
};

[GenerateToJSON]
dictionary MediaTrackConstraints : MediaTrackConstraintSet {
    sequence<MediaTrackConstraintSet> advanced;
};

enum MediaStreamTrackState {
    "live",
    "ended"
};

[Exposed=Window]
interface MediaStreamTrack : EventTarget {
    readonly    attribute DOMString             kind;
    readonly    attribute DOMString             id;
    [NeedsCallerType]
    readonly    attribute DOMString             label;
                attribute boolean               enabled;
    readonly    attribute boolean               muted;
                attribute EventHandler          onmute;
                attribute EventHandler          onunmute;
    readonly    attribute MediaStreamTrackState readyState;
                attribute EventHandler          onended;
    MediaStreamTrack       clone ();
    undefined              stop ();
//  MediaTrackCapabilities getCapabilities ();
    MediaTrackConstraints  getConstraints ();
    [NeedsCallerType]
    MediaTrackSettings     getSettings ();

    [NewObject, NeedsCallerType]
    Promise<undefined>     applyConstraints (optional MediaTrackConstraints constraints = {});
//              attribute EventHandler          onoverconstrained;
};
 
/* ---------------------- MediaStreamTrackAudioSourceNode ----------------------------- */ 
/* ./webidl/MediaStreamTrackAudioSourceNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary MediaStreamTrackAudioSourceOptions {
    required MediaStreamTrack mediaStreamTrack;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface MediaStreamTrackAudioSourceNode : AudioNode {
  [Throws]
  constructor(AudioContext context, MediaStreamTrackAudioSourceOptions options);
};

// Mozilla extensions
MediaStreamTrackAudioSourceNode includes AudioNodePassThrough;
 
/* ---------------------- MediaStreamTrackEvent ----------------------------- */ 
/* ./webidl/MediaStreamTrackEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/webrtc.html#mediastreamevent
 */

dictionary MediaStreamTrackEventInit : EventInit {
    required MediaStreamTrack track;
};

[Exposed=Window]
interface MediaStreamTrackEvent : Event {
    constructor(DOMString type, MediaStreamTrackEventInit eventInitDict);

    [SameObject]
    readonly        attribute MediaStreamTrack track;
};
 
/* ---------------------- MediaTrackSettings ----------------------------- */ 
/* ./webidl/MediaTrackSettings.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/mediacapture-main/getusermedia.html
 */

dictionary MediaTrackSettings {
    long      width;
    long      height;
    double    frameRate;
    DOMString facingMode;
    boolean   echoCancellation;
    boolean   autoGainControl;
    boolean   noiseSuppression;
    long      channelCount;
    DOMString deviceId;
    DOMString groupId;

    // Mozilla-specific extensions:

    // http://fluffy.github.io/w3c-screen-share/#screen-based-video-constraints
    // OBE by http://w3c.github.io/mediacapture-screen-share

    DOMString mediaSource;

    // Experimental https://bugzilla.mozilla.org/show_bug.cgi?id=1131568#c3
    //              https://bugzilla.mozilla.org/show_bug.cgi?id=1193075

    long long browserWindow;
    boolean scrollWithPage;
    long viewportOffsetX;
    long viewportOffsetY;
    long viewportWidth;
    long viewportHeight;
};
 
/* ---------------------- MediaTrackSupportedConstraints ----------------------------- */ 
/* ./webidl/MediaTrackSupportedConstraints.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/getusermedia.html
 */

dictionary MediaTrackSupportedConstraints {
    boolean width = true;
    boolean height = true;
    boolean aspectRatio;        // to be supported
    boolean frameRate = true;
    boolean facingMode = true;
    boolean volume;             // to be supported
    boolean sampleRate;         // to be supported
    boolean sampleSize;         // to be supported
    boolean echoCancellation = true;
    boolean noiseSuppression = true;
    boolean autoGainControl = true;
    boolean latency;            // to be supported
    boolean channelCount = true;
    boolean deviceId = true;
    boolean groupId = true;

    // Mozilla-specific extensions:

    // http://fluffy.github.io/w3c-screen-share/#screen-based-video-constraints
    // OBE by http://w3c.github.io/mediacapture-screen-share

    boolean mediaSource = true;

    // Experimental https://bugzilla.mozilla.org/show_bug.cgi?id=1131568#c3
    //              https://bugzilla.mozilla.org/show_bug.cgi?id=1193075

    boolean browserWindow = true;
    boolean scrollWithPage = true;
    boolean viewportOffsetX = true;
    boolean viewportOffsetY = true;
    boolean viewportWidth = true;
    boolean viewportHeight = true;
};
 
/* ---------------------- MerchantValidationEvent ----------------------------- */ 
/* ./webidl/MerchantValidationEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https://w3c.github.io/payment-request/#merchantvalidationevent-interface
 *   https://w3c.github.io/payment-request/#merchantvalidationeventinit-dictionary
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[SecureContext,
Exposed=Window,
Func="mozilla::dom::PaymentRequest::PrefEnabled"]
interface MerchantValidationEvent : Event {
  [Throws]
  constructor(DOMString type,
              optional MerchantValidationEventInit eventInitDict = {});

  readonly attribute DOMString methodName;
  readonly attribute USVString validationURL;
  [Throws]
  undefined complete(Promise<any> merchantSessionPromise);
};

dictionary MerchantValidationEventInit : EventInit {
  DOMString methodName = "";
  USVString validationURL = "";
};
 
/* ---------------------- MessageChannel ----------------------------- */ 
/* ./webidl/MessageChannel.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * http://www.whatwg.org/specs/web-apps/current-work/#channel-messaging
 */

[Exposed=(Window,Worker)]
interface MessageChannel {
  [Throws]
  constructor();

  readonly attribute MessagePort port1;
  readonly attribute MessagePort port2;
};
 
/* ---------------------- MessageEvent ----------------------------- */ 
/* ./webidl/MessageEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://html.spec.whatwg.org/#messageevent
 */

[Exposed=(Window,Worker,AudioWorklet), ProbablyShortLivingWrapper]
interface MessageEvent : Event {
  constructor(DOMString type, optional MessageEventInit eventInitDict = {});

  /**
   * Custom data associated with this event.
   */
  [GetterThrows]
  readonly attribute any data;

  /**
   * The origin of the site from which this event originated, which is the
   * scheme, ":", and if the URI has a host, "//" followed by the
   * host, and if the port is not the default for the given scheme,
   * ":" followed by that port.  This value does not have a trailing slash.
   */
  readonly attribute USVString origin;

  /**
   * The last event ID string of the event source, for server-sent DOM events; this
   * value is the empty string for cross-origin messaging.
   */
  readonly attribute DOMString lastEventId;

  /**
   * The window or port which originated this event.
   */
  readonly attribute MessageEventSource? source;

  [Pure, Cached, Frozen]
  readonly attribute sequence<MessagePort> ports;

  /**
   * Initializes this event with the given data, in a manner analogous to
   * the similarly-named method on the Event interface, also setting the
   * data, origin, source, and lastEventId attributes of this appropriately.
   */
  undefined initMessageEvent(DOMString type,
                             optional boolean bubbles = false,
                             optional boolean cancelable = false,
                             optional any data = null,
                             optional DOMString origin = "",
                             optional DOMString lastEventId = "",
                             optional MessageEventSource? source = null,
                             optional sequence<MessagePort> ports = []);
};

dictionary MessageEventInit : EventInit {
  any data = null;
  DOMString origin = "";
  DOMString lastEventId = "";
  MessageEventSource? source = null;
  sequence<MessagePort> ports = [];
};

typedef (WindowProxy or MessagePort or ServiceWorker) MessageEventSource;
 
/* ---------------------- MessagePort ----------------------------- */ 
/* ./webidl/MessagePort.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://html.spec.whatwg.org/#message-ports
 */

[Exposed=(Window,Worker,AudioWorklet)]
interface MessagePort : EventTarget {
  [Throws]
  undefined postMessage(any message, sequence<object> transferable);
  [Throws]
  undefined postMessage(any message, optional StructuredSerializeOptions options = {});

  undefined start();
  undefined close();

  // event handlers
  attribute EventHandler onmessage;
  attribute EventHandler onmessageerror;
};

// Used to declare which objects should be transferred.
dictionary StructuredSerializeOptions {
  sequence<object> transfer = [];
};
 
/* ---------------------- MIDIAccess ----------------------------- */ 
/* ./webidl/MIDIAccess.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext, Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIAccess : EventTarget {
  readonly attribute MIDIInputMap  inputs;
  readonly attribute MIDIOutputMap outputs;
           attribute EventHandler  onstatechange;
  readonly attribute boolean       sysexEnabled;
};
 
/* ---------------------- MIDIConnectionEvent ----------------------------- */ 
/* ./webidl/MIDIConnectionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext,
 Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIConnectionEvent : Event
{
  constructor(DOMString type,
              optional MIDIConnectionEventInit eventInitDict = {});

  readonly attribute MIDIPort? port;
};

dictionary MIDIConnectionEventInit : EventInit
{
  MIDIPort? port = null;
};
 
/* ---------------------- MIDIInput ----------------------------- */ 
/* ./webidl/MIDIInput.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext, Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIInput : MIDIPort {
  attribute EventHandler onmidimessage;
};
 
/* ---------------------- MIDIInputMap ----------------------------- */ 
/* ./webidl/MIDIInputMap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext, Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIInputMap {
  readonly maplike<DOMString, MIDIInput>;
};
 
/* ---------------------- MIDIMessageEvent ----------------------------- */ 
/* ./webidl/MIDIMessageEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext,
 Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIMessageEvent : Event
{
  [Throws]
  constructor(DOMString type, optional MIDIMessageEventInit eventInitDict = {});

  [Throws]
  readonly attribute Uint8Array  data;
};

dictionary MIDIMessageEventInit : EventInit
{
  Uint8Array  data;
};
 
/* ---------------------- MIDIOptions ----------------------------- */ 
/* ./webidl/MIDIOptions.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

dictionary MIDIOptions {
  boolean sysex = false;
  boolean software = false;
};
 
/* ---------------------- MIDIOutput ----------------------------- */ 
/* ./webidl/MIDIOutput.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext, Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIOutput : MIDIPort {
  [Throws]
  undefined send(sequence<octet> data, optional DOMHighResTimeStamp timestamp);
  undefined clear();
};
 
/* ---------------------- MIDIOutputMap ----------------------------- */ 
/* ./webidl/MIDIOutputMap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

[SecureContext, Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIOutputMap {
  readonly maplike<DOMString, MIDIOutput>;
};
 
/* ---------------------- MIDIPort ----------------------------- */ 
/* ./webidl/MIDIPort.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-midi-api/
 */

enum MIDIPortType {
  "input",
  "output"
};

enum MIDIPortDeviceState {
  "disconnected",
  "connected"
};

enum MIDIPortConnectionState {
  "open",
  "closed",
  "pending"
};

[SecureContext, Pref="dom.webmidi.enabled",
 Exposed=Window]
interface MIDIPort : EventTarget {
  readonly attribute DOMString    id;
  readonly attribute DOMString?   manufacturer;
  readonly attribute DOMString?   name;
  readonly attribute DOMString?   version;
  readonly attribute MIDIPortType type;
  readonly attribute MIDIPortDeviceState state;
  readonly attribute MIDIPortConnectionState connection;
           attribute EventHandler onstatechange;
  [Throws]
  Promise<MIDIPort> open();
  [Throws]
  Promise<MIDIPort> close();
};
 
/* ---------------------- MimeType ----------------------------- */ 
/* ./webidl/MimeType.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface MimeType {
  readonly attribute DOMString type;
  readonly attribute DOMString description;
  readonly attribute DOMString suffixes;
  readonly attribute Plugin enabledPlugin;
};
 
/* ---------------------- MimeTypeArray ----------------------------- */ 
/* ./webidl/MimeTypeArray.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface MimeTypeArray {
  readonly attribute unsigned long length;
  getter MimeType? item(unsigned long index);
  getter MimeType? namedItem(DOMString name);
};
 
/* ---------------------- MouseEvent ----------------------------- */ 
/* ./webidl/MouseEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface please see
 * http://dev.w3.org/2006/webapi/DOM-Level-3-Events/html/DOM3-Events.html
 * https://drafts.csswg.org/cssom-view/#extensions-to-the-mouseevent-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

interface nsIScreen;

[Exposed=Window]
interface MouseEvent : UIEvent {
  constructor(DOMString typeArg,
              optional MouseEventInit mouseEventInitDict = {});

  [NeedsCallerType]
  readonly attribute long           screenX;
  [NeedsCallerType]
  readonly attribute long           screenY;

  [ChromeOnly]
  readonly attribute nsIScreen?     screen;

  readonly attribute long           pageX;
  readonly attribute long           pageY;
  readonly attribute long           clientX;
  readonly attribute long           clientY;
  [BinaryName="clientX"]
  readonly attribute long           x;
  [BinaryName="clientY"]
  readonly attribute long           y;
  readonly attribute long           offsetX;
  readonly attribute long           offsetY;
  readonly attribute boolean        ctrlKey;
  readonly attribute boolean        shiftKey;
  readonly attribute boolean        altKey;
  readonly attribute boolean        metaKey;
  readonly attribute short          button;
  readonly attribute unsigned short buttons;
  readonly attribute EventTarget?   relatedTarget;

  // Pointer Lock
  readonly attribute long           movementX;
  readonly attribute long           movementY;

  // Deprecated in DOM Level 3:
  [Deprecated="InitMouseEvent"]
  undefined initMouseEvent(DOMString typeArg,
                         optional boolean canBubbleArg = false,
                         optional boolean cancelableArg = false,
                         optional Window? viewArg = null,
                         optional long detailArg = 0,
                         optional long screenXArg = 0,
                         optional long screenYArg = 0,
                         optional long clientXArg = 0,
                         optional long clientYArg = 0,
                         optional boolean ctrlKeyArg = false,
                         optional boolean altKeyArg = false,
                         optional boolean shiftKeyArg = false,
                         optional boolean metaKeyArg = false,
                         optional short buttonArg = 0,
                         optional EventTarget? relatedTargetArg = null);
  // Introduced in DOM Level 3:
  boolean                           getModifierState(DOMString keyArg);
};

// Suggested initMouseEvent replacement initializer:
dictionary MouseEventInit : EventModifierInit {
  // Attributes for MouseEvent:
  long           screenX       = 0;
  long           screenY       = 0;
  long           clientX       = 0;
  long           clientY       = 0;
  short          button        = 0;
  // Note: "buttons" was not previously initializable through initMouseEvent!
  unsigned short buttons       = 0;
  EventTarget?   relatedTarget = null;

  // Pointer Lock
  long           movementX = 0;
  long           movementY = 0;
};

// Mozilla extensions
partial interface MouseEvent
{
  // Finger or touch pressure event value
  // ranges between 0.0 and 1.0
  // TODO: Remove mozPressure. (bug 1534199)
  [Deprecated="MouseEvent_MozPressure"]
  readonly attribute float mozPressure;

  const unsigned short    MOZ_SOURCE_UNKNOWN    = 0;
  const unsigned short    MOZ_SOURCE_MOUSE      = 1;
  const unsigned short    MOZ_SOURCE_PEN        = 2;
  const unsigned short    MOZ_SOURCE_ERASER     = 3;
  const unsigned short    MOZ_SOURCE_CURSOR     = 4;
  const unsigned short    MOZ_SOURCE_TOUCH      = 5;
  const unsigned short    MOZ_SOURCE_KEYBOARD   = 6;

  [ChromeOnly]
  readonly attribute unsigned short inputSource;

  [Deprecated="MozInputSource", BinaryName="inputSource"]
  readonly attribute unsigned short mozInputSource;

  // TODO: Remove initNSMouseEvent. (bug 1165213)
  [Deprecated="InitNSMouseEvent"]
  undefined initNSMouseEvent(DOMString typeArg,
                             optional boolean canBubbleArg = false,
                             optional boolean cancelableArg = false,
                             optional Window? viewArg = null,
                             optional long detailArg = 0,
                             optional long screenXArg = 0,
                             optional long screenYArg = 0,
                             optional long clientXArg = 0,
                             optional long clientYArg = 0,
                             optional boolean ctrlKeyArg = false,
                             optional boolean altKeyArg = false,
                             optional boolean shiftKeyArg = false,
                             optional boolean metaKeyArg = false,
                             optional short buttonArg = 0,
                             optional EventTarget? relatedTargetArg = null,
                             optional float pressure = 0,
                             optional unsigned short inputSourceArg = 0);

  /**
   * preventClickEvent() prevents the following "click", "auxclick" and
   * "dblclick" events of "mousedown" and "mouseup" events.
   */
  [ChromeOnly]
  undefined preventClickEvent();

  /**
   * Returns true if the following "click", "auxclick" and "dblclick"
   * events of "mousedown" and "mouseup" events are prevented.
   */
  [ChromeOnly]
  boolean clickEventPrevented();
};
 
/* ---------------------- MouseScrollEvent ----------------------------- */ 
/* ./webidl/MouseScrollEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface MouseScrollEvent : MouseEvent
{
  const long HORIZONTAL_AXIS = 1;
  const long VERTICAL_AXIS = 2;

  readonly attribute long axis;

  undefined initMouseScrollEvent(DOMString type,
                                 optional boolean canBubble = false,
                                 optional boolean cancelable = false,
                                 optional Window? view = null,
                                 optional long detail = 0,
                                 optional long screenX = 0,
                                 optional long screenY = 0,
                                 optional long clientX = 0,
                                 optional long clientY = 0,
                                 optional boolean ctrlKey = false,
                                 optional boolean altKey = false,
                                 optional boolean shiftKey = false,
                                 optional boolean metaKey = false,
                                 optional short button = 0,
                                 optional EventTarget? relatedTarget = null,
                                 optional long axis = 0);
};
 
/* ---------------------- MozApplicationEvent ----------------------------- */ 
/* ./webidl/MozApplicationEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[ChromeOnly,
 Exposed=Window]
interface MozApplicationEvent : Event
{
  constructor(DOMString type,
              optional MozApplicationEventInit eventInitDict = {});

  readonly attribute DOMApplication? application;
};

dictionary MozApplicationEventInit : EventInit
{
  DOMApplication? application = null;
};
 
/* ---------------------- MozFrameLoaderOwner ----------------------------- */ 
/* ./webidl/MozFrameLoaderOwner.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

dictionary RemotenessOptions {
  required UTF8String? remoteType;

  // Used to resume a given channel load within the target process. If present,
  // it will be used rather than the `src` & `srcdoc` attributes on the
  // frameloader to control the load behaviour.
  unsigned long long pendingSwitchID;

  // True if we have an existing channel that we will resume in the
  // target process, either via pendingSwitchID or using messageManager.
  boolean switchingInProgressLoad = false;
};

/**
 * A mixin included by elements that are 'browsing context containers'
 * in HTML5 terms (that is, elements such as iframe that creates a new
 * browsing context):
 *
 * https://html.spec.whatwg.org/#browsing-context-container
 *
 * Objects including this mixin must implement nsFrameLoaderOwner in
 * native C++ code.
 */
interface mixin MozFrameLoaderOwner {
  [ChromeOnly]
  readonly attribute FrameLoader? frameLoader;

  [ChromeOnly]
  readonly attribute BrowsingContext? browsingContext;

  [ChromeOnly, Throws]
  undefined swapFrameLoaders(XULFrameElement aOtherLoaderOwner);

  [ChromeOnly, Throws]
  undefined swapFrameLoaders(HTMLIFrameElement aOtherLoaderOwner);

  [ChromeOnly, Throws]
  undefined changeRemoteness(RemotenessOptions aOptions);
};
 
/* ---------------------- MutationEvent ----------------------------- */ 
/* ./webidl/MutationEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2006/webapi/DOM-Level-3-Events/html/DOM3-Events.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */
[Exposed=Window]
interface MutationEvent : Event
{
  const unsigned short MODIFICATION = 1;
  const unsigned short ADDITION     = 2;
  const unsigned short REMOVAL      = 3;
  [ChromeOnly]
  const unsigned short SMIL         = 4;

  readonly attribute Node?          relatedNode;
  readonly attribute DOMString      prevValue;
  readonly attribute DOMString      newValue;
  readonly attribute DOMString      attrName;
  readonly attribute unsigned short attrChange;

  [Throws]
  undefined initMutationEvent(DOMString type,
                              optional boolean canBubble = false,
                              optional boolean cancelable = false,
                              optional Node? relatedNode = null,
                              optional DOMString prevValue = "",
                              optional DOMString newValue = "",
                              optional DOMString attrName = "",
                              optional unsigned short attrChange = 0);
};
 
/* ---------------------- MutationObserver ----------------------------- */ 
/* ./webidl/MutationObserver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org
 */

[ProbablyShortLivingWrapper,
 Exposed=Window]
interface MutationRecord {
  [Constant]
  readonly attribute DOMString type;
  // .target is not nullable per the spec, but in order to prevent crashes,
  // if there are GC/CC bugs in Gecko, we let the property to be null.
  [Constant]
  readonly attribute Node? target;
  [Constant]
  readonly attribute NodeList addedNodes;
  [Constant]
  readonly attribute NodeList removedNodes;
  [Constant]
  readonly attribute Node? previousSibling;
  [Constant]
  readonly attribute Node? nextSibling;
  [Constant]
  readonly attribute DOMString? attributeName;
  [Constant]
  readonly attribute DOMString? attributeNamespace;
  [Constant]
  readonly attribute DOMString? oldValue;
  [Constant, Cached, ChromeOnly]
  readonly attribute sequence<Animation> addedAnimations;
  [Constant, Cached, ChromeOnly]
  readonly attribute sequence<Animation> changedAnimations;
  [Constant, Cached, ChromeOnly]
  readonly attribute sequence<Animation> removedAnimations;
};

[Exposed=Window]
interface MutationObserver {
  [Throws]
  constructor(MutationCallback mutationCallback);

  [Throws, NeedsSubjectPrincipal]
  undefined observe(Node target, optional MutationObserverInit options = {});
  undefined disconnect();
  sequence<MutationRecord> takeRecords();

  [ChromeOnly, Throws]
  sequence<MutationObservingInfo?> getObservingInfo();
  [ChromeOnly]
  readonly attribute MutationCallback mutationCallback;
  [ChromeOnly]
  attribute boolean mergeAttributeRecords;
};

callback MutationCallback = undefined (sequence<MutationRecord> mutations, MutationObserver observer);

dictionary MutationObserverInit {
  boolean childList = false;
  boolean attributes;
  boolean characterData;
  boolean subtree = false;
  boolean attributeOldValue;
  boolean characterDataOldValue;
  [ChromeOnly]
  boolean chromeOnlyNodes = false;
  [ChromeOnly]
  boolean animations = false;
  sequence<DOMString> attributeFilter;
};

dictionary MutationObservingInfo : MutationObserverInit
{
  Node? observedNode = null;
};
 
/* ---------------------- NamedNodeMap ----------------------------- */ 
/* ./webidl/NamedNodeMap.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

[LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface NamedNodeMap {
  getter Attr? getNamedItem(DOMString name);
  [CEReactions, Throws, BinaryName="setNamedItemNS"]
  Attr? setNamedItem(Attr arg);
  [CEReactions, Throws]
  Attr removeNamedItem(DOMString name);

  getter Attr? item(unsigned long index);
  readonly attribute unsigned long length;

  Attr? getNamedItemNS(DOMString? namespaceURI, DOMString localName);
  [CEReactions, Throws]
  Attr? setNamedItemNS(Attr arg);
  [CEReactions, Throws]
  Attr removeNamedItemNS(DOMString? namespaceURI, DOMString localName);
};
 
/* ---------------------- NavigationPreloadManager ----------------------------- */ 
/* ./webidl/NavigationPreloadManager.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/ServiceWorker/#navigation-preload-manager
 */

[Func="NavigationPreloadManager::IsEnabled", SecureContext,
 Exposed=(Window,Worker)]
interface NavigationPreloadManager {
  [NewObject]
  Promise<undefined> enable();
  [NewObject]
  Promise<undefined> disable();
  [NewObject]
  Promise<undefined> setHeaderValue(ByteString value);
  [NewObject]
  Promise<NavigationPreloadState> getState();
};

dictionary NavigationPreloadState {
  boolean enabled = false;
  ByteString headerValue;
};
 
/* ---------------------- Navigator ----------------------------- */ 
/* ./webidl/Navigator.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/#the-navigator-object
 * http://www.w3.org/TR/tracking-dnt/
 * http://www.w3.org/TR/geolocation-API/#geolocation_interface
 * http://www.w3.org/TR/battery-status/#navigatorbattery-interface
 * http://www.w3.org/TR/vibration/#vibration-interface
 * http://www.w3.org/2012/sysapps/runtime/#extension-to-the-navigator-interface-1
 * https://dvcs.w3.org/hg/gamepad/raw-file/default/gamepad.html#navigator-interface-extension
 * http://www.w3.org/TR/beacon/#sec-beacon-method
 * https://html.spec.whatwg.org/#navigatorconcurrenthardware
 * http://wicg.github.io/netinfo/#extensions-to-the-navigator-interface
 * https://w3c.github.io/webappsec-credential-management/#framework-credential-management
 * https://w3c.github.io/webdriver/webdriver-spec.html#interface
 * https://wicg.github.io/media-capabilities/#idl-index
 * https://w3c.github.io/mediasession/#idl-index
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

interface URI;

// https://html.spec.whatwg.org/#the-navigator-object
[HeaderFile="Navigator.h",
 Exposed=Window,
 InstrumentedProps=(canShare,
                    clearAppBadge,
                    setAppBadge,
                    share,
                    userActivation,
                    wakeLock)]
interface Navigator {
  // objects implementing this interface also implement the interfaces given below
};
Navigator includes NavigatorID;
Navigator includes NavigatorLanguage;
Navigator includes NavigatorOnLine;
Navigator includes NavigatorContentUtils;
Navigator includes NavigatorStorageUtils;
Navigator includes NavigatorConcurrentHardware;
Navigator includes NavigatorStorage;
Navigator includes NavigatorAutomationInformation;
Navigator includes NavigatorGPU;
Navigator includes GlobalPrivacyControl;

interface mixin NavigatorID {
  // WebKit/Blink/Trident/Presto support this (hardcoded "Mozilla").
  [Constant, Cached, Throws]
  readonly attribute DOMString appCodeName; // constant "Mozilla"
  [Constant, Cached]
  readonly attribute DOMString appName; // constant "Netscape"
  [Constant, Cached, Throws, NeedsCallerType]
  readonly attribute DOMString appVersion;
  [Pure, Cached, Throws, NeedsCallerType]
  readonly attribute DOMString platform;
  [Pure, Cached, Throws, NeedsCallerType]
  readonly attribute DOMString userAgent;
  [Constant, Cached]
  readonly attribute DOMString product; // constant "Gecko"

  // Everyone but WebKit/Blink supports this.  See bug 679971.
  [Exposed=Window]
  boolean taintEnabled(); // constant false
};

interface mixin NavigatorLanguage {

  // These two attributes are cached because this interface is also implemented
  // by Workernavigator and this way we don't have to go back to the
  // main-thread from the worker thread anytime we need to retrieve them. They
  // are updated when pref intl.accept_languages is changed.

  [Pure, Cached]
  readonly attribute DOMString? language;
  [Pure, Cached, Frozen]
  readonly attribute sequence<DOMString> languages;
};

interface mixin NavigatorOnLine {
  readonly attribute boolean onLine;
};

interface mixin NavigatorContentUtils {
  // content handler registration
  [Throws, ChromeOnly]
  undefined checkProtocolHandlerAllowed(DOMString scheme, URI handlerURI, URI documentURI);
  [Throws, SecureContext]
  undefined registerProtocolHandler(DOMString scheme, DOMString url);
  // NOT IMPLEMENTED
  //undefined unregisterProtocolHandler(DOMString scheme, DOMString url);
};

[SecureContext]
interface mixin NavigatorStorage {
  readonly attribute StorageManager storage;
};

interface mixin NavigatorStorageUtils {
  // NOT IMPLEMENTED
  //undefined yieldForStorageUpdates();
};

partial interface Navigator {
  [Throws]
  readonly attribute Permissions permissions;
};

partial interface Navigator {
  [Throws, SameObject]
  readonly attribute MimeTypeArray mimeTypes;
  [Throws, SameObject]
  readonly attribute PluginArray plugins;
  readonly attribute boolean pdfViewerEnabled;
};

// http://www.w3.org/TR/tracking-dnt/ sort of
partial interface Navigator {
  readonly attribute DOMString doNotTrack;
};

// https://globalprivacycontrol.github.io/gpc-spec/
interface mixin GlobalPrivacyControl {
  [Pref="privacy.globalprivacycontrol.functionality.enabled"]
  readonly attribute boolean globalPrivacyControl;
};

// http://www.w3.org/TR/geolocation-API/#geolocation_interface
interface mixin NavigatorGeolocation {
  [Throws, Pref="geo.enabled"]
  readonly attribute Geolocation geolocation;
};
Navigator includes NavigatorGeolocation;

// http://www.w3.org/TR/battery-status/#navigatorbattery-interface
partial interface Navigator {
  // ChromeOnly to prevent web content from fingerprinting users' batteries.
  [Throws, ChromeOnly, Pref="dom.battery.enabled"]
  Promise<BatteryManager> getBattery();
};

// http://www.w3.org/TR/vibration/#vibration-interface
partial interface Navigator {
    // We don't support sequences in unions yet
    //boolean vibrate ((unsigned long or sequence<unsigned long>) pattern);
    boolean vibrate(unsigned long duration);
    boolean vibrate(sequence<unsigned long> pattern);
};

// http://www.w3.org/TR/pointerevents/#extensions-to-the-navigator-interface
partial interface Navigator {
    [NeedsCallerType]
    readonly attribute long maxTouchPoints;
};

// https://wicg.github.io/media-capabilities/#idl-index
[Exposed=Window]
partial interface Navigator {
  [SameObject, Func="mozilla::dom::MediaCapabilities::Enabled"]
  readonly attribute MediaCapabilities mediaCapabilities;
};

// Mozilla-specific extensions

// Chrome-only interface for Vibration API permission handling.
partial interface Navigator {
    /* Set permission state to device vibration.
     * @param permitted permission state (true for allowing vibration)
     * @param persistent make the permission session-persistent
     */
    [ChromeOnly]
    undefined setVibrationPermission(boolean permitted,
                                     optional boolean persistent = true);
};

partial interface Navigator {
  [Throws, Constant, Cached, NeedsCallerType]
  readonly attribute DOMString oscpu;
  // WebKit/Blink support this; Trident/Presto do not.
  readonly attribute DOMString vendor;
  // WebKit/Blink supports this (hardcoded ""); Trident/Presto do not.
  readonly attribute DOMString vendorSub;
  // WebKit/Blink supports this (hardcoded "20030107"); Trident/Presto don't
  readonly attribute DOMString productSub;
  // WebKit/Blink/Trident/Presto support this.
  readonly attribute boolean cookieEnabled;
  [Throws, Constant, Cached, NeedsCallerType]
  readonly attribute DOMString buildID;

  // WebKit/Blink/Trident/Presto support this.
  [Affects=Nothing, DependsOn=Nothing]
  boolean javaEnabled();
};

// Addon manager bits
partial interface Navigator {
  [Throws, Func="mozilla::AddonManagerWebAPI::IsAPIEnabled"]
  readonly attribute AddonManager mozAddonManager;
};

// NetworkInformation
partial interface Navigator {
  [Throws, Pref="dom.netinfo.enabled"]
  readonly attribute NetworkInformation connection;
};

// https://dvcs.w3.org/hg/gamepad/raw-file/default/gamepad.html#navigator-interface-extension
partial interface Navigator {
  [Throws, Pref="dom.gamepad.enabled"]
  sequence<Gamepad?> getGamepads();
};
partial interface Navigator {
  [Throws, Pref="dom.gamepad.test.enabled"]
  GamepadServiceTest requestGamepadServiceTest();
};

// https://immersive-web.github.io/webvr/spec/1.1/#interface-navigator
partial interface Navigator {
  [NewObject, SecureContext, Pref="dom.vr.enabled"]
  Promise<sequence<VRDisplay>> getVRDisplays();
  // TODO: Use FrozenArray once available. (Bug 1236777)
  [SecureContext, Frozen, Cached, Pure, Pref="dom.vr.enabled"]
  readonly attribute sequence<VRDisplay> activeVRDisplays;
  [ChromeOnly, Pref="dom.vr.enabled"]
  readonly attribute boolean isWebVRContentDetected;
  [ChromeOnly, Pref="dom.vr.enabled"]
  readonly attribute boolean isWebVRContentPresenting;
  [ChromeOnly, Pref="dom.vr.enabled"]
  undefined requestVRPresentation(VRDisplay display);
};
partial interface Navigator {
  [Throws, Pref="dom.vr.puppet.enabled"]
  VRServiceTest requestVRServiceTest();
};

// https://immersive-web.github.io/webxr/#dom-navigator-xr
partial interface Navigator {
  [SecureContext, SameObject, Throws, Pref="dom.vr.webxr.enabled"]
  readonly attribute XRSystem xr;
};

// http://webaudio.github.io/web-midi-api/#requestmidiaccess
partial interface Navigator {
  [NewObject, Func="Navigator::HasMidiSupport"]
  Promise<MIDIAccess> requestMIDIAccess(optional MIDIOptions options = {});
};

callback NavigatorUserMediaSuccessCallback = undefined (MediaStream stream);
callback NavigatorUserMediaErrorCallback = undefined (MediaStreamError error);

partial interface Navigator {
  [Throws, Func="Navigator::HasUserMediaSupport"]
  readonly attribute MediaDevices mediaDevices;

  // Deprecated. Use mediaDevices.getUserMedia instead.
  [Deprecated="NavigatorGetUserMedia", Throws,
   Func="Navigator::HasUserMediaSupport",
   NeedsCallerType,
   UseCounter]
  undefined mozGetUserMedia(MediaStreamConstraints constraints,
                            NavigatorUserMediaSuccessCallback successCallback,
                            NavigatorUserMediaErrorCallback errorCallback);
};

// Service Workers/Navigation Controllers
partial interface Navigator {
  [Func="ServiceWorkersEnabled", SameObject, BinaryName="serviceWorkerJS"]
  readonly attribute ServiceWorkerContainer serviceWorker;
};

partial interface Navigator {
  [Throws, Pref="beacon.enabled"]
  boolean sendBeacon(DOMString url,
                     optional BodyInit? data = null);
};

partial interface Navigator {
  [NewObject, Func="mozilla::dom::TCPSocket::ShouldTCPSocketExist"]
  readonly attribute LegacyMozTCPSocket mozTCPSocket;
};

partial interface Navigator {
  [NewObject]
  Promise<MediaKeySystemAccess>
  requestMediaKeySystemAccess(DOMString keySystem,
                              sequence<MediaKeySystemConfiguration> supportedConfigurations);
};

interface mixin NavigatorConcurrentHardware {
  readonly attribute unsigned long long hardwareConcurrency;
};

// https://w3c.github.io/webappsec-credential-management/#framework-credential-management
partial interface Navigator {
  [Pref="security.webauth.webauthn", SecureContext, SameObject]
  readonly attribute CredentialsContainer credentials;
};

// https://w3c.github.io/webdriver/webdriver-spec.html#interface
interface mixin NavigatorAutomationInformation {
  [Constant, Cached]
  readonly attribute boolean webdriver;
};

// https://www.w3.org/TR/clipboard-apis/#navigator-interface
partial interface Navigator {
  [SecureContext, SameObject]
  readonly attribute Clipboard clipboard;
};

// Used for testing of origin trials.
partial interface Navigator {
  [Trial="TestTrial"]
  readonly attribute boolean testTrialGatedAttribute;
};

// https://wicg.github.io/web-share/#navigator-interface
partial interface Navigator {
  [SecureContext, NewObject, Func="Navigator::HasShareSupport"]
  Promise<undefined> share(optional ShareData data = {});
  [SecureContext, Func="Navigator::HasShareSupport"]
  boolean canShare(optional ShareData data = {});
};
// https://wicg.github.io/web-share/#sharedata-dictionary
dictionary ShareData {
  USVString title;
  USVString text;
  USVString url;
  // Note: we don't actually support files yet
  // we have it here for the .canShare() checks.
  sequence<File> files;
};

// https://w3c.github.io/mediasession/#idl-index
[Exposed=Window]
partial interface Navigator {
  [SameObject]
  readonly attribute MediaSession mediaSession;
};

// https://w3c.github.io/web-locks/#navigator-mixins
[SecureContext]
interface mixin NavigatorLocks {
  readonly attribute LockManager locks;
};
Navigator includes NavigatorLocks;

// https://w3c.github.io/autoplay/#autoplay-policy
enum AutoplayPolicy {
  "allowed",
  "allowed-muted",
  "disallowed"
};

enum AutoplayPolicyMediaType {
  "mediaelement",
  "audiocontext"
};

// https://w3c.github.io/autoplay/#autoplay-detection-methods
partial interface Navigator {
  [Pref="dom.media.autoplay-policy-detection.enabled"]
  AutoplayPolicy getAutoplayPolicy(AutoplayPolicyMediaType type);

  [Pref="dom.media.autoplay-policy-detection.enabled"]
  AutoplayPolicy getAutoplayPolicy(HTMLMediaElement element);

  [Pref="dom.media.autoplay-policy-detection.enabled"]
  AutoplayPolicy getAutoplayPolicy(AudioContext context);
};

// https://html.spec.whatwg.org/multipage/interaction.html#the-useractivation-interface
partial interface Navigator {
  [SameObject] readonly attribute UserActivation userActivation;
};

// https://w3c.github.io/screen-wake-lock/#extensions-to-the-navigator-interface
[SecureContext]
partial interface Navigator {
  [SameObject, Pref="dom.screenwakelock.enabled"]
  readonly attribute WakeLock wakeLock;
};
 
/* ---------------------- NetErrorInfo ----------------------------- */ 
/* ./webidl/NetErrorInfo.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * This dictionary is used for exposing failed channel info
 * to about:neterror to built UI.
 */

dictionary NetErrorInfo {
  DOMString errorCodeString = "";
};
 
/* ---------------------- NetworkInformation ----------------------------- */ 
/* ./webidl/NetworkInformation.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is https://w3c.github.io/netinfo/
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum ConnectionType {
    "cellular",
    "bluetooth",
    "ethernet",
    "wifi",
    "other",
    "none",
    "unknown"
};

[Pref="dom.netinfo.enabled",
 Exposed=(Window,Worker)]
interface NetworkInformation : EventTarget {
    readonly    attribute ConnectionType type;
                attribute EventHandler   ontypechange;
};
 
/* ---------------------- NetworkOptions ----------------------------- */ 
/* ./webidl/NetworkOptions.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
* This dictionary holds the parameters sent to the network worker.
*/
dictionary NetworkCommandOptions
{
  long id = 0;                        // opaque id.
  DOMString cmd = "";                 // the command name.
  DOMString ifname;                   // for "removeNetworkRoute", "setDNS",
                                      //     "setDefaultRouteAndDNS", "removeDefaultRoute"
                                      //     "addHostRoute", "removeHostRoute"
                                      //     "removeHostRoutes".
  DOMString ip;                       // for "removeNetworkRoute", "setWifiTethering".
  unsigned long prefixLength;         // for "removeNetworkRoute".
  DOMString domain;                   // for "setDNS"
  sequence<DOMString> dnses;          // for "setDNS", "setDefaultRouteAndDNS".
  DOMString gateway;                  // for "addSecondaryRoute", "removeSecondaryRoute".
  sequence<DOMString> gateways;       // for "setDefaultRouteAndDNS", "removeDefaultRoute".
  DOMString mode;                     // for "setWifiOperationMode".
  boolean report;                     // for "setWifiOperationMode".
  boolean enabled;                    // for "setDhcpServer".
  DOMString wifictrlinterfacename;    // for "setWifiTethering".
  DOMString internalIfname;           // for "setWifiTethering".
  DOMString externalIfname;           // for "setWifiTethering".
  boolean enable;                     // for "setWifiTethering".
  DOMString ssid;                     // for "setWifiTethering".
  DOMString security;                 // for "setWifiTethering".
  DOMString key;                      // for "setWifiTethering".
  DOMString prefix;                   // for "setWifiTethering", "setDhcpServer".
  DOMString link;                     // for "setWifiTethering", "setDhcpServer".
  sequence<DOMString> interfaceList;  // for "setWifiTethering".
  DOMString wifiStartIp;              // for "setWifiTethering".
  DOMString wifiEndIp;                // for "setWifiTethering".
  DOMString usbStartIp;               // for "setWifiTethering".
  DOMString usbEndIp;                 // for "setWifiTethering".
  DOMString dns1;                     // for "setWifiTethering".
  DOMString dns2;                     // for "setWifiTethering".
  long long threshold;                // for "setNetworkInterfaceAlarm",
                                      //     "enableNetworkInterfaceAlarm".
  DOMString startIp;                  // for "setDhcpServer".
  DOMString endIp;                    // for "setDhcpServer".
  DOMString serverIp;                 // for "setDhcpServer".
  DOMString maskLength;               // for "setDhcpServer".
  DOMString preInternalIfname;        // for "updateUpStream".
  DOMString preExternalIfname;        // for "updateUpStream".
  DOMString curInternalIfname;        // for "updateUpStream".
  DOMString curExternalIfname;        // for "updateUpStream".

  long ipaddr;                        // for "ifc_configure".
  long mask;                          // for "ifc_configure".
  long gateway_long;                  // for "ifc_configure".
  long dns1_long;                     // for "ifc_configure".
  long dns2_long;                     // for "ifc_configure".

  long mtu;                           // for "setMtu".
};

/**
* This dictionary holds the parameters sent back to NetworkService.js.
*/
dictionary NetworkResultOptions
{
  long id = 0;                        // opaque id.
  boolean ret = false;                // for sync command.
  boolean broadcast = false;          // for netd broadcast message.
  DOMString topic = "";               // for netd broadcast message.
  DOMString reason = "";              // for netd broadcast message.

  long resultCode = 0;                // for all commands.
  DOMString resultReason = "";        // for all commands.
  boolean error = false;              // for all commands.

  boolean enable = false;             // for "setWifiTethering", "setUSBTethering"
                                      //     "enableUsbRndis".
  boolean result = false;             // for "enableUsbRndis".
  boolean success = false;            // for "setDhcpServer".
  DOMString curExternalIfname = "";   // for "updateUpStream".
  DOMString curInternalIfname = "";   // for "updateUpStream".

  DOMString reply = "";               // for "command".
  DOMString route = "";               // for "ifc_get_default_route".
  DOMString ipaddr_str = "";          // The following are for the result of
                                      // dhcp_do_request.
  DOMString gateway_str = "";
  DOMString dns1_str = "";
  DOMString dns2_str = "";
  DOMString mask_str = "";
  DOMString server_str = "";
  DOMString vendor_str = "";
  long      lease = 0;
  long      prefixLength = 0;
  long      mask = 0;
  long      ipaddr = 0;
  long      gateway = 0;
  long      dns1 = 0;
  long      dns2 = 0;
  long      server = 0;

  DOMString netId = "";               // for "getNetId".

  sequence<DOMString> interfaceList;  // for "getInterfaceList".

  DOMString flag = "down";            // for "getInterfaceConfig".
  DOMString macAddr = "";             // for "getInterfaceConfig".
  DOMString ipAddr = "";              // for "getInterfaceConfig".
};
 
/* ---------------------- Node ----------------------------- */ 
/* ./webidl/Node.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

interface Principal;
interface URI;

[Exposed=Window]
interface Node : EventTarget {
  const unsigned short ELEMENT_NODE = 1;
  const unsigned short ATTRIBUTE_NODE = 2; // historical
  const unsigned short TEXT_NODE = 3;
  const unsigned short CDATA_SECTION_NODE = 4; // historical
  const unsigned short ENTITY_REFERENCE_NODE = 5; // historical
  const unsigned short ENTITY_NODE = 6; // historical
  const unsigned short PROCESSING_INSTRUCTION_NODE = 7;
  const unsigned short COMMENT_NODE = 8;
  const unsigned short DOCUMENT_NODE = 9;
  const unsigned short DOCUMENT_TYPE_NODE = 10;
  const unsigned short DOCUMENT_FRAGMENT_NODE = 11;
  const unsigned short NOTATION_NODE = 12; // historical
  [Constant]
  readonly attribute unsigned short nodeType;
  [Pure]
  readonly attribute DOMString nodeName;

  [Pure, Throws, NeedsCallerType, BinaryName="baseURIFromJS"]
  readonly attribute DOMString? baseURI;

  [Pure, BinaryName=isInComposedDoc]
  readonly attribute boolean isConnected;
  [Pure]
  readonly attribute Document? ownerDocument;
  [Pure]
  Node getRootNode(optional GetRootNodeOptions options = {});
  [Pure]
  readonly attribute Node? parentNode;
  [Pure]
  readonly attribute Element? parentElement;
  [Pure]
  boolean hasChildNodes();
  [SameObject]
  readonly attribute NodeList childNodes;
  [Pure]
  readonly attribute Node? firstChild;
  [Pure]
  readonly attribute Node? lastChild;
  [Pure]
  readonly attribute Node? previousSibling;
  [Pure]
  readonly attribute Node? nextSibling;

  [CEReactions, SetterThrows, Pure]
           attribute DOMString? nodeValue;
  [CEReactions, SetterThrows, GetterCanOOM,
   SetterNeedsSubjectPrincipal=NonSystem, Pure]
           attribute DOMString? textContent;
  // These DOM methods cannot be accessed by UA Widget scripts
  // because the DOM element reflectors will be in the content scope,
  // instead of the desired UA Widget scope.
  [CEReactions, Throws, Func="IsNotUAWidget"]
  Node insertBefore(Node node, Node? child);
  [CEReactions, Throws, Func="IsNotUAWidget"]
  Node appendChild(Node node);
  [CEReactions, Throws, Func="IsNotUAWidget"]
  Node replaceChild(Node node, Node child);
  [CEReactions, Throws]
  Node removeChild(Node child);
  [CEReactions]
  undefined normalize();

  [CEReactions, Throws, Func="IsNotUAWidget"]
  Node cloneNode(optional boolean deep = false);
  [Pure]
  boolean isSameNode(Node? node);
  [Pure]
  boolean isEqualNode(Node? node);

  const unsigned short DOCUMENT_POSITION_DISCONNECTED = 0x01;
  const unsigned short DOCUMENT_POSITION_PRECEDING = 0x02;
  const unsigned short DOCUMENT_POSITION_FOLLOWING = 0x04;
  const unsigned short DOCUMENT_POSITION_CONTAINS = 0x08;
  const unsigned short DOCUMENT_POSITION_CONTAINED_BY = 0x10;
  const unsigned short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 0x20; // historical
  [Pure]
  unsigned short compareDocumentPosition(Node other);
  [Pure]
  boolean contains(Node? other);

  [Pure]
  DOMString? lookupPrefix(DOMString? namespace);
  [Pure]
  DOMString? lookupNamespaceURI(DOMString? prefix);
  [Pure]
  boolean isDefaultNamespace(DOMString? namespace);

  // Mozilla-specific stuff
  [ChromeOnly]
  readonly attribute Principal nodePrincipal;
  [ChromeOnly]
  readonly attribute URI? baseURIObject;
  [ChromeOnly]
  DOMString generateXPath();
  [ChromeOnly, Pure, BinaryName="flattenedTreeParentNodeNonInline"]
  readonly attribute Node? flattenedTreeParentNode;
  [ChromeOnly, Pure, BinaryName="isInNativeAnonymousSubtree"]
  readonly attribute boolean isNativeAnonymous;

  // Maybe this would be useful to authors? https://github.com/whatwg/dom/issues/826
  [Func="IsChromeOrUAWidget", Pure, BinaryName="containingShadow"]
  readonly attribute ShadowRoot? containingShadowRoot;

  // Mozilla devtools-specific stuff
  /**
   * If this element is a flex item (or has one or more anonymous box ancestors
   * that chain up to an anonymous flex item), then this method returns the
   * flex container that the flex item participates in. Otherwise, this method
   * returns null.
   */
  [ChromeOnly]
  readonly attribute Element? parentFlexElement;

#ifdef ACCESSIBILITY
  [Func="mozilla::dom::AccessibleNode::IsAOMEnabled", SameObject]
  readonly attribute AccessibleNode? accessibleNode;
#endif
};

dictionary GetRootNodeOptions {
  boolean composed = false;
};
 
/* ---------------------- NodeFilter ----------------------------- */ 
/* ./webidl/NodeFilter.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#interface-nodefilter
 */

[Exposed=Window]
callback interface NodeFilter {
  // Constants for acceptNode()
  const unsigned short FILTER_ACCEPT = 1;
  const unsigned short FILTER_REJECT = 2;
  const unsigned short FILTER_SKIP = 3;

  // Constants for whatToShow
  const unsigned long SHOW_ALL = 0xFFFFFFFF;
  const unsigned long SHOW_ELEMENT = 0x1;
  const unsigned long SHOW_ATTRIBUTE = 0x2; // historical
  const unsigned long SHOW_TEXT = 0x4;
  const unsigned long SHOW_CDATA_SECTION = 0x8; // historical
  const unsigned long SHOW_ENTITY_REFERENCE = 0x10; // historical
  const unsigned long SHOW_ENTITY = 0x20; // historical
  const unsigned long SHOW_PROCESSING_INSTRUCTION = 0x40;
  const unsigned long SHOW_COMMENT = 0x80;
  const unsigned long SHOW_DOCUMENT = 0x100;
  const unsigned long SHOW_DOCUMENT_TYPE = 0x200;
  const unsigned long SHOW_DOCUMENT_FRAGMENT = 0x400;
  const unsigned long SHOW_NOTATION = 0x800; // historical

  unsigned short acceptNode(Node node);
};
 
/* ---------------------- NodeIterator ----------------------------- */ 
/* ./webidl/NodeIterator.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface NodeIterator {
  [Constant]
  readonly attribute Node root;
  [Pure]
  readonly attribute Node? referenceNode;
  [Pure]
  readonly attribute boolean pointerBeforeReferenceNode;
  [Constant]
  readonly attribute unsigned long whatToShow;
  [Constant]
  readonly attribute NodeFilter? filter;

  [Throws]
  Node? nextNode();
  [Throws]
  Node? previousNode();

  undefined detach();
};
 
/* ---------------------- NodeList ----------------------------- */ 
/* ./webidl/NodeList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/2012/WD-dom-20120105/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[ProbablyShortLivingWrapper,
 Exposed=Window]
interface NodeList {
  getter Node? item(unsigned long index);
  readonly attribute unsigned long length;
  iterable<Node?>;
};
 
/* ---------------------- NonElementParentNode ----------------------------- */ 
/* ./webidl/NonElementParentNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#nonelementparentnode
 */
interface mixin NonElementParentNode {
  [Pure]
  Element? getElementById(DOMString elementId);
};
 
/* ---------------------- Notification ----------------------------- */ 
/* ./webidl/Notification.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://notifications.spec.whatwg.org/
 *
 * Copyright:
 * To the extent possible under law, the editors have waived all copyright and
 * related or neighboring rights to this work.
 */

[Exposed=(Window,Worker),
 Func="mozilla::dom::Notification::PrefEnabled"]
interface Notification : EventTarget {
  [Throws]
  constructor(DOMString title, optional NotificationOptions options = {});

  [GetterThrows]
  static readonly attribute NotificationPermission permission;

  [NewObject, Func="mozilla::dom::Notification::RequestPermissionEnabledForScope"]
  static Promise<NotificationPermission> requestPermission(optional NotificationPermissionCallback permissionCallback);

  attribute EventHandler onclick;

  attribute EventHandler onshow;

  attribute EventHandler onerror;

  attribute EventHandler onclose;

  [Pure]
  readonly attribute DOMString title;

  [Pure]
  readonly attribute NotificationDirection dir;

  [Pure]
  readonly attribute DOMString? lang;

  [Pure]
  readonly attribute DOMString? body;

  [Constant]
  readonly attribute DOMString? tag;

  [Pure]
  readonly attribute DOMString? icon;

  [Constant, Pref="dom.webnotifications.requireinteraction.enabled"]
  readonly attribute boolean requireInteraction;

  [Constant, Pref="dom.webnotifications.silent.enabled"]
  readonly attribute boolean silent;

  [Cached, Frozen, Pure, Pref="dom.webnotifications.vibrate.enabled"]
  readonly attribute sequence<unsigned long> vibrate;

  [Constant]
  readonly attribute any data;

  undefined close();
};

typedef (unsigned long or sequence<unsigned long>) VibratePattern;

dictionary NotificationOptions {
  NotificationDirection dir = "auto";
  DOMString lang = "";
  DOMString body = "";
  DOMString tag = "";
  DOMString icon = "";
  boolean requireInteraction = false;
  boolean silent = false;
  VibratePattern vibrate;
  any data = null;
  NotificationBehavior mozbehavior = {};
};

dictionary GetNotificationOptions {
  DOMString tag = "";
};

[GenerateToJSON]
dictionary NotificationBehavior {
  boolean noscreen = false;
  boolean noclear = false;
  boolean showOnlyOnce = false;
  DOMString soundFile = "";
  sequence<unsigned long> vibrationPattern;
};

enum NotificationPermission {
  "default",
  "denied",
  "granted"
};

callback NotificationPermissionCallback = undefined (NotificationPermission permission);

enum NotificationDirection {
  "auto",
  "ltr",
  "rtl"
};
 
/* ---------------------- NotificationEvent ----------------------------- */ 
/* ./webidl/NotificationEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://notifications.spec.whatwg.org/
 *
 * Copyright:
 * To the extent possible under law, the editors have waived all copyright and
 * related or neighboring rights to this work.
 */

[Exposed=ServiceWorker,Func="mozilla::dom::Notification::PrefEnabled"]
interface NotificationEvent : ExtendableEvent {
  constructor(DOMString type, NotificationEventInit eventInitDict);

  [BinaryName="notification_"]
  readonly attribute Notification notification;
};

dictionary NotificationEventInit : ExtendableEventInit {
  required Notification notification;
};
 
/* ---------------------- NotifyPaintEvent ----------------------------- */ 
/* ./webidl/NotifyPaintEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * The NotifyPaintEvent interface is used for the MozDOMAfterPaint
 * event, which fires at a window when painting has happened in
 * that window.
 */
[ChromeOnly,
 Exposed=Window]
interface NotifyPaintEvent : Event
{
  /**
   * Get a list of rectangles which are affected. The rectangles are
   * in CSS pixels relative to the viewport origin.
   */
  [ChromeOnly, NeedsCallerType]
  readonly attribute DOMRectList clientRects;

  /**
   * Get the bounding box of the rectangles which are affected. The rectangle
   * is in CSS pixels relative to the viewport origin.
   */
  [ChromeOnly, NeedsCallerType]
  readonly attribute DOMRect boundingClientRect;

  [ChromeOnly, NeedsCallerType]
  readonly attribute PaintRequestList paintRequests;

  [ChromeOnly, NeedsCallerType]
  readonly attribute unsigned long long transactionId;

  [ChromeOnly, NeedsCallerType]
  readonly attribute DOMHighResTimeStamp paintTimeStamp;
};
 
/* ---------------------- OfflineAudioCompletionEvent ----------------------------- */ 
/* ./webidl/OfflineAudioCompletionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary OfflineAudioCompletionEventInit : EventInit {
    required AudioBuffer renderedBuffer;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface OfflineAudioCompletionEvent : Event {
  constructor(DOMString type, OfflineAudioCompletionEventInit eventInitDict);

  readonly attribute AudioBuffer renderedBuffer;
};
 
/* ---------------------- OfflineAudioContext ----------------------------- */ 
/* ./webidl/OfflineAudioContext.webidl */ 
 
/* -*- Mode: IDL; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary OfflineAudioContextOptions {
             unsigned long numberOfChannels = 1;
    required unsigned long length;
    required float         sampleRate;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface OfflineAudioContext : BaseAudioContext {
    [Throws]
    constructor(OfflineAudioContextOptions contextOptions);
    [Throws]
    constructor(unsigned long numberOfChannels, unsigned long length,
                float sampleRate);

    [NewObject]
    Promise<AudioBuffer> startRendering();

    // TODO: Promise<undefined>   suspend (double suspendTime);

    readonly        attribute unsigned long length;
                    attribute EventHandler  oncomplete;
};
 
/* ---------------------- OffscreenCanvas ----------------------------- */ 
/* ./webidl/OffscreenCanvas.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://html.spec.whatwg.org/#the-offscreencanvas-interface
 */

typedef (OffscreenCanvasRenderingContext2D or ImageBitmapRenderingContext or WebGLRenderingContext or WebGL2RenderingContext or GPUCanvasContext) OffscreenRenderingContext;

dictionary ImageEncodeOptions {
  DOMString type = "image/png";
  unrestricted double quality;
};

enum OffscreenRenderingContextId { "2d", "bitmaprenderer", "webgl", "webgl2", "webgpu" };

[Exposed=(Window,Worker), Pref="gfx.offscreencanvas.enabled"]
interface OffscreenCanvas : EventTarget {
  [Throws]
  constructor([EnforceRange] unsigned long width, [EnforceRange] unsigned long height);

  [Pure, SetterThrows]
  attribute [EnforceRange] unsigned long width;
  [Pure, SetterThrows]
  attribute [EnforceRange] unsigned long height;

  [Throws]
  OffscreenRenderingContext? getContext(OffscreenRenderingContextId contextId,
                                        optional any contextOptions = null);

  [Throws]
  ImageBitmap transferToImageBitmap();
  [NewObject]
  Promise<Blob> convertToBlob(optional ImageEncodeOptions options = {});

  attribute EventHandler oncontextlost;
  attribute EventHandler oncontextrestored;

  // Deprecated by convertToBlob
  [Deprecated="OffscreenCanvasToBlob", NewObject]
  Promise<Blob> toBlob(optional DOMString type = "",
                       optional any encoderOptions);
};
 
/* ---------------------- OffscreenCanvasRenderingContext2D ----------------------------- */ 
/* ./webidl/OffscreenCanvasRenderingContext2D.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information on this interface, please see
 * https://html.spec.whatwg.org/#the-offscreen-2d-rendering-context
 */

[Exposed=(Window,Worker), Pref="gfx.offscreencanvas.enabled"]
interface OffscreenCanvasRenderingContext2D {
  [Throws]
  undefined commit();

  readonly attribute OffscreenCanvas canvas;
};

OffscreenCanvasRenderingContext2D includes CanvasState;
OffscreenCanvasRenderingContext2D includes CanvasTransform;
OffscreenCanvasRenderingContext2D includes CanvasCompositing;
OffscreenCanvasRenderingContext2D includes CanvasImageSmoothing;
OffscreenCanvasRenderingContext2D includes CanvasFillStrokeStyles;
OffscreenCanvasRenderingContext2D includes CanvasShadowStyles;
OffscreenCanvasRenderingContext2D includes CanvasFilters;
OffscreenCanvasRenderingContext2D includes CanvasRect;
OffscreenCanvasRenderingContext2D includes CanvasDrawPath;
OffscreenCanvasRenderingContext2D includes CanvasText;
OffscreenCanvasRenderingContext2D includes CanvasDrawImage;
OffscreenCanvasRenderingContext2D includes CanvasImageData;
OffscreenCanvasRenderingContext2D includes CanvasPathDrawingStyles;
OffscreenCanvasRenderingContext2D includes CanvasTextDrawingStyles;
OffscreenCanvasRenderingContext2D includes CanvasPathMethods;
 
/* ---------------------- OscillatorNode ----------------------------- */ 
/* ./webidl/OscillatorNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum OscillatorType {
  "sine",
  "square",
  "sawtooth",
  "triangle",
  "custom"
};

dictionary OscillatorOptions : AudioNodeOptions {
             OscillatorType type = "sine";
             float          frequency = 440;
             float          detune = 0;
             PeriodicWave   periodicWave;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface OscillatorNode : AudioScheduledSourceNode {
    [Throws]
    constructor(BaseAudioContext context,
                optional OscillatorOptions options = {});

    [SetterThrows]
    attribute OscillatorType type;

    readonly attribute AudioParam frequency; // in Hertz
    readonly attribute AudioParam detune; // in Cents

    undefined setPeriodicWave(PeriodicWave periodicWave);
};

// Mozilla extensions
OscillatorNode includes AudioNodePassThrough;
 
/* ---------------------- PageTransitionEvent ----------------------------- */ 
/* ./webidl/PageTransitionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * The PageTransitionEvent interface is used for the pageshow and
 * pagehide events, which are generic events that apply to both page
 * load/unload and saving/restoring a document from session history.
 */

[Exposed=Window]
interface PageTransitionEvent : Event
{
  constructor(DOMString type,
              optional PageTransitionEventInit eventInitDict = {});

  /**
   * Set to true if the document has been or will be persisted across
   * firing of the event.  For example, if a document is being cached in
   * session history, |persisted| is true for the PageHide event.
   */
  readonly attribute boolean persisted;

  // Whether the document is in the middle of a frame swap.
  [ChromeOnly]
  readonly attribute boolean inFrameSwap;
};

dictionary PageTransitionEventInit : EventInit
{
  boolean persisted = false;
  boolean inFrameSwap = false;
};
 
/* ---------------------- PaintRequest ----------------------------- */ 
/* ./webidl/PaintRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * These objects are exposed by the MozDOMAfterPaint event. Each one represents
 * a request to repaint a rectangle that was generated by the browser.
 */
[Exposed=Window]
interface PaintRequest {
  /**
   * The client rect where invalidation was triggered.
   */
  readonly attribute DOMRect clientRect;

  /**
   * The reason for the request, as a string. If an empty string, then we don't know
   * the reason (this is common). Reasons include "scroll repaint", meaning that we
   * needed to repaint the rectangle due to scrolling, and "scroll copy", meaning
   * that we updated the rectangle due to scrolling but instead of painting
   * manually, we were able to do a copy from another area of the screen.
   */
  readonly attribute DOMString reason;
};
 
/* ---------------------- PaintRequestList ----------------------------- */ 
/* ./webidl/PaintRequestList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface PaintRequestList {
  readonly attribute unsigned long length;
  getter PaintRequest? item(unsigned long index);
};
 
/* ---------------------- PaintWorkletGlobalScope ----------------------------- */ 
/* ./webidl/PaintWorkletGlobalScope.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.css-houdini.org/css-paint-api-1/#paintworkletglobalscope
 */

[Global=(Worklet,PaintWorklet),Exposed=PaintWorklet]
interface PaintWorkletGlobalScope : WorkletGlobalScope {
    undefined registerPaint(DOMString name, VoidFunction paintCtor);
};
 
/* ---------------------- PannerNode ----------------------------- */ 
/* ./webidl/PannerNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum PanningModelType {
  "equalpower",
  "HRTF"
};

enum DistanceModelType {
  "linear",
  "inverse",
  "exponential"
};

dictionary PannerOptions : AudioNodeOptions {
             PanningModelType  panningModel = "equalpower";
             DistanceModelType distanceModel = "inverse";
             float             positionX = 0;
             float             positionY = 0;
             float             positionZ = 0;
             float             orientationX = 1;
             float             orientationY = 0;
             float             orientationZ = 0;
             double            refDistance = 1;
             double            maxDistance = 10000;
             double            rolloffFactor = 1;
             double            coneInnerAngle = 360;
             double            coneOuterAngle = 360;
             double            coneOuterGain = 0;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface PannerNode : AudioNode {
    [Throws]
    constructor(BaseAudioContext context, optional PannerOptions options = {});

    // Default for stereo is equalpower
    attribute PanningModelType panningModel;

    // Uses a 3D cartesian coordinate system
    [Throws]
    undefined setPosition(double x, double y, double z);
    [Throws]
    undefined setOrientation(double x, double y, double z);

    // Cartesian coordinate for position
    readonly attribute AudioParam positionX;
    readonly attribute AudioParam positionY;
    readonly attribute AudioParam positionZ;

    // Cartesian coordinate for orientation
    readonly attribute AudioParam orientationX;
    readonly attribute AudioParam orientationY;
    readonly attribute AudioParam orientationZ;

    // Distance model and attributes
    attribute DistanceModelType distanceModel;
    [SetterThrows]
    attribute double refDistance;
    [SetterThrows]
    attribute double maxDistance;
    [SetterThrows]
    attribute double rolloffFactor;

    // Directional sound cone
    attribute double coneInnerAngle;
    attribute double coneOuterAngle;
    [SetterThrows]
    attribute double coneOuterGain;

};

// Mozilla extension
PannerNode includes AudioNodePassThrough;
 
/* ---------------------- ParentNode ----------------------------- */ 
/* ./webidl/ParentNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#interface-parentnode
 */

interface mixin ParentNode {
  [Constant]
  readonly attribute HTMLCollection children;
  [Pure]
  readonly attribute Element? firstElementChild;
  [Pure]
  readonly attribute Element? lastElementChild;
  [Pure]
  readonly attribute unsigned long childElementCount;

  [ChromeOnly]
  HTMLCollection getElementsByAttribute(DOMString name,
                                        [LegacyNullToEmptyString] DOMString value);
  [ChromeOnly, Throws]
  HTMLCollection getElementsByAttributeNS(DOMString? namespaceURI, DOMString name,
                                          [LegacyNullToEmptyString] DOMString value);

  [CEReactions, Throws, Unscopable]
  undefined prepend((Node or DOMString)... nodes);
  [CEReactions, Throws, Unscopable]
  undefined append((Node or DOMString)... nodes);
  [CEReactions, Throws, Unscopable]
  undefined replaceChildren((Node or DOMString)... nodes);

  [Throws, Pure]
  Element?  querySelector(UTF8String selectors);
  [Throws, Pure]
  NodeList  querySelectorAll(UTF8String selectors);
};
 
/* ---------------------- PaymentAddress ----------------------------- */ 
/* ./webidl/PaymentAddress.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https://www.w3.org/TR/payment-request/#paymentaddress-interface
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[SecureContext,
 Func="mozilla::dom::PaymentRequest::PrefEnabled",
 Exposed=Window]
interface PaymentAddress {
  [Default] object toJSON();

  readonly attribute DOMString              country;
  // TODO: Use FrozenArray once available. (Bug 1236777)
  // readonly attribute FrozenArray<DOMString> addressLine;
  [Frozen, Cached, Pure]
  readonly attribute sequence<DOMString>    addressLine;
  readonly attribute DOMString              region;
  readonly attribute DOMString              regionCode;
  readonly attribute DOMString              city;
  readonly attribute DOMString              dependentLocality;
  readonly attribute DOMString              postalCode;
  readonly attribute DOMString              sortingCode;
  readonly attribute DOMString              organization;
  readonly attribute DOMString              recipient;
  readonly attribute DOMString              phone;
};
 
/* ---------------------- PaymentMethodChangeEvent ----------------------------- */ 
/* ./webidl/PaymentMethodChangeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https://w3c.github.io/payment-request/#paymentmethodchangeevent-interface
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[SecureContext,
 Exposed=Window,
 Func="mozilla::dom::PaymentRequest::PrefEnabled"]
interface PaymentMethodChangeEvent : PaymentRequestUpdateEvent {
    constructor(DOMString type,
                optional PaymentMethodChangeEventInit eventInitDict = {});

    readonly attribute DOMString methodName;
    readonly attribute object?   methodDetails;
};

dictionary PaymentMethodChangeEventInit : PaymentRequestUpdateEventInit {
    DOMString methodName = "";
    object?   methodDetails = null;
};
 
/* ---------------------- PaymentRequest ----------------------------- */ 
/* ./webidl/PaymentRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https://w3c.github.io/payment-request/#paymentrequest-interface
 *   https://w3c.github.io/payment-request/#idl-index
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary PaymentMethodData {
  required DOMString           supportedMethods;
           object              data;
};

dictionary PaymentCurrencyAmount {
  required DOMString currency;
  required DOMString value;
};

dictionary PaymentItem {
  required DOMString             label;
  required PaymentCurrencyAmount amount;
           boolean               pending = false;
};

dictionary PaymentShippingOption {
  required DOMString             id;
  required DOMString             label;
  required PaymentCurrencyAmount amount;
           boolean               selected = false;
};

dictionary PaymentDetailsModifier {
  required DOMString             supportedMethods;
           PaymentItem           total;
           sequence<PaymentItem> additionalDisplayItems;
           object                data;
};

dictionary PaymentDetailsBase {
  sequence<PaymentItem>            displayItems;
  sequence<PaymentShippingOption>  shippingOptions;
  sequence<PaymentDetailsModifier> modifiers;
};

dictionary PaymentDetailsInit : PaymentDetailsBase {
           DOMString   id;
  required PaymentItem total;
};

[GenerateInitFromJSON, GenerateToJSON]
dictionary AddressErrors {
  DOMString addressLine;
  DOMString city;
  DOMString country;
  DOMString dependentLocality;
  DOMString organization;
  DOMString phone;
  DOMString postalCode;
  DOMString recipient;
  DOMString region;
  DOMString regionCode;
  DOMString sortingCode;
};

dictionary PaymentValidationErrors {
  PayerErrors payer;
  AddressErrors shippingAddress;
  DOMString error;
  object paymentMethod;
};

[GenerateInitFromJSON, GenerateToJSON]
dictionary PayerErrors {
  DOMString email;
  DOMString name;
  DOMString phone;
};

dictionary PaymentDetailsUpdate : PaymentDetailsBase {
  DOMString     error;
  AddressErrors shippingAddressErrors;
  PayerErrors payerErrors;
  object paymentMethodErrors;
  PaymentItem   total;
};

enum PaymentShippingType {
  "shipping",
  "delivery",
  "pickup"
};

dictionary PaymentOptions {
  boolean             requestPayerName = false;
  boolean             requestPayerEmail = false;
  boolean             requestPayerPhone = false;
  boolean             requestShipping = false;
  boolean             requestBillingAddress = false;
  PaymentShippingType shippingType = "shipping";
};

[SecureContext,
 Func="mozilla::dom::PaymentRequest::PrefEnabled",
 Exposed=Window]
interface PaymentRequest : EventTarget {
  [Throws]
  constructor(sequence<PaymentMethodData> methodData,
              PaymentDetailsInit details,
              optional PaymentOptions options = {});

  [NewObject]
  Promise<PaymentResponse> show(optional Promise<PaymentDetailsUpdate> detailsPromise);
  [NewObject]
  Promise<undefined>       abort();
  [NewObject]
  Promise<boolean>         canMakePayment();

  readonly attribute DOMString            id;
  readonly attribute PaymentAddress?      shippingAddress;
  readonly attribute DOMString?           shippingOption;
  readonly attribute PaymentShippingType? shippingType;

           attribute EventHandler         onmerchantvalidation;
           attribute EventHandler         onshippingaddresschange;
           attribute EventHandler         onshippingoptionchange;
           attribute EventHandler         onpaymentmethodchange;
};
 
/* ---------------------- PaymentRequestUpdateEvent ----------------------------- */ 
/* ./webidl/PaymentRequestUpdateEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https://w3c.github.io/payment-request/#paymentrequestupdateevent-interface
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[SecureContext,
 Func="mozilla::dom::PaymentRequest::PrefEnabled",
 Exposed=Window]
interface PaymentRequestUpdateEvent : Event {
  constructor(DOMString type,
              optional PaymentRequestUpdateEventInit eventInitDict = {});

  [Throws]
  undefined updateWith(Promise<PaymentDetailsUpdate> detailsPromise);
};

dictionary PaymentRequestUpdateEventInit : EventInit {
};
 
/* ---------------------- PaymentResponse ----------------------------- */ 
/* ./webidl/PaymentResponse.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this WebIDL file is
 *   https:/w3c.github.io/payment-request/#paymentresponse-interface
 *
 * Copyright © 2018 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum PaymentComplete {
  "success",
  "fail",
  "unknown"
};

[SecureContext,
 Func="mozilla::dom::PaymentRequest::PrefEnabled",
 Exposed=Window]
interface PaymentResponse : EventTarget {
  [Default] object toJSON();

  readonly attribute DOMString       requestId;
  readonly attribute DOMString       methodName;
  readonly attribute object          details;
  readonly attribute PaymentAddress? shippingAddress;
  readonly attribute DOMString?      shippingOption;
  readonly attribute DOMString?      payerName;
  readonly attribute DOMString?      payerEmail;
  readonly attribute DOMString?      payerPhone;

  [NewObject]
  Promise<undefined> complete(optional PaymentComplete result = "unknown");

  // If the dictionary argument has no required members, it must be optional.
  [NewObject]
  Promise<undefined> retry(optional PaymentValidationErrors errorFields = {});

  attribute EventHandler onpayerdetailchange;
};
 
/* ---------------------- PeerConnectionImpl ----------------------------- */ 
/* ./webidl/PeerConnectionImpl.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * PeerConnection.js' interface to the C++ PeerConnectionImpl.
 *
 * Do not confuse with RTCPeerConnection. This interface is purely for
 * communication between the PeerConnection JS DOM binding and the C++
 * implementation.
 *
 * See media/webrtc/signaling/include/PeerConnectionImpl.h
 *
 */

interface nsISupports;

callback ChainedOperation = Promise<any> ();

/* Must be created first. Observer events will be dispatched on the thread provided */
[ChromeOnly,
 Exposed=Window]
interface PeerConnectionImpl  {
  constructor();

  /* Must be called first. Observer events dispatched on the thread provided */
  [Throws]
  undefined initialize(PeerConnectionObserver observer, Window window);

  /* JSEP calls */
  [Throws]
  undefined createOffer(optional RTCOfferOptions options = {});
  [Throws]
  undefined createAnswer();
  [Throws]
  undefined setLocalDescription(long action, DOMString sdp);
  [Throws]
  undefined setRemoteDescription(long action, DOMString sdp);

  Promise<RTCStatsReport> getStats(MediaStreamTrack? selector);

  sequence<MediaStream> getRemoteStreams();

  /* Adds the tracks created by GetUserMedia */
  [Throws]
  RTCRtpTransceiver addTransceiver(RTCRtpTransceiverInit init,
                                   DOMString kind,
                                   MediaStreamTrack? sendTrack,
                                   boolean addTrackMagic);
  sequence<RTCRtpTransceiver> getTransceivers();

  [Throws]
  undefined closeStreams();

  [Throws]
  undefined enablePacketDump(unsigned long level,
                             mozPacketDumpType type,
                             boolean sending);

  [Throws]
  undefined disablePacketDump(unsigned long level,
                              mozPacketDumpType type,
                              boolean sending);

  /* As the ICE candidates roll in this one should be called each time
   * in order to keep the candidate list up-to-date for the next SDP-related
   * call PeerConnectionImpl does not parse ICE candidates, just sticks them
   * into the SDP.
   */
  [Throws]
  undefined addIceCandidate(DOMString candidate,
                            DOMString mid,
                            DOMString ufrag,
                            unsigned short? level);

  /* Shuts down threads, deletes state */
  [Throws]
  undefined close();

  [Throws]
  undefined setConfiguration(optional RTCConfiguration config = {});

  undefined restartIce();
  undefined restartIceNoRenegotiationNeeded();

  /* Notify DOM window if this plugin crash is ours. */
  boolean pluginCrash(unsigned long long pluginId, DOMString name);

  // Only throws if promise creation fails
  [Throws]
  Promise<undefined> onSetDescriptionSuccess(RTCSdpType type, boolean remote);

  undefined onSetDescriptionError();

  /* Attributes */
  /* This provides the implementation with the certificate it uses to
   * authenticate itself.  The JS side must set this before calling
   * createOffer/createAnswer or retrieving the value of fingerprint.  This has
   * to be delayed because generating the certificate takes some time. */
  attribute RTCCertificate certificate;
  [Constant]
  readonly attribute DOMString fingerprint;
  readonly attribute DOMString currentLocalDescription;
  readonly attribute DOMString pendingLocalDescription;
  readonly attribute DOMString currentRemoteDescription;
  readonly attribute DOMString pendingRemoteDescription;
  readonly attribute boolean? currentOfferer;
  readonly attribute boolean? pendingOfferer;

  readonly attribute RTCIceConnectionState iceConnectionState;
  readonly attribute RTCIceGatheringState iceGatheringState;
  readonly attribute RTCPeerConnectionState connectionState;
  readonly attribute RTCSignalingState signalingState;
  attribute DOMString id;

  [SetterThrows]
  attribute DOMString peerIdentity;
  readonly attribute boolean privacyRequested;

  readonly attribute RTCSctpTransport? sctp;

  /* Data channels */
  [Throws]
  RTCDataChannel createDataChannel(DOMString label, DOMString protocol,
    unsigned short type, boolean ordered,
    unsigned short maxTime, unsigned short maxNum,
    boolean externalNegotiated, unsigned short stream);

  [Throws]
  Promise<any> chain(ChainedOperation op);
  undefined updateNegotiationNeeded();

  boolean createdSender(RTCRtpSender sender);
};
 
/* ---------------------- PeerConnectionObserver ----------------------------- */ 
/* ./webidl/PeerConnectionObserver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

interface nsISupports;

dictionary PCErrorData
{
  required PCError name;
  required DOMString message;
  // Will need to add more stuff (optional) for RTCError
};

[ChromeOnly,
 JSImplementation="@mozilla.org/dom/peerconnectionobserver;1",
 Exposed=Window]
interface PeerConnectionObserver
{
  [Throws]
  constructor(RTCPeerConnection domPC);

  /* JSEP callbacks */
  undefined onCreateOfferSuccess(DOMString offer);
  undefined onCreateOfferError(PCErrorData error);
  undefined onCreateAnswerSuccess(DOMString answer);
  undefined onCreateAnswerError(PCErrorData error);
  undefined onSetDescriptionSuccess();
  undefined onSetDescriptionError(PCErrorData error);
  undefined onAddIceCandidateSuccess();
  undefined onAddIceCandidateError(PCErrorData error);
  undefined onIceCandidate(unsigned short level, DOMString mid, DOMString candidate, DOMString ufrag);

  /* Data channel callbacks */
  undefined notifyDataChannel(RTCDataChannel channel);

  /* Notification of one of several types of state changed */
  undefined onStateChange(PCObserverStateType state);

  /*
    Lets PeerConnectionImpl fire track events on the RTCPeerConnection
  */
  undefined fireTrackEvent(RTCRtpReceiver receiver, sequence<MediaStream> streams);

  /*
    Lets PeerConnectionImpl fire addstream events on the RTCPeerConnection
  */
  undefined fireStreamEvent(MediaStream stream);

  undefined fireNegotiationNeededEvent();

  /* Packet dump callback */
  undefined onPacket(unsigned long level, mozPacketDumpType type, boolean sending,
                     ArrayBuffer packet);
};
 
/* ---------------------- PeerConnectionObserverEnums ----------------------------- */ 
/* ./webidl/PeerConnectionObserverEnums.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This is in a separate file so it can be shared with unittests.
 */

enum PCObserverStateType {
    "None",
    "IceConnectionState",
    "IceGatheringState",
    "SignalingState",
    "ConnectionState",
};

enum PCError {
  "UnknownError",
  "InvalidAccessError",
  "InvalidStateError",
  "InvalidModificationError",
  "OperationError",
  "NotSupportedError",
  "SyntaxError",
  "NotReadableError",
  "TypeError",
  "RangeError",
  "InvalidCharacterError"
};
 
/* ---------------------- Performance ----------------------------- */ 
/* ./webidl/Performance.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/hr-time/#sec-performance
 * https://w3c.github.io/navigation-timing/#extensions-to-the-performance-interface
 * https://w3c.github.io/performance-timeline/#extensions-to-the-performance-interface
 * https://w3c.github.io/resource-timing/#sec-extensions-performance-interface
 * https://w3c.github.io/user-timing/#extensions-performance-interface
 *
 * Copyright © 2015 W3C® (MIT, ERCIM, Keio, Beihang).
 * W3C liability, trademark and document use rules apply.
 */

// DOMTimeStamp is deprecated, use EpochTimeStamp instead.
typedef unsigned long long DOMTimeStamp;
typedef unsigned long long EpochTimeStamp;
typedef double DOMHighResTimeStamp;
typedef sequence <PerformanceEntry> PerformanceEntryList;

// https://w3c.github.io/hr-time/#sec-performance
[Exposed=(Window,Worker)]
interface Performance : EventTarget {
  [DependsOn=DeviceState, Affects=Nothing]
  DOMHighResTimeStamp now();

  [Constant]
  readonly attribute DOMHighResTimeStamp timeOrigin;

  [Default] object toJSON();
};

// https://w3c.github.io/navigation-timing/#extensions-to-the-performance-interface
[Exposed=Window]
partial interface Performance {
  [Constant]
  readonly attribute PerformanceTiming timing;
  [Constant]
  readonly attribute PerformanceNavigation navigation;
};

// https://w3c.github.io/performance-timeline/#extensions-to-the-performance-interface
[Exposed=(Window,Worker)]
partial interface Performance {
  PerformanceEntryList getEntries();
  PerformanceEntryList getEntriesByType(DOMString entryType);
  PerformanceEntryList getEntriesByName(DOMString name, optional DOMString
    entryType);
};

// https://w3c.github.io/resource-timing/#sec-extensions-performance-interface
[Exposed=(Window,Worker)]
partial interface Performance {
  undefined clearResourceTimings();
  undefined setResourceTimingBufferSize(unsigned long maxSize);
  attribute EventHandler onresourcetimingbufferfull;
};

// GC microbenchmarks, pref-guarded, not for general use (bug 1125412)
[Exposed=Window]
partial interface Performance {
  [Pref="dom.enable_memory_stats"]
  readonly attribute object mozMemory;
};

// https://w3c.github.io/user-timing/#extensions-performance-interface
dictionary PerformanceMarkOptions {
  any detail;
  DOMHighResTimeStamp startTime;
};

// https://w3c.github.io/user-timing/#extensions-performance-interface
dictionary PerformanceMeasureOptions {
  any detail;
  (DOMString or DOMHighResTimeStamp) start;
  DOMHighResTimeStamp duration;
  (DOMString or DOMHighResTimeStamp) end;
};

// https://w3c.github.io/user-timing/#extensions-performance-interface
[Exposed=(Window,Worker)]
partial interface Performance {
  [Throws]
  PerformanceMark mark(DOMString markName, optional PerformanceMarkOptions markOptions = {});
  undefined clearMarks(optional DOMString markName);
  [Throws]
  PerformanceMeasure measure(DOMString measureName, optional (DOMString or PerformanceMeasureOptions) startOrMeasureOptions = {}, optional DOMString endMark);
  undefined clearMeasures(optional DOMString measureName);
};

[Exposed=Window]
partial interface Performance {
  [Pref="dom.enable_event_timing", SameObject]
  readonly attribute EventCounts eventCounts;
};
 
/* ---------------------- PerformanceEntry ----------------------------- */ 
/* ./webidl/PerformanceEntry.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/performance-timeline/#dom-performanceentry
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker)]
interface PerformanceEntry
{
  readonly attribute DOMString name;
  readonly attribute DOMString entryType;
  readonly attribute DOMHighResTimeStamp startTime;
  readonly attribute DOMHighResTimeStamp duration;

  [Default] object toJSON();
};
 
/* ---------------------- PerformanceEntryEvent ----------------------------- */ 
/* ./webidl/PerformanceEntryEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

dictionary PerformanceEntryEventInit : EventInit
{
  DOMString name = "";
  DOMString entryType = "";
  DOMHighResTimeStamp startTime = 0;
  DOMHighResTimeStamp duration = 0;
  double epoch = 0;
  DOMString origin = "";
};

[ChromeOnly,
 Exposed=Window]
interface PerformanceEntryEvent : Event
{
  constructor(DOMString type,
              optional PerformanceEntryEventInit eventInitDict = {});

  readonly attribute DOMString name;
  readonly attribute DOMString entryType;
  readonly attribute DOMHighResTimeStamp startTime;
  readonly attribute DOMHighResTimeStamp duration;
  readonly attribute double epoch;
  readonly attribute DOMString origin;
};
 
/* ---------------------- PerformanceEventTiming ----------------------------- */ 
/* ./webidl/PerformanceEventTiming.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/navigation-timing/#the-performancenavigation-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.enable_event_timing",
 Exposed=Window]
interface EventCounts {
    readonly maplike<DOMString, unsigned long long>;
};

[Pref="dom.enable_event_timing",
 Exposed=Window]
interface PerformanceEventTiming : PerformanceEntry {
    readonly attribute DOMHighResTimeStamp processingStart;
    readonly attribute DOMHighResTimeStamp processingEnd;
    readonly attribute boolean cancelable;
    readonly attribute Node? target;

    [Default] object toJSON();
};
 
/* ---------------------- PerformanceLargestContentfulPaint ----------------------------- */ 
/* ./webidl/PerformanceLargestContentfulPaint.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/largest-contentful-paint/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.enable_largest_contentful_paint",
 Exposed=Window]
interface LargestContentfulPaint : PerformanceEntry {
    readonly attribute DOMHighResTimeStamp renderTime;
    readonly attribute DOMHighResTimeStamp loadTime;
    readonly attribute unsigned long size;
    readonly attribute DOMString id;
    readonly attribute DOMString url;
    readonly attribute Element? element;
    [Default] object toJSON();
};
 
/* ---------------------- PerformanceMark ----------------------------- */ 
/* ./webidl/PerformanceMark.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/user-timing/#performancemark
 */

[Exposed=(Window,Worker)]
interface PerformanceMark : PerformanceEntry
{
  [Throws]
  constructor(DOMString markName, optional PerformanceMarkOptions markOptions = {});
  readonly attribute any detail;
};
 
/* ---------------------- PerformanceMeasure ----------------------------- */ 
/* ./webidl/PerformanceMeasure.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/user-timing/#performancemeasure
 */

[Exposed=(Window,Worker)]
interface PerformanceMeasure : PerformanceEntry
{
  readonly attribute any detail;
};
 
/* ---------------------- PerformanceNavigation ----------------------------- */ 
/* ./webidl/PerformanceNavigation.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/navigation-timing/#the-performancenavigation-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface PerformanceNavigation {
  const unsigned short TYPE_NAVIGATE = 0;
  const unsigned short TYPE_RELOAD = 1;
  const unsigned short TYPE_BACK_FORWARD = 2;
  const unsigned short TYPE_RESERVED = 255;

  readonly attribute unsigned short type;
  readonly attribute unsigned short redirectCount;

  [Default] object toJSON();
};
 
/* ---------------------- PerformanceNavigationTiming ----------------------------- */ 
/* ./webidl/PerformanceNavigationTiming.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/navigation-timing/#sec-PerformanceNavigationTiming
 *
 * Copyright © 2016 W3C® (MIT, ERCIM, Keio, Beihang).
 * W3C liability, trademark and document use rules apply.
 */

enum NavigationType {
  "navigate",
  "reload",
  "back_forward",
  "prerender"
};

[Exposed=Window,
 Func="mozilla::dom::PerformanceNavigationTiming::Enabled"]
interface PerformanceNavigationTiming : PerformanceResourceTiming {
  readonly        attribute DOMHighResTimeStamp unloadEventStart;
  readonly        attribute DOMHighResTimeStamp unloadEventEnd;
  readonly        attribute DOMHighResTimeStamp domInteractive;
  readonly        attribute DOMHighResTimeStamp domContentLoadedEventStart;
  readonly        attribute DOMHighResTimeStamp domContentLoadedEventEnd;
  readonly        attribute DOMHighResTimeStamp domComplete;
  readonly        attribute DOMHighResTimeStamp loadEventStart;
  readonly        attribute DOMHighResTimeStamp loadEventEnd;
  readonly        attribute NavigationType      type;
  readonly        attribute unsigned short      redirectCount;

  [Default] object toJSON();
};
 
/* ---------------------- PerformanceObserver ----------------------------- */ 
/* ./webidl/PerformanceObserver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/performance-timeline/#the-performanceobserver-interface
 */

dictionary PerformanceObserverInit {
  sequence<DOMString> entryTypes;
  DOMString type;
  boolean buffered;
  [Pref="dom.enable_event_timing"]
  DOMHighResTimeStamp durationThreshold;
};

callback PerformanceObserverCallback = undefined (PerformanceObserverEntryList entries,
                                                  PerformanceObserver observer);

[Pref="dom.enable_performance_observer",
 Exposed=(Window,Worker)]
interface PerformanceObserver {
    [Throws]
    constructor(PerformanceObserverCallback callback);

    [Throws] undefined observe(optional PerformanceObserverInit options = {});
    undefined disconnect();
    PerformanceEntryList takeRecords();
    static readonly attribute object supportedEntryTypes;
};
 
/* ---------------------- PerformanceObserverEntryList ----------------------------- */ 
/* ./webidl/PerformanceObserverEntryList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/performance-timeline/#the-performanceobserverentrylist-interface
 */

// XXX should be moved into Performance.webidl.
dictionary PerformanceEntryFilterOptions {
  DOMString name;
  DOMString entryType;
  DOMString initiatorType;
};

[Pref="dom.enable_performance_observer",
 Exposed=(Window,Worker)]
interface PerformanceObserverEntryList {
  PerformanceEntryList getEntries(optional PerformanceEntryFilterOptions filter = {});
  PerformanceEntryList getEntriesByType(DOMString entryType);
  PerformanceEntryList getEntriesByName(DOMString name,
                                        optional DOMString entryType);
};
 
/* ---------------------- PerformancePaintTiming ----------------------------- */ 
/* ./webidl/PerformancePaintTiming.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/paint-timing/#sec-PerformancePaintTiming
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window)]
interface PerformancePaintTiming : PerformanceEntry
{
};
 
/* ---------------------- PerformanceResourceTiming ----------------------------- */ 
/* ./webidl/PerformanceResourceTiming.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/resource-timing/#sec-performanceresourcetiming
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=(Window,Worker)]
interface PerformanceResourceTiming : PerformanceEntry
{
  readonly attribute DOMString initiatorType;
  readonly attribute DOMString nextHopProtocol;

  readonly attribute DOMHighResTimeStamp workerStart;

  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp redirectStart;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp redirectEnd;

  readonly attribute DOMHighResTimeStamp fetchStart;

  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp domainLookupStart;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp domainLookupEnd;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp connectStart;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp connectEnd;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp secureConnectionStart;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp requestStart;
  [NeedsSubjectPrincipal]
  readonly attribute DOMHighResTimeStamp responseStart;

  readonly attribute DOMHighResTimeStamp responseEnd;

  [NeedsSubjectPrincipal]
  readonly attribute unsigned long long transferSize;
  [NeedsSubjectPrincipal]
  readonly attribute unsigned long long encodedBodySize;
  [NeedsSubjectPrincipal]
  readonly attribute unsigned long long decodedBodySize;

  // TODO: Use FrozenArray once available. (Bug 1236777)
  // readonly attribute FrozenArray<PerformanceServerTiming> serverTiming;
  [SecureContext, Frozen, Cached, Pure, NeedsSubjectPrincipal]
  readonly attribute sequence<PerformanceServerTiming> serverTiming;

  [Default] object toJSON();
};
 
/* ---------------------- PerformanceServerTiming ----------------------------- */ 
/* ./webidl/PerformanceServerTiming.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/server-timing/#the-performanceservertiming-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[SecureContext,Exposed=(Window,Worker)]
interface PerformanceServerTiming {
  readonly attribute DOMString           name;
  readonly attribute DOMHighResTimeStamp duration;
  readonly attribute DOMString           description;

  [Default] object toJSON();
};
 
/* ---------------------- PerformanceTiming ----------------------------- */ 
/* ./webidl/PerformanceTiming.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/navigation-timing/#the-performancetiming-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface PerformanceTiming {
  readonly attribute unsigned long long navigationStart;
  readonly attribute unsigned long long unloadEventStart;
  readonly attribute unsigned long long unloadEventEnd;
  readonly attribute unsigned long long redirectStart;
  readonly attribute unsigned long long redirectEnd;
  readonly attribute unsigned long long fetchStart;
  readonly attribute unsigned long long domainLookupStart;
  readonly attribute unsigned long long domainLookupEnd;
  readonly attribute unsigned long long connectStart;
  readonly attribute unsigned long long connectEnd;
  readonly attribute unsigned long long secureConnectionStart;
  readonly attribute unsigned long long requestStart;
  readonly attribute unsigned long long responseStart;
  readonly attribute unsigned long long responseEnd;
  readonly attribute unsigned long long domLoading;
  readonly attribute unsigned long long domInteractive;
  readonly attribute unsigned long long domContentLoadedEventStart;
  readonly attribute unsigned long long domContentLoadedEventEnd;
  readonly attribute unsigned long long domComplete;
  readonly attribute unsigned long long loadEventStart;
  readonly attribute unsigned long long loadEventEnd;

  // This is a Chrome proprietary extension and not part of the
  // performance/navigation timing specification.
  // Returns 0 if a non-blank paint has not happened.
  [Pref="dom.performance.time_to_non_blank_paint.enabled"]
  readonly attribute unsigned long long timeToNonBlankPaint;

  // Returns 0 if a contentful paint has not happened.
  [Pref="dom.performance.time_to_contentful_paint.enabled"]
  readonly attribute unsigned long long timeToContentfulPaint;

  // This is a Mozilla proprietary extension and not part of the
  // performance/navigation timing specification. It marks the
  // completion of the first presentation flush after DOMContentLoaded.
  [Pref="dom.performance.time_to_dom_content_flushed.enabled"]
  readonly attribute unsigned long long timeToDOMContentFlushed;

  // This is a Chrome proprietary extension and not part of the
  // performance/navigation timing specification.
  // Returns 0 if a time-to-interactive measurement has not happened.
  [Pref="dom.performance.time_to_first_interactive.enabled"]
  readonly attribute unsigned long long timeToFirstInteractive;

  [Default] object toJSON();
};
 
/* ---------------------- PeriodicWave ----------------------------- */ 
/* ./webidl/PeriodicWave.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary PeriodicWaveConstraints {
  boolean disableNormalization = false;
};

dictionary PeriodicWaveOptions : PeriodicWaveConstraints {
             sequence<float> real;
             sequence<float> imag;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface PeriodicWave {
  [Throws]
  constructor(BaseAudioContext context,
              optional PeriodicWaveOptions options = {});
};
 
/* ---------------------- Permissions ----------------------------- */ 
/* ./webidl/Permissions.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/permissions/#permissions-interface
 */

enum PermissionName {
  "geolocation",
  "notifications",
  "push",
  "persistent-storage",
  "midi",
  "storage-access", // Defined in https://privacycg.github.io/storage-access/#permissions-integration
  "screen-wake-lock" // Defined in https://w3c.github.io/screen-wake-lock/
};

[GenerateInit]
dictionary PermissionDescriptor {
  required PermissionName name;
};

// https://webaudio.github.io/web-midi-api/#permissions-integration
[GenerateInit]
dictionary MidiPermissionDescriptor : PermissionDescriptor {
  boolean sysex = false;
};

// We don't implement `PushPermissionDescriptor` because we use a background
// message quota instead of `userVisibleOnly`.

[Exposed=Window]
interface Permissions {
  [NewObject]
  Promise<PermissionStatus> query(object permission);

  // http://w3c.github.io/permissions/#webdriver-command-set-permission
  [ChromeOnly, Throws]
  PermissionStatus parseSetParameters(PermissionSetParameters parameters);
};
 
/* ---------------------- PermissionStatus ----------------------------- */ 
/* ./webidl/PermissionStatus.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/permissions/#status-of-a-permission
 */

enum PermissionState {
  "granted",
  "denied",
  "prompt"
};

[Exposed=Window]
interface PermissionStatus : EventTarget {
  readonly attribute PermissionName name;
  readonly attribute PermissionState state;
  attribute EventHandler onchange;

  [ChromeOnly]
  readonly attribute UTF8String type;
};
 
/* ---------------------- Plugin ----------------------------- */ 
/* ./webidl/Plugin.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface Plugin {
  readonly attribute DOMString description;
  readonly attribute DOMString filename;
  readonly attribute DOMString name;

  readonly attribute unsigned long length;
  getter MimeType? item(unsigned long index);
  getter MimeType? namedItem(DOMString name);
};
 
/* ---------------------- PluginArray ----------------------------- */ 
/* ./webidl/PluginArray.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[LegacyUnenumerableNamedProperties,
 Exposed=Window]
interface PluginArray {
  undefined refresh();
  readonly attribute unsigned long length;
  getter Plugin? item(unsigned long index);
  getter Plugin? namedItem(DOMString name);
};
 
/* ---------------------- PointerEvent ----------------------------- */ 
/* ./webidl/PointerEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information see nsIPointerEvent.idl.
 *
 * Portions Copyright 2013 Microsoft Open Technologies, Inc. */

interface WindowProxy;

[Exposed=Window]
interface PointerEvent : MouseEvent
{
  constructor(DOMString type, optional PointerEventInit eventInitDict = {});

  readonly attribute long pointerId;

  readonly attribute long width;
  readonly attribute long height;
  readonly attribute float pressure;
  readonly attribute float tangentialPressure;
  readonly attribute long tiltX;
  readonly attribute long tiltY;
  readonly attribute long twist;

  readonly attribute DOMString pointerType;
  readonly attribute boolean isPrimary;

  [Func="mozilla::dom::PointerEvent::EnableGetCoalescedEvents"]
  sequence<PointerEvent> getCoalescedEvents();
  sequence<PointerEvent> getPredictedEvents();
};

dictionary PointerEventInit : MouseEventInit
{
  long pointerId = 0;
  long width = 1;
  long height = 1;
  float pressure = 0;
  float tangentialPressure = 0;
  long tiltX = 0;
  long tiltY = 0;
  long twist = 0;
  DOMString pointerType = "";
  boolean isPrimary = false;
  sequence<PointerEvent> coalescedEvents = [];
  sequence<PointerEvent> predictedEvents = [];
};
 
/* ---------------------- PopoverInvokerElement ----------------------------- */ 
/* ./webidl/PopoverInvokerElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/popover.html#popoverinvokerelement
 */

interface mixin PopoverInvokerElement {
  [Pref="dom.element.popover.enabled", CEReactions] attribute Element? popoverTargetElement;
  [Pref="dom.element.popover.enabled", CEReactions] attribute DOMString popoverTargetAction;
};
 
/* ---------------------- PopStateEvent ----------------------------- */ 
/* ./webidl/PopStateEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface PopStateEvent : Event
{
  constructor(DOMString type, optional PopStateEventInit eventInitDict = {});

  readonly attribute any state;
};

dictionary PopStateEventInit : EventInit
{
  any state = null;
};
 
/* ---------------------- PopupBlockedEvent ----------------------------- */ 
/* ./webidl/PopupBlockedEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */
interface URI;

[Exposed=Window]
interface PopupBlockedEvent : Event
{
  constructor(DOMString type,
              optional PopupBlockedEventInit eventInitDict = {});

  readonly attribute Window? requestingWindow;
  readonly attribute URI? popupWindowURI;
  readonly attribute DOMString? popupWindowName;
  readonly attribute DOMString? popupWindowFeatures;
};

dictionary PopupBlockedEventInit : EventInit
{
  Window? requestingWindow = null;
  URI? popupWindowURI = null;
  DOMString popupWindowName = "";
  DOMString popupWindowFeatures = "";
};
 
/* ---------------------- PositionStateEvent ----------------------------- */ 
/* ./webidl/PositionStateEvent.webidl */ 
 
/**
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

dictionary PositionStateEventInit : EventInit {
  required double duration;
  required double playbackRate;
  required double position;
};

[Exposed=Window, ChromeOnly]
interface PositionStateEvent : Event {
  constructor(DOMString type, optional PositionStateEventInit eventInitDict = {});
  readonly attribute double duration;
  readonly attribute double playbackRate;
  readonly attribute double position;
};
 
/* ---------------------- ProcessingInstruction ----------------------------- */ 
/* ./webidl/ProcessingInstruction.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#interface-processinginstruction
 * https://drafts.csswg.org/cssom/#requirements-on-user-agents-implementing-the-xml-stylesheet-processing-instruction
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// https://dom.spec.whatwg.org/#interface-processinginstruction
[Exposed=Window]
interface ProcessingInstruction : CharacterData {
  readonly attribute DOMString target;
};

// https://drafts.csswg.org/cssom/#requirements-on-user-agents-implementing-the-xml-stylesheet-processing-instruction
ProcessingInstruction includes LinkStyle;
 
/* ---------------------- ProgressEvent ----------------------------- */ 
/* ./webidl/ProgressEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=(Window,Worker)]
interface ProgressEvent : Event
{
  constructor(DOMString type, optional ProgressEventInit eventInitDict = {});

  readonly attribute boolean lengthComputable;
  readonly attribute unsigned long long loaded;
  readonly attribute unsigned long long total;
};

dictionary ProgressEventInit : EventInit
{
  boolean lengthComputable = false;
  unsigned long long loaded = 0;
  unsigned long long total = 0;
};
 
/* ---------------------- Promise ----------------------------- */ 
/* ./webidl/Promise.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This IDL file contains utilities to help connect JS promises to our
 * Web IDL infrastructure.
 */

callback PromiseJobCallback = undefined();

[TreatNonCallableAsNull]
callback AnyCallback = any (any value);

// Hack to allow us to have JS owning and properly tracing/CCing/etc a
// PromiseNativeHandler.
[LegacyNoInterfaceObject, Exposed=(Window,Worker)]
interface PromiseNativeHandler {
};
 
/* ---------------------- PromiseRejectionEvent ----------------------------- */ 
/* ./webidl/PromiseRejectionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/webappapis.html#the-promiserejectionevent-interface
 */

[Exposed=(Window,Worker)]
interface PromiseRejectionEvent : Event
{
  constructor(DOMString type, PromiseRejectionEventInit eventInitDict);

  [BinaryName="rejectedPromise"]
  readonly attribute Promise<any> promise;
  readonly attribute any reason;
};

dictionary PromiseRejectionEventInit : EventInit {
  required Promise<any> promise;
           any reason;
};
 
/* ---------------------- PushEvent ----------------------------- */ 
/* ./webidl/PushEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/push-api/
 */

[Pref="dom.push.enabled",
 Exposed=ServiceWorker]
interface PushEvent : ExtendableEvent {
  [Throws]
  constructor(DOMString type, optional PushEventInit eventInitDict = {});

  readonly attribute PushMessageData? data;
};

typedef (BufferSource or USVString) PushMessageDataInit;

dictionary PushEventInit : ExtendableEventInit {
  PushMessageDataInit data;
};
 
/* ---------------------- PushManager ----------------------------- */ 
/* ./webidl/PushManager.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* The origin of this IDL file is
* https://w3c.github.io/push-api/
*/

dictionary PushSubscriptionOptionsInit {
  // boolean userVisibleOnly = false;
  (BufferSource or DOMString)? applicationServerKey = null;
};

// The main thread JS implementation. Please see comments in
// dom/push/PushManager.h for the split between PushManagerImpl and PushManager.
[JSImplementation="@mozilla.org/push/PushManager;1",
 ChromeOnly,
 Exposed=Window]
interface PushManagerImpl {
  [Throws]
  constructor(DOMString scope);

  Promise<PushSubscription>    subscribe(optional PushSubscriptionOptionsInit options = {});
  Promise<PushSubscription?>   getSubscription();
  Promise<PermissionState> permissionState(optional PushSubscriptionOptionsInit options = {});
};

[Exposed=(Window,Worker), Func="PushManager::IsEnabled"]
interface PushManager {
  [Throws, ChromeOnly]
  constructor(DOMString scope);

  [Throws, UseCounter]
  Promise<PushSubscription>    subscribe(optional PushSubscriptionOptionsInit options = {});
  [Throws]
  Promise<PushSubscription?>   getSubscription();
  [Throws]
  Promise<PermissionState> permissionState(optional PushSubscriptionOptionsInit options = {});
};
 
/* ---------------------- PushMessageData ----------------------------- */ 
/* ./webidl/PushMessageData.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/push-api/
 */

[Pref="dom.push.enabled",
 Exposed=ServiceWorker]
interface PushMessageData
{
    [Throws]
    ArrayBuffer arrayBuffer();
    [Throws]
    Blob        blob();
    [Throws]
    any         json();
    USVString   text();
};
 
/* ---------------------- PushSubscription ----------------------------- */ 
/* ./webidl/PushSubscription.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* The origin of this IDL file is
* https://w3c.github.io/push-api/
*/

interface Principal;

enum PushEncryptionKeyName
{
  "p256dh",
  "auth"
};

dictionary PushSubscriptionKeys
{
  ByteString p256dh;
  ByteString auth;
};

dictionary PushSubscriptionJSON
{
  USVString endpoint;
  // FIXME: bug 1493860: should this "= {}" be here?  For that matter, this
  // PushSubscriptionKeys thing is not even in the spec; "keys" is a record
  // there.
  PushSubscriptionKeys keys = {};
  EpochTimeStamp? expirationTime;
};

dictionary PushSubscriptionInit
{
  required USVString endpoint;
  required USVString scope;
  ArrayBuffer? p256dhKey;
  ArrayBuffer? authSecret;
  BufferSource? appServerKey;
  EpochTimeStamp? expirationTime = null;
};

[Exposed=(Window,Worker), Func="ServiceWorkerVisible"]
interface PushSubscription
{
  [Throws, ChromeOnly]
  constructor(PushSubscriptionInit initDict);

  readonly attribute USVString endpoint;
  readonly attribute PushSubscriptionOptions options;
  readonly attribute EpochTimeStamp? expirationTime;
  [Throws]
  ArrayBuffer? getKey(PushEncryptionKeyName name);
  [NewObject, UseCounter]
  Promise<boolean> unsubscribe();

  // Implements the custom serializer specified in Push API, section 9.
  [Throws]
  PushSubscriptionJSON toJSON();
};
 
/* ---------------------- PushSubscriptionOptions ----------------------------- */ 
/* ./webidl/PushSubscriptionOptions.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* The origin of this IDL file is
* https://w3c.github.io/push-api/
*/

[Exposed=(Window,Worker), Func="ServiceWorkerVisible"]
interface PushSubscriptionOptions
{
  [SameObject, Throws]
  readonly attribute ArrayBuffer? applicationServerKey;
};
 
/* ---------------------- QueuingStrategy ----------------------------- */ 
/* ./webidl/QueuingStrategy.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#qs
 */

dictionary QueuingStrategy {
  unrestricted double highWaterMark;
  QueuingStrategySize size;
};

callback QueuingStrategySize = unrestricted double (optional any chunk);

dictionary QueuingStrategyInit {
  required unrestricted double highWaterMark;
};


[Exposed=*]
interface CountQueuingStrategy {
  constructor(QueuingStrategyInit init);

  readonly attribute unrestricted double highWaterMark;

  [Throws]
  readonly attribute Function size;
};

[Exposed=*]
interface ByteLengthQueuingStrategy {
  constructor(QueuingStrategyInit init);

  readonly attribute unrestricted double highWaterMark;

  [Throws]
  readonly attribute Function size;
};
 
/* ---------------------- RadioNodeList ----------------------------- */ 
/* ./webidl/RadioNodeList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/common-dom-interfaces.html#htmlformcontrolscollection-0
 *
 * © Copyright 2004-2014 Apple Computer, Inc., Mozilla Foundation, and
 * Opera Software ASA. You are granted a license to use, reproduce
 * and create derivative works of this document.
 */

[Exposed=Window]
interface RadioNodeList : NodeList {
  [NeedsCallerType]
  attribute DOMString value;
};
 
/* ---------------------- Range ----------------------------- */ 
/* ./webidl/Range.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dom.spec.whatwg.org/#range
 * http://domparsing.spec.whatwg.org/#dom-range-createcontextualfragment
 * http://dvcs.w3.org/hg/csswg/raw-file/tip/cssom-view/Overview.html#extensions-to-the-range-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// Use ProbablyShortLivingWrapper so that the Range object could be deleted
// as soon as possible, and thus slow down DOM operations less.
[Exposed=Window, ProbablyShortLivingWrapper]
interface Range : AbstractRange {
  [Throws]
  constructor();

  [Throws]
  readonly attribute Node commonAncestorContainer;

  [Throws, BinaryName="setStartJS"]
  undefined setStart(Node refNode, unsigned long offset);
  [Throws, BinaryName="setEndJS"]
  undefined setEnd(Node refNode, unsigned long offset);
  [Throws, BinaryName="setStartBeforeJS"]
  undefined setStartBefore(Node refNode);
  [Throws, BinaryName="setStartAfterJS"]
  undefined setStartAfter(Node refNode);
  [Throws, BinaryName="setEndBeforeJS"]
  undefined setEndBefore(Node refNode);
  [Throws, BinaryName="setEndAfterJS"]
  undefined setEndAfter(Node refNode);
  [BinaryName="collapseJS"]
  undefined collapse(optional boolean toStart = false);
  [Throws, BinaryName="selectNodeJS"]
  undefined selectNode(Node refNode);
  [Throws, BinaryName="selectNodeContentsJS"]
  undefined selectNodeContents(Node refNode);

  const unsigned short START_TO_START = 0;
  const unsigned short START_TO_END = 1;
  const unsigned short END_TO_END = 2;
  const unsigned short END_TO_START = 3;
  [Throws]
  short compareBoundaryPoints(unsigned short how, Range sourceRange);
  [CEReactions, Throws]
  undefined deleteContents();
  [CEReactions, Throws]
  DocumentFragment extractContents();
  [CEReactions, Throws]
  DocumentFragment cloneContents();
  [CEReactions, Throws]
  undefined insertNode(Node node);
  [CEReactions, Throws]
  undefined surroundContents(Node newParent);

  Range cloneRange();
  undefined detach();

  [Throws]
  boolean isPointInRange(Node node, unsigned long offset);
  [Throws]
  short comparePoint(Node node, unsigned long offset);

  [Throws]
  boolean intersectsNode(Node node);

  [Throws, BinaryName="ToString"]
  stringifier;
};

// http://domparsing.spec.whatwg.org/#dom-range-createcontextualfragment
partial interface Range {
  [CEReactions, Throws, UseCounter]
  DocumentFragment createContextualFragment(DOMString fragment);
};

// http://dvcs.w3.org/hg/csswg/raw-file/tip/cssom-view/Overview.html#extensions-to-the-range-interface
partial interface Range {
  DOMRectList? getClientRects();
  DOMRect getBoundingClientRect();
};

dictionary ClientRectsAndTexts {
  required DOMRectList rectList;
  required sequence<DOMString> textList;
};

partial interface Range {
  [ChromeOnly, Throws]
  ClientRectsAndTexts getClientRectsAndTexts();
};

// ChromeOnly methods that allow setting Range boundaries to cross
// shadow boundary.
partial interface Range {
  [ChromeOnly, Throws]
  undefined setStartAllowCrossShadowBoundary(Node refNode, unsigned long offset);
  [ChromeOnly, Throws]
  undefined setEndAllowCrossShadowBoundary(Node refNode, unsigned long offset);
};
 
/* ---------------------- ReadableByteStreamController ----------------------------- */ 
/* ./webidl/ReadableByteStreamController.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#rbs-controller-class-definition
 */

[Exposed=*]
interface ReadableByteStreamController {
  [Throws] // Throws on OOM
  readonly attribute ReadableStreamBYOBRequest? byobRequest;

  readonly attribute unrestricted double? desiredSize;

  [Throws]
  undefined close();

  [Throws]
  undefined enqueue(ArrayBufferView chunk);

  [Throws]
  undefined error(optional any e);
};
 
/* ---------------------- ReadableStream ----------------------------- */ 
/* ./webidl/ReadableStream.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#rs-class-definition
 */

[Exposed=*] // [Transferable] - See Bug 1562065
interface ReadableStream {
  [Throws]
  constructor(optional object underlyingSource, optional QueuingStrategy strategy = {});

  [Pref="dom.streams.from.enabled", Throws]
  static ReadableStream from(any asyncIterable);

  readonly attribute boolean locked;

  [NewObject]
  Promise<undefined> cancel(optional any reason);

  [Throws]
  ReadableStreamReader getReader(optional ReadableStreamGetReaderOptions options = {});

  [Throws]
  ReadableStream pipeThrough(ReadableWritablePair transform, optional StreamPipeOptions options = {});

  [NewObject]
  Promise<undefined> pipeTo(WritableStream destination, optional StreamPipeOptions options = {});

  [Throws]
  sequence<ReadableStream> tee();

  [GenerateReturnMethod]
  async iterable<any>(optional ReadableStreamIteratorOptions options = {});
};

enum ReadableStreamReaderMode { "byob" };

dictionary ReadableStreamGetReaderOptions {
  ReadableStreamReaderMode mode;
};

dictionary ReadableStreamIteratorOptions {
  boolean preventCancel = false;
};

dictionary ReadableWritablePair {
  required ReadableStream readable;
  required WritableStream writable;
};

dictionary StreamPipeOptions {
  boolean preventClose = false;
  boolean preventAbort = false;
  boolean preventCancel = false;
  AbortSignal signal;
};
 
/* ---------------------- ReadableStreamBYOBReader ----------------------------- */ 
/* ./webidl/ReadableStreamBYOBReader.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#byob-reader-class-definition
 */

[Exposed=*]
interface ReadableStreamBYOBReader {
  [Throws]
  constructor(ReadableStream stream);

  [NewObject]
  Promise<ReadableStreamReadResult> read(ArrayBufferView view);

  [Throws]
  undefined releaseLock();
};
ReadableStreamBYOBReader includes ReadableStreamGenericReader;
 
/* ---------------------- ReadableStreamBYOBRequest ----------------------------- */ 
/* ./webidl/ReadableStreamBYOBRequest.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#rs-byob-request-class-definition
 */

[Exposed=*]
interface ReadableStreamBYOBRequest {
  readonly attribute ArrayBufferView? view;

  [Throws]
  undefined respond([EnforceRange] unsigned long long bytesWritten);

  [Throws]
  undefined respondWithNewView(ArrayBufferView view);
};
 
/* ---------------------- ReadableStreamDefaultController ----------------------------- */ 
/* ./webidl/ReadableStreamDefaultController.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#rs-default-controller-class-definition
 */

[Exposed=*]
interface ReadableStreamDefaultController {
  readonly attribute unrestricted double? desiredSize;

  [Throws]
  undefined close();

  [Throws]
  undefined enqueue(optional any chunk);

  [Throws]
  undefined error(optional any e);
};
 
/* ---------------------- ReadableStreamDefaultReader ----------------------------- */ 
/* ./webidl/ReadableStreamDefaultReader.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://streams.spec.whatwg.org/#generic-reader-mixin-definition
 * https://streams.spec.whatwg.org/#default-reader-class-definition
 */

typedef (ReadableStreamDefaultReader or ReadableStreamBYOBReader) ReadableStreamReader;

enum ReadableStreamType { "bytes" };

interface mixin ReadableStreamGenericReader {
  readonly attribute Promise<undefined> closed;

  [NewObject]
  Promise<undefined> cancel(optional any reason);
};

[Exposed=*]
interface ReadableStreamDefaultReader {
  [Throws]
  constructor(ReadableStream stream);

  [NewObject]
  Promise<ReadableStreamReadResult> read();

  [Throws]
  undefined releaseLock();
};
ReadableStreamDefaultReader includes ReadableStreamGenericReader;


dictionary ReadableStreamReadResult {
 any value;
 boolean done;
};
 
/* ---------------------- ReferrerPolicy ----------------------------- */ 
/* ./webidl/ReferrerPolicy.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * For more information please see
 * https://w3c.github.io/webappsec-referrer-policy#idl-index
 */

enum ReferrerPolicy {
  "",
  "no-referrer",
  "no-referrer-when-downgrade",
  "origin",
  "origin-when-cross-origin",
  "unsafe-url", "same-origin",
  "strict-origin",
  "strict-origin-when-cross-origin"
};
 
/* ---------------------- Reporting ----------------------------- */ 
/* ./webidl/Reporting.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/reporting/#interface-reporting-observer
 */

[Pref="dom.reporting.enabled",
 Exposed=(Window,Worker)]
interface ReportBody {
  [Default] object toJSON
();
};

[Pref="dom.reporting.enabled",
 Exposed=(Window,Worker)]
interface Report {
  [Default] object toJSON
();
  readonly attribute DOMString type;
  readonly attribute DOMString url;
  readonly attribute ReportBody? body;
};

[Pref="dom.reporting.enabled",
 Exposed=(Window,Worker)]
interface ReportingObserver {
  [Throws]
  constructor(ReportingObserverCallback callback, optional ReportingObserverOptions options = {});
  undefined observe();
  undefined disconnect();
  ReportList takeRecords();
};

callback ReportingObserverCallback = undefined (sequence<Report> reports, ReportingObserver observer);

dictionary ReportingObserverOptions {
  sequence<DOMString> types;
  boolean buffered = false;
};

typedef sequence<Report> ReportList;

[Pref="dom.reporting.enabled",
 Exposed=Window]
interface DeprecationReportBody : ReportBody {
  readonly attribute DOMString id;
  // The spec currently has Date, but that's not a type that exists in Web IDL.
  // In any case, we always return null, so we just need _some_ nullable type
  // here.
  readonly attribute DOMTimeStamp? anticipatedRemoval;
  readonly attribute DOMString message;
  readonly attribute DOMString? sourceFile;
  readonly attribute unsigned long? lineNumber;
  readonly attribute unsigned long? columnNumber;
};

[Deprecated="DeprecatedTestingInterface",
 Pref="dom.reporting.testing.enabled",
 Exposed=(Window,DedicatedWorker)]
interface TestingDeprecatedInterface {
  constructor();

  [Deprecated="DeprecatedTestingMethod"]
  undefined deprecatedMethod();

  [Deprecated="DeprecatedTestingAttribute"]
  readonly attribute boolean deprecatedAttribute;
};

// Used internally to process the JSON
[GenerateInit]
dictionary ReportingHeaderValue {
  sequence<ReportingItem> items;
};

// Used internally to process the JSON
dictionary ReportingItem {
  // This is a long.
  any max_age;
  // This is a sequence of ReportingEndpoint.
  any endpoints;
  // This is a string. If missing, the value is 'default'.
  any group;
  boolean include_subdomains = false;
};

// Used internally to process the JSON
[GenerateInit]
dictionary ReportingEndpoint {
  // This is a string.
  any url;
  // This is an unsigned long.
  any priority;
  // This is an unsigned long.
  any weight;
};
 
/* ---------------------- Request ----------------------------- */ 
/* ./webidl/Request.webidl */ 
 
/* -*- Mode: IDL; tab-width: 1; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://fetch.spec.whatwg.org/#request-class
 */

typedef (Request or USVString) RequestInfo;
typedef unsigned long nsContentPolicyType;

[Exposed=(Window,Worker)]
interface Request {
  /**
   * Note that Requests created from system principal (ie "privileged"/chrome)
   * code will default to omitting credentials. You can override this behaviour
   * using the ``credentials`` member on the ``init`` dictionary.
   */
  [Throws]
  constructor(RequestInfo input, optional RequestInit init = {});

  readonly attribute ByteString method;
  readonly attribute USVString url;
  [SameObject, BinaryName="headers_"] readonly attribute Headers headers;

  readonly attribute RequestDestination destination;
  readonly attribute USVString referrer;
  [BinaryName="referrerPolicy_"]
  readonly attribute ReferrerPolicy referrerPolicy;
  readonly attribute RequestMode mode;
  readonly attribute RequestCredentials credentials;
  readonly attribute RequestCache cache;
  readonly attribute RequestRedirect redirect;
  readonly attribute DOMString integrity;

  [Pref="dom.fetchKeepalive.enabled"]
  readonly attribute boolean keepalive;

  // If a main-thread fetch() promise rejects, the error passed will be a
  // nsresult code.
  [ChromeOnly]
  readonly attribute boolean mozErrors;

  [BinaryName="getOrCreateSignal"]
  readonly attribute AbortSignal signal;

  [Throws,
   NewObject] Request clone();

  // Bug 1124638 - Allow chrome callers to set the context.
  [ChromeOnly]
  undefined overrideContentPolicyType(nsContentPolicyType context);
};
Request includes Body;

// <https://fetch.spec.whatwg.org/#requestinit>.
dictionary RequestInit {
  ByteString method;
  HeadersInit headers;
  BodyInit? body;
  USVString referrer;
  ReferrerPolicy referrerPolicy;
  RequestMode mode;
  /**
   * If not set, defaults to "same-origin", except for system principal (chrome)
   * requests where the default is "omit".
   */
  RequestCredentials credentials;
  RequestCache cache;
  RequestRedirect redirect;
  DOMString integrity;

  [Pref="dom.fetchKeepalive.enabled"]
  boolean keepalive;

  [ChromeOnly]
  boolean mozErrors;

  AbortSignal? signal;

  [Pref="network.fetchpriority.enabled"]
  RequestPriority priority;

  [Pref="dom.fetchObserver.enabled"]
  ObserverCallback observe;
};

enum RequestDestination {
  "",
  "audio", "audioworklet", "document", "embed", "font", "frame", "iframe",
  "image", "manifest", "object", "paintworklet", "report", "script",
  "sharedworker", "style",  "track", "video", "worker", "xslt"
};

enum RequestMode { "same-origin", "no-cors", "cors", "navigate" };
enum RequestCredentials { "omit", "same-origin", "include" };
enum RequestCache { "default", "no-store", "reload", "no-cache", "force-cache", "only-if-cached" };
enum RequestRedirect { "follow", "error", "manual" };
enum RequestPriority { "high" , "low" , "auto" };
 
/* ---------------------- ResizeObserver ----------------------------- */ 
/* ./webidl/ResizeObserver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://drafts.csswg.org/resize-observer/
 */

enum ResizeObserverBoxOptions {
    "border-box",
    "content-box",
    "device-pixel-content-box"
};

dictionary ResizeObserverOptions {
    ResizeObserverBoxOptions box = "content-box";
};

[Exposed=Window]
interface ResizeObserver {
    [Throws]
    constructor(ResizeObserverCallback callback);

    undefined observe(Element target, optional ResizeObserverOptions options = {});
    undefined unobserve(Element target);
    undefined disconnect();
};

callback ResizeObserverCallback = undefined (sequence<ResizeObserverEntry> entries, ResizeObserver observer);

[Exposed=Window]
interface ResizeObserverEntry {
    readonly attribute Element target;
    readonly attribute DOMRectReadOnly contentRect;
    // We are using [Pure, Cached, Frozen] sequence until `FrozenArray` is implemented.
    // See https://bugzilla.mozilla.org/show_bug.cgi?id=1236777 for more details.
    [Frozen, Cached, Pure]
    readonly attribute sequence<ResizeObserverSize> borderBoxSize;
    [Frozen, Cached, Pure]
    readonly attribute sequence<ResizeObserverSize> contentBoxSize;
    [Frozen, Cached, Pure]
    readonly attribute sequence<ResizeObserverSize> devicePixelContentBoxSize;
};

[Exposed=Window]
interface ResizeObserverSize {
    readonly attribute unrestricted double inlineSize;
    readonly attribute unrestricted double blockSize;
};
 
/* ---------------------- Response ----------------------------- */ 
/* ./webidl/Response.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://fetch.spec.whatwg.org/#response-class
 */

[Exposed=(Window,Worker)]
interface Response {
  // This should be constructor(optional BodyInit... but BodyInit doesn't
  // include ReadableStream yet because we don't want to expose Streams API to
  // Request.
  [Throws]
  constructor(optional (Blob or BufferSource or FormData or URLSearchParams or ReadableStream or USVString)? body = null,
              optional ResponseInit init = {});

  [NewObject] static Response error();
  [Throws,
   NewObject] static Response redirect(USVString url, optional unsigned short status = 302);
  [BinaryName=CreateFromJson, Throws,
   NewObject] static Response json(any data, optional ResponseInit init = {});

  readonly attribute ResponseType type;

  readonly attribute USVString url;
  readonly attribute boolean redirected;
  readonly attribute unsigned short status;
  readonly attribute boolean ok;
  readonly attribute ByteString statusText;
  [SameObject, BinaryName="headers_"] readonly attribute Headers headers;

  [Throws,
   NewObject] Response clone();

  [ChromeOnly, NewObject, Throws] Response cloneUnfiltered();

  // For testing only.
  [ChromeOnly] readonly attribute boolean hasCacheInfoChannel;
};
Response includes Body;

// This should be part of Body but we don't want to expose body to request yet.
// See bug 1387483.
partial interface Response {
  [GetterThrows]
  readonly attribute ReadableStream? body;
};

dictionary ResponseInit {
  unsigned short status = 200;
  ByteString statusText = "";
  HeadersInit headers;
};

enum ResponseType { "basic", "cors", "default", "error", "opaque", "opaqueredirect" };
 
/* ---------------------- RTCCertificate ----------------------------- */ 
/* ./webidl/RTCCertificate.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Specification: http://w3c.github.io/webrtc-pc/#certificate-management
 */

[GenerateInit]
dictionary RTCCertificateExpiration {
  [EnforceRange]
  DOMTimeStamp expires;
};

[Pref="media.peerconnection.enabled", Serializable,
 Exposed=Window]
interface RTCCertificate {
  readonly attribute DOMTimeStamp expires;
};
 
/* ---------------------- RTCConfiguration ----------------------------- */ 
/* ./webidl/RTCConfiguration.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/webrtc.html#idl-def-RTCConfiguration
 */

enum RTCIceCredentialType {
    "password",
};

dictionary RTCIceServer {
    (DOMString or sequence<DOMString>) urls;
    DOMString  url; //deprecated
    DOMString username;
    DOMString credential;
    RTCIceCredentialType credentialType = "password";
};

enum RTCIceTransportPolicy {
    "relay",
    "all"
};

enum RTCBundlePolicy {
    "balanced",
    "max-compat",
    "max-bundle"
};

dictionary RTCConfiguration {
    sequence<RTCIceServer> iceServers = [];
    RTCIceTransportPolicy  iceTransportPolicy = "all";
    RTCBundlePolicy bundlePolicy = "balanced";
    DOMString? peerIdentity = null;
    sequence<RTCCertificate> certificates = [];

    // Non-standard. Only here to be able to detect and warn in web console.
    // Uses DOMString over enum as a trade-off between type errors and safety.
    // TODO: Remove once sdpSemantics usage drops to zero (bug 1632243).
    DOMString sdpSemantics;
};
 
/* ---------------------- RTCDataChannel ----------------------------- */ 
/* ./webidl/RTCDataChannel.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

enum RTCDataChannelState {
  "connecting",
  "open",
  "closing",
  "closed"
};

enum RTCDataChannelType {
  "arraybuffer",
  "blob"
};

[Exposed=Window]
interface RTCDataChannel : EventTarget
{
  readonly attribute DOMString label;
  readonly attribute boolean negotiated;
  readonly attribute boolean ordered;
  readonly attribute boolean reliable;
  readonly attribute unsigned short? maxPacketLifeTime;
  readonly attribute unsigned short? maxRetransmits;
  readonly attribute USVString protocol;
  readonly attribute unsigned short? id;
  readonly attribute RTCDataChannelState readyState;
  readonly attribute unsigned long bufferedAmount;
  attribute unsigned long bufferedAmountLowThreshold;
  attribute EventHandler onopen;
  attribute EventHandler onerror;
  attribute EventHandler onclose;
  undefined close();
  attribute EventHandler onmessage;
  attribute EventHandler onbufferedamountlow;
  attribute RTCDataChannelType binaryType;
  [Throws]
  undefined send(DOMString data);
  [Throws]
  undefined send(Blob data);
  [Throws]
  undefined send(ArrayBuffer data);
  [Throws]
  undefined send(ArrayBufferView data);
};
 
/* ---------------------- RTCDataChannelEvent ----------------------------- */ 
/* ./webidl/RTCDataChannelEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/webrtc.html#idl-def-RTCDataChannelEvent
 */

dictionary RTCDataChannelEventInit : EventInit {
    required RTCDataChannel channel;
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCDataChannelEvent : Event {
    constructor(DOMString type, RTCDataChannelEventInit eventInitDict);

    readonly attribute RTCDataChannel channel;
};
 
/* ---------------------- RTCDtlsTransport ----------------------------- */ 
/* ./webidl/RTCDtlsTransport.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-pc/#rtcdtlstransport-interface
 */

enum RTCDtlsTransportState {
  "new",
  "connecting",
  "connected",
  "closed",
  "failed"
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCDtlsTransport : EventTarget {
  [SameObject] readonly attribute RTCIceTransport iceTransport;
  readonly attribute RTCDtlsTransportState state;
  attribute EventHandler onstatechange;
};
 
/* ---------------------- RTCDTMFSender ----------------------------- */ 
/* ./webidl/RTCDTMFSender.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc/#rtcdtmfsender
 */

[Exposed=Window]
interface RTCDTMFSender : EventTarget {
    [Throws]
    undefined insertDTMF(DOMString tones,
                         optional unsigned long duration = 100,
                         optional unsigned long interToneGap = 70);
    attribute EventHandler  ontonechange;
    readonly attribute DOMString toneBuffer;
};
 
/* ---------------------- RTCDTMFToneChangeEvent ----------------------------- */ 
/* ./webidl/RTCDTMFToneChangeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc/#rtcdtmftonechangeevent
 */

[Exposed=Window]
interface RTCDTMFToneChangeEvent : Event {
    constructor(DOMString type,
                optional RTCDTMFToneChangeEventInit eventInitDict = {});

    readonly attribute DOMString tone;
};

dictionary RTCDTMFToneChangeEventInit : EventInit {
    DOMString tone = "";
};
 
/* ---------------------- RTCEncodedAudioFrame ----------------------------- */ 
/* ./webidl/RTCEncodedAudioFrame.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-encoded-transform
 */

dictionary RTCEncodedAudioFrameMetadata {
    unsigned long synchronizationSource;
    octet payloadType;
    sequence<unsigned long> contributingSources;
    short sequenceNumber;
};

[Pref="media.peerconnection.enabled",
 Pref="media.peerconnection.scripttransform.enabled",
 Exposed=(Window,DedicatedWorker)]
interface RTCEncodedAudioFrame {
    readonly attribute unsigned long timestamp;
    attribute ArrayBuffer data;
    RTCEncodedAudioFrameMetadata getMetadata();
};
 
/* ---------------------- RTCEncodedVideoFrame ----------------------------- */ 
/* ./webidl/RTCEncodedVideoFrame.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc-encoded-transform
 */

// New enum for video frame types. Will eventually re-use the equivalent defined
// by WebCodecs.
enum RTCEncodedVideoFrameType {
    "empty",
    "key",
    "delta",
};

dictionary RTCEncodedVideoFrameMetadata {
    unsigned long long frameId;
    sequence<unsigned long long> dependencies;
    unsigned short width;
    unsigned short height;
    unsigned long spatialIndex;
    unsigned long temporalIndex;
    unsigned long synchronizationSource;
    octet payloadType;
    sequence<unsigned long> contributingSources;
    long long timestamp;    // microseconds
};

// New interfaces to define encoded video and audio frames. Will eventually
// re-use or extend the equivalent defined in WebCodecs.
[Pref="media.peerconnection.enabled",
 Pref="media.peerconnection.scripttransform.enabled",
 Exposed=(Window,DedicatedWorker)]
interface RTCEncodedVideoFrame {
    readonly attribute RTCEncodedVideoFrameType type;
    readonly attribute unsigned long timestamp;
    attribute ArrayBuffer data;
    RTCEncodedVideoFrameMetadata getMetadata();
};
 
/* ---------------------- RTCIceCandidate ----------------------------- */ 
/* ./webidl/RTCIceCandidate.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-pc/#rtcicecandidate-interface
 */

dictionary RTCIceCandidateInit {
  DOMString candidate = "";
  DOMString? sdpMid = null;
  unsigned short? sdpMLineIndex = null;
  DOMString? usernameFragment = null;
};

enum RTCIceComponent {
  "rtp",
  "rtcp"
};

enum RTCIceProtocol {
  "udp",
  "tcp"
};

enum RTCIceCandidateType {
  "host",
  "srflx",
  "prflx",
  "relay"
};

enum RTCIceTcpCandidateType {
  "active",
  "passive",
  "so"
};

[Pref="media.peerconnection.enabled",
 JSImplementation="@mozilla.org/dom/rtcicecandidate;1",
 Exposed=Window]
interface RTCIceCandidate {
  [Throws]
  constructor(optional RTCIceCandidateInit candidateInitDict = {});
  readonly attribute DOMString candidate;
  readonly attribute DOMString? sdpMid;
  readonly attribute unsigned short? sdpMLineIndex;
  readonly attribute DOMString? foundation;
  readonly attribute RTCIceComponent? component;
  readonly attribute unsigned long? priority;
  readonly attribute DOMString? address;
  readonly attribute RTCIceProtocol? protocol;
  readonly attribute unsigned short? port;
  readonly attribute RTCIceCandidateType? type;
  readonly attribute RTCIceTcpCandidateType? tcpType;
  readonly attribute DOMString? relatedAddress;
  readonly attribute unsigned short? relatedPort;
  readonly attribute DOMString? usernameFragment;
  // TODO: add remaining members relayProtocol and url (bug 1886013)
  // readonly attribute RTCIceServerTransportProtocol? relayProtocol;
  // readonly attribute DOMString? url;
  RTCIceCandidateInit toJSON();
};
 
/* ---------------------- RTCIceTransport ----------------------------- */ 
/* ./webidl/RTCIceTransport.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-pc/#dom-rtcicetransport
 */

enum RTCIceTransportState {
  "closed",
  "failed",
  "disconnected",
  "new",
  "checking",
  "completed",
  "connected"
};

enum RTCIceGathererState {
  "new",
  "gathering",
  "complete"
};

[Exposed=Window]
interface RTCIceTransport : EventTarget {
  // TODO(bug 1307994)
  // readonly attribute RTCIceRole role;
  // readonly attribute RTCIceComponent component;
  readonly attribute RTCIceTransportState state;
  readonly attribute RTCIceGathererState gatheringState;
  // TODO(bug 1307994)
  // sequence<RTCIceCandidate> getLocalCandidates();
  // sequence<RTCIceCandidate> getRemoteCandidates();
  // RTCIceCandidatePair? getSelectedCandidatePair();
  // RTCIceParameters? getLocalParameters();
  // RTCIceParameters? getRemoteParameters();
  attribute EventHandler onstatechange;
  attribute EventHandler ongatheringstatechange;
  // TODO(bug 1307994)
  // attribute EventHandler onselectedcandidatepairchange;
};
 
/* ---------------------- RTCIdentityAssertion ----------------------------- */ 
/* ./webidl/RTCIdentityAssertion.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/webrtc-pc/#idl-def-RTCIdentityAssertion
 */

dictionary RTCIdentityAssertion {
  DOMString idp;
  DOMString name;
};
 
/* ---------------------- RTCIdentityProvider ----------------------------- */ 
/* ./webidl/RTCIdentityProvider.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * http://w3c.github.io/webrtc-pc/ (with https://github.com/w3c/webrtc-pc/pull/178)
 */

[LegacyNoInterfaceObject,
 Exposed=Window]
interface RTCIdentityProviderRegistrar {
  undefined register(RTCIdentityProvider idp);

  /* Whether an IdP was passed to register() to chrome code. */
  [ChromeOnly]
  readonly attribute boolean hasIdp;
  /* The following two chrome-only functions forward to the corresponding
   * function on the registered IdP.  This is necessary because the
   * JS-implemented WebIDL can't see these functions on `idp` above, chrome JS
   * gets an Xray onto the content code that suppresses functions, see
   * https://developer.mozilla.org/en-US/docs/Xray_vision#Xrays_for_JavaScript_objects
   */
  /* Forward to idp.generateAssertion() */
  [ChromeOnly, Throws]
  Promise<RTCIdentityAssertionResult>
  generateAssertion(DOMString contents, DOMString origin,
                    optional RTCIdentityProviderOptions options = {});
  /* Forward to idp.validateAssertion() */
  [ChromeOnly, Throws]
  Promise<RTCIdentityValidationResult>
  validateAssertion(DOMString assertion, DOMString origin);
};

dictionary RTCIdentityProvider {
  required GenerateAssertionCallback generateAssertion;
  required ValidateAssertionCallback validateAssertion;
};

callback GenerateAssertionCallback =
  Promise<RTCIdentityAssertionResult>
    (DOMString contents, DOMString origin,
     RTCIdentityProviderOptions options);
callback ValidateAssertionCallback =
  Promise<RTCIdentityValidationResult> (DOMString assertion, DOMString origin);

dictionary RTCIdentityAssertionResult {
  required RTCIdentityProviderDetails idp;
  required DOMString assertion;
};

dictionary RTCIdentityProviderDetails {
  required DOMString domain;
  DOMString protocol = "default";
};

dictionary RTCIdentityValidationResult {
  required DOMString identity;
  required DOMString contents;
};

dictionary RTCIdentityProviderOptions {
  DOMString protocol = "default";
  DOMString usernameHint;
  DOMString peerIdentity;
};
 
/* ---------------------- RTCPeerConnection ----------------------------- */ 
/* ./webidl/RTCPeerConnection.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/webrtc-pc/#interface-definition
 */

callback RTCSessionDescriptionCallback = undefined (RTCSessionDescriptionInit description);
callback RTCPeerConnectionErrorCallback = undefined (DOMException error);
callback RTCStatsCallback = undefined (RTCStatsReport report);

enum RTCSignalingState {
    "stable",
    "have-local-offer",
    "have-remote-offer",
    "have-local-pranswer",
    "have-remote-pranswer",
    "closed"
};

enum RTCIceGatheringState {
    "new",
    "gathering",
    "complete"
};

enum RTCIceConnectionState {
  "closed",
  "failed",
  "disconnected",
  "new",
  "checking",
  "completed",
  "connected"
};

enum RTCPeerConnectionState {
  "closed",
  "failed",
  "disconnected",
  "new",
  "connecting",
  "connected"
};

enum mozPacketDumpType {
  "rtp", // dump unencrypted rtp as the MediaPipeline sees it
  "srtp", // dump encrypted rtp as the MediaPipeline sees it
  "rtcp", // dump unencrypted rtcp as the MediaPipeline sees it
  "srtcp" // dump encrypted rtcp as the MediaPipeline sees it
};

callback mozPacketCallback = undefined (unsigned long level,
                                        mozPacketDumpType type,
                                        boolean sending,
                                        ArrayBuffer packet);

dictionary RTCDataChannelInit {
  boolean        ordered = true;
  [EnforceRange]
  unsigned short maxPacketLifeTime;
  [EnforceRange]
  unsigned short maxRetransmits;
  DOMString      protocol = "";
  boolean        negotiated = false;
  [EnforceRange]
  unsigned short id;

  // These are deprecated due to renaming in the spec, but still supported for Fx53
  unsigned short maxRetransmitTime;
};

dictionary RTCOfferAnswerOptions {
//  boolean voiceActivityDetection = true; // TODO: support this (Bug 1184712)
};

dictionary RTCAnswerOptions : RTCOfferAnswerOptions {
};

dictionary RTCOfferOptions : RTCOfferAnswerOptions {
  boolean offerToReceiveVideo;
  boolean offerToReceiveAudio;
  boolean iceRestart = false;
};

[Pref="media.peerconnection.enabled",
 JSImplementation="@mozilla.org/dom/peerconnection;1",
 Exposed=Window]
interface RTCPeerConnection : EventTarget  {
  [Throws]
  constructor(optional RTCConfiguration configuration = {});

  [Throws, StaticClassOverride="mozilla::dom::RTCCertificate"]
  static Promise<RTCCertificate> generateCertificate (AlgorithmIdentifier keygenAlgorithm);

  undefined setIdentityProvider (DOMString provider,
                                 optional RTCIdentityProviderOptions options = {});
  Promise<DOMString> getIdentityAssertion();
  Promise<RTCSessionDescriptionInit> createOffer(optional RTCOfferOptions options = {});
  Promise<RTCSessionDescriptionInit> createAnswer(optional RTCAnswerOptions options = {});
  Promise<undefined> setLocalDescription(optional RTCLocalSessionDescriptionInit description = {});
  readonly attribute RTCSessionDescription? localDescription;
  readonly attribute RTCSessionDescription? currentLocalDescription;
  readonly attribute RTCSessionDescription? pendingLocalDescription;
  Promise<undefined> setRemoteDescription(RTCSessionDescriptionInit description);
  readonly attribute RTCSessionDescription? remoteDescription;
  readonly attribute RTCSessionDescription? currentRemoteDescription;
  readonly attribute RTCSessionDescription? pendingRemoteDescription;
  readonly attribute RTCSignalingState signalingState;
  Promise<undefined> addIceCandidate (optional (RTCIceCandidateInit or RTCIceCandidate) candidate = {});
  readonly attribute boolean? canTrickleIceCandidates;
  readonly attribute RTCIceGatheringState iceGatheringState;
  readonly attribute RTCIceConnectionState iceConnectionState;
  readonly attribute RTCPeerConnectionState connectionState;
  undefined restartIce ();
  readonly attribute Promise<RTCIdentityAssertion> peerIdentity;
  readonly attribute DOMString? idpLoginUrl;

  [ChromeOnly]
  attribute DOMString id;

  RTCConfiguration      getConfiguration ();
  undefined setConfiguration(optional RTCConfiguration configuration = {});
  [Deprecated="RTCPeerConnectionGetStreams"]
  sequence<MediaStream> getLocalStreams ();
  [Deprecated="RTCPeerConnectionGetStreams"]
  sequence<MediaStream> getRemoteStreams ();
  undefined addStream (MediaStream stream);

  // replaces addStream; fails if already added
  // because a track can be part of multiple streams, stream parameters
  // indicate which particular streams should be referenced in signaling

  RTCRtpSender addTrack(MediaStreamTrack track,
                        MediaStream... streams);
  undefined removeTrack(RTCRtpSender sender);

  [Throws]
  RTCRtpTransceiver addTransceiver((MediaStreamTrack or DOMString) trackOrKind,
                                   optional RTCRtpTransceiverInit init = {});

  sequence<RTCRtpSender> getSenders();
  sequence<RTCRtpReceiver> getReceivers();
  sequence<RTCRtpTransceiver> getTransceivers();

  [ChromeOnly]
  undefined mozSetPacketCallback(mozPacketCallback callback);
  [ChromeOnly]
  undefined mozEnablePacketDump(unsigned long level,
                                mozPacketDumpType type,
                                boolean sending);
  [ChromeOnly]
  undefined mozDisablePacketDump(unsigned long level,
                                 mozPacketDumpType type,
                                 boolean sending);

  undefined close ();
  attribute EventHandler onnegotiationneeded;
  attribute EventHandler onicecandidate;
  attribute EventHandler onsignalingstatechange;
  attribute EventHandler onaddstream; // obsolete
  attribute EventHandler onaddtrack;  // obsolete
  attribute EventHandler ontrack;     // replaces onaddtrack and onaddstream.
  attribute EventHandler oniceconnectionstatechange;
  attribute EventHandler onicegatheringstatechange;
  attribute EventHandler onconnectionstatechange;

  Promise<RTCStatsReport> getStats (optional MediaStreamTrack? selector = null);

  readonly attribute RTCSctpTransport? sctp;
  // Data channel.
  RTCDataChannel createDataChannel (DOMString label,
                                    optional RTCDataChannelInit dataChannelDict = {});
  attribute EventHandler ondatachannel;
};

// Legacy callback API

partial interface RTCPeerConnection {

  // Legacy Interface Extensions
  // Supporting the methods in this section is optional.
  // If these methods are supported
  // they must be implemented as defined
  // in section "Legacy Interface Extensions"
  Promise<undefined> createOffer(RTCSessionDescriptionCallback successCallback,
                                 RTCPeerConnectionErrorCallback failureCallback,
                                 optional RTCOfferOptions options = {});
  Promise<undefined> setLocalDescription(RTCLocalSessionDescriptionInit description,
                                         VoidFunction successCallback,
                                         RTCPeerConnectionErrorCallback failureCallback);
  Promise<undefined> createAnswer(RTCSessionDescriptionCallback successCallback,
                                  RTCPeerConnectionErrorCallback failureCallback);
  Promise<undefined> setRemoteDescription(RTCSessionDescriptionInit description,
                                          VoidFunction successCallback,
                                          RTCPeerConnectionErrorCallback failureCallback);
  Promise<undefined> addIceCandidate(RTCIceCandidateInit candidate,
                                     VoidFunction successCallback,
                                     RTCPeerConnectionErrorCallback failureCallback);
};
 
/* ---------------------- RTCPeerConnectionIceEvent ----------------------------- */ 
/* ./webidl/RTCPeerConnectionIceEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/webrtc.html#idl-def-RTCPeerConnectionIceEvent
 */

dictionary RTCPeerConnectionIceEventInit : EventInit {
  RTCIceCandidate? candidate = null;
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCPeerConnectionIceEvent : Event {
  constructor(DOMString type,
              optional RTCPeerConnectionIceEventInit eventInitDict = {});

  readonly attribute RTCIceCandidate? candidate;
};
 
/* ---------------------- RTCPeerConnectionStatic ----------------------------- */ 
/* ./webidl/RTCPeerConnectionStatic.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
  Right now, it is not possible to add static functions to a JS implemented
  interface (see bug 863952), so we need to create a simple interface with a
  trivial constructor and no data to hold these functions that really ought to
  be static in RTCPeerConnection.
  TODO(bcampen@mozilla.com) Merge this code into RTCPeerConnection once this
  limitation is gone. (Bug 1017082)
*/

enum RTCLifecycleEvent {
    "initialized",
    "icegatheringstatechange",
    "iceconnectionstatechange",
    "connectionstatechange",
};

callback PeerConnectionLifecycleCallback = undefined (RTCPeerConnection pc,
                                                      unsigned long long windowId,
                                                      RTCLifecycleEvent eventType);

[ChromeOnly,
 Pref="media.peerconnection.enabled",
 JSImplementation="@mozilla.org/dom/peerconnectionstatic;1",
 Exposed=Window]
interface RTCPeerConnectionStatic {
  [Throws]
  constructor();

  /* One slot per window (the window in which the register call is made),
     automatically unregistered when window goes away.
     Fires when a PC is created, and whenever the ICE connection state or
     gathering state changes. */
  undefined registerPeerConnectionLifecycleCallback(
    PeerConnectionLifecycleCallback cb);
};
 
/* ---------------------- RTCRtpCapabilities ----------------------------- */ 
/* ./webidl/RTCRtpCapabilities.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-pc/#dom-rtcrtpcapabilities
 */

dictionary RTCRtpCapabilities {
  required sequence<RTCRtpCodecCapability> codecs;
  required sequence<RTCRtpHeaderExtensionCapability> headerExtensions;
};

dictionary RTCRtpCodecCapability : RTCRtpCodec {
};

dictionary RTCRtpCodec {
  required DOMString mimeType;
  required unsigned long clockRate;
  unsigned short channels;
  DOMString sdpFmtpLine;
};

dictionary RTCRtpHeaderExtensionCapability {
  required DOMString uri;
};
 
/* ---------------------- RTCRtpParameters ----------------------------- */ 
/* ./webidl/RTCRtpParameters.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/webrtc-pc/#rtcrtpsender-interface
 */

enum RTCPriorityType {
  "very-low",
  "low",
  "medium",
  "high"
};

enum RTCDegradationPreference {
  "maintain-framerate",
  "maintain-resolution",
  "balanced"
};

dictionary RTCRtpEncodingParameters {
  boolean                  active = true;
  // From https://www.w3.org/TR/webrtc-priority/
  RTCPriorityType          priority = "low";
  unsigned long            maxBitrate;
  DOMString                rid;
  double                   scaleResolutionDownBy;
  // From https://w3c.github.io/webrtc-extensions/#rtcrtpencodingparameters-dictionary
  double                   maxFramerate;
};

dictionary RTCRtpHeaderExtensionParameters {
  DOMString      uri;
  unsigned short id;
  boolean        encrypted;
};

dictionary RTCRtcpParameters {
  DOMString cname;
  boolean   reducedSize;
};

dictionary RTCRtpCodecParameters {
  unsigned short payloadType;
  DOMString      mimeType;
  unsigned long  clockRate;
  unsigned short channels = 1;
  DOMString      sdpFmtpLine;
};

dictionary RTCRtpParameters {
  // We do not support these, but every wpt test involving parameters insists
  // that these be present, regardless of whether the test-case has anything to
  // do with these in particular (see validateRtpParameters).
  sequence<RTCRtpHeaderExtensionParameters> headerExtensions;
  RTCRtcpParameters                         rtcp;
  sequence<RTCRtpCodecParameters>           codecs;
};

dictionary RTCRtpSendParameters : RTCRtpParameters {
  DOMString transactionId;
  required sequence<RTCRtpEncodingParameters> encodings;
};
 
/* ---------------------- RTCRtpReceiver ----------------------------- */ 
/* ./webidl/RTCRtpReceiver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://lists.w3.org/Archives/Public/public-webrtc/2014May/0067.html
 */

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCRtpReceiver {
  readonly attribute MediaStreamTrack   track;
  readonly attribute RTCDtlsTransport?  transport;
  static RTCRtpCapabilities? getCapabilities(DOMString kind);
  sequence<RTCRtpContributingSource>    getContributingSources();
  sequence<RTCRtpSynchronizationSource> getSynchronizationSources();
  [NewObject]
  Promise<RTCStatsReport>               getStats();

  // test-only: for testing getContributingSources
  [ChromeOnly]
  undefined mozInsertAudioLevelForContributingSource(unsigned long source,
                                                     DOMHighResTimeStamp timestamp,
                                                     unsigned long rtpTimestamp,
                                                     boolean hasLevel,
                                                     byte level);
};

//https://w3c.github.io/webrtc-extensions/#rtcrtpreceiver-jitterbuffertarget-rtcrtpreceiver-interface
partial interface RTCRtpReceiver {
  [Throws]
  attribute DOMHighResTimeStamp? jitterBufferTarget;
};

// https://w3c.github.io/webrtc-encoded-transform/#specification
partial interface RTCRtpReceiver {
  [SetterThrows,
   Pref="media.peerconnection.scripttransform.enabled"] attribute RTCRtpTransform? transform;
};
 
/* ---------------------- RTCRtpScriptTransform ----------------------------- */ 
/* ./webidl/RTCRtpScriptTransform.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc-encoded-transform
 */

// Spec version is commented out (uncomment if SFrameTransform is implemented)
// typedef (SFrameTransform or RTCRtpScriptTransform) RTCRtpTransform;
typedef RTCRtpScriptTransform RTCRtpTransform;

[Pref="media.peerconnection.enabled",
 Pref="media.peerconnection.scripttransform.enabled",
 Exposed=Window]
interface RTCRtpScriptTransform {
  [Throws]
  constructor(Worker worker, optional any options, optional sequence<object> transfer);
};
 
/* ---------------------- RTCRtpScriptTransformer ----------------------------- */ 
/* ./webidl/RTCRtpScriptTransformer.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc-encoded-transform
 */

[Pref="media.peerconnection.enabled",
 Pref="media.peerconnection.scripttransform.enabled",
 Exposed=DedicatedWorker]
interface RTCRtpScriptTransformer {
    readonly attribute ReadableStream readable;
    readonly attribute WritableStream writable;
    [Throws] readonly attribute any options;
    Promise<unsigned long long> generateKeyFrame(optional DOMString rid);
    Promise<undefined> sendKeyFrameRequest();
};
 
/* ---------------------- RTCRtpSender ----------------------------- */ 
/* ./webidl/RTCRtpSender.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/webrtc-pc/#rtcrtpsender-interface
 */

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCRtpSender {
  readonly attribute MediaStreamTrack? track;
  readonly attribute RTCDtlsTransport? transport;
  static RTCRtpCapabilities? getCapabilities(DOMString kind);
  [NewObject]
  Promise<undefined> setParameters (RTCRtpSendParameters parameters);
  RTCRtpSendParameters getParameters();
  [Throws]
  Promise<undefined> replaceTrack(MediaStreamTrack? withTrack);
  [Throws]
  undefined setStreams(MediaStream... streams);
  [NewObject]
  Promise<RTCStatsReport> getStats();
  readonly attribute RTCDTMFSender? dtmf;
  [ChromeOnly]
  sequence<MediaStream> getStreams();
  [ChromeOnly]
  undefined setStreamsImpl(MediaStream... streams);
  [ChromeOnly]
  undefined setTrack(MediaStreamTrack? track);
};

// https://w3c.github.io/webrtc-encoded-transform/#specification
partial interface RTCRtpSender {
  [SetterThrows,
   Pref="media.peerconnection.scripttransform.enabled"] attribute RTCRtpTransform? transform;
};
 
/* ---------------------- RTCRtpSources ----------------------------- */ 
/* ./webidl/RTCRtpSources.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-pc/ Editor's Draft 18 January 2018
 */

dictionary RTCRtpContributingSource {
    required DOMHighResTimeStamp timestamp;
    required unsigned long source;
    double audioLevel;
    required unsigned long rtpTimestamp;
};

dictionary RTCRtpSynchronizationSource : RTCRtpContributingSource {
    boolean? voiceActivityFlag;
};

/* Internal enum of types used by RTCRtpSourceEntry */
enum RTCRtpSourceEntryType {
    "contributing",
    "synchronization",
};
/* Internal shared representation of Contributing and Synchronization sources */
dictionary RTCRtpSourceEntry : RTCRtpSynchronizationSource {
    required RTCRtpSourceEntryType sourceType;
};
 
/* ---------------------- RTCRtpTransceiver ----------------------------- */ 
/* ./webidl/RTCRtpTransceiver.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/webrtc-pc/#rtcrtptransceiver-interface
 */

enum RTCRtpTransceiverDirection {
    "sendrecv",
    "sendonly",
    "recvonly",
    "inactive",
    "stopped"
};

dictionary RTCRtpTransceiverInit {
    RTCRtpTransceiverDirection         direction = "sendrecv";
    sequence<MediaStream>              streams = [];
    sequence<RTCRtpEncodingParameters> sendEncodings = [];
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCRtpTransceiver {
    readonly attribute DOMString?                  mid;
    [SameObject]
    readonly attribute RTCRtpSender                sender;
    [SameObject]
    readonly attribute RTCRtpReceiver              receiver;
    readonly attribute boolean                     stopped;
    [SetterThrows]
             attribute RTCRtpTransceiverDirection  direction;
    readonly attribute RTCRtpTransceiverDirection? currentDirection;

    [Throws]
    undefined stop();
    // TODO: bug 1396922
    // undefined setCodecPreferences(sequence<RTCRtpCodecCapability> codecs);

    [ChromeOnly]
    undefined setDirectionInternal(RTCRtpTransceiverDirection direction);

    [ChromeOnly]
    DOMString getKind();
    [ChromeOnly]
    boolean hasBeenUsedToSend();
};
 
/* ---------------------- RTCSctpTransport ----------------------------- */ 
/* ./webidl/RTCSctpTransport.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webrtc-pc/#dom-rtcsctptransport
 */

enum RTCSctpTransportState {
  "connecting",
  "connected",
  "closed"
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCSctpTransport : EventTarget {
  readonly attribute RTCDtlsTransport transport;
  readonly attribute RTCSctpTransportState state;
  readonly attribute unrestricted double maxMessageSize;
  readonly attribute unsigned short? maxChannels;
  attribute EventHandler onstatechange;
};
 
/* ---------------------- RTCSessionDescription ----------------------------- */ 
/* ./webidl/RTCSessionDescription.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc/#rtcsessiondescription-class
 */

enum RTCSdpType {
  "offer",
  "pranswer",
  "answer",
  "rollback"
};

dictionary RTCSessionDescriptionInit {
  required RTCSdpType type;
  DOMString sdp = "";
};

dictionary RTCLocalSessionDescriptionInit {
  RTCSdpType type;
  DOMString sdp = "";
};

[Pref="media.peerconnection.enabled",
 JSImplementation="@mozilla.org/dom/rtcsessiondescription;1",
 Exposed=Window]
interface RTCSessionDescription {
  [Throws]
  constructor(RTCSessionDescriptionInit descriptionInitDict);

  // These should be readonly, but writing causes deprecation warnings for a bit
  attribute RTCSdpType type;
  attribute DOMString sdp;

  [Default] object toJSON();
};
 
/* ---------------------- RTCStatsReport ----------------------------- */ 
/* ./webidl/RTCStatsReport.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/2011/webrtc/editor/webrtc.html#rtcstatsreport-object
 * http://www.w3.org/2011/04/webrtc/wiki/Stats
 * https://www.w3.org/TR/webrtc-stats/
 */

enum RTCStatsType {
  "codec",
  "inbound-rtp",
  "outbound-rtp",
  "remote-inbound-rtp",
  "remote-outbound-rtp",
  "media-source",
  "peer-connection",
  "csrc",
  "data-channel",
  "session",
  "track",
  "transport",
  "candidate-pair",
  "local-candidate",
  "remote-candidate"
};

dictionary RTCStats {
  DOMHighResTimeStamp timestamp;
  RTCStatsType type;
  DOMString id;
};

dictionary RTCRtpStreamStats : RTCStats {
  required unsigned long ssrc;
  required DOMString kind;
  DOMString mediaType;
  DOMString transportId;
  DOMString codecId;
};

dictionary RTCCodecStats : RTCStats {
  required unsigned long payloadType;
  RTCCodecType  codecType;
  required DOMString     transportId;
  required DOMString     mimeType;
  unsigned long clockRate;
  unsigned long channels;
  DOMString     sdpFmtpLine;
};

enum RTCCodecType {
  "encode",
  "decode",
};

dictionary RTCReceivedRtpStreamStats: RTCRtpStreamStats {
  unsigned long long packetsReceived;
  long long packetsLost;
  double jitter;
  unsigned long discardedPackets; // non-standard alias for packetsDiscarded
  unsigned long packetsDiscarded;
};

dictionary RTCInboundRtpStreamStats : RTCReceivedRtpStreamStats {
  required DOMString trackIdentifier;
  DOMString remoteId;
  unsigned long framesDecoded;
  unsigned long framesDropped;
  unsigned long frameWidth;
  unsigned long frameHeight;
  double framesPerSecond;
  unsigned long long qpSum;
  double totalDecodeTime;
  double totalInterFrameDelay;
  double totalSquaredInterFrameDelay;
  DOMHighResTimeStamp lastPacketReceivedTimestamp;
  unsigned long long headerBytesReceived;
  unsigned long long fecPacketsReceived;
  unsigned long long fecPacketsDiscarded;
  unsigned long long bytesReceived;
  unsigned long nackCount;
  unsigned long firCount;
  unsigned long pliCount;
  double totalProcessingDelay;
  // Always missing from libwebrtc
  // DOMHighResTimeStamp  estimatedPlayoutTimestamp;
  double jitterBufferDelay;
  unsigned long long jitterBufferEmittedCount;
  unsigned long long totalSamplesReceived;
  unsigned long long concealedSamples;
  unsigned long long silentConcealedSamples;
  unsigned long long concealmentEvents;
  unsigned long long insertedSamplesForDeceleration;
  unsigned long long removedSamplesForAcceleration;
  double audioLevel;
  double totalAudioEnergy;
  double totalSamplesDuration;
  unsigned long framesReceived;
};

dictionary RTCRemoteInboundRtpStreamStats : RTCReceivedRtpStreamStats {
  DOMString localId;
  double roundTripTime;
  double totalRoundTripTime;
  double fractionLost;
  unsigned long long roundTripTimeMeasurements;
};

dictionary RTCSentRtpStreamStats : RTCRtpStreamStats {
  unsigned long packetsSent;
  unsigned long long bytesSent;
};

dictionary RTCOutboundRtpStreamStats : RTCSentRtpStreamStats {
  DOMString remoteId;
  unsigned long framesEncoded;
  unsigned long long qpSum;
  unsigned long nackCount;
  unsigned long firCount;
  unsigned long pliCount;
  unsigned long long headerBytesSent;
  unsigned long long retransmittedPacketsSent;
  unsigned long long retransmittedBytesSent;
  unsigned long long totalEncodedBytesTarget;
  unsigned long frameWidth;
  unsigned long frameHeight;
  double framesPerSecond;
  unsigned long framesSent;
  unsigned long hugeFramesSent;
  double totalEncodeTime;
};

dictionary RTCRemoteOutboundRtpStreamStats : RTCSentRtpStreamStats {
  DOMString localId;
  DOMHighResTimeStamp remoteTimestamp;
};

dictionary RTCMediaSourceStats : RTCStats {
  required DOMString trackIdentifier;
  required DOMString kind;
};

dictionary RTCVideoSourceStats : RTCMediaSourceStats {
  unsigned long   width;
  unsigned long   height;
  unsigned long   frames;
  double          framesPerSecond;
};

dictionary RTCPeerConnectionStats : RTCStats {
  unsigned long dataChannelsOpened;
  unsigned long dataChannelsClosed;
};

dictionary RTCRTPContributingSourceStats : RTCStats {
  unsigned long contributorSsrc;
  DOMString     inboundRtpStreamId;
};

dictionary RTCDataChannelStats : RTCStats {
  DOMString           label;
  DOMString           protocol;
  long                dataChannelIdentifier;
  // RTCTransportId is not yet implemented - Bug 1225723
  // DOMString transportId;
  RTCDataChannelState state;
  unsigned long       messagesSent;
  unsigned long long  bytesSent;
  unsigned long       messagesReceived;
  unsigned long long  bytesReceived;
};

enum RTCStatsIceCandidatePairState {
  "frozen",
  "waiting",
  "inprogress",
  "failed",
  "succeeded",
  "cancelled"
};

dictionary RTCIceCandidatePairStats : RTCStats {
  DOMString transportId;
  DOMString localCandidateId;
  DOMString remoteCandidateId;
  RTCStatsIceCandidatePairState state;
  unsigned long long priority;
  boolean nominated;
  boolean writable;
  boolean readable;
  unsigned long long bytesSent;
  unsigned long long bytesReceived;
  DOMHighResTimeStamp lastPacketSentTimestamp;
  DOMHighResTimeStamp lastPacketReceivedTimestamp;
  boolean selected;
  [ChromeOnly]
  unsigned long componentId; // moz
};

dictionary RTCIceCandidateStats : RTCStats {
  DOMString address;
  long port;
  DOMString protocol;
  RTCIceCandidateType candidateType;
  long priority;
  DOMString relayProtocol;
  // Because we use this internally but don't support RTCIceCandidateStats,
  // we need to keep the field as ChromeOnly. Bug 1225723
  [ChromeOnly]
  DOMString transportId;
  [ChromeOnly]
  DOMString proxied;
};

// This is for tracking the frame rate in about:webrtc
dictionary RTCVideoFrameHistoryEntryInternal {
  required unsigned long       width;
  required unsigned long       height;
  required unsigned long       rotationAngle;
  required DOMHighResTimeStamp firstFrameTimestamp;
  required DOMHighResTimeStamp lastFrameTimestamp;
  required unsigned long long  consecutiveFrames;
  required unsigned long       localSsrc;
  required unsigned long       remoteSsrc;
};

// Collection over the entries for a single track for about:webrtc
dictionary RTCVideoFrameHistoryInternal {
  required DOMString                          trackIdentifier;
  sequence<RTCVideoFrameHistoryEntryInternal> entries = [];
};

// Collection over the libwebrtc bandwidth estimation stats
dictionary RTCBandwidthEstimationInternal {
  required DOMString  trackIdentifier;
  long                sendBandwidthBps;    // Estimated available send bandwidth
  long                maxPaddingBps;       // Cumulative configured max padding
  long                receiveBandwidthBps; // Estimated available receive bandwidth
  long                pacerDelayMs;
  long                rttMs;
};

// This is used by about:webrtc to report SDP parsing errors
dictionary RTCSdpParsingErrorInternal {
  required unsigned long lineNumber;
  required DOMString     error;
};

// This is for tracking the flow of SDP for about:webrtc
dictionary RTCSdpHistoryEntryInternal {
  required DOMHighResTimeStamp         timestamp;
  required boolean                     isLocal;
  required DOMString                   sdp;
  sequence<RTCSdpParsingErrorInternal> errors = [];
};

// This is intended to be a list of dictionaries that inherit from RTCStats
// (with some raw ICE candidates thrown in). Unfortunately, we cannot simply
// store a sequence<RTCStats> because of slicing. So, we have to have a
// separate list for each type. Used in c++ gecko code.
dictionary RTCStatsCollection {
  sequence<RTCInboundRtpStreamStats>        inboundRtpStreamStats = [];
  sequence<RTCOutboundRtpStreamStats>       outboundRtpStreamStats = [];
  sequence<RTCRemoteInboundRtpStreamStats>  remoteInboundRtpStreamStats = [];
  sequence<RTCRemoteOutboundRtpStreamStats> remoteOutboundRtpStreamStats = [];
  sequence<RTCMediaSourceStats>             mediaSourceStats = [];
  sequence<RTCVideoSourceStats>             videoSourceStats = [];
  sequence<RTCPeerConnectionStats>          peerConnectionStats = [];
  sequence<RTCRTPContributingSourceStats>   rtpContributingSourceStats = [];
  sequence<RTCIceCandidatePairStats>        iceCandidatePairStats = [];
  sequence<RTCIceCandidateStats>            iceCandidateStats = [];
  sequence<RTCIceCandidateStats>            trickledIceCandidateStats = [];
  sequence<RTCDataChannelStats>             dataChannelStats = [];
  sequence<RTCCodecStats>                   codecStats = [];

  // For internal use only
  sequence<DOMString>                       rawLocalCandidates = [];
  sequence<DOMString>                       rawRemoteCandidates = [];
  sequence<RTCVideoFrameHistoryInternal>    videoFrameHistories = [];
  sequence<RTCBandwidthEstimationInternal>  bandwidthEstimations = [];
};

// Details that about:webrtc can display about configured ICE servers
dictionary RTCIceServerInternal {
  sequence<DOMString> urls = [];
  required boolean    credentialProvided;
  required boolean    userNameProvided;
};

// Details that about:webrtc can display about the RTCConfiguration
// Chrome only
dictionary RTCConfigurationInternal {
  RTCBundlePolicy                bundlePolicy;
  required boolean               certificatesProvided;
  sequence<RTCIceServerInternal> iceServers = [];
  RTCIceTransportPolicy          iceTransportPolicy;
  required boolean               peerIdentityProvided;
  DOMString                      sdpSemantics;
};

dictionary RTCSdpHistoryInternal {
  required DOMString pcid;
  sequence<RTCSdpHistoryEntryInternal> sdpHistory = [];
};

// A collection of RTCStats dictionaries, plus some other info. Used by
// WebrtcGlobalInformation for about:webrtc, and telemetry.
dictionary RTCStatsReportInternal : RTCStatsCollection {
  required DOMString                        pcid;
  required unsigned long                    browserId;
  RTCConfigurationInternal                  configuration;
  DOMString                                 jsepSessionErrors;
  // TODO demux from RTCStatsReportInternal in bug 1830824
  sequence<RTCSdpHistoryEntryInternal>      sdpHistory = [];
  required DOMHighResTimeStamp              timestamp;
  double                                    callDurationMs;
  required unsigned long                    iceRestarts;
  required unsigned long                    iceRollbacks;
  boolean                                   offerer; // Is the PC the offerer
  required boolean                          closed; // Is the PC now closed
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCStatsReport {

  // TODO(bug 1586109): Remove this once we no longer need to be able to
  // construct empty RTCStatsReports from JS.
  [ChromeOnly]
  constructor();

  readonly maplike<DOMString, object>;
};
 
/* ---------------------- RTCTrackEvent ----------------------------- */ 
/* ./webidl/RTCTrackEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://w3c.github.io/webrtc-pc/#idl-def-RTCTrackEvent
 */

dictionary RTCTrackEventInit : EventInit {
    required RTCRtpReceiver        receiver;
    required MediaStreamTrack      track;
    sequence<MediaStream> streams = [];
    required RTCRtpTransceiver     transceiver;
};

[Pref="media.peerconnection.enabled",
 Exposed=Window]
interface RTCTrackEvent : Event {
    constructor(DOMString type, RTCTrackEventInit eventInitDict);

    readonly        attribute RTCRtpReceiver           receiver;
    readonly        attribute MediaStreamTrack         track;

// TODO: Use FrozenArray once available. (Bug 1236777)
//  readonly        attribute FrozenArray<MediaStream> streams;

    [Frozen, Cached, Pure]
    readonly        attribute sequence<MediaStream> streams; // workaround
    readonly        attribute RTCRtpTransceiver transceiver;
};
 
/* ---------------------- RTCTransformEvent ----------------------------- */ 
/* ./webidl/RTCTransformEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://www.w3.org/TR/webrtc-encoded-transform
 */

[Pref="media.peerconnection.enabled",
 Pref="media.peerconnection.scripttransform.enabled",
 Exposed=DedicatedWorker]
interface RTCTransformEvent : Event {
   constructor(DOMString type, RTCTransformEventInit eventInitDict);
   readonly attribute RTCRtpScriptTransformer transformer;
};

dictionary RTCTransformEventInit : EventInit {
  required RTCRtpScriptTransformer transformer;
};
 
/* ---------------------- Sanitizer ----------------------------- */ 
/* ./webidl/Sanitizer.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://wicg.github.io/sanitizer-api/#sanitizer
 * https://wicg.github.io/sanitizer-api/#config
 *
 * * Copyright © 2020 the Contributors to the HTML Sanitizer API Specification,
 * published by the Web Platform Incubator Community Group under the W3C Community Contributor License Agreement (CLA).
 */

// NOTE: This IDL is still under development:
// https://github.com/WICG/sanitizer-api/issues/181


dictionary SanitizerElementNamespace {
  required DOMString name;
  DOMString? _namespace = "http://www.w3.org/1999/xhtml";
};

// Used by "elements"
dictionary SanitizerElementNamespaceWithAttributes : SanitizerElementNamespace {
  sequence<SanitizerAttribute> attributes;
  sequence<SanitizerAttribute> removeAttributes;
};

typedef (DOMString or SanitizerElementNamespace) SanitizerElement;
typedef (DOMString or SanitizerElementNamespaceWithAttributes) SanitizerElementWithAttributes;

dictionary SanitizerAttributeNamespace {
  required DOMString name;
  DOMString? _namespace = null;
};
typedef (DOMString or SanitizerAttributeNamespace) SanitizerAttribute;

dictionary SanitizerConfig {
  sequence<SanitizerElementWithAttributes> elements;
  sequence<SanitizerElement> removeElements;
  sequence<SanitizerElement> replaceWithChildrenElements;

  sequence<SanitizerAttribute> attributes;
  sequence<SanitizerAttribute> removeAttributes;

  boolean customElements;
  boolean unknownMarkup; // Name TBD!
  boolean comments;
};

typedef (DocumentFragment or Document) SanitizerInput;

[Exposed=Window, SecureContext, Pref="dom.security.sanitizer.enabled"]
interface Sanitizer {
  [Throws, UseCounter]
  constructor(optional SanitizerConfig sanitizerConfig = {});
  [UseCounter, Throws]
  DocumentFragment sanitize(SanitizerInput input);
};
 
/* ---------------------- Screen ----------------------------- */ 
/* ./webidl/Screen.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

[Exposed=Window]
interface Screen : EventTarget {
  // CSSOM-View
  // http://dev.w3.org/csswg/cssom-view/#the-screen-interface
  readonly attribute long availWidth;
  readonly attribute long availHeight;
  readonly attribute long width;
  readonly attribute long height;
  readonly attribute long colorDepth;
  readonly attribute long pixelDepth;

  readonly attribute long top;
  readonly attribute long left;
  readonly attribute long availTop;
  readonly attribute long availLeft;

  /**
   * DEPRECATED, use ScreenOrientation API instead.
   * Returns the current screen orientation.
   * Can be: landscape-primary, landscape-secondary,
   *         portrait-primary or portrait-secondary.
   */
  [NeedsCallerType]
  readonly attribute DOMString mozOrientation;

  attribute EventHandler onmozorientationchange;

  /**
   * DEPRECATED, use ScreenOrientation API instead.
   * Lock/unlock screen orientation to the specified type.
   *
   * FIXME(emilio): These do literally nothing, we should
   * try to remove these.
   */
  boolean mozLockOrientation(DOMString orientation);
  boolean mozLockOrientation(sequence<DOMString> orientation);
  undefined mozUnlockOrientation();
};

// https://w3c.github.io/screen-orientation
partial interface Screen {
  readonly attribute ScreenOrientation orientation;
};

// https://wicg.github.io/media-capabilities/#idl-index
enum ScreenColorGamut {
  "srgb",
  "p3",
  "rec2020",
};

[Func="nsScreen::MediaCapabilitiesEnabled",
 Exposed=Window]
interface ScreenLuminance {
  readonly attribute double min;
  readonly attribute double max;
  readonly attribute double maxAverage;
};

partial interface Screen {
  [Func="nsScreen::MediaCapabilitiesEnabled"]
  readonly attribute ScreenColorGamut colorGamut;
  [Func="nsScreen::MediaCapabilitiesEnabled"]
  readonly attribute ScreenLuminance? luminance;

  [Func="nsScreen::MediaCapabilitiesEnabled"]
  attribute EventHandler onchange;
};
 
/* ---------------------- ScreenOrientation ----------------------------- */ 
/* ./webidl/ScreenOrientation.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/screen-orientation
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio, Beihang), All Rights
 * Reserved. W3C liability, trademark and document use rules apply.
 */

enum OrientationType {
  "portrait-primary",
  "portrait-secondary",
  "landscape-primary",
  "landscape-secondary"
};

enum OrientationLockType {
  "any",
  "natural",
  "landscape",
  "portrait",
  "portrait-primary",
  "portrait-secondary",
  "landscape-primary",
  "landscape-secondary"
};

[Exposed=Window]
interface ScreenOrientation : EventTarget {
  [NewObject]
  Promise<undefined> lock(OrientationLockType orientation);
  [Throws]
  undefined unlock();
  [Throws, NeedsCallerType]
  readonly attribute OrientationType type;
  [Throws, NeedsCallerType]
  readonly attribute unsigned short angle;
  attribute EventHandler onchange;
};
 
/* ---------------------- ScriptProcessorNode ----------------------------- */ 
/* ./webidl/ScriptProcessorNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface ScriptProcessorNode : AudioNode {

    attribute EventHandler onaudioprocess;

    readonly attribute long bufferSize;

};

// Mozilla extension
ScriptProcessorNode includes AudioNodePassThrough;
 
/* ---------------------- ScrollAreaEvent ----------------------------- */ 
/* ./webidl/ScrollAreaEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface ScrollAreaEvent : UIEvent
{
  readonly attribute float x;
  readonly attribute float y;
  readonly attribute float width;
  readonly attribute float height;

  undefined initScrollAreaEvent(DOMString type,
                                optional boolean canBubble = false,
                                optional boolean cancelable = false,
                                optional Window? view = null,
                                optional long detail = 0,
                                optional float x = 0,
                                optional float y = 0,
                                optional float width = 0,
                                optional float height = 0);
};
 
/* ---------------------- ScrollViewChangeEvent ----------------------------- */ 
/* ./webidl/ScrollViewChangeEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

enum ScrollState {"started", "stopped"};

dictionary ScrollViewChangeEventInit : EventInit {
  ScrollState state = "started";
};

[ChromeOnly,
 Exposed=Window]
interface ScrollViewChangeEvent : Event {
  constructor(DOMString type,
              optional ScrollViewChangeEventInit eventInit = {});

  readonly attribute ScrollState state;
};
 
/* ---------------------- SecurityPolicyViolationEvent ----------------------------- */ 
/* ./webidl/SecurityPolicyViolationEvent.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/webappsec-csp/#violation-events
 */

enum SecurityPolicyViolationEventDisposition
{
  "enforce", "report"
};

[Exposed=Window]
interface SecurityPolicyViolationEvent : Event
{
    constructor(DOMString type,
                optional SecurityPolicyViolationEventInit eventInitDict = {});

    readonly attribute DOMString      documentURI;
    readonly attribute DOMString      referrer;
    readonly attribute DOMString      blockedURI;
    readonly attribute DOMString      violatedDirective; // historical alias of effectiveDirective
    readonly attribute DOMString      effectiveDirective;
    readonly attribute DOMString      originalPolicy;
    readonly attribute DOMString      sourceFile;
    readonly attribute DOMString      sample;
    readonly attribute SecurityPolicyViolationEventDisposition disposition;
    readonly attribute unsigned short statusCode;
    readonly attribute unsigned long  lineNumber;
    readonly attribute unsigned long  columnNumber;
};

[GenerateInitFromJSON, GenerateToJSON]
dictionary SecurityPolicyViolationEventInit : EventInit
{
    DOMString      documentURI = "";
    DOMString      referrer = "";
    DOMString      blockedURI = "";
    DOMString      violatedDirective = "";
    DOMString      effectiveDirective = "";
    DOMString      originalPolicy = "";
    DOMString      sourceFile = "";
    DOMString      sample = "";
    SecurityPolicyViolationEventDisposition disposition = "enforce";
    unsigned short statusCode = 0;
    unsigned long  lineNumber = 0;
    unsigned long  columnNumber = 0;
};
 
/* ---------------------- Selection ----------------------------- */ 
/* ./webidl/Selection.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/selection-api/#selection-interface
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface Selection {
  [NeedsCallerType]
  readonly attribute Node?         anchorNode;
  [NeedsCallerType]
  readonly attribute unsigned long anchorOffset;
  [NeedsCallerType]
  readonly attribute Node?         focusNode;
  [NeedsCallerType]
  readonly attribute unsigned long focusOffset;
  readonly attribute boolean       isCollapsed;
  /**
   * Returns the number of ranges in the selection.
   */
  readonly attribute unsigned long rangeCount;
  readonly attribute DOMString     type;
  readonly attribute DOMString direction;
  /**
   * Returns the range at the specified index.  Throws if the index is
   * out of range.
   */
  [Throws]
  Range     getRangeAt(unsigned long index);
  /**
   * Adds a range to the current selection.
   */
  [Throws, BinaryName="addRangeJS"]
  undefined addRange(Range range);
  /**
   * Removes a range from the current selection.
   */
  [Throws, BinaryName="removeRangeAndUnselectFramesAndNotifyListeners"]
  undefined removeRange(Range range);
  /**
   * Removes all ranges from the current selection.
   */
  [Throws]
  undefined removeAllRanges();
  [Throws, BinaryName="RemoveAllRanges"]
  undefined empty();

  [Pref="dom.shadowdom.selection_across_boundary_enabled"]
  sequence<StaticRange> getComposedRanges(ShadowRoot... shadowRoots);

  [Throws, BinaryName="collapseJS"]
  undefined collapse(Node? node, optional unsigned long offset = 0);
  [Throws, BinaryName="collapseJS"]
  undefined setPosition(Node? node, optional unsigned long offset = 0);
  [Throws, BinaryName="collapseToStartJS"]
  undefined collapseToStart();
  [Throws, BinaryName="collapseToEndJS"]
  undefined collapseToEnd();
  [Throws, BinaryName="extendJS"]
  undefined extend(Node node, optional unsigned long offset = 0);
  [Throws, BinaryName="setBaseAndExtentJS"]
  undefined setBaseAndExtent(Node anchorNode,
                             unsigned long anchorOffset,
                             Node focusNode,
                             unsigned long focusOffset);
  [Throws, BinaryName="selectAllChildrenJS"]
  undefined selectAllChildren(Node node);
  [CEReactions, Throws]
  undefined deleteFromDocument();
  [Throws]
  boolean   containsNode(Node node,
                         optional boolean allowPartialContainment = false);
  stringifier DOMString ();
};

// Additional methods not currently in the spec
partial interface Selection {
  [Throws]
  undefined modify(DOMString alter, DOMString direction,
                   DOMString granularity);
};

// Additional chrome-only methods.
interface nsISelectionListener;
partial interface Selection {
  /**
   * A true value means "selection after newline"; false means "selection before
   * newline" when a selection is positioned "between lines".
   */
  [ChromeOnly,Throws, BinaryName=interlinePositionJS]
  attribute boolean interlinePosition;

  [Throws]
  attribute short? caretBidiLevel;

  [ChromeOnly,Throws]
  DOMString  toStringWithFormat(DOMString formatType, unsigned long flags, long wrapColumn);
  [ChromeOnly]
  undefined  addSelectionListener(nsISelectionListener newListener);
  [ChromeOnly]
  undefined  removeSelectionListener(nsISelectionListener listenerToRemove);

  [ChromeOnly,BinaryName="rawType"]
  readonly attribute short selectionType;

  /**
   * Return array of ranges intersecting with the given DOM interval.
   */
  [ChromeOnly,Throws,Pref="dom.testing.selection.GetRangesForInterval"]
  sequence<Range> GetRangesForInterval(Node beginNode, long beginOffset, Node endNode, long endOffset,
                                       boolean allowAdjacent);

  /**
   * Scrolls a region of the selection, so that it is visible in
   * the scrolled view.
   *
   * @param aRegion the region inside the selection to scroll into view
   *                (see selection region constants defined in
   *                nsISelectionController).
   * @param aIsSynchronous when true, scrolls the selection into view
   *                       before returning. If false, posts a request which
   *                       is processed at some point after the method returns.
   * @param aVPercent how to align the frame vertically.
   * @param aHPercent how to align the frame horizontally.
   */
  [ChromeOnly,Throws]
  undefined scrollIntoView(short aRegion, boolean aIsSynchronous, short aVPercent, short aHPercent);

  /**
   * setColors() sets custom colors for the selection.
   * Currently, this is supported only when the selection type is SELECTION_FIND.
   * Otherwise, throws an exception.
   *
   * @param aForegroundColor     The foreground color of the selection.
   *                             If this is "currentColor", foreground color
   *                             isn't changed by this selection.
   * @param aBackgroundColor     The background color of the selection.
   *                             If this is "transparent", background color is
   *                             never painted.
   * @param aAltForegroundColor  The alternative foreground color of the
   *                             selection.
   *                             If aBackgroundColor doesn't have sufficient
   *                             contrast with its around or foreground color
   *                             if "currentColor" is specified, alternative
   *                             colors are used if it have higher contrast.
   * @param aAltBackgroundColor  The alternative background color of the
   *                             selection.
   */
  [ChromeOnly,Throws]
  undefined setColors(DOMString aForegroundColor, DOMString aBackgroundColor,
                      DOMString aAltForegroundColor, DOMString aAltBackgroundColor);

  /**
   * resetColors() forget the customized colors which were set by setColors().
   */
  [ChromeOnly]
  undefined resetColors();
};
 
/* ---------------------- ServiceWorker ----------------------------- */ 
/* ./webidl/ServiceWorker.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html#service-worker-obj
 *
 */

// Still unclear what should be subclassed.
// https://github.com/slightlyoff/ServiceWorker/issues/189
[Func="ServiceWorkerVisible",
 // FIXME(nsm): Bug 1113522. This is exposed to satisfy webidl constraints, but it won't actually work.
 Exposed=(Window,Worker)]
interface ServiceWorker : EventTarget {
  readonly attribute USVString scriptURL;
  readonly attribute ServiceWorkerState state;

  attribute EventHandler onstatechange;

  [Throws]
  undefined postMessage(any message, sequence<object> transferable);
  [Throws]
  undefined postMessage(any message, optional StructuredSerializeOptions options = {});
};

ServiceWorker includes AbstractWorker;

enum ServiceWorkerState {
  // https://github.com/w3c/ServiceWorker/issues/1162
  "parsed",

  "installing",
  "installed",
  "activating",
  "activated",
  "redundant"
};
 
/* ---------------------- ServiceWorkerContainer ----------------------------- */ 
/* ./webidl/ServiceWorkerContainer.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://w3c.github.io/ServiceWorker/#serviceworkercontainer
 *
 */

[Func="ServiceWorkersEnabled",
 Exposed=Window]
interface ServiceWorkerContainer : EventTarget {
  // FIXME(nsm):
  // https://github.com/slightlyoff/ServiceWorker/issues/198
  // and discussion at https://etherpad.mozilla.org/serviceworker07apr
  readonly attribute ServiceWorker? controller;

  [Throws]
  readonly attribute Promise<ServiceWorkerRegistration> ready;

  [NewObject, NeedsCallerType]
  Promise<ServiceWorkerRegistration> register(USVString scriptURL,
                                              optional RegistrationOptions options = {});

  [NewObject]
  Promise<(ServiceWorkerRegistration or undefined)> getRegistration(optional USVString documentURL = "");

  [NewObject]
  Promise<sequence<ServiceWorkerRegistration>> getRegistrations();

  undefined startMessages();

  attribute EventHandler oncontrollerchange;
  attribute EventHandler onmessage;
  attribute EventHandler onmessageerror;
};

// Testing only.
partial interface ServiceWorkerContainer {
  [Throws,Pref="dom.serviceWorkers.testing.enabled"]
  DOMString getScopeForUrl(DOMString url);
};

dictionary RegistrationOptions {
  USVString scope;
  ServiceWorkerUpdateViaCache updateViaCache = "imports";
};
 
/* ---------------------- ServiceWorkerGlobalScope ----------------------------- */ 
/* ./webidl/ServiceWorkerGlobalScope.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html
 * http://w3c.github.io/push-api/
 * https://notifications.spec.whatwg.org/
 *
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

[Global=(Worker,ServiceWorker),
 Exposed=ServiceWorker]
interface ServiceWorkerGlobalScope : WorkerGlobalScope {
  [SameObject, BinaryName="GetClients"]
  readonly attribute Clients clients;
  [SameObject] readonly attribute ServiceWorkerRegistration registration;

  [Throws, NewObject]
  Promise<undefined> skipWaiting();

  attribute EventHandler oninstall;
  attribute EventHandler onactivate;

  attribute EventHandler onfetch;

  // The event.source of these MessageEvents are instances of Client
  attribute EventHandler onmessage;
  attribute EventHandler onmessageerror;
};

// These are from w3c.github.io/push-api/
partial interface ServiceWorkerGlobalScope {
  attribute EventHandler onpush;
  attribute EventHandler onpushsubscriptionchange;
};

// https://notifications.spec.whatwg.org/
partial interface ServiceWorkerGlobalScope {
  attribute EventHandler onnotificationclick;
  attribute EventHandler onnotificationclose;
};

// Mixin the WebExtensions API globals (the actual properties are only available to
// extension service workers, locked behind a Func="extensions::ExtensionAPIAllowed" annotation).
ServiceWorkerGlobalScope includes ExtensionGlobalsMixin;
 
/* ---------------------- ServiceWorkerRegistration ----------------------------- */ 
/* ./webidl/ServiceWorkerRegistration.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://slightlyoff.github.io/ServiceWorker/spec/service_worker/index.html
 * https://w3c.github.io/push-api/
 * https://notifications.spec.whatwg.org/
 */

[Func="ServiceWorkerVisible",
 Exposed=(Window,Worker)]
interface ServiceWorkerRegistration : EventTarget {
  readonly attribute ServiceWorker? installing;
  readonly attribute ServiceWorker? waiting;
  readonly attribute ServiceWorker? active;

  [Pref="dom.serviceWorkers.navigationPreload.enabled", SameObject]
  readonly attribute NavigationPreloadManager navigationPreload;

  readonly attribute USVString scope;
  [Throws]
  readonly attribute ServiceWorkerUpdateViaCache updateViaCache;

  [Throws, NewObject]
  Promise<undefined> update();

  [Throws, NewObject]
  Promise<boolean> unregister();

  // event
  attribute EventHandler onupdatefound;
};

enum ServiceWorkerUpdateViaCache {
  "imports",
  "all",
  "none"
};

// https://w3c.github.io/push-api/
partial interface ServiceWorkerRegistration {
  [Throws, Exposed=(Window,Worker), Pref="dom.push.enabled"]
  readonly attribute PushManager pushManager;
};

// https://notifications.spec.whatwg.org/
partial interface ServiceWorkerRegistration {
  [NewObject, Func="mozilla::dom::Notification::PrefEnabled"]
  Promise<undefined> showNotification(DOMString title, optional NotificationOptions options = {});
  [NewObject, Func="mozilla::dom::Notification::PrefEnabled"]
  Promise<sequence<Notification>> getNotifications(optional GetNotificationOptions filter = {});
};
 
/* ---------------------- ShadowRealmGlobalScope ----------------------------- */ 
/* ./webidl/ShadowRealmGlobalScope.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

// This interface exists purely to register a new global as part of
// code generation so that we can properly hook this into
// shadow realms.
[Global=(ShadowRealmGlobal), Exposed=ShadowRealmGlobal, LegacyNoInterfaceObject]
interface ShadowRealmGlobalScope { };
 
/* ---------------------- ShadowRoot ----------------------------- */ 
/* ./webidl/ShadowRoot.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dvcs.w3.org/hg/webcomponents/raw-file/tip/spec/shadow/index.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

// https://dom.spec.whatwg.org/#enumdef-shadowrootmode
enum ShadowRootMode {
  "open",
  "closed"
};

enum SlotAssignmentMode { "manual", "named" };

// https://dom.spec.whatwg.org/#shadowroot
[Exposed=Window,
 InstrumentedProps=(pictureInPictureElement)]
interface ShadowRoot : DocumentFragment
{
  // Shadow DOM v1
  readonly attribute ShadowRootMode mode;
  readonly attribute boolean delegatesFocus;
  readonly attribute SlotAssignmentMode slotAssignment;
  [Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  readonly attribute boolean clonable;
  readonly attribute Element host;
  attribute EventHandler onslotchange;

  Element? getElementById(DOMString elementId);

  // https://w3c.github.io/DOM-Parsing/#the-innerhtml-mixin
  [CEReactions, SetterThrows]
  attribute [LegacyNullToEmptyString] DOMString innerHTML;

  // When JS invokes importNode or createElement, the binding code needs to
  // create a reflector, and so invoking those methods directly on the content
  // document would cause the reflector to be created in the content scope,
  // at which point it would be difficult to move into the UA Widget scope.
  // As such, these methods allow UA widget code to simultaneously create nodes
  // and associate them with the UA widget tree, so that the reflectors get
  // created in the right scope.
  [CEReactions, Throws, Func="IsChromeOrUAWidget"]
  Node importNodeAndAppendChildAt(Node parentNode, Node node, optional boolean deep = false);

  [CEReactions, Throws, Func="IsChromeOrUAWidget"]
  Node createElementAndAppendChildAt(Node parentNode, DOMString localName);

  // For triggering UA Widget scope in tests.
  [ChromeOnly]
  undefined setIsUAWidget();
  [ChromeOnly]
  boolean isUAWidget();
};

partial interface ShadowRoot {
  // https://html.spec.whatwg.org/#dom-shadowroot-sethtmlunsafe
  [Pref="dom.webcomponents.shadowdom.declarative.enabled"]
  undefined setHTMLUnsafe(DOMString html);
};

ShadowRoot includes DocumentOrShadowRoot;
 
/* ---------------------- SharedWorker ----------------------------- */ 
/* ./webidl/SharedWorker.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=Window]
interface SharedWorker : EventTarget {
    [Throws]
    constructor(USVString scriptURL,
                optional (DOMString or WorkerOptions) options = {});

    readonly attribute MessagePort port;
};

SharedWorker includes AbstractWorker;
 
/* ---------------------- SharedWorkerGlobalScope ----------------------------- */ 
/* ./webidl/SharedWorkerGlobalScope.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.whatwg.org/specs/web-apps/current-work/multipage/workers.html#the-workerglobalscope-common-interface
 *
 * © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and Opera
 * Software ASA.
 * You are granted a license to use, reproduce and create derivative works of
 * this document.
 */

[Global=(Worker,SharedWorker),
 Exposed=SharedWorker]
interface SharedWorkerGlobalScope : WorkerGlobalScope {
  [Replaceable]
  readonly attribute DOMString name;

  undefined close();

  attribute EventHandler onconnect;
};
 
/* ---------------------- SimpleGestureEvent ----------------------------- */ 
/* ./webidl/SimpleGestureEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * The SimpleGestureEvent interface is the datatype for all
 * Mozilla-specific simple gesture events in the Document Object Model.
 *
 * The following events are generated:
 *
 * MozSwipeGestureMayStart - Generated when the user starts a horizontal
 * swipe across the input device, but before we know whether the user
 * is actually scrolling past a scroll edge.
 * This event asks two questions:  Should a swipe really be started, and
 * in which directions should the user be able to swipe?  The first
 * question is answered by event listeners by calling or not calling
 * preventDefault() on the event.  Since a swipe swallows all scroll
 * events, the default action of the swipe start event is *not* to
 * start a swipe. Call preventDefault() if you want a swipe to be
 * started. Doing so won't necessarily result in a swipe being started,
 * it only communicates an intention. Once Gecko determines whether a
 * swipe should actually be started, it will send a MozSwipeGestureStart
 * event.
 * The second question (swipe-able directions) is answered in the
 * allowedDirections field.
 *
 * MozSwipeGestureStart - This event signals the start of a swipe.
 * It guarantees a future MozSwipeGestureEnd event that will signal
 * the end of a swipe animation.
 *
 * MozSwipeGestureUpdate - Generated periodically while the user is
 * continuing a horizontal swipe gesture.  The "delta" value represents
 * the current absolute gesture amount.  This event may even be sent
 * after a MozSwipeGesture event fired in order to allow for fluid
 * completion of a swipe animation.  The direction value is meaningless
 * on swipe update events.
 *
 * MozSwipeGestureEnd - Generated when the swipe animation is completed.
 *
 * MozSwipeGesture - Generated when the user releases a swipe across
 * across the input device.  This event signals that the actual swipe
 * operation is complete, even though the animation might not be finished
 * yet.  This event can be sent without accompanying start / update / end
 * events, and it can also be handled on its own if the consumer doesn't
 * want to handle swipe animation events.
 * Only the direction value has any significance, the delta value is
 * meaningless.
 *
 * MozMagnifyGestureStart - Generated when the user begins the magnify
 * ("pinch") gesture.  The "delta" value represents the initial
 * movement.
 *
 * MozMagnifyGestureUpdate - Generated periodically while the user is
 * continuing the magnify ("pinch") gesture.  The "delta" value
 * represents the movement since the last MozMagnifyGestureStart or
 * MozMagnifyGestureUpdate event.
 *
 * MozMagnifyGesture - Generated when the user has completed the
 * magnify ("pinch") gesture.  If you only want to receive a single
 * event when the magnify gesture is complete, you only need to hook
 * this event and can safely ignore the MozMagnifyGestureStart and the
 * MozMagnifyGestureUpdate events. The "delta" value is the cumulative
 * amount represented by the user's gesture.
 *
 * MozRotateGestureStart - Generated when the user begins the rotation
 * gesture.  The "delta" value represents the initial rotation.
 *
 * MozRotateGestureUpdate - Generated periodically while the user is
 * continuing the rotation gesture.  The "delta" value represents the
 * rotation since the last MozRotateGestureStart or
 * MozRotateGestureUpdate event.
 *
 * MozRotateGesture - Generated when the user has completed the
 * rotation gesture.  If you only want to receive a single event when
 * the rotation gesture is complete, you only need to hook this event
 * and can safely ignore the MozRotateGestureStart and the
 * MozRotateGestureUpdate events.  The "delta" value is the cumulative
 * amount of rotation represented by the user's gesture.
 *
 * MozTapGesture - Generated when the user executes a two finger
 * tap gesture on the input device. Client coordinates contain the
 * center point of the tap.
 * (XXX On OS X, only Lion (10.7) and up)
 *
 * MozPressTapGesture - Generated when the user executes a press
 * and tap two finger gesture (first finger down, second finger down,
 * second finger up, first finger up) on the input device.
 * Client coordinates contain the center pivot point of the action.
 * (XXX Not implemented on Mac)
 *
 * MozEdgeUIGesture - Generated when the user swipes the display to
 * invoke edge ui.
 * (XXX Win8 only)
 *
 * Default behavior:
 *
 * Some operating systems support default behaviors for gesture events
 * when they are not handled by the application. Consumers should
 * use event.preventDefault() to prevent default behavior when
 * consuming events.
 */

[ChromeOnly,
 Exposed=Window]
interface SimpleGestureEvent : MouseEvent
{
  /* Swipe direction constants */
  const unsigned long DIRECTION_UP = 1;
  const unsigned long DIRECTION_DOWN = 2;
  const unsigned long DIRECTION_LEFT = 4;
  const unsigned long DIRECTION_RIGHT = 8;

  /* Rotational direction constants */
  const unsigned long ROTATION_COUNTERCLOCKWISE = 1;
  const unsigned long ROTATION_CLOCKWISE = 2;

  /* Read-write value for swipe events.
   *
   * Reports the directions that can be swiped to; multiple directions
   * should be OR'ed together.
   *
   * The allowedDirections field is designed to be set on SwipeGestureMayStart
   * events by event listeners.  Its value after event dispatch determines
   * the behavior of the swipe animation that might be about to begin.
   * Specifically, if the user swipes in a direction that can't be swiped
   * to, the animation will have a bounce effect.
   * Future SwipeGestureUpdate, SwipeGesture and SwipeGestureEnd events
   * will carry the allowDirections value that was set on the SwipeMayStart
   * event.  Changing this field on non-SwipeGestureMayStart events doesn't
   * have any effect.
   */
  attribute unsigned long allowedDirections;

  /* Direction of a gesture. Diagonals are indicated by OR'ing the
   * applicable constants together.
   *
   * Swipes gestures may occur in any direction.
   *
   * Magnify gestures do not have a direction.
   *
   * Rotation gestures will be either ROTATION_COUNTERCLOCKWISE or
   * ROTATION_CLOCKWISE.
   */
  readonly attribute unsigned long direction;

  /* Delta value for magnify, rotate and swipe gestures.
   *
   * For rotation, the value is in degrees and is positive for
   * clockwise rotation and negative for counterclockwise
   * rotation.
   *
   * For magnification, the value will be positive for a "zoom in"
   * (i.e, increased magnification) and negative for a "zoom out"
   * (i.e., decreased magnification).  The particular units
   * represented by the "delta" are currently implementation specific.
   *
   * XXX - The units for measuring magnification are currently
   * unspecified because the units used by Mac OS X are currently
   * undocumented.  The values are typically in the range of 0.0 to
   * 100.0, but it is only safe currently to rely on the delta being
   * positive or negative.
   *
   * For swipe start, update and end events, the value is a fraction
   * of one "page".  If the resulting swipe will have DIRECTION_LEFT, the
   * delta value will be positive; for DIRECTION_RIGHT, delta is negative.
   * If this seems backwards to you, look at it this way:  If the current
   * page is pushed to the right during the animation (positive delta),
   * the page left to the current page will be visible after the swipe
   * (DIRECTION_LEFT).
   *
   * Units on Windows represent the difference between the initial
   * and current/final width between the two touch points on the input
   * device and are measured in pixels.
   */
  readonly attribute double delta;

  /* Click count value for taps. */
  readonly attribute unsigned long clickCount;

  undefined initSimpleGestureEvent(DOMString typeArg,
                                   optional boolean canBubbleArg = false,
                                   optional boolean cancelableArg = false,
                                   optional Window? viewArg = null,
                                   optional long detailArg = 0,
                                   optional long screenXArg = 0,
                                   optional long screenYArg = 0,
                                   optional long clientXArg = 0,
                                   optional long clientYArg = 0,
                                   optional boolean ctrlKeyArg = false,
                                   optional boolean altKeyArg = false,
                                   optional boolean shiftKeyArg = false,
                                   optional boolean metaKeyArg = false,
                                   optional short buttonArg = 0,
                                   optional EventTarget? relatedTargetArg = null,
                                   optional unsigned long allowedDirectionsArg = 0,
                                   optional unsigned long directionArg = 0,
                                   optional double deltaArg = 0,
                                   optional unsigned long clickCount = 0);
};
 
/* ---------------------- SocketCommon ----------------------------- */ 
/* ./webidl/SocketCommon.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/2012/sysapps/tcp-udp-sockets/#readystate
 */

enum SocketReadyState {
    "opening",
    "open",
    "closing",
    "closed",
    "halfclosed"
};
 
/* ---------------------- SourceBuffer ----------------------------- */ 
/* ./webidl/SourceBuffer.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/html-media/raw-file/default/media-source/media-source.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum SourceBufferAppendMode {
    "segments",
    "sequence"
};

[Pref="media.mediasource.enabled",
 Exposed=Window]
interface SourceBuffer : EventTarget {
  [SetterThrows]
  attribute SourceBufferAppendMode mode;
  readonly attribute boolean updating;
  [Throws]
  readonly attribute TimeRanges buffered;
  [SetterThrows]
  attribute double timestampOffset;
  //readonly attribute AudioTrackList audioTracks;
  //readonly attribute VideoTrackList videoTracks;
  //readonly attribute TextTrackList textTracks;
  [SetterThrows]
  attribute double appendWindowStart;
  [SetterThrows]
  attribute unrestricted double appendWindowEnd;
  attribute EventHandler onupdatestart;
  attribute EventHandler onupdate;
  attribute EventHandler onupdateend;
  attribute EventHandler onerror;
  attribute EventHandler onabort;
  [Throws]
  undefined appendBuffer(ArrayBuffer data);
  [Throws]
  undefined appendBuffer(ArrayBufferView data);
  //[Throws]
  //undefined appendStream(Stream stream, [EnforceRange] optional unsigned long long maxSize);
  [Throws]
  undefined abort();
  [Throws]
  undefined remove(double start, unrestricted double end);
};

// Mozilla extensions for experimental features
partial interface SourceBuffer {
  // Experimental function as proposed in:
  // https://github.com/w3c/media-source/issues/100 for promise proposal.
  [NewObject, Pref="media.mediasource.experimental.enabled"]
  Promise<undefined> appendBufferAsync(ArrayBuffer data);
  [NewObject, Pref="media.mediasource.experimental.enabled"]
  Promise<undefined> appendBufferAsync(ArrayBufferView data);
  [NewObject, Pref="media.mediasource.experimental.enabled"]
  Promise<undefined> removeAsync(double start, unrestricted double end);

  // Experimental function as proposed in:
  // https://github.com/w3c/media-source/issues/155
  [Throws]
  undefined changeType(DOMString type);
};
 
/* ---------------------- SourceBufferList ----------------------------- */ 
/* ./webidl/SourceBufferList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/html-media/raw-file/default/media-source/media-source.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.mediasource.enabled",
 Exposed=Window]
interface SourceBufferList : EventTarget {
  readonly attribute unsigned long length;
  attribute EventHandler onaddsourcebuffer;
  attribute EventHandler onremovesourcebuffer;
  getter SourceBuffer (unsigned long index);
};
 
/* ---------------------- SpeechGrammar ----------------------------- */ 
/* ./webidl/SpeechGrammar.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.recognition.enable",
 LegacyFactoryFunction=webkitSpeechGrammar,
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechGrammar {
    constructor();

    [Throws]
    attribute DOMString src;
    [Throws]
    attribute float weight;
};
 
/* ---------------------- SpeechGrammarList ----------------------------- */ 
/* ./webidl/SpeechGrammarList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.recognition.enable",
 LegacyFactoryFunction=webkitSpeechGrammarList,
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechGrammarList {
    constructor();

    readonly attribute unsigned long length;
    [Throws]
    getter SpeechGrammar item(unsigned long index);
    [Throws]
    undefined addFromURI(DOMString src, optional float weight);
    [Throws]
    undefined addFromString(DOMString string, optional float weight);
};
 
/* ---------------------- SpeechRecognition ----------------------------- */ 
/* ./webidl/SpeechRecognition.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.recognition.enable",
 LegacyFactoryFunction=webkitSpeechRecognition,
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechRecognition : EventTarget {
    [Throws]
    constructor();

    // recognition parameters
    attribute SpeechGrammarList grammars;
    attribute DOMString lang;
    [Throws]
    attribute boolean continuous;
    attribute boolean interimResults;
    attribute unsigned long maxAlternatives;
    [Throws]
    attribute DOMString serviceURI;

    // methods to drive the speech interaction
    [Throws, NeedsCallerType]
    undefined start(optional MediaStream stream);
    undefined stop();
    undefined abort();

    // event methods
    attribute EventHandler onaudiostart;
    attribute EventHandler onsoundstart;
    attribute EventHandler onspeechstart;
    attribute EventHandler onspeechend;
    attribute EventHandler onsoundend;
    attribute EventHandler onaudioend;
    attribute EventHandler onresult;
    attribute EventHandler onnomatch;
    attribute EventHandler onerror;
    attribute EventHandler onstart;
    attribute EventHandler onend;
};
 
/* ---------------------- SpeechRecognitionAlternative ----------------------------- */ 
/* ./webidl/SpeechRecognitionAlternative.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.recognition.enable",
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechRecognitionAlternative {
    readonly attribute DOMString transcript;
    readonly attribute float confidence;
};
 
/* ---------------------- SpeechRecognitionError ----------------------------- */ 
/* ./webidl/SpeechRecognitionError.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

enum SpeechRecognitionErrorCode {
  "no-speech",
  "aborted",
  "audio-capture",
  "network",
  "not-allowed",
  "service-not-allowed",
  "bad-grammar",
  "language-not-supported"
};

[Pref="media.webspeech.recognition.enable",
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechRecognitionError : Event
{
  constructor(DOMString type,
              optional SpeechRecognitionErrorInit eventInitDict = {});

  readonly attribute SpeechRecognitionErrorCode error;
  readonly attribute DOMString? message;
};

dictionary SpeechRecognitionErrorInit : EventInit
{
  SpeechRecognitionErrorCode error = "no-speech";
  DOMString message = "";
};
 
/* ---------------------- SpeechRecognitionEvent ----------------------------- */ 
/* ./webidl/SpeechRecognitionEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */
interface nsISupports;

[Pref="media.webspeech.recognition.enable",
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechRecognitionEvent : Event
{
  constructor(DOMString type,
              optional SpeechRecognitionEventInit eventInitDict = {});

  readonly attribute unsigned long resultIndex;
  readonly attribute SpeechRecognitionResultList? results;
  readonly attribute any interpretation;
  readonly attribute Document? emma;
};

dictionary SpeechRecognitionEventInit : EventInit
{
  unsigned long resultIndex = 0;
  SpeechRecognitionResultList? results = null;
  any interpretation = null;
  Document? emma = null;
};
 
/* ---------------------- SpeechRecognitionResult ----------------------------- */ 
/* ./webidl/SpeechRecognitionResult.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.recognition.enable",
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechRecognitionResult {
    readonly attribute unsigned long length;
    getter SpeechRecognitionAlternative item(unsigned long index);
    readonly attribute boolean isFinal;
};
 
/* ---------------------- SpeechRecognitionResultList ----------------------------- */ 
/* ./webidl/SpeechRecognitionResultList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.recognition.enable",
 Func="SpeechRecognition::IsAuthorized",
 Exposed=Window]
interface SpeechRecognitionResultList {
    readonly attribute unsigned long length;
    getter SpeechRecognitionResult item(unsigned long index);
};
 
/* ---------------------- SpeechSynthesis ----------------------------- */ 
/* ./webidl/SpeechSynthesis.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.synth.enabled",
 Exposed=Window]
interface SpeechSynthesis : EventTarget{
  readonly attribute boolean pending;
  readonly attribute boolean speaking;
  readonly attribute boolean paused;

  undefined speak(SpeechSynthesisUtterance utterance);
  undefined cancel();
  undefined pause();
  undefined resume();
  sequence<SpeechSynthesisVoice> getVoices();

  attribute EventHandler onvoiceschanged;

  [ChromeOnly]
  // Force an utterance to end. Circumvents bad speech service implementations.
  undefined forceEnd();
};
 
/* ---------------------- SpeechSynthesisErrorEvent ----------------------------- */ 
/* ./webidl/SpeechSynthesisErrorEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

enum SpeechSynthesisErrorCode {
  "canceled",
  "interrupted",
  "audio-busy",
  "audio-hardware",
  "network",
  "synthesis-unavailable",
  "synthesis-failed",
  "language-unavailable",
  "voice-unavailable",
  "text-too-long",
  "invalid-argument",
};

[Pref="media.webspeech.synth.enabled",
 Exposed=Window]
interface SpeechSynthesisErrorEvent : SpeechSynthesisEvent {
  constructor(DOMString type, SpeechSynthesisErrorEventInit eventInitDict);

  readonly attribute SpeechSynthesisErrorCode error;
};

dictionary SpeechSynthesisErrorEventInit : SpeechSynthesisEventInit
{
  required SpeechSynthesisErrorCode error;
};
 
/* ---------------------- SpeechSynthesisEvent ----------------------------- */ 
/* ./webidl/SpeechSynthesisEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.synth.enabled",
 Exposed=Window]
interface SpeechSynthesisEvent : Event
{
  constructor(DOMString type, SpeechSynthesisEventInit eventInitDict);

  readonly attribute SpeechSynthesisUtterance utterance;
  readonly attribute unsigned long charIndex;
  readonly attribute unsigned long? charLength;
  readonly attribute float elapsedTime;
  readonly attribute DOMString? name;
};

dictionary SpeechSynthesisEventInit : EventInit
{
  required SpeechSynthesisUtterance utterance;
  unsigned long charIndex = 0;
  unsigned long? charLength = null;
  float elapsedTime = 0;
  DOMString name = "";
};
 
/* ---------------------- SpeechSynthesisUtterance ----------------------------- */ 
/* ./webidl/SpeechSynthesisUtterance.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.synth.enabled",
 Exposed=Window]
interface SpeechSynthesisUtterance : EventTarget {
  [Throws]
  constructor();
  [Throws]
  constructor(DOMString text);

  attribute DOMString text;
  attribute DOMString lang;
  attribute SpeechSynthesisVoice? voice;
  attribute float volume;
  attribute float rate;
  attribute float pitch;

  attribute EventHandler onstart;
  attribute EventHandler onend;
  attribute EventHandler onerror;
  attribute EventHandler onpause;
  attribute EventHandler onresume;
  attribute EventHandler onmark;
  attribute EventHandler onboundary;

  [ChromeOnly]
  readonly attribute DOMString chosenVoiceURI;
};
 
/* ---------------------- SpeechSynthesisVoice ----------------------------- */ 
/* ./webidl/SpeechSynthesisVoice.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dvcs.w3.org/hg/speech-api/raw-file/tip/speechapi.html
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Pref="media.webspeech.synth.enabled",
 Exposed=Window]
interface SpeechSynthesisVoice {
  readonly attribute DOMString voiceURI;
  readonly attribute DOMString name;
  readonly attribute DOMString lang;
  readonly attribute boolean localService;
  readonly attribute boolean default;
};
 
/* ---------------------- StaticRange ----------------------------- */ 
/* ./webidl/StaticRange.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://dom.spec.whatwg.org/#staticrange
 *
 * Copyright  2012 W3C  (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface StaticRange : AbstractRange {
  [Throws]
  constructor(StaticRangeInit init);
  // And no additional functions/properties.
};

dictionary StaticRangeInit {
  required Node startContainer;
  required unsigned long startOffset;
  required Node endContainer;
  required unsigned long endOffset;
};
 
/* ---------------------- StereoPannerNode ----------------------------- */ 
/* ./webidl/StereoPannerNode.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://webaudio.github.io/web-audio-api/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary StereoPannerOptions : AudioNodeOptions {
             float pan = 0;
};

[Pref="dom.webaudio.enabled",
 Exposed=Window]
interface StereoPannerNode : AudioNode {
  [Throws]
  constructor(BaseAudioContext context,
              optional StereoPannerOptions options = {});

  readonly attribute AudioParam pan;
};

// Mozilla extension
StereoPannerNode includes AudioNodePassThrough;
 
/* ---------------------- Storage ----------------------------- */ 
/* ./webidl/Storage.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* The origin of this IDL file is
* http://www.whatwg.org/html/#the-storage-interface
*
* © Copyright 2004-2011 Apple Computer, Inc., Mozilla Foundation, and
* Opera Software ASA. You are granted a license to use, reproduce
* and create derivative works of this document.
*/

[Exposed=Window]
interface Storage {
  [Throws, NeedsSubjectPrincipal]
  readonly attribute unsigned long length;

  [Throws, NeedsSubjectPrincipal]
  DOMString? key(unsigned long index);

  [Throws, NeedsSubjectPrincipal]
  getter DOMString? getItem(DOMString key);

  [Throws, NeedsSubjectPrincipal]
  setter undefined setItem(DOMString key, DOMString value);

  [Throws, NeedsSubjectPrincipal]
  deleter undefined removeItem(DOMString key);

  [Throws, NeedsSubjectPrincipal]
  undefined clear();
};

/**
 * Testing methods that exist only for the benefit of automated glass-box
 * testing.  Will never be exposed to content at large and unlikely to be useful
 * in a WebDriver context.
 */
partial interface Storage {
  /**
   * Does a security-check and ensures the underlying database has been opened
   * without actually calling any database methods.  (Read-only methods will
   * have a similar effect but also impact the state of the snapshot.)
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  undefined open();

  /**
   * Automatically ends any explicit snapshot and drops the reference to the
   * underlying database, but does not otherwise perturb the database.
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  undefined close();

  /**
   * Ensures the database has been opened and initiates an explicit snapshot.
   * Snapshots are normally automatically ended and checkpointed back to the
   * parent, but explicitly opened snapshots must be explicitly ended via
   * `endExplicitSnapshot` or `close`.
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  undefined beginExplicitSnapshot();

  /**
   * Checkpoints the explicitly begun snapshot. This is only useful for testing
   * of snapshot re-using when multiple checkpoints are involved. There's no
   * need to call this before `endExplicitSnapshot` because it checkpoints the
   * snapshot before it's ended.
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  undefined checkpointExplicitSnapshot();

  /**
   * Ends the explicitly begun snapshot and retains the underlying database.
   * Compare with `close` which also drops the reference to the database.
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  undefined endExplicitSnapshot();

  /**
   * Returns true if the underlying database has been opened, the database is
   * not being closed and it has a snapshot (initialized implicitly or
   * explicitly).
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  readonly attribute boolean hasSnapshot;

  /**
   * Returns snapshot usage.
   *
   * @throws NS_ERROR_NOT_AVAILABLE if the underlying database hasn't been
   *         opened or the database is being closed or it doesn't have a
   *         snapshot.
   */
  [Throws, NeedsSubjectPrincipal, Pref="dom.storage.testing"]
  readonly attribute long long snapshotUsage;
};
 
/* ---------------------- StorageEvent ----------------------------- */ 
/* ./webidl/StorageEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Interface for a client side storage. See
 * http://dev.w3.org/html5/webstorage/#the-storage-event
 * for more information.
 *
 * Event sent to a window when a storage area changes.
 */

[Exposed=Window]
interface StorageEvent : Event
{
  constructor(DOMString type, optional StorageEventInit eventInitDict = {});

  readonly attribute DOMString? key;
  readonly attribute DOMString? oldValue;
  readonly attribute DOMString? newValue;
  readonly attribute DOMString? url;
  readonly attribute Storage? storageArea;

  // Bug 1016053 - This is not spec compliant.
  undefined initStorageEvent(DOMString type,
                             optional boolean canBubble = false,
                             optional boolean cancelable = false,
                             optional DOMString? key = null,
                             optional DOMString? oldValue = null,
                             optional DOMString? newValue = null,
                             optional DOMString? url = null,
                             optional Storage? storageArea = null);
};

dictionary StorageEventInit : EventInit
{
  DOMString? key = null;
  DOMString? oldValue = null;
  DOMString? newValue = null;
  DOMString url = "";
  Storage? storageArea = null;
};
 
/* ---------------------- StorageManager ----------------------------- */ 
/* ./webidl/StorageManager.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://storage.spec.whatwg.org/#storagemanager
 *
 */

[SecureContext, Exposed=(Window,Worker)]
interface StorageManager {
  [NewObject]
  Promise<boolean> persisted();

  [Exposed=Window, NewObject]
  Promise<boolean> persist();

  [NewObject]
  Promise<StorageEstimate> estimate();
};

dictionary StorageEstimate {
  unsigned long long usage;
  unsigned long long quota;
};

[SecureContext]
partial interface StorageManager {
  [Pref="dom.fs.enabled", NewObject]
  Promise<FileSystemDirectoryHandle> getDirectory();
};

/**
 * Testing methods that exist only for the benefit of automated glass-box
 * testing.  Will never be exposed to content at large and unlikely to be useful
 * in a WebDriver context.
 */
[SecureContext]
partial interface StorageManager {
  [ChromeOnly]
  undefined shutdown();
};
 
/* ---------------------- StreamFilter ----------------------------- */ 
/* ./webidl/StreamFilter.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/**
 * This is a Mozilla-specific WebExtension API, which is not available to web
 * content. It allows monitoring and filtering of HTTP response stream data.
 *
 * This API should currently be considered experimental, and is not defined by
 * any standard.
 */

enum StreamFilterStatus {
  /**
   * The StreamFilter is not fully initialized. No methods may be called until
   * a "start" event has been received.
   */
  "uninitialized",
  /**
   * The underlying channel is currently transferring data, which will be
   * dispatched via "data" events.
   */
  "transferringdata",
  /**
   * The underlying channel has finished transferring data. Data may still be
   * written via write() calls at this point.
   */
  "finishedtransferringdata",
  /**
   * Data transfer is currently suspended. It may be resumed by a call to
   * resume(). Data may still be written via write() calls in this state.
   */
  "suspended",
  /**
   * The channel has been closed by a call to close(). No further data wlil be
   * delivered via "data" events, and no further data may be written via
   * write() calls.
   */
  "closed",
  /**
   * The channel has been disconnected by a call to disconnect(). All further
   * data will be delivered directly, without passing through the filter. No
   * further events will be dispatched, and no further data may be written by
   * write() calls.
   */
  "disconnected",
  /**
   * An error has occurred and the channel is disconnected. The `error`
   * property contains the details of the error.
   */
  "failed",
};

/**
 * An interface which allows an extension to intercept, and optionally modify,
 * response data from an HTTP request.
 */
[Exposed=Window,
 Func="mozilla::extensions::StreamFilter::IsAllowedInContext"]
interface StreamFilter : EventTarget {
  /**
   * Creates a stream filter for the given add-on and the given extension ID.
   */
  [ChromeOnly]
  static StreamFilter create(unsigned long long requestId, DOMString addonId);

  /**
   * Suspends processing of the request. After this is called, no further data
   * will be delivered until the request is resumed.
   */
  [Throws]
  undefined suspend();

  /**
   * Resumes delivery of data for a suspended request.
   */
  [Throws]
  undefined resume();

  /**
   * Closes the request. After this is called, no more data may be written to
   * the stream, and no further data will be delivered.
   *
   * This *must* be called after the consumer is finished writing data, unless
   * disconnect() has already been called.
   */
  [Throws]
  undefined close();

  /**
   * Disconnects the stream filter from the request. After this is called, no
   * further data will be delivered to the filter, and any unprocessed data
   * will be written directly to the output stream.
   */
  [Throws]
  undefined disconnect();

  /**
   * Writes a chunk of data to the output stream. This may not be called
   * before the "start" event has been received.
   */
  [Throws]
  undefined write((ArrayBuffer or Uint8Array) data);

  /**
   * Returns the current status of the stream.
   */
  [Pure]
  readonly attribute StreamFilterStatus status;

  /**
   * After an "error" event has been dispatched, this contains a message
   * describing the error.
   */
  [Pure]
  readonly attribute DOMString error;

  /**
   * Dispatched with a StreamFilterDataEvent whenever incoming data is
   * available on the stream. This data will not be delivered to the output
   * stream unless it is explicitly written via a write() call.
   */
  attribute EventHandler ondata;

  /**
   * Dispatched when the stream is opened, and is about to begin delivering
   * data.
   */
  attribute EventHandler onstart;

  /**
   * Dispatched when the stream has closed, and has no more data to deliver.
   * The output stream remains open and writable until close() is called.
   */
  attribute EventHandler onstop;

  /**
   * Dispatched when an error has occurred. No further data may be read or
   * written after this point.
   */
  attribute EventHandler onerror;
};
 
/* ---------------------- StreamFilterDataEvent ----------------------------- */ 
/* ./webidl/StreamFilterDataEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This is a Mozilla-specific WebExtension API, which is not available to web
 * content. It allows monitoring and filtering of HTTP response stream data.
 *
 * This API should currently be considered experimental, and is not defined by
 * any standard.
 */

[Func="mozilla::extensions::StreamFilter::IsAllowedInContext",
 Exposed=Window]
interface StreamFilterDataEvent : Event {
  constructor(DOMString type,
              optional StreamFilterDataEventInit eventInitDict = {});

  /**
   * Contains a chunk of data read from the input stream.
   */
  [Pure]
  readonly attribute ArrayBuffer data;
};

dictionary StreamFilterDataEventInit : EventInit {
  required ArrayBuffer data;
};
 
/* ---------------------- StructuredCloneTester ----------------------------- */ 
/* ./webidl/StructuredCloneTester.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 */

[Exposed=(Window,Worker),
 Pref="dom.testing.structuredclonetester.enabled",
 Serializable]
interface StructuredCloneTester {
  constructor(boolean serializable, boolean deserializable);

  readonly attribute boolean serializable;
  readonly attribute boolean deserializable;
};
 
/* ---------------------- StyleSheet ----------------------------- */ 
/* ./webidl/StyleSheet.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/csswg/cssom/
 */

[Exposed=Window]
interface StyleSheet {
  [Constant]
  readonly attribute DOMString type;
  [Constant, Throws]
  readonly attribute DOMString? href;
  // Spec says "Node", but it can go null when the node gets a new
  // sheet.  That's also why it's not [Constant]
  [Pure]
  readonly attribute Node? ownerNode;
  [Pure]
  readonly attribute StyleSheet? parentStyleSheet;
  [Pure]
  readonly attribute DOMString? title;
  [Constant, PutForwards=mediaText]
  readonly attribute MediaList media;
  [Pure]
  attribute boolean disabled;
  // The source map URL for this style sheet.  The source map URL can
  // be found in one of two ways.
  //
  // If a SourceMap or X-SourceMap response header is seen, this is
  // the value.  If both are seen, SourceMap is preferred.  Because
  // this relies on the HTTP response, it can change if checked before
  // the response is available -- which is why it is not [Constant].
  //
  // If the style sheet has the special "# sourceMappingURL=" comment,
  // then this is the URL specified there.
  //
  // If the source map URL is not found by either of these methods,
  // then this is an empty string.
  [ChromeOnly, Pure]
  readonly attribute UTF8String sourceMapURL;
  // The source URL for this style sheet.  If the style sheet has the
  // special "# sourceURL=" comment, then this is the URL specified
  // there.  If no such comment is found, then this is the empty
  // string.
  [ChromeOnly, Pure]
  readonly attribute UTF8String sourceURL;
  [ChromeOnly, Pure]
  readonly attribute Document? associatedDocument;
  [ChromeOnly, Pure, BinaryName="isConstructed"]
  readonly attribute boolean constructed;
};
 
/* ---------------------- StyleSheetList ----------------------------- */ 
/* ./webidl/StyleSheetList.webidl */ 
 
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// https://drafts.csswg.org/cssom/#stylesheetlist
[Exposed=Window]
interface StyleSheetList {
  getter CSSStyleSheet? item(unsigned long index);
  readonly attribute unsigned long length;
};
 
/* ---------------------- SubmitEvent ----------------------------- */ 
/* ./webidl/SubmitEvent.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#submitevent
 */

[Exposed=Window]
interface SubmitEvent : Event {
  constructor(DOMString type, optional SubmitEventInit eventInitDict = {});

  readonly attribute HTMLElement? submitter;
};

dictionary SubmitEventInit : EventInit {
  HTMLElement? submitter = null;
};
 
/* ---------------------- SubtleCrypto ----------------------------- */ 
/* ./webidl/SubtleCrypto.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/WebCryptoAPI/
 */

typedef DOMString KeyType;
typedef DOMString KeyUsage;
typedef DOMString NamedCurve;
typedef Uint8Array BigInteger;

/***** Algorithm dictionaries *****/

dictionary Algorithm {
  required DOMString name;
};

[GenerateInit]
dictionary AesCbcParams : Algorithm {
  required BufferSource iv;
};

[GenerateInit]
dictionary AesCtrParams : Algorithm {
  required BufferSource counter;
  required [EnforceRange] octet length;
};

[GenerateInit]
dictionary AesGcmParams : Algorithm {
  required BufferSource iv;
  BufferSource additionalData;
  [EnforceRange] octet tagLength;
};

dictionary HmacImportParams : Algorithm {
  required AlgorithmIdentifier hash;
};

[GenerateInit]
dictionary Pbkdf2Params : Algorithm {
  required BufferSource salt;
  required [EnforceRange] unsigned long iterations;
  required AlgorithmIdentifier hash;
};

[GenerateInit]
dictionary RsaHashedImportParams {
  required AlgorithmIdentifier hash;
};

dictionary AesKeyGenParams : Algorithm {
  required [EnforceRange] unsigned short length;
};

[GenerateInit]
dictionary HmacKeyGenParams : Algorithm {
  required AlgorithmIdentifier hash;
  [EnforceRange] unsigned long length;
};

[GenerateInit]
dictionary RsaHashedKeyGenParams : Algorithm {
  required [EnforceRange] unsigned long modulusLength;
  required BigInteger publicExponent;
  required AlgorithmIdentifier hash;
};

[GenerateInit]
dictionary RsaOaepParams : Algorithm {
  BufferSource label;
};

[GenerateInit]
dictionary RsaPssParams : Algorithm {
  required [EnforceRange] unsigned long saltLength;
};

[GenerateInit]
dictionary EcKeyGenParams : Algorithm {
  required NamedCurve namedCurve;
};

[GenerateInit]
dictionary AesDerivedKeyParams : Algorithm {
  required [EnforceRange] unsigned long length;
};

[GenerateInit]
dictionary HmacDerivedKeyParams : HmacImportParams {
  [EnforceRange] unsigned long length;
};

[GenerateInit]
dictionary EcdhKeyDeriveParams : Algorithm {
  required CryptoKey public;
};

[GenerateInit]
dictionary DhImportKeyParams : Algorithm {
  required BigInteger prime;
  required BigInteger generator;
};

[GenerateInit]
dictionary EcdsaParams : Algorithm {
  required AlgorithmIdentifier hash;
};

[GenerateInit]
dictionary EcKeyImportParams : Algorithm {
  NamedCurve namedCurve;
};

[GenerateInit]
dictionary HkdfParams : Algorithm {
  required AlgorithmIdentifier hash;
  required BufferSource salt;
  required BufferSource info;
};

/***** JWK *****/

dictionary RsaOtherPrimesInfo {
  // The following fields are defined in Section 6.3.2.7 of JSON Web Algorithms
  required DOMString r;
  required DOMString d;
  required DOMString t;
};

[GenerateInitFromJSON, GenerateToJSON]
dictionary JsonWebKey {
  // The following fields are defined in Section 3.1 of JSON Web Key
  required DOMString kty;
  DOMString use;
  sequence<DOMString> key_ops;
  DOMString alg;

  // The following fields are defined in JSON Web Key Parameters Registration
  boolean ext;

  // The following fields are defined in Section 6 of JSON Web Algorithms
  DOMString crv;
  DOMString x;
  DOMString y;
  DOMString d;
  DOMString n;
  DOMString e;
  DOMString p;
  DOMString q;
  DOMString dp;
  DOMString dq;
  DOMString qi;
  sequence<RsaOtherPrimesInfo> oth;
  DOMString k;
};


/***** The Main API *****/

[Serializable,
 SecureContext,
 Exposed=(Window,Worker)]
interface CryptoKey {
  readonly attribute KeyType type;
  readonly attribute boolean extractable;
  [Cached, Constant, Throws] readonly attribute object algorithm;
  [Cached, Constant, Frozen] readonly attribute sequence<KeyUsage> usages;
};

[GenerateConversionToJS]
dictionary CryptoKeyPair {
  required CryptoKey publicKey;
  required CryptoKey privateKey;
};

typedef DOMString KeyFormat;
typedef (object or DOMString) AlgorithmIdentifier;

[Exposed=(Window,Worker),
 SecureContext]
interface SubtleCrypto {
  [NewObject]
  Promise<any> encrypt(AlgorithmIdentifier algorithm,
                       CryptoKey key,
                       BufferSource data);
  [NewObject]
  Promise<any> decrypt(AlgorithmIdentifier algorithm,
                       CryptoKey key,
                       BufferSource data);
  [NewObject]
  Promise<any> sign(AlgorithmIdentifier algorithm,
                     CryptoKey key,
                     BufferSource data);
  [NewObject]
  Promise<any> verify(AlgorithmIdentifier algorithm,
                      CryptoKey key,
                      BufferSource signature,
                      BufferSource data);
  [NewObject]
  Promise<any> digest(AlgorithmIdentifier algorithm,
                      BufferSource data);

  [NewObject]
  Promise<any> generateKey(AlgorithmIdentifier algorithm,
                           boolean extractable,
                           sequence<KeyUsage> keyUsages );
  [NewObject]
  Promise<any> deriveKey(AlgorithmIdentifier algorithm,
                         CryptoKey baseKey,
                         AlgorithmIdentifier derivedKeyType,
                         boolean extractable,
                         sequence<KeyUsage> keyUsages );
  [NewObject]
  Promise<any> deriveBits(AlgorithmIdentifier algorithm,
                          CryptoKey baseKey,
                          unsigned long length);

  [NewObject]
  Promise<any> importKey(KeyFormat format,
                         object keyData,
                         AlgorithmIdentifier algorithm,
                         boolean extractable,
                         sequence<KeyUsage> keyUsages );
  [NewObject]
  Promise<any> exportKey(KeyFormat format, CryptoKey key);

  [NewObject]
  Promise<any> wrapKey(KeyFormat format,
                       CryptoKey key,
                       CryptoKey wrappingKey,
                       AlgorithmIdentifier wrapAlgorithm);

  [NewObject]
  Promise<any> unwrapKey(KeyFormat format,
                         BufferSource wrappedKey,
                         CryptoKey unwrappingKey,
                         AlgorithmIdentifier unwrapAlgorithm,
                         AlgorithmIdentifier unwrappedKeyAlgorithm,
                         boolean extractable,
                         sequence<KeyUsage> keyUsages );
};
 
/* ---------------------- SVGAElement ----------------------------- */ 
/* ./webidl/SVGAElement.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/SVG2/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAElement : SVGGraphicsElement {
  readonly attribute SVGAnimatedString target;

  [SetterThrows]
  attribute DOMString download;
  [SetterThrows]
  attribute DOMString ping;
  [SetterThrows]
  attribute DOMString rel;
  [SetterThrows]
  attribute DOMString referrerPolicy;
  [PutForwards=value]
  readonly attribute DOMTokenList relList;
  [SetterThrows]
  attribute DOMString hreflang;
  [SetterThrows]
  attribute DOMString type;

  [Throws, Pref="svg.SVGAElement.text.enabled"]
  attribute DOMString text;
};

SVGAElement includes SVGURIReference;
 
/* ---------------------- SVGAngle ----------------------------- */ 
/* ./webidl/SVGAngle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/SVG2/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAngle {

  // Angle Unit Types
  const unsigned short SVG_ANGLETYPE_UNKNOWN = 0;
  const unsigned short SVG_ANGLETYPE_UNSPECIFIED = 1;
  const unsigned short SVG_ANGLETYPE_DEG = 2;
  const unsigned short SVG_ANGLETYPE_RAD = 3;
  const unsigned short SVG_ANGLETYPE_GRAD = 4;

  readonly attribute unsigned short unitType;
           [SetterThrows]
           attribute float value;
           [SetterThrows]
           attribute float valueInSpecifiedUnits;
           [SetterThrows]
           attribute DOMString valueAsString;

  [Throws]
  undefined newValueSpecifiedUnits(unsigned short unitType, float valueInSpecifiedUnits);
  [Throws]
  undefined convertToSpecifiedUnits(unsigned short unitType);
};
 
/* ---------------------- SVGAnimatedAngle ----------------------------- */ 
/* ./webidl/SVGAnimatedAngle.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/SVG2/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAnimatedAngle {
  [Constant]
  readonly attribute SVGAngle baseVal;
  [Constant]
  readonly attribute SVGAngle animVal;
};
 
/* ---------------------- SVGAnimatedBoolean ----------------------------- */ 
/* ./webidl/SVGAnimatedBoolean.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/SVG2/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAnimatedBoolean {
           attribute boolean baseVal;
  readonly attribute boolean animVal;
};
 
/* ---------------------- SVGAnimatedEnumeration ----------------------------- */ 
/* ./webidl/SVGAnimatedEnumeration.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://svgwg.org/svg2-draft/types.html#InterfaceSVGAnimatedEnumeration
 *
 * Copyright © 2013 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAnimatedEnumeration {
  [SetterThrows]
           attribute unsigned short baseVal;
  readonly attribute unsigned short animVal;
};
 
/* ---------------------- SVGAnimatedInteger ----------------------------- */ 
/* ./webidl/SVGAnimatedInteger.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * https://svgwg.org/svg2-draft/types.html#InterfaceSVGAnimatedInteger
 *
 * Copyright © 2013 W3C® (MIT, ERCIM, Keio, Beihang), All Rights Reserved.
 * W3C liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAnimatedInteger {
           attribute long baseVal;
  readonly attribute long animVal;
};
 
/* ---------------------- SVGAnimatedLength ----------------------------- */ 
/* ./webidl/SVGAnimatedLength.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://www.w3.org/TR/SVG2/
 *
 * Copyright © 2012 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

[Exposed=Window]
interface SVGAnimatedLength {
  [Constant]
  readonly attribute SVGLength baseVal;
  [Constant]
  readonly attribute SVGLength animVal;
};
 
/* ---------------------- SVGAnimatedLengthList ----------------------------- */ 
/* ./webidl/SVGAnimatedLengthList.webidl */ 
 
/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file