{
     File:       PMPrintingDialogExtensions.h
 
     Contains:   Mac OS X Printing Manager Print Dialog Extensions' Interfaces.
 
     Version:    Technology: Mac OS X
                 Release:    1.0
 
     Copyright  (c) 1998-2008 by Apple Inc. All Rights Reserved.
 
     Bugs?:      For bug reports, consult the following page on
                 the World Wide Web:
 
                     http://bugs.freepascal.org
}
{  Pascal Translation Updated:  Jonas Maebe, <jonas@freepascal.org>, October 2009 }
{  Pascal Translation Updated:  Jonas Maebe, <jonas@freepascal.org>, October 2012 }
{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$modeswitch cblocks}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

{$IFNDEF FPC_DOTTEDUNITS}
unit PMPrintingDialogExtensions;
{$ENDIF FPC_DOTTEDUNITS}
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}
{$ifc not defined __arm64__ and defined CPUAARCH64}
  {$setc __arm64__ := 1}
{$elsec}
  {$setc __arm64__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
{$ifc defined iphonesim}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
{$ifc defined iphonesim}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elifc defined __arm64__ and __arm64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := TRUE}
{$ifc defined ios}
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$endc}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ nor __arm64__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
{$IFDEF FPC_DOTTEDUNITS}
uses MacOsApi.MacTypes;
{$ELSE FPC_DOTTEDUNITS}
uses MacTypes;
{$ENDIF FPC_DOTTEDUNITS}
{$endc} {not MACOSALLINCLUDE}


{$ifc TARGET_OS_MAC}

{$ALIGN POWER}


{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Constants
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}

{
Define the Kind IDs for Universal and Standard Printing Dialog Extensions.
}
{ Implemented Universal }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPageAttributesKindID CFSTRP('com.apple.print.pde.PageAttributesKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMCopiesAndPagesPDEKindID CFSTRP('com.apple.print.pde.CopiesAndPagesKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMLayoutPDEKindID CFSTRP('com.apple.print.pde.LayoutUserOptionKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMOutputOptionsPDEKindID CFSTRP('com.apple.print.pde.OutputOptionsKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMDuplexPDEKindID CFSTRP('com.apple.print.pde.DuplexKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMCustomPaperSizePDEKindID CFSTRP('com.apple.print.pde.CustomPaperSizeKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMCoverPagePDEKindID CFSTRP('com.apple.print.pde.CoverPageKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMColorMatchingPDEKindID CFSTRP('com.apple.print.pde.ColorMatchingKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMSchedulerPDEKindID CFSTRP('com.apple.print.pde.SchedulerKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMImagingOptionsPDEKindID CFSTRP('com.apple.print.pde.ImagingOptionsKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMFaxCoverPagePDEKindID CFSTRP('com.apple.print.pde.FaxCoverPageKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMFaxModemPDEKindID CFSTRP('com.apple.print.pde.FaxModemKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMFaxAddressesPDEKindID CFSTRP('com.apple.print.pde.FaxAddressesKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPaperHandlingPDEKindID CFSTRP('com.apple.print.pde.PaperHandlingKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPDFEffectsPDEKindID CFSTRP('com.apple.print.pde.PDFEffects')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMSummaryPanelKindID CFSTRP('com.apple.print.pde.SummaryKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMUniPrinterPDEKindID CFSTRP('com.apple.print.pde.UniPrinterKind')}
{$endc}
{ Unimplemented Universal }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPaperSourcePDEKindID CFSTRP('com.apple.print.pde.PaperSourceKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPriorityPDEKindID CFSTRP('com.apple.print.pde.PriorityKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMRotationScalingPDEKindID CFSTRP('com.apple.print.pde.RotationScalingKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMUnsupportedPDEKindID CFSTRP('com.apple.print.pde.UnsupportedPDEKind')}
{$endc}
{ Implemented Standard }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMErrorHandlingPDEKindID CFSTRP('com.apple.print.pde.ErrorHandlingKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPaperFeedPDEKindID CFSTRP('com.apple.print.pde.PaperFeedKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMPrinterFeaturesPDEKindID CFSTRP('com.apple.print.pde.PrinterFeaturesKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMInkPDEKindID CFSTRP('com.apple.print.pde.InkKind')}
{$endc}
{ Unimplemented Standard }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMColorPDEKindID CFSTRP('com.apple.print.pde.ColorKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMQualityMediaPDEKindID CFSTRP('com.apple.print.pde.QualityMediaPDEKind')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMMediaQualityPDEKindID CFSTRP('com.apple.print.pde.MediaQualityPDEKind')}
{$endc}

{ Key to represent information about display order for Cocoa summary info }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec SUMMARY_DISPLAY_ORDER CFSTRP('Summary Display Order')}
{$endc}

{  Boolean key in the Bundle's Info.plist file that sepecifies whether the PDEPanels created by the Bundle are Sandbox compatible }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPMSandboxCompatiblePDEs CFSTRP('PMSandboxCompatiblePDEs')}
{$endc}

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Type Definitions
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{
Basic types...
}

{ Type and Interface IDs. }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kDialogExtensionIntfIDStr CFSTRP('A996FD7E-B738-11D3-8519-0050E4603277')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kGeneralPageSetupDialogTypeIDStr CFSTRP('6E6ED964-B738-11D3-952F-0050E4603277')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kGeneralPrintDialogTypeIDStr CFSTRP('C1BF838E-B72A-11D3-9644-0050E4603277')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAppPageSetupDialogTypeIDStr CFSTRP('B9A0DA98-E57F-11D3-9E83-0050E4603277')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAppPrintDialogTypeIDStr CFSTRP('BCB07250-E57F-11D3-8CA6-0050E4603277')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kAppPrintThumbnailTypeIDStr CFSTRP('9320FE03-B5D5-11D5-84D1-003065D6135E')}
{$endc}
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kPrinterModuleTypeIDStr CFSTRP('BDB091F4-E57F-11D3-B5CC-0050E4603277')}
{$endc}

	
{$endc} {TARGET_OS_MAC}
{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}

end.
{$endc} {not MACOSALLINCLUDE}
