{
 *	CTRun.h
 *	CoreText
 *
 *	Copyright (c) 2004-2012 Apple Inc. All rights reserved.
 *
 }
{  Initial Pascal Translation:  Jonas Maebe, <jonas@freepascal.org>, October 2009 }
{  Pascal Translation Updated:  Jonas Maebe, <jonas@freepascal.org>, October 2012 }
{  Pascal Translation Updated:  Jonas Maebe, <jonas@freepascal.org>, August 2015 }
{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$modeswitch cblocks}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

{$IFNDEF FPC_DOTTEDUNITS}
unit CTRun;
{$ENDIF FPC_DOTTEDUNITS}
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}
{$ifc not defined __arm64__ and defined CPUAARCH64}
  {$setc __arm64__ := 1}
{$elsec}
  {$setc __arm64__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
{$ifc defined iphonesim}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := FALSE}
{$ifc defined iphonesim}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{$setc TARGET_CPU_ARM64 := FALSE}
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elifc defined __arm64__ and __arm64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_CPU_ARM64 := TRUE}
{$ifc defined ios}
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$endc}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ nor __arm64__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
{$IFDEF FPC_DOTTEDUNITS}
uses MacOsApi.MacTypes,MacOsApi.CFBase,MacOsApi.CFDictionary,MacOsApi.CGBase,MacOsApi.CGAffineTransforms,MacOsApi.CGContext,MacOsApi.CGFont,MacOsApi.CGGeometry;
{$ELSE FPC_DOTTEDUNITS}
uses MacTypes,CFBase,CFDictionary,CGBase,CGAffineTransforms,CGContext,CGFont,CGGeometry;
{$ENDIF FPC_DOTTEDUNITS}
{$endc} {not MACOSALLINCLUDE}


{$ALIGN POWER}


{!
    @header

    Thread Safety Information

    All functions in this header are thread safe unless otherwise specified.
}


{ --------------------------------------------------------------------------- }
{ Glyph Run Types }
{ --------------------------------------------------------------------------- }

type
	CTRunRef = ^__CTRun; { an opaque type }
	__CTRun = record end;


{!
	@enum		CTRunStatus
	@abstract	A bitfield passed back by CTRunGetStatus that is used to
				indicate the disposition of the run.

	@constant	kCTRunStatusNoStatus
				The run has no special attributes.

	@constant	kCTRunStatusRightToLeft
				When set, the run is right to left.

	@constant	kCTRunStatusNonMonotonic
				When set, the run has been reordered in some way such that
				the string indices associated with the glyphs are no longer
				strictly increasing (for left to right runs) or decreasing
				(for right to left runs).

	@constant	kCTRunStatusHasNonIdentityMatrix
				When set, the run requires a specific text matrix to be set
				in the current CG context for proper drawing.
}

const
	kCTRunStatusNoStatus = 0;
	kCTRunStatusRightToLeft = 1 shl 0;
	kCTRunStatusNonMonotonic = 1 shl 1;
	kCTRunStatusHasNonIdentityMatrix = 1 shl 2;
type
	CTRunStatus = UInt32;

 
{!
	@function	CTRunGetTypeID
	@abstract	Returns the CFType of the run object
}

function CTRunGetTypeID: CFTypeID; external name '_CTRunGetTypeID';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{ --------------------------------------------------------------------------- }
{ Glyph Run Access }
{ --------------------------------------------------------------------------- }

{!
	@function	CTRunGetGlyphCount
	@abstract	Gets the glyph count for the run.

	@param		run
				The run whose glyph count you wish to access.

	@result		The number of glyphs that the run contains. It is totally
				possible that this function could return a value of zero,
				indicating that there are no glyphs in this run.
}

function CTRunGetGlyphCount( run: CTRunRef ): CFIndex; external name '_CTRunGetGlyphCount';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetAttributes
	@abstract	Returns the attribute dictionary that was used to create the
				glyph run.

	@discussion This dictionary returned is either the same exact one that was
				set as an attribute dictionary on the original attributed string
				or a dictionary that has been manufactured by the layout engine.
				Attribute dictionaries can be manufactured in the case of font
				substitution or if they are missing critical attributes.

	@param		run
				The run whose attributes you wish to access.

	@result		A valid CFDictionaryRef or NULL.
}

function CTRunGetAttributes( run: CTRunRef ): CFDictionaryRef; external name '_CTRunGetAttributes';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetStatus
	@abstract	Returns the run's status.

	@discussion In addition to attributes, runs also have status that can be
				used to expedite certain operations. Knowing the direction and
				ordering of a run's glyphs can aid in string index analysis,
				whereas knowing whether the positions reference the identity
				text matrix can avoid expensive comparisons. Note that this
				status is provided as a convenience, since this information is
				not strictly necessary but can certainly be helpful.

	@param		run
				The run whose status you wish to access.

	@result		The run's status.
}

function CTRunGetStatus( run: CTRunRef ): CTRunStatus; external name '_CTRunGetStatus';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetGlyphsPtr
	@abstract	Returns a direct pointer for the glyph array stored in the run.

	@discussion The glyph array will have a length equal to the value returned by
				CTRunGetGlyphCount. The caller should be prepared for this
				function to return NULL even if there are glyphs in the stream.
				Should this function return NULL, the caller will need to
				allocate their own buffer and call CTRunGetGlyphs to fetch the
				glyphs.

	@param		run
				The run whose glyphs you wish to access.

	@result		A valid pointer to an array of CGGlyph structures or NULL.
}

function CTRunGetGlyphsPtr( run: CTRunRef ): CGGlyphPtr; external name '_CTRunGetGlyphsPtr';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetGlyphs
	@abstract	Copies a range of glyphs into user-provided buffer.

	@param		run
				The run whose glyphs you wish to copy.

	@param		range
				The range of glyphs you wish to copy. If the length of the range
				is set to 0, then the copy operation will continue from the
				range's start index to the end of the run.

	@param		buffer
				The buffer where the glyphs will be copied to. The buffer must be
				allocated to at least the value specified by the range's length.
}

procedure CTRunGetGlyphs( run: CTRunRef; range: CFRange; buffer: {variable-size-array} CGGlyphPtr ); external name '_CTRunGetGlyphs';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetPositionsPtr
	@abstract	Returns a direct pointer for the glyph position array stored in
				the run.

	@discussion The glyph positions in a run are relative to the origin of the
				line containing the run. The position array will have a length
				equal to the value returned by CTRunGetGlyphCount. The caller
				should be prepared for this function to return NULL even if there
				are glyphs in the stream. Should this function return NULL, the
				caller will need to allocate their own buffer and call
				CTRunGetPositions to fetch the positions.

	@param		run
				The run whose positions you wish to access.

	@result		A valid pointer to an array of CGPoint structures or NULL.
}

function CTRunGetPositionsPtr( run: CTRunRef ): CGPointPtr; external name '_CTRunGetPositionsPtr';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetPositions
	@abstract	Copies a range of glyph positions into a user-provided buffer.

	@discussion The glyph positions in a run are relative to the origin of the
				line containing the run.

	@param		run
				The run whose positions you wish to copy.

	@param		range
				The range of glyph positions you wish to copy. If the length of
				the range is set to 0, then the copy operation will continue from
				the range's start index to the end of the run.

	@param		buffer
				The buffer where the glyph positions will be copied to. The buffer
				must be allocated to at least the value specified by the range's
				length.
}

procedure CTRunGetPositions( run: CTRunRef; range: CFRange; buffer: {variable-size-array} CGPointPtr ); external name '_CTRunGetPositions';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetAdvancesPtr
	@abstract	Returns a direct pointer for the glyph advance array stored in
				the run.

	@discussion The advance array will have a length equal to the value returned
				by CTRunGetGlyphCount. The caller should be prepared for this
				function to return NULL even if there are glyphs in the stream.
				Should this function return NULL, the caller will need to
				allocate their own buffer and call CTRunGetAdvances to fetch the
				advances. Note that advances alone are not sufficient for correctly
				positioning glyphs in a line, as a run may have a non-identity
				matrix or the initial glyph in a line may have a non-zero origin;
				callers should consider using positions instead.

	@param		run
				The run whose advances you wish to access.

	@result		A valid pointer to an array of CGSize structures or NULL.
}

function CTRunGetAdvancesPtr( run: CTRunRef ): CGSizePtr; external name '_CTRunGetAdvancesPtr';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetAdvances
	@abstract	Copies a range of glyph advances into a user-provided buffer.

	@param		run
				The run whose advances you wish to copy.

	@param		range
				The range of glyph advances you wish to copy. If the length of
				the range is set to 0, then the copy operation will continue from
				the range's start index to the end of the run.

	@param		buffer
				The buffer where the glyph advances will be copied to. The buffer
				must be allocated to at least the value specified by the range's
				length.
}

procedure CTRunGetAdvances( run: CTRunRef; range: CFRange; buffer: {variable-size-array} CGSizePtr ); external name '_CTRunGetAdvances';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetStringIndicesPtr
	@abstract	Returns a direct pointer for the string indices stored in the run.

	@discussion The indices are the character indices that originally spawned the
				glyphs that make up the run. They can be used to map the glyphs in
				the run back to the characters in the backing store. The string
				indices array will have a length equal to the value returned by
				CTRunGetGlyphCount. The caller should be prepared for this
				function to return NULL even if there are glyphs in the stream.
				Should this function return NULL, the caller will need to allocate
				their own buffer and call CTRunGetStringIndices to fetch the
				indices.

	@param		run
				The run whose string indices you wish to access.

	@result		A valid pointer to an array of CFIndex structures or NULL.
}

function CTRunGetStringIndicesPtr( run: CTRunRef ): CFIndexPtr; external name '_CTRunGetStringIndicesPtr';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetStringIndices
	@abstract	Copies a range of string indices int o a user-provided buffer.

	@discussion The indices are the character indices that originally spawned the
				glyphs that make up the run. They can be used to map the glyphs
				in the run back to the characters in the backing store.

	@param		run
				The run whose string indices you wish to copy.

	@param		range
				The range of string indices you wish to copy. If the length of
				the range is set to 0, then the copy operation will continue from
				the range's start index to the end of the run.

	@param		buffer
				The buffer where the string indices will be copied to. The buffer
				must be allocated to at least the value specified by the range's
				length.
}

procedure CTRunGetStringIndices( run: CTRunRef; range: CFRange; buffer: {variable-size-array} CFIndexPtr ); external name '_CTRunGetStringIndices';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetStringRange
	@abstract	Gets the range of characters that originally spawned the glyphs
				in the run.

	@param		run
				The run whose string range you wish to access.

	@result		Returns the range of characters that originally spawned the
				glyphs. If run is invalid, this will return an empty range.
}

function CTRunGetStringRange( run: CTRunRef ): CFRange; external name '_CTRunGetStringRange';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetTypographicBounds
	@abstract	Gets the typographic bounds of the run.

	@param		run
				The run that you want to calculate the typographic bounds for.

	@param		range
				The portion of the run which to measure. If the length of the
				range is set to 0, then the measure operation will continue from
				the range's start index to the end of the run.

	@param		ascent
				Upon return, this parameter will contain the ascent of the run.
				This may be set to NULL if not needed.

	@param		descent
				Upon return, this parameter will contain the descent of the run.
				This may be set to NULL if not needed.

	@param		leading
				Upon return, this parameter will contain the leading of the run.
				This may be set to NULL if not needed.

	@result		The typographic width of the run. If run or range is
				invalid, then this function will always return zero.
}

function CTRunGetTypographicBounds( run: CTRunRef; range: CFRange; ascent: CGFloatPtr {can be null}; descent: CGFloatPtr {can be null}; leading: CGFloat {can be null} ): Float64; external name '_CTRunGetTypographicBounds';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetImageBounds
	@abstract	Calculates the image bounds for a glyph range.

	@discussion The image bounds for a run is the union of all non-empty glyph
				bounding rects, each positioned as it would be if drawn using
				CTRunDraw using the current context. Note that the result is
				ideal and does not account for raster coverage due to rendering.
				This function is purely a convenience for using glyphs as an
				image and should not be used for typographic purposes.

	@param		run
				The run that you want to calculate the image bounds for.

	@param		context
				The context which the image bounds will be calculated for or NULL,
                in which case the bounds are relative to CGPointZero.

	@param		range
				The portion of the run which to measure. If the length of the
				range is set to 0, then the measure operation will continue from
				the range's start index to the end of the run.

	@result		A rect that tightly encloses the paths of the run's glyphs. The
				rect origin will match the drawn position of the requested range;
				that is, it will be translated by the supplied context's text
				position and the positions of the individual glyphs. If the run
                or range is invalid, CGRectNull will be returned.

	@seealso	CTRunGetTypographicBounds
}

function CTRunGetImageBounds( run: CTRunRef; context: CGContextRef; range: CFRange ): CGRect; external name '_CTRunGetImageBounds';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunGetTextMatrix
	@abstract	Returns the text matrix needed to draw this run.

	@discussion To properly draw the glyphs in a run, the fields 'tx' and 'ty' of
				the CGAffineTransform returned by this function should be set to
				the current text position.

	@param		run
				The run object from which to get the text matrix.

	@result		A CGAffineTransform.
}

function CTRunGetTextMatrix( run: CTRunRef ): CGAffineTransform; external name '_CTRunGetTextMatrix';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)


{!
	@function	CTRunDraw
	@abstract	Draws a complete run or part of one.

	@discussion This is a convenience call, since the run could also be drawn by
				accessing its glyphs, positions, and text matrix. Unlike when
				drawing the entire line containing the run with CTLineDraw, the
				run's underline (if any) will not be drawn, since the underline's
				appearance may depend on other runs in the line. Note that this
				call may leave the graphics context in any state and does not
				flush the context after the draw operation.

	@param		run
				The run that you want to draw.

	@param		context
				The context to draw the run to.

	@param		range
				The portion of the run to draw. If the length of the range is set
				to 0, then the draw operation will continue from the range's
				start index to the end of the run.
}

procedure CTRunDraw( run: CTRunRef; context: CGContextRef; range: CFRange ); external name '_CTRunDraw';
(* CT_AVAILABLE_STARTING( __MAC_10_5, __IPHONE_3_2) *)

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}

end.
{$endc} {not MACOSALLINCLUDE}
