unit minimain; 
 
interface 

{$mode delphi}{$H+}
 
uses 
  SysUtils, Classes, httpd, apr;

procedure RegisterHooks(p: Papr_pool_t); cdecl; 
 
implementation 
 
function DefaultHandler(r: Prequest_rec): Integer; cdecl;
var
  RequestedHandler: ;
begin 
  RequestedHandler := r^.handler;

  { We decline to handle a request if hello-handler is not the value of r->handler }
  if not SameText(RequestedHandler, 'testapache-handler') then
  begin
    Result := DECLINED;
    Exit;
  end;

  { The following line just prints a message to the errorlog }
  ap_log_error('me',1, APLOG_NOERRNO or APLOG_NOTICE, 0, r^.server,
   'mod_hello: %s', ['Before content is output']);

  { We set the content type before doing anything else }
  ap_set_content_type(r, 'text/html');

  { If the request is for a header only, and not a request for
   the whole content, then return OK now. We don't have to do
   anything else. }
  if (r^.header_only <> 0) then
  begin
    Result := OK;
    Exit;
  end;

  { Now we just print the contents of the document using the
   ap_rputs and ap_rprintf functions. More information about
   the use of these can be found in http_protocol.h }
  ap_rputs('<HTML>' + LineEnding, r);
  ap_rputs('<HEAD>' + LineEnding, r);
  ap_rputs('<TITLE>Hello There</TITLE>' + LineEnding, r);
  ap_rputs('</HEAD>' + LineEnding, r);
  ap_rputs('<BODY BGCOLOR="#FFFFFF">' + LineEnding ,r);
  ap_rputs('<H1>Hello world</H1>' + LineEnding, r);
  ap_rputs('This is the first Apache Module working with the new binding from Free Pascal' + LineEnding, r);
  ap_rprintf(r, '<br>A sample line generated by ap_rprintf<br>\n', []);
  ap_rputs('</BODY></HTML>' + LineEnding, r);

  { We can either return OK or DECLINED at this point. If we return
         * OK, then no other modules will attempt to process this request }
  Result := OK;
end;
 
procedure RegisterHooks(p: Papr_pool_t); cdecl; 
begin 
  ap_hook_handler(DefaultHandler,nil,nil,APR_HOOK_MIDDLE); 
end; 
 
end. 
