{$IFNDEF FPC_DOTTEDUNITS}
unit googlediscovery;
{$ENDIF FPC_DOTTEDUNITS}
{$MODE objfpc}
{$H+}

interface

{$IFDEF FPC_DOTTEDUNITS}
uses System.SysUtils, System.Classes, GoogleApi.Service, FpWeb.Rest.Base, GoogleApi.Base;
{$ELSE FPC_DOTTEDUNITS}
uses sysutils, classes, googleservice, restbase, googlebase;
{$ENDIF FPC_DOTTEDUNITS}

type
  
  //Top-level schema types
  TDirectoryList = Class;
  TJsonSchema = Class;
  TRestDescription = Class;
  TRestMethod = Class;
  TRestResource = Class;
  TDirectoryListArray = Array of TDirectoryList;
  TJsonSchemaArray = Array of TJsonSchema;
  TRestDescriptionArray = Array of TRestDescription;
  TRestMethodArray = Array of TRestMethod;
  TRestResourceArray = Array of TRestResource;
  //Anonymous types, using auto-generated names
  TDirectoryListTypeitemsItemTypeicons = Class;
  TDirectoryListTypeitemsItem = Class;
  TJsonSchemaTypeannotations = Class;
  TJsonSchemaTypeproperties = Class;
  TJsonSchemaTypevariantTypemapItem = Class;
  TJsonSchemaTypevariant = Class;
  TRestDescriptionTypeauthTypeoauth2Typescopes = Class;
  TRestDescriptionTypeauthTypeoauth2 = Class;
  TRestDescriptionTypeauth = Class;
  TRestDescriptionTypeicons = Class;
  TRestDescriptionTypemethods = Class;
  TRestDescriptionTypeparameters = Class;
  TRestDescriptionTyperesources = Class;
  TRestDescriptionTypeschemas = Class;
  TRestMethodTypemediaUploadTypeprotocolsTyperesumable = Class;
  TRestMethodTypemediaUploadTypeprotocolsTypesimple = Class;
  TRestMethodTypemediaUploadTypeprotocols = Class;
  TRestMethodTypemediaUpload = Class;
  TRestMethodTypeparameters = Class;
  TRestMethodTyperequest = Class;
  TRestMethodTyperesponse = Class;
  TRestResourceTypemethods = Class;
  TRestResourceTyperesources = Class;
  TDirectoryListTypeitemsArray = Array of TDirectoryListTypeitemsItem;
  TJsonSchemaTypevariantTypemapArray = Array of TJsonSchemaTypevariantTypemapItem;
  
  { --------------------------------------------------------------------
    TDirectoryListTypeitemsItemTypeicons
    --------------------------------------------------------------------}
  
  TDirectoryListTypeitemsItemTypeicons = Class(TGoogleBaseObject)
  Private
    Fx16 : String;
    Fx32 : String;
  Protected
    //Property setters
    Procedure Setx16(AIndex : Integer; const AValue : String); virtual;
    Procedure Setx32(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property x16 : String Index 0 Read Fx16 Write Setx16;
    Property x32 : String Index 8 Read Fx32 Write Setx32;
  end;
  TDirectoryListTypeitemsItemTypeiconsClass = Class of TDirectoryListTypeitemsItemTypeicons;
  
  { --------------------------------------------------------------------
    TDirectoryListTypeitemsItem
    --------------------------------------------------------------------}
  
  TDirectoryListTypeitemsItem = Class(TGoogleBaseObject)
  Private
    Fdescription : String;
    FdiscoveryLink : String;
    FdiscoveryRestUrl : String;
    FdocumentationLink : String;
    Ficons : TDirectoryListTypeitemsItemTypeicons;
    Fid : String;
    Fkind : String;
    Flabels : TStringArray;
    Fname : String;
    Fpreferred : boolean;
    Ftitle : String;
    Fversion : String;
  Protected
    //Property setters
    Procedure Setdescription(AIndex : Integer; const AValue : String); virtual;
    Procedure SetdiscoveryLink(AIndex : Integer; const AValue : String); virtual;
    Procedure SetdiscoveryRestUrl(AIndex : Integer; const AValue : String); virtual;
    Procedure SetdocumentationLink(AIndex : Integer; const AValue : String); virtual;
    Procedure Seticons(AIndex : Integer; const AValue : TDirectoryListTypeitemsItemTypeicons); virtual;
    Procedure Setid(AIndex : Integer; const AValue : String); virtual;
    Procedure Setkind(AIndex : Integer; const AValue : String); virtual;
    Procedure Setlabels(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure Setname(AIndex : Integer; const AValue : String); virtual;
    Procedure Setpreferred(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Settitle(AIndex : Integer; const AValue : String); virtual;
    Procedure Setversion(AIndex : Integer; const AValue : String); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property description : String Index 0 Read Fdescription Write Setdescription;
    Property discoveryLink : String Index 8 Read FdiscoveryLink Write SetdiscoveryLink;
    Property discoveryRestUrl : String Index 16 Read FdiscoveryRestUrl Write SetdiscoveryRestUrl;
    Property documentationLink : String Index 24 Read FdocumentationLink Write SetdocumentationLink;
    Property icons : TDirectoryListTypeitemsItemTypeicons Index 32 Read Ficons Write Seticons;
    Property id : String Index 40 Read Fid Write Setid;
    Property kind : String Index 48 Read Fkind Write Setkind;
    Property labels : TStringArray Index 56 Read Flabels Write Setlabels;
    Property name : String Index 64 Read Fname Write Setname;
    Property preferred : boolean Index 72 Read Fpreferred Write Setpreferred;
    Property title : String Index 80 Read Ftitle Write Settitle;
    Property version : String Index 88 Read Fversion Write Setversion;
  end;
  TDirectoryListTypeitemsItemClass = Class of TDirectoryListTypeitemsItem;
  
  { --------------------------------------------------------------------
    TDirectoryList
    --------------------------------------------------------------------}
  
  TDirectoryList = Class(TGoogleBaseObject)
  Private
    FdiscoveryVersion : String;
    Fitems : TDirectoryListTypeitemsArray;
    Fkind : String;
  Protected
    //Property setters
    Procedure SetdiscoveryVersion(AIndex : Integer; const AValue : String); virtual;
    Procedure Setitems(AIndex : Integer; const AValue : TDirectoryListTypeitemsArray); virtual;
    Procedure Setkind(AIndex : Integer; const AValue : String); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property discoveryVersion : String Index 0 Read FdiscoveryVersion Write SetdiscoveryVersion;
    Property items : TDirectoryListTypeitemsArray Index 8 Read Fitems Write Setitems;
    Property kind : String Index 16 Read Fkind Write Setkind;
  end;
  TDirectoryListClass = Class of TDirectoryList;
  
  { --------------------------------------------------------------------
    TJsonSchemaTypeannotations
    --------------------------------------------------------------------}
  
  TJsonSchemaTypeannotations = Class(TGoogleBaseObject)
  Private
    Frequired : TStringArray;
  Protected
    //Property setters
    Procedure Setrequired(AIndex : Integer; const AValue : TStringArray); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property required : TStringArray Index 0 Read Frequired Write Setrequired;
  end;
  TJsonSchemaTypeannotationsClass = Class of TJsonSchemaTypeannotations;
  
  { --------------------------------------------------------------------
    TJsonSchemaTypeproperties
    --------------------------------------------------------------------}
  
  TJsonSchemaTypeproperties = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TJsonSchemaTypepropertiesClass = Class of TJsonSchemaTypeproperties;
  
  { --------------------------------------------------------------------
    TJsonSchemaTypevariantTypemapItem
    --------------------------------------------------------------------}
  
  TJsonSchemaTypevariantTypemapItem = Class(TGoogleBaseObject)
  Private
    Fref : String;
    Ftype_value : String;
  Protected
    Class Function ExportPropertyName(Const AName : String) : string; override;
    //Property setters
    Procedure Setref(AIndex : Integer; const AValue : String); virtual;
    Procedure Settype_value(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property ref : String Index 0 Read Fref Write Setref;
    Property type_value : String Index 8 Read Ftype_value Write Settype_value;
  end;
  TJsonSchemaTypevariantTypemapItemClass = Class of TJsonSchemaTypevariantTypemapItem;
  
  { --------------------------------------------------------------------
    TJsonSchemaTypevariant
    --------------------------------------------------------------------}
  
  TJsonSchemaTypevariant = Class(TGoogleBaseObject)
  Private
    Fdiscriminant : String;
    Fmap : TJsonSchemaTypevariantTypemapArray;
  Protected
    //Property setters
    Procedure Setdiscriminant(AIndex : Integer; const AValue : String); virtual;
    Procedure Setmap(AIndex : Integer; const AValue : TJsonSchemaTypevariantTypemapArray); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property discriminant : String Index 0 Read Fdiscriminant Write Setdiscriminant;
    Property map : TJsonSchemaTypevariantTypemapArray Index 8 Read Fmap Write Setmap;
  end;
  TJsonSchemaTypevariantClass = Class of TJsonSchemaTypevariant;
  
  { --------------------------------------------------------------------
    TJsonSchema
    --------------------------------------------------------------------}
  
  TJsonSchema = Class(TGoogleBaseObject)
  Private
    Fref : String;
    FadditionalProperties : TJsonSchema;
    Fannotations : TJsonSchemaTypeannotations;
    Fdefault : String;
    Fdescription : String;
    Fenum : TStringArray;
    FenumDescriptions : TStringArray;
    Fformat : String;
    Fid : String;
    Fitems : TJsonSchema;
    Flocation : String;
    Fmaximum : String;
    Fminimum : String;
    Fpattern : String;
    Fproperties : TJsonSchemaTypeproperties;
    FreadOnly : boolean;
    Frepeated : boolean;
    Frequired : boolean;
    F_type : String;
    Fvariant : TJsonSchemaTypevariant;
  Protected
    Class Function ExportPropertyName(Const AName : String) : string; override;
    //Property setters
    Procedure Setref(AIndex : Integer; const AValue : String); virtual;
    Procedure SetadditionalProperties(AIndex : Integer; const AValue : TJsonSchema); virtual;
    Procedure Setannotations(AIndex : Integer; const AValue : TJsonSchemaTypeannotations); virtual;
    Procedure Setdefault(AIndex : Integer; const AValue : String); virtual;
    Procedure Setdescription(AIndex : Integer; const AValue : String); virtual;
    Procedure Setenum(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure SetenumDescriptions(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure Setformat(AIndex : Integer; const AValue : String); virtual;
    Procedure Setid(AIndex : Integer; const AValue : String); virtual;
    Procedure Setitems(AIndex : Integer; const AValue : TJsonSchema); virtual;
    Procedure Setlocation(AIndex : Integer; const AValue : String); virtual;
    Procedure Setmaximum(AIndex : Integer; const AValue : String); virtual;
    Procedure Setminimum(AIndex : Integer; const AValue : String); virtual;
    Procedure Setpattern(AIndex : Integer; const AValue : String); virtual;
    Procedure Setproperties(AIndex : Integer; const AValue : TJsonSchemaTypeproperties); virtual;
    Procedure SetreadOnly(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Setrepeated(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Setrequired(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Set_type(AIndex : Integer; const AValue : String); virtual;
    Procedure Setvariant(AIndex : Integer; const AValue : TJsonSchemaTypevariant); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property ref : String Index 0 Read Fref Write Setref;
    Property additionalProperties : TJsonSchema Index 8 Read FadditionalProperties Write SetadditionalProperties;
    Property annotations : TJsonSchemaTypeannotations Index 16 Read Fannotations Write Setannotations;
    Property default : String Index 24 Read Fdefault Write Setdefault;
    Property description : String Index 32 Read Fdescription Write Setdescription;
    Property enum : TStringArray Index 40 Read Fenum Write Setenum;
    Property enumDescriptions : TStringArray Index 48 Read FenumDescriptions Write SetenumDescriptions;
    Property format : String Index 56 Read Fformat Write Setformat;
    Property id : String Index 64 Read Fid Write Setid;
    Property items : TJsonSchema Index 72 Read Fitems Write Setitems;
    Property location : String Index 80 Read Flocation Write Setlocation;
    Property maximum : String Index 88 Read Fmaximum Write Setmaximum;
    Property minimum : String Index 96 Read Fminimum Write Setminimum;
    Property pattern : String Index 104 Read Fpattern Write Setpattern;
    Property properties : TJsonSchemaTypeproperties Index 112 Read Fproperties Write Setproperties;
    Property readOnly : boolean Index 120 Read FreadOnly Write SetreadOnly;
    Property repeated : boolean Index 128 Read Frepeated Write Setrepeated;
    Property required : boolean Index 136 Read Frequired Write Setrequired;
    Property _type : String Index 144 Read F_type Write Set_type;
    Property variant : TJsonSchemaTypevariant Index 152 Read Fvariant Write Setvariant;
  end;
  TJsonSchemaClass = Class of TJsonSchema;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypeauthTypeoauth2Typescopes
    --------------------------------------------------------------------}
  
  TRestDescriptionTypeauthTypeoauth2Typescopes = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestDescriptionTypeauthTypeoauth2TypescopesClass = Class of TRestDescriptionTypeauthTypeoauth2Typescopes;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypeauthTypeoauth2
    --------------------------------------------------------------------}
  
  TRestDescriptionTypeauthTypeoauth2 = Class(TGoogleBaseObject)
  Private
    Fscopes : TRestDescriptionTypeauthTypeoauth2Typescopes;
  Protected
    //Property setters
    Procedure Setscopes(AIndex : Integer; const AValue : TRestDescriptionTypeauthTypeoauth2Typescopes); virtual;
  Public
  Published
    Property scopes : TRestDescriptionTypeauthTypeoauth2Typescopes Index 0 Read Fscopes Write Setscopes;
  end;
  TRestDescriptionTypeauthTypeoauth2Class = Class of TRestDescriptionTypeauthTypeoauth2;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypeauth
    --------------------------------------------------------------------}
  
  TRestDescriptionTypeauth = Class(TGoogleBaseObject)
  Private
    Foauth2 : TRestDescriptionTypeauthTypeoauth2;
  Protected
    //Property setters
    Procedure Setoauth2(AIndex : Integer; const AValue : TRestDescriptionTypeauthTypeoauth2); virtual;
  Public
  Published
    Property oauth2 : TRestDescriptionTypeauthTypeoauth2 Index 0 Read Foauth2 Write Setoauth2;
  end;
  TRestDescriptionTypeauthClass = Class of TRestDescriptionTypeauth;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypeicons
    --------------------------------------------------------------------}
  
  TRestDescriptionTypeicons = Class(TGoogleBaseObject)
  Private
    Fx16 : String;
    Fx32 : String;
  Protected
    //Property setters
    Procedure Setx16(AIndex : Integer; const AValue : String); virtual;
    Procedure Setx32(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property x16 : String Index 0 Read Fx16 Write Setx16;
    Property x32 : String Index 8 Read Fx32 Write Setx32;
  end;
  TRestDescriptionTypeiconsClass = Class of TRestDescriptionTypeicons;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypemethods
    --------------------------------------------------------------------}
  
  TRestDescriptionTypemethods = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestDescriptionTypemethodsClass = Class of TRestDescriptionTypemethods;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypeparameters
    --------------------------------------------------------------------}
  
  TRestDescriptionTypeparameters = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestDescriptionTypeparametersClass = Class of TRestDescriptionTypeparameters;
  
  { --------------------------------------------------------------------
    TRestDescriptionTyperesources
    --------------------------------------------------------------------}
  
  TRestDescriptionTyperesources = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestDescriptionTyperesourcesClass = Class of TRestDescriptionTyperesources;
  
  { --------------------------------------------------------------------
    TRestDescriptionTypeschemas
    --------------------------------------------------------------------}
  
  TRestDescriptionTypeschemas = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestDescriptionTypeschemasClass = Class of TRestDescriptionTypeschemas;
  
  { --------------------------------------------------------------------
    TRestDescription
    --------------------------------------------------------------------}
  
  TRestDescription = Class(TGoogleBaseObject)
  Private
    Fauth : TRestDescriptionTypeauth;
    FbasePath : String;
    FbaseUrl : String;
    FbatchPath : String;
    FcanonicalName : String;
    Fdescription : String;
    FdiscoveryVersion : String;
    FdocumentationLink : String;
    Fetag : String;
    FexponentialBackoffDefault : boolean;
    Ffeatures : TStringArray;
    Ficons : TRestDescriptionTypeicons;
    Fid : String;
    Fkind : String;
    Flabels : TStringArray;
    Fmethods : TRestDescriptionTypemethods;
    Fname : String;
    FownerDomain : String;
    FownerName : String;
    FpackagePath : String;
    Fparameters : TRestDescriptionTypeparameters;
    Fprotocol : String;
    Fresources : TRestDescriptionTyperesources;
    Frevision : String;
    FrootUrl : String;
    Fschemas : TRestDescriptionTypeschemas;
    FservicePath : String;
    Ftitle : String;
    Fversion : String;
    Fversion_module : boolean;
  Protected
    //Property setters
    Procedure Setauth(AIndex : Integer; const AValue : TRestDescriptionTypeauth); virtual;
    Procedure SetbasePath(AIndex : Integer; const AValue : String); virtual;
    Procedure SetbaseUrl(AIndex : Integer; const AValue : String); virtual;
    Procedure SetbatchPath(AIndex : Integer; const AValue : String); virtual;
    Procedure SetcanonicalName(AIndex : Integer; const AValue : String); virtual;
    Procedure Setdescription(AIndex : Integer; const AValue : String); virtual;
    Procedure SetdiscoveryVersion(AIndex : Integer; const AValue : String); virtual;
    Procedure SetdocumentationLink(AIndex : Integer; const AValue : String); virtual;
    Procedure Setetag(AIndex : Integer; const AValue : String); virtual;
    Procedure SetexponentialBackoffDefault(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Setfeatures(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure Seticons(AIndex : Integer; const AValue : TRestDescriptionTypeicons); virtual;
    Procedure Setid(AIndex : Integer; const AValue : String); virtual;
    Procedure Setkind(AIndex : Integer; const AValue : String); virtual;
    Procedure Setlabels(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure Setmethods(AIndex : Integer; const AValue : TRestDescriptionTypemethods); virtual;
    Procedure Setname(AIndex : Integer; const AValue : String); virtual;
    Procedure SetownerDomain(AIndex : Integer; const AValue : String); virtual;
    Procedure SetownerName(AIndex : Integer; const AValue : String); virtual;
    Procedure SetpackagePath(AIndex : Integer; const AValue : String); virtual;
    Procedure Setparameters(AIndex : Integer; const AValue : TRestDescriptionTypeparameters); virtual;
    Procedure Setprotocol(AIndex : Integer; const AValue : String); virtual;
    Procedure Setresources(AIndex : Integer; const AValue : TRestDescriptionTyperesources); virtual;
    Procedure Setrevision(AIndex : Integer; const AValue : String); virtual;
    Procedure SetrootUrl(AIndex : Integer; const AValue : String); virtual;
    Procedure Setschemas(AIndex : Integer; const AValue : TRestDescriptionTypeschemas); virtual;
    Procedure SetservicePath(AIndex : Integer; const AValue : String); virtual;
    Procedure Settitle(AIndex : Integer; const AValue : String); virtual;
    Procedure Setversion(AIndex : Integer; const AValue : String); virtual;
    Procedure Setversion_module(AIndex : Integer; const AValue : boolean); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property auth : TRestDescriptionTypeauth Index 0 Read Fauth Write Setauth;
    Property basePath : String Index 8 Read FbasePath Write SetbasePath;
    Property baseUrl : String Index 16 Read FbaseUrl Write SetbaseUrl;
    Property batchPath : String Index 24 Read FbatchPath Write SetbatchPath;
    Property canonicalName : String Index 32 Read FcanonicalName Write SetcanonicalName;
    Property description : String Index 40 Read Fdescription Write Setdescription;
    Property discoveryVersion : String Index 48 Read FdiscoveryVersion Write SetdiscoveryVersion;
    Property documentationLink : String Index 56 Read FdocumentationLink Write SetdocumentationLink;
    Property etag : String Index 64 Read Fetag Write Setetag;
    Property exponentialBackoffDefault : boolean Index 72 Read FexponentialBackoffDefault Write SetexponentialBackoffDefault;
    Property features : TStringArray Index 80 Read Ffeatures Write Setfeatures;
    Property icons : TRestDescriptionTypeicons Index 88 Read Ficons Write Seticons;
    Property id : String Index 96 Read Fid Write Setid;
    Property kind : String Index 104 Read Fkind Write Setkind;
    Property labels : TStringArray Index 112 Read Flabels Write Setlabels;
    Property methods : TRestDescriptionTypemethods Index 120 Read Fmethods Write Setmethods;
    Property name : String Index 128 Read Fname Write Setname;
    Property ownerDomain : String Index 136 Read FownerDomain Write SetownerDomain;
    Property ownerName : String Index 144 Read FownerName Write SetownerName;
    Property packagePath : String Index 152 Read FpackagePath Write SetpackagePath;
    Property parameters : TRestDescriptionTypeparameters Index 160 Read Fparameters Write Setparameters;
    Property protocol : String Index 168 Read Fprotocol Write Setprotocol;
    Property resources : TRestDescriptionTyperesources Index 176 Read Fresources Write Setresources;
    Property revision : String Index 184 Read Frevision Write Setrevision;
    Property rootUrl : String Index 192 Read FrootUrl Write SetrootUrl;
    Property schemas : TRestDescriptionTypeschemas Index 200 Read Fschemas Write Setschemas;
    Property servicePath : String Index 208 Read FservicePath Write SetservicePath;
    Property title : String Index 216 Read Ftitle Write Settitle;
    Property version : String Index 224 Read Fversion Write Setversion;
    Property version_module : boolean Index 232 Read Fversion_module Write Setversion_module;
  end;
  TRestDescriptionClass = Class of TRestDescription;
  
  { --------------------------------------------------------------------
    TRestMethodTypemediaUploadTypeprotocolsTyperesumable
    --------------------------------------------------------------------}
  
  TRestMethodTypemediaUploadTypeprotocolsTyperesumable = Class(TGoogleBaseObject)
  Private
    Fmultipart : boolean;
    Fpath : String;
  Protected
    //Property setters
    Procedure Setmultipart(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Setpath(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property multipart : boolean Index 0 Read Fmultipart Write Setmultipart;
    Property path : String Index 8 Read Fpath Write Setpath;
  end;
  TRestMethodTypemediaUploadTypeprotocolsTyperesumableClass = Class of TRestMethodTypemediaUploadTypeprotocolsTyperesumable;
  
  { --------------------------------------------------------------------
    TRestMethodTypemediaUploadTypeprotocolsTypesimple
    --------------------------------------------------------------------}
  
  TRestMethodTypemediaUploadTypeprotocolsTypesimple = Class(TGoogleBaseObject)
  Private
    Fmultipart : boolean;
    Fpath : String;
  Protected
    //Property setters
    Procedure Setmultipart(AIndex : Integer; const AValue : boolean); virtual;
    Procedure Setpath(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property multipart : boolean Index 0 Read Fmultipart Write Setmultipart;
    Property path : String Index 8 Read Fpath Write Setpath;
  end;
  TRestMethodTypemediaUploadTypeprotocolsTypesimpleClass = Class of TRestMethodTypemediaUploadTypeprotocolsTypesimple;
  
  { --------------------------------------------------------------------
    TRestMethodTypemediaUploadTypeprotocols
    --------------------------------------------------------------------}
  
  TRestMethodTypemediaUploadTypeprotocols = Class(TGoogleBaseObject)
  Private
    Fresumable : TRestMethodTypemediaUploadTypeprotocolsTyperesumable;
    Fsimple : TRestMethodTypemediaUploadTypeprotocolsTypesimple;
  Protected
    //Property setters
    Procedure Setresumable(AIndex : Integer; const AValue : TRestMethodTypemediaUploadTypeprotocolsTyperesumable); virtual;
    Procedure Setsimple(AIndex : Integer; const AValue : TRestMethodTypemediaUploadTypeprotocolsTypesimple); virtual;
  Public
  Published
    Property resumable : TRestMethodTypemediaUploadTypeprotocolsTyperesumable Index 0 Read Fresumable Write Setresumable;
    Property simple : TRestMethodTypemediaUploadTypeprotocolsTypesimple Index 8 Read Fsimple Write Setsimple;
  end;
  TRestMethodTypemediaUploadTypeprotocolsClass = Class of TRestMethodTypemediaUploadTypeprotocols;
  
  { --------------------------------------------------------------------
    TRestMethodTypemediaUpload
    --------------------------------------------------------------------}
  
  TRestMethodTypemediaUpload = Class(TGoogleBaseObject)
  Private
    Faccept : TStringArray;
    FmaxSize : String;
    Fprotocols : TRestMethodTypemediaUploadTypeprotocols;
  Protected
    //Property setters
    Procedure Setaccept(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure SetmaxSize(AIndex : Integer; const AValue : String); virtual;
    Procedure Setprotocols(AIndex : Integer; const AValue : TRestMethodTypemediaUploadTypeprotocols); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property accept : TStringArray Index 0 Read Faccept Write Setaccept;
    Property maxSize : String Index 8 Read FmaxSize Write SetmaxSize;
    Property protocols : TRestMethodTypemediaUploadTypeprotocols Index 16 Read Fprotocols Write Setprotocols;
  end;
  TRestMethodTypemediaUploadClass = Class of TRestMethodTypemediaUpload;
  
  { --------------------------------------------------------------------
    TRestMethodTypeparameters
    --------------------------------------------------------------------}
  
  TRestMethodTypeparameters = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestMethodTypeparametersClass = Class of TRestMethodTypeparameters;
  
  { --------------------------------------------------------------------
    TRestMethodTyperequest
    --------------------------------------------------------------------}
  
  TRestMethodTyperequest = Class(TGoogleBaseObject)
  Private
    Fref : String;
    FparameterName : String;
  Protected
    Class Function ExportPropertyName(Const AName : String) : string; override;
    //Property setters
    Procedure Setref(AIndex : Integer; const AValue : String); virtual;
    Procedure SetparameterName(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property ref : String Index 0 Read Fref Write Setref;
    Property parameterName : String Index 8 Read FparameterName Write SetparameterName;
  end;
  TRestMethodTyperequestClass = Class of TRestMethodTyperequest;
  
  { --------------------------------------------------------------------
    TRestMethodTyperesponse
    --------------------------------------------------------------------}
  
  TRestMethodTyperesponse = Class(TGoogleBaseObject)
  Private
    Fref : String;
  Protected
    Class Function ExportPropertyName(Const AName : String) : string; override;
    //Property setters
    Procedure Setref(AIndex : Integer; const AValue : String); virtual;
  Public
  Published
    Property ref : String Index 0 Read Fref Write Setref;
  end;
  TRestMethodTyperesponseClass = Class of TRestMethodTyperesponse;
  
  { --------------------------------------------------------------------
    TRestMethod
    --------------------------------------------------------------------}
  
  TRestMethod = Class(TGoogleBaseObject)
  Private
    Fdescription : String;
    FetagRequired : boolean;
    FhttpMethod : String;
    Fid : String;
    FmediaUpload : TRestMethodTypemediaUpload;
    FparameterOrder : TStringArray;
    Fparameters : TRestMethodTypeparameters;
    Fpath : String;
    Frequest : TRestMethodTyperequest;
    Fresponse : TRestMethodTyperesponse;
    Fscopes : TStringArray;
    FsupportsMediaDownload : boolean;
    FsupportsMediaUpload : boolean;
    FsupportsSubscription : boolean;
    FuseMediaDownloadService : boolean;
  Protected
    //Property setters
    Procedure Setdescription(AIndex : Integer; const AValue : String); virtual;
    Procedure SetetagRequired(AIndex : Integer; const AValue : boolean); virtual;
    Procedure SethttpMethod(AIndex : Integer; const AValue : String); virtual;
    Procedure Setid(AIndex : Integer; const AValue : String); virtual;
    Procedure SetmediaUpload(AIndex : Integer; const AValue : TRestMethodTypemediaUpload); virtual;
    Procedure SetparameterOrder(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure Setparameters(AIndex : Integer; const AValue : TRestMethodTypeparameters); virtual;
    Procedure Setpath(AIndex : Integer; const AValue : String); virtual;
    Procedure Setrequest(AIndex : Integer; const AValue : TRestMethodTyperequest); virtual;
    Procedure Setresponse(AIndex : Integer; const AValue : TRestMethodTyperesponse); virtual;
    Procedure Setscopes(AIndex : Integer; const AValue : TStringArray); virtual;
    Procedure SetsupportsMediaDownload(AIndex : Integer; const AValue : boolean); virtual;
    Procedure SetsupportsMediaUpload(AIndex : Integer; const AValue : boolean); virtual;
    Procedure SetsupportsSubscription(AIndex : Integer; const AValue : boolean); virtual;
    Procedure SetuseMediaDownloadService(AIndex : Integer; const AValue : boolean); virtual;
    //2.6.4. bug workaround
    {$IFDEF VER2_6}
    Procedure SetArrayLength(Const AName : String; ALength : Longint); override;
    {$ENDIF VER2_6}
  Public
  Published
    Property description : String Index 0 Read Fdescription Write Setdescription;
    Property etagRequired : boolean Index 8 Read FetagRequired Write SetetagRequired;
    Property httpMethod : String Index 16 Read FhttpMethod Write SethttpMethod;
    Property id : String Index 24 Read Fid Write Setid;
    Property mediaUpload : TRestMethodTypemediaUpload Index 32 Read FmediaUpload Write SetmediaUpload;
    Property parameterOrder : TStringArray Index 40 Read FparameterOrder Write SetparameterOrder;
    Property parameters : TRestMethodTypeparameters Index 48 Read Fparameters Write Setparameters;
    Property path : String Index 56 Read Fpath Write Setpath;
    Property request : TRestMethodTyperequest Index 64 Read Frequest Write Setrequest;
    Property response : TRestMethodTyperesponse Index 72 Read Fresponse Write Setresponse;
    Property scopes : TStringArray Index 80 Read Fscopes Write Setscopes;
    Property supportsMediaDownload : boolean Index 88 Read FsupportsMediaDownload Write SetsupportsMediaDownload;
    Property supportsMediaUpload : boolean Index 96 Read FsupportsMediaUpload Write SetsupportsMediaUpload;
    Property supportsSubscription : boolean Index 104 Read FsupportsSubscription Write SetsupportsSubscription;
    Property useMediaDownloadService : boolean Index 112 Read FuseMediaDownloadService Write SetuseMediaDownloadService;
  end;
  TRestMethodClass = Class of TRestMethod;
  
  { --------------------------------------------------------------------
    TRestResourceTypemethods
    --------------------------------------------------------------------}
  
  TRestResourceTypemethods = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestResourceTypemethodsClass = Class of TRestResourceTypemethods;
  
  { --------------------------------------------------------------------
    TRestResourceTyperesources
    --------------------------------------------------------------------}
  
  TRestResourceTyperesources = Class(TGoogleBaseObject)
  Private
  Protected
    //Property setters
  Public
    Class Function AllowAdditionalProperties : Boolean; override;
  Published
  end;
  TRestResourceTyperesourcesClass = Class of TRestResourceTyperesources;
  
  { --------------------------------------------------------------------
    TRestResource
    --------------------------------------------------------------------}
  
  TRestResource = Class(TGoogleBaseObject)
  Private
    Fmethods : TRestResourceTypemethods;
    Fresources : TRestResourceTyperesources;
  Protected
    //Property setters
    Procedure Setmethods(AIndex : Integer; const AValue : TRestResourceTypemethods); virtual;
    Procedure Setresources(AIndex : Integer; const AValue : TRestResourceTyperesources); virtual;
  Public
  Published
    Property methods : TRestResourceTypemethods Index 0 Read Fmethods Write Setmethods;
    Property resources : TRestResourceTyperesources Index 8 Read Fresources Write Setresources;
  end;
  TRestResourceClass = Class of TRestResource;
  
  { --------------------------------------------------------------------
    TApisResource
    --------------------------------------------------------------------}
  
  
  //Optional query Options for TApisResource, method List
  
  TApisListOptions = Record
    _name : String;
    preferred : boolean;
  end;
  
  TApisResource = Class(TGoogleResource)
  Public
    Class Function ResourceName : String; override;
    Class Function DefaultAPI : TGoogleAPIClass; override;
    Function GetRest(_api: string; version: string) : TRestDescription;
    Function List(AQuery : string  = '') : TDirectoryList;
    Function List(AQuery : TApislistOptions) : TDirectoryList;
  end;
  
  
  { --------------------------------------------------------------------
    TDiscoveryAPI
    --------------------------------------------------------------------}
  
  TDiscoveryAPI = Class(TGoogleAPI)
  Private
    FApisInstance : TApisResource;
    Function GetApisInstance : TApisResource;virtual;
  Public
    //Override class functions with API info
    Class Function APIName : String; override;
    Class Function APIVersion : String; override;
    Class Function APIRevision : String; override;
    Class Function APIID : String; override;
    Class Function APITitle : String; override;
    Class Function APIDescription : String; override;
    Class Function APIOwnerDomain : String; override;
    Class Function APIOwnerName : String; override;
    Class Function APIIcon16 : String; override;
    Class Function APIIcon32 : String; override;
    Class Function APIdocumentationLink : String; override;
    Class Function APIrootUrl : string; override;
    Class Function APIbasePath : string;override;
    Class Function APIbaseURL : String;override;
    Class Function APIProtocol : string;override;
    Class Function APIservicePath : string;override;
    Class Function APIbatchPath : String;override;
    Class Function APIAuthScopes : TScopeInfoArray;override;
    Class Function APINeedsAuth : Boolean;override;
    Class Procedure RegisterAPIResources; override;
    //Add create function for resources
    Function CreateApisResource(AOwner : TComponent) : TApisResource;virtual;overload;
    Function CreateApisResource : TApisResource;virtual;overload;
    //Add default on-demand instances for resources
    Property ApisResource : TApisResource Read GetApisInstance;
  end;

implementation


{ --------------------------------------------------------------------
  TDirectoryListTypeitemsItemTypeicons
  --------------------------------------------------------------------}


Procedure TDirectoryListTypeitemsItemTypeicons.Setx16(AIndex : Integer; const AValue : String); 

begin
  If (Fx16=AValue) then exit;
  Fx16:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItemTypeicons.Setx32(AIndex : Integer; const AValue : String); 

begin
  If (Fx32=AValue) then exit;
  Fx32:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TDirectoryListTypeitemsItem
  --------------------------------------------------------------------}


Procedure TDirectoryListTypeitemsItem.Setdescription(AIndex : Integer; const AValue : String); 

begin
  If (Fdescription=AValue) then exit;
  Fdescription:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.SetdiscoveryLink(AIndex : Integer; const AValue : String); 

begin
  If (FdiscoveryLink=AValue) then exit;
  FdiscoveryLink:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.SetdiscoveryRestUrl(AIndex : Integer; const AValue : String); 

begin
  If (FdiscoveryRestUrl=AValue) then exit;
  FdiscoveryRestUrl:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.SetdocumentationLink(AIndex : Integer; const AValue : String); 

begin
  If (FdocumentationLink=AValue) then exit;
  FdocumentationLink:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Seticons(AIndex : Integer; const AValue : TDirectoryListTypeitemsItemTypeicons); 

begin
  If (Ficons=AValue) then exit;
  Ficons:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Setid(AIndex : Integer; const AValue : String); 

begin
  If (Fid=AValue) then exit;
  Fid:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Setkind(AIndex : Integer; const AValue : String); 

begin
  If (Fkind=AValue) then exit;
  Fkind:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Setlabels(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Flabels=AValue) then exit;
  Flabels:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Setname(AIndex : Integer; const AValue : String); 

begin
  If (Fname=AValue) then exit;
  Fname:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Setpreferred(AIndex : Integer; const AValue : boolean); 

begin
  If (Fpreferred=AValue) then exit;
  Fpreferred:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Settitle(AIndex : Integer; const AValue : String); 

begin
  If (Ftitle=AValue) then exit;
  Ftitle:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryListTypeitemsItem.Setversion(AIndex : Integer; const AValue : String); 

begin
  If (Fversion=AValue) then exit;
  Fversion:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TDirectoryListTypeitemsItem.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'labels' : SetLength(Flabels,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TDirectoryList
  --------------------------------------------------------------------}


Procedure TDirectoryList.SetdiscoveryVersion(AIndex : Integer; const AValue : String); 

begin
  If (FdiscoveryVersion=AValue) then exit;
  FdiscoveryVersion:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryList.Setitems(AIndex : Integer; const AValue : TDirectoryListTypeitemsArray); 

begin
  If (Fitems=AValue) then exit;
  Fitems:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TDirectoryList.Setkind(AIndex : Integer; const AValue : String); 

begin
  If (Fkind=AValue) then exit;
  Fkind:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TDirectoryList.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'items' : SetLength(Fitems,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TJsonSchemaTypeannotations
  --------------------------------------------------------------------}


Procedure TJsonSchemaTypeannotations.Setrequired(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Frequired=AValue) then exit;
  Frequired:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TJsonSchemaTypeannotations.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'required' : SetLength(Frequired,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TJsonSchemaTypeproperties
  --------------------------------------------------------------------}


Class Function TJsonSchemaTypeproperties.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TJsonSchemaTypevariantTypemapItem
  --------------------------------------------------------------------}


Procedure TJsonSchemaTypevariantTypemapItem.Setref(AIndex : Integer; const AValue : String); 

begin
  If (Fref=AValue) then exit;
  Fref:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchemaTypevariantTypemapItem.Settype_value(AIndex : Integer; const AValue : String); 

begin
  If (Ftype_value=AValue) then exit;
  Ftype_value:=AValue;
  MarkPropertyChanged(AIndex);
end;



Class Function TJsonSchemaTypevariantTypemapItem.ExportPropertyName(Const AName : String) :String;

begin
  Case AName of
  'ref' : Result:='$ref';
  else
    Result:=Inherited ExportPropertyName(AName);
  end;
end;




{ --------------------------------------------------------------------
  TJsonSchemaTypevariant
  --------------------------------------------------------------------}


Procedure TJsonSchemaTypevariant.Setdiscriminant(AIndex : Integer; const AValue : String); 

begin
  If (Fdiscriminant=AValue) then exit;
  Fdiscriminant:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchemaTypevariant.Setmap(AIndex : Integer; const AValue : TJsonSchemaTypevariantTypemapArray); 

begin
  If (Fmap=AValue) then exit;
  Fmap:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TJsonSchemaTypevariant.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'map' : SetLength(Fmap,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TJsonSchema
  --------------------------------------------------------------------}


Procedure TJsonSchema.Setref(AIndex : Integer; const AValue : String); 

begin
  If (Fref=AValue) then exit;
  Fref:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.SetadditionalProperties(AIndex : Integer; const AValue : TJsonSchema); 

begin
  If (FadditionalProperties=AValue) then exit;
  FadditionalProperties:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setannotations(AIndex : Integer; const AValue : TJsonSchemaTypeannotations); 

begin
  If (Fannotations=AValue) then exit;
  Fannotations:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setdefault(AIndex : Integer; const AValue : String); 

begin
  If (Fdefault=AValue) then exit;
  Fdefault:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setdescription(AIndex : Integer; const AValue : String); 

begin
  If (Fdescription=AValue) then exit;
  Fdescription:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setenum(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Fenum=AValue) then exit;
  Fenum:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.SetenumDescriptions(AIndex : Integer; const AValue : TStringArray); 

begin
  If (FenumDescriptions=AValue) then exit;
  FenumDescriptions:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setformat(AIndex : Integer; const AValue : String); 

begin
  If (Fformat=AValue) then exit;
  Fformat:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setid(AIndex : Integer; const AValue : String); 

begin
  If (Fid=AValue) then exit;
  Fid:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setitems(AIndex : Integer; const AValue : TJsonSchema); 

begin
  If (Fitems=AValue) then exit;
  Fitems:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setlocation(AIndex : Integer; const AValue : String); 

begin
  If (Flocation=AValue) then exit;
  Flocation:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setmaximum(AIndex : Integer; const AValue : String); 

begin
  If (Fmaximum=AValue) then exit;
  Fmaximum:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setminimum(AIndex : Integer; const AValue : String); 

begin
  If (Fminimum=AValue) then exit;
  Fminimum:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setpattern(AIndex : Integer; const AValue : String); 

begin
  If (Fpattern=AValue) then exit;
  Fpattern:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setproperties(AIndex : Integer; const AValue : TJsonSchemaTypeproperties); 

begin
  If (Fproperties=AValue) then exit;
  Fproperties:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.SetreadOnly(AIndex : Integer; const AValue : boolean); 

begin
  If (FreadOnly=AValue) then exit;
  FreadOnly:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setrepeated(AIndex : Integer; const AValue : boolean); 

begin
  If (Frepeated=AValue) then exit;
  Frepeated:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setrequired(AIndex : Integer; const AValue : boolean); 

begin
  If (Frequired=AValue) then exit;
  Frequired:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Set_type(AIndex : Integer; const AValue : String); 

begin
  If (F_type=AValue) then exit;
  F_type:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TJsonSchema.Setvariant(AIndex : Integer; const AValue : TJsonSchemaTypevariant); 

begin
  If (Fvariant=AValue) then exit;
  Fvariant:=AValue;
  MarkPropertyChanged(AIndex);
end;



Class Function TJsonSchema.ExportPropertyName(Const AName : String) :String;

begin
  Case AName of
  'ref' : Result:='$ref';
  '_type' : Result:='type';
  else
    Result:=Inherited ExportPropertyName(AName);
  end;
end;

//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TJsonSchema.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'enum' : SetLength(Fenum,ALength);
  'enumdescriptions' : SetLength(FenumDescriptions,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TRestDescriptionTypeauthTypeoauth2Typescopes
  --------------------------------------------------------------------}


Class Function TRestDescriptionTypeauthTypeoauth2Typescopes.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestDescriptionTypeauthTypeoauth2
  --------------------------------------------------------------------}


Procedure TRestDescriptionTypeauthTypeoauth2.Setscopes(AIndex : Integer; const AValue : TRestDescriptionTypeauthTypeoauth2Typescopes); 

begin
  If (Fscopes=AValue) then exit;
  Fscopes:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TRestDescriptionTypeauth
  --------------------------------------------------------------------}


Procedure TRestDescriptionTypeauth.Setoauth2(AIndex : Integer; const AValue : TRestDescriptionTypeauthTypeoauth2); 

begin
  If (Foauth2=AValue) then exit;
  Foauth2:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TRestDescriptionTypeicons
  --------------------------------------------------------------------}


Procedure TRestDescriptionTypeicons.Setx16(AIndex : Integer; const AValue : String); 

begin
  If (Fx16=AValue) then exit;
  Fx16:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescriptionTypeicons.Setx32(AIndex : Integer; const AValue : String); 

begin
  If (Fx32=AValue) then exit;
  Fx32:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TRestDescriptionTypemethods
  --------------------------------------------------------------------}


Class Function TRestDescriptionTypemethods.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestDescriptionTypeparameters
  --------------------------------------------------------------------}


Class Function TRestDescriptionTypeparameters.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestDescriptionTyperesources
  --------------------------------------------------------------------}


Class Function TRestDescriptionTyperesources.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestDescriptionTypeschemas
  --------------------------------------------------------------------}


Class Function TRestDescriptionTypeschemas.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestDescription
  --------------------------------------------------------------------}


Procedure TRestDescription.Setauth(AIndex : Integer; const AValue : TRestDescriptionTypeauth); 

begin
  If (Fauth=AValue) then exit;
  Fauth:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetbasePath(AIndex : Integer; const AValue : String); 

begin
  If (FbasePath=AValue) then exit;
  FbasePath:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetbaseUrl(AIndex : Integer; const AValue : String); 

begin
  If (FbaseUrl=AValue) then exit;
  FbaseUrl:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetbatchPath(AIndex : Integer; const AValue : String); 

begin
  If (FbatchPath=AValue) then exit;
  FbatchPath:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetcanonicalName(AIndex : Integer; const AValue : String); 

begin
  If (FcanonicalName=AValue) then exit;
  FcanonicalName:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setdescription(AIndex : Integer; const AValue : String); 

begin
  If (Fdescription=AValue) then exit;
  Fdescription:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetdiscoveryVersion(AIndex : Integer; const AValue : String); 

begin
  If (FdiscoveryVersion=AValue) then exit;
  FdiscoveryVersion:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetdocumentationLink(AIndex : Integer; const AValue : String); 

begin
  If (FdocumentationLink=AValue) then exit;
  FdocumentationLink:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setetag(AIndex : Integer; const AValue : String); 

begin
  If (Fetag=AValue) then exit;
  Fetag:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetexponentialBackoffDefault(AIndex : Integer; const AValue : boolean); 

begin
  If (FexponentialBackoffDefault=AValue) then exit;
  FexponentialBackoffDefault:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setfeatures(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Ffeatures=AValue) then exit;
  Ffeatures:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Seticons(AIndex : Integer; const AValue : TRestDescriptionTypeicons); 

begin
  If (Ficons=AValue) then exit;
  Ficons:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setid(AIndex : Integer; const AValue : String); 

begin
  If (Fid=AValue) then exit;
  Fid:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setkind(AIndex : Integer; const AValue : String); 

begin
  If (Fkind=AValue) then exit;
  Fkind:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setlabels(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Flabels=AValue) then exit;
  Flabels:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setmethods(AIndex : Integer; const AValue : TRestDescriptionTypemethods); 

begin
  If (Fmethods=AValue) then exit;
  Fmethods:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setname(AIndex : Integer; const AValue : String); 

begin
  If (Fname=AValue) then exit;
  Fname:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetownerDomain(AIndex : Integer; const AValue : String); 

begin
  If (FownerDomain=AValue) then exit;
  FownerDomain:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetownerName(AIndex : Integer; const AValue : String); 

begin
  If (FownerName=AValue) then exit;
  FownerName:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetpackagePath(AIndex : Integer; const AValue : String); 

begin
  If (FpackagePath=AValue) then exit;
  FpackagePath:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setparameters(AIndex : Integer; const AValue : TRestDescriptionTypeparameters); 

begin
  If (Fparameters=AValue) then exit;
  Fparameters:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setprotocol(AIndex : Integer; const AValue : String); 

begin
  If (Fprotocol=AValue) then exit;
  Fprotocol:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setresources(AIndex : Integer; const AValue : TRestDescriptionTyperesources); 

begin
  If (Fresources=AValue) then exit;
  Fresources:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setrevision(AIndex : Integer; const AValue : String); 

begin
  If (Frevision=AValue) then exit;
  Frevision:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetrootUrl(AIndex : Integer; const AValue : String); 

begin
  If (FrootUrl=AValue) then exit;
  FrootUrl:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setschemas(AIndex : Integer; const AValue : TRestDescriptionTypeschemas); 

begin
  If (Fschemas=AValue) then exit;
  Fschemas:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.SetservicePath(AIndex : Integer; const AValue : String); 

begin
  If (FservicePath=AValue) then exit;
  FservicePath:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Settitle(AIndex : Integer; const AValue : String); 

begin
  If (Ftitle=AValue) then exit;
  Ftitle:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setversion(AIndex : Integer; const AValue : String); 

begin
  If (Fversion=AValue) then exit;
  Fversion:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestDescription.Setversion_module(AIndex : Integer; const AValue : boolean); 

begin
  If (Fversion_module=AValue) then exit;
  Fversion_module:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TRestDescription.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'features' : SetLength(Ffeatures,ALength);
  'labels' : SetLength(Flabels,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TRestMethodTypemediaUploadTypeprotocolsTyperesumable
  --------------------------------------------------------------------}


Procedure TRestMethodTypemediaUploadTypeprotocolsTyperesumable.Setmultipart(AIndex : Integer; const AValue : boolean); 

begin
  If (Fmultipart=AValue) then exit;
  Fmultipart:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethodTypemediaUploadTypeprotocolsTyperesumable.Setpath(AIndex : Integer; const AValue : String); 

begin
  If (Fpath=AValue) then exit;
  Fpath:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TRestMethodTypemediaUploadTypeprotocolsTypesimple
  --------------------------------------------------------------------}


Procedure TRestMethodTypemediaUploadTypeprotocolsTypesimple.Setmultipart(AIndex : Integer; const AValue : boolean); 

begin
  If (Fmultipart=AValue) then exit;
  Fmultipart:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethodTypemediaUploadTypeprotocolsTypesimple.Setpath(AIndex : Integer; const AValue : String); 

begin
  If (Fpath=AValue) then exit;
  Fpath:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TRestMethodTypemediaUploadTypeprotocols
  --------------------------------------------------------------------}


Procedure TRestMethodTypemediaUploadTypeprotocols.Setresumable(AIndex : Integer; const AValue : TRestMethodTypemediaUploadTypeprotocolsTyperesumable); 

begin
  If (Fresumable=AValue) then exit;
  Fresumable:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethodTypemediaUploadTypeprotocols.Setsimple(AIndex : Integer; const AValue : TRestMethodTypemediaUploadTypeprotocolsTypesimple); 

begin
  If (Fsimple=AValue) then exit;
  Fsimple:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TRestMethodTypemediaUpload
  --------------------------------------------------------------------}


Procedure TRestMethodTypemediaUpload.Setaccept(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Faccept=AValue) then exit;
  Faccept:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethodTypemediaUpload.SetmaxSize(AIndex : Integer; const AValue : String); 

begin
  If (FmaxSize=AValue) then exit;
  FmaxSize:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethodTypemediaUpload.Setprotocols(AIndex : Integer; const AValue : TRestMethodTypemediaUploadTypeprotocols); 

begin
  If (Fprotocols=AValue) then exit;
  Fprotocols:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TRestMethodTypemediaUpload.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'accept' : SetLength(Faccept,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TRestMethodTypeparameters
  --------------------------------------------------------------------}


Class Function TRestMethodTypeparameters.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestMethodTyperequest
  --------------------------------------------------------------------}


Procedure TRestMethodTyperequest.Setref(AIndex : Integer; const AValue : String); 

begin
  If (Fref=AValue) then exit;
  Fref:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethodTyperequest.SetparameterName(AIndex : Integer; const AValue : String); 

begin
  If (FparameterName=AValue) then exit;
  FparameterName:=AValue;
  MarkPropertyChanged(AIndex);
end;



Class Function TRestMethodTyperequest.ExportPropertyName(Const AName : String) :String;

begin
  Case AName of
  'ref' : Result:='$ref';
  else
    Result:=Inherited ExportPropertyName(AName);
  end;
end;




{ --------------------------------------------------------------------
  TRestMethodTyperesponse
  --------------------------------------------------------------------}


Procedure TRestMethodTyperesponse.Setref(AIndex : Integer; const AValue : String); 

begin
  If (Fref=AValue) then exit;
  Fref:=AValue;
  MarkPropertyChanged(AIndex);
end;



Class Function TRestMethodTyperesponse.ExportPropertyName(Const AName : String) :String;

begin
  Case AName of
  'ref' : Result:='$ref';
  else
    Result:=Inherited ExportPropertyName(AName);
  end;
end;




{ --------------------------------------------------------------------
  TRestMethod
  --------------------------------------------------------------------}


Procedure TRestMethod.Setdescription(AIndex : Integer; const AValue : String); 

begin
  If (Fdescription=AValue) then exit;
  Fdescription:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetetagRequired(AIndex : Integer; const AValue : boolean); 

begin
  If (FetagRequired=AValue) then exit;
  FetagRequired:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SethttpMethod(AIndex : Integer; const AValue : String); 

begin
  If (FhttpMethod=AValue) then exit;
  FhttpMethod:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.Setid(AIndex : Integer; const AValue : String); 

begin
  If (Fid=AValue) then exit;
  Fid:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetmediaUpload(AIndex : Integer; const AValue : TRestMethodTypemediaUpload); 

begin
  If (FmediaUpload=AValue) then exit;
  FmediaUpload:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetparameterOrder(AIndex : Integer; const AValue : TStringArray); 

begin
  If (FparameterOrder=AValue) then exit;
  FparameterOrder:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.Setparameters(AIndex : Integer; const AValue : TRestMethodTypeparameters); 

begin
  If (Fparameters=AValue) then exit;
  Fparameters:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.Setpath(AIndex : Integer; const AValue : String); 

begin
  If (Fpath=AValue) then exit;
  Fpath:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.Setrequest(AIndex : Integer; const AValue : TRestMethodTyperequest); 

begin
  If (Frequest=AValue) then exit;
  Frequest:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.Setresponse(AIndex : Integer; const AValue : TRestMethodTyperesponse); 

begin
  If (Fresponse=AValue) then exit;
  Fresponse:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.Setscopes(AIndex : Integer; const AValue : TStringArray); 

begin
  If (Fscopes=AValue) then exit;
  Fscopes:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetsupportsMediaDownload(AIndex : Integer; const AValue : boolean); 

begin
  If (FsupportsMediaDownload=AValue) then exit;
  FsupportsMediaDownload:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetsupportsMediaUpload(AIndex : Integer; const AValue : boolean); 

begin
  If (FsupportsMediaUpload=AValue) then exit;
  FsupportsMediaUpload:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetsupportsSubscription(AIndex : Integer; const AValue : boolean); 

begin
  If (FsupportsSubscription=AValue) then exit;
  FsupportsSubscription:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestMethod.SetuseMediaDownloadService(AIndex : Integer; const AValue : boolean); 

begin
  If (FuseMediaDownloadService=AValue) then exit;
  FuseMediaDownloadService:=AValue;
  MarkPropertyChanged(AIndex);
end;


//2.6.4. bug workaround
{$IFDEF VER2_6}
Procedure TRestMethod.SetArrayLength(Const AName : String; ALength : Longint); 

begin
  Case AName of
  'parameterorder' : SetLength(FparameterOrder,ALength);
  'scopes' : SetLength(Fscopes,ALength);
  else
    Inherited SetArrayLength(AName,ALength);
  end;
end;
{$ENDIF VER2_6}




{ --------------------------------------------------------------------
  TRestResourceTypemethods
  --------------------------------------------------------------------}


Class Function TRestResourceTypemethods.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestResourceTyperesources
  --------------------------------------------------------------------}


Class Function TRestResourceTyperesources.AllowAdditionalProperties : Boolean;

begin
  Result:=True;
end;



{ --------------------------------------------------------------------
  TRestResource
  --------------------------------------------------------------------}


Procedure TRestResource.Setmethods(AIndex : Integer; const AValue : TRestResourceTypemethods); 

begin
  If (Fmethods=AValue) then exit;
  Fmethods:=AValue;
  MarkPropertyChanged(AIndex);
end;



Procedure TRestResource.Setresources(AIndex : Integer; const AValue : TRestResourceTyperesources); 

begin
  If (Fresources=AValue) then exit;
  Fresources:=AValue;
  MarkPropertyChanged(AIndex);
end;





{ --------------------------------------------------------------------
  TApisResource
  --------------------------------------------------------------------}


Class Function TApisResource.ResourceName : String;

begin
  Result:='apis';
end;

Class Function TApisResource.DefaultAPI : TGoogleAPIClass;

begin
  Result:=TdiscoveryAPI;
end;

Function TApisResource.GetRest(_api: string; version: string) : TRestDescription;

Const
  _HTTPMethod = 'GET';
  _Path       = 'apis/{api}/{version}/rest';
  _Methodid   = 'discovery.apis.getRest';

Var
  _P : String;

begin
  _P:=SubstitutePath(_Path,['api',_api,'version',version]);
  Result:=ServiceCall(_HTTPMethod,_P,'',Nil,TRestDescription) as TRestDescription;
end;

Function TApisResource.List(AQuery : string = '') : TDirectoryList;

Const
  _HTTPMethod = 'GET';
  _Path       = 'apis';
  _Methodid   = 'discovery.apis.list';

begin
  Result:=ServiceCall(_HTTPMethod,_Path,AQuery,Nil,TDirectoryList) as TDirectoryList;
end;


Function TApisResource.List(AQuery : TApislistOptions) : TDirectoryList;

Var
  _Q : String;

begin
  _Q:='';
  AddToQuery(_Q,'name',AQuery._name);
  AddToQuery(_Q,'preferred',AQuery.preferred);
  Result:=List(_Q);
end;



{ --------------------------------------------------------------------
  TDiscoveryAPI
  --------------------------------------------------------------------}

Class Function TDiscoveryAPI.APIName : String;

begin
  Result:='discovery';
end;

Class Function TDiscoveryAPI.APIVersion : String;

begin
  Result:='v1';
end;

Class Function TDiscoveryAPI.APIRevision : String;

begin
  Result:='';
end;

Class Function TDiscoveryAPI.APIID : String;

begin
  Result:='discovery:v1';
end;

Class Function TDiscoveryAPI.APITitle : String;

begin
  Result:='APIs Discovery Service';
end;

Class Function TDiscoveryAPI.APIDescription : String;

begin
  Result:='Provides information about other Google APIs, such as what APIs are available, the resource, and method details for each API.';
end;

Class Function TDiscoveryAPI.APIOwnerDomain : String;

begin
  Result:='google.com';
end;

Class Function TDiscoveryAPI.APIOwnerName : String;

begin
  Result:='Google';
end;

Class Function TDiscoveryAPI.APIIcon16 : String;

begin
  Result:='http://www.google.com/images/icons/feature/filing_cabinet_search-g16.png';
end;

Class Function TDiscoveryAPI.APIIcon32 : String;

begin
  Result:='http://www.google.com/images/icons/feature/filing_cabinet_search-g32.png';
end;

Class Function TDiscoveryAPI.APIdocumentationLink : String;

begin
  Result:='https://developers.google.com/discovery/';
end;

Class Function TDiscoveryAPI.APIrootUrl : string;

begin
  Result:='https://www.googleapis.com/';
end;

Class Function TDiscoveryAPI.APIbasePath : string;

begin
  Result:='/discovery/v1/';
end;

Class Function TDiscoveryAPI.APIbaseURL : String;

begin
  Result:='https://www.googleapis.com/discovery/v1/';
end;

Class Function TDiscoveryAPI.APIProtocol : string;

begin
  Result:='rest';
end;

Class Function TDiscoveryAPI.APIservicePath : string;

begin
  Result:='discovery/v1/';
end;

Class Function TDiscoveryAPI.APIbatchPath : String;

begin
  Result:='batch';
end;

Class Function TDiscoveryAPI.APIAuthScopes : TScopeInfoArray;

begin
  SetLength(Result,0);
  
end;

Class Function TDiscoveryAPI.APINeedsAuth : Boolean;

begin
  Result:=False;
end;

Class Procedure TDiscoveryAPI.RegisterAPIResources;

begin
  TDirectoryListTypeitemsItemTypeicons.RegisterObject;
  TDirectoryListTypeitemsItem.RegisterObject;
  TDirectoryList.RegisterObject;
  TJsonSchemaTypeannotations.RegisterObject;
  TJsonSchemaTypeproperties.RegisterObject;
  TJsonSchemaTypevariantTypemapItem.RegisterObject;
  TJsonSchemaTypevariant.RegisterObject;
  TJsonSchema.RegisterObject;
  TRestDescriptionTypeauthTypeoauth2Typescopes.RegisterObject;
  TRestDescriptionTypeauthTypeoauth2.RegisterObject;
  TRestDescriptionTypeauth.RegisterObject;
  TRestDescriptionTypeicons.RegisterObject;
  TRestDescriptionTypemethods.RegisterObject;
  TRestDescriptionTypeparameters.RegisterObject;
  TRestDescriptionTyperesources.RegisterObject;
  TRestDescriptionTypeschemas.RegisterObject;
  TRestDescription.RegisterObject;
  TRestMethodTypemediaUploadTypeprotocolsTyperesumable.RegisterObject;
  TRestMethodTypemediaUploadTypeprotocolsTypesimple.RegisterObject;
  TRestMethodTypemediaUploadTypeprotocols.RegisterObject;
  TRestMethodTypemediaUpload.RegisterObject;
  TRestMethodTypeparameters.RegisterObject;
  TRestMethodTyperequest.RegisterObject;
  TRestMethodTyperesponse.RegisterObject;
  TRestMethod.RegisterObject;
  TRestResourceTypemethods.RegisterObject;
  TRestResourceTyperesources.RegisterObject;
  TRestResource.RegisterObject;
end;


Function TDiscoveryAPI.GetApisInstance : TApisResource;

begin
  if (FApisInstance=Nil) then
    FApisInstance:=CreateApisResource;
  Result:=FApisInstance;
end;

Function TDiscoveryAPI.CreateApisResource : TApisResource;

begin
  Result:=CreateApisResource(Self);
end;


Function TDiscoveryAPI.CreateApisResource(AOwner : TComponent) : TApisResource;

begin
  Result:=TApisResource.Create(AOwner);
  Result.API:=Self.API;
end;



initialization
  TDiscoveryAPI.RegisterAPI;
end.
