{
    This file is part of the Free Component Library
    Copyright (c) 2024 by Michael Van Canneyt michael@freepascal.org

    FCM Messaging demo - web client : RPC client definition.
    This file is automatically generated by the RPC Client context menu in Lazarus.

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

Unit service.messagingserver;

{$MODE ObjFPC}
{$H+}

interface

uses js, fprpcclient;

Type
  
  { --------------------------------------------------------------------
    TMessagingService
    --------------------------------------------------------------------}
  
  TMessagingService = Class(TRPCCustomService)
  Protected
    Function RPCClassName : string; override;
  Public
    Function SendNotification (Message : TJSObject; aOnSuccess : TJSValueResultHandler = Nil; aOnFailure : TRPCFailureCallBack = Nil) : NativeInt;
    Function RegisterSubscription (Token : String; aOnSuccess : TJSValueResultHandler = Nil; aOnFailure : TRPCFailureCallBack = Nil) : NativeInt;
  end;
  
  implementation
  
  
  { --------------------------------------------------------------------
    TMessagingService
    --------------------------------------------------------------------}
  
  
  Function TMessagingService.RPCClassName : string;
  
  begin
    Result:='Messaging';
  end;
  
  
  Function TMessagingService.SendNotification (Message : TJSObject; aOnSuccess : TJSValueResultHandler = Nil; aOnFailure : TRPCFailureCallBack = Nil) : NativeInt;
  
    Procedure DoSuccess(Sender : TObject; const aResult : JSValue);
    
    begin
      If Assigned(aOnSuccess) then
        aOnSuccess(JSValue(aResult))
    end;
  
  Var
    _Params : JSValue;
  
  begin
    StartParams;
    AddParam('Message',Message);
    _Params:=EndParams;
    Result:=ExecuteRequest(RPCClassName,'SendNotification',_Params,@DoSuccess,aOnFailure);
  end;
  
  
  Function TMessagingService.RegisterSubscription (Token : String; aOnSuccess : TJSValueResultHandler = Nil; aOnFailure : TRPCFailureCallBack = Nil) : NativeInt;
  
    Procedure DoSuccess(Sender : TObject; const aResult : JSValue);
    
    begin
      If Assigned(aOnSuccess) then
        aOnSuccess(JSValue(aResult))
    end;
  
  Var
    _Params : JSValue;
  
  begin
    StartParams;
    AddParam('Token',Token);
    _Params:=EndParams;
    Result:=ExecuteRequest(RPCClassName,'RegisterSubscription',_Params,@DoSuccess,aOnFailure);
  end;
  
  
  
  
  end.
