
(* lexical analyzer template (TP Lex V3.0), V1.0 3-2-91 AG *)

(* global definitions: *)
var
  kwtmp: integer;

const
  KeywordDefs: array [0..33] of TIdentMapEntry = (
    // attribs
    (Value: _LANGUAGE;             Name: 'LANGUAGE'),
    (Value: _CHARACTERISTICS;      Name: 'CHARACTERISTICS'),
    (Value: _VERSION;              Name: 'VERSION'),
    (Value: _MOVEABLE;             Name: 'MOVEABLE'),
    (Value: _FIXED;                Name: 'FIXED'),
    (Value: _PURE;                 Name: 'PURE'),
    (Value: _IMPURE;               Name: 'IMPURE'),
    (Value: _PRELOAD;              Name: 'PRELOAD'),
    (Value: _LOADONCALL;           Name: 'LOADONCALL'),
    (Value: _DISCARDABLE;          Name: 'DISCARDABLE'),
    // resource names
    (Value: _ANICURSOR;            Name: 'ANICURSOR'),
    (Value: _ANIICON;              Name: 'ANIICON'),
    (Value: _BITMAP;               Name: 'BITMAP'),
    (Value: _CURSOR;               Name: 'CURSOR'),
    (Value: _DLGINCLUDE;           Name: 'DLGINCLUDE'),
    (Value: _DLGINIT;              Name: 'DLGINIT'),
    (Value: _HTML;                 Name: 'HTML'),
    (Value: _ICON;                 Name: 'ICON'),
    (Value: _MANIFEST;             Name: 'MANIFEST'),
    (Value: _MESSAGETABLE;         Name: 'MESSAGETABLE'),
    (Value: _PLUGPLAY;             Name: 'PLUGPLAY'),
    (Value: _STRINGTABLE;          Name: 'STRINGTABLE'),
    (Value: _RCDATA;               Name: 'RCDATA'),
    (Value: _VERSIONINFO;          Name: 'VERSIONINFO'),
    (Value: _VXD;                  Name: 'VXD'),
    // file version fields names
    (Value: _FILEVERSION;          Name: 'FILEVERSION'),
    (Value: _PRODUCTVERSION;       Name: 'PRODUCTVERSION'),
    (Value: _FILEFLAGSMASK;        Name: 'FILEFLAGSMASK'),
    (Value: _FILEFLAGS;            Name: 'FILEFLAGS'),
    (Value: _FILEOS;               Name: 'FILEOS'),
    (Value: _FILETYPE;             Name: 'FILETYPE'),
    (Value: _FILESUBTYPE;          Name: 'FILESUBTYPE'),
    (Value: _BLOCK;                Name: 'BLOCK'),
    (Value: _VALUE;                Name: 'VALUE')
  );

function KeywordToInt(k: string; out kw: integer): boolean;
var
  i: integer;
begin
  Result:= False;
  for i:= low(KeywordDefs) to high(KeywordDefs) do begin
    if k = KeywordDefs[i].Name then begin
      kw:= KeywordDefs[i].Value;
      Exit(True);
    end;
  end;
end;

const INCOMLINE = 2;
const INCOMMENT = 4;
const INSTRING = 6;
const INSTRINGL = 8;



function yylex : Integer;

procedure yyaction ( yyruleno : Integer );
  (* local definitions: *)

begin
  (* actions: *)
  case yyruleno of
  1:
                        start(INCOMLINE);
  2:
                        begin start(0); unget_char(nl); end;
  3:
                        yymore;

  4:
                        start(INCOMMENT);
  5:
                        ;
  6:
                        start(0);
  7:
                        return(_ILLEGAL);

  8:
                        return(_NUMBER);
  9:
                        return(_NUMBER);
  10:
                        return(_NUMBER);
  11:
                                  begin start(INSTRINGL); strbuf_begin(); end;
  12:
                                  begin start(INSTRING); strbuf_begin(); end;
  13:
                                  strbuf_append('"');
  14:
                                  begin
                                    start(0);
                                    return(_QUOTEDSTR);
                                  end;
  15:
                                  begin
                                    start(0);
                                    return(_QUOTEDSTRL);
                                  end;
  16:
                                  ;
  17:
                                  return(_ILLEGAL);
  18:
                                  strbuf_append(yytext);
  19:
                        begin yytext:= 'StringFileInfo'; return(_STR_StringFileInfo); end;
  20:
                        begin yytext:= 'VarFileInfo'; return(_STR_VarFileInfo); end;
  21:
                        begin yytext:= 'Translation'; return(_STR_Translation); end;

  22:
                        return(_BEGIN);
  23:
                        return(_END);
  24:
                        begin
                          if ypreproc.isdefine(yytext) then begin
                            unget_char(' ');
                            unget_string(ypreproc.getdefine(yytext));
                          end else
                            if KeywordToInt(yytext, kwtmp) then
                              return(kwtmp)
                            else
                              return(_ID);
                         end;
  25:
                  return(_NSWPSTR);
  26:
                        ;
  27:
                        returnc(yytext[1]);
  28:
                        return(_ILLEGAL);
  end;
end(*yyaction*);

(* DFA table: *)

type YYTRec = record
                cc : set of AnsiChar;
                s  : Integer;
              end;

const

yynmarks   = 88;
yynmatches = 88;
yyntrans   = 156;
yynstates  = 96;

yyk : array [1..yynmarks] of Integer = (
  { 0: }
  25,
  { 1: }
  25,
  { 2: }
  { 3: }
  { 4: }
  { 5: }
  { 6: }
  { 7: }
  { 8: }
  { 9: }
  { 10: }
  27,
  28,
  { 11: }
  8,
  25,
  28,
  { 12: }
  8,
  25,
  28,
  { 13: }
  24,
  25,
  28,
  { 14: }
  12,
  28,
  { 15: }
  24,
  25,
  28,
  { 16: }
  22,
  28,
  { 17: }
  24,
  25,
  28,
  { 18: }
  23,
  28,
  { 19: }
  24,
  25,
  28,
  { 20: }
  25,
  28,
  { 21: }
  26,
  { 22: }
  27,
  28,
  { 23: }
  26,
  28,
  { 24: }
  28,
  { 25: }
  2,
  { 26: }
  3,
  { 27: }
  5,
  { 28: }
  5,
  { 29: }
  7,
  { 30: }
  14,
  18,
  { 31: }
  18,
  { 32: }
  17,
  { 33: }
  18,
  { 34: }
  15,
  18,
  { 35: }
  1,
  { 36: }
  4,
  { 37: }
  8,
  25,
  { 38: }
  8,
  25,
  { 39: }
  25,
  { 40: }
  25,
  { 41: }
  25,
  { 42: }
  11,
  { 43: }
  24,
  25,
  { 44: }
  { 45: }
  { 46: }
  { 47: }
  24,
  25,
  { 48: }
  24,
  25,
  { 49: }
  6,
  { 50: }
  13,
  { 51: }
  16,
  { 52: }
  9,
  25,
  { 53: }
  10,
  25,
  { 54: }
  { 55: }
  { 56: }
  { 57: }
  24,
  25,
  { 58: }
  23,
  24,
  25,
  { 59: }
  9,
  25,
  { 60: }
  10,
  25,
  { 61: }
  { 62: }
  { 63: }
  { 64: }
  24,
  25,
  { 65: }
  { 66: }
  { 67: }
  { 68: }
  22,
  24,
  25,
  { 69: }
  { 70: }
  { 71: }
  { 72: }
  { 73: }
  { 74: }
  { 75: }
  { 76: }
  { 77: }
  { 78: }
  { 79: }
  { 80: }
  { 81: }
  { 82: }
  { 83: }
  { 84: }
  { 85: }
  { 86: }
  { 87: }
  { 88: }
  { 89: }
  { 90: }
  { 91: }
  20,
  { 92: }
  21,
  { 93: }
  { 94: }
  { 95: }
  19
);

yym : array [1..yynmatches] of Integer = (
{ 0: }
  25,
{ 1: }
  25,
{ 2: }
{ 3: }
{ 4: }
{ 5: }
{ 6: }
{ 7: }
{ 8: }
{ 9: }
{ 10: }
  27,
  28,
{ 11: }
  8,
  25,
  28,
{ 12: }
  8,
  25,
  28,
{ 13: }
  24,
  25,
  28,
{ 14: }
  12,
  28,
{ 15: }
  24,
  25,
  28,
{ 16: }
  22,
  28,
{ 17: }
  24,
  25,
  28,
{ 18: }
  23,
  28,
{ 19: }
  24,
  25,
  28,
{ 20: }
  25,
  28,
{ 21: }
  26,
{ 22: }
  27,
  28,
{ 23: }
  26,
  28,
{ 24: }
  28,
{ 25: }
  2,
{ 26: }
  3,
{ 27: }
  5,
{ 28: }
  5,
{ 29: }
  7,
{ 30: }
  14,
  18,
{ 31: }
  18,
{ 32: }
  17,
{ 33: }
  18,
{ 34: }
  15,
  18,
{ 35: }
  1,
{ 36: }
  4,
{ 37: }
  8,
  25,
{ 38: }
  8,
  25,
{ 39: }
  25,
{ 40: }
  25,
{ 41: }
  25,
{ 42: }
  11,
{ 43: }
  24,
  25,
{ 44: }
{ 45: }
{ 46: }
{ 47: }
  24,
  25,
{ 48: }
  24,
  25,
{ 49: }
  6,
{ 50: }
  13,
{ 51: }
  16,
{ 52: }
  9,
  25,
{ 53: }
  10,
  25,
{ 54: }
{ 55: }
{ 56: }
{ 57: }
  24,
  25,
{ 58: }
  23,
  24,
  25,
{ 59: }
  9,
  25,
{ 60: }
  10,
  25,
{ 61: }
{ 62: }
{ 63: }
{ 64: }
  24,
  25,
{ 65: }
{ 66: }
{ 67: }
{ 68: }
  22,
  24,
  25,
{ 69: }
{ 70: }
{ 71: }
{ 72: }
{ 73: }
{ 74: }
{ 75: }
{ 76: }
{ 77: }
{ 78: }
{ 79: }
{ 80: }
{ 81: }
{ 82: }
{ 83: }
{ 84: }
{ 85: }
{ 86: }
{ 87: }
{ 88: }
{ 89: }
{ 90: }
{ 91: }
  20,
{ 92: }
  21,
{ 93: }
{ 94: }
{ 95: }
  19
);

yyt : array [1..yyntrans] of YYTrec = (
{ 0: }
  ( cc: [ #1..#8,#11,#13..#31,'!','#','$','''','*','+',
            '-',';'..'@','[',']','`',#127..#255 ]; s: 24),
  ( cc: [ #9,#12,' ' ]; s: 23),
  ( cc: [ #10 ]; s: 21),
  ( cc: [ '"' ]; s: 14),
  ( cc: [ '%','&','(',')',',','^','|','~' ]; s: 22),
  ( cc: [ '.',':','\' ]; s: 20),
  ( cc: [ '/' ]; s: 10),
  ( cc: [ '0' ]; s: 12),
  ( cc: [ '1'..'9' ]; s: 11),
  ( cc: [ 'A','C','D','F'..'K','M'..'Z','_','a'..'z' ]; s: 19),
  ( cc: [ 'B' ]; s: 15),
  ( cc: [ 'E' ]; s: 17),
  ( cc: [ 'L' ]; s: 13),
  ( cc: [ '{' ]; s: 16),
  ( cc: [ '}' ]; s: 18),
{ 1: }
  ( cc: [ #1..#8,#11,#13..#31,'!','#','$','''','*','+',
            '-',';'..'@','[',']','`',#127..#255 ]; s: 24),
  ( cc: [ #9,#12,' ' ]; s: 23),
  ( cc: [ #10 ]; s: 21),
  ( cc: [ '"' ]; s: 14),
  ( cc: [ '%','&','(',')',',','^','|','~' ]; s: 22),
  ( cc: [ '.',':','\' ]; s: 20),
  ( cc: [ '/' ]; s: 10),
  ( cc: [ '0' ]; s: 12),
  ( cc: [ '1'..'9' ]; s: 11),
  ( cc: [ 'A','C','D','F'..'K','M'..'Z','_','a'..'z' ]; s: 19),
  ( cc: [ 'B' ]; s: 15),
  ( cc: [ 'E' ]; s: 17),
  ( cc: [ 'L' ]; s: 13),
  ( cc: [ '{' ]; s: 16),
  ( cc: [ '}' ]; s: 18),
{ 2: }
  ( cc: [ #1..#9,#11..#255 ]; s: 26),
  ( cc: [ #10 ]; s: 25),
{ 3: }
  ( cc: [ #1..#9,#11..#255 ]; s: 26),
  ( cc: [ #10 ]; s: 25),
{ 4: }
  ( cc: [ #0 ]; s: 29),
  ( cc: [ #1..#9,#11..')','+'..#255 ]; s: 27),
  ( cc: [ '*' ]; s: 28),
{ 5: }
  ( cc: [ #0 ]; s: 29),
  ( cc: [ #1..#9,#11..')','+'..#255 ]; s: 27),
  ( cc: [ '*' ]; s: 28),
{ 6: }
  ( cc: [ #1..#9,#11..'!','#'..'[',']'..#255 ]; s: 33),
  ( cc: [ #10 ]; s: 32),
  ( cc: [ '"' ]; s: 30),
  ( cc: [ '\' ]; s: 31),
{ 7: }
  ( cc: [ #1..#9,#11..'!','#'..'[',']'..#255 ]; s: 33),
  ( cc: [ #10 ]; s: 32),
  ( cc: [ '"' ]; s: 30),
  ( cc: [ '\' ]; s: 31),
{ 8: }
  ( cc: [ #1..#9,#11..'!','#'..'[',']'..#255 ]; s: 33),
  ( cc: [ #10 ]; s: 32),
  ( cc: [ '"' ]; s: 34),
  ( cc: [ '\' ]; s: 31),
{ 9: }
  ( cc: [ #1..#9,#11..'!','#'..'[',']'..#255 ]; s: 33),
  ( cc: [ #10 ]; s: 32),
  ( cc: [ '"' ]; s: 34),
  ( cc: [ '\' ]; s: 31),
{ 10: }
  ( cc: [ '*' ]; s: 36),
  ( cc: [ '/' ]; s: 35),
{ 11: }
  ( cc: [ '.',':','A'..'K','M'..'Z','\','_','a'..'z' ]; s: 39),
  ( cc: [ '0'..'9' ]; s: 37),
  ( cc: [ 'L' ]; s: 38),
{ 12: }
  ( cc: [ '.',':','A'..'K','M'..'Z','\','_','a'..'n',
            'p'..'w','y','z' ]; s: 39),
  ( cc: [ '0'..'9' ]; s: 37),
  ( cc: [ 'L' ]; s: 38),
  ( cc: [ 'o' ]; s: 41),
  ( cc: [ 'x' ]; s: 40),
{ 13: }
  ( cc: [ '"' ]; s: 42),
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 43),
{ 14: }
  ( cc: [ 'S' ]; s: 44),
  ( cc: [ 'T' ]; s: 46),
  ( cc: [ 'V' ]; s: 45),
{ 15: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'D','F'..'Z','_','a'..'z' ]; s: 43),
  ( cc: [ 'E' ]; s: 47),
{ 16: }
{ 17: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'M','O'..'Z','_','a'..'z' ]; s: 43),
  ( cc: [ 'N' ]; s: 48),
{ 18: }
{ 19: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 43),
{ 20: }
  ( cc: [ '.','0'..':','A'..'Z','\','_','a'..'z' ]; s: 39),
{ 21: }
{ 22: }
{ 23: }
{ 24: }
{ 25: }
{ 26: }
{ 27: }
{ 28: }
  ( cc: [ '/' ]; s: 49),
{ 29: }
{ 30: }
  ( cc: [ '"' ]; s: 50),
{ 31: }
  ( cc: [ #10 ]; s: 51),
{ 32: }
{ 33: }
{ 34: }
  ( cc: [ '"' ]; s: 50),
{ 35: }
{ 36: }
{ 37: }
  ( cc: [ '.',':','A'..'K','M'..'Z','\','_','a'..'z' ]; s: 39),
  ( cc: [ '0'..'9' ]; s: 37),
  ( cc: [ 'L' ]; s: 38),
{ 38: }
  ( cc: [ '.','0'..':','A'..'Z','\','_','a'..'z' ]; s: 39),
{ 39: }
  ( cc: [ '.','0'..':','A'..'Z','\','_','a'..'z' ]; s: 39),
{ 40: }
  ( cc: [ '.',':','G'..'Z','\','_','g'..'z' ]; s: 39),
  ( cc: [ '0'..'9','A'..'F','a'..'f' ]; s: 52),
{ 41: }
  ( cc: [ '.','8'..':','A'..'Z','\','_','a'..'z' ]; s: 39),
  ( cc: [ '0'..'7' ]; s: 53),
{ 42: }
{ 43: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 43),
{ 44: }
  ( cc: [ 't' ]; s: 54),
{ 45: }
  ( cc: [ 'a' ]; s: 55),
{ 46: }
  ( cc: [ 'r' ]; s: 56),
{ 47: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'F','H'..'Z','_','a'..'z' ]; s: 43),
  ( cc: [ 'G' ]; s: 57),
{ 48: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'C','E'..'Z','_','a'..'z' ]; s: 43),
  ( cc: [ 'D' ]; s: 58),
{ 49: }
{ 50: }
{ 51: }
{ 52: }
  ( cc: [ '.',':','G'..'K','M'..'Z','\','_','g'..'z' ]; s: 39),
  ( cc: [ '0'..'9','A'..'F','a'..'f' ]; s: 52),
  ( cc: [ 'L' ]; s: 59),
{ 53: }
  ( cc: [ '.','8'..':','A'..'K','M'..'Z','\','_','a'..'z' ]; s: 39),
  ( cc: [ '0'..'7' ]; s: 53),
  ( cc: [ 'L' ]; s: 60),
{ 54: }
  ( cc: [ 'r' ]; s: 61),
{ 55: }
  ( cc: [ 'r' ]; s: 62),
{ 56: }
  ( cc: [ 'a' ]; s: 63),
{ 57: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'H','J'..'Z','_','a'..'z' ]; s: 43),
  ( cc: [ 'I' ]; s: 64),
{ 58: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 43),
{ 59: }
  ( cc: [ '.','0'..':','A'..'Z','\','_','a'..'z' ]; s: 39),
{ 60: }
  ( cc: [ '.','0'..':','A'..'Z','\','_','a'..'z' ]; s: 39),
{ 61: }
  ( cc: [ 'i' ]; s: 65),
{ 62: }
  ( cc: [ 'F' ]; s: 66),
{ 63: }
  ( cc: [ 'n' ]; s: 67),
{ 64: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'M','O'..'Z','_','a'..'z' ]; s: 43),
  ( cc: [ 'N' ]; s: 68),
{ 65: }
  ( cc: [ 'n' ]; s: 69),
{ 66: }
  ( cc: [ 'i' ]; s: 70),
{ 67: }
  ( cc: [ 's' ]; s: 71),
{ 68: }
  ( cc: [ '.',':','\' ]; s: 39),
  ( cc: [ '0'..'9','A'..'Z','_','a'..'z' ]; s: 43),
{ 69: }
  ( cc: [ 'g' ]; s: 72),
{ 70: }
  ( cc: [ 'l' ]; s: 73),
{ 71: }
  ( cc: [ 'l' ]; s: 74),
{ 72: }
  ( cc: [ 'F' ]; s: 75),
{ 73: }
  ( cc: [ 'e' ]; s: 76),
{ 74: }
  ( cc: [ 'a' ]; s: 77),
{ 75: }
  ( cc: [ 'i' ]; s: 78),
{ 76: }
  ( cc: [ 'I' ]; s: 79),
{ 77: }
  ( cc: [ 't' ]; s: 80),
{ 78: }
  ( cc: [ 'l' ]; s: 81),
{ 79: }
  ( cc: [ 'n' ]; s: 82),
{ 80: }
  ( cc: [ 'i' ]; s: 83),
{ 81: }
  ( cc: [ 'e' ]; s: 84),
{ 82: }
  ( cc: [ 'f' ]; s: 85),
{ 83: }
  ( cc: [ 'o' ]; s: 86),
{ 84: }
  ( cc: [ 'I' ]; s: 87),
{ 85: }
  ( cc: [ 'o' ]; s: 88),
{ 86: }
  ( cc: [ 'n' ]; s: 89),
{ 87: }
  ( cc: [ 'n' ]; s: 90),
{ 88: }
  ( cc: [ '"' ]; s: 91),
{ 89: }
  ( cc: [ '"' ]; s: 92),
{ 90: }
  ( cc: [ 'f' ]; s: 93),
{ 91: }
{ 92: }
{ 93: }
  ( cc: [ 'o' ]; s: 94),
{ 94: }
  ( cc: [ '"' ]; s: 95)
{ 95: }
);

yykl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 2,
{ 2: } 3,
{ 3: } 3,
{ 4: } 3,
{ 5: } 3,
{ 6: } 3,
{ 7: } 3,
{ 8: } 3,
{ 9: } 3,
{ 10: } 3,
{ 11: } 5,
{ 12: } 8,
{ 13: } 11,
{ 14: } 14,
{ 15: } 16,
{ 16: } 19,
{ 17: } 21,
{ 18: } 24,
{ 19: } 26,
{ 20: } 29,
{ 21: } 31,
{ 22: } 32,
{ 23: } 34,
{ 24: } 36,
{ 25: } 37,
{ 26: } 38,
{ 27: } 39,
{ 28: } 40,
{ 29: } 41,
{ 30: } 42,
{ 31: } 44,
{ 32: } 45,
{ 33: } 46,
{ 34: } 47,
{ 35: } 49,
{ 36: } 50,
{ 37: } 51,
{ 38: } 53,
{ 39: } 55,
{ 40: } 56,
{ 41: } 57,
{ 42: } 58,
{ 43: } 59,
{ 44: } 61,
{ 45: } 61,
{ 46: } 61,
{ 47: } 61,
{ 48: } 63,
{ 49: } 65,
{ 50: } 66,
{ 51: } 67,
{ 52: } 68,
{ 53: } 70,
{ 54: } 72,
{ 55: } 72,
{ 56: } 72,
{ 57: } 72,
{ 58: } 74,
{ 59: } 77,
{ 60: } 79,
{ 61: } 81,
{ 62: } 81,
{ 63: } 81,
{ 64: } 81,
{ 65: } 83,
{ 66: } 83,
{ 67: } 83,
{ 68: } 83,
{ 69: } 86,
{ 70: } 86,
{ 71: } 86,
{ 72: } 86,
{ 73: } 86,
{ 74: } 86,
{ 75: } 86,
{ 76: } 86,
{ 77: } 86,
{ 78: } 86,
{ 79: } 86,
{ 80: } 86,
{ 81: } 86,
{ 82: } 86,
{ 83: } 86,
{ 84: } 86,
{ 85: } 86,
{ 86: } 86,
{ 87: } 86,
{ 88: } 86,
{ 89: } 86,
{ 90: } 86,
{ 91: } 86,
{ 92: } 87,
{ 93: } 88,
{ 94: } 88,
{ 95: } 88
);

yykh : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 2,
{ 2: } 2,
{ 3: } 2,
{ 4: } 2,
{ 5: } 2,
{ 6: } 2,
{ 7: } 2,
{ 8: } 2,
{ 9: } 2,
{ 10: } 4,
{ 11: } 7,
{ 12: } 10,
{ 13: } 13,
{ 14: } 15,
{ 15: } 18,
{ 16: } 20,
{ 17: } 23,
{ 18: } 25,
{ 19: } 28,
{ 20: } 30,
{ 21: } 31,
{ 22: } 33,
{ 23: } 35,
{ 24: } 36,
{ 25: } 37,
{ 26: } 38,
{ 27: } 39,
{ 28: } 40,
{ 29: } 41,
{ 30: } 43,
{ 31: } 44,
{ 32: } 45,
{ 33: } 46,
{ 34: } 48,
{ 35: } 49,
{ 36: } 50,
{ 37: } 52,
{ 38: } 54,
{ 39: } 55,
{ 40: } 56,
{ 41: } 57,
{ 42: } 58,
{ 43: } 60,
{ 44: } 60,
{ 45: } 60,
{ 46: } 60,
{ 47: } 62,
{ 48: } 64,
{ 49: } 65,
{ 50: } 66,
{ 51: } 67,
{ 52: } 69,
{ 53: } 71,
{ 54: } 71,
{ 55: } 71,
{ 56: } 71,
{ 57: } 73,
{ 58: } 76,
{ 59: } 78,
{ 60: } 80,
{ 61: } 80,
{ 62: } 80,
{ 63: } 80,
{ 64: } 82,
{ 65: } 82,
{ 66: } 82,
{ 67: } 82,
{ 68: } 85,
{ 69: } 85,
{ 70: } 85,
{ 71: } 85,
{ 72: } 85,
{ 73: } 85,
{ 74: } 85,
{ 75: } 85,
{ 76: } 85,
{ 77: } 85,
{ 78: } 85,
{ 79: } 85,
{ 80: } 85,
{ 81: } 85,
{ 82: } 85,
{ 83: } 85,
{ 84: } 85,
{ 85: } 85,
{ 86: } 85,
{ 87: } 85,
{ 88: } 85,
{ 89: } 85,
{ 90: } 85,
{ 91: } 86,
{ 92: } 87,
{ 93: } 87,
{ 94: } 87,
{ 95: } 88
);

yyml : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 2,
{ 2: } 3,
{ 3: } 3,
{ 4: } 3,
{ 5: } 3,
{ 6: } 3,
{ 7: } 3,
{ 8: } 3,
{ 9: } 3,
{ 10: } 3,
{ 11: } 5,
{ 12: } 8,
{ 13: } 11,
{ 14: } 14,
{ 15: } 16,
{ 16: } 19,
{ 17: } 21,
{ 18: } 24,
{ 19: } 26,
{ 20: } 29,
{ 21: } 31,
{ 22: } 32,
{ 23: } 34,
{ 24: } 36,
{ 25: } 37,
{ 26: } 38,
{ 27: } 39,
{ 28: } 40,
{ 29: } 41,
{ 30: } 42,
{ 31: } 44,
{ 32: } 45,
{ 33: } 46,
{ 34: } 47,
{ 35: } 49,
{ 36: } 50,
{ 37: } 51,
{ 38: } 53,
{ 39: } 55,
{ 40: } 56,
{ 41: } 57,
{ 42: } 58,
{ 43: } 59,
{ 44: } 61,
{ 45: } 61,
{ 46: } 61,
{ 47: } 61,
{ 48: } 63,
{ 49: } 65,
{ 50: } 66,
{ 51: } 67,
{ 52: } 68,
{ 53: } 70,
{ 54: } 72,
{ 55: } 72,
{ 56: } 72,
{ 57: } 72,
{ 58: } 74,
{ 59: } 77,
{ 60: } 79,
{ 61: } 81,
{ 62: } 81,
{ 63: } 81,
{ 64: } 81,
{ 65: } 83,
{ 66: } 83,
{ 67: } 83,
{ 68: } 83,
{ 69: } 86,
{ 70: } 86,
{ 71: } 86,
{ 72: } 86,
{ 73: } 86,
{ 74: } 86,
{ 75: } 86,
{ 76: } 86,
{ 77: } 86,
{ 78: } 86,
{ 79: } 86,
{ 80: } 86,
{ 81: } 86,
{ 82: } 86,
{ 83: } 86,
{ 84: } 86,
{ 85: } 86,
{ 86: } 86,
{ 87: } 86,
{ 88: } 86,
{ 89: } 86,
{ 90: } 86,
{ 91: } 86,
{ 92: } 87,
{ 93: } 88,
{ 94: } 88,
{ 95: } 88
);

yymh : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 2,
{ 2: } 2,
{ 3: } 2,
{ 4: } 2,
{ 5: } 2,
{ 6: } 2,
{ 7: } 2,
{ 8: } 2,
{ 9: } 2,
{ 10: } 4,
{ 11: } 7,
{ 12: } 10,
{ 13: } 13,
{ 14: } 15,
{ 15: } 18,
{ 16: } 20,
{ 17: } 23,
{ 18: } 25,
{ 19: } 28,
{ 20: } 30,
{ 21: } 31,
{ 22: } 33,
{ 23: } 35,
{ 24: } 36,
{ 25: } 37,
{ 26: } 38,
{ 27: } 39,
{ 28: } 40,
{ 29: } 41,
{ 30: } 43,
{ 31: } 44,
{ 32: } 45,
{ 33: } 46,
{ 34: } 48,
{ 35: } 49,
{ 36: } 50,
{ 37: } 52,
{ 38: } 54,
{ 39: } 55,
{ 40: } 56,
{ 41: } 57,
{ 42: } 58,
{ 43: } 60,
{ 44: } 60,
{ 45: } 60,
{ 46: } 60,
{ 47: } 62,
{ 48: } 64,
{ 49: } 65,
{ 50: } 66,
{ 51: } 67,
{ 52: } 69,
{ 53: } 71,
{ 54: } 71,
{ 55: } 71,
{ 56: } 71,
{ 57: } 73,
{ 58: } 76,
{ 59: } 78,
{ 60: } 80,
{ 61: } 80,
{ 62: } 80,
{ 63: } 80,
{ 64: } 82,
{ 65: } 82,
{ 66: } 82,
{ 67: } 82,
{ 68: } 85,
{ 69: } 85,
{ 70: } 85,
{ 71: } 85,
{ 72: } 85,
{ 73: } 85,
{ 74: } 85,
{ 75: } 85,
{ 76: } 85,
{ 77: } 85,
{ 78: } 85,
{ 79: } 85,
{ 80: } 85,
{ 81: } 85,
{ 82: } 85,
{ 83: } 85,
{ 84: } 85,
{ 85: } 85,
{ 86: } 85,
{ 87: } 85,
{ 88: } 85,
{ 89: } 85,
{ 90: } 85,
{ 91: } 86,
{ 92: } 87,
{ 93: } 87,
{ 94: } 87,
{ 95: } 88
);

yytl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 16,
{ 2: } 31,
{ 3: } 33,
{ 4: } 35,
{ 5: } 38,
{ 6: } 41,
{ 7: } 45,
{ 8: } 49,
{ 9: } 53,
{ 10: } 57,
{ 11: } 59,
{ 12: } 62,
{ 13: } 67,
{ 14: } 70,
{ 15: } 73,
{ 16: } 76,
{ 17: } 76,
{ 18: } 79,
{ 19: } 79,
{ 20: } 81,
{ 21: } 82,
{ 22: } 82,
{ 23: } 82,
{ 24: } 82,
{ 25: } 82,
{ 26: } 82,
{ 27: } 82,
{ 28: } 82,
{ 29: } 83,
{ 30: } 83,
{ 31: } 84,
{ 32: } 85,
{ 33: } 85,
{ 34: } 85,
{ 35: } 86,
{ 36: } 86,
{ 37: } 86,
{ 38: } 89,
{ 39: } 90,
{ 40: } 91,
{ 41: } 93,
{ 42: } 95,
{ 43: } 95,
{ 44: } 97,
{ 45: } 98,
{ 46: } 99,
{ 47: } 100,
{ 48: } 103,
{ 49: } 106,
{ 50: } 106,
{ 51: } 106,
{ 52: } 106,
{ 53: } 109,
{ 54: } 112,
{ 55: } 113,
{ 56: } 114,
{ 57: } 115,
{ 58: } 118,
{ 59: } 120,
{ 60: } 121,
{ 61: } 122,
{ 62: } 123,
{ 63: } 124,
{ 64: } 125,
{ 65: } 128,
{ 66: } 129,
{ 67: } 130,
{ 68: } 131,
{ 69: } 133,
{ 70: } 134,
{ 71: } 135,
{ 72: } 136,
{ 73: } 137,
{ 74: } 138,
{ 75: } 139,
{ 76: } 140,
{ 77: } 141,
{ 78: } 142,
{ 79: } 143,
{ 80: } 144,
{ 81: } 145,
{ 82: } 146,
{ 83: } 147,
{ 84: } 148,
{ 85: } 149,
{ 86: } 150,
{ 87: } 151,
{ 88: } 152,
{ 89: } 153,
{ 90: } 154,
{ 91: } 155,
{ 92: } 155,
{ 93: } 155,
{ 94: } 156,
{ 95: } 157
);

yyth : array [0..yynstates-1] of Integer = (
{ 0: } 15,
{ 1: } 30,
{ 2: } 32,
{ 3: } 34,
{ 4: } 37,
{ 5: } 40,
{ 6: } 44,
{ 7: } 48,
{ 8: } 52,
{ 9: } 56,
{ 10: } 58,
{ 11: } 61,
{ 12: } 66,
{ 13: } 69,
{ 14: } 72,
{ 15: } 75,
{ 16: } 75,
{ 17: } 78,
{ 18: } 78,
{ 19: } 80,
{ 20: } 81,
{ 21: } 81,
{ 22: } 81,
{ 23: } 81,
{ 24: } 81,
{ 25: } 81,
{ 26: } 81,
{ 27: } 81,
{ 28: } 82,
{ 29: } 82,
{ 30: } 83,
{ 31: } 84,
{ 32: } 84,
{ 33: } 84,
{ 34: } 85,
{ 35: } 85,
{ 36: } 85,
{ 37: } 88,
{ 38: } 89,
{ 39: } 90,
{ 40: } 92,
{ 41: } 94,
{ 42: } 94,
{ 43: } 96,
{ 44: } 97,
{ 45: } 98,
{ 46: } 99,
{ 47: } 102,
{ 48: } 105,
{ 49: } 105,
{ 50: } 105,
{ 51: } 105,
{ 52: } 108,
{ 53: } 111,
{ 54: } 112,
{ 55: } 113,
{ 56: } 114,
{ 57: } 117,
{ 58: } 119,
{ 59: } 120,
{ 60: } 121,
{ 61: } 122,
{ 62: } 123,
{ 63: } 124,
{ 64: } 127,
{ 65: } 128,
{ 66: } 129,
{ 67: } 130,
{ 68: } 132,
{ 69: } 133,
{ 70: } 134,
{ 71: } 135,
{ 72: } 136,
{ 73: } 137,
{ 74: } 138,
{ 75: } 139,
{ 76: } 140,
{ 77: } 141,
{ 78: } 142,
{ 79: } 143,
{ 80: } 144,
{ 81: } 145,
{ 82: } 146,
{ 83: } 147,
{ 84: } 148,
{ 85: } 149,
{ 86: } 150,
{ 87: } 151,
{ 88: } 152,
{ 89: } 153,
{ 90: } 154,
{ 91: } 154,
{ 92: } 154,
{ 93: } 155,
{ 94: } 156,
{ 95: } 156
);


var yyn : Integer;

label start, scan, action;

begin

start:

  (* initialize: *)

  yynew;

scan:

  (* mark positions and matches: *)

  for yyn := yykl[yystate] to     yykh[yystate] do yymark(yyk[yyn]);
  for yyn := yymh[yystate] downto yyml[yystate] do yymatch(yym[yyn]);

  if yytl[yystate]>yyth[yystate] then goto action; (* dead state *)

  (* get next character: *)

  yyscan;

  (* determine action: *)

  yyn := yytl[yystate];
  while (yyn<=yyth[yystate]) and not (yyactchar in yyt[yyn].cc) do inc(yyn);
  if yyn>yyth[yystate] then goto action;
    (* no transition on yyactchar in this state *)

  (* switch to new state: *)

  yystate := yyt[yyn].s;

  goto scan;

action:

  (* execute action: *)

  if yyfind(yyrule) then
    begin
      yyaction(yyrule);
      if yyreject then goto action;
    end
  else if not yydefault and yywrap() then
    begin
      yyclear;
      return(0);
    end;

  if not yydone then goto start;

  yylex := yyretval;

end(*yylex*);



// end.





