{
    Copyright (c) 2019 by Jonas Maebe

    Generate LLVM bytecode for set/case nodes

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 ****************************************************************************
}
unit nllvmset;

{$i fpcdefs.inc}

interface

  uses
    nset, ncgset,
    symtype,
    cgbase;

  type
    tllvminnode = class(tcginnode)
     protected
      procedure in_reg_const(uopdef: tdef; opsize: tcgsize); override;
    end;

    tllvmcasenode = class(tcgcasenode)
     protected
      procedure genlinearlist(hp: pcaselabel); override;
    end;


implementation

    uses
      globals,
      aasmbase, aasmdata,
      hlcgobj,
      llvminfo;

    procedure tllvminnode.in_reg_const(uopdef: tdef; opsize: tcgsize);
      var
        hl,hlend: TAsmLabel;
      begin
        if not(llvmflag_no_freeze in llvmversion_properties[current_settings.llvmversion]) then
          begin
            { if we have the freeze instruction, we can mark the poison value
              potentially generated by the shift as "replace with a fixed value
              if it's poison, we don't care since we'll mask it anyway" }
            inherited;
            exit;
          end;
        { don't perform the bit test if the register's value can be >=
          "number of bits in right.location", because that generates a poison
          value in LLVM (and even anding it will 0 will keep it a poison value),
          and calculations using poison as input result in undefined behaviour }
        current_asmdata.getjumplabel(hl);
        current_asmdata.getjumplabel(hlend);
        hlcg.a_cmp_const_reg_label(current_asmdata.CurrAsmList,uopdef,OC_AE,
          right.resultdef.packedbitsize,left.location.register,hl);
        hlcg.a_bit_test_reg_loc_reg(current_asmdata.CurrAsmList,
          uopdef,right.resultdef,uopdef,
          left.location.register,right.location,location.register);
        hlcg.a_jmp_always(current_asmdata.CurrAsmList,hlend);
        hlcg.a_label(current_asmdata.CurrAsmList,hl);
        hlcg.a_load_const_reg(current_asmdata.CurrAsmList,uopdef,0,location.register);
        hlcg.a_label(current_asmdata.CurrAsmList,hlend);
      end;


  procedure tllvmcasenode.genlinearlist(hp: pcaselabel);
    begin
      { genlinearlist constantly updates the case value in the register,
        which causes tons of spilling with LLVM due to the need to bring
        it back into SSA form. LLVM will recognise and optimise the linear
        cmp list just as well (or even better), while the code that FPC
        has to generate is much smaller (no spilling) }
      genlinearcmplist(hp);
    end;

begin
  cinnode:=tllvminnode;
  ccasenode:=tllvmcasenode;
end.

