/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple5;
import scala.UninitializedFieldError;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import sttp.model.Uri;
import sttp.model.Uri$Authority$;
import sttp.model.Uri$EmptyPath$;
import sttp.model.Uri$FragmentSegment$;
import sttp.model.Uri$HostSegment$;
import sttp.model.Uri$PathSegment$;
import sttp.model.Uri$PathSegments$;
import sttp.model.UriInterpolator;
import sttp.model.internal.Validate$;

public final class Uri$
implements UriInterpolator,
Serializable {
    public static final Uri$ MODULE$ = new Uri$();
    private static final Regex AllowedSchemeCharacters;
    private static volatile int bitmap$init$0;

    static {
        UriInterpolator.$init$(MODULE$);
        AllowedSchemeCharacters = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[a-zA-Z][a-zA-Z0-9+-.]*"));
        bitmap$init$0 |= 1;
    }

    @Override
    public UriInterpolator.UriContext UriContext(StringContext sc) {
        return UriInterpolator.UriContext$(this, sc);
    }

    private Regex AllowedSchemeCharacters() {
        if ((bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/sttp-model/sttp-model/core/src/main/scala/sttp/model/Uri.scala: 328");
        }
        return AllowedSchemeCharacters;
    }

    public Option<String> sttp$model$Uri$$validateHost(Option<String> host) {
        return host.flatMap((Function1 & Serializable)h -> h.isEmpty() ? new Some((Object)"Host cannot be empty") : None$.MODULE$);
    }

    private Option<String> validateScheme(Option<String> scheme) {
        return scheme.flatMap((Function1 & Serializable)s -> MODULE$.AllowedSchemeCharacters().unapplySeq((CharSequence)s).isEmpty() ? new Some((Object)"Scheme can only contain alphanumeric characters, +, - and .") : None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host) {
        return this.safeApply("http", (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host, int port) {
        return this.safeApply("http", (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host, int port, Seq<String> path) {
        return this.safeApply("http", (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$19 -> Uri$PathSegment$.MODULE$.apply((String)x$19))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.Authority>)None$.MODULE$, (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$20 -> Uri$PathSegment$.MODULE$.apply((String)x$20))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host) {
        return this.safeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, int port) {
        return this.safeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, int port, Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$21 -> Uri$PathSegment$.MODULE$.apply((String)x$21))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$22 -> Uri$PathSegment$.MODULE$.apply((String)x$22))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, Seq<String> path, Option<String> fragment) {
        return this.safeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$23 -> Uri$PathSegment$.MODULE$.apply((String)x$23))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$24 -> Uri$FragmentSegment$.MODULE$.apply((String)x$24)));
    }

    public Either<String, Uri> safeApply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.safeApply(scheme, (Option<Uri.Authority>)new Some((Object)new Uri.Authority(userInfo, Uri$HostSegment$.MODULE$.apply(host), port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$25 -> Uri$PathSegment$.MODULE$.apply((String)x$25))), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$26 -> Uri$FragmentSegment$.MODULE$.apply((String)x$26)));
    }

    public Either<String, Uri> safeApply(String scheme, Option<Uri.Authority> authority, Seq<Uri.Segment> pathSegments, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return Validate$.MODULE$.all((Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.validateScheme((Option<String>)new Some((Object)scheme)), this.sttp$model$Uri$$validateHost((Option<String>)authority.map((Function1 & Serializable)x$27 -> x$27.hostSegment().v()))}), (Function0 & Serializable)() -> new Uri((Option<String>)new Some((Object)scheme), authority, Uri$PathSegments$.MODULE$.absoluteOrEmpty(pathSegments), querySegments, fragmentSegment));
    }

    public Uri unsafeApply(String host) {
        return this.unsafeApply("http", (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String host, int port) {
        return this.unsafeApply("http", (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String host, int port, Seq<String> path) {
        return this.unsafeApply("http", (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$28 -> Uri$PathSegment$.MODULE$.apply((String)x$28))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)None$.MODULE$, (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$29 -> Uri$PathSegment$.MODULE$.apply((String)x$29))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, int port) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, int port, Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$30 -> Uri$PathSegment$.MODULE$.apply((String)x$30))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$31 -> Uri$PathSegment$.MODULE$.apply((String)x$31))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, Seq<String> path, Option<String> fragment) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$32 -> Uri$PathSegment$.MODULE$.apply((String)x$32))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$33 -> Uri$FragmentSegment$.MODULE$.apply((String)x$33)));
    }

    public Uri unsafeApply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)new Some((Object)new Uri.Authority(userInfo, Uri$HostSegment$.MODULE$.apply(host), port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$34 -> Uri$PathSegment$.MODULE$.apply((String)x$34))), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$35 -> Uri$FragmentSegment$.MODULE$.apply((String)x$35)));
    }

    public Uri unsafeApply(String scheme, Option<Uri.Authority> authority, Seq<Uri.Segment> pathSegments, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return Validate$.MODULE$.RichEither(this.safeApply(scheme, authority, pathSegments, querySegments, fragmentSegment)).getOrThrow();
    }

    public Uri apply(String host) {
        return new Uri((Option<String>)new Some((Object)"http"), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String host, int port) {
        return new Uri((Option<String>)new Some((Object)"http"), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String host, int port, Seq<String> path) {
        return new Uri((Option<String>)new Some((Object)"http"), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, Seq<String> path) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)None$.MODULE$, Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, int port) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, int port, Seq<String> path) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, Seq<String> path) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, Seq<String> path, Option<String> fragment) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)new Some((Object)Uri$Authority$.MODULE$.apply(host)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$36 -> Uri$FragmentSegment$.MODULE$.apply((String)x$36)));
    }

    public Uri apply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return new Uri((Option<String>)new Some((Object)scheme), (Option<Uri.Authority>)new Some((Object)new Uri.Authority(userInfo, Uri$HostSegment$.MODULE$.apply(host), port)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$37 -> Uri$FragmentSegment$.MODULE$.apply((String)x$37)));
    }

    public Uri apply(String scheme, Option<Uri.Authority> authority, Seq<Uri.Segment> path, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragment) {
        return new Uri((Option<String>)new Some((Object)scheme), authority, Uri$PathSegments$.MODULE$.absoluteOrEmpty(path), querySegments, fragment);
    }

    public Uri relative(Seq<String> path) {
        return this.relative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<String>)None$.MODULE$);
    }

    public Uri relative(Seq<String> path, Option<String> fragment) {
        return this.relative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), fragment);
    }

    public Uri relative(Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return new Uri((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$38 -> Uri$FragmentSegment$.MODULE$.apply((String)x$38)));
    }

    public Uri pathRelative(Seq<String> path) {
        return this.pathRelative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<String>)None$.MODULE$);
    }

    public Uri pathRelative(Seq<String> path, Option<String> fragment) {
        return this.pathRelative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), fragment);
    }

    public Uri pathRelative(Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return new Uri((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, new Uri.RelativePath((Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)x$39 -> Uri$PathSegment$.MODULE$.apply((String)x$39)))), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)x$40 -> Uri$FragmentSegment$.MODULE$.apply((String)x$40)));
    }

    public Uri apply(URI javaUri) {
        return this.UriContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{javaUri.toString()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, Uri> parse(String uri) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.UriContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Uri u = (Uri)success.value();
            return package$.MODULE$.Right().apply((Object)u);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof Exception) {
                Exception exception = (Exception)e;
                return package$.MODULE$.Left().apply((Object)exception.getMessage());
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable t = failure.exception();
        if (t == null) throw new MatchError((Object)try_);
        Throwable throwable = t;
        throw throwable;
    }

    public Uri unsafeParse(String uri) {
        return this.UriContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{uri}));
    }

    public Uri apply(Option<String> scheme, Option<Uri.Authority> authority, Uri.PathSegments pathSegments, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return new Uri(scheme, authority, pathSegments, querySegments, fragmentSegment);
    }

    public Option<Tuple5<Option<String>, Option<Uri.Authority>, Uri.PathSegments, Seq<Uri.QuerySegment>, Option<Uri.Segment>>> unapply(Uri x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.scheme(), x$0.authority(), (Object)x$0.pathSegments(), x$0.querySegments(), x$0.fragmentSegment()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Uri$.class);
    }

    private Uri$() {
    }
}

