/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.serde.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.serde.avro.AvroHelper$;
import io.conduktor.serde.serializers.AvroConversionException;
import io.conduktor.serde.serializers.AvroConversionExceptionWrapped;
import io.conduktor.serde.serializers.AvroTypeExceptions$;
import io.conduktor.serde.serializers.JsonGenericRecordReader$;
import io.conduktor.serde.serializers.JsonGenericRecordReader$Incompatible$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Locale;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecordBuilder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class JsonGenericRecordReader$ {
    public static final JsonGenericRecordReader$ MODULE$ = new JsonGenericRecordReader$();
    private static final JsonGenericRecordReader$Incompatible$ INCOMPATIBLE = JsonGenericRecordReader$Incompatible$.MODULE$;
    private static final DateTimeFormatter humanDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.ENGLISH).withZone(ZoneId.systemDefault());

    private JsonGenericRecordReader$Incompatible$ INCOMPATIBLE() {
        return INCOMPATIBLE;
    }

    private DateTimeFormatter humanDateTimeFormatter() {
        return humanDateTimeFormatter;
    }

    public GenericData.Record read(JsonNode json, Schema schema) {
        GenericData.Record record;
        if (!json.isObject()) {
            throw new AvroConversionException("JSON arrays at root are not supported");
        }
        try {
            record = this.readRecord((ObjectNode)json, schema, (List<String>)package$.MODULE$.List().empty());
        }
        catch (AvroRuntimeException ex) {
            throw new AvroConversionExceptionWrapped(new StringBuilder(33).append("Failed to convert JSON to Avro : ").append((Object)ex).toString(), ex);
        }
        return record;
    }

    private GenericData.Record readRecord(ObjectNode json, Schema schema, List<String> path) {
        GenericRecordBuilder record = new GenericRecordBuilder(schema);
        CollectionConverters$.MODULE$.IteratorHasAsScala(json.fields()).asScala().foreach((Function1 & Serializable)a -> {
            Schema.Field avroField = schema.getField((String)a.getKey());
            return avroField != null ? record.set(avroField, MODULE$.read(avroField, avroField.schema(), (Option<JsonNode>)Option$.MODULE$.apply(a.getValue()), path, false).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())) : BoxedUnit.UNIT;
        });
        return record.build();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Option<Object> read(Schema.Field field, Schema schema, Option<JsonNode> jsonValue, List<String> path, boolean isTestingUnion) {
        block38: {
            block49: {
                block51: {
                    block53: {
                        block52: {
                            block50: {
                                block45: {
                                    block47: {
                                        block48: {
                                            block46: {
                                                block44: {
                                                    block43: {
                                                        block42: {
                                                            block41: {
                                                                block40: {
                                                                    block39: {
                                                                        block37: {
                                                                            childPath = (List)path.$colon$plus((Object)field.name());
                                                                            var23_7 = schema.getType();
                                                                            if (!Schema.Type.UNION.equals(var23_7)) break block37;
                                                                            var6_8 = this.readUnion(field, schema, jsonValue, (List<String>)childPath);
                                                                            break block38;
                                                                        }
                                                                        if (!Schema.Type.RECORD.equals(var23_7)) break block39;
                                                                        var24_9 = jsonValue;
                                                                        var20_12 /* !! */  = var24_9 instanceof Some != false && (value = (JsonNode)(var25_10 = (Some)var24_9).value()).isObject() != false ? this.readRecord((ObjectNode)value, schema, (List<String>)childPath) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                                                        var6_8 = var20_12 /* !! */ ;
                                                                        break block38;
                                                                    }
                                                                    if (!Schema.Type.ARRAY.equals(var23_7)) break block40;
                                                                    var27_13 = jsonValue;
                                                                    var19_16 = var27_13 instanceof Some != false && (value = (JsonNode)(var28_14 = (Some)var27_13).value()).isArray() != false ? this.readArray(field, schema, (ArrayNode)value, (List<String>)childPath) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                                                    var6_8 = var19_16;
                                                                    break block38;
                                                                }
                                                                if (!Schema.Type.MAP.equals(var23_7)) break block41;
                                                                var30_17 = jsonValue;
                                                                var18_20 = var30_17 instanceof Some != false && (value = (JsonNode)(var31_18 = (Some)var30_17).value()).isObject() != false ? this.readMap(field, schema, (ObjectNode)value, (List<String>)childPath) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                                                var6_8 = var18_20;
                                                                break block38;
                                                            }
                                                            if (!Schema.Type.ENUM.equals(var23_7)) break block42;
                                                            var33_21 = jsonValue;
                                                            var17_24 /* !! */  = var33_21 instanceof Some != false && (value = (JsonNode)(var34_22 = (Some)var33_21).value()).isTextual() != false ? this.stringToEnumSymbol(schema, value.textValue(), (List<String>)childPath) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                                            var6_8 = var17_24 /* !! */ ;
                                                            break block38;
                                                        }
                                                        if (!Schema.Type.STRING.equals(var23_7)) break block43;
                                                        var36_25 = jsonValue;
                                                        var16_28 = var36_25 instanceof Some != false && (value = (JsonNode)(var37_26 = (Some)var36_25).value()).isTextual() != false ? value.textValue() : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                                        var6_8 = var16_28;
                                                        break block38;
                                                    }
                                                    if (!Schema.Type.BYTES.equals(var23_7)) break block44;
                                                    lt = schema.getLogicalType();
                                                    var40_30 = false;
                                                    var41_31 = null;
                                                    var42_32 = jsonValue;
                                                    if (!(var42_32 instanceof Some)) ** GOTO lbl-1000
                                                    var40_30 = true;
                                                    var41_31 = (Some)var42_32;
                                                    value = (JsonNode)var41_31.value();
                                                    if (value.isTextual()) {
                                                        str = value.textValue();
                                                        var45_35 = lt;
                                                        if (var45_35 instanceof LogicalTypes.Decimal) {
                                                            var46_36 = (LogicalTypes.Decimal)var45_35;
                                                            try {
                                                                dec = package$.MODULE$.BigDecimal().apply(str).setScale(var46_36.getScale(), BigDecimal.RoundingMode$.MODULE$.HALF_EVEN());
                                                                v0 = AvroHelper$.MODULE$.decimalConversion().toBytes(dec.bigDecimal(), schema, lt);
                                                            }
                                                            catch (Throwable var48_38) {
                                                                var49_39 = var48_38;
                                                                if (var49_39 == null || (var50_40 = NonFatal$.MODULE$.unapply(var49_39)).isEmpty()) {
                                                                    throw var48_38;
                                                                }
                                                                e = (Throwable)var50_40.get();
                                                                var15_42 = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                                                                v0 = var15_42;
                                                            }
                                                            var14_43 = v0;
                                                        } else {
                                                            try {
                                                                v1 = this.bytesForStringBase64(str);
                                                            }
                                                            catch (Throwable v2) {
                                                                v1 = this.wrongTypeError$1((Option)new Some((Object)new Exception("Please encode bytes with a base64 encoding in your string")), isTestingUnion, childPath, schema);
                                                            }
                                                            var14_43 = v1;
                                                        }
                                                        var13_44 = var14_43;
                                                    } else if (var40_30 && (value = (JsonNode)var41_31.value()).isNumber() && lt instanceof LogicalTypes.Decimal) {
                                                        try {
                                                            dec = package$.MODULE$.BigDecimal().apply(value.doubleValue()).setScale(((LogicalTypes.Decimal)lt).getScale(), BigDecimal.RoundingMode$.MODULE$.HALF_EVEN());
                                                            v3 = AvroHelper$.MODULE$.decimalConversion().toBytes(dec.bigDecimal(), schema, lt);
                                                        }
                                                        catch (Exception e) {
                                                            v3 = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                                                        }
                                                        var13_44 = v3;
                                                    } else {
                                                        var13_44 = this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                                    }
                                                    var6_8 = var13_44;
                                                    break block38;
                                                }
                                                if (!Schema.Type.INT.equals(var23_7)) break block45;
                                                lt = schema.getLogicalType();
                                                var56_49 = new Tuple2((Object)lt, jsonValue);
                                                if (var56_49 == null || !((var57_50 = (Option)var56_49._2()) instanceof Some) || !(json = (JsonNode)(var58_51 = (Some)var57_50).value()).canConvertToInt()) break block46;
                                                var12_53 /* !! */  = BoxesRunTime.boxToInteger((int)json.intValue());
                                                break block47;
                                            }
                                            if (var56_49 == null) break block48;
                                            var60_54 = (Option)var56_49._2();
                                            if (!(var56_49._1() instanceof LogicalTypes.Date) || !(var60_54 instanceof Some) || !(json = (JsonNode)(var61_55 = (Some)var60_54).value()).isTextual()) break block48;
                                            try {
                                                v4 /* !! */  = BoxesRunTime.boxToInteger((int)this.convertToDate(json.textValue()));
                                            }
                                            catch (Exception e) {
                                                v4 /* !! */  = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                                            }
                                            var12_53 /* !! */  = v4 /* !! */ ;
                                            break block47;
                                        }
                                        if (var56_49 == null) ** GOTO lbl-1000
                                        var64_58 = (Option)var56_49._2();
                                        if (var56_49._1() instanceof LogicalTypes.TimeMillis && var64_58 instanceof Some && (json = (JsonNode)(var65_59 = (Some)var64_58).value()).isTextual()) {
                                            try {
                                                v5 /* !! */  = BoxesRunTime.boxToInteger((int)this.convertToTimeMillis(json.textValue()));
                                            }
                                            catch (Exception e) {
                                                v5 /* !! */  = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                                            }
                                            var12_53 /* !! */  = v5 /* !! */ ;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var12_53 /* !! */  = this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                                        }
                                    }
                                    var6_8 = var12_53 /* !! */ ;
                                    break block38;
                                }
                                if (!Schema.Type.LONG.equals(var23_7)) break block49;
                                lt = schema.getLogicalType();
                                var69_63 = new Tuple2((Object)lt, jsonValue);
                                if (var69_63 == null || !((var70_64 = (Option)var69_63._2()) instanceof Some) || !(json = (JsonNode)(var71_65 = (Some)var70_64).value()).canConvertToLong()) break block50;
                                var11_67 /* !! */  = BoxesRunTime.boxToLong((long)json.longValue());
                                break block51;
                            }
                            if (var69_63 == null) break block52;
                            var73_68 = (Option)var69_63._2();
                            if (!(var69_63._1() instanceof LogicalTypes.TimestampMillis) || !(var73_68 instanceof Some) || !(json = (JsonNode)(var74_69 = (Some)var73_68).value()).isTextual()) break block52;
                            try {
                                v6 /* !! */  = BoxesRunTime.boxToLong((long)this.convertToTimestampMillis(json.textValue()));
                            }
                            catch (Exception e) {
                                v6 /* !! */  = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                            }
                            var11_67 /* !! */  = v6 /* !! */ ;
                            break block51;
                        }
                        if (var69_63 == null) break block53;
                        var77_72 = (Option)var69_63._2();
                        if (!(var69_63._1() instanceof LogicalTypes.TimestampMicros) || !(var77_72 instanceof Some) || !(json = (JsonNode)(var78_73 = (Some)var77_72).value()).isTextual()) break block53;
                        try {
                            v7 /* !! */  = BoxesRunTime.boxToLong((long)this.convertToTimestampMicros(json.textValue()));
                        }
                        catch (Exception e) {
                            v7 /* !! */  = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                        }
                        var11_67 /* !! */  = v7 /* !! */ ;
                        break block51;
                    }
                    if (var69_63 == null) ** GOTO lbl-1000
                    var81_76 = (Option)var69_63._2();
                    if (var69_63._1() instanceof LogicalTypes.TimeMicros && var81_76 instanceof Some && (json = (JsonNode)(var82_77 = (Some)var81_76).value()).isTextual()) {
                        try {
                            v8 /* !! */  = BoxesRunTime.boxToLong((long)this.convertToTimeMicros(json.textValue()));
                        }
                        catch (Exception e) {
                            v8 /* !! */  = this.wrongTypeError$1((Option)new Some((Object)e), isTestingUnion, childPath, schema);
                        }
                        var11_67 /* !! */  = v8 /* !! */ ;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var11_67 /* !! */  = this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                    }
                }
                var6_8 = var11_67 /* !! */ ;
                break block38;
            }
            if (Schema.Type.FLOAT.equals(var23_7)) {
                var85_80 = jsonValue;
                var10_83 /* !! */  = var85_80 instanceof Some != false && (value = (JsonNode)(var86_81 = (Some)var85_80).value()).isNumber() != false ? BoxesRunTime.boxToFloat((float)value.floatValue()) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                var6_8 = var10_83 /* !! */ ;
            } else if (Schema.Type.DOUBLE.equals(var23_7)) {
                var88_84 = jsonValue;
                var9_87 /* !! */  = var88_84 instanceof Some != false && (value = (JsonNode)(var89_85 = (Some)var88_84).value()).isNumber() != false ? BoxesRunTime.boxToDouble((double)value.doubleValue()) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                var6_8 = var9_87 /* !! */ ;
            } else if (Schema.Type.BOOLEAN.equals(var23_7)) {
                var91_88 = jsonValue;
                var8_91 /* !! */  = var91_88 instanceof Some != false && (value = (JsonNode)(var92_89 = (Some)var91_88).value()).isBoolean() != false ? BoxesRunTime.boxToBoolean((boolean)value.booleanValue()) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                var6_8 = var8_91 /* !! */ ;
            } else if (Schema.Type.NULL.equals(var23_7)) {
                var6_8 = jsonValue.isEmpty() != false || ((JsonNode)jsonValue.get()).isNull() != false ? null : this.INCOMPATIBLE();
            } else if (Schema.Type.FIXED.equals(var23_7)) {
                var94_92 = jsonValue;
                var7_95 /* !! */  = var94_92 instanceof Some != false && (value = (JsonNode)(var95_93 = (Some)var94_92).value()).isArray() != false ? this.readFixed(schema, (ArrayNode)value) : this.wrongTypeError$1(JsonGenericRecordReader$.wrongTypeError$default$1$1(), isTestingUnion, childPath, schema);
                var6_8 = var7_95 /* !! */ ;
            } else {
                throw new AvroTypeException(new StringBuilder(18).append("Unsupported type: ").append(field.schema().getType()).toString());
            }
        }
        maybeNullRes = var6_8;
        return Option$.MODULE$.apply(maybeNullRes);
    }

    private long convertToTimestampMillis(String text) {
        long l;
        try {
            l = Predef$.MODULE$.Long2long(AvroHelper$.MODULE$.timestampConversion().toLong(Instant.parse(text), null, null));
        }
        catch (Throwable throwable) {
            l = Predef$.MODULE$.Long2long(AvroHelper$.MODULE$.timestampConversion().toLong(ZonedDateTime.parse(text, this.humanDateTimeFormatter()).toInstant(), null, null));
        }
        return l;
    }

    private long convertToTimestampMicros(String text) {
        long l;
        try {
            l = Predef$.MODULE$.Long2long(AvroHelper$.MODULE$.timestampMicrosConversion().toLong(Instant.parse(text), null, null));
        }
        catch (Throwable throwable) {
            l = Predef$.MODULE$.Long2long(AvroHelper$.MODULE$.timestampMicrosConversion().toLong(ZonedDateTime.parse(text, this.humanDateTimeFormatter()).toInstant(), null, null));
        }
        return l;
    }

    private long convertToTimeMicros(String text) {
        return Predef$.MODULE$.Long2long(AvroHelper$.MODULE$.timeMicrosConversion().toLong(LocalTime.parse(text), null, null));
    }

    private int convertToTimeMillis(String text) {
        return Predef$.MODULE$.Integer2int(AvroHelper$.MODULE$.timeConversion().toInt(LocalTime.parse(text), null, null));
    }

    private int convertToDate(String text) {
        return Predef$.MODULE$.Integer2int(AvroHelper$.MODULE$.dateConversion().toInt(LocalDate.parse(text), null, null));
    }

    private Iterable<Object> readArray(Schema.Field field, Schema schema, ArrayNode items, List<String> path) {
        ArrayList<Object> buff = new ArrayList<Object>();
        for (JsonNode item : items) {
            buff.add(this.read(field, schema.getElementType(), (Option<JsonNode>)Option$.MODULE$.apply((Object)item), path, false).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return buff;
    }

    private GenericFixed readFixed(Schema schema, ArrayNode items) {
        return new GenericFixed(schema, items){
            private final Schema schema$3;
            private final ArrayNode items$1;

            public Schema getSchema() {
                return this.schema$3;
            }

            public byte[] bytes() {
                return (byte[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)this.items$1).asScala().toArray(ClassTag$.MODULE$.apply(JsonNode.class))), (Function1 & Serializable)item -> BoxesRunTime.boxToByte((byte)anon.1.$anonfun$bytes$1(item)), (ClassTag)ClassTag$.MODULE$.Byte());
            }

            public static final /* synthetic */ byte $anonfun$bytes$1(JsonNode item) {
                return (byte)item.intValue();
            }
            {
                this.schema$3 = schema$3;
                this.items$1 = items$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bytes$1$adapted(com.fasterxml.jackson.databind.JsonNode )}, serializedLambda);
            }
        };
    }

    private Map<String, Object> readMap(Schema.Field field, Schema schema, ObjectNode obj, List<String> path) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(obj.fields()).asScala().map((Function1 & Serializable)a -> new Tuple2(a.getKey(), MODULE$.read(field, schema.getValueType(), (Option<JsonNode>)Option$.MODULE$.apply(a.getValue()), path, false).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Object readUnion(Schema.Field field, Schema schema, Option<JsonNode> value, List<String> path) {
        List types = CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)schema.getTypes()).asScala().toList();
        Left left = package$.MODULE$.Left().apply((Object)BoxedUnit.UNIT);
        Either found = (Either)types.foldLeft((Object)left, (Function2 & Serializable)(a, b) -> {
            Right right;
            Either r;
            Tuple2 tuple2 = new Tuple2(a, b);
            if (tuple2 != null && (r = (Either)tuple2._1()) instanceof Right) {
                Right right2;
                right = right2 = (Right)r;
            } else if (tuple2 != null) {
                Object object;
                Schema schema = (Schema)tuple2._2();
                try {
                    Option<Object> subObj = MODULE$.read(field, schema, value, path, true);
                    object = subObj.contains((Object)MODULE$.INCOMPATIBLE()) ? left : package$.MODULE$.Right().apply(subObj);
                }
                catch (AvroRuntimeException avroRuntimeException) {
                    object = left;
                }
                right = object;
            } else {
                throw new MatchError((Object)tuple2);
            }
            return right;
        });
        return found.map((Function1 & Serializable)x$1 -> x$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse((Function0 & Serializable)() -> {
            throw AvroTypeExceptions$.MODULE$.unionException(field.name(), types.map((Function1 & Serializable)x$2 -> x$2.getType().getName()).mkString(", "), path);
        });
    }

    private GenericData.EnumSymbol stringToEnumSymbol(Schema schema, String value, List<String> path) {
        java.util.List symbols = schema.getEnumSymbols();
        if (!symbols.contains(value)) {
            throw AvroTypeExceptions$.MODULE$.enumException(path, CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)symbols).asScala().mkString(", "));
        }
        return new GenericData.EnumSymbol(schema, value);
    }

    private ByteBuffer bytesForStringBase64(String string) {
        return ByteBuffer.wrap(Base64.getDecoder().decode(string));
    }

    private Option<JsonGenericRecordReader$Incompatible$> failAvroType(boolean isTestingUnion, List<String> path, Schema schema, Schema.Type schemaType, Option<Exception> e) {
        if (!isTestingUnion) {
            Object object;
            String expectedType = schemaType.getName();
            LogicalType logicalType = schema.getLogicalType();
            if (logicalType instanceof LogicalTypes.Decimal) {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                object = new Some((Object)new StringBuilder(12).append("decimal (").append(decimal.getPrecision()).append(", ").append(decimal.getScale()).append(")").toString());
            } else {
                object = logicalType instanceof LogicalTypes.Date ? new Some((Object)"date") : (logicalType instanceof LogicalTypes.TimeMicros ? new Some((Object)"time-micros") : (logicalType instanceof LogicalTypes.TimeMillis ? new Some((Object)"time-millis") : (logicalType instanceof LogicalTypes.TimestampMicros ? new Some((Object)"timestamp-micros") : (logicalType instanceof LogicalTypes.TimestampMillis ? new Some((Object)"timestamp-millis") : None$.MODULE$))));
            }
            Some logicalTypeDetails = object;
            Schema.Type type = schemaType;
            Object object2 = Schema.Type.BYTES.equals(type) ? new Some((Object)"a string in JSON") : None$.MODULE$;
            None$ detailedExpectedType = object2;
            throw AvroTypeExceptions$.MODULE$.typeException(path, (Option<String>)new Some((Object)new StringBuilder(0).append(expectedType).append(logicalTypeDetails.map((Function1 & Serializable)a -> new StringBuilder(3).append(" (").append((String)a).append(")").toString()).getOrElse((Function0 & Serializable)() -> "")).append(detailedExpectedType.map((Function1 & Serializable)a -> new StringBuilder(3).append(" (").append((String)a).append(")").toString()).getOrElse((Function0 & Serializable)() -> "")).toString()), e);
        }
        return Option$.MODULE$.apply((Object)this.INCOMPATIBLE());
    }

    private final JsonGenericRecordReader$Incompatible$ wrongTypeError$1(Option e, boolean isTestingUnion$1, List childPath$1, Schema schema$2) {
        return (JsonGenericRecordReader$Incompatible$)this.failAvroType(isTestingUnion$1, (List<String>)childPath$1, schema$2, schema$2.getType(), (Option<Exception>)e.map((Function1 & Serializable)x0$1 -> {
            Exception exception;
            Throwable throwable = x0$1;
            Exception exception2 = throwable instanceof Exception ? (exception = (Exception)throwable) : new Exception(throwable);
            return exception2;
        })).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Option wrongTypeError$default$1$1() {
        return None$.MODULE$;
    }

    private JsonGenericRecordReader$() {
    }
}

