/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.utils;

import com.sun.javafx.tk.Toolkit;
import io.conduktor.Constants;
import io.conduktor.analytics.tracking.AnalyticsObject;
import io.conduktor.analytics.tracking.AnalyticsTracker;
import io.conduktor.analytics.tracking.Links;
import io.conduktor.analytics.tracking.ObjectAction;
import io.conduktor.analytics.tracking.ObjectActionKt;
import io.conduktor.analytics.tracking.User;
import io.conduktor.app.Conduktor;
import io.conduktor.auth.user.ConduktorUser;
import io.conduktor.utils.BrowserOpener;
import io.conduktor.utils.OS;
import java.awt.Desktop;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Window;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J$\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\fJ\u0012\u0010\u0014\u001a\u00020\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\fJ6\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00182\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070 2\b\b\u0002\u0010!\u001a\u00020\tJ6\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070 2\b\b\u0002\u0010!\u001a\u00020\tJ\u001a\u0010$\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010%\u001a\u00020\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/conduktor/utils/SystemUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "clipboard", "", "copyToClipboardOnJavaFXThread", "", "value", "displayErrorOpening", "", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "copyToClipboard", "uri", "Ljava/net/URI;", "openChangelog", "openDocumentation", "path", "openGetStartedPlatform", "origin", "Lio/conduktor/analytics/tracking/AnalyticsObject;", "openKafkademy", "openMyAccount", "openPlans", "openTwitter", "openURI", "analytics", "analyticsProps", "", "hideUrl", "objectAction", "Lio/conduktor/analytics/tracking/ObjectAction;", "uriOpenerErrorHandler", "toCopy", "desktop"})
public final class SystemUtils {
    @NotNull
    public static final SystemUtils INSTANCE = new SystemUtils();
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);

    private SystemUtils() {
    }

    private final void uriOpenerErrorHandler(URI uri, boolean toCopy) {
        try {
            BrowserOpener.INSTANCE.openBrowserNative(uri.toString());
        }
        catch (Exception e) {
            this.displayErrorOpening(e, toCopy, uri);
        }
    }

    static /* synthetic */ void uriOpenerErrorHandler$default(SystemUtils systemUtils, URI uRI, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        systemUtils.uriOpenerErrorHandler(uRI, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void displayErrorOpening(Exception ex, boolean copyToClipboard, URI uri) {
        Optional buttonClicked$iv;
        void header$iv;
        void type$iv;
        void buttons$iv;
        void content$iv;
        logger.warn("Error opening browser", (Throwable)ex);
        boolean isCopied = copyToClipboard ? this.copyToClipboardOnJavaFXThread(uri.toString()) : false;
        Alert.AlertType alertType = Alert.AlertType.ERROR;
        String string = "";
        String string2 = "We couldn't open your browser. " + (String)(isCopied ? "The link is copied in your clipboard, please paste it into your browser." : "We failed copying it into your clipboard, check your logs: " + uri) + "\n\nDue to the way Java is distributed on Linux, we are unable to provide a consistent streamlined browser-based login experience. As such, we require you to do this manual step and are sorry for the inconvenience. ";
        ButtonType[] buttonTypeArray = new ButtonType[]{};
        Window owner$iv = null;
        String title$iv = null;
        Node graphic$iv = null;
        boolean $i$f$alert = false;
        String string3 = content$iv;
        if (string3 == null) {
            string3 = "";
        }
        void v1 = buttons$iv;
        Alert alert$iv = new Alert((Alert.AlertType)type$iv, string3, (ButtonType[])Arrays.copyOf(v1, ((void)v1).length));
        alert$iv.setHeaderText((String)header$iv);
        Optional optional = buttonClicked$iv = alert$iv.showAndWait();
        Intrinsics.checkExpressionValueIsNotNull((Object)optional, (String)"buttonClicked");
        if (optional.isPresent()) {
            Object t = buttonClicked$iv.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"buttonClicked.get()");
            ButtonType buttonType = (ButtonType)t;
            Alert $this$displayErrorOpening_u24lambda_u2d0 = alert$iv;
            boolean bl = false;
            $this$displayErrorOpening_u24lambda_u2d0.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        }
        if (!isCopied) {
            logger.info("Copy this url into your browser: " + uri);
        }
    }

    public final void openDocumentation(@Nullable String path) {
        SystemUtils.openURI$default(this, path == null ? Constants.INSTANCE.getCONDUKTOR_DOCUMENTATION_URI() : Constants.INSTANCE.getCONDUKTOR_DOCUMENTATION_URI().resolve(path), Links.Conduktor.Documentation.INSTANCE, null, false, 12, null);
    }

    public static /* synthetic */ void openDocumentation$default(SystemUtils systemUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        systemUtils.openDocumentation(string);
    }

    public final void openGetStartedPlatform(@NotNull AnalyticsObject origin) {
        Object object;
        String email;
        ConduktorUser loggedInUser;
        ConduktorUser conduktorUser = loggedInUser = (ConduktorUser)Conduktor.Companion.getAuth().getLoggedInUser().getValue();
        String string = email = conduktorUser != null ? conduktorUser.getEmail() : null;
        if (email != null) {
            Base64.Encoder encoder = Base64.getEncoder();
            String string2 = email;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = "?e=" + encoder.encodeToString(byArray);
        } else {
            object = "";
        }
        String encodedEmail = object;
        SystemUtils.openURI$default(this, new URL(Constants.INSTANCE.getCONDUKTOR_GET_STARTED_PLATFORM_URI().toString() + encodedEmail).toURI(), Links.Conduktor.GetStartedPlatform.INSTANCE, ObjectActionKt.origin(origin), false, 8, null);
    }

    public final void openKafkademy(@NotNull AnalyticsObject origin) {
        SystemUtils.openURI$default(this, Constants.INSTANCE.getCONDUKTOR_KAFKADEMY_URI(), Links.Conduktor.Kafkademy.INSTANCE, ObjectActionKt.origin(origin), false, 8, null);
    }

    public final void openChangelog() {
        SystemUtils.openURI$default(this, Constants.INSTANCE.getCONDUKTOR_CHANGELOG_URI(), Links.Conduktor.Changelog.INSTANCE, null, false, 12, null);
    }

    public final void openMyAccount() {
        SystemUtils.openURI$default(this, Constants.INSTANCE.getCONDUKTOR_ACCOUNT_MANAGEMENT_URI(), User.Account.INSTANCE, null, false, 12, null);
    }

    public final void openPlans() {
        SystemUtils.openURI$default(this, Constants.INSTANCE.getCONDUKTOR_PLANS_URI(), Links.Conduktor.Website.INSTANCE, null, false, 12, null);
    }

    public final void openTwitter() {
        SystemUtils.openURI$default(this, Constants.INSTANCE.getCONDUKTOR_TWITTER_URI(), Links.Twitter.INSTANCE, null, false, 12, null);
    }

    @Nullable
    public final String clipboard() {
        String string;
        try {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            string = clipboard.getString();
        }
        catch (Throwable e) {
            logger.warn("Can't access the clipboard: " + e.getMessage());
            string = null;
        }
        return string;
    }

    public final boolean copyToClipboardOnJavaFXThread(@NotNull String value2) {
        boolean bl;
        if (!Toolkit.getToolkit().isFxUserThread()) {
            logger.warn("Can't copy to clipboard. Please contact the technical support to ask them to fix their code.");
        }
        try {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content2 = new ClipboardContent();
            content2.putString(value2);
            logger.info("Copy: " + value2);
            bl = clipboard.setContent((Map)content2);
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final void openURI(@NotNull URI uri, @NotNull AnalyticsObject analytics, @NotNull Map<String, String> analyticsProps, boolean hideUrl) {
        this.openURI(uri, analytics.visited(), analyticsProps, hideUrl);
    }

    public static /* synthetic */ void openURI$default(SystemUtils systemUtils, URI uRI, AnalyticsObject analyticsObject, Map map2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        systemUtils.openURI(uRI, analyticsObject, (Map<String, String>)map2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void openURI(@NotNull URI uri, @NotNull ObjectAction objectAction, @NotNull Map<String, String> analyticsProps, boolean hideUrl) {
        block13: {
            void $this$openURI_u24lambda_u2d1;
            logger.info("Opening URL: " + uri);
            Map<String, String> map2 = analyticsProps;
            Object object = map2;
            ObjectAction objectAction2 = objectAction;
            AnalyticsTracker analyticsTracker = Conduktor.Companion.getTracker();
            boolean bl = false;
            MapsKt.plus((Map)MapsKt.toMutableMap((Map)$this$openURI_u24lambda_u2d1), hideUrl ? ObjectActionKt.url("hidden") : ObjectActionKt.url(uri));
            Unit unit = Unit.INSTANCE;
            analyticsTracker.action(objectAction2, map2);
            if (OS.INSTANCE.isLinux()) {
                logger.debug("Linux strategy: using native command first");
                try {
                    BrowserOpener.INSTANCE.openBrowserNative(uri.toString());
                }
                catch (Exception e) {
                    logger.warn("Native browser opening command failed", (Throwable)e);
                    if (Desktop.isDesktopSupported()) {
                        try {
                            logger.debug("Fallbacking on Java Desktop platform");
                            Desktop.getDesktop().browse(uri);
                        }
                        catch (Exception e2) {
                            logger.warn("Java Desktop platform error", (Throwable)e2);
                            this.displayErrorOpening(e2, true, uri);
                        }
                        break block13;
                    }
                    logger.debug("Can't fallback on Java Desktop platform: not supported");
                    this.displayErrorOpening(e, true, uri);
                }
            } else {
                Object $i$a$-runCatching-SystemUtils$openURI$32;
                try {
                    boolean $i$a$-runCatching-SystemUtils$openURI$32 = false;
                    $i$a$-runCatching-SystemUtils$openURI$32 = Result.constructor-impl((Object)Desktop.isDesktopSupported());
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-SystemUtils$openURI$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object = false;
                if (((Boolean)(Result.isFailure-impl((Object)$i$a$-runCatching-SystemUtils$openURI$32) ? object : $i$a$-runCatching-SystemUtils$openURI$32)).booleanValue()) {
                    try {
                        logger.debug("Java Desktop platform supported");
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception e) {
                        logger.warn("Java Desktop platform error, fallbacking on custom OS strategy", (Throwable)e);
                        SystemUtils.uriOpenerErrorHandler$default(this, uri, false, 2, null);
                    }
                } else {
                    logger.debug("Java Desktop platform not supported");
                    SystemUtils.uriOpenerErrorHandler$default(this, uri, false, 2, null);
                }
            }
        }
    }

    public static /* synthetic */ void openURI$default(SystemUtils systemUtils, URI uRI, ObjectAction objectAction, Map map2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        systemUtils.openURI(uRI, objectAction, (Map<String, String>)map2, bl);
    }
}

