/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.schemaregistry;

import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.NonFatalKt;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\bf\u0018\u0000 \u000f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004\u000e\u000f\u0010\u0011J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\r\u001a\u00020\u0005H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/conduktor/schemaregistry/SchemaFormat;", "T", "Lio/confluent/kafka/schemaregistry/ParsedSchema;", "", "defaultSchema", "", "getDefaultSchema", "()Ljava/lang/String;", "label", "getLabel", "parse", "Larrow/core/Either;", "", "s", "Avro", "Companion", "Json", "Protobuf", "desktop"})
public interface SchemaFormat<T extends ParsedSchema> {
    @NotNull
    public static final Companion Companion = io.conduktor.schemaregistry.SchemaFormat$Companion.$$INSTANCE;

    @NotNull
    public Either<Throwable, T> parse(@NotNull String var1);

    @NotNull
    public String getLabel();

    @NotNull
    public String getDefaultSchema();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lio/conduktor/schemaregistry/SchemaFormat$Companion;", "", "()V", "fromUnsafe", "Lio/conduktor/schemaregistry/SchemaFormat;", "type", "", "isDefault", "", "schema", "desktop"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final SchemaFormat<?> fromUnsafe(@NotNull String type2) {
            String string = type2;
            return Intrinsics.areEqual((Object)string, (Object)"PROTOBUF") ? (SchemaFormat)Protobuf.INSTANCE : (Intrinsics.areEqual((Object)string, (Object)"JSON") ? (SchemaFormat)Json.INSTANCE : (SchemaFormat)Avro.INSTANCE);
        }

        public final boolean isDefault(@NotNull String schema2) {
            return Intrinsics.areEqual((Object)schema2, (Object)Avro.INSTANCE.getDefaultSchema()) || Intrinsics.areEqual((Object)schema2, (Object)Json.INSTANCE.getDefaultSchema()) || Intrinsics.areEqual((Object)schema2, (Object)Protobuf.INSTANCE.getDefaultSchema());
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/conduktor/schemaregistry/SchemaFormat$Avro;", "Lio/conduktor/schemaregistry/SchemaFormat;", "Lio/confluent/kafka/schemaregistry/avro/AvroSchema;", "()V", "defaultSchema", "", "getDefaultSchema", "()Ljava/lang/String;", "label", "getLabel", "parse", "Larrow/core/Either;", "", "s", "desktop"})
    public static final class Avro
    implements SchemaFormat<AvroSchema> {
        @NotNull
        public static final Avro INSTANCE = new Avro();
        @NotNull
        private static final String label = "Avro";
        @NotNull
        private static final String defaultSchema = "{\n  \"type\": \"record\",\n  \"name\": \"MyRecord\",\n  \"namespace\": \"com.mycompany\",\n  \"fields\" : [\n    {\"name\": \"id\", \"type\": \"long\"}\n  ]\n}";

        private Avro() {
        }

        @Override
        @NotNull
        public String getLabel() {
            return label;
        }

        @Override
        @NotNull
        public Either<Throwable, AvroSchema> parse(@NotNull String s2) {
            Either either2;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                either2 = EitherKt.right((Object)new AvroSchema(s2));
            }
            catch (Throwable t$iv) {
                either2 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either2;
        }

        @Override
        @NotNull
        public String getDefaultSchema() {
            return defaultSchema;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/conduktor/schemaregistry/SchemaFormat$Protobuf;", "Lio/conduktor/schemaregistry/SchemaFormat;", "Lio/confluent/kafka/schemaregistry/protobuf/ProtobufSchema;", "()V", "defaultSchema", "", "getDefaultSchema", "()Ljava/lang/String;", "label", "getLabel", "parse", "Larrow/core/Either;", "", "s", "desktop"})
    public static final class Protobuf
    implements SchemaFormat<ProtobufSchema> {
        @NotNull
        public static final Protobuf INSTANCE = new Protobuf();
        @NotNull
        private static final String label = "Protobuf";
        @NotNull
        private static final String defaultSchema = "syntax = \"proto3\";\n\nmessage MyRecord {\n  int32 id = 1;\n  string createdAt = 2;\n  string name = 3;\n}";

        private Protobuf() {
        }

        @Override
        @NotNull
        public String getLabel() {
            return label;
        }

        @Override
        @NotNull
        public Either<Throwable, ProtobufSchema> parse(@NotNull String s2) {
            Either either2;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                either2 = EitherKt.right((Object)new ProtobufSchema(s2));
            }
            catch (Throwable t$iv) {
                either2 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either2;
        }

        @Override
        @NotNull
        public String getDefaultSchema() {
            return defaultSchema;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/conduktor/schemaregistry/SchemaFormat$Json;", "Lio/conduktor/schemaregistry/SchemaFormat;", "Lio/confluent/kafka/schemaregistry/json/JsonSchema;", "()V", "defaultSchema", "", "getDefaultSchema", "()Ljava/lang/String;", "label", "getLabel", "parse", "Larrow/core/Either;", "", "s", "desktop"})
    public static final class Json
    implements SchemaFormat<JsonSchema> {
        @NotNull
        public static final Json INSTANCE = new Json();
        @NotNull
        private static final String label = "JSON";
        @NotNull
        private static final String defaultSchema = "{\n  \"$id\": \"https://mycompany.com/myrecord\",\n  \"$schema\": \"https://json-schema.org/draft/2019-09/schema\",\n  \"type\": \"object\",\n  \"title\": \"MyRecord\",\n  \"description\": \"Json schema for MyRecord\",\n  \"properties\": {\n    \"id\": {\n      \"type\": \"string\"\n    },\n    \"name\": {\n      \"type\": [ \"string\", \"null\" ]\n    }\n  },\n  \"required\": [ \"id\" ],\n  \"additionalProperties\": false\n}";

        private Json() {
        }

        @Override
        @NotNull
        public String getLabel() {
            return label;
        }

        @Override
        @NotNull
        public Either<Throwable, JsonSchema> parse(@NotNull String s2) {
            Either either2;
            Either.Companion this_$iv = Either.Companion;
            boolean $i$f$tryCatch = false;
            try {
                boolean bl = false;
                either2 = EitherKt.right((Object)new JsonSchema(s2));
            }
            catch (Throwable t$iv) {
                either2 = EitherKt.left((Object)NonFatalKt.nonFatalOrThrow((Throwable)t$iv));
            }
            return either2;
        }

        @Override
        @NotNull
        public String getDefaultSchema() {
            return defaultSchema;
        }
    }
}

