/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.conduktor.exporter.ObjectJsonifier;
import io.conduktor.models.PartitionSize;
import io.conduktor.models.TopicPartitionInfo;
import io.conduktor.models.settings.ConduktorConfig;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/conduktor/exporter/TopicPartitionInfoJsonifier;", "Lio/conduktor/exporter/ObjectJsonifier;", "Lio/conduktor/models/TopicPartitionInfo;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "(Lio/conduktor/models/settings/ConduktorConfig;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "om", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "toJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "a", "desktop"})
final class TopicPartitionInfoJsonifier
implements ObjectJsonifier<TopicPartitionInfo> {
    @NotNull
    private final ConduktorConfig config;
    @NotNull
    private final ObjectMapper om;

    public TopicPartitionInfoJsonifier(@NotNull ConduktorConfig config) {
        this.config = config;
        this.om = new ObjectMapper();
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public JsonNode toJson(@NotNull TopicPartitionInfo a) {
        int it;
        ArrayNode arrayNode;
        ObjectNode node = this.om.createObjectNode();
        node.put("partition", a.getPartition());
        node.put("leader", a.getLeaderId());
        node.put("offset_beginning", a.getBeginningOffset().getValue());
        node.put("offset_ending", a.getEndOffset().getValue());
        PartitionSize partitionSize = a.getSize();
        if (this.config.getShowTopicSizeColumn() && partitionSize instanceof PartitionSize.Default) {
            node.put("size", ((PartitionSize.Default)partitionSize).getValue());
        }
        ArrayNode arr = arrayNode = node.putArray("isr");
        boolean bl = false;
        Iterable $this$forEach$iv = a.getIsrText();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            arr.add(it);
        }
        arr = arrayNode = node.putArray("replicas");
        boolean bl3 = false;
        List<Integer> list2 = a.getReplicasText();
        if (list2 != null) {
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = ((Number)element$iv).intValue();
                boolean bl4 = false;
                arr.add(it);
            }
        }
        if (this.config.getShowTopicLastWriteColumn()) {
            node.put("last_write", a.getLastWrite().getMillisUTC());
        }
        return (JsonNode)node;
    }
}

