/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.exporter;

import io.conduktor.exporter.ObjectStringifier;
import io.conduktor.models.Node;
import io.conduktor.models.settings.ConduktorConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00130\b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lio/conduktor/exporter/NodeToCsvStringifier;", "Lio/conduktor/exporter/ObjectStringifier;", "Lio/conduktor/models/Node;", "config", "Lio/conduktor/models/settings/ConduktorConfig;", "withMetrics", "", "nodes", "", "(Lio/conduktor/models/settings/ConduktorConfig;ZLjava/util/List;)V", "getConfig", "()Lio/conduktor/models/settings/ConduktorConfig;", "getNodes", "()Ljava/util/List;", "getWithMetrics", "()Z", "columns", "", "toStrings", "", "a", "desktop"})
final class NodeToCsvStringifier
implements ObjectStringifier<Node> {
    @NotNull
    private final ConduktorConfig config;
    private final boolean withMetrics;
    @NotNull
    private final List<Node> nodes;

    public NodeToCsvStringifier(@NotNull ConduktorConfig config, boolean withMetrics, @NotNull List<Node> nodes) {
        this.config = config;
        this.withMetrics = withMetrics;
        this.nodes = nodes;
    }

    @NotNull
    public final ConduktorConfig getConfig() {
        return this.config;
    }

    public final boolean getWithMetrics() {
        return this.withMetrics;
    }

    @NotNull
    public final List<Node> getNodes() {
        return this.nodes;
    }

    @Override
    @NotNull
    public List<String> columns() {
        List l = new ArrayList();
        if (this.config.getShowBrokerIdColumn()) {
            l.add("ID");
        }
        if (this.config.getShowBrokerRackColumn()) {
            l.add("Rack");
        }
        l.add("Listener");
        l.add("Partitions");
        l.add("Partitions Skew");
        l.add("Leaders");
        l.add("Leaders Skew");
        if (this.withMetrics) {
            Object[] objectArray = new String[]{"Bytes in", "Bytes out"};
            CollectionsKt.addAll((Collection)l, (Object[])objectArray);
        }
        if (this.config.getShowBrokerSizeColumn()) {
            l.add("Size");
        }
        return l;
    }

    @Override
    @NotNull
    public List<String[]> toStrings(@NotNull Node a) {
        List l = new ArrayList();
        if (this.config.getShowBrokerIdColumn()) {
            l.add(String.valueOf(a.getId()));
        }
        if (this.config.getShowBrokerRackColumn()) {
            l.add(a.getRack());
        }
        l.add(a.getHostAndPort());
        Object object = a.getPartitionCount();
        if (object == null || (object = ((Integer)object).toString()) == null) {
            object = "";
        }
        l.add(object);
        l.add(String.valueOf(a.skew(this.nodes)));
        l.add(String.valueOf(a.getPartitionLeaderCount()));
        l.add(String.valueOf(a.leaderSkew(this.nodes)));
        if (this.withMetrics) {
            Object[] objectArray = new String[]{String.valueOf(a.getMetrics().getBytesInProperty().getValue()), String.valueOf(a.getMetrics().getBytesOutProperty().getValue())};
            CollectionsKt.addAll((Collection)l, (Object[])objectArray);
        }
        if (this.config.getShowBrokerSizeColumn()) {
            Object object2 = a.getLogDirSize();
            if (object2 == null || (object2 = ((Long)object2).toString()) == null) {
                object2 = "";
            }
            l.add(object2);
        }
        Collection $this$toTypedArray$iv = l;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return CollectionsKt.listOf((Object)stringArray);
    }
}

